<?php

use SCCSP\SendCloud\Connected\Shipping\Utility\SCCSP_View;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Contains data regarding shipping configuration
 *
 * @var array $data
 */
?>

<div class="sc-accordion">
    <div class="sc-accordion-item">
        <div class="sc-accordion-header">
            <h2>
                <span class="sc-check-icon <?php if($data['has_shipping_zones']) {echo esc_attr('active');}?>">
                    <img src="<?php echo plugins_url( 'resources/images/check-icon.svg', SC_PLUGIN_FILE ); ?>" alt="Completed">
                </span>
                <?php
                /* translators: Heading for the setup step where a merchant adds shipping zones and rates */
                esc_html_e( 'Add shipping zones and rates', 'sendcloud-connected-shipping' );
                ?>
            </h2>
            <span class="sc-arrow"></span>
            <p>
                <?php
                /* translators: Description text explaining why to configure shipping zones and rates */
                esc_html_e(
                        'To offer your customers different shipping methods and rates based on their location.',
                        'sendcloud-connected-shipping'
                );
                ?>
            </p>

        </div>
        <div class="sc-accordion-content">
            <ol class="sc-accordion-list">
                <li class="sc-accordion-list-step">
                    <?php
                    printf(
                    /* translators: %1$s = HTML "WooCommerce > Settings >", %2$s = HTML link to Shipping, %3$s = bold "Add shipping zone" */
                            esc_html__(
                                    'From the sidebar menu in your WooCommerce dashboard, go to %1$s %2$s and then click %3$s.',
                                    'sendcloud-connected-shipping'
                            ),
                            '<em>' . esc_html__('WooCommerce > Settings >', 'sendcloud-connected-shipping') . '</em>',
                            '<a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=shipping' ) ) . '" target="_blank">'
                            . esc_html__( 'Shipping', 'sendcloud-connected-shipping' )
                            . '</a>',
                            '<strong>' . esc_html__('Add shipping zone', 'sendcloud-connected-shipping') . '</strong>'
                    );
                    ?>
                    <div class="sc-step-image">
                        <img class="sc-screenshot-thumb"
                             src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/WCSPEN1.png' ); ?>"
                             alt="<?php esc_attr_e( 'Screenshot of WooCommerce Shipping Settings', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                    <hr/>
                </li>


                <li class="sc-accordion-list-step">
                    <?php
                    /* translators: Instruction to give shipping zone a name, select regions, and add shipping methods */
                    esc_html_e(
                            'Give your shipping zone a name, select the regions you want to include, and add your shipping methods.',
                            'sendcloud-connected-shipping'
                    );
                    ?>
                    <hr/>
                </li>

                <li class="sc-accordion-list-step">
                    <?php
                    /* translators: Instruction on pricing methods */
                    esc_html_e(
                            "When you add a shipping method, you'll have the option to decide from the following pricing methods",
                            'sendcloud-connected-shipping'
                    );
                    ?>:
                    <ul>
                        <li>
                            <strong><?php esc_html_e('Free shipping', 'sendcloud-connected-shipping'); ?></strong>:
                            <?php esc_html_e('Grant a free delivery to your customers', 'sendcloud-connected-shipping'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Fixed rate', 'sendcloud-connected-shipping'); ?></strong>:
                            <?php esc_html_e('Set a unique delivery fee', 'sendcloud-connected-shipping'); ?>
                        </li>
                        <li>
                            <strong><?php esc_html_e('Local pickup', 'sendcloud-connected-shipping'); ?></strong>:
                            <?php esc_html_e('Customers will pick up the order themselves', 'sendcloud-connected-shipping'); ?>
                        </li>
                    </ul>
                    <div class="sc-step-image">
                        <img class="sc-screenshot-thumb"
                             src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/setup_checklist/create_shipping_method.png' ); ?>"
                             alt="<?php esc_attr_e( 'Screenshot of WooCommerce Shipping Methods', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                    <hr/>
                </li>
                <li class="sc-accordion-list-step">
                    <?php
                    /* translators: Instruction after choosing a pricing method; %s is "set up" in bold */
                    printf(
                        esc_html__(
                                'Once the pricing method is chosen, you will be able to %s the shipping method as desired:',
                                'sendcloud-connected-shipping'
                        ),
                        '<strong>' . esc_html__('set up', 'sendcloud-connected-shipping') . '</strong>'
                    );
                    ?>
                    <div class="sc-step-image">
                         <img class="sc-screenshot-thumb"
                              src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/setup_checklist/setup_shippingmethod.png' ); ?>"
                              alt="<?php esc_attr_e( 'Screenshot of WooCommerce Shipping Settings', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                    <hr/>
                </li>
                <li class="sc-accordion-list-step">
                    <?php
                    printf(
                    /* translators: Instruction linking to WooCommerce documentation about shipping classes */
                            esc_html__('For more information about adding rates and shipping classes in WooCommerce, see the following article: %s', 'sendcloud-connected-shipping'),
                            '<a href="https://woocommerce.com/document/product-shipping-classes/" target="_blank">'
                            . esc_html__('Product Shipping Classes - WooCommerce', 'sendcloud-connected-shipping')
                            . '</a>'
                    );
                    ?>
                </li>
            </ol>
        </div>
    </div>

    <div class="sc-accordion-nested">
        <?php
        if ($data['migration_required']) {
            echo SCCSP_View::file( '/wc-settings/dashboard/service-point/sendcloud-migrate.php' )->render($data);
        } else {
            echo SCCSP_View::file( '/wc-settings/dashboard/service-point/sendcloud-setup.php' )->render($data);
        }
        ?>
    </div>

    <div class="sc-accordion-item">
        <div class="sc-accordion-header">
            <h2>
                <span class="sc-check-icon <?php if($data['has_product_data']) {echo esc_attr('active');}?>">
                    <img src="<?php echo plugins_url( 'resources/images/check-icon.svg', SC_PLUGIN_FILE ); ?>" alt="Completed">
                </span>
                <span class="sc-arrow"></span>
                <?php
                /* translators: Instruction heading for configuring product data */
                esc_html_e(
                        'Configure product data',
                        'sendcloud-connected-shipping'
                );
                ?>

            </h2>
            <p>
                <?php
                /* translators: Description text explaining why to import all necessary item details into Sendcloud */
                esc_html_e(
                        'To ensure all necessary item details are imported into Sendcloud, helping you stay compliant with carrier requirements and customs documentation.',
                        'sendcloud-connected-shipping'
                );
                ?>
            </p>
        </div>
        <div class="sc-accordion-content">
            <div class="sc-product-data-title sc-title-top">
                <?php
                /* translators: Section heading for setting EAN (European Article Number) codes */
                esc_html_e(
                        'Setting EAN Codes',
                        'sendcloud-connected-shipping'
                );
                ?>
            </div>
            <span>
                <?php
                printf(
                /* translators: %1$s and %2$s wrap 'Products' in italics;
                   %3$s and %4$s wrap 'All Products' in italics;
                   %5$s and %6$s wrap 'Product Data > Inventory' in italics */
                        esc_html__(
                                'In your WooCommerce dashboard, go to %1$sProducts%2$s > %3$sAll Products%4$s and select a product. Under %5$sProduct Data > Inventory%6$s, enter the EAN in:',
                                'sendcloud-connected-shipping'
                        ),
                        '<i>', '</i>',
                        '<i>', '</i>',
                        '<i>', '</i>'
                );
                ?>
            </span>


            <ul>
                <li>
                    <?php
                    printf(
                    /* translators: %1$s and %2$s wrap 'EAN by Sendcloud' in bold;
                       %3$s and %4$s wrap '9.2.' in bold */
                            esc_html__(
                                    '%1$sEAN by Sendcloud%2$s field for WooCommerce versions below %3$s9.2%4$s',
                                    'sendcloud-connected-shipping'
                            ),
                            '<strong>', '</strong>',
                            '<strong>', '</strong>'
                    );
                    ?>:
                    <div class="sc-step-image">
                        <img class="sc-screenshot-thumb"
                             src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/englishwoocommm1229983834.png' ); ?>"
                             alt="<?php esc_attr_e( 'Screenshot of EAN Attribute', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                </li>
                <li>
                    <?php
                    printf(
                    /* translators: %1$s and %2$s wrap 'EAN' in bold;
                       %3$s and %4$s wrap '9.2 and higher' in bold */
                            esc_html__(
                                    'WooCommerce’s native %1$sEAN%2$s field for versions %3$s9.2 and higher%4$s',
                                    'sendcloud-connected-shipping'
                            ),
                            '<strong>', '</strong>',
                            '<strong>', '</strong>'
                    );
                    ?>:
                    <div class="sc-step-image">
                        <img class="sc-screenshot-thumb"
                             src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/ENV2inventory22.png' ); ?>"
                             alt="<?php esc_attr_e( 'Screenshot of EAN Attribute', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                    <hr/>
                </li>
            </ul>

            <div class="sc-product-data-title">
                <?php
                /* translators: Section heading for configuring HS Codes and Country of Origin (used in international shipping) */
                esc_html_e(
                        'Setting HS Codes and Country of Origin (for international shipping)',
                        'sendcloud-connected-shipping'
                );
                ?>
            </div>

            <ul>
                <li>
                     <span>
                        <?php
                        printf(
                        /* translators: %1$s and %2$s wrap the word 'Shipping' (tab name in WooCommerce Product Data) in bold */
                                esc_html__(
                                        'Enter the HS Code and Country of Origin under the %1$sShipping%2$s tab in Product Data.',
                                        'sendcloud-connected-shipping'
                                ),
                                '<strong>', '</strong>'
                        );
                        ?>
                    </span>
                    <div class="sc-step-image">
                        <img class="sc-screenshot-thumb"
                             src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/WCSPEN5.png' ); ?>"
                             alt="<?php esc_attr_e( 'Screenshot of HS Code and Country Attribute', 'sendcloud-connected-shipping' ); ?>">
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>