<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Contains data regarding shipping configuration
 *
 * @var array $data
 */
?>
<div class="nested-connector-line">
    <img src="<?php echo plugins_url( 'resources/images/connector-line.svg', SC_PLUGIN_FILE ); ?>" alt="Connector Line Icon">
</div>
<div class="sc-accordion-item nested">
    <div class="sc-accordion-header">
        <h2>
            <span class="sc-check-icon <?php if($data['has_service_point']) {echo esc_attr('active');}?>">
                <img src="<?php echo plugins_url( 'resources/images/check-icon.svg', SC_PLUGIN_FILE ); ?>" alt="Completed">
            </span>
            <span class="sc-arrow"></span>
            <?php
            /* translators: Heading for the setup step where a merchant configures service point delivery */
            esc_html_e( 'Configure service point delivery', 'sendcloud-connected-shipping' );
            ?>
        </h2>
        <p>
            <?php
            /* translators: Description text explaining why to configure service point delivery */
            esc_html_e(
                'To offer your customers the option to pick up their parcels from a local service point.',
                'sendcloud-connected-shipping'
            );
            ?>
        </p>
        <div class="sc-note-with-icon <?php if($data['is_service_point_enable']) {echo esc_attr('sc-hidden');}?>">
            <span class="sc-note-icon">
                <img src="<?php echo plugins_url( 'resources/images/note-icon.svg', SC_PLUGIN_FILE ); ?>" alt="Note Icon">
            </span>
            <span>
                <?php
                printf(
                /* translators: %s is the word "activate" as a clickable link */
                    esc_html__('Note: To enable this type of delivery, you must %s in Sendcloud.', 'sendcloud-connected-shipping'),
                '<a href="' . esc_url(
                        sprintf(
                                'https://app.sendcloud.com/v2/settings/integrations/woocommerce_v2/%d',
                                $data['integration_id']
                        )
                    ) . '" target="_blank">'
                    . esc_html__('activate', 'sendcloud-connected-shipping')
                    . '</a>'
                );
                ?>
            </span>
        </div>
    </div>
    <div class="sc-accordion-content">
        <div class="sc-note-highlighted">
            <span>
                <?php
                printf(
                /* translators:
                 * %1$s is "Note:" in bold HTML
                 * %2$s is "Before you can do this, make sure you’ve activated Service Point delivery in Sendcloud and selected your carriers"
                 * %3$s is "You can find the steps in the Activate Service Point Delivery section."
                 */
                        esc_html__(
                                '%1$s %2$s %3$s',
                                'sendcloud-connected-shipping'
                        ),
                        '<strong>' . esc_html__( 'Note:', 'sendcloud-connected-shipping' ) . '</strong>',
                        esc_html__(
                                'Before you can do this, make sure you’ve activated Service Point delivery in Sendcloud and selected your carriers.',
                                'sendcloud-connected-shipping'
                        ),
                        esc_html__(
                                'You can find the steps in the Activate Service Point Delivery section below.',
                                'sendcloud-connected-shipping'
                        )
                );
                ?>
            </span>
        </div>

        <ol class="sc-accordion-list">
            <li class="sc-accordion-list-step">
                <?php
                printf(
                /* translators: %1$s = WooCommerce > Settings > (emphasized), %2$s = Shipping link, %3$s = Add zone in bold */
                    esc_html__('In your WooCommerce dashboard, navigate to %1$s %2$s and then %3$s.', 'sendcloud-connected-shipping'),
                    '<em>' . esc_html__('WooCommerce > Settings >', 'sendcloud-connected-shipping') . '</em>',
                    '<a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=shipping' ) ) . '" target="_blank">'
                    . esc_html__( 'Shipping', 'sendcloud-connected-shipping' )
                    . '</a>',
                    '<strong>' . esc_html__('Add zone', 'sendcloud-connected-shipping') . '</strong>'
                );
                ?>
                <div class="sc-step-image nested">
                      <img class="sc-screenshot-thumb"
                           src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/WCSPEN1.png' ); ?>"
                           alt="<?php esc_attr_e( 'Screenshot of WooCommerce Shipping Settings', 'sendcloud-connected-shipping' ); ?>">
                </div>
                <hr/>
            </li>
            <li class="sc-accordion-list-step">
                <?php
                printf(
                /* translators: %s is the "Add shipping method" text in bold */
                    esc_html__('Click %s.', 'sendcloud-connected-shipping'),
                    '<strong>' . esc_html__('Add shipping method', 'sendcloud-connected-shipping') . '</strong>'
                );
                ?>

                <div class="sc-step-image nested">
                    <img class="sc-screenshot-thumb"
                         src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/WCSPEN2.png' ); ?>"
                         alt="<?php esc_attr_e( 'Screenshot of WooCommerce Shipping Zone', 'sendcloud-connected-shipping' ); ?>">
                </div>
                <hr/>
            </li>
            <li class="sc-accordion-list-step">
                <?php
                printf(
                /* translators: %1$s = "Service Point Delivery" in bold, %2$s = "[Sendcloud]" in bold, %3$s = "Continue" in bold */
                    esc_html__(
                        'Select the %1$s method that explicitly includes %2$s in its description. Then, click %3$s.',
                        'sendcloud-connected-shipping'
                    ),
                    '<strong>' . esc_html__('Service Point Delivery', 'sendcloud-connected-shipping') . '</strong>',
                    '<strong>' . esc_html__('[Sendcloud]', 'sendcloud-connected-shipping') . '</strong>',
                    '<strong>' . esc_html__('Continue', 'sendcloud-connected-shipping') . '</strong>'
                );
                ?>
                <div class="sc-step-image nested">
                    <img class="sc-screenshot-thumb"
                         src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/setup_checklist/servicepoint_delivery[Sendcloud].png' ); ?>"
                         alt="<?php esc_attr_e( 'Screenshot of Service Point Delivery Method', 'sendcloud-connected-shipping' ); ?>">                </div>
                <hr/>
            </li>
            <li class="sc-accordion-list-step">
                <?php
                printf(
                /* translators: %1$s = "method name" in bold, %2$s = example method in italic */
                    esc_html__(
                        'Enter a %1$s for your shipping method to be displayed on your checkout page (such as %2$s) and add a shipping cost.',
                        'sendcloud-connected-shipping'
                    ),
                    '<strong>' . esc_html__('method name', 'sendcloud-connected-shipping') . '</strong>',
                    '<i>' . esc_html__('Delivery to service point', 'sendcloud-connected-shipping') . '</i>'
                );
                ?>

                <hr/>
            </li>
            <li class="sc-accordion-list-step">
                <?php
                printf(
                /* translators: Shown in the settings description for the Carrier Selection field */
                    esc_html__(
                        'In the field %1$s, there is a list of Sendcloud enabled carriers which you can
                         select one or more carriers from (e.g., UPS, DPD, DHL). If a selection is not made,
                          then all Sendcloud enabled carriers will be displayed.',
                        'sendcloud-connected-shipping'
                    ),
            '<strong>' . esc_html__('Carrier Selection', 'sendcloud-connected-shipping') . '</strong>'
                );
                ?>
                <div class="sc-step-image nested">
                    <img class="sc-screenshot-thumb"
                         src="<?php echo esc_url( 'https://www.sendcloud.com/wp-content/help-center-images/WooCommerce/setup_checklist/setupservicepointdelivery.png' ); ?>"
                         alt="<?php esc_attr_e( 'Screenshot of Service Point Delivery Method', 'sendcloud-connected-shipping' ); ?>">
                </div>
            </li>
        </ol>
    </div>
</div>
