<?php

namespace SCCSP\SendCloud\Connected\Shipping\Utility;

use WC_Shipping_Zones;
use WC_Shipping_Zone;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class SCCSP_Shipping_Zone {

    /**
     * Retrieves all WooCommerce shipping zones.
     *
     * @return array
     */
    public function get_shipping_zones(): array {
        return WC_Shipping_Zones::get_zones();
    }

    /**
     * Checks if a specific shipping method exists in any zone.
     *
     * @param string $method_id
     * @return bool
     */
    public function zone_has_method(string $method_id): bool {
        try {
            SCCSP_Logger::info('Checking if any shipping zone has method: ' . $method_id);
            $zones = WC_Shipping_Zones::get_zones();
            SCCSP_Logger::info('Loaded zones: ' . count($zones));

            foreach ($zones as $zone) {
                $zone_id = $zone['zone_id'];
                SCCSP_Logger::info("Checking zone ID: {$zone_id}");

                $zone_obj = new WC_Shipping_Zone($zone_id);
                $shipping_methods = $zone_obj->get_shipping_methods();

                foreach ($shipping_methods as $method) {
                    SCCSP_Logger::info("Found shipping method: {$method->id}");
                    if ($method->id === $method_id) {
                        SCCSP_Logger::info("Match found for method ID: {$method_id} in zone {$zone_id}");
                        return true;
                    }
                }
            }

            // Check "Rest of the World" zone (ID 0)
            $rest_zone = WC_Shipping_Zones::get_zone_by('zone_id', 0);
            if ($rest_zone) {
                SCCSP_Logger::info('Checking Rest of the World zone');
                $shipping_methods = $rest_zone->get_shipping_methods();

                foreach ($shipping_methods as $method) {
                    if ($method->id === $method_id) {
                        SCCSP_Logger::info("Match found for method ID: {$method_id} in Rest of the World zone");
                        return true;
                    }
                }
            }

            SCCSP_Logger::info("No match found for method ID: {$method_id}");
            return false;
        } catch (\Exception $e) {
            SCCSP_Logger::error('zone_has_method() failed: ' . $e->getMessage());
            return false;
        }
    }
}