<?php

namespace SCCSP\SendCloud\Connected\Shipping\Utility;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class SCCSP_Product {

    /**
     * @var string[] Meta keys to check for products
     */
    private $meta_keys = [
        'sc_hs_code',
        'sc_country_of_origin',
        'sc_ean_code',
        '_global_unique_id',
    ];

    /**
     * Check if there is at least one product with meta keys.
     *
     * @return bool
     */
    public function has_products_with_meta(): bool {
        try {
            if (empty($this->meta_keys)) {
                SCCSP_Logger::info('No meta keys defined, skipping product meta check');
                return false;
            }

            SCCSP_Logger::info('Checking if products exist with any of meta keys', ['keys' => $this->meta_keys]);

            foreach ($this->meta_keys as $key) {
                $query = new \WP_Query([
                    'post_type'      => 'product',
                    'posts_per_page' => 1,
                    'fields'         => 'ids',
                    'post_status'    => 'publish',
                    'meta_query'     => [
                        [
                            'key'     => $key,
                            'value'   => '',    // compare against empty string
                            'compare' => '!='   // value must not be empty
                        ]
                    ]
                ]);

                if (!empty($query->posts)) {
                    SCCSP_Logger::info("Found product with meta key '{$key}'");
                    return true;
                }
            }

            SCCSP_Logger::info('No products found with any of the specified meta keys');
            return false;
        } catch (\Exception $e) {
            SCCSP_Logger::error('has_products_with_meta() failed: ' . $e->getMessage());
            return false;
        }
    }
}