<?php
class Sccp_Settings_Actions {
    private $plugin_name;

    public function __construct($plugin_name) {
        $this->plugin_name = $plugin_name;
        // $this->check_setting_mailchimp();
    }

    public function store_data($data){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ays_sccp_settings";
        if( isset($data["settings_action"]) && wp_verify_nonce( $data["settings_action"], 'settings_action' ) ){
            $success = 0;            
            $mailchimp_username = isset($data['ays_mailchimp_username']) ? esc_attr(stripslashes($data['ays_mailchimp_username'])) : '';
            $mailchimp_api_key = isset($data['ays_mailchimp_api_key']) ? esc_attr(stripslashes($data['ays_mailchimp_api_key'])) : '';
            $mailchimp = array(
                'username' => $mailchimp_username,
                'apiKey' => $mailchimp_api_key
            );
            // WP Editor height
            $sccp_wp_editor_height = (isset($data['ays_sccp_wp_editor_height']) && $data['ays_sccp_wp_editor_height'] != '') ? absint( sanitize_text_field($data['ays_sccp_wp_editor_height']) ) : 150 ;

            $sccp_disable_user_ip = (isset( $data['ays_sccp_disable_user_ip'] ) && sanitize_text_field( $data['ays_sccp_disable_user_ip'] ) == 'on') ? 'on' : 'off';

            $options = array(
                "sccp_wp_editor_height" => $sccp_wp_editor_height,
                "sccp_disable_user_ip" => $sccp_disable_user_ip,
            );

            // Subscribe box width
            $ays_sccp_sub_width = (isset($data['ays_sccp_sub_width']) && $data['ays_sccp_sub_width'] != '') ? absint( sanitize_text_field($data['ays_sccp_sub_width']) ) : '';

            // Subscribe box width mobile
            $ays_sccp_sub_width_mobile = (isset($data['ays_sccp_sub_width_mobile']) && $data['ays_sccp_sub_width_mobile'] != '') ? absint( sanitize_text_field($data['ays_sccp_sub_width_mobile']) ) : '';

            // Subscribe input width
            $ays_sccp_sub_input_width = (isset($data['ays_sccp_sub_input_width']) && $data['ays_sccp_sub_input_width'] != '') ? absint( sanitize_text_field($data['ays_sccp_sub_input_width']) ) : '';

            // Enable Subscribe Container input width Mobile
            $enable_ays_sccp_sub_input_width_mobile = isset( $data['enable_ays_sccp_sub_input_width_mobile'] ) && $data['enable_ays_sccp_sub_input_width_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Container input width Mobile
            $ays_sccp_sub_input_width_mobile = isset( $data['ays_sccp_sub_input_width_mobile'] ) && $data['ays_sccp_sub_input_width_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_input_width_mobile'] ) : '';

            // Subscribe box title size
            $ays_sccp_sub_title_size = (isset($data['ays_sccp_sub_title_size']) && $data['ays_sccp_sub_title_size'] != '') ? absint( sanitize_text_field($data['ays_sccp_sub_title_size']) ) : 18;

            // Enable Subscribe box title size Mobile
            $enable_ays_sccp_sub_title_size_mobile = isset( $data['enable_ays_sccp_sub_title_size_mobile'] ) && $data['enable_ays_sccp_sub_title_size_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box title size Mobile
            $ays_sccp_sub_title_size_mobile = isset( $data['ays_sccp_sub_title_size_mobile'] ) && $data['ays_sccp_sub_title_size_mobile'] != '' ? absint( sanitize_text_field( $data['ays_sccp_sub_title_size_mobile'] ) ) : 18;

            // Subscribe box description size
            $ays_sccp_sub_desc_size = (isset($data['ays_sccp_sub_desc_size']) && $data['ays_sccp_sub_desc_size'] != '') ? absint( sanitize_text_field($data['ays_sccp_sub_desc_size']) ) : 18;

            // Enable Subscribe box description size Mobile
            $enable_ays_sccp_sub_desc_size_mobile = isset( $data['enable_ays_sccp_sub_desc_size_mobile'] ) && $data['enable_ays_sccp_sub_desc_size_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box description size Mobile
            $ays_sccp_sub_desc_size_mobile = isset( $data['ays_sccp_sub_desc_size_mobile'] ) && $data['ays_sccp_sub_desc_size_mobile'] != '' ? absint( sanitize_text_field( $data['ays_sccp_sub_desc_size_mobile'] ) ) : 18;

            // Subscribe box text color
            $sub_text_color = ( isset( $data['sub_text_color'] ) && $data['sub_text_color'] != '') ? stripslashes( esc_attr($data['sub_text_color'] ) ) : '#000';

            // Enable Subscribe box Text Color Mobile
            $enable_sub_text_color_mobile = isset( $data['enable_sub_text_color_mobile'] ) && $data['enable_sub_text_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box Text Color Mobile
            $sub_text_color_mobile = isset( $data['sub_text_color_mobile'] ) && $data['sub_text_color_mobile'] != '' ? sanitize_text_field( $data['sub_text_color_mobile'] ) : '#000'; 

            // Subscribe box background color
            $sub_bg_color = (isset($data['sub_bg_color']) && $data['sub_bg_color'] != '') ? stripslashes( esc_attr($data['sub_bg_color']) ) : '#fff';

            // Enable Subscribe box background color Mobile
            $enable_sub_bg_color_mobile = isset( $data['enable_sub_bg_color_mobile'] ) && $data['enable_sub_bg_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box Background Color Mobile
            $sub_bg_color_mobile = isset( $data['sub_bg_color_mobile'] ) && $data['sub_bg_color_mobile'] != '' ? sanitize_text_field( $data['sub_bg_color_mobile'] ) : '#fff';

            // Subscribe description text color
            $sub_desc_text_color = (isset($data['sub_desc_text_color']) && $data['sub_desc_text_color'] != '') ? stripslashes( esc_attr($data['sub_desc_text_color']) ) : '#000';

            // Enable Subscribe description text color Mobile
            $enable_sub_desc_text_color_mobile = isset( $data['enable_sub_desc_text_color_mobile'] ) && $data['enable_sub_desc_text_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box description text color Mobile
            $sub_desc_text_color_mobile = isset( $data['sub_desc_text_color_mobile'] ) && $data['sub_desc_text_color_mobile'] != '' ? sanitize_text_field( $data['sub_desc_text_color_mobile'] ) : '#000';
            
            // Subscribe box title transformation
            $sub_title_transformation = (isset($data['ays_sub_title_transformation']) && sanitize_text_field( $data['ays_sub_title_transformation'] ) != "") ? sanitize_text_field( $data['ays_sub_title_transformation'] ) : 'none';

            // Enable Subscribe title transformation Mobile
            $enable_sub_title_transformation_mobile = isset( $data['enable_ays_sub_title_transformation_mobile'] ) && $data['enable_ays_sub_title_transformation_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box title transformation Mobile
            $sub_title_transformation_mobile = isset( $data['ays_sub_title_transformation_mobile'] ) && $data['ays_sub_title_transformation_mobile'] != '' ? sanitize_text_field( $data['ays_sub_title_transformation_mobile'] ) : 'none';

            // Subscribe box button text
            $ays_sub_button_text = (isset($data['ays_sccp_sub_button_text']) && $data['ays_sccp_sub_button_text'] != '') ? stripslashes( esc_attr($data['ays_sccp_sub_button_text']) ) : 'Subscribe';

            // Enable Subscribe title transformation Mobile
            $enable_ays_sub_button_text_mobile = isset( $data['enable_ays_sccp_sub_button_text_mobile'] ) && $data['enable_ays_sub_title_transformation_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box title transformation Mobile
            $ays_sub_button_text_mobile = isset( $data['ays_sccp_sub_button_text_mobile'] ) && $data['ays_sccp_sub_button_text_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_button_text_mobile'] ) : 'Subscribe';

            // Subscribe box Add Icon
            $ays_sub_icon_img = (isset($data['ays_sccp_sub_icon_image']) && $data['ays_sccp_sub_icon_image'] != '') ? $data['ays_sccp_sub_icon_image'] : '';

            // Subscribe box Add BG Image
            $ays_sub_bg_img = (isset($data['ays_sccp_sub_bg_image']) && $data['ays_sccp_sub_bg_image'] != '') ? $data['ays_sccp_sub_bg_image'] : '';

            // Subscribe box email placeholder text
            $ays_sub_email_place_text = (isset($data['ays_sccp_sub_email_place_text']) && $data['ays_sccp_sub_email_place_text'] != '') ? stripslashes( esc_attr($data['ays_sccp_sub_email_place_text']) ) : 'Type your email address';

            // Subscribe box name placeholder text
            $ays_sub_name_place_text = (isset($data['ays_sccp_sub_name_place_text']) && $data['ays_sccp_sub_name_place_text'] != '') ? stripslashes( esc_attr($data['ays_sccp_sub_name_place_text']) ) : 'Type your name';

            // Subscribe button style
            $enable_sub_btn_style = (isset($data['ays_sccp_enable_sub_btn_style']) && $data['ays_sccp_enable_sub_btn_style'] != '') ? 'on' : 'off';

            // Subscribe button color
            $sub_btn_color = (isset($data['ays_sccp_sub_btn_color']) && $data['ays_sccp_sub_btn_color'] != '') ? sanitize_text_field($data['ays_sccp_sub_btn_color']) : 'rgba(255,255,255,0)';

            // Enable Subscribe button color Mobile
            $enable_sub_btn_color_mobile = isset( $data['enable_ays_sccp_sub_btn_color_mobile'] ) && $data['enable_ays_sccp_sub_btn_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe button color Mobile
            $sub_btn_color_mobile = isset( $data['ays_sccp_sub_btn_color_mobile'] ) && $data['ays_sccp_sub_btn_color_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_color_mobile'] ) : 'rgba(255,255,255,0)';

            // Enable Subscribe button text color
            $sub_btn_text_color = (isset($data['ays_sccp_sub_btn_text_color']) && $data['ays_sccp_sub_btn_text_color'] != '') ? sanitize_text_field($data['ays_sccp_sub_btn_text_color']) : '#000000';

            // Enable Subscribe button text color Mobile
            $enable_sub_btn_text_color_mobile = isset( $data['enable_ays_sccp_sub_btn_text_color_mobile'] ) && $data['enable_ays_sccp_sub_btn_text_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe button text color Mobile
            $sub_btn_text_color_mobile = isset( $data['ays_sccp_sub_btn_text_color_mobile'] ) && $data['ays_sccp_sub_btn_text_color_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_text_color_mobile'] ) : '#000000';

            // Subscribe Buttons border color Mobile
            $sub_btn_border_color = (isset($data['ays_sccp_sub_btn_border_color']) && $data['ays_sccp_sub_btn_border_color'] != '') ? sanitize_text_field($data['ays_sccp_sub_btn_border_color']) : '#000000';

            // Enable Subscribe Buttons border color Mobile
            $enable_sub_btn_border_color_mobile = isset( $data['enable_ays_sccp_sub_btn_border_color_mobile'] ) && $data['enable_ays_sccp_sub_btn_border_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Buttons border color Mobile
            $sub_btn_border_color_mobile = isset( $data['ays_sccp_sub_btn_border_color_mobile'] ) && $data['ays_sccp_sub_btn_border_color_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_border_color_mobile'] ) : '#000';

            // Subscribe Container border color
            $sub_cont_border_color = (isset($data['ays_sccp_sub_cont_border_color']) && $data['ays_sccp_sub_cont_border_color'] != '') ? sanitize_text_field($data['ays_sccp_sub_cont_border_color']) : '#000000';

            // Enable Subscribe Container border color Mobile
            $enable_sub_cont_border_color_mobile = isset( $data['enable_ays_sccp_sub_cont_border_color_mobile'] ) && $data['enable_ays_sccp_sub_cont_border_color_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Container border color Mobile
            $sub_cont_border_color_mobile = isset( $data['ays_sccp_sub_cont_border_color_mobile'] ) && $data['ays_sccp_sub_cont_border_color_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_cont_border_color_mobile'] ) : '#000';

            $sub_btn_size = (isset($data['ays_sccp_sub_btn_size']) && $data['ays_sccp_sub_btn_size'] != '') ? sanitize_text_field($data['ays_sccp_sub_btn_size']) : '14';

            $sub_mobile_btn_size = (isset($data['ays_sccp_sub_mobile_btn_size']) && $data['ays_sccp_sub_mobile_btn_size'] != '') ? sanitize_text_field($data['ays_sccp_sub_mobile_btn_size']) : '14';

            // Subscribe box button border radius
            $sub_btn_radius = (isset($data['ays_sccp_sub_btn_radius']) && sanitize_text_field( $data['ays_sccp_sub_btn_radius'] ) != "") ? sanitize_text_field( $data['ays_sccp_sub_btn_radius'] ) : '3';

            // Enable Subscribe box button border radius Mobile
            $enable_sub_btn_radius_mobile = isset( $data['enable_ays_sccp_sub_btn_radius_mobile'] ) && $data['enable_ays_sccp_sub_btn_radius_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box button border radius Mobile
            $sub_btn_radius_mobile = isset( $data['ays_sccp_sub_btn_radius_mobile'] ) && $data['ays_sccp_sub_btn_radius_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_radius_mobile'] ) : '3';

            // Buttons border width
            $sub_btn_border_width = (isset($data['ays_sccp_sub_btn_border_width']) && sanitize_text_field( $data['ays_sccp_sub_btn_border_width'] ) != "") ? sanitize_text_field( $data['ays_sccp_sub_btn_border_width'] ) : '1';

            // Enable Subscribe box button border width Mobile
            $enable_sub_btn_border_width_mobile = isset( $data['enable_ays_sccp_sub_btn_border_width_mobile'] ) && $data['enable_ays_sccp_sub_btn_border_width_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box button border width Mobile
            $sub_btn_border_width_mobile = isset( $data['ays_sccp_sub_btn_border_width_mobile'] ) && $data['ays_sccp_sub_btn_border_width_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_border_width_mobile'] ) : '1';

            // Container border width
            $sub_cont_border_width = (isset($data['ays_sccp_sub_cont_border_width']) && sanitize_text_field( $data['ays_sccp_sub_cont_border_width'] ) != "") ? sanitize_text_field( $data['ays_sccp_sub_cont_border_width'] ) : '1';

            // Enable Subscribe Container border width Mobile
            $enable_sub_cont_border_width_mobile = isset( $data['enable_ays_sccp_sub_cont_border_width_mobile'] ) && $data['enable_ays_sccp_sub_cont_border_width_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Container border width Mobile
            $sub_cont_border_width_mobile = isset( $data['ays_sccp_sub_cont_border_width_mobile'] ) && $data['ays_sccp_sub_cont_border_width_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_cont_border_width_mobile'] ) : '1';

            // Buttons border style
            $sub_btn_border_style = (isset($data['ays_sccp_sub_btn_border_style']) && $data['ays_sccp_sub_btn_border_style'] != '') ? sanitize_text_field( $data['ays_sccp_sub_btn_border_style'] ) : 'solid';

            // Enable Subscribe Buttons border style Mobile
            $enable_sub_btn_border_style_mobile = isset( $data['enable_ays_sccp_sub_btn_border_style_mobile'] ) && $data['enable_ays_sccp_sub_btn_border_style_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Buttons border style Mobile
            $sub_btn_border_style_mobile = isset( $data['ays_sccp_sub_btn_border_style_mobile'] ) && $data['ays_sccp_sub_btn_border_style_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_btn_border_style_mobile'] ) : 'solid';

            // Subscribe Container border style
            $sub_cont_border_style = (isset($data['ays_sccp_sub_cont_border_style']) && $data['ays_sccp_sub_cont_border_style'] != '') ? sanitize_text_field( $data['ays_sccp_sub_cont_border_style'] ) : 'solid';

            // Enable Subscribe Container border style Mobile
            $enable_sub_cont_border_style_mobile = isset( $data['enable_ays_sccp_sub_cont_border_style_mobile'] ) && $data['enable_ays_sccp_sub_cont_border_style_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Container border style Mobile
            $sub_cont_border_style_mobile = isset( $data['ays_sccp_sub_cont_border_style_mobile'] ) && $data['ays_sccp_sub_cont_border_style_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_cont_border_style_mobile'] ) : 'solid';

            // Buttons Left / Right padding
            $buttons_left_right_padding = (isset($data['ays_sub_btn_left_right_padding']) && $data['ays_sub_btn_left_right_padding'] != "") ? $data['ays_sub_btn_left_right_padding'] : '20';

            // Buttons Top / Bottom padding
            $buttons_top_bottom_padding = (isset($data['ays_sub_btn_top_bottom_padding']) && $data['ays_sub_btn_top_bottom_padding'] != "") ? $data['ays_sub_btn_top_bottom_padding'] : '10';

            // Enable Subscribe Buttons padding Mobile
            $enable_sub_buttons_padding_mobile = isset( $data['enable_ays_sub_btn_padding_mobile'] ) && $data['enable_ays_sub_btn_padding_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Buttons padding Mobile
            $buttons_left_right_padding_mobile = isset( $data['ays_sub_btn_left_right_padding_mobile'] ) && $data['ays_sub_btn_left_right_padding_mobile'] != '' ? sanitize_text_field( $data['ays_sub_btn_left_right_padding_mobile'] ) : '20';

            $buttons_top_bottom_padding_mobile = isset( $data['ays_sub_btn_top_bottom_padding_mobile'] ) && $data['ays_sub_btn_top_bottom_padding_mobile'] != '' ? sanitize_text_field( $data['ays_sub_btn_top_bottom_padding_mobile'] ) : '10';

            // Subscribe box text alignment
            $sccp_sub_text_alignment = (isset($data['ays_sccp_sub_text_alignment']) && sanitize_text_field( $data['ays_sccp_sub_text_alignment']) != '') ? sanitize_text_field( $data['ays_sccp_sub_text_alignment'] ) : 'center';

            // Enable Subscribe box text alignment Mobile
            $enable_sccp_sub_text_alignment_mobile = isset( $data['enable_ays_sccp_sub_text_alignment_mobile'] ) && $data['enable_ays_sccp_sub_text_alignment_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe box text alignment Mobile
            $sccp_sub_text_alignment_mobile = isset( $data['ays_sccp_sub_text_alignment_mobile'] ) && $data['ays_sccp_sub_text_alignment_mobile'] != '' ? sanitize_text_field( $data['ays_sccp_sub_text_alignment_mobile'] ) : 'center';

            // Subscribe box Width by percentage or pixels
            $sccp_sub_width_by_percentage_px = (isset($data['ays_sccp_sub_width_by_percentage_px']) && $data['ays_sccp_sub_width_by_percentage_px'] != '') ? sanitize_text_field( $data['ays_sccp_sub_width_by_percentage_px'] ) : 'pixels';

            // Subscribe box Width mobile by percentage or pixels
            $sccp_sub_width_mobile_by_percentage_px = (isset($data['ays_sccp_sub_width_mobile_by_percentage_px']) && $data['ays_sccp_sub_width_mobile_by_percentage_px'] != '') ? sanitize_text_field( $data['ays_sccp_sub_width_mobile_by_percentage_px'] ) : 'pixels';

            // Subscribe Bg image positioning
            $sub_bg_image_position = (isset($data['ays_sub_bg_image_position']) && $data['ays_sub_bg_image_position'] != "") ? $data['ays_sub_bg_image_position'] : 'center center';

            // Enable Subscribe Bg image positioning Mobile
            $enable_sub_bg_image_position_mobile = isset( $data['enable_ays_sub_bg_image_position_mobile'] ) && $data['enable_ays_sub_bg_image_position_mobile'] == 'on' ? 'on' : 'off';

            // Subscribe Bg image positioning Mobile
            $sub_bg_image_position_mobile = isset( $data['ays_sub_bg_image_position_mobile'] ) && $data['ays_sub_bg_image_position_mobile'] != '' ? sanitize_text_field( $data['ays_sub_bg_image_position_mobile'] ) : 'center center';

            $subscribe = array(
                "sccp_sub_width"                            => $ays_sccp_sub_width,
                "sccp_sub_width_mobile"                     => $ays_sccp_sub_width_mobile,
                "sub_cont_input_width"                      => $ays_sccp_sub_input_width,
                "enable_sub_cont_input_width_mobile"        => $enable_ays_sccp_sub_input_width_mobile,
                "sub_cont_input_width_mobile"               => $ays_sccp_sub_input_width_mobile,
                "sccp_sub_text_color"                       => $sub_text_color,
                "enable_sccp_sub_text_color_mobile"         => $enable_sub_text_color_mobile,
                "sccp_sub_text_color_mobile"                => $sub_text_color_mobile,
                "sccp_sub_desc_text_color"                  => $sub_desc_text_color,
                "enable_sccp_sub_desc_text_color_mobile"    => $enable_sub_desc_text_color_mobile,
                "sccp_sub_desc_text_color_mobile"           => $sub_desc_text_color_mobile,
                "sccp_sub_bg_color"                         => $sub_bg_color,
                "enable_sccp_sub_bg_color_mobile"           => $enable_sub_bg_color_mobile,
                "sccp_sub_bg_color_mobile"                  => $sub_bg_color_mobile,
                "sub_title_transformation"                  => $sub_title_transformation,
                "enable_sub_title_transformation_mobile"    => $enable_sub_title_transformation_mobile,
                "sub_title_transformation_mobile"           => $sub_title_transformation_mobile,
                "sccp_sub_button_text"                      => $ays_sub_button_text,
                "enable_sccp_sub_button_text_mobile"        => $enable_ays_sub_button_text_mobile,
                "sccp_sub_button_text_mobile"               => $ays_sub_button_text_mobile,
                "sub_icon_image"                            => $ays_sub_icon_img,
                "sub_bg_image"                              => $ays_sub_bg_img,
                "sub_bg_image_position"                     => $sub_bg_image_position,
                "enable_sub_bg_image_position_mobile"       => $enable_sub_bg_image_position_mobile,
                "sub_bg_image_position_mobile"              => $sub_bg_image_position_mobile,
                "sccp_sub_email_place_text"                 => $ays_sub_email_place_text,
                "sccp_sub_name_place_text"                  => $ays_sub_name_place_text,
                "sccp_sub_title_size"                       => $ays_sccp_sub_title_size,
                "enable_sccp_sub_title_size_mobile"         => $enable_ays_sccp_sub_title_size_mobile,
                "sccp_sub_title_size_mobile"                => $ays_sccp_sub_title_size_mobile,
                "sccp_sub_desc_size"                        => $ays_sccp_sub_desc_size,
                "enable_sccp_sub_desc_size_mobile"          => $enable_ays_sccp_sub_desc_size_mobile,
                "sccp_sub_desc_size_mobile"                 => $ays_sccp_sub_desc_size_mobile,
                "enable_sub_btn_style"                      => $enable_sub_btn_style,
                "sub_btn_color"                             => $sub_btn_color,
                "enable_sub_btn_color_mobile"               => $enable_sub_btn_color_mobile,
                "sub_btn_color_mobile"                      => $sub_btn_color_mobile,
                "sub_btn_text_color"                        => $sub_btn_text_color,
                "enable_sub_btn_text_color_mobile"          => $enable_sub_btn_text_color_mobile,
                "sub_btn_text_color_mobile"                 => $sub_btn_text_color_mobile,
                "sub_btn_border_color"                      => $sub_btn_border_color,
                "enable_sub_btn_border_color_mobile"        => $enable_sub_btn_border_color_mobile,
                "sub_btn_border_color_mobile"               => $sub_btn_border_color_mobile,
                "sub_cont_border_color"                     => $sub_cont_border_color,
                "enable_sub_cont_border_color_mobile"       => $enable_sub_cont_border_color_mobile,
                "sub_cont_border_color_mobile"              => $sub_cont_border_color_mobile,
                "sub_btn_size"                              => $sub_btn_size,
                "sub_mobile_btn_size"                       => $sub_mobile_btn_size,
                "sub_btn_radius"                            => $sub_btn_radius,
                "enable_sub_btn_radius_mobile"              => $enable_sub_btn_radius_mobile,
                "sub_btn_radius_mobile"                     => $sub_btn_radius_mobile,
                "sub_btn_border_width"                      => $sub_btn_border_width,
                "enable_sub_btn_border_width_mobile"        => $enable_sub_btn_border_width_mobile,
                "sub_btn_border_width_mobile"               => $sub_btn_border_width_mobile,
                "sub_cont_border_width"                     => $sub_cont_border_width,
                "enable_sub_cont_border_width_mobile"       => $enable_sub_cont_border_width_mobile,
                "sub_cont_border_width_mobile"              => $sub_cont_border_width_mobile,
                "sub_btn_border_style"                      => $sub_btn_border_style,
                "enable_sub_btn_border_style_mobile"        => $enable_sub_btn_border_style_mobile,
                "sub_btn_border_style_mobile"               => $sub_btn_border_style_mobile,
                "sub_cont_border_style"                     => $sub_cont_border_style,
                "enable_sub_cont_border_style_mobile"       => $enable_sub_cont_border_style_mobile,
                "sub_cont_border_style_mobile"              => $sub_cont_border_style_mobile,
                "sub_btn_left_right_padding"                => $buttons_left_right_padding,
                "sub_btn_top_bottom_padding"                => $buttons_top_bottom_padding,
                "enable_sub_btn_padding_mobile"             => $enable_sub_buttons_padding_mobile,
                "sub_btn_left_right_padding_mobile"         => $buttons_left_right_padding_mobile,
                "sub_btn_top_bottom_padding_mobile"         => $buttons_top_bottom_padding_mobile,
                "sccp_sub_text_alignment"                   => $sccp_sub_text_alignment,
                "enable_sccp_sub_text_alignment_mobile"     => $enable_sccp_sub_text_alignment_mobile,
                "sccp_sub_text_alignment_mobile"            => $sccp_sub_text_alignment_mobile,
                "sccp_sub_width_by_percentage_px"           => $sccp_sub_width_by_percentage_px,
                "sccp_sub_width_mobile_by_percentage_px"    => $sccp_sub_width_mobile_by_percentage_px
            );            

             // Block content box width
            $ays_sccp_bc_width = (isset($data['ays_sccp_bc_width']) && $data['ays_sccp_bc_width'] != '') ? absint( sanitize_text_field($data['ays_sccp_bc_width']) ) : '';

            $ays_sccp_bc_width_mobile = (isset($data['ays_sccp_bc_width_mobile']) && $data['ays_sccp_bc_width_mobile'] != '') ? absint( sanitize_text_field($data['ays_sccp_bc_width_mobile']) ) : '';

            // Block content box Width by percentage or pixels
            $sccp_bc_width_by_percentage_px = (isset($data['ays_sccp_bc_width_by_percentage_px']) && $data['ays_sccp_bc_width_by_percentage_px'] != '') ? sanitize_text_field( $data['ays_sccp_bc_width_by_percentage_px'] ) : 'pixels';

            $sccp_bc_width_mobile_by_percentage_px = (isset($data['ays_sccp_bc_width_mobile_by_percentage_px']) && $data['ays_sccp_bc_width_mobile_by_percentage_px'] != '') ? sanitize_text_field( $data['ays_sccp_bc_width_mobile_by_percentage_px'] ) : 'pixels';


            // Block content box text color
            $bc_text_color = (isset($data['bc_text_color']) && $data['bc_text_color'] != '') ? stripslashes( esc_attr($data['bc_text_color']) ) : '#000';

            // Enable Block content box Text Color Mobile
            $enable_bc_text_color_mobile = isset( $data['enable_bc_text_color_mobile'] ) && $data['enable_bc_text_color_mobile'] == 'on' ? 'on' : 'off';

            // Block content box Text Color Mobile
            $bc_text_color_mobile = isset( $data['bc_text_color_mobile'] ) && $data['bc_text_color_mobile'] != '' ? sanitize_text_field( $data['bc_text_color_mobile'] ) : '#000';

            // Block content box background color
            $bc_bg_color = (isset($data['bc_bg_color']) && $data['bc_bg_color'] != '') ? stripslashes( esc_attr($data['bc_bg_color']) ) : '#fff';

            // Enable Block content box background color Mobile
            $enable_bc_bg_color_mobile = isset( $data['enable_bc_bg_color_mobile'] ) && $data['enable_bc_bg_color_mobile'] == 'on' ? 'on' : 'off';

            // Block content box Background Color Mobile
            $bc_bg_color_mobile = isset( $data['bc_bg_color_mobile'] ) && $data['bc_bg_color_mobile'] != '' ? sanitize_text_field( $data['bc_bg_color_mobile'] ) : '#fff';

            // Block content box Add BG Image
            $ays_bc_bg_img = (isset($data['ays_sccp_bc_bg_image']) && $data['ays_sccp_bc_bg_image'] != '') ? $data['ays_sccp_bc_bg_image'] : '';

            // Block content Bg image positioning
            $bc_bg_image_position = (isset($data['ays_bc_bg_image_position']) && $data['ays_bc_bg_image_position'] != "") ? $data['ays_bc_bg_image_position'] : 'center center';

            // Enable Block content Bg image positioning Mobile
            $enable_bc_bg_image_position_mobile = isset( $data['enable_ays_bc_bg_image_position_mobile'] ) && $data['enable_ays_bc_bg_image_position_mobile'] == 'on' ? 'on' : 'off';

            // Block content Bg image positioning Mobile
            $bc_bg_image_position_mobile = isset( $data['ays_bc_bg_image_position_mobile'] ) && $data['ays_bc_bg_image_position_mobile'] != '' ? sanitize_text_field( $data['ays_bc_bg_image_position_mobile'] ) : 'center center';

            // Block content box button text
            $ays_bc_button_text = (isset($data['ays_sccp_bc_button_text']) && $data['ays_sccp_bc_button_text'] != '') ? stripslashes( esc_attr($data['ays_sccp_bc_button_text']) ) : 'Submit';

            // Block content box password placeholder text
            $ays_bc_psw_place_text = (isset($data['ays_sccp_bc_psw_place_text']) && $data['ays_sccp_bc_psw_place_text'] != '') ? stripslashes( esc_attr($data['ays_sccp_bc_psw_place_text']) ) : 'Password';

            // Block content Container border style
            $bc_cont_border_style = (isset($data['ays_sccp_bc_cont_border_style']) && $data['ays_sccp_bc_cont_border_style'] != '') ? sanitize_text_field( $data['ays_sccp_bc_cont_border_style'] ) : 'double';

            // Block content Container border color
            $bc_cont_border_color = (isset($data['ays_sccp_bc_cont_border_color']) && $data['ays_sccp_bc_cont_border_color'] != '') ? sanitize_text_field($data['ays_sccp_bc_cont_border_color']) : '#c5c5c5';

            // Block content Container border width
            $bc_cont_border_width = (isset($data['ays_sccp_bc_cont_border_width']) && sanitize_text_field( $data['ays_sccp_bc_cont_border_width'] ) != "") ? sanitize_text_field( $data['ays_sccp_bc_cont_border_width'] ) : '4';

            // Block content box Add Icon
            $ays_bc_icon_img = (isset($data['ays_sccp_bc_icon_image']) && $data['ays_sccp_bc_icon_image'] != '') ? $data['ays_sccp_bc_icon_image'] : '';

            // Block content input width
            $ays_sccp_bc_input_width = (isset($data['ays_sccp_bc_input_width']) && $data['ays_sccp_bc_input_width'] != '') ? absint( sanitize_text_field($data['ays_sccp_bc_input_width']) ) : '';

            // Block content box text alignment
            $sccp_bc_text_alignment = (isset($data['ays_sccp_bc_text_alignment']) && sanitize_text_field( $data['ays_sccp_bc_text_alignment']) != '') ? sanitize_text_field( $data['ays_sccp_bc_text_alignment'] ) : 'center';

            //Block content button style
            $enable_bc_btn_style = (isset($data['ays_sccp_enable_bc_btn_style']) && $data['ays_sccp_enable_bc_btn_style'] != '') ? 'on' : 'off';

            $bc_btn_color = (isset($data['ays_sccp_bc_btn_color']) && $data['ays_sccp_bc_btn_color'] != '') ? sanitize_text_field($data['ays_sccp_bc_btn_color']) : 'rgba(255,255,255,0)';

            $bc_btn_text_color = (isset($data['ays_sccp_bc_btn_text_color']) && $data['ays_sccp_bc_btn_text_color'] != '') ? sanitize_text_field($data['ays_sccp_bc_btn_text_color']) : '#000000';

            $bc_btn_size = (isset($data['ays_sccp_bc_btn_size']) && $data['ays_sccp_bc_btn_size'] != '') ? sanitize_text_field($data['ays_sccp_bc_btn_size']) : '14';

            $bc_mobile_btn_size = (isset($data['ays_sccp_bc_mobile_btn_size']) && $data['ays_sccp_bc_mobile_btn_size'] != '') ? sanitize_text_field($data['ays_sccp_bc_mobile_btn_size']) : '14';

            $bc_btn_radius = (isset($data['ays_sccp_bc_btn_radius']) && sanitize_text_field( $data['ays_sccp_bc_btn_radius'] ) != "") ? sanitize_text_field( $data['ays_sccp_bc_btn_radius'] ) : '3';

            // Block content Buttons border width
            $bc_btn_border_width = (isset($data['ays_sccp_bc_btn_border_width']) && sanitize_text_field( $data['ays_sccp_bc_btn_border_width'] ) != "") ? sanitize_text_field( $data['ays_sccp_bc_btn_border_width'] ) : '1';

            // Block content Buttons border style
            $bc_btn_border_style = (isset($data['ays_sccp_bc_btn_border_style']) && $data['ays_sccp_bc_btn_border_style'] != '') ? sanitize_text_field( $data['ays_sccp_bc_btn_border_style'] ) : 'solid';

            // Block content Buttons border color
            $bc_btn_border_color = (isset($data['ays_sccp_bc_btn_border_color']) && $data['ays_sccp_bc_btn_border_color'] != '') ? sanitize_text_field($data['ays_sccp_bc_btn_border_color']) : '#c5c5c5';

            // Block content Buttons Left / Right padding
            $bc_buttons_left_right_padding = (isset($data['ays_bc_btn_left_right_padding']) && $data['ays_bc_btn_left_right_padding'] != "") ? $data['ays_bc_btn_left_right_padding'] : '10';

            // Block content Buttons Top / Bottom padding
            $bc_buttons_top_bottom_padding = (isset($data['ays_bc_btn_top_bottom_padding']) && $data['ays_bc_btn_top_bottom_padding'] != "") ? $data['ays_bc_btn_top_bottom_padding'] : '10';

            $block_content = array(
                "sccp_bc_width"                         => $ays_sccp_bc_width,
                "sccp_bc_width_mobile"                  => $ays_sccp_bc_width_mobile,
                "sccp_bc_width_by_percentage_px"        => $sccp_bc_width_by_percentage_px,
                "sccp_bc_width_mobile_by_percentage_px" => $sccp_bc_width_mobile_by_percentage_px,
                "sccp_bc_text_color"                    => $bc_text_color,
                "enable_sccp_bc_text_color_mobile"      => $enable_bc_text_color_mobile,
                "sccp_bc_text_color_mobile"             => $bc_text_color_mobile,
                "sccp_bc_bg_color"                      => $bc_bg_color,
                "enable_sccp_bc_bg_color_mobile"        => $enable_bc_bg_color_mobile,
                "sccp_bc_bg_color_mobile"               => $bc_bg_color_mobile,
                "bc_bg_image"                           => $ays_bc_bg_img,
                "bc_bg_image_position"                  => $bc_bg_image_position,
                "enable_bc_bg_image_position_mobile"    => $enable_bc_bg_image_position_mobile,
                "bc_bg_image_position_mobile"           => $bc_bg_image_position_mobile,
                "sccp_bc_button_text"                   => $ays_bc_button_text,
                "sccp_bc_psw_place_text"                => $ays_bc_psw_place_text,
                "bc_cont_border_style"                  => $bc_cont_border_style,
                "bc_cont_border_color"                  => $bc_cont_border_color,
                "bc_cont_border_width"                  => $bc_cont_border_width,
                "bc_icon_image"                         => $ays_bc_icon_img,
                "bc_cont_input_width"                   => $ays_sccp_bc_input_width,
                "bc_text_alignment"                     => $sccp_bc_text_alignment,
                "enable_bc_btn_style"                   => $enable_bc_btn_style,
                "bc_btn_color"                          => $bc_btn_color,
                "bc_btn_text_color"                     => $bc_btn_text_color,
                "bc_btn_size"                           => $bc_btn_size,
                "bc_mobile_btn_size"                    => $bc_mobile_btn_size,
                "bc_btn_radius"                         => $bc_btn_radius,
                "bc_btn_border_width"                   => $bc_btn_border_width,
                "bc_btn_border_style"                   => $bc_btn_border_style,
                "bc_btn_border_color"                   => $bc_btn_border_color,
                "bc_btn_left_right_padding"             => $bc_buttons_left_right_padding,
                "bc_btn_top_bottom_padding"             => $bc_buttons_top_bottom_padding,
            );

            $result = $this->ays_update_setting('mailchimp', json_encode($mailchimp));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('options', json_encode($options));
            if ($result) {
                $success++;
            }
            
            $result = $this->ays_update_setting('subscribe', json_encode( $subscribe, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES ));
            if ($result) {
                $success++;
            }

            $result = $this->ays_update_setting('block_content', json_encode( $block_content, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES ));
            if ($result) {
                $success++;
            }

            $message = "saved";
            if($success > 0){
                $tab = "";
                if(isset($data['ays_sccp_tab'])){
                    $tab = "&ays_sccp_tab=".$data['ays_sccp_tab'];
                }
                $url = admin_url('admin.php') . "?page=secure-copy-content-protection-settings" . $tab . '&status=' . $message;
                wp_redirect( $url );
            }
        }

    }

    public function get_db_data(){
        global $wpdb;
        $settings_table = esc_sql($wpdb->prefix . "ays_sccp_settings");
        $sql = "SELECT * FROM ".$settings_table;
        
        $results = $wpdb->get_results($sql, 'ARRAY_A');
        if(count($results) > 0){
            return $results;
        }else{
            return array();
        }
    }

    public function check_setting_mailchimp(){
        global $wpdb;
        $settings_table = esc_sql($wpdb->prefix . "ays_sccp_settings");
        $mailchimp = esc_sql('mailchimp');
        $sql = "SELECT COUNT(*) FROM ".$settings_table." WHERE meta_key = %s";

        $result = $wpdb->get_var(
                    $wpdb->prepare( $sql, $mailchimp)
                  );

        if(intval($result) == 0){
            $this->ays_add_setting("mailchimp", "", "", "");
        }
        return false;
    }

    public function ays_get_setting($meta_key){
        global $wpdb;
        $settings_table = esc_sql($wpdb->prefix . "ays_sccp_settings");
        $key_meta = esc_sql($meta_key);

        $sql = "SELECT meta_value FROM ".$settings_table." WHERE meta_key = %s";

        $result = $wpdb->get_var(
                    $wpdb->prepare( $sql, $key_meta)
                  );

        if($result != ""){
            return $result;
        }
        return false;
    }

    public function ays_add_setting($meta_key, $meta_value, $note = "", $options = ""){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ays_sccp_settings";
        $result = $wpdb->insert(
            $settings_table,
            array(
                'meta_key'    => $meta_key,
                'meta_value'  => $meta_value,
                'note'        => $note,
                'options'     => $options
            ),
            array( '%s', '%s', '%s', '%s' )
        );
        if($result >= 0){
            return true;
        }
        return false;
    }

    public function ays_update_setting($meta_key, $meta_value, $note = null, $options = null){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ays_sccp_settings";
        $value = array(
            'meta_value'  => $meta_value,
        );
        $value_s = array( '%s' );
        if($note != null){
            $value['note'] = $note;
            $value_s[] = '%s';
        }
        if($options != null){
            $value['options'] = $options;
            $value_s[] = '%s';
        }
        $result = $wpdb->update(
            $settings_table,
            $value,
            array( 'meta_key' => $meta_key, ),
            $value_s,
            array( '%s' )
        );
        if($result >= 0){
            return true;
        }
        return false;
    }

    public function ays_delete_setting($meta_key){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ays_sccp_settings";
        $wpdb->delete(
            $settings_table,
            array( 'meta_key' => $meta_key ),
            array( '%s' )
        );
    }

    public function sccp_settings_notices($status){

        if ( empty( $status ) )
            return;

        if ( 'saved' == $status )
            $updated_message = esc_html( __( 'Changes saved.', 'secure-copy-content-protection' ) );
        elseif ( 'updated' == $status )
            $updated_message = esc_html( __( 'SCCP attribute .', 'secure-copy-content-protection' ) );
        elseif ( 'deleted' == $status )
            $updated_message = esc_html( __( 'SCCP attribute deleted.', 'secure-copy-content-protection' ) );

        if ( empty( $updated_message ) )
            return;

        ?>
        <div class="ays-sccp-admin-notice notice notice-success is-dismissible">
            <p> <?php echo esc_html( $updated_message ); ?> </p>
        </div>
        <?php
    }

}