<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://boomdevs.com
 * @since             1.0.2
 * @package           Wpsafe_Ai_Malware_Protection
 *
 * @wordpress-plugin
 * Plugin Name:       Safe Ai Malware Protection for WP
 * Plugin URI:        https://wpsafe.ai/
 * Description:       WP Safe AI - Stress-Free WordPress Malware Cleaner.
 * Version:           1.0.20
 * Author:            BoomDevs
 * Author URI:        https://boomdevs.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       malware-virus-scanner-plugin
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'MVSP_PLUGIN_VERSION', '1.0.20' );

/**
 * Plugin global information..
 */
define( 'MVSP_PATH', plugin_dir_path( __FILE__ ) );
define( 'MVSP_URL', plugin_dir_url( __FILE__ ) );
define( 'MVSP_SLUG', 'wpsafe-ai-malware-protection' );
define( 'MVSP_SHORT_NAME', 'Safe Ai Malware Protection for WP' );
define( 'MVSP_FULL_NAME', 'Safe Ai Malware Protection for WP' );
define( 'MVSP_BASE_NAME', plugin_basename( __FILE__ ) );

ini_set('memory_limit', '102400M');
ini_set('max_execution_time', 0);
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );

// Change permalink for rest api
update_option('permalink_structure', '/%postname%/');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-malware-virus-scanner-plugin-activator.php
 */
function mvsp_malware_virus_scanner_plugin_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-malware-virus-scanner-plugin-activator.php';
	Malware_Virus_Scanner_Plugin_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-malware-virus-scanner-plugin-deactivator.php
 */
function mvsp_malware_virus_scanner_plugin_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-malware-virus-scanner-plugin-deactivator.php';
	Malware_Virus_Scanner_Plugin_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'mvsp_malware_virus_scanner_plugin_activate' );
register_deactivation_hook( __FILE__, 'mvsp_malware_virus_scanner_plugin_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-malware-virus-scanner-plugin.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function mvsp_malware_virus_scanner_plugin_run() {
	$plugin = new Malware_Virus_Scanner_Plugin();
	$plugin->run();
}
mvsp_malware_virus_scanner_plugin_run();