<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	class MVSP_Uploads_Scanner {
		public static function check_uploads_folder_files() {


			$uploads_directory = wp_upload_dir()['basedir'];
			$files = new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($uploads_directory),
				RecursiveIteratorIterator::SELF_FIRST
			);

			$infected_files = [];

			foreach ($files as $file) {
				if (self::is_invalid_file($file) || empty(filesize($file))) {
					continue;
				}

				$data = @file_get_contents($file);

				$definitions = [
					"qLPAE" => [
						"severity" => "suspicious",
						"signature" => "IlwvW15hLXpcXFwvJ1wiXWV2YWxcXChbXlxcKV0rWydcIlxcc1xcKTtdK1wvaSI,",
						"class" => "scripting"
					],
					"Y9N1H" => [
						"severity" => "suspicious",
						"signature" => "IlwvXFwkYXV0aF9wYXNzXFxzKj0uKztcL2ki",
						"class" => "scripting"
					],
					"2F58G" => [
						"severity" => "suspicious",
						"signature" => "IlwvcHJlZ19yZXBsYWNlXFxzKlxcKC4rW1xcXC9cXCNcXHxdW2ldKmVbaV0qWydcIl0uK1xcKVwvaSI,",
						"class" => "scripting"
					],
					"wCM8D" => [
						"severity" => "suspicious",
						"signature" => "IlwvXFxcL1xcKiBUaGlzIGZpbGUgaXMgcHJvdGVjdGVkIGJ5IGNvcHlyaWdodCBsYXcgYW5kIHByb3ZpZGVkIHVuZGVyIGxpY2Vuc2UuIFJldmVyc2UgZW5naW5lZXJpbmcgb2YgdGhpcyBmaWxlIGlzIHN0cmljdGx5IHByb2hpYml0ZWQuIFxcKlxcXC9cLyI,",
						"class" => "scripting"
					],
					"GML4E" => [
						"severity" => "suspicious",
						"signature" => "IlwvXFwjKFxcdyspXFwjLis_XFwjXFxcL1xcMVxcI1wvaXMi",
						"class" => "scripting"
					],
					"CD69I" => [
						"severity" => "severe",
						"signature" => "IlwvKFxccyooXFwkWzAtOV9hLXpdKylcXHMqPVxccyooW1wiJ10pKFthLXpcXFwvX1xcLTAtOVxcLl0qXFxcXHhbYS1mMC05XXsyfSkrW15cXDNdKj9cXDM7fFxccyooXFxcL1xcKihbXipdKlxcKig_IVxcXC8pKSpbXipdKlxcKlxcXC8pKSpbXFxAXFxzXSooaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_W1xcc1xcKF0qKFxcXC9cXCpbXlxcKl0qKFxcKlteXFwqXFxcL10qKStcXFwvXFxzKikqW1xcKFxcc10qKChbXCInXSkoW2EtelxcXC9fXFwtMC05XFwuXSpcXFxcKHhbYS1mMC05XXsyfXxbMC05XXsyLDN9KSkrW15cXDEyXSo_XFwxMnxcXDJ8XFwkXyg_IVJFUVVFU1RcXFsndGFyZ2V0J1xcXTspKFBPU3xSRVFVRVN8R0UpVFxccyooXFxbW15cXF1dK1xcXVxccyp8XFx7W15cXH1dK1xcfVxccyopKylbXFxzXFwpXSo7KFxccypcXDUpKlwvaSI,",
						"class" => "scripting"
					],
					"xCQBJ" => [
						"severity" => "severe",
						"signature" => "IlwvPFxcP1twaFxcc10rKFxcXC9cXFwvW15cXG5dKlxccyt8KGlmW1xcc1xcKF0raXNzZXRcXCh8ZnVuY3Rpb25cXHMrW2Etel8wLTldK1xcKFteXFx7XStbXFx7XFxzXSsuK3JldHVybilbXjtdKztbXFxzXFx9XSspKigoKFxcXC9cXCooW14qXSpcXCooPyFcXFwvKSkqW14qXSpcXCpcXFwvXFxzKnxpZlxccyopK1xcKGlzc2V0W1xcc1xcKF0rW1xcJFxceydcIl9dK1teXFx7XStbXFx7XFxzXSopPygoXFxcL1xcKihbXipdKlxcKig_IVxcXC8pKSpbXipdKlxcKlxcXC9cXHMqfFxcJFthLXpfMC05XSsoXFxzKlxcW1teXFxdXSpcXF0pKlxccyopKz1bXjtdKjtcXHMqfGZvcihlYWNoKT9cXHMqXFwoW15cXHtdK1xce1teXFx9XStcXH1cXHMqKSspKygoZnVuY3Rpb25cXHMrW2Etel8wLTldK1xcKFteXFx7XStbXFx7XFxzXSsuKj8pP1xcJFtcXCRcXHtdKlthLXpfMC05XStbXFx9XFxzXSooXFxcL1xcKihbXipdKlxcKig_IVxcXC8pKSpbXipdKlxcKlxcXC9cXHMqfFxcW1teXFxdXStcXF1cXHMqKSpcXCguKjtbXFx9XFxzXSopKygkfFxcPz4pXC9pIg,",
						"class" => "scripting"
					],
					"v411F" => [
						"severity" => "suspicious",
						"signature" => "IlwvanNvbjJcXC5taW5cXC5qc1wvaSI,",
						"class" => "scripting"
					]
				];

				foreach ($definitions as $definition => $signature) {
					if ($signature['class'] == 'htaccess' && self::get_fileext($file) != 'htaccess') {
						continue;
					}

					try {
						$matches = preg_match(self::decode($signature['signature']), $data, $found);
					} catch (Exception $e) {
						continue;
					}

					$infected_files[] = [
						'file'     => $file->getPathname(),
						'size'     => filesize($file),
						'id'       => $definition,
						'severity' => $signature['severity'],
						'info'     => $signature['severity'],
					];

//					if ($matches >= 1) {
//						$infected_files[] = [
//							'file'     => $file,
//							'id'       => $definition,
//							'severity' => $signature['severity'],
//							'info'     => $signature['severity'],
//						];
//					}
				}
			}

			return $infected_files;
		}

	    public static function is_invalid_file( $file ) {
			$file = self::realpath( $file );
			return ( ! file_exists( $file ) || ! is_readable( $file ) || ! is_file( $file ) );
		}

		public static function realpath( $path ) {
			$realpath = realpath( $path );
			if ( $realpath ) {
				return $realpath;
			}
			return $path;
		}

		public static function get_fileext( $filename ) {
			$nameparts = explode( '.', ".$filename" );
			return strtolower( $nameparts[ ( count( $nameparts ) - 1 ) ] );
		}

		public static function decode( $str ) {
			return json_decode( base64_decode( strtr( $str, '-_,', '+/=' ) ), true );
		}
	}