<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	class MVSP_DB_Scanner {

		public static function db_scan() {

			global $wpdb;
			$scan_sqls   = array(
				'post'      => "SELECT ID AS id, post_content AS content, post_type as post_type FROM $wpdb->posts where post_content LIKE '%s'",
				'post_meta' => "SELECT meta_id AS id, meta_value AS content FROM $wpdb->postmeta where meta_value LIKE '%s'",
				'option'    => "SELECT option_id AS id, option_value AS content FROM $wpdb->options WHERE option_value LIKE '%s'",
				'comment'   => "SELECT comment_ID AS id, comment_content AS content FROM $wpdb->comments WHERE comment_content LIKE '%s' AND comment_approved = '1'",
			);
			$definitions = array(
				"J53Gh" => array(
					"severity" => "severe",
					"query" => "IiU8c2NyaXB0JSI,",
					"signature" => "IlwvPHNjcmlwdC4rP2Zyb21DaGFyQ29kZS4rP2xvY2F0aW9uLis_bG9jYXRpb24uKz9sb2NhdGlvbi4rPzxcXFwvc2NyaXB0PlwvaXMi",
					"class" => "database"
				),
				"cHTCI" => array(
					"severity" => "severe",
					"query" => "IiU8YSAldmlhZ3JhJSI,",
					"signature" => "IlwvPGFbXj5dKj5bXjxdKihwdXJjaGFzZXxvcmRlcnxidXl8Y2hlYXB8dmlhZ3JhfGxpc2lub3ByaWx8amFudXZpYXxmbHVveGV0aW5lfHBpbGxzfGNhc2htZXJlW1xcc19cXC1dKnNjYXJmfG9ubGluZXxvdXRsZXQpW148XSo8XFxcL2E",
					"class" => "database"
				),
				"OCQ5J" => array(
					"severity" => "severe",
					"query" => "IiVldmFsKFN0cmluZy5mcm9tQ2hhckNvZGUoJSI,",
					"signature" => "IlwvZXZhbFxcKFtcXHNhLXpfMC05XFwuXFwoXSpmcm9tQ2hhckNvZGVcXChbMC05LFxcc10rW1xcKVxcc10rO1xccypcL2ki",
					"class" => "database"
				),
				"n711J" => array(
					"severity" => "severe",
					"query" => "IiU8YSAlY2lhbGlzJSI,",
					"signature" => "IlwvPGFbXj5dKig-fD5bXjxdKltcXHNfXFwtXFwuXSspY2lhbGlzKFtcXHNfXFwtXFwuXStbXjxdKjx8PClcXFwvYT5cL2lzIg,,",
					"class" => "database"
				)
			);

			$db_results = [];
			foreach ( $definitions as $ver => $details ) {
				foreach ( $scan_sqls as $key => $sql ) {
					$results = $wpdb->get_results( "SELECT id FROM $wpdb->posts", ARRAY_A );

					foreach ( $results as $result ) {
						$content     = $result['content'];
						$id          = sanitize_text_field( $result['id'] );

						$post_status = empty( $result['post_type'] ) ? '' : 'post-type &rarr; ' . $result['post_type'] . '.';
						try {
							$matches = preg_match( self::decode( $details['signature'] ), $content, $found );
						} catch ( Exception $e ) {
							continue;
						}

	                    if ( $matches >= 1 ) {
	                        if ( in_array( $details['severity'], array( 'severe', 'high' ) ) ) {
	                            $db_results['status']= 'infected';
	                        }

	                        $db_results['infected_line'] =


		                    $status = '';
		                    if ( in_array( $details['severity'], array( 'severe', 'high' ) ) ) {
			                    $status = 'infected';
		                    }

		                    $db_results[] = [
			                    'status' => $status,
			                    'infected_line' => $details['severity'] . 'Found database infection(s) in ' . ucwords( $key ) . " id $id. $post_status Threat Level &rarr; " . $details['severity'] . '.' .$ver,
		                    ];
	                    }
					}
				}
			}

			return $db_results;
		}

		public static function decode( $str ) {
			return json_decode( base64_decode( strtr( $str, '-_,', '+/=' ) ), true );
		}
	}