<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
require_once plugin_dir_path(dirname(__FILE__)) . 'helper/class-get-plugins.php';
class MVSP_Plugins_List_Info {

    public static function plugins() {
        $active_plugins = get_option('active_plugins');
        $active_plugins = array_filter($active_plugins, function($value) {
            return !is_null($value);
        });
        $all_plugins = get_plugins();
        $inactive_plugins = array_diff_key($all_plugins, array_flip($active_plugins));
        $active_plugins_list = array_intersect_key($all_plugins, array_flip($active_plugins));
        $active_plugins = MVSP_Plugins_Info::plugins_info($active_plugins_list);

        $response = array(
            'active_plugins' => $active_plugins,
            'inactive_plugins' => $inactive_plugins,
        );
        

        // Adding status information directly to the response array
        $response['premium_plugins'] = [];
        $response['free_plugins'] = [];

        $plugins_info = MVSP_Plugins_Info::plugins_info($all_plugins);
        if(count($plugins_info) > 0) {
            foreach ($plugins_info as $single_plugin) {
                if($single_plugin->download_link === null) {
                    $response['premium_plugins'][] = $single_plugin;
                } else {
                    $response['free_plugins'][] = $single_plugin;
                }
            }
        }

        $response['plugins'] = $plugins_info;

        return $response;
    }

}