<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	require_once plugin_dir_path(dirname(__FILE__)) . 'helper/class-get-plugins.php';
	class MVSP_WP_Info {
		public static function return_website_info_json() {
			global $wpdb;
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			require_once ABSPATH . 'wp-load.php';

			$php_version = phpversion();
			$wp_version = get_bloginfo('version');
			$active_plugins = get_option('active_plugins');
			$active_plugins = array_filter($active_plugins, function($value) {
                return !is_null($value);
            });

			$all_plugins = get_plugins();
			// Initialize arrays for active and inactive plugins and their information
			$active_plugins_info = [];
			$inactive_plugins_info = [];

			// Loop through all available plugins
			foreach ($all_plugins as $plugin_path => $plugin_info) {
				// Add the plugin path to the plugin info array
				$plugin_info['path'] = $plugin_path;
				$folder_name = dirname($plugin_path);
				if($plugin_path === 'hello.php') {
					$folder_name = 'hello-dolly';
				}

				$plugin_info['folder_name'] = $folder_name;
    
				// Check if the plugin is in the active plugins list
				if (in_array($plugin_path, $active_plugins)) {
					// Add to the active plugins array
					$active_plugins_info[] = $plugin_info;
				} else {
					// Add to the inactive plugins array
					$inactive_plugins_info[] = $plugin_info;
				}
			}

			// $active_plugins = MVSP_Plugins_Info::plugins_info($active_plugins);
			$active_theme = wp_get_theme()->get('Name');
			$all_themes = wp_get_themes();
			$mysql_version = $wpdb->db_version();

			// Build theme data manually
			$free_themes = array();
			$premium_themes = array();

			foreach ($all_themes as $key => $theme) {

				$theme_information = wp_remote_get("https://api.wordpress.org/themes/info/1.1/?action=query_themes&request[theme]={$key}");
				$theme_information_response = json_decode($theme_information['body'], true);
				$is_premium = true;

				$theme_folder = $theme->get_stylesheet();

				if(count($theme_information_response['themes']) > 0) {
					$is_premium = false;
					$free_themes[] = array(
						'Name' => $theme->get('Name'),
						'Description' => $theme->get('Description'),
						'Author' => $theme->get('Author'),
						'AuthorURI' => $theme->get('AuthorURI'),
						'Version' => $theme->get('Version'),
						'Template' => $theme->get('Template'),
						'Status' => $theme->get('Status'),
						'Tags' => $theme->get('Tags'),
						'TextDomain' => $theme->get('TextDomain'),
						'DomainPath' => $theme->get('DomainPath'),
						'is_premium' => $is_premium,
						'slug'      => $theme_information_response['themes'][0]['slug'],
						'download_link' => "https://downloads.wordpress.org/theme/{$theme->get('TextDomain')}.{$theme->get('Version')}.zip",
						'screenshot' => 'https:'.$theme_information_response['themes'][0]['screenshot_url'],
						'folder_name' => $theme_folder,
					);
				} else {
					$premium_themes[] = array(
						'Name' => $theme->get('Name'),
						'Description' => $theme->get('Description'),
						'Author' => $theme->get('Author'),
						'AuthorURI' => $theme->get('AuthorURI'),
						'Version' => $theme->get('Version'),
						'Template' => $theme->get('Template'),
						'Status' => $theme->get('Status'),
						'Tags' => $theme->get('Tags'),
						'TextDomain' => $theme->get('TextDomain'),
						'DomainPath' => $theme->get('DomainPath'),
						'download_link' => null,
						'slug'          => $key,
						'is_premium' => $is_premium,
						'screenshot' => $theme->get_screenshot(),
						'folder_name' => $theme_folder,
					);
				}
			}

			global $wpdb;
			$status = array();

			// Check if MySQL CLI access is enabled
			$version = $wpdb->get_var("SELECT VERSION()");
			$status['mysql_cli_access'] = $version !== null;

			// Check if safe mode is on
			$status['safe_mode'] = defined('WP_SAFE_MODE') && WP_SAFE_MODE;

			// Check if the maximum post size limit is defined
			$status['post_max_size_defined'] = ini_get('post_max_size');

			// Check if the maximum upload size limit is defined
			$status['upload_max_size_defined'] = ini_get('upload_max_filesize');

			// Check if the WordPress root folder is accessible
			$status['wordpress_root_accessible'] = is_readable(ABSPATH);

			// Check if the PHP memory limit is set
			$status['php_memory_limit_set'] = ini_get('memory_limit');

			// Check if the PHP execution time limit is set
			$status['php_execution_time_limit_set'] = ini_get('max_execution_time');

			// Check if the 'unzip' functionality is available
			$status['unzip_functionality_available'] = function_exists('zip_open');

			// Check if cURL is enabled
			$status['curl_enabled'] = extension_loaded('curl');

			$status['site_ip'] = 'Unknown';
			if (!empty($_SERVER['SERVER_ADDR'])) {
				$status['site_ip'] = $_SERVER['SERVER_ADDR'];
			}

			$uname = php_uname();
			if (preg_match('/^[^\s]+/', $uname, $matches)) {
				$status['server_os'] = $matches[0];
			} else {
				$status['server_os'] = 'Unknown OS';
			}

			$status['worker_version'] = 'Unknown';
			if (defined('MVSP_PLUGIN_VERSION')) {
				$status['worker_version'] = MVSP_PLUGIN_VERSION;
			}

			$response = array(
				'php_version' => $php_version,
				'wordpress_version' => $wp_version,
				'active_plugins' => $active_plugins_info,
				'inactive_plugins' => $inactive_plugins_info,
				'active_theme' => $active_theme,
				'mysql_version' => $mysql_version,
			);

			// Adding status information directly to the response array
			$response = array_merge($response, $status);

			$response['free_themes'] = $free_themes;
			$response['premium_themes'] = $premium_themes;
			$response['premium_plugins'] = [];
			$response['free_plugins'] = [];

			$plugins_info = MVSP_Plugins_Info::plugins_info($all_plugins);
			if(count($plugins_info) > 0) {
				foreach ($plugins_info as $single_plugin) {
					if($single_plugin->download_link === null) {
						$single_plugin->mu_plugins = false;
						$response['premium_plugins'][] = $single_plugin;
					} else {
						$response['free_plugins'][] = $single_plugin;
					}
				}
			}

			$response['premium_plugins'] = array_merge($response['premium_plugins'], MVSP_Plugins_Info::get_plugins_mu());
			$response['plugins'] = $plugins_info;
			return $response;
		}
	}