<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
class MVSP_Themes_List {
    public static function themes_list() {
        $themes = array();
        $free_themes = array();
        $premium_themes = array();
        $all_themes = wp_get_themes();
        $active_theme = wp_get_theme()->get('Name');

        foreach ($all_themes as $key => $theme) {
            $theme_slug = sanitize_title($theme->get('Name'));
            if($theme->get('TextDomain') && $theme->get('TextDomain') !== '') {
                $theme_slug = $theme->get('TextDomain');
            }

            $theme_information = wp_remote_get("https://api.wordpress.org/themes/info/1.1/?action=query_themes&request[theme]={$theme_slug}");
            $theme_information_response = json_decode($theme_information['body'], true);
            $is_premium = true;

            $theme_folder = $theme->get_template();

            if(count($theme_information_response['themes']) > 0) {
                $is_premium = false;
                $free_themes[] = array(
                    'Name' => $theme->get('Name'),
                    'Description' => $theme->get('Description'),
                    'Author' => $theme->get('Author'),
                    'AuthorURI' => $theme->get('AuthorURI'),
                    'Version' => $theme->get('Version'),
                    'Template' => $theme->get('Template'),
                    'Status' => $theme->get('Status'),
                    'Tags' => $theme->get('Tags'),
                    'TextDomain' => $theme->get('TextDomain'),
                    'DomainPath' => $theme->get('DomainPath'),
                    'is_premium' => $is_premium,
                    'slug'      => $theme_information_response['themes'][0]['slug'],
                    'download_link' => "https://downloads.wordpress.org/theme/{$theme->get('TextDomain')}.{$theme->get('Version')}.zip",
                    'screenshot' => 'https:'.$theme_information_response['themes'][0]['screenshot_url'],
                    'folder_name' => $theme_folder,
                );
            } else {
                $premium_themes[] = array(
                    'Name' => $theme->get('Name'),
                    'Description' => $theme->get('Description'),
                    'Author' => $theme->get('Author'),
                    'AuthorURI' => $theme->get('AuthorURI'),
                    'Version' => $theme->get('Version'),
                    'Template' => $theme->get('Template'),
                    'Status' => $theme->get('Status'),
                    'Tags' => $theme->get('Tags'),
                    'TextDomain' => $theme->get('TextDomain'),
                    'DomainPath' => $theme->get('DomainPath'),
                    'download_link' => null,
                    'slug'          => $key,
                    'is_premium' => $is_premium,
                    'screenshot' => $theme->get_screenshot(),
                    'folder_name' => $theme_folder,
                );
            }
        }

        $response['free_themes'] = $free_themes;
        $response['active_theme'] = $active_theme;
        $response['premium_themes'] = $premium_themes;

        return $response;
    }
}