<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
    
	class MVSP_Templates {
		public static function menu_add_site($authorized, $token) {
			$app_url = getenv('APP_URL') ? getenv('APP_URL') : 'https://app.wpsafe.ai';
			?>
            <div class="cardWrapper">
				<?php if($authorized && $token): ?>
                    <div class="mvsp_title_wrapper title">
                        <h6 class="title">
							<?php echo esc_html__('Your site connected', 'wpsafe-ai-malware-protection'); ?>
                        </h6>
                        <div class="mvsp_button_outter_wrapper">
                            <button type="button" id="disConnectSite" class="disconnect_btn">
		                        <?php echo esc_html__('Disconnect', 'wpsafe-ai-malware-protection'); ?>
                            </button>
                            <div class="mvsp_loader_wrapper">
                                <span class="loader"></span>
                            </div>
                        </div>
                    </div>
                    <div class="formWrapper">
                        <div class="mvsp_site_status"><?php echo esc_url(site_url());?> <span class="mvsp_connected"><?php echo esc_html__('Connected', 'wpsafe-ai-malware-protection');?></span></div>
                    </div>
				<?php else: ?>
                    <h6 class="title"><?php echo esc_html__('Connect your site', 'wpsafe-ai-malware-protection'); ?></h6>
                    <div class="formWrapper">
                        <form target="_blank" id="mvspSiteConnectForm" action="<?php echo esc_url($app_url);?>/connect" method="get">
                            <input type="hidden" name="site" value="<?php echo esc_url(site_url()); ?>" />
                            <input type="hidden" id="mvspToken" name="token" />
                            <input class="input" id="mvspUserEmail" type="email" name="email" placeholder="<?php echo esc_attr__('Your personal email', 'wpsafe-ai-malware-protection'); ?>" value="<?php echo esc_attr( get_option( 'admin_email' ) ); ?>" />
                            <div class="mvsp_button_outter_wrapper">
                                <button type="button" id="mvspConnectSite" class="submitButton">
									<?php echo esc_html__('Submit', 'wpsafe-ai-malware-protection'); ?>
                                </button>
                                <div class="mvsp_loader_wrapper">
                                    <span class="loader"></span>
                                </div>
                            </div>
                        </form>
                    </div>
				<?php endif; ?>
            </div>
			<?php
		}
	}