<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}

	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-wp-info.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-check-php.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-export-db.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-generate-token.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-store-authorized-token.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-encryption.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-uploads-scanner.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-scan-db.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-deployment-script.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-plugins-info.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-theme-lists.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'helper/class-get-plugins.php';

	require_once plugin_dir_path(dirname(__FILE__)) . 'vendor/autoload.php';
	use Firebase\JWT\JWT;
	use Firebase\JWT\Key;

	/**
	 * Register custom api
	 */
	class MVSP_Rest_Api
	{
		public function __construct()
		{
			add_action('rest_api_init', function () {
				register_rest_route('mvsp/v1', '/authentication', array(
					'methods' => 'POST',
					'callback' => array($this, 'authentication'),
					'permission_callback' => '__return_true', // You can directly use a callback function
				));

				register_rest_route('mvsp/v1', '/export-db', array(
					'methods' => 'POST',
					'callback' => array($this, 'export_db'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/delete-exported-db', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_exported_db'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/delete-db-config', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_db_config'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/wp-core-hash', array(
					'methods' => 'POST',
					'callback' => array($this, 'wp_core_hash_files'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/upload-files-hash', array(
					'methods' => 'POST',
					'callback' => array($this, 'upload_hash_files'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/generate-core-hash', array(
					'methods' => 'POST',
					'callback' => array($this, 'generate_core_hash'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/scan/get-initial-info', array(
					'methods' => 'POST',
					'callback' => array($this, 'get_initial_info'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/scan/plugin/checksum', array(
					'methods' => 'POST',
					'callback' => array($this, 'wp_plugin_hash_files'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/get-db-config', array(
					'methods' => 'POST',
					'callback' => array($this, 'get_wp_config'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/scan/theme/checksum', array(
					'methods' => 'POST',
					'callback' => array($this, 'get_theme_checksum'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/create-files-zip', array(
					'methods' => 'POST',
					'callback' => array($this, 'create_zip'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/delete-file', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_file'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/scan-uploads', array(
					'methods' => 'POST',
					'callback' => array($this, 'scan_uploads'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/start-migrate', array(
					'methods' => 'POST',
					'callback' => array($this, 'start_migrate'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/scan-db', array(
					'methods' => 'POST',
					'callback' => array($this, 'scan_db'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/upload-files', array(
					'methods' => 'POST',
					'callback' => array($this, 'send_upload_files'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/create-theme-zips', array(
					'methods' => 'POST',
					'callback' => array($this, 'create_theme_zip'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/create-plugin-zips', array(
					'methods' => 'POST',
					'callback' => array($this, 'create_plugin_zip'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

                register_rest_route('mvsp/v1', '/create-mu-plugin-zips', array(
                    'methods' => 'POST',
                    'callback' => array($this, 'create_mu_plugin_zip'),
                    'permission_callback' => array($this, 'check_user_authenticated'),
                ));

				register_rest_route('mvsp/v1', '/verify/token', array(
					'methods' => 'POST',
					'callback' => array($this, 'verifytoken'),
					'permission_callback' => '__return_true', // You can directly use a callback function
				));

				register_rest_route('mvsp/v1', '/disconnect', array(
					'methods' => 'POST',
					'callback' => array($this, 'disconnect_site'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/checklist', array(
					'methods' => 'POST',
					'callback' => array($this, 'checklists'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/delete-deployment-script', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_deployment_script'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/get-htaccess', array(
					'methods' => 'POST',
					'callback' => array($this, 'get_htaccess'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));

				register_rest_route('mvsp/v1', '/store-token', array(
					'methods' => 'POST',
					'callback' => array($this, 'store_token'),
					'permission_callback' => '__return_true', // You can directly use a callback function
				));

				register_rest_route('mvsp/v1', '/update-plugin', array(
					'methods' => 'POST',
					'callback' => array($this, 'update_plugin'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/update-theme', array(
					'methods' => 'POST',
					'callback' => array($this, 'update_theme'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/delete-plugin', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_plugin'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/active-plugin', array(
					'methods' => 'POST',
					'callback' => array($this, 'active_plugin'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));
				
				register_rest_route('mvsp/v1', '/deactive-plugin', array(
					'methods' => 'POST',
					'callback' => array($this, 'deactive_plugin'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				// delete_theme_by_slug
				register_rest_route('mvsp/v1', '/delete-theme', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_theme_by_slug'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/active-theme', array(
					'methods' => 'POST',
					'callback' => array($this, 'switch_theme_by_slug'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				));
				
				register_rest_route('mvsp/v1', '/plugins-list', array(
					'methods' => 'POST',
					'callback' => array($this, 'plugins_list'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/themes-list', array(
					'methods' => 'POST',
					'callback' => array($this, 'themes_list'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/delete-files', array(
					'methods' => 'POST',
					'callback' => array($this, 'delete_files'),
					'permission_callback' => array($this, 'check_user_authenticated'),
					// 'permission_callback' => '__return_true',
				));
				
				register_rest_route('mvsp/v1', '/technical-assessment', array(
					'methods' => 'POST',
					'callback' => array($this, 'technical_assessment'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				// 	'permission_callback' => '__return_true',
				));

				register_rest_route('mvsp/v1', '/free-plugins', array(
					'methods' => 'POST',
					'callback' => array($this, 'free_plugins'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				// 	'permission_callback' => '__return_true',
				));
				
				register_rest_route('mvsp/v1', '/premium-plugins', array(
					'methods' => 'POST',
					'callback' => array($this, 'premium_plugins'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				// 	'permission_callback' => '__return_true',
				));
				
				register_rest_route('mvsp/v1', '/free-themes', array(
					'methods' => 'POST',
					'callback' => array($this, 'free_themes'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				// 	'permission_callback' => '__return_true',
				));
				
				register_rest_route('mvsp/v1', '/premium-themes', array(
					'methods' => 'POST',
					'callback' => array($this, 'premium_themes'),
					'permission_callback' => array($this, 'check_user_authenticated'),
				// 	'permission_callback' => '__return_true',
				));
			});
		}
		
		// Free themes callback
		public function free_themes() {
		    if ( ! function_exists( 'themes_api' ) ) {
            	require_once( ABSPATH . 'wp-admin/includes/theme.php' );
            }
            
		    $response = [MVSP_Themes_List::themes_list()];
		    $active_theme = wp_get_theme()->get('Name');
		    $free_themes_response = [];
		    
		    if(count($response[0]['free_themes'])> 0) {
		         foreach($response[0]['free_themes'] as $single_theme){
		             $request = themes_api('theme_information', array(
                        'slug'   => $single_theme['slug'],
                        'fields' => array(
                            'version' => true,
                        ),
                    ));
                    
                    $latest_version  = null;
                    
                    if (!is_wp_error($request)) {
                        $latest_version  = $request->version;
                    }
                    
                    $free_themes_response[] = array(
                        'name' => $single_theme['Name'],
                        'version' => $single_theme['Version'],
                        'new_version' => $latest_version,
                        'activated' => $active_theme === $single_theme['Name']
                    );
		         }
		    }
		   
		    return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $free_themes_response
				), 200);
		}
		
		// Premium themes callback
		// Free themes callback
		public function premium_themes() {
		    if ( ! function_exists( 'themes_api' ) ) {
            	require_once( ABSPATH . 'wp-admin/includes/theme.php' );
            }
            
		    $response = [MVSP_Themes_List::themes_list()];
		    $active_theme = wp_get_theme()->get('Name');
		    $premium_themes_response = [];
		    
		    if(count($response[0]['premium_themes'])> 0) {
		         foreach($response[0]['premium_themes'] as $single_theme){
                    $premium_themes_response[] = array(
                        'name' => $single_theme['Name'],
                        'version' => $single_theme['Version'],
                        'new_version' => null,
                        'activated' => $active_theme === $single_theme['Name']
                    );
		         }
		    }
		   
		    return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $premium_themes_response
				), 200);
		}

		// Free plugins callback
		public function free_plugins() {
		    global $wpdb, $wp_rewrite;
		    if ( ! function_exists( 'get_plugins' ) ) {
                require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            }
            
			
            $all_plugins = get_plugins();
            $plugins_info = MVSP_Plugins_Info::plugins_info($all_plugins);
            
            
			$response = [];
            
            if (count($plugins_info) > 0) {
                foreach ($plugins_info as $single_plugin) {
                    if ($single_plugin->download_link !== null) {
						$response[] = [
						    'name' => $single_plugin->Name,
						    'varsion' => $single_plugin->Version,
						    'new_version' => $single_plugin->new_version,
						    'activated' => is_plugin_active($single_plugin->plugin)
					    ];
                    }
                }
            }
            
            return new WP_REST_Response(
    			array(
    				'status' => true,
    				'data' => $response
    			), 200
    		);
		}
		
		// Premium plugins handler
		public function premium_plugins() {
		    global $wpdb, $wp_rewrite;
		    if ( ! function_exists( 'get_plugins' ) ) {
                require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            }
            
			
            $all_plugins = get_plugins();
            $plugins_info = MVSP_Plugins_Info::plugins_info($all_plugins);
            
			$response = [];
            
            if (count($plugins_info) > 0) {
                $active_plugins = get_option( 'active_plugins' );
                
                foreach ($plugins_info as $single_plugin) {
                    if ($single_plugin->download_link === null) {
                        // var_dump($single_plugin);
                        
                        $found = false;  // Flag to track if the plugin is found

                        foreach ( $active_plugins as $plugin ) {
                            if ( strpos( $plugin, $single_plugin->folder_name ) !== false ) {
                                $found = true;
                            }
                        }
                        
						$response[] = array(
						   'name' => $single_plugin->Name,
						    'varsion' => $single_plugin->Version,
						    'new_version' => $single_plugin->new_version,
						    'activated' => $found
					    );
                    }
                }
            }
            
            return new WP_REST_Response(
    			array(
    				'status' => true,
    				'data' => $response
    			), 200
    		);
		}
		
		public function technical_assessment() {
		     // Get the list of all installed plugins
		    global $wpdb, $wp_rewrite;
		    
		    if ( ! function_exists( 'get_plugins' ) ) {
                require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            }
		   
            $all_plugins = get_plugins();
            
        	$response = [
                'automatic_update' => true,
                'free_plugins_updated' => true,
                'premium_plugins_updated' => true,
                'disable_search_engine' => false,
                'file_editing_enabled' => true,
                'admin_user_exists' => false,
                'frontend_edit_enabled' => false,
                'deactivated_plugins' => false,
                'akismet_plugin_activated' => false,
                'vulnerabilities' => false,
                'protect_wp_config' => false,
                'protect_readme_html' => false,
                'disable_directory_access' => false,
                'protect_install_php' => false,
                'disabled_debug_mode' => false,
                'deactivated_themes' => false,
                'protect_upgrade_php' => false,
                'admin_accounts' => true,
                'stable_wordpress_version' => false,
                'wordpress_version_hide' => false,
                'revision_posts' => false,
                'user_friendly_permalink' => false,
                'timezone_settings' => true,
                'sample_page' => false,
                'sample_post' => false,
                'sample_comment' => false
            ];
            
            // Get the list of plugins with auto-update enabled
            $auto_update_plugins = get_site_option('auto_update_plugins', []);
            $all_have_auto_update = true;
            
            foreach ($all_plugins as $plugin_file => $plugin_data) {
                if (!in_array($plugin_file, $auto_update_plugins)) {
                    $all_have_auto_update = false;
                }
            }
            
            $response['automatic_update'] = $all_have_auto_update;
            
            // Autometic update end
            
            // Get premium and free plugins
            // Load all installed plugins
            
            $plugins_info = MVSP_Plugins_Info::plugins_info($all_plugins);
            $updates = get_site_transient('update_plugins');
            
            $need_update = [];
            
            if (!empty($updates->response)) {
                foreach ($updates->response as $plugin_file => $plugin_data) {
                    $need_update[] = $plugin_data->slug;
                }
            }
            
            
            if (count($plugins_info) > 0) {
                foreach ($plugins_info as $single_plugin) {
                    // Check if the plugin is premium (no download link) or free
                    if ($single_plugin->download_link === null) {
                        if(in_array($single_plugin->slug, $need_update)) {
                            $response['premium_plugins_updated'] = false;
                            $response['vulnerabilities'] = true;
                        }
                    } else {
                        if(in_array($single_plugin->slug, $need_update)) {
                            $response['free_plugins_updated'] = in_array($single_plugin->slug, $need_update) ? false : true;
                            $response['vulnerabilities'] = true;
                        }
                    }
                }
            }
            
            // Check if file editing is disabled
            if (defined('DISALLOW_FILE_EDIT') && DISALLOW_FILE_EDIT) {
                $response['file_editing_enabled'] = false;
            }
            
            // Check if an admin user with username 'admin' exists
            $user = get_user_by('login', 'admin');
            
            if ($user && in_array('administrator', $user->roles)) {
                $response['admin_user_exists'] = true;
            }
            
            $blog_public = get_option('blog_public');
            
            if ($blog_public === '0') {
                $response['disable_search_engine'] = true;
            }
            
            if (is_admin_bar_showing()) {
                $response['frontend_edit_enabled'] = true;
            }
            
            
            // Get the list of active plugins
            $active_plugins = get_option('active_plugins');
            
            // Check if any plugin is deactivated
            foreach ($all_plugins as $plugin_file => $plugin_data) {
                if (!in_array($plugin_file, $active_plugins)) {
                    $response['deactivated_plugins'] = true;
                    break;
                }
            }
            
            if(is_plugin_active('akismet/akismet.php')) {
                $response['akismet_plugin_activated'] = true;
            }
            
            $url = home_url('/wp-config.php');
            $headers = get_headers($url);
            
            if (strpos($headers[0], '403') || strpos($headers[0], '404')) {
                $response['protect_wp_config'] = true;
            }
            
            $url = home_url('/readme.html');
            $headers = get_headers($url);
            
            if (strpos($headers[0], '403') || strpos($headers[0], '404')) {
                $response['protect_readme_html'] = true;
            }
            
            $url = home_url('/install.php');
            $headers = get_headers($url);
            
            if (strpos($headers[0], '403') || strpos($headers[0], '404')) {
                $response['protect_install_php'] = true;
            }
            
            $directory_path = ABSPATH . 'wp-content/uploads';
            
            if(!opendir($directory_path)) {
                $response['disable_directory_access'] = true;
            }
            
            $response['disabled_debug_mode'] = defined('WP_DEBUG') && WP_DEBUG === false;
            
            
            $deactivated_themes = [];
            $all_themes = wp_get_themes();
            $active_theme = wp_get_theme()->get_stylesheet();
            
            foreach ($all_themes as $theme_name => $theme_obj) {
                if ($theme_name !== $active_theme) {
                    $deactivated_themes[] = $theme_obj->get('Name');
                }
            }
            
            
            if(count($deactivated_themes) > 0) {
                $response['deactivated_themes'] = true;
                $response['vulnerabilities'] = true;
            }
            
            $url = home_url('/upgrade.php');
            $headers = get_headers($url);
            
            if (strpos($headers[0], '403') || strpos($headers[0], '404')) {
                $response['protect_upgrade_php'] = true;
            }
            
            // Get the installed WordPress version
            $installed_version = get_bloginfo('version');
            
            // Fetch the latest version information from WordPress.org API
            $latest_version_data = file_get_contents('https://api.wordpress.org/core/version-check/1.7/');
            $latest_version_info = json_decode($latest_version_data, true);
            $latest_stable_version = $latest_version_info['offers'][0]['current'];
            
            if (version_compare($installed_version, $latest_stable_version, '>=')) {
                $response['stable_wordpress_version'] = true;
            }
            
            $response['wordpress_version_hide'] = !has_action('wp_head', 'wp_generator');

            // The ID of the post you want to check
            $post_id = 123; // Replace with the actual post ID
            
            // SQL query to check for revisions
            $query = "
                SELECT COUNT(*) 
                FROM {$wpdb->posts} 
                WHERE post_type = 'revision'
            ";
            
            $revision_count = $wpdb->get_var( $wpdb->prepare( $query ) );
            if(intval($revision_count) > 0) {
                $response['revision_posts'] = true;
            }
            
            $permalink_structure = $wp_rewrite->permalink_structure;
            if (strpos($permalink_structure, '%postname%') !== false) {
                $response['user_friendly_permalink'] = true;
            }
            
            // Query for pages with the title 'Sample Page'
            $args = array(
                'post_title' => 'Sample Page',
                'post_type'  => 'page',
                'posts_per_page' => 1
            );
            
            $query = new WP_Query( $args );
            
            // Check if the page exists
            if ( $query->have_posts() ) {
                $response['sample_page'] = true;
            }
            
            $args = array(
                'post_type' => 'post',           // We're looking for posts
                'post_title' => 'Hello World!',  // The default sample post title
                'posts_per_page' => 1            // Limit to 1 post
            );
            
            $query = new WP_Query( $args );
            
            if ( $query->have_posts() ) {
                $response['sample_post'] = true;
            }
            
            $args = array(
                'post_type'    => 'post',      // We're looking for comments on posts
                'number'       => 1,           // Limit to 1 comment
                'search'       => 'This is a sample comment',  // Search for a specific sample comment text
            );
            
            $comments = get_comments( $args );
            
            if ( ! empty( $comments ) ) {
                $response['sample_comment'] = true;
            }
            
        	return new WP_REST_Response(
    			array(
    				'status' => true,
    				'data' => $response
    			), 200
    		);
                
		}

		public function create_zip(WP_REST_Request $request) {
			$files = $request->get_param('data');
			$upload_folder_name = 'mvsp_uploads';
			if (!is_dir($upload_folder_name) && !file_exists($upload_folder_name)) {
				mkdir($upload_folder_name, 0777);
			}

			$output_dir = ABSPATH . 'mvsp_uploads';
			$source_directory = WP_CONTENT_DIR;
			$token = get_option('mvsp_auth_token');
			$zip_file_name = $token.'_' . time() . '.zip';
			$zip_destination = $output_dir . '/'.$zip_file_name;

			$zip_file = $this->create_chunk($files, $output_dir, $zip_destination,$source_directory, $zip_file_name);

			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => site_url() . '/mvsp_uploads/' . $zip_file
				), 200);
		}

		function create_chunk($files, $output_dir, $zip_destination,$source_directory, $zip_file_name) {
			require_once ABSPATH . 'wp-admin/includes/class-pclzip.php';
			$archive = new PclZip($zip_destination);
			$v_list = $archive->create($files, PCLZIP_OPT_REMOVE_PATH, $source_directory);

			if ($v_list == 0) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'error' => esc_html__($archive->errorInfo(true), 'wpsafe-ai-malware-protection')
					), 400);
			}

			return $zip_file_name;
		}

		public static function check_user_authenticated(WP_REST_Request $request){


			$header = $request->get_headers();

			// User verify using nonce
			if (!isset($header['nonce'][0]) || !wp_verify_nonce($header['nonce'][0], 'verify_user_authorized')) {
				return false;
			}

			// JWT Authentication with role
			$auth_header = $request->get_header('authorization');
			
			if (!$auth_header) {
				return false;
			}

			$token = get_option('mvsp_auth_token');

			// Extract token from "Bearer {token}"
			list(, $access_token) = explode(' ', $auth_header, 2);
			
			try {
				$get_user = JWT::decode($access_token, $token, array('HS256'));
			} catch (Exception $e) {
				return false;
			}
			
			

			// Check if the user is an administrator
			if (($get_user->role !== 'administrator') || !user_can($get_user->ID, 'manage_options')) {
				return new WP_REST_Response(
					array('status' => false, 'error' => 'Unauthorized access'),
					403
				);
			}

			// User verify using token
			if (isset($header['auth_token']) && count($header['auth_token']) > 0 && $header['auth_token'][0] !== '') {
				if ($header['auth_token'][0] === $token) {
					return true;
				}
			} else {
				return false;
			}
		}

		// Authentication
		public function authentication(WP_REST_Request $request)
		{
			$username = $request->get_param('username');
			$password = $request->get_param('password');

			// Validate credentials
			$user = wp_authenticate($username, $password);

			if (is_wp_error($user)) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'error' =>esc_html__('Authentication failed', 'wpsafe-ai-malware-protection')
					),401
				);
			}

			$user = new WP_User($username);
			$user_role_member = $user->roles[0];
			
			if (($user_role_member !== 'administrator') || (!user_can($user->ID, 'manage_options'))) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'error' => esc_html__('You don`t have permission.', 'wpsafe-ai-malware-protection')
					), 401);
			}
			
			
			// Generate hash token for authentication
			$token = get_option('mvsp_auth_token');

			if (!$token) {
				$token = MVSP_Generate_Token::generate_token($username.$password);
				MVSP_Store_Authorized_Token::store_token($token);
				MVSP_Store_Authorized_Token::set_autorized();
			}

			// Generate JWT Token with role
            $payload = [
                'iss' => get_site_url(),
                'iat' => time(),
                'exp' => time() + 3600, // Token expires in 1 hour
                'user_id' => $user->ID,
                'role' => $user_role_member
            ];
            
            $access_token = JWT::encode($payload, $token, 'HS256');

			$response = [
			    'access_token' => $access_token,
				'token' => $token,
				'nonce' => wp_create_nonce('verify_user_authorized'),
				'theme_uri' => wp_get_theme(get_option('stylesheet'))->get('ThemeURI'),
				'screenshot_url' => wp_get_theme(get_option('stylesheet'))->get_screenshot(),
				'site_info' => MVSP_WP_Info::return_website_info_json()
			];

			// Authentication successful
			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $response
				), 200);
		}

		public function export_db()
		{
			$db_url = MVSP_Export_DB::export_db();
			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => site_url() . '/' . $db_url
				), 200);
		}

		public function delete_exported_db(WP_REST_Request $request) {
			$filename = $request->get_param('filename');
			if (file_exists($filename)) {
				unlink($filename);
			}

			return new WP_REST_Response(
				array(
					'status' => true,
					'message' => esc_html__('Exported sql file deleted successfully.', 'wpsafe-ai-malware-protection')
				), 200);
		}

		public function get_plugin_files_hash($plugin_slug) {

			$hashes = [];

			if($plugin_slug === 'hello-dolly') {
				$plugin_file = ABSPATH . 'wp-content/plugins/hello.php';
				if (file_exists($plugin_file)) {
					$hashes['wp-content/plugins/hello.php'] = hash_file('md5', $plugin_file);
				} else {
					$plugin_dir = WP_CONTENT_DIR . '/plugins/'. $plugin_slug;
					if (is_dir($plugin_dir)) {
						$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($plugin_dir));
	
						$hashes = [];
		
						foreach ($iterator as $file) {
							if ($file->isFile()) {
								$filePath = $file->getPathname();
								$relativePath = str_replace(ABSPATH, '', $filePath);
								$root_path = pathinfo($relativePath, PATHINFO_DIRNAME);
								if (str_starts_with($root_path, 'wp-content') && str_contains($root_path, $plugin_slug)) {
									$hashes[$relativePath] = hash_file('md5', $filePath);
								}
							}
						}
					}
				}
			} else {

				if (strpos($plugin_slug, 'mu-plugins') !== false) {
					$plugin_file = ABSPATH . 'wp-content/'.$plugin_slug;
					$hashes['wp-content/'.$plugin_slug] = hash_file('md5', $plugin_file);
				} else {
					$plugin_dir = WP_CONTENT_DIR . '/plugins/'. $plugin_slug;
					if (is_dir($plugin_dir)) {
						$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($plugin_dir));
	
						$hashes = [];
		
						foreach ($iterator as $file) {
							if ($file->isFile()) {
								$filePath = $file->getPathname();
								$relativePath = str_replace(ABSPATH, '', $filePath);
								$root_path = pathinfo($relativePath, PATHINFO_DIRNAME);

								if (str_starts_with($root_path, 'wp-content') && str_contains($root_path, $plugin_slug)) {
									$hashes[$relativePath] = hash_file('md5', $filePath);
								}
							}
						}
					}
				}
			}

			return $hashes;
		}

		public function get_theme_files_hash($theme_slug) {
			$hashes = [];

			$theme_dir = WP_CONTENT_DIR . '/themes/'. $theme_slug;
			if (is_dir($theme_dir)) {
				$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($theme_dir));

				$hashes = [];

				foreach ($iterator as $file) {
					if ($file->isFile()) {
						$filePath = $file->getPathname();
						$relativePath = str_replace(ABSPATH, '', $filePath);
						$root_path = pathinfo($relativePath, PATHINFO_DIRNAME);

						if (str_starts_with($root_path, 'wp-content') && str_contains($root_path, $theme_slug)) {
							$hashes[$relativePath] = hash_file('md5', $filePath);
						}
					}
				}
			}

			return $hashes;
		}


		public function upload_hash_files($request) {
			$hashes = [];
			$files = $request->get_param('files');
			if(is_countable($files) && count($files) > 0) {
				foreach($files as $file) {
					if(file_exists($file)) {
						$relativePath = str_replace(ABSPATH, '', $file);

						$last_modified_time = filemtime($file); // Get last modified time
						$file_size_kb = filesize($file) / 1024; // Get file size in KB
						$file_hash = array(
							'hash' => hash_file('md5', $file),
							'last_modified_time' => gmdate("Y-m-d H:i:s", $last_modified_time),
							'file_size_kb' => round($file_size_kb, 2)
						);
						$hashes[$relativePath] = $file_hash;
					}
				}
				
				return new WP_REST_Response(
					array(
						'status' => true,
						'data' => $hashes
					), 200
				);
			}

			return new WP_REST_Response(
				array(
					'status' => false,
					'message' => 'Please provide valid files url.'
				), 400
			);
		}

		public function generate_core_hash($request) {
			$hashes = [];
			$files = $request->get_param('files');
			if(is_countable($files) && count($files) > 0) {
				foreach($files as $file) {
					if(file_exists($file)) {
						$relativePath = str_replace(ABSPATH, '', $file);
						$hashes[$relativePath] = hash_file('md5', $file);
					}
				}
				
				return new WP_REST_Response(
					array(
						'status' => true,
						'data' => $hashes
					), 200
				);
			}

			return new WP_REST_Response(
				array(
					'status' => false,
					'message' => 'Please provide valid files url.'
				), 400
			);

			// $hashes = [];
            // $excludedFiles = ['wp-config.php', '.htaccess'];
            // $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator(ABSPATH));
            
           
            
            // foreach ($files as $file) {
                 
            //     if ($file->isFile()) {
                    
            //         $filePath = $file->getPathname();
            //         $relativePath = str_replace(ABSPATH, '', $filePath);
            //         $rootPath = pathinfo($relativePath, PATHINFO_DIRNAME);
                    
                  
            //         // Exclude specific files
            //         if (in_array(pathinfo($relativePath, PATHINFO_BASENAME), $excludedFiles)) {
            //             continue;
            //         }
            
            //         // Exclude wp-content directory
            //         if (str_starts_with($rootPath, 'wp-admin')) {
            //             continue;
            //         }

            //         if (str_starts_with($rootPath, 'wp-content')) {
            //             continue;
            //         }
            //          if (str_starts_with($rootPath, 'wp-includes')) {
            //             continue;
            //         }
                    
                     
            //         // Exclude specific custom directories
            //         if (
            //             is_dir(ABSPATH . 'mvsp_plugin_zips') && str_starts_with($rootPath, 'mvsp_plugin_zips') ||
            //             is_dir(ABSPATH . 'mvsp_theme_zips') && str_starts_with($rootPath, 'mvsp_theme_zips') ||
            //             is_dir(ABSPATH . 'mvsp_uploads') && str_starts_with($rootPath, 'mvsp_uploads') ||
            //             is_dir(ABSPATH . 'deploy-wp') && str_starts_with($rootPath, 'deploy-wp')
            //         ) {
            //             continue;
            //         }
                    
                   
            
            //         // Skip folders that start with "staging"
            //         if (str_starts_with(basename($rootPath), 'staging')) {
            //             continue;
            //         }
            
              
            //         // Check if the current directory is wp-admin or wp-includes
            //         if (str_starts_with($rootPath, 'wp-admin') || str_starts_with($rootPath, 'wp-includes')) {
            //             continue;
            //         }
                    
                   
            
            //         $hashes[$relativePath] = hash_file('md5', $filePath);
            //     }
            // }
            
            // return $hashes;

		}

		public function wp_core_hash_files() {
		    
		    ini_set('max_execution_time', 0);
			$chunk_size = 50;
            $source_directory = ABSPATH;
            
            // Get all files in the source directory and its subdirectories
            $iterator = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($source_directory),
                RecursiveIteratorIterator::SELF_FIRST
            );
            
            $files = array();
            foreach ($iterator as $file) {
                if ($file->isFile()) {
                    $filepath = $file->getPathname();
            
                    // Exclude specific files
                    if (basename($filepath) === 'wp-config.php' || basename($filepath) === '.htaccess') {
                        continue;
                    }
            
                    // Exclude wp-content and other specified directories
                    if (strpos($filepath, '/wp-content/') !== false ||
                        strpos($filepath, '/mvsp_plugin_zips') !== false ||
                        strpos($filepath, '/mvsp_theme_zips') !== false ||
                        strpos($filepath, '/mvsp_uploads') !== false ||
                        strpos($filepath, '/deploy-wp') !== false) {
                        continue;
                    }
            
                    $files[] = $filepath;
                }
            }
            
            $current_chunk = array();
            $current_chunk_size = 0;
            
            $chunk_files_arr = [];
            foreach ($files as $file) {
                $file_size = filesize($file);
                $file_size_mb = $file_size / (1024 * 1024); // Convert to megabytes
                if (($current_chunk_size + $file_size_mb) > $chunk_size) {
                    $chunk_files_arr[] = $current_chunk;
                    $current_chunk = array();
                    $current_chunk_size = 0;
                }
            
                // Add the file to the current chunk
                $current_chunk[] = $file;
                $current_chunk_size += $file_size_mb;
            }
            
            if (!empty($current_chunk)) {
                $chunk_files_arr[] = $current_chunk;
            }
            
            return new WP_REST_Response(
                array(
                    'data' => $chunk_files_arr
                ), 200);

		}

		public function wp_plugin_hash_files(WP_REST_Request $request) {
			$plugin_slug = $request->get_param('slug');

			if (strpos($plugin_slug, 'mu-plugins') !== false) {
				$plugin_dir = WP_CONTENT_DIR .'/'. $plugin_slug;
			} else {
				$plugin_dir = WP_CONTENT_DIR . '/plugins/' . $plugin_slug;

				if ((!is_dir($plugin_dir) && !is_file($plugin_dir)) && $plugin_slug !== 'hello-dolly') {
					return new WP_REST_Response(
						array(
							'status' => false,
							'message' => 'The specified path is neither a directory nor a file.'
						), 400
					);
				}
			}

			$plugin_hash = $this->get_plugin_files_hash($plugin_slug);

			$plugin_data = [];
			$plugin_path = WP_PLUGIN_DIR . '/' . $plugin_slug . '/' . $plugin_slug . '.php';

			if($plugin_slug === 'hello-dolly') {
				$plugin_slug = 'hello-dolly';
			}

			if (file_exists($plugin_path)) {
				require_once(ABSPATH . 'wp-admin/includes/plugin.php');
				$plugin_data = get_plugin_data($plugin_path);

			} else {
				if (strpos($plugin_slug, 'mu-plugins') !== false) {
					$plugin_data['name'] = '';
					$plugin_data['slug'] = '';
					$plugin_data['version'] = '';
				} else {
					$plugin_information = wp_remote_get("https://api.wordpress.org/plugins/info/1.0/{$plugin_slug}.json");
					$plugin_information_response = json_decode($plugin_information['body'], true);
					if(!isset($plugin_information_response["error"])) {
						$plugin_data['name'] = $plugin_information_response['name'];
						$plugin_data['slug'] = $plugin_information_response['slug'];
						$plugin_data['version'] = $plugin_information_response['version'];
					}
				}
			}

			return new WP_REST_Response(
				array(
					'data' => array(
						$plugin_data,
						'checksums' => $plugin_hash
					)
				), 200);
		}

		public function get_theme_checksum(WP_REST_Request $request) {
			$theme_slug = $request->get_param('slug');

			$theme_dir = WP_CONTENT_DIR . '/themes/' . $theme_slug;

			if (!is_dir($theme_dir) && !is_file($theme_dir)) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => 'The specified path is neither a directory nor a file.'
					), 400
				);
			}

			$theme_hash = $this->get_theme_files_hash($theme_slug);

			$theme_data = [];
			$theme = wp_get_theme($theme_slug);
			if ($theme->exists()) {
				$theme_data['name'] = $theme->get('Name');
				$theme_data['version'] = $theme->get('Version');
			}

			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => array(
						$theme_data,
						'checksums' => $theme_hash
					)
				), 200);
		}

		public function get_initial_info() {
			$response = [
				'theme_uri' => wp_get_theme(get_option('stylesheet'))->get('ThemeURI'),
				'screenshot_url' => wp_get_theme(get_option('stylesheet'))->get_screenshot(),
				'site_info' => MVSP_WP_Info::return_website_info_json(),
			];

			// Authentication successful
			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $response
				), 200);
		}

		public function get_wp_config() {

			require_once ABSPATH . 'wp-config.php';
			require_once ABSPATH . 'wp-load.php';

			global $wpdb;
			global $table_prefix;
			$db_user = DB_USER;
			$db_pass = DB_PASSWORD;
			$db_name = DB_NAME;
			$db_host = DB_HOST;
			$db_table_prefix = $table_prefix;
			$auth_key = AUTH_KEY;
			$secure_auth_key = SECURE_AUTH_KEY;
			$logged_in_key = LOGGED_IN_KEY;
			$nonce_key = NONCE_KEY;
			$auth_salt_key = AUTH_SALT;
			$secure_auth_salt_key = SECURE_AUTH_SALT;
			$logged_in_salt_key = LOGGED_IN_SALT;
			$nonce_salt_key = NONCE_SALT;
			$wp_debug  = WP_DEBUG;

			$db_config = array(
				'db_user' => $db_user,
				'db_pass' => $db_pass,
				'db_name' => $db_name,
				'db_host' => $db_host,
				'db_table_prefix' => $db_table_prefix,
				'auth_key' => $auth_key,
				'secure_auth_key' => $secure_auth_key,
				'logged_in_key' => $logged_in_key,
				'nonce_key' => $nonce_key,
				'auth_salt_key' => $auth_salt_key,
				'secure_auth_salt_key' => $secure_auth_salt_key,
				'logged_in_salt_key' => $logged_in_salt_key,
				'nonce_salt_key' => $nonce_salt_key,
				'wp_debug' => $wp_debug
			);

			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $db_config
				), 200);
		}

		public function verifytoken(WP_REST_Request $request) {
			$token = $request->get_param('token');
			$site_url = $request->get_param('site_url');

			$saved_token = get_option('mvsp_auth_token');
			if (($token !== '' && $site_url !== '') && ($token === $saved_token && get_site_url())) {
				return new WP_REST_Response(
					array(
						'status' => true,
						'message' => esc_html__('Verified', 'wpsafe-ai-malware-protection')
					),
					200
				);
			} else {
				return new WP_REST_Response(
					array(
						'status' => false,
						'error' => esc_html__('This token not verified.', 'wpsafe-ai-malware-protection')
					),
					400
				);
			}
		}

		public function delete_file(WP_REST_Request $request) {
			$zip_file_name_with_folder = $request->get_param('file_name');

			if($zip_file_name_with_folder === NULL) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'error' => esc_html__('File name is required.', 'wpsafe-ai-malware-protection')
					),
					400
				);
			}
			if (file_exists(ABSPATH . $zip_file_name_with_folder)) {
				unlink(ABSPATH . $zip_file_name_with_folder);
			}

			return new WP_REST_Response(
				array(
					'status' => true,
					'message' => esc_html__('File is deleted successfully.', 'wpsafe-ai-malware-protection')
				), 200);
		}

		public function scan_uploads() {
			$infected_files = MVSP_Uploads_Scanner::check_uploads_folder_files();
			return new WP_REST_Response(
				array(
					'data' => $infected_files
				), 200);
		}

		public function scan_db() {
			$infected_db_content = MVSP_DB_Scanner::db_scan();
			return new WP_REST_Response(
				array(
					'data' => $infected_db_content
				), 200);
		}

		public function start_migrate(WP_REST_Request $request) {
			$token = get_option('mvsp_auth_token');

			$zip_file_link = $request->get_param('file_path');

			if($zip_file_link === NULL) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => esc_html__('File path is required.', 'wpsafe-ai-malware-protection')
					),
					400
				);
			}

			$header = $request->get_headers();

			if (isset($header['dir_name']) && $header['dir_name'][0] === '') {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => esc_html__('Directory name is required.', 'wpsafe-ai-malware-protection')
					),
					400
				);
			}

			$dir_name = $header['dir_name'][0];

			new MVSP_Deployment_Script($token, $zip_file_link, $dir_name);

			return new WP_REST_Response(
				array(
					'status' => true,
					'message' => 'Deployment script successfully deployed'
				), 200);
		}

		public function deleteDirectory($dir) {
			if (!file_exists($dir)) {
				return true;
			}

			if (!is_dir($dir)) {
				return unlink($dir);
			}

			foreach (scandir($dir) as $item) {
				if ($item == '.' || $item == '..') {
					continue;
				}

				if (!$this->deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
					return false;
				}
			}

			return rmdir($dir);
		}
		public function delete_deployment_script() {
			// Check if the folder exists
			$deployment_folder = ABSPATH . 'deploy-wp';
			if (is_dir($deployment_folder)) {
				// Attempt to delete the folder
				if ($this->deleteDirectory($deployment_folder)) {
					return new WP_REST_Response(
						array(
							'status' => true,
							'message' => __('Successfully removed the deployment script', 'wpsafe-ai-malware-protection')
						), 200);
				}
			}

			return new WP_REST_Response(
				array(
					'status' => false,
					'message' => __('Deployment script not found', 'wpsafe-ai-malware-protection')
				), 400);
		}

		public function send_upload_files() {
			$chunk_size = 50;
			$source_directory = wp_upload_dir()['basedir'];

			// Get all files in the source directory and its subdirectories
			$iterator = new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($source_directory),
				RecursiveIteratorIterator::SELF_FIRST
			);

			$files = array();
			foreach ($iterator as $file) {
				if ($file->isFile()) {
					$files[] = $file->getPathname();
				}
			}

			$current_chunk = array();
			$current_chunk_size = 0;

			$chunk_files_arr = [];
			foreach ($files as $file) {
				$file_size = filesize($file);
				$file_size_mb = $file_size / (1024 * 1024); // Convert to megabytes
				if (($current_chunk_size + $file_size_mb) > $chunk_size) {
					$chunk_files_arr[] = $current_chunk;
					$current_chunk = array();
					$current_chunk_size = 0;
				}

				// Add the file to the current chunk
				$current_chunk[] = $file;
				$current_chunk_size += $file_size_mb;
			}

			if (!empty($current_chunk)) {
				$chunk_files_arr[] = $current_chunk;
			}

			return new WP_REST_Response(
				array(
					'data' => $chunk_files_arr
				), 200);
		}

		public function create_theme_zip(WP_REST_Request $request) {
			$source_directory = WP_CONTENT_DIR;
			$theme_zip_folder_name = 'mvsp_theme_zips';
			if (!is_dir($theme_zip_folder_name)) {
				mkdir($theme_zip_folder_name, 0755);
			}

			$output_dir = ABSPATH . 'mvsp_theme_zips';
			$theme_name = $request->get_param('theme_name');
			$token = get_option('mvsp_auth_token');
			$zip_file_name = $token.'_' . time() . rand(1, 100) . '.zip';
			$zip_destination = $output_dir . '/'.$zip_file_name;

			$theme_directory = WP_CONTENT_DIR . '/themes/' . $theme_name;
			$files = $this->get_files_from_dir($theme_directory);
			$zip_file = $this->create_chunk($files, $output_dir, $zip_destination,$source_directory, $zip_file_name);
			sleep(0.01);
			return new WP_REST_Response(
				array(
					'data' => site_url() . '/mvsp_theme_zips/' . $zip_file
				), 200);
		}

		public function create_plugin_zip(WP_REST_Request $request) {
			$source_directory = WP_CONTENT_DIR;
			$plugin_zip_folder_name = 'mvsp_plugin_zips';
			if (!is_dir($plugin_zip_folder_name)) {
				mkdir($plugin_zip_folder_name, 0755);
			}

			$output_dir = ABSPATH . 'mvsp_plugin_zips';
			$plugin_name = $request->get_param('plugin_name');
			$token = get_option('mvsp_auth_token');
			$zip_file_name = $token.'_' . time() . rand(1, 100). '.zip';
			$zip_destination = $output_dir . '/'.$zip_file_name;

			$plugin_directory = WP_CONTENT_DIR . '/plugins/' . $plugin_name;

			if (strpos($plugin_name, 'mu-plugins') !== false) {
				$plugin_directory = WP_CONTENT_DIR .'/'. $plugin_name;
			}

			$files = $this->get_files_from_dir($plugin_directory);
			$zip_file = $this->create_chunk($files, $output_dir, $zip_destination,$source_directory, $zip_file_name);

			return new WP_REST_Response(
				array(
					'data' => site_url() . '/mvsp_plugin_zips/' . $zip_file
				), 200);
		}

        public function create_mu_plugin_zip(WP_REST_Request $request)
        {
            $source_directory = WP_CONTENT_DIR;
            $plugin_zip_folder_name = 'mvsp_mu_plugin_zips';
            if (!is_dir($plugin_zip_folder_name)) {
                mkdir($plugin_zip_folder_name, 0755);
            }

            $output_dir = ABSPATH . 'mvsp_mu_plugin_zips';
            $plugin_name = $request->get_param('plugin_name');
            $token = get_option('mvsp_auth_token');
            $zip_file_name = $token . '_' . time() . rand(1, 100) . '.zip';
            $zip_destination = $output_dir . '/' . $zip_file_name;

            $plugin_directory = WP_CONTENT_DIR . '/mu-plugins/' . $plugin_name;

            if (is_dir($plugin_name)){
                $files = $this->get_files_from_dir($plugin_directory);
            } else {
                $files = array($plugin_directory);
            }

            $zip_file = $this->create_chunk($files, $output_dir, $zip_destination,$source_directory, $zip_file_name);

            sleep(0.01);

            return new WP_REST_Response(
                array(
                    'data' => site_url() . '/mvsp_mu_plugin_zips/' . $zip_file
                ), 200);
        }

		public function disconnect_site(WP_REST_Request $request) {
			$token = get_option('mvsp_auth_token');
			$user_token = $request->get_header('x_user_token');

			if($token) {
				$url = 'https://api.wpsafe.ai/api/v1/sites/verify/';
				$response = wp_remote_post($url, array(
						'method' => 'POST',
						'headers' => array(
							'X-API-KEY' => $token,
							'Authorization' => 'Bearer '.$user_token
						),
					)
				);

				$response_body = wp_remote_retrieve_body($response);
				$response_data = json_decode($response_body, true);

				if (array_key_exists('status', $response_data) && !$response_data['status']) {
					return new WP_REST_Response(
						array(
							'status' => false,
							'message' => __('Token is not valid', 'wpsafe-ai-malware-protection')
						), 400);
				} else {
					delete_option('mvsp_auth_token');
					delete_option('mvsp_site_connected');
					return new WP_REST_Response(
						array(
							'status' => true,
							'message' => esc_html__('Site disconnected', 'wpsafe-ai-malware-protection')
						), 200);
				}
			} else {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => __('Token not found', 'wpsafe-ai-malware-protection')
					), 400);
			}
		}

		public function get_files_from_dir($dir): array
		{
			$files = array();

			if (is_dir($dir)){
                $iterator = new RecursiveIteratorIterator(
					new RecursiveDirectoryIterator($dir),
					RecursiveIteratorIterator::SELF_FIRST
				);
	
				foreach ($iterator as $file) {
					if ($file->isDir() && !$iterator->isDot()) {
						continue;
					} elseif ($file->isFile()) {
						$files[] = $file->getPathname();
					}
				}
            } else {
                $files = array($dir);
            }

			return $files;
		}

		public function checklists(){

			// Site checklists
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
			require_once ABSPATH . 'wp-load.php';
			require_once ABSPATH .'wp-admin/includes/update.php';

			$wp_version = get_bloginfo('version');
			$url = 'https://api.wordpress.org/core/version-check/1.7/';
			$response = wp_remote_get($url);
			$json = $response['body'];
			$obj = json_decode($json);
			$latest_version = $obj->offers[0]->current;

			$plugin_updates = get_plugin_updates();
			$core_updated = get_core_updates();
			$themes_updated = get_theme_updates();

			$checklists = array(
				'core_updated' => $this->check_wp_version_udpated(),
				'ssl' => is_ssl(),
				'xmlrpc_disabled' => extension_loaded('xmlrpc'),
				'file_editing_disabled' => defined('DISALLOW_FILE_EDIT') || (defined('DISALLOW_FILE_EDIT') && DISALLOW_FILE_EDIT),
				'hide_wordpress_version_number' => !get_option('blog_public', true),
				'php_error_reporting' => defined( 'WP_DEBUG' ) && WP_DEBUG,
				'login_url_masking' => $this->is_wp_login_url_changed(),
				'outdated_themes' => $this->get_outdated_themes(),
				'outdated_plugins' => $this->outdated_plugins_check(),
				'username_with_admin' => $this->check_admin_username(),
				'unique_database_table_prefix' => $this->is_secure_prefix(),
			);
			return new WP_REST_Response(
				array(
					'data' => $checklists
				), 200);
		}

		public function is_wp_login_url_changed() {
			// Default WordPress login URL
			$default_login_url = site_url('wp-login.php');

			// Get the current login URL
			$current_login_url = wp_login_url();

			// Check if the current login URL is different from the default login URL
			if ($default_login_url !== $current_login_url) {
				return true; // The login URL has been changed
			}

			// Additional checks for popular plugins that change the login URL

			// WPS Hide Login
			if (function_exists('wps_hide_login')) {
				$wps_login_url = home_url(get_option('whl_page', 'login'));
				if ($wps_login_url !== $default_login_url) {
					return true; // WPS Hide Login has changed the login URL
				}
			}

			// iThemes Security
			if (function_exists('itsec_get_secure_login_slug')) {
				$itsec_login_slug = itsec_get_secure_login_slug();
				$itsec_login_url = home_url($itsec_login_slug);
				if ($itsec_login_url !== $default_login_url) {
					return true; // iThemes Security has changed the login URL
				}
			}

			// Custom login URL through custom code or other plugins
			// Add additional checks here as needed

			return false; // The login URL has not been changed
		}

		// Check wordpress udpated
		public function check_wp_version_udpated() {
			// Ensure the version check data is up to date
			wp_version_check();

			// Get the current version and the latest version data
			global $wp_version;
			$update_info = get_site_transient('update_core');

			if (isset($update_info->updates) && !empty($update_info->updates)) {
				$latest_version = $update_info->updates[0]->current;
				if (version_compare($wp_version, $latest_version, '>=')) {
					return true;
				} else {
					return false;
				}
			}
		}

		// Check username admin found
		public function check_admin_username()
		{
			$admin_user = get_user_by('login', 'admin');

			if ($admin_user) {
				return true;
			}

			return false;
		}
		// Outdated plugins
		public function outdated_plugins_check() {
			// Get the list of plugins with available updates
			$plugin_updates = get_plugin_updates();
			$outdated_plugins_count = count($plugin_updates);

			return $outdated_plugins_count;
		}

		// Function to check if the prefix is secure
		public function is_secure_prefix() {
			global $wpdb;
			$prefix = $wpdb->prefix;
			// Define a regex pattern for a secure prefix
			// This pattern allows only letters, numbers, and underscores
			$pattern = '/^[a-zA-Z0-9_]+$/';

			// Check if the prefix matches the pattern
			if (!preg_match($pattern, $prefix)) {
				return false; // Prefix is not secure
			}

			// Check the length of the prefix (example: 1-30 characters)
			if (strlen($prefix) < 1 || strlen($prefix) > 30) {
				return false; // Prefix length is not secure
			}

			// Define a list of reserved SQL keywords (simplified list for this example)
			$reserved_keywords = [
				'SELECT', 'INSERT', 'UPDATE', 'DELETE', 'WHERE', 'DROP', 'TABLE', 'FROM', 'ALTER', 'CREATE'
			];

			// Check if the prefix contains any reserved SQL keyword
			foreach ($reserved_keywords as $keyword) {
				if (stripos($prefix, $keyword) !== false) {
					return false; // Prefix contains a reserved keyword
				}
			}

			return true; // Prefix is secure
		}

		public function get_outdated_themes() {
			// Ensure the theme update data is up to date
			wp_update_themes();

			// Get the list of themes
			$all_themes = wp_get_themes();
			$update_themes = get_site_transient('update_themes');

			$outdated_themes_count = 0;
			if (isset($update_themes->response) && !empty($update_themes->response)) {
				foreach ($all_themes as $theme) {
					if (isset($update_themes->response[$theme->get_stylesheet()])) {
						$outdated_themes_count++;
					}
				}
			}

			return $outdated_themes_count;
		}

		public function get_htaccess() {
			$token = get_option('mvsp_auth_token');
			$output_file = $token.'htaccess.txt';
			$file = fopen($output_file, 'w');

			$htaccess_files = ABSPATH . '.htaccess';

			if(file_exists($htaccess_files)) {
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $htaccess_files); // Changed to site_url() instead of $htaccess_files
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Skip SSL verification (if needed)
				$data = curl_exec($ch);
				curl_close($ch);

				$file_handle = fopen($output_file, 'w');

				if ($file_handle === false) {
					return new WP_REST_Response(
						array(
							'status' => false,
							'message' => __('Error: Unable to open file.', 'wpsafe-ai-malware-protection')
						), 400);
				} else {
					// Write data to the file
					if (fwrite($file_handle, $data) === false) {
						return new WP_REST_Response(
							array(
								'status' => false,
								'message' => __('Error: Unable to write to file.', 'wpsafe-ai-malware-protection')
							), 400);
					} else {
						return new WP_REST_Response(
							array(
								'status' => true,
								'data' => site_url() . '/'.$output_file,
							), 200);
					}

					// Close the file handle
					fclose($file_handle);
				}
			}

			return new WP_REST_Response(
				array(
					'status' => false,
					'message' => __('.htaccess file not found.', 'wpsafe-ai-malware-protection')
				), 400);
		}

		public function store_token(WP_REST_Request $request) {
			$token = $request->get_header('token');
			$user_token = $request->get_header('x_user_token');
			if($token) {
				// $url = 'https://api.wpsafe.ai/api/v1/sites/verify/';
				$url = 'https://centrally-wise-flounder.ngrok-free.app/api/v1/sites/verify/';
				$response = wp_remote_post( $url, array(
						'method' => 'POST',
						'headers' => array(
							'X-API-KEY' => $token,
							'Authorization' => 'Bearer '.$user_token
						),
					)
				);

				$response_body = wp_remote_retrieve_body($response);
				$response_data = json_decode($response_body, true);
				// var_dump($response_data); // Output the response body

				if ($response_data && array_key_exists('status', $response_data) && !$response_data['status']) {
					return new WP_REST_Response(
						array(
							'status' => false,
							'message' => __('Token is not valid', 'wpsafe-ai-malware-protection')
						), 400);
				} else {
					MVSP_Store_Authorized_Token::store_token($token);
					MVSP_Store_Authorized_Token::set_autorized();

					$response = [
						'theme_uri' => wp_get_theme(get_option('stylesheet'))->get('ThemeURI'),
						'screenshot_url' => wp_get_theme(get_option('stylesheet'))->get_screenshot(),
						'site_info' => MVSP_WP_Info::return_website_info_json(),
					];
					return new WP_REST_Response(
						array(
							'status' => true,
							'data' => $response
						), 200);
				}
			}

			return new WP_REST_Response(
				array(
					'status' => false,
					'message' => __('Please pass token.', 'wpsafe-ai-malware-protection')
				), 400);
		}

		public function update_plugin(WP_REST_Request $request) {
			$plugin_slug = $request->get_param('slug');
			$plugin_dir_name = $request->get_param('dir_name');
			$plugin_dir = WP_PLUGIN_DIR . '/'.$plugin_dir_name;
			$plugin_information = wp_remote_get("https://api.wordpress.org/plugins/info/1.0/{$plugin_slug}.json");
			$plugin_information_response = json_decode($plugin_information['body'], true);

			if (!is_dir($plugin_dir)) {
				return new WP_Error('plugin_not_found', 'The specified plugin does not exist.', array('status' => 404));
			}

			if(isset($plugin_information_response['download_link'])) {
				// Get all file names inside the directory
				$files = glob($plugin_dir . '/*');
				foreach ($files as $file) {
					if (is_file($file)) {
						unlink($file);
					}
				}

				$plugin_url = $plugin_information_response['download_link']; // URL to the updated plugin ZIP file

				// Check if the plugin is installed
				if (file_exists($plugin_dir)) {
					// Initialize cURL session
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $plugin_url);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

					// Execute cURL request
					$zip_content = curl_exec($ch);

					// Check for cURL errors
					if (curl_errno($ch)) {
						curl_close($ch);
						return new WP_Error('plugin_update_failed', 'Failed to download the plugin update.', array('status' => 500));
					}

					// Close cURL session
					curl_close($ch);

					// Create a temporary file
					$tmp_file = tempnam(sys_get_temp_dir(), 'plugin-update-');
					file_put_contents($tmp_file, $zip_content);

					// Include necessary WordPress file
					require_once ABSPATH . 'wp-admin/includes/file.php';
					require_once ABSPATH . 'wp-admin/includes/class-pclzip.php'; // Include PclZip class

					// Initialize PclZip
					$archive = new PclZip($tmp_file);

					// Extract files to WP_PLUGIN_DIR
					$result = $archive->extract(PCLZIP_OPT_PATH, WP_PLUGIN_DIR);

					// Check for errors
					if ($result == 0) {
						return new WP_Error('plugin_update_failed', 'Failed to unzip the plugin update.', array('status' => 500));
					}

					// Activate the updated plugin
					activate_plugin($plugin_slug);

					return rest_ensure_response(array('status' => true, 'message' => 'Plugin updated successfully!'));
				}
			}else {
				return rest_ensure_response(array('status' => true, 'message' => 'This is a premium plugin!'));
			}
		}

		public function update_theme(WP_REST_Request $request) {
			$theme_slug = $request->get_param('slug');
			$theme_dir_name = $request->get_param('dir_name');
			$theme_dir = get_theme_root() . '/' . $theme_dir_name;
			$theme_root_dir = get_theme_root();
			$theme_information = wp_remote_get("https://api.wordpress.org/themes/info/1.2/?action=theme_information&request[slug]={$theme_slug}");
			$theme_information_response = json_decode($theme_information['body'], true);

			if (!is_dir($theme_dir)) {
				return new WP_Error('theme_not_found', 'The specified theme does not exist.', array('status' => 404));
			}

			if (isset($theme_information_response['download_link'])) {
				// Get all file names inside the directory
				$files = glob($theme_dir . '/*');
				foreach ($files as $file) {
					if (is_file($file)) {
						unlink($file);
					}
				}

				$theme_url = $theme_information_response['download_link']; // URL to the updated theme ZIP file

				// Check if the theme is installed
				if (file_exists($theme_dir)) {
					// Initialize cURL session
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $theme_url);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

					// Execute cURL request
					$zip_content = curl_exec($ch);

					// Check for cURL errors
					if (curl_errno($ch)) {
						curl_close($ch);
						return new WP_Error('theme_update_failed', 'Failed to download the theme update.', array('status' => 500));
					}

					// Close cURL session
					curl_close($ch);

					// Create a temporary file
					$tmp_file = tempnam(sys_get_temp_dir(), 'theme-update-');
					file_put_contents($tmp_file, $zip_content);

					// Include necessary WordPress file
					require_once ABSPATH . 'wp-admin/includes/file.php';
					require_once ABSPATH . 'wp-admin/includes/class-pclzip.php'; // Include PclZip class

					// Initialize PclZip
					$archive = new PclZip($tmp_file);

					// Extract files to the theme directory
					$result = $archive->extract(PCLZIP_OPT_PATH, $theme_root_dir);

					// Check for errors
					if ($result == 0) {
						return new WP_Error('theme_update_failed', 'Failed to unzip the theme update.', array('status' => 500));
					}

					// Activate the updated theme
					switch_theme($theme_slug);

					return rest_ensure_response(array('status' => true, 'message' => 'Theme updated successfully!'));
				}
			} else {
				return rest_ensure_response(array('status' => true, 'message' => 'This is a premium theme!'));
			}

		}

		public function delete_plugin(WP_REST_Request $request) {
			$plugin_slug = $request->get_param('slug');
			$plugin_dir = $request->get_param('dir_name');

			if($plugin_dir === '') {
				return rest_ensure_response(array('status' => false, 'message' => 'Please provide plugin directory name.'));
			}

			if($plugin_slug === '') {
				return rest_ensure_response(array('status' => false, 'message' => 'Please provide plugin slug.'));
			}

			// $plugin_dir = ABSPATH . WP_CONTENT_DIRE
			$plugin_dir = WP_PLUGIN_DIR . '/'.$plugin_dir;

			if (file_exists($plugin_dir) && is_dir($plugin_dir)) {
				// Attempt to delete the folder
				$files = glob($plugin_dir . '/*');
				foreach ($files as $file) {
					if (is_file($file)) {
						unlink($file);
					}
				}
				
				rmdir($plugin_dir);

				return rest_ensure_response(array('status' => true, 'message' => 'Plugin deleted successfully!'));
			}
			
			return rest_ensure_response(array('status' => false, 'message' => 'This plugin not found please check your site!'));
		}

		public function active_plugin(WP_REST_Request $request) {
			$plugin_slug = $request->get_param('slug');
			$plugins = get_option('active_plugins');
			$key = array_search($plugin_slug, $plugins);
			if ($key !== false) {
				return rest_ensure_response(array('status' => false, 'message' => 'Plugin already activated!'));
			}

			$plugins[] = $plugin_slug;
			update_option('active_plugins', $plugins);

			return rest_ensure_response(array('status' => true, 'message' => 'Plugin activated successfully!'));
		}

		public function deactive_plugin(WP_REST_Request $request) {
			$plugin_slug = $request->get_param('slug');
			$plugins = get_option('active_plugins');
			$key = array_search($plugin_slug, $plugins);
			if ($key !== false) {
				unset($plugins[$key]);
				update_option('active_plugins', $plugins);
				return rest_ensure_response(array('status' => true, 'message' => 'Plugin deactivated successfully!'));
			}
			
			return rest_ensure_response(array('status' => false, 'message' => 'This plugin found please install manually!'));
		}

		// Active Deactive Delete theme
		public function switch_theme_by_slug(WP_REST_Request $request) {
			// Check if the theme exists
			$theme_slug = $request->get_param('slug');
			if (wp_get_theme($theme_slug)->exists()) {
				// Switch to the theme
				switch_theme($theme_slug);
				return rest_ensure_response(array('status' => true, 'message' => 'Theme activated successfully.'));
			} else {
				return rest_ensure_response(array('status' => true, 'message' => 'Theme does not exist.'));
			}
		}

		// Function to delete a theme by slug
		public function delete_theme_by_slug(WP_REST_Request $request) {
			// Get the theme directory
			$theme_slug = $request->get_param('slug');
			$theme = wp_get_theme($theme_slug);
			if ($theme->exists()) {
				$theme_dir = $theme->get_stylesheet_directory();
				// Recursively delete the theme directory
				if ($this->delete_directory($theme_dir)) {
					return rest_ensure_response(array('status' => true, 'message' => 'Theme deleted successfully.'));
				} else {
					return rest_ensure_response(array('status' => false, 'message' => 'Failed to delete theme.'));
				}
			} else {
				return rest_ensure_response(array('status' => false, 'message' => 'Theme does not exist.'));
			}
		}

		// Helper function to delete a directory recursively
		public function delete_directory($dir) {
			if (!file_exists($dir)) {
				return true;
			}

			if (!is_dir($dir)) {
				return unlink($dir);
			}

			foreach (scandir($dir) as $item) {
				if ($item == '.' || $item == '..') {
					continue;
				}

				if (!$this->delete_directory($dir . DIRECTORY_SEPARATOR . $item)) {
					return false;
				}
			}

			return rmdir($dir);
		}

		public function plugins_list() {
			$response = [MVSP_Plugins_List_Info::plugins()];
			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $response
				), 200);
		}

		public function themes_list() {
			$response = [MVSP_Themes_List::themes_list()];
			return new WP_REST_Response(
				array(
					'status' => true,
					'data' => $response
				), 200);
		}

		public function delete_files(WP_REST_Request $request) {
			$files = $request->get_param('files');

			if (!is_array($files) || count($files) < 1) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => __('The files variable is either not an array or it is empty.', 'wpsafe-ai-malware-protection')
					), 400
				);
			}

			foreach ($files as $key => $item) {
				// Get the absolute path
				$path = ABSPATH . $item;
				// Check if the item exists
				if (file_exists($path)) {
					// Check if it's a file and delete it
					if (is_file($path)) {
						if (unlink($path)) {
							unset($files[$key]);
						}
					} elseif (is_dir($path)) {
						if ($this->deleteDirectory($path)) {
							unset($files[$key]);
						}
					}
				}
			}

			if (count($files) > 0) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => __('Those files does not exist: ' . implode(', ', $files), 'wpsafe-ai-malware-protection')
					), 400
				);
			} else {
				return new WP_REST_Response(
					array(
						'status' => true,
						'message' => __('All files are deleted successfully.', 'wpsafe-ai-malware-protection')
					), 200
				);
			}
		}
	}

	new MVSP_Rest_Api();
