<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-store-authorized-token.php';
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-templates.php';
	class MVSP_Register_Menu {
		public static bool $token = false;
		public static bool $authorized = false;
		public function __construct()
		{
			MVSP_Register_Menu::$token = get_option('mvsp_auth_token');
			MVSP_Register_Menu::$authorized = get_option('mvsp_site_connected');
			add_action( 'admin_menu', [$this, 'register_menu'] );
		}

		public function register_menu() {
			$menu_slug = 'malware-virus-scanner';
			$add_site_menu_slug = 'safe-ai-malware-connect';
			add_menu_page( esc_html__('WPSafe.AI', 'wpsafe-ai-malware-protection'), esc_html__('WPSafe.AI', 'wpsafe-ai-malware-protection'), 'read', $add_site_menu_slug, false );
			add_submenu_page( $add_site_menu_slug, esc_html__('Connect site', 'wpsafe-ai-malware-protection'), esc_html__('Connect site', 'wpsafe-ai-malware-protection'), 'manage_options', $add_site_menu_slug, [$this, 'site_add'] );
			// add_submenu_page( $add_site_menu_slug, esc_html__('Report', 'wpsafe-ai-malware-protection'), esc_html__('Report', 'wpsafe-ai-malware-protection'), 'manage_options', 'malware-virus-scanner-site-report', [$this, 'site_report'] );
		}

		public function site_add() {
			$wp_site_token = get_option('mvsp_auth_token');

			if((isset($_GET['authorized']) && $_GET['authorized'] === 'true') && (isset($_GET['token']) && $_GET['token'] === $wp_site_token)) {
				add_option('mvsp_site_connected', true);
				MVSP_Register_Menu::$authorized = get_option('mvsp_site_connected');
			}

			if((isset($_GET['authorized']) && $_GET['authorized'] === 'false') && (isset($_GET['token']) && $_GET['token'] === $wp_site_token)) {
				delete_option('mvsp_auth_token');
			}

			MVSP_Templates::menu_add_site(MVSP_Register_Menu::$authorized, MVSP_Register_Menu::$token);
		}

		public function site_report() { ?>
            <div class="mvsp_site_report">
                <iframe src="https://malware-virus-scanner-frontend.vercel.app/scan/info?site=siteId-or-something-like-hash" title="Site report"></iframe>
            </div>
		<?php }
	}

	new MVSP_Register_Menu();