<?php
	class MVSP_Encryption {
		public static function generate_encrypted_token($secret_key, $data) {
			// Derive a key using PBKDF2
			$salt = random_bytes(256);
			$key = hash_pbkdf2('sha256', $secret_key, $salt, 100000, 32, true);

			// Generate a random IV (Initialization Vector)
			$iv = random_bytes(openssl_cipher_iv_length('aes-256-cfb'));

			// Encrypt the data
			$cipherText = openssl_encrypt($data, 'aes-256-cfb', $key, 0, $iv);

			// Combine the salt, IV, and ciphertext into the final token
			$encodedToken = base64_encode($salt . $iv . $cipherText);

			return $encodedToken;
		}
		public static function decrypt_token($secret_key, $encodedToken) {
			// Decode the token
			$decodedToken = base64_decode($encodedToken);

			// Extract salt, IV, and ciphertext
			$salt = substr($decodedToken, 0, 256);
			$iv = substr($decodedToken, 256, openssl_cipher_iv_length('aes-256-cfb'));
			$cipherText = substr($decodedToken, 256 + openssl_cipher_iv_length('aes-256-cfb'));

			// Derive the key using PBKDF2
			$key = hash_pbkdf2('sha256', $secret_key, $salt, 100000, 32, true);

			// Decrypt the data
			$data = openssl_decrypt($cipherText, 'aes-256-cfb', $key, 0, $iv);

			return $data;
		}
		
		public static function decrypt_file($inputFile, $outputFile, $token) {
			$data = file_get_contents($inputFile);
			$ivLength = openssl_cipher_iv_length('aes-256-cbc');
			$iv = substr($data, 0, $ivLength);
			$encryptedData = substr($data, $ivLength);
			$decryptedData = openssl_decrypt($encryptedData, 'aes-256-cbc', $token, 0, $iv);
			file_put_contents($outputFile, $decryptedData);
		}

		public static function download_file($url) {
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$data = curl_exec($ch);
			curl_close($ch);

			return $data;
		}
	}