<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
// Check php version for wordpress

class MVSP_Check_PHP {
    public static function wp_check_php_version() {
        $version = PHP_VERSION;
        $key     = md5( $version );
    
        $response = get_site_transient( 'php_check_' . $key );
    
        if ( false === $response ) {
            $url = 'http://api.wordpress.org/core/serve-happy/1.0/';
    
            if ( wp_http_supports( array( 'ssl' ) ) ) {
                $url = set_url_scheme( $url, 'https' );
            }
    
            $url = add_query_arg( 'php_version', $version, $url );
    
            $response = wp_remote_get( $url );
    
            if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
                return false;
            }
    
            $response = json_decode( wp_remote_retrieve_body( $response ), true );
    
            if ( ! is_array( $response ) ) {
                return false;
            }
    
            set_site_transient( 'php_check_' . $key, $response, WEEK_IN_SECONDS );
        }
    
        if ( isset( $response['is_acceptable'] ) && $response['is_acceptable'] ) {
            /**
             * Filters whether the active PHP version is considered acceptable by WordPress.
             *
             * Returning false will trigger a PHP version warning to show up in the admin dashboard to administrators.
             *
             * This filter is only run if the wordpress.org Serve Happy API considers the PHP version acceptable, ensuring
             * that this filter can only make this check stricter, but not loosen it.
             *
             * @since 5.1.1
             *
             * @param bool   $is_acceptable Whether the PHP version is considered acceptable. Default true.
             * @param string $version       PHP version checked.
             */
            $response['is_acceptable'] = (bool) apply_filters( 'wp_is_php_version_acceptable', true, $version );
        }
    
        $response['is_lower_than_future_minimum'] = false;
    
        // The minimum supported PHP version will be updated to 7.2. Check if the current version is lower.
        if ( version_compare( $version, '7.2', '<' ) ) {
            $response['is_lower_than_future_minimum'] = true;
    
            // Force showing of warnings.
            $response['is_acceptable'] = false;
        }
    
        return $response;
    }
}

new MVSP_Check_PHP();