<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-store-authorized-token.php';
	class MVSP_Ajax {
		public function __construct() {
			add_action( 'wp_ajax_generate_store_token', [$this, 'generate_store_token'] );
			add_action( 'wp_ajax_nopriv_generate_store_token', [$this, 'generate_store_token'] );

			add_action( 'wp_ajax_disconnect_site', [$this, 'disconnect_site'] );
			add_action( 'wp_ajax_nopriv_disconnect_site', [$this, 'disconnect_site'] );
		}

		public function generate_store_token() {
			$nonce = $_POST['nonce'];
			if ( ! wp_verify_nonce( $nonce, 'mvsp_nonce' ) ) {
				$return = array(
					'status' => false,
					'message'  => esc_html__('Unauthorized user', 'wpsafe-ai-malware-protection'),
				);

				wp_send_json($return);
			}

			if(isset($_POST['token']) && $_POST['token'] !== '') {
				$token = MVSP_Store_Authorized_Token::store_token($_POST['token']);
				$return = array(
					'status' => true,
					'data'  => $token,
				);

				wp_send_json($return);
			}
		}

		public function disconnect_site() {
			$nonce = $_POST['nonce'];
			if ( ! wp_verify_nonce( $nonce, 'mvsp_nonce' ) ) {
				$return = array(
					'status' => false,
					'message' => esc_html__('Unauthorized user', 'wpsafe-ai-malware-protection'),
				);

				wp_send_json($return);
			}
			$disconnect_url = getenv('DISCONNECT_URL') ? getenv('DISCONNECT_URL') : 'https://app.wpsafe.ai';
			$auth_token = get_option('mvsp_auth_token');
			$response = wp_remote_post( $disconnect_url, array(
					'method' => 'POST',
					'blocking' => true,
					'headers' => array(
						'Auth-Token' => $auth_token
					),
				)
			);

			if ( is_wp_error( $response ) ) {
				$return = array(
					'status' => false,
					'message' => esc_html__('Something went wrong', 'wpsafe-ai-malware-protection'),
				);

				wp_send_json($return);
			} else {
				delete_option('mvsp_auth_token');
				delete_option('mvsp_site_connected');
			}

			$return = array(
				'status'  => true,
			);

			wp_send_json($return);
		}
	}

	new MVSP_Ajax();