<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://boomdevs.com
 * @since      1.0.0
 *
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/includes
 * @author     BoomDevs <contact@boomdevs.com>
 */
class Malware_Virus_Scanner_Plugin_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'malware-virus-scanner-plugin',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
