<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://boomdevs.com
 * @since      1.0.0
 *
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/includes
 * @author     BoomDevs <contact@boomdevs.com>
 */
class Malware_Virus_Scanner_Plugin_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		$disconnect_url = getenv('DISCONNECT_URL') ? getenv('DISCONNECT_URL') : 'https://app.wpsafe.ai';
		$auth_token = get_option('mvsp_auth_token');

		if($auth_token) {
			$response = wp_remote_post( $disconnect_url, array(
					'method' => 'POST',
					'blocking' => true,
					'headers' => array(
						'Auth-Token' => $auth_token
					),
				)
			);

			if ( !is_wp_error( $response ) ) {
				delete_option('mvsp_auth_token');
				delete_option('mvsp_site_connected');
			}
		}
	}
}
