<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	class MVSP_Deployment_Script {
		public function __construct($dynamicToken, $zip_file_link, $dir_name) {
			$directory = ABSPATH . 'deploy-wp';
			$php_ini_file = ABSPATH . '/php.ini';

			// Check if the directory exists, if not create it
			if (!is_dir($directory) && !file_exists($directory)) {
				mkdir($directory, 0755, true);
			}

			if (!file_exists($php_ini_file)) {
				$content = 'disable_functions = ""';
				file_put_contents($php_ini_file, $content);
			}

			$config = "
				<IfModule mod_rewrite.c>
				    RewriteEngine On
				    RewriteCond %{HTTP:X-Token} !^{$dynamicToken}
				    RewriteRule ^ - [F]
				</IfModule>
			";

			// Save the configuration block to .htaccess file
			$file = fopen($directory . '/'.'.htaccess', 'w');
			fwrite($file, $config);
			fclose($file);

			$this->download_deployment_script($dynamicToken, $directory, $zip_file_link, $dir_name);
		}

		public function download_deployment_script($token, $directory, $zip_file_link, $dir_name) {
			$tempZipFile = tempnam(sys_get_temp_dir(), 'downloaded_zip_');
			$ch = curl_init($zip_file_link);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			// Set the token in the header
			$headers = array(
				'Auth-Token: '.$token, // Replace 'your_token_here' with your actual token
				'X-Dir-Name: '.$dir_name
			);

			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			$data = curl_exec($ch);

			// Check for cURL errors
			if (curl_errno($ch)) {
				return new WP_REST_Response(
					array(
						'status' => false,
						'message' => 'Failed to download file.'
					), 400);
			} else {
				require_once ABSPATH . 'wp-admin/includes/class-pclzip.php';
				file_put_contents($tempZipFile, $data);
				$zip = new PclZip($tempZipFile);
				$extractResult = $zip->extract(PCLZIP_OPT_PATH, $directory);

				if ($extractResult == 0) {
					return new WP_REST_Response(
						array(
							'status' => false,
							'message' => 'Failed to extract ZIP file.'
						), 400);
				}
				unlink($tempZipFile);
			}

			// Close cURL resource
			curl_close($ch);

			$source_folder = $directory . '/wp-site-deployment-master';
			$this->move_folder_contents($source_folder, $directory);

			return new WP_REST_Response(
				array(
					'status' => true,
					'message' => 'ZIP file extracted successfully.'
				), 200);
		}

		public function move_folder_contents($sourceFolder, $destinationFolder) {
			// Get the list of files and directories in the source folder
			$items = scandir($sourceFolder);

			// Loop through each item
			foreach ($items as $item) {
				// Skip special directories (current and parent)
				if ($item == '.' || $item == '..') {
					continue;
				}

				// Build the full paths for the source and destination
				$sourcePath = $sourceFolder . '/' . $item;
				$destinationPath = $destinationFolder . '/' . $item;

				// Check if the item is a file or a directory
				if (is_file($sourcePath)) {
					// If it's a file, move it to the destination folder
					rename($sourcePath, $destinationPath);
				} elseif (is_dir($sourcePath)) {
					// If it's a directory, create the directory in the destination folder
					mkdir($destinationPath);

					// Recursively move the contents of the subfolder
					$this->move_folder_contents($sourcePath, $destinationPath);

					// Remove the empty source directory
					rmdir($sourcePath);
				}
			}
		}
	}