<?php
	if (!defined('ABSPATH')) {
		die("What you are doing here man.");
	}
	
	class MVSP_Plugins_Info {

		public static function plugins_info($plugins) {
			$plugins_info = [];
			$plugin_info = get_site_transient( 'update_plugins' );
			foreach ($plugins as $plugin_file => $plugin_data) {
				$plugin_slug = sanitize_title($plugin_data['Name']);

				if ( isset( $plugin_info->response[ $plugin_file ] ) ) {
					$plugin_data = array_merge( (array) $plugin_info->response[ $plugin_file ], array( 'update-supported' => true ), $plugin_data );
				} elseif ( isset( $plugin_info->no_update[ $plugin_file ] ) ) {
					$plugin_data = array_merge( (array) $plugin_info->no_update[ $plugin_file ], array( 'update-supported' => true ), $plugin_data );
				} elseif ( empty( $plugin_data['update-supported'] ) ) {
					$plugin_data['update-supported'] = false;
				}

				$filter_payload = array(
					'Name'          => $plugin_data['Name'],
					'slug'          => '',
					'PluginURI'     => '',
					'Version'       => '',
					'Description'   => '',
					'Author'        => '',
					'AuthorURI'     => '',
					'TextDomain'    => '',
					'DomainPath'    => '',
					'Network'       => '',
					'RequiresWP'    => '',
					'RequiresPHP'   => '',
					'UpdateURI'     => '',
					'Title'         => '',
					'AuthorName'    => ''
				);

				$plugin_data = (object) wp_parse_args( $plugin_data, $filter_payload );

				if($plugin_data->slug === '') {
					$plugin_data->slug = $plugin_slug;
				}

				$plugin_information = wp_remote_get("https://api.wordpress.org/plugins/info/1.0/{$plugin_data->slug}.json");
				$plugin_information_response = json_decode($plugin_information['body'], true);

				$plugin_folder = dirname($plugin_file);

				$download_link = null;
				if(isset($plugin_information_response['download_link'])) {
					$plugin_data->download_link = $plugin_information_response['download_link'];
					$plugin_data->folder_name = $plugin_folder;
					$plugins_info[] = $plugin_data;
				} else {
					$plugin_data->download_link = $download_link;
					$plugin_data->folder_name = $plugin_folder;
					$plugins_info[] = $plugin_data;
				}

				if($plugin_data->slug === 'hello-dolly') {
					$plugin_data->folder_name = 'hello-dolly';
				}
			}
			return $plugins_info;
		}

		public static function get_plugins_mu() {

			$wp_plugins   = array();
			$plugin_files = array();

			if ( ! is_dir( WPMU_PLUGIN_DIR ) ) {
				return $wp_plugins;
			}

			// Files in wp-content/mu-plugins directory.
			$plugins_dir = @opendir( WPMU_PLUGIN_DIR );
			if ( $plugins_dir ) {
				while ( ( $file = readdir( $plugins_dir ) ) !== false ) {
					if ( str_ends_with( $file, '.php' ) ) {
						$plugin_files[] = $file;
					}
				}
			} else {
				return $wp_plugins;
			}

			closedir( $plugins_dir );

			if ( empty( $plugin_files ) ) {
				return $wp_plugins;
			}

			foreach ( $plugin_files as $plugin_file ) {
				if ( ! is_readable( WPMU_PLUGIN_DIR . "/$plugin_file" ) ) {
					continue;
				}

				// Do not apply markup/translate as it will be cached.
				$plugin_data = get_plugin_data( WPMU_PLUGIN_DIR . "/$plugin_file", false, false );

				if ( empty( $plugin_data['Name'] ) ) {
					$plugin_data['Name'] = $plugin_file;
				}
				// $plugin_data->folder_name = $plugin_file;
				// Add the folder name to the plugin data
				$plugin_data['folder_name'] = $plugin_file;
				$plugin_data['slug'] = $plugin_file;
				$plugin_data['mu_plugins'] = true;

				$wp_plugins[] = $plugin_data;
			}
			
			uasort( $wp_plugins, '_sort_uname_callback' );

			return $wp_plugins;
		}

		public static function strcontains($main_string, $sub_string) {
			// Split the substring by hyphen
			$sub_parts = explode("-", $sub_string);
		
			// Check each part
			foreach ($sub_parts as $part) {
				if (stripos($main_string, $part) === false) {
					return false;
				}
			}
			return true;
		}

        public static function mu_plugins_info($plugin_slug) {
            // Define the directory to scan
            $directory = WP_CONTENT_DIR . '/mu-plugins';

            // Initialize an array to hold the names
            $items = [];

            // Check if the directory exists
            if (is_dir($directory)) {
                // Scan the directory
                $files_and_folders = scandir($directory);

                // Loop through the results
                foreach ($files_and_folders as $item) {
                    // Skip the current and parent directory links
                    if ($item == '.' || $item == '..') {
                        continue;
                    }

                    // Check if it's a file or a folder
                    $full_path = $directory . '/' . $item;
                    if (is_dir($full_path) || is_file($full_path)) {
						$main_string = $item;
						$sub_string = $plugin_slug;

						if (MVSP_Plugins_Info::strcontains($main_string, $sub_string)) {
							// Add the item to the array
							$items[] = $item;
						}
                    }
                }
            } else {
                return "The specified directory does not exist.";
            }

            // Return the array of items
            return $items;
        }
	}