(function( $ ) {
	'use strict';
	$(document).on("click", "#mvspConnectSite", function(){
		$('.mvsp_loader_wrapper').css('display', 'flex');

		$.ajax({
			type : "POST",
			url : mvsp_object.ajaxurl,
			data : {
				nonce: mvsp_object.mvsp_nonce,
				action: "generate_store_token",
				token: mvsp_object.token,
			},
			success: function(response) {
				if(response.data) {
					$('#mvspToken').val(response.data);
					$("#mvspSiteConnectForm").submit();
					$('#mvspUserEmail').prop( "disabled", true );
				}
			},
			error: function (xhr, status, error) {
				$('.mvsp_loader_wrapper').css('display', 'none');
				$('#mvspUserEmail').prop( "disabled", false );
			}
		});
	});

	$(document).on("click", "#disConnectSite", function(){
		$('.mvsp_loader_wrapper').css('display', 'flex');
		console.log(mvsp_object.mvsp_nonce)
		$.ajax({
			type : "POST",
			url : mvsp_object.ajaxurl,
			data : {
				nonce: mvsp_object.mvsp_nonce,
				// nonce: '7d8961213d1d',
				action: "disconnect_site",
			},
			success: function(response) {
				if(response.status) {
					window.location.href = "/wp-admin/?page=malware-virus-scanner-site-connect";
				} else  {
					$('.mvsp_loader_wrapper').css('display', 'none');
					$.toast({
						heading: 'Error',
						text: response.message,
						showHideTransition: 'fade',
						icon: 'error',
						position: {
							right: 10,
							top: 40
						},
					})
				}
			}
		});
	});
})( jQuery );
