<?php
	require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-mvsp-generate-token.php';
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://boomdevs.com
 * @since      1.0.0
 *
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Malware_Virus_Scanner_Plugin
 * @subpackage Malware_Virus_Scanner_Plugin/admin
 * @author     BoomDevs <contact@boomdevs.com>
 */
class Malware_Virus_Scanner_Plugin_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Malware_Virus_Scanner_Plugin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Malware_Virus_Scanner_Plugin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name . '-toast', plugin_dir_url( __FILE__ ) . 'css/jquery.toast.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/malware-virus-scanner-plugin-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Malware_Virus_Scanner_Plugin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Malware_Virus_Scanner_Plugin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$authorized = get_option('mvsp_site_connected');
		$current_user = wp_get_current_user();
		wp_enqueue_script( $this->plugin_name . '-toast', plugin_dir_url( __FILE__ ) . 'js/jquery.toast.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/malware-virus-scanner-plugin-admin.js', array( 'jquery' ), $this->version, false );
		$token = MVSP_Generate_Token::generate_token($current_user->display_name . $current_user->ID);
		wp_localize_script( $this->plugin_name, 'mvsp_object',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'token' => $token,
				'mvsp_nonce' => wp_create_nonce('mvsp_nonce'),
				'username' => $current_user->display_name,
				'userid' => $current_user->ID,
				'authorized' => $authorized,
			)
		);
	}
}
