<?php
// @codingStandardsIgnoreFile
/**
 * Menu page for the s2Member plugin (Restriction Options page).
 *
 * Copyright: © 2009-2011
 * {@link http://websharks-inc.com/ WebSharks, Inc.}
 * (coded in the USA)
 *
 * Released under the terms of the GNU General Public License.
 * You should have received a copy of the GNU General Public License,
 * along with this software. In the main directory, see: /licensing/
 * If not, see: {@link http://www.gnu.org/licenses/}.
 *
 * @package s2Member\Menu_Pages
 * @since 3.0
 */
if(!defined('WPINC')) // MUST have WordPress.
	exit ("Do not access this file directly.");

if(!class_exists("c_ws_plugin__s2member_menu_page_res_ops"))
{
	/**
	 * Menu page for the s2Member plugin (Restriction Options page).
	 *
	 * @package s2Member\Menu_Pages
	 * @since 110531
	 */
	class c_ws_plugin__s2member_menu_page_res_ops
	{
		public function __construct()
		{
			echo '<div class="wrap ws-menu-page">'."\n";

			echo '<div class="wp-header-end"></div>'."\n";

			echo '<div class="ws-menu-page-toolbox">'."\n";
			c_ws_plugin__s2member_menu_pages_tb::display();
			echo '</div>'."\n";

			echo '<h2>Restriction Options</h2>'."\n";

			echo '<table class="ws-menu-page-table">'."\n";
			echo '<tbody class="ws-menu-page-table-tbody">'."\n";
			echo '<tr class="ws-menu-page-table-tr">'."\n";
			echo '<td class="ws-menu-page-table-l">'."\n";

			do_action("ws_plugin__s2member_during_res_ops_page_before_left_sections_form", get_defined_vars());

			echo '<form method="post" name="ws_plugin__s2member_options_form" id="ws-plugin--s2member-options-form" autocomplete="off">'."\n";
			echo '<input type="hidden" name="ws_plugin__s2member_options_save" id="ws-plugin--s2member-options-save" value="'.esc_attr(wp_create_nonce("ws-plugin--s2member-options-save")).'" />'."\n";
			echo '<input type="hidden" name="ws_plugin__s2member_configured" id="ws-plugin--s2member-configured" value="1" />'."\n";

			do_action("ws_plugin__s2member_during_res_ops_page_before_left_sections", get_defined_vars());

			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_post_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_post_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Post Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-post-level-access-section">'."\n";
				echo '<h3>Post Level Access Restrictions (optional)</h3>'."\n";
				echo '<p>Here you can specify Posts that are restricted to certain Membership Access Levels. s2Member also supports Custom <a href="https://s2member.com/r/wordpress-codex-post-types/" target="_blank" rel="external">Post Types</a> here. If you have a theme or plugin installed, which has enabled Custom Post Types <em>(i.e., Music/Videos or something else)</em>, you can put the IDs for those Posts here.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> Post IDs in comma-delimited format. Example: <code>1,2,3,84,8,21</code>. Or, you can type: <code>all</code> <em>(to protect all Posts, of any type)</em>. You can also include all Post IDs of a specific <a href="https://s2member.com/r/wordpress-codex-post-types/" target="_blank" rel="external">Post Type</a>. e.g., <code>1,2,3,all-newspapers</code> <em>(protects several Post IDs, and all Posts of type: <code>newspaper</code>)</em>.</p>'."\n";
				echo '<p><em><strong>Note:</strong> Protecting individual Posts, <strong>only</strong> protects the Permalinks for those Posts. It is still possible for excerpts of protected content to be seen in search results generated by WordPress, feeds, and Archive views; such as your Home Page, inside a Category listing, or through other queries formulated by your theme. This is the intended functionality. Excerpts are a great way to "tease" public visitors. In other words, public visitors may have access to excerpts introduced by your theme, but any attempt to view the full Post (i.e., the Permalink) will result in an automatic redirect to your Membership Options Page; requiring registration.</em></p>'."\n";
				echo '<p><em><strong>Note:</strong> If you would like to protect many Posts at once (including Archive views), you can use Category Level Restrictions, Tag Level Restrictions, or have a look down below at s2Member\'s options for "Alternative View Protection", which deals with search results, as well as feeds.</em></p>'."\n";
				echo ((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) && empty($GLOBALS["WS_PLUGIN__"]["wp_show_ids"])) ? '<p><em><strong>Tip:</strong> Can\'t find your Post IDs? Get <a href="https://s2member.com/r/wordpress-org-wp-show-ids/" target="_blank" rel="external">WP Show IDs</a>.</em></p>'."\n" : '';
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_post_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";

				for($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
				{
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-level'.$n.'-posts">'."\n";
					echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Posts That Require Highest Level #'.$n.':'."\n" : 'Posts That Require Level #'.$n.' Or Higher:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level'.$n.'_posts" id="ws-plugin--s2member-level'.$n.'-posts" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level".$n."_posts"]).'" />'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
				}
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_post_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_page_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_page_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Page Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-page-level-access-section">'."\n";
				echo '<h3>Page Level Access Restrictions (optional)</h3>'."\n";
				echo '<p>Here you can specify Pages that are restricted to certain Membership Access Levels.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> Page IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code>. Or, you can type: <code>all</code> <em>(to protect all Pages)</em>.</p>'."\n";
				echo ((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) && empty($GLOBALS["WS_PLUGIN__"]["wp_show_ids"])) ? '<p><em><strong>Tip:</strong> Can\'t find your Page IDs? Get <a href="https://s2member.com/r/wordpress-org-wp-show-ids/" target="_blank" rel="external">WP Show IDs</a>.</em></p>'."\n" : '';
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_page_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";

				for($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
				{
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-level'.$n.'-pages">'."\n";
					echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Pages That Require Highest Level #'.$n.':'."\n" : 'Pages That Require Level #'.$n.' Or Higher:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level'.$n.'_pages" id="ws-plugin--s2member-level'.$n.'-pages" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level".$n."_pages"]).'" />'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
				}
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_page_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_tag_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_tag_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Tag Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-tag-level-access-section">'."\n";
				echo '<h3>Tag Level Access Restrictions (optional)</h3>'."\n";
				echo '<p>Here you can specify Tags that are restricted to certain Membership Access Levels. This is similar to Category Level Access. When you restrict access to a Tag Archive, it also restricts access to any Post having that Tag; even if a Post has other Tags. <strong>Tip:</strong> Tags can be applied to any Post, without affecting your Category structure at all. If you\'d like to use Tags with Pages get the <a href="https://s2member.com/r/wordpress-org-tag-pages/" target="_blank" rel="external">Tag Pages</a> plugin.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> Tags in comma-delimited format. Example: <code>members, members only, free subscribers, premium</code>. Or, you can type: <code>all</code> <em>(to protect all Tags)</em>. <strong>Note:</strong> tags are caSe sensitive. The Tag <code>members only</code> is not the same as <code>Members Only</code>.</p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_tag_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";

				for($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
				{
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-level'.$n.'-ptags">'."\n";
					echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Tags That Require Highest Level #'.$n.':'."\n" : 'Tags That Require Level #'.$n.' Or Higher:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level'.$n.'_ptags" id="ws-plugin--s2member-level'.$n.'-ptags" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level".$n."_ptags"]).'" />'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
				}
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_tag_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_category_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_category_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Category Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-category-level-access-section">'."\n";
				echo '<h3>Category Level Access Restrictions (optional)</h3>'."\n";
				echo '<p>Here you can specify Categories that are restricted to certain Membership Access Levels. Category restrictions are a bit more complex. When you restrict access to a Category, it also restricts access to any child Categories it may have <em>(aka: sub-Categories)</em>. In other words, restricting a Category protects a Category Archive, all of its child Category Archives, and any Posts contained within the Category or its child Categories. This is a very powerful form of protection, so please be careful. It\'s very easy to protect too much content by accident.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> Category IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code>. Or, you can type: <code>all</code> <em>(to protect all Categories)</em>.</p>'."\n";
				echo ((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) && empty($GLOBALS["WS_PLUGIN__"]["wp_show_ids"])) ? '<p><em><strong>Tip:</strong> Can\'t find your Category IDs? Get <a href="https://s2member.com/r/wordpress-org-wp-show-ids/" target="_blank" rel="external">WP Show IDs</a>.</em></p>'."\n" : '';
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_category_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";

				for($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
				{
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-level'.$n.'-catgs">'."\n";
					echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'Categories That Require Highest Level #'.$n.':'."\n" : 'Categories That Require Level #'.$n.' Or Higher:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_level'.$n.'_catgs" id="ws-plugin--s2member-level'.$n.'-catgs" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level".$n."_catgs"]).'" />'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";

					echo '<tr>'."\n";
				}
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_category_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_uri_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_uri_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="URI Restrictions (typical w/BuddyPress)">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-uri-level-access-section">'."\n";
				echo '<h3>URI Level Access Restrictions (optional)</h3>'."\n";
				echo '<p>Here you can specify URIs (or word fragments found in URIs) that are restricted to certain Membership Access Levels. Control over URIs is a little more complex. This section is intended for advanced webmasters only. A <code>REQUEST_URI</code> is the portion of a <code>URL</code> that comes immediately after the domain. This is a URL <code>http://www.example.com/path/to/file.php</code>, and this is the URI: <code>/path/to/file.php</code>. In other words, a <code>REQUEST_URI</code> is the full path to a real <em>(or virtual)</em> directory and/or file on your domain. s2Member can match a URI in whole, or in part.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> In the fields below, you can provide a list of URIs <strong>(one per line; i.e., line-delimited)</strong> that should be off-limits based on Membership Level. You can also use word fragments instead of a full URI. If a word fragment is found anywhere in the URI, it will be protected. Wildcards and other regex patterns are <em>not</em> supported here, and therefore you don\'t need to escape special characters or anything. Please note, depending on your caSe configuration option (as seen below), your exclusion patterns might be caSe sensitive. If you choose to make these caSe sensitive, you must be specific. The word fragment <code>some-path/</code> would not match a URI that contains <code>some-Path/</code>.</p>'."\n";
				echo '<p><em><strong>Replacement Codes:</strong> A few <a href="#" onclick="alert(\'URI Replacement Codes:\\n\\n%%current_user_login%% = The current User\\\'s Username, lowercase (deprecated, please use %%current_user_nicename%%).\\n\\n%%current_user_nicename%% = The current User\\\'s Nicename in lowercase format (i.e., a cleaner version of the username for URLs; recommended for best compatibility).\\n\\n%%current_user_id%% = The current User\\\'s ID.\\n\\n%%current_user_level%% = The current User\\\'s s2Member Level.\\n\\n%%current_user_role%% = The current User\\\'s WordPress Role.'.((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) ? '\\n\\n%%current_user_ccaps%% = The current User\\\'s Custom Capabilities.' : '').'\\n\\n%%current_user_logins%% = Number of times the current User has logged in.\\n\\nFor example, if you\\\'re using BuddyPress, and want to protect BuddyPress Groups, you could add URI protection, like this: /members/%%current_user_nicename%%/groups/\'); return false;">Replacement Codes</a> are also supported here.</em></p>'."\n";
				echo '<p><em><strong>BuddyPress (and similar):</strong> URI Restrictions work great with plugins like BuddyPress that add new areas to your site (where those new areas are not necessarily a Post/Page/Tag/Category). In other words, anytime you\'d like to protect a specific feature offered by BuddyPress (or other plugins), you\'ll need to nail-down specific word fragments found in the URIs associated with those areas. For instance, with BuddyPress you might have something like: [<a href="#" onclick="alert(\'/members/\\n/groups/\\n/blogs/\\n/activity/\\n/messages/\\n/profile/\\n/friends/\\n/settings/\'); return false;">click for example</a>].</em></p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_uri_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-ruris-case-sensitive">'."\n";
				echo 'URI Restrictions caSe Sensitive?'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<select name="ws_plugin__s2member_ruris_case_sensitive" id="ws-plugin--s2member-ruris-case-sensitive">'."\n";
				echo '<option value="0"'.((!$GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["ruris_case_sensitive"]) ? ' selected="selected"' : '').'>No (caSe-insensitive; recommended)</option>'."\n";
				echo '<option value="1"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["ruris_case_sensitive"]) ? ' selected="selected"' : '').'>Yes (caSe-sensitive; e.g., /some-path/ is not the same as /some-Path/)</option>'."\n";
				echo '</select><br />'."\n";
				echo 'Recommended setting: (<code>No; caSe-insensitive</code>)'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";

				echo '<div class="ws-menu-page-hr"></div>'."\n";

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";

				for($n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n++)
				{
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-level'.$n.'-ruris">'."\n";
					echo ($n === $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]) ? 'URIs That Require Highest Level #'.$n.':'."\n" : 'URIs That Require Level #'.$n.' Or Higher:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<textarea name="ws_plugin__s2member_level'.$n.'_ruris" id="ws-plugin--s2member-level'.$n.'-ruris" rows="3" wrap="off" spellcheck="false">'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["level".$n."_ruris"]).'</textarea>'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
				}
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_uri_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_query_level_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_query_level_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Alternative View Protection (feeds, search results, etc.)">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-query-level-access-section">'."\n";
				echo '<h3>Alternative View Protection (optional)</h3>'."\n";
				echo '<p>s2Member protects Categories, Tags, Posts, Pages, Files, URIs &amp; more. However, even with all of those security restrictions, it\'s still possible for protected content excerpts to be seen through XML feeds, in search results generated by WordPress; and/or (depending on your theme), possibly in other Archive views; which might include things like: Posts by Author, Posts by Date, a list of featured items formulated by your theme; or even through other widgets/plugins adding functionality to your site. We refer to all of these collectively, as "Alternative Views".</p>'."\n";
				echo '<p>Using the options below, you can tell s2Member to protect some (or all) of these "Alternative Views" by filtering WordPress database queries for you. s2Member can automatically hide protected content that is not available to the current User/Member. In other words, s2Member is capable of pre-filtering all database queries so that excerpts of protected content will not be allowed to slip through.</p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_uri_level_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-filter-wp-query">'."\n";
				echo 'Protect Alternative Views?'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<div class="ws-menu-page-scrollbox" style="height:105px;">'."\n";
				echo '<input type="hidden" name="ws_plugin__s2member_filter_wp_query[]" value="update-signal" />'."\n";
				foreach(array("all" => "<strong>Filter ALL WordPress queries</strong>; protecting all Alternative Views.", "searches" => "&#9492;&#9472; Searches (hide protected content in search results)", "feeds" => "&#9492;&#9472; Feeds (hide protected content in standard XML/RSS/ATOM feeds)", "comment-feeds" => "&#9492;&#9472; Comment Feeds (hide comments associated with protected content, in comment feeds)", "nav-menus" => "&#9492;&#9472; Nav Menus (hide protected content in menus generated with <em>WordPress → Appearance → Menus</em>)", "pages" => "&#9492;&#9472; Pages (hide protected content in widgets that list Pages)") as $ws_plugin__s2member_temp_s_value => $ws_plugin__s2member_temp_s_label)
					echo '<input type="checkbox" name="ws_plugin__s2member_filter_wp_query[]" id="ws-plugin--s2member-filter-wp-query-'.esc_attr(preg_replace("/[^a-z0-9_\-]/", "-", $ws_plugin__s2member_temp_s_value)).'" value="'.esc_attr($ws_plugin__s2member_temp_s_value).'"'.((in_array($ws_plugin__s2member_temp_s_value, $GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["filter_wp_query"])) ? ' checked="checked"' : '').' /> <label for="ws-plugin--s2member-filter-wp-query-'.esc_attr(preg_replace("/[^a-z0-9_\-]/", "-", $ws_plugin__s2member_temp_s_value)).'">'.$ws_plugin__s2member_temp_s_label.'</label><br />'."\n";
				echo '</div>'."\n";
				echo '<strong>Attn Developers:</strong> Filters can be suppressed dynamically using this technique:<br />'."\n";
				echo '<code><a href="https://s2member.com/r/wordpress-codex-query_posts/" target="_blank" rel="external">query_posts</a>("suppress_filters=true");</code><br />'."\n";
				echo '<code><a href="https://s2member.com/r/wordpress-codex-get_posts/" target="_blank" rel="external">get_posts</a>()</code> auto-suppresses filters.<br />'."\n";
				echo 'Also see <a href="https://s2member.com/r/s2member-codex-attach_s2member_query_filters/" target="_blank" rel="external">this article</a> in the s2Member Codex.'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_query_level_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_conditionals", (!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()), get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_conditionals", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Simple Shortcode Conditionals (protect only parts of your content)">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-conditionals-section">'."\n";
				echo '<h3>Simple Shortcode Conditionals (optional; to protect only parts of your content)</h3>'."\n";
				echo '<p>s2Member makes it very easy to protect entire Posts, Pages, Categories, Tags, URIs, etc. This can be accomplished here in your WordPress Dashboard, using one of the many tools made available on this page. Or, from your Post/Page editing station in WordPress. We consider this to be point-and-click functionality—very easy. However, s2Member also makes it possible for you to protect "parts" of a Post or Page. You can even get creative about what you display to certain Users/Members, based upon your own custom criteria. s2Member\'s Simple Shortcode Conditionals are the key to accomplishing this.</p>'."\n";
				echo '<p>Please see this KB article to learn more about <code>[s2If /]</code>: <a href="http://www.s2member.com/kb/simple-shortcode-conditionals/" target="_blank" rel="external">s2Member Simple Shortcode Conditionals</a></p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_conditionals", get_defined_vars());
				echo '</div>'."\n";

				if((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) && c_ws_plugin__s2member_utils_conds::pro_is_installed())
				{
					echo '<div class="ws-menu-page-hr"></div>'."\n";

					echo '<h3>Arbitrary PHP Code via <code>[s2If php=&quot;&quot;]</code></h3>'."\n";
					echo '<p>By default, the <code>[s2If]</code> Shortcode is limited to a specific set of Conditional Tags provided by WordPress and the s2Member plugin; e.g., <code>[s2If current_user_can(access_s2member_level1)]</code>; as one quick example. Arbitrary PHP code is not allowed with this syntax. However, a second syntax variation exists; where it <em>is</em> possible to use arbitrary PHP code (only if enabled below). The second syntax variation uses one <code>php</code> Shortcode Attribute to run a single conditional check; e.g., <code>[s2If php="is_user_logged_in() && current_user_can(\'access_s2member_ccap_music\')"]</code>. For developers, this has some obvious advantages. The code inside the <code>php</code> attribute is evaluated at runtime, so it\'s possible to accomplish more when necessary. Of course, you could also use a plugin like <a href="https://www.s2member.com/kb/ezphp-plugin/" target="_blank" rel="external">ezPHP</a> to accomplish the same thing (if you prefer).</p>'."\n";

					echo '<table class="form-table">'."\n";
					echo '<tbody>'."\n";
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-sc-conds-allow-arbitrary-php">'."\n";
					echo 'Allow Arbitrary PHP Code via the <code>[s2If php=&quot;&quot;]</code> Attribute?'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<select name="ws_plugin__s2member_sc_conds_allow_arbitrary_php" id="ws-plugin--s2member-sc-conds-allow-arbitrary-php">'."\n";
					echo '<option value="0"'.((!$GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["sc_conds_allow_arbitrary_php"]) ? ' selected="selected"' : '').'>No (recommended for best security; e.g., on sites with multiple authors/editors)</option>'."\n";
					echo '<option value="1"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["sc_conds_allow_arbitrary_php"]) ? ' selected="selected"' : '').'>Yes (allow me to use PHP via the [s2If php=&quot;&quot;][/s2If] shortcode)</option>'."\n";
					echo '</select>'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
					echo '</tbody>'."\n";
					echo '</table>'."\n";

					//230813 Whitelist more conditional functions
					echo '<div class="ws-menu-page-hr"></div>'."\n";

					echo '<h3>Whitelist Additional Conditional Functions for <code>[s2If]</code></h3>'."\n";
					echo '<p>Enter a comma-separated list of additional conditional functions you\'d like to whitelist for the <code>[s2If]</code> shortcode. These functions will be added to the existing set of <a href="https://s2member.com/kb-article/s2if-simple-shortcode-conditionals/#toc-5bb69568" target="_blank" rel="external">allowed functions</a>.</p>'."\n";

					echo '<table class="form-table">'."\n";
					echo '<tbody>'."\n";
					echo '<tr>'."\n";

					echo '<th>'."\n";
					echo '<label for="ws-plugin--s2member-sc-conds-whitelist">'."\n";
					echo 'Allowed Conditional Functions:'."\n";
					echo '</label>'."\n";
					echo '</th>'."\n";

					echo '</tr>'."\n";
					echo '<tr>'."\n";

					echo '<td>'."\n";
					echo '<input type="text" name="ws_plugin__s2member_sc_conds_whitelist" id="ws-plugin--s2member-sc-conds-whitelist" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["sc_conds_whitelist"]).'" placeholder="" style="width:100%;" /><br />'."\n";
					echo 'Ex: <code>get_user_field, my_custom_function</code><br />'."\n";
					echo '</td>'."\n";

					echo '</tr>'."\n";
					echo '</tbody>'."\n";
					echo '</table>'."\n";
				}
				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_conditionals", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_sp_access", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_sp_access", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Specific Post/Page Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-sp-access-section">'."\n";
				echo '<h3>Specific Post/Page Access Restrictions (optional)</h3>'."\n";
				echo '<p>s2Member now supports an additional layer of functionality that allows you to sell access to specific Posts/Pages that you\'ve created in WordPress. s2Member\'s "Specific Post/Page Access" works independently from Membership Level Access. That is, you can sell an unlimited number of Posts/Pages using "Buy Now" Buttons (or Pro-Forms; if you\'re running s2Member Pro)—your Customers will not be required to have a Membership Account with your site in order to receive access. If they are already a Member, that\'s fine, but they won\'t need to be.</p>'."\n";
				echo '<p>In other words, Customers will not need to log in (or even have an account) to receive access to the Specific Post/Page they purchased access to. s2Member will immediately redirect the Customer to the Specific Post/Page after checkout is completed successfully. An email is also sent to the Customer with a link (see: <strong>s2Member → PayPal Options → Specific Post/Page Email</strong>). Authentication is handled automatically through self-expiring links, good for 72 hours by default.</p>'."\n";
				echo '<p>Specific Post/Page Access is sort of like selling a product. Only, instead of shipping anything to the Customer, you just give them access to a specific Post/Page on your site; one that you created in WordPress. A Specific Post/Page that is protected by s2Member might contain a download link for your eBook, access to file &amp; music downloads, access to additional support services, and the list goes on. The possibilities with this are endless; as long as your digital product can be delivered through access to a WordPress Post/Page that you\'ve created.</p>'."\n";
				echo '<p>Very simple. All you do is protect the Specific Post/Page IDs that are being sold on your site. Then, you can go to <strong>s2Member → PayPal Buttons → Specific Post/Page</strong> to generate "Buy Now" Buttons that you can insert into your WordPress Editor and make available on your site. The Button Generator for s2Member will even let you Package Additional Posts/Pages together into one transaction.</p>'."\n";
				echo '<p><strong>What do I enter?</strong> Post/Page IDs in comma-delimited format. Example: <code>1,2,3,34,8,21</code>. <strong>Note:</strong> the word <code>all</code> does not work here. You must supply a list of Specific Post/Page IDs.</p>'."\n";
				echo '<p><em><strong>Avoid Conflicts!</strong> Please be careful not to create a conflict with any of your other Access Restrictions. If you are going to sell Specific Post/Page Access you should enter specific Post/Page IDs that have not already been protected by other Restrictions (either directly or indirectly). In short, <strong>make sure that you haven\'t protected any of your Specific Posts/Pages with Member Level Access Restrictions already</strong>. If you configure s2Member in such as a way, that a Post/Page requires both Membership Level Access and Specific Post/Page Access too, you will create a conflict. Customers that purchase Specific Post/Page Access would be unable to access the Post/Page without also having a Membership.</em></p>'."\n";
				echo ((!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) && empty($GLOBALS["WS_PLUGIN__"]["wp_show_ids"])) ? '<p><em><strong>Tip:</strong> Can\'t find your Post/Page IDs? Get <a href="https://s2member.com/r/wordpress-org-wp-show-ids/" target="_blank" rel="external">WP Show IDs</a>.</em></p>'."\n" : '';
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_sp_access", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-specific-ids">'."\n";
				echo 'Specific Post/Page IDs Being Sold On Your Site:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_specific_ids" id="ws-plugin--s2member-specific-ids" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["specific_ids"]).'" />'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_sp_access", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_brute_force_restrictions", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_brute_force_restrictions", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Brute Force IP/Login Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-brute-force-restrictions-section">'."\n";
				echo '<h3>Brute Force IP/Login Restrictions (prevents username/password guessing)</h3>'."\n";
				echo '<input type="button" id="ws-plugin--s2member-brute-force-restrictions-reset-button" value="Reset Brute Force Logs" class="ws-menu-page-right" style="min-width:175px;" />'."\n";
				echo '<p>As with any Membership system, it is possible for someone to try and guess Username/Password combinations by attempting a <a href="https://s2member.com/r/wikipedia-brute-force-attack/" target="_blank" rel="external">Brute Force Attack</a>; whereby multiple/repeated logins are strategically attempted with various Username/Password combinations until a correct guess is made. It is not likely that you\'ll be attacked in this way, but it\'s still a good idea to protect your system; just in case somebody tries this. s2Member thwarts this behavior by monitoring failed login attempts that occur within a short period of time. Whenever s2Member detects an IP address <em>(i.e., a remote user)</em> that is consistently failing to enter a valid Username/Password, a temporary ban is created; preventing additional attempts from taking place for 30 minutes. This temporary ban, will only affect the offending IP address.</p>'."\n";
				echo '<p><em><strong>Note:</strong> an empty IP address (associated with someone browsing anonymously) is also considered a unique IP address. This way it cannot circumvent s2Member\'s security.</em></p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_ip_restrictions", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-max-failed-login-attempts">'."\n";
				echo 'Maximum Failed Login Attempts:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<select name="ws_plugin__s2member_max_failed_login_attempts" id="ws-plugin--s2member-max-failed-login-attempts">'."\n";
				$ws_plugin__s2member_temp_s = apply_filters("ws_plugin__s2member_track_failed_logins__exp_time", "30 minutes");
				echo '<option value="1"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 1) ? ' selected="selected"' : '').'>Allow 1 failed login attempt ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="2"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 2) ? ' selected="selected"' : '').'>Allow 2 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="3"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 3) ? ' selected="selected"' : '').'>Allow 3 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="4"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 4) ? ' selected="selected"' : '').'>Allow 4 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="5"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 5) ? ' selected="selected"' : '').'>Allow 5 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="10"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 10) ? ' selected="selected"' : '').'>Allow 10 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="20"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 20) ? ' selected="selected"' : '').'>Allow 20 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="30"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 30) ? ' selected="selected"' : '').'>Allow 30 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="40"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 40) ? ' selected="selected"' : '').'>Allow 40 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="50"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 50) ? ' selected="selected"' : '').'>Allow 50 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="75"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 75) ? ' selected="selected"' : '').'>Allow 75 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="100"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 100) ? ' selected="selected"' : '').'>Allow 100 failed login attempts ( then punish for '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="0"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_failed_login_attempts"] == 0) ? ' selected="selected"' : '').'>Allow infinite failed logins (Brute Force Restrictions disabled)</option>'."\n";
				echo '</select><br />'."\n";
				echo 'When/if you change this, you should also <strong>Reset Brute Force Logs</strong> (click button above).'."\n";
				echo (!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) ? '<br /><br />The default period of "30 minutes" could be modified through this WordPress Filter:<br /><code>ws_plugin__s2member_track_failed_logins__exp_time</code>'."\n" : '';
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_ip_restrictions", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_ip_restrictions", TRUE, get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_ip_restrictions", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Unique IP Access Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-ip-restrictions-section">'."\n";
				echo '<h3>Unique IP Access Restrictions (prevents username/link sharing)</h3>'."\n";
				echo '<input type="button" id="ws-plugin--s2member-ip-restrictions-reset-button" value="Reset IP Restriction Logs" class="ws-menu-page-right" style="min-width:175px;" />'."\n";
				echo '<p>As with any Membership system, it is possible for one Member to signup, and then share their Username with someone else; or even post it online for the whole world to see. This is known as Link Sharing (or Username Sharing). It is not likely that you\'ll be attacked in this way, but it\'s still a good idea to protect your system; just in case somebody tries this. s2Member\'s IP Restrictions work for Membership Level Access (i.e., account logins), Specific Post/Page Access, Registration Links, and other secure Entry Points. In all cases, the rules are simple. A single Username, Access Link, and/or Entry Point is only valid for a certain number of unique IP addresses. Once that limit is reached, s2Member assumes there has been a security breach. At that time, s2Member will create a temporary ban; preventing access to a Specific Post/Page, or to an account associated with a particular Username. This temporary ban will only affect the offending Link and/or Username associated with the security breach. You can fine-tune this behavior using the options below.</p>'."\n";
				echo '<p><em><strong>Note:</strong> an empty IP address (associated with someone browsing anonymously) is also considered a unique IP address. This way it cannot circumvent s2Member\'s security.</em></p>'."\n";
				echo '<p><em><strong>Note:</strong> This feature can work with or without <strong>Simultaneous Login Monitoring</strong> (Simultaneous Login Monitoring is an s2Member Pro feature). You can choose to implement both Unique IP Access Restrictions and Simultaneous Login Monitoring together, just one of them, or neither. It\'s a matter of preference. Simultaneous Login Monitoring has the added benefit of not being dependent upon IP address tracking—making it more user-friendly and reliable. Particularly in cases where you\'d like to support users who might travel a lot, have multiple devices, or be on ISPs that change their IP address frequently.</em></p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_ip_restrictions", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-max-ip-restriction">'."\n";
				echo 'Maximum Unique IP Addresses Allowed:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<select name="ws_plugin__s2member_max_ip_restriction" id="ws-plugin--s2member-max-ip-restriction">'."\n";
				$ws_plugin__s2member_temp_s = apply_filters("ws_plugin__s2member_ip_restrictions__concurrency_time_per_ip", "30 days");
				echo '<option value="1"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 1) ? ' selected="selected"' : '').'>Allow up to 1 unique IP per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="2"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 2) ? ' selected="selected"' : '').'>Allow up to 2 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="3"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 3) ? ' selected="selected"' : '').'>Allow up to 3 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="4"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 4) ? ' selected="selected"' : '').'>Allow up to 4 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="5"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 5) ? ' selected="selected"' : '').'>Allow up to 5 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="10"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 10) ? ' selected="selected"' : '').'>Allow up to 10 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="20"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 20) ? ' selected="selected"' : '').'>Allow up to 20 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="30"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 30) ? ' selected="selected"' : '').'>Allow up to 30 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="40"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 40) ? ' selected="selected"' : '').'>Allow up to 40 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="50"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 50) ? ' selected="selected"' : '').'>Allow up to 50 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="75"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 75) ? ' selected="selected"' : '').'>Allow up to 75 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="100"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 100) ? ' selected="selected"' : '').'>Allow up to 100 different IPs per Customer ( every '.$ws_plugin__s2member_temp_s.' )</option>'."\n";
				echo '<option value="0"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction"] == 0) ? ' selected="selected"' : '').'>Allow infinite IPs (all IP Restrictions are disabled)</option>'."\n";
				echo '</select>'."\n";
				echo (!is_multisite() || !c_ws_plugin__s2member_utils_conds::is_multisite_farm() || is_main_site()) ? '<br />The default period of "30 days" could be modified through this WordPress Filter:<br /><code>ws_plugin__s2member_ip_restrictions__concurrency_time_per_ip</code>'."\n" : '';
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-max-ip-restriction-time">'."\n";
				echo 'Security Breach Timeout Period:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<select name="ws_plugin__s2member_max_ip_restriction_time" id="ws-plugin--s2member-max-ip-restriction-time">'."\n";
				echo '<option value="300"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 300) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 5 mins)</option>'."\n";
				echo '<option value="900"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 900) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 15 mins)</option>'."\n";
				echo '<option value="1800"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 1800) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 30 mins)</option>'."\n";
				echo '<option value="3600"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 3600) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 1 hour)</option>'."\n";
				echo '<option value="7200"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 7200) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 2 hours)</option>'."\n";
				echo '<option value="14400"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 14400) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 4 hours)</option>'."\n";
				echo '<option value="21600"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 21600) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 6 hours)</option>'."\n";
				echo '<option value="28800"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 28800) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 8 hours)</option>'."\n";
				echo '<option value="43200"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 43200) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 12 hours)</option>'."\n";
				echo '<option value="86400"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 86400) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 24 hours)</option>'."\n";
				echo '<option value="172800"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 172800) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 2 days)</option>'."\n";
				echo '<option value="345600"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 345600) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 4 days)</option>'."\n";
				echo '<option value="604800"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 604800) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 1 week)</option>'."\n";
				echo '<option value="1209600"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 1209600) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 2 weeks)</option>'."\n";
				echo '<option value="2629743"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 2629743) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 1 month)</option>'."\n";
				echo '<option value="5259487"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 5259487) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 2 months)</option>'."\n";
				echo '<option value="7889231"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 7889231) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 3 months)</option>'."\n";
				echo '<option value="15778463"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 15778463) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 6 months)</option>'."\n";
				echo '<option value="31556926"'.(($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_ip_restriction_time"] == 31556926) ? ' selected="selected"' : '').'>If limit is exceeded (punish for 1 year)</option>'."\n";
				echo '</select><br />'."\n";
				echo 'When/if you change this, you should also <strong>Reset IP Restriction Logs</strong> (click button above).'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_ip_restrictions", get_defined_vars());
			}
			if(apply_filters("ws_plugin__s2member_during_res_ops_page_during_left_sections_display_slogin_restrictions", c_ws_plugin__s2member_utils_conds::pro_is_installed(), get_defined_vars()))
			{
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_before_slogin_restrictions", get_defined_vars());

				echo '<div class="ws-menu-page-group" title="Simultaneous Login Restrictions">'."\n";

				echo '<div class="ws-menu-page-section ws-plugin--s2member-slogin-restrictions-section">'."\n";
				echo '<h3>Simultaneous Login Restrictions (prevents username sharing)</h3>'."\n";
				echo '<p>As with any Membership system, it is possible for one Member to signup, then share their Username with someone else; or even post it online for the whole world to see. This is known as Username Sharing. It is not likely that you\'ll be attacked in this way, but it\'s not a bad idea to protect your system; just in case somebody tries this.</p>'."\n";
				echo '<p>s2Member\'s Simultaneous Login Monitoring (for Membership Access only) works with account logins (Usernames), to help you prevent a security issue. The rules are simple. A single Username can only have X number of simultaneous logins (as configured below). Once that limit is reached, s2Member assumes there has been a security breach. At that time, s2Member will create a temporary ban; preventing the offending Username from being able to log in until somebody else (who is already logged into the account) has logged-out; clearing the way for someone new.</p>'."\n";
				echo '<p>This can be a tricky feature to configure, because most people do not click a "Logout" link when they are done with their account. This makes it challenging to know when someone is still logged-in, and when they\'re not. s2Member monitors simultaneous logins by updating a timer whenever someone actually logs in; and then again on each page view while they navigate the site. If there is no activity after X amount of time, s2Member\'s Simultaneous Login Monitor considers that person inactive, and will not include them in security checks until they log in again, or visit a new page on the site. You can configure the timeout period below. The default value is <code>30 minutes</code>.</p>'."\n";
				echo '<p><em><strong>Note:</strong> This feature can work with or without <strong>Unique IP Restrictions</strong>. You can choose to implement both Unique IP Access Restrictions and Simultaneous Login Monitoring together, just one of them, or neither. It\'s a matter of preference. Simultaneous Login Monitoring has the added benefit of not being dependent upon IP address tracking—making it more user-friendly and reliable. Particularly in cases where you\'d like to support users who might travel a lot, have multiple devices, or be on ISPs that change their IP address frequently.</em></p>'."\n";
				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_during_slogin_restrictions", get_defined_vars());

				echo '<table class="form-table">'."\n";
				echo '<tbody>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-max-simultaneous-logins">'."\n";
				echo 'Max Simultaneous Logins Allowed; for each Username:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_max_simultaneous_logins" id="ws-plugin--s2member-max-simultaneous-logins" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_simultaneous_logins"]).'" /><br />'."\n";
				echo 'Examples: <code>0</code> (to disable this functionality), <code>1</code> (maximum of 1 login at a time), <code>2</code>, <code>3</code>, <code>10</code>, <code>20</code>, etc.<br />'."\n";
				echo 'Suggestion: <code>3</code>—the chance to open your site in multiple browsers; but still prevents major security issues.<br />'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<th>'."\n";
				echo '<label for="ws-plugin--s2member-max-simultaneous-logins-timeout">'."\n";
				echo 'Inactivity Timeout Period; this impacts Simultaneous Login Monitoring only.<br />'."\n";
				echo 'Simultaneous Login Monitoring should assume a Username is logged-out after this amount of time:'."\n";
				echo '</label>'."\n";
				echo '</th>'."\n";

				echo '</tr>'."\n";
				echo '<tr>'."\n";

				echo '<td>'."\n";
				echo '<input type="text" autocomplete="off" name="ws_plugin__s2member_max_simultaneous_logins_timeout" id="ws-plugin--s2member-max-simultaneous-logins-timeout" value="'.format_to_edit($GLOBALS["WS_PLUGIN__"]["s2member"]["o"]["max_simultaneous_logins_timeout"]).'" /><br />'."\n";
				echo 'Examples: <code>30 minutes</code>, <code>1 hour</code>, <code>2 hours</code>; anything compatible with PHP\'s <a href="https://s2member.com/r/php-net-strtotime/" target="_blank" rel="external">strtotime()</a>.<br />'."\n";
				echo 'Recommended Setting: <code>30 minutes</code>; if they stop browsing the site, they\'re considered inactive.<br />'."\n";
				echo '</td>'."\n";

				echo '</tr>'."\n";
				echo '</tbody>'."\n";
				echo '</table>'."\n";
				echo '</div>'."\n";

				echo '</div>'."\n";

				do_action("ws_plugin__s2member_during_res_ops_page_during_left_sections_after_slogin_restrictions", get_defined_vars());
			}
			do_action("ws_plugin__s2member_during_res_ops_page_after_left_sections", get_defined_vars());

			echo '<p class="submit"><input type="submit" value="Save All Changes" /></p>'."\n";

			echo '</form>'."\n";

			echo '</td>'."\n";

			echo '<td class="ws-menu-page-table-r">'."\n";
			c_ws_plugin__s2member_menu_pages_rs::display();
			echo '</td>'."\n";

			echo '</tr>'."\n";
			echo '</tbody>'."\n";
			echo '</table>'."\n";

			echo '</div>'."\n";
		}
	}
}
new c_ws_plugin__s2member_menu_page_res_ops ();
