<?php
/**
 * Sidebar widgets
 *
 * @author        Webcraftic <wordpress.webraftic@gmail.com>
 * @copyright (c) 01.12.2018, Webcraftic
 * @version       1.0
 */

/**
 * Return premium widget markup
 *
 * @return string
 */
function wrio_get_sidebar_premium_widget() {

	$purchase_url  = WRIO_Plugin::app()->get_support()->get_pricing_url( true, 'license_page' );
	$upgrade_price = WRIO_Plugin::app()->premium->get_price();

	ob_start();
	?>
    <div id="wbcr-clr-go-to-premium-widget" class="wbcr-factory-sidebar-widget">
        <p>
            <strong><?php _e( 'Activate Robin image optimizer pro', 'robin-image-optimizer' ); ?></strong>
        </p>
        <div class="wbcr-clr-go-to-premium-widget-body">
            <p><?php _e( '<b>Clearfy Business</b> is a paid package of components for the popular free WordPress plugin named Clearfy. You get access to all paid components at one price.', 'wrio-image-optimizer' ) ?></p>
            <p><?php _e( 'Paid license guarantees that you can download and update existing and future paid components of the plugin.', 'robin-image-optimizer' ) ?></p>
            <a href="<?= $purchase_url ?>" class="wbcr-clr-purchase-premium" target="_blank" rel="noopener">
                <span class="btn btn-gold btn-inner-wrap">
                <?php printf( __( 'Upgrade to Clearfy Business for $%s', 'robin-image-optimizer' ), $upgrade_price ) ?>
                </span>
            </a>
        </div>
    </div>
	<?php

	$output = ob_get_contents();

	ob_end_clean();

	return $output;
}

/**
 * Return support widget markup
 *
 * @return string
 */
function wrio_get_sidebar_support_widget() {

	//$free_support_url = WRIO_Plugin::app()->get_support()->get_contacts_url( true, 'support_widget' );
	//$hot_support_url  = WRIO_Plugin::app()->get_support()->get_tracking_page_url( 'hot-support', 'support_widget' );

	$support_url = "https://webcraftic.com/support/";

	ob_start();
	?>
    <div id="wbcr-clr-support-widget" class="wbcr-factory-sidebar-widget">
        <p><strong><?php _e( 'Having Issues?', 'robin-image-optimizer' ); ?></strong></p>
        <div class="wbcr-clr-support-widget-body">
            <p>
				<?php _e( 'We provide free support for this plugin. If you are pushed with a problem, just create a new ticket. We will definitely help you!', 'robin-image-optimizer' ); ?>
            </p>
            <ul>
                <li><span class="dashicons dashicons-sos"></span>
                    <a href="<?= $support_url ?>" target="_blank" rel="noopener"><?php _e( 'Get starting free support', 'robin-image-optimizer' ); ?></a>
                </li>
                <li style="margin-top: 15px;background: #fff4f1;padding: 10px;color: #a58074;">
                    <span class="dashicons dashicons-warning"></span>
					<?php printf( __( 'If you find a php error or a vulnerability in plugin, you can <a href="%s" target="_blank" rel="noopener">create ticket</a> in hot support that we responded instantly.', 'wrio-image-optimizer' ), $support_url ); ?>
                </li>
            </ul>
        </div>
    </div>
	<?php

	$output = ob_get_contents();

	ob_end_clean();

	return $output;
}
