<?php
/**
 * Plugin name: Retainful - WooCommerce Abandoned Cart Recovery, Email Campaigns, Newsletters, Signup Forms & Popups
 * Plugin URI: https://www.retainful.com
 * Description: Do life-cycle WooCommerce email marketing with Retainful - grow email list, nurture and retain customers through automation & email campaigns.
 * Author: Retainful
 * Author URI: https://www.retainful.com
 * Version: 2.6.43
 * Slug: retainful-next-order-coupon-for-woocommerce
 * Text Domain: retainful-next-order-coupon-for-woocommerce
 * Domain Path: /i18n/languages/
 * Plugin URI: https://www.retainful.com
 * Requires at least: 6.0.0
 * Contributers: Sathyaseelan
 * WC requires at least: 6.0.0
 * WC tested up to: 10.1
 * Requires Plugins: woocommerce
 */
if (!defined('ABSPATH')) {
    exit;
}
/**
 * Define the text domain
 */
if (!defined('RNOC_TEXT_DOMAIN')) {
    define('RNOC_TEXT_DOMAIN', 'retainful-next-order-coupon-for-woocommerce');
}
/**
 * Define the plugin slug
 */
if (!defined('RNOC_PLUGIN_SLUG')) {
    define('RNOC_PLUGIN_SLUG', 'retainful-next-order-coupon-for-woocommerce');
}
/**
 * Current version of our app
 */
if (!defined('RNOC_VERSION')) {
    define('RNOC_VERSION', '2.6.43');
}
/**
 * Set base file URL
 */
if (!defined('RNOC_BASE_FILE')) {
    define('RNOC_BASE_FILE', plugin_basename(__FILE__));
}
/**
 * Set base file URL
 */
if (!defined('RNOC_FILE')) {
    define('RNOC_FILE', __FILE__);
}
/**
 * Set base file URL
 */
if (!defined('RNOC_PLUGIN_PREFIX')) {
    define('RNOC_PLUGIN_PREFIX', 'rnoc_');
}
/**
 * Define plugin path
 */
if (!defined('RNOC_PLUGIN_PATH')) {
    define('RNOC_PLUGIN_PATH', plugin_dir_path(__FILE__));
}
/**
 * Define plugin path
 */
if (!defined('RNOC_PLUGIN_URL')) {
    define('RNOC_PLUGIN_URL', plugin_dir_url(__FILE__));
}
/**
 * Check for required packages
 */
if (!file_exists(__DIR__ . '/vendor/autoload.php')) {
    return false;
}
/**
 * Define plugin path
 */
if (!defined('RNOCPREMIUM_PLUGIN_PATH')) {
    define('RNOCPREMIUM_PLUGIN_PATH', RNOC_PLUGIN_PATH . 'src/premium/');
}
/**
 * Define premium plugin URL
 */
if (!defined('RNOCPREMIUM_PLUGIN_URL')) {
    define('RNOCPREMIUM_PLUGIN_URL', RNOC_PLUGIN_URL . 'src/premium/');
}
/**
 * Set Plugin log path
 */
if (!defined('RNOC_LOG_FILE_PATH')) {
    $path = ABSPATH . 'wp-content/retainful.log';
    define('RNOC_LOG_FILE_PATH', $path);
}
/**
 * Setup plugin compatable versions
 */
if (!defined('RNOC_MINIMUM_WC_VERSION')) {
    define('RNOC_MINIMUM_WC_VERSION', '6.0.0');
}
if (!defined('RNOC_MINIMUM_WP_VERSION')) {
    define('RNOC_MINIMUM_WP_VERSION', '6.0.0');
}
if (!defined('RNOC_MINIMUM_PHP_VERSION')) {
    define('RNOC_MINIMUM_PHP_VERSION', '7.4.0');
}
if (!defined('REQUESTS_SILENCE_PSR0_DEPRECATIONS')) {
    define('REQUESTS_SILENCE_PSR0_DEPRECATIONS', true);
}
//Create and alter the tables for abandoned carts and also check for woocommerce installed
register_activation_hook( RNOC_FILE, 'rnocPluginActivation' );
if ( ! function_exists( 'rnocPluginActivation' ) ) {
	/**
	 * Run on plugin activation
	 */
	function rnocPluginActivation() {
		if ( ! rnocIsEnvironmentCompatible() ) {
			/* translators: 1: Require php version */
			wp_die( sprintf( esc_html__( 'This plugin can not be activated because it requires minimum PHP version of %1$s.', 'retainful-next-order-coupon-for-woocommerce' ), esc_html(RNOC_MINIMUM_PHP_VERSION )));
		}
		if ( ! rnocIsWordPressCompatible() ) {
			exit( esc_html__( 'Retainful requires at least Wordpress', 'retainful-next-order-coupon-for-woocommerce' ) . ' ' . esc_html(RNOC_MINIMUM_WC_VERSION ));
		}
		if ( ! rnocIsWoocommerceActive() ) {
			exit( esc_html__( 'Woocommerce must be installed and activated in-order to use Retainful!', 'retainful-next-order-coupon-for-woocommerce' ) );
		}
		if ( ! rnocIsWooCompatible() ) {
			exit( esc_html__( 'Retainful requires at least Woocommerce', 'retainful-next-order-coupon-for-woocommerce' ) . ' ' . esc_html(RNOC_MINIMUM_WC_VERSION ));
		}
		do_action( 'retainful_plugin_activated' );

        return true;
    }
}
add_action('before_woocommerce_init', function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});
/**
 * Check the woocommerce is active or not
 * @return bool
 */
if (!function_exists('rnocIsWoocommerceActive')) {
    function rnocIsWoocommerceActive()
    {
        $active_plugins = apply_filters('active_plugins', get_option('active_plugins', array()));
        if (is_multisite()) {
            $active_plugins = array_merge($active_plugins, get_site_option('active_sitewide_plugins', array()));
        }

        return in_array('woocommerce/woocommerce.php', $active_plugins, false) || array_key_exists('woocommerce/woocommerce.php', $active_plugins);
    }
}
/**
 * Check woocommerce version is compatibility
 * @return bool
 */
if (!function_exists('rnocIsWooCompatible')) {
    function rnocIsWooCompatible()
    {
        if (!RNOC_MINIMUM_WC_VERSION) {
            $is_compatible = true;
        } else {
            $is_compatible = defined('WC_VERSION') && version_compare(WC_VERSION, RNOC_MINIMUM_WC_VERSION, '>=');
        }

        return $is_compatible;
    }
}
/**
 * Determines if the WordPress compatible.
 * @return bool
 * @since 1.0.0
 */
if (!function_exists('rnocIsWordPressCompatible')) {
    function rnocIsWordPressCompatible()
    {
        if (!RNOC_MINIMUM_WP_VERSION) {
            $is_compatible = true;
        } else {
            $is_compatible = version_compare(get_bloginfo('version'), RNOC_MINIMUM_WP_VERSION, '>=');
        }

        return $is_compatible;
    }
}
/**
 * Determines if the server environment is compatible with this plugin.
 * @return bool
 * @since 1.0.0
 */
if (!function_exists('rnocIsEnvironmentCompatible')) {
    function rnocIsEnvironmentCompatible()
    {
        return version_compare(PHP_VERSION, RNOC_MINIMUM_PHP_VERSION, '>=');
    }
}
if (!function_exists('rnocGetInstalledWoocommerceVersion')) {
    /**
     * Get the installed woocommerce version
     */
    function rnocGetInstalledWoocommerceVersion()
    {
        $plugin_folder = get_plugins('/woocommerce');
        $plugin_file = 'woocommerce.php';
        $wc_installed_version = null;
        if (isset($plugin_folder[$plugin_file]['Version'])) {
            $wc_installed_version = $plugin_folder[$plugin_file]['Version'];
        }

        return $wc_installed_version;
    }
}

/**
 * check is woocommerce is active
 */
if (!rnocIsWoocommerceActive() && !function_exists('WC')) {
    return '';
}
require __DIR__ . '/vendor/autoload.php';

use Rnoc\Retainful\Main;

Main::instance();
