<?php
/*
Plugin Name: Restore and Enable Classic Widgets No Expiration
Description: Description: Restore and enable the previous classic widgets settings screens and disables the Gutenberg block editor from managing widgets. No expiration date.
Version: 4.86
Text Domain: restore-classic-widgets
Domain Path: /language
Author: Bill Minozzi
Author URI: http://billminozzi.com
Requires at least: 6.2
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/
if (!defined('ABSPATH')) {
    die('We\'re sorry, but you can not directly access this file.');
}
$restore_classic_widgets_debug = false;
$restore_classic_widgets_plugin_data = get_file_data(__FILE__, array('Version' => 'Version'), false);
$restore_classic_widgets_plugin_version = $restore_classic_widgets_plugin_data['Version'];
define('RESTORE_CLASSIC_WIDGETSPATH', plugin_dir_path(__file__));
define('RESTORE_CLASSIC_WIDGETSURL', plugin_dir_url(__file__));
define('RESTORE_CLASSIC_WIDGETSVERSION', $restore_classic_widgets_plugin_version);
$restore_classic_widgets_images =  RESTORE_CLASSIC_WIDGETSURL . 'assets/images/';
define('RESTORE_CLASSIC_WIDGETSIMAGES', $restore_classic_widgets_images);
$restore_classic_widgets_is_admin = restore_classic_widgets_check_wordpress_logged_in_cookie();
add_filter('gutenberg_use_widgets_block_editor', '__return_false');
add_filter('use_widgets_block_editor', '__return_false');
function restore_classic_widgets_check_wordpress_logged_in_cookie()
{
    try {
        if (!function_exists("wp_get_current_user")) {
            return false;
        }
        if (current_user_can('manage_options')) {
            return true;
        } else {
            return false;
        }
    } catch (Exception $e) {
        return false;
    }
}
$restore_classic_widgets_is_admin = restore_classic_widgets_check_wordpress_logged_in_cookie();
if ($restore_classic_widgets_is_admin) {
}
function restore_classic_widgets_add_admstylesheet()
{
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-dialog');
    $wpmemory_jqueryurl = RESTORE_CLASSIC_WIDGETSURL . 'assets/css/jquery-ui.css';
    wp_register_style('bill-jquery-ui', $wpmemory_jqueryurl, array(), '1.12.1', 'all');
    wp_enqueue_style('bill-jquery-ui');
    wp_enqueue_script('jquery-migrate');
}
add_action('admin_enqueue_scripts', 'restore_classic_widgets_add_admstylesheet');
if ($restore_classic_widgets_is_admin) {
    add_action('admin_init', 'restore_classic_widgets_add_admstylesheet');
}
function restore_classic_widget_row_meta($links, $file)
{
    if (!is_array($links)) {
        return $links;
    }
    // 1. Determina a URL
    if (is_multisite())
        return;
    else
        $url = admin_url() . "tools.php?page=restore_classic_widgets&tab=more_tools";
    // 2. Novo Link com a estética de Botão Laranja
    $new_link_html = '<a href="' . esc_url($url) . '" target="_blank" style="color: #fff; background-color: #ff8c00; padding: 2px 6px; border-radius: 3px; font-weight: bold;">' . esc_html('More Useful Tools', "restore-classic-widgets") . '</a>';
    // 3. Adiciona o novo link no INÍCIO da lista de links (usando array_unshift)
    array_unshift($links, $new_link_html);
    return $links;
}
// O restante do código, assumindo que está correto:
$restore_classic_widgets_plugin = plugin_basename(__FILE__);
add_filter("plugin_action_links_$restore_classic_widgets_plugin", 'restore_classic_widget_row_meta', 10, 2);
function restore_classic_widgets_load_chat()
{
    if (current_user_can("manage_options")) {
        require_once(RESTORE_CLASSIC_WIDGETSPATH . 'functions/function_sysinfo.php');
        if (!class_exists('restore_classic_widgets_BillChat\ChatPlugin')) {
            require_once dirname(__FILE__) . "/includes/chat/class_bill_chat.php";
        }
    }
}
add_action('init', 'restore_classic_widgets_load_chat');


function restore_classic_widgets_restore_classic_widgets_hooking_diagnose()
{
    if (current_user_can("manage_options")) {
        require_once(RESTORE_CLASSIC_WIDGETSPATH . 'functions/function_sysinfo.php');
        $declared_classes = get_declared_classes();
        /*
        foreach ($declared_classes as $class_name) {
            if (strpos($class_name, "_Diagnose") !== false) {
                return;
            }
        }
        */
        // --- CORREÇÃO PRINCIPAL: VERIFICAÇÃO PRECISA DE SUFIXO DE CLASSE (COMPATÍVEL COM PHP < 8.0) ---
        // 2. Percorre a lista de classes.
        foreach ($declared_classes as $class_name) {
            // 3. Verifica se o nome da classe TERMINA com "_Diagnose".
            $suffix = 'Bill_Diagnose';
            $does_end_with = (substr($class_name, -strlen($suffix)) === $suffix);
            if ($does_end_with) {
                return; // Uma classe de diagnóstico principal já foi carregada, não faça nada.
            }
        }
        $plugin_slug = 'restore-classic-widgets';
        $plugin_text_domain = $plugin_slug;
        $notification_url = "https://wpmemory.com/fix-low-memory-limit/";
        $notification_url2 =
            "https://wptoolsplugin.com/site-language-error-can-crash-your-site/";
        require_once dirname(__FILE__) . "/includes/diagnose/class_bill_diagnose.php";
    }
}
add_action('init', 'restore_classic_widgets_restore_classic_widgets_hooking_diagnose');
function restore_classic_widgets_restore_classic_widgets_hooking_catch_errors()
{
    global $restore_classic_widgets_plugin_slug;
    if (current_user_can("manage_options")) {
        $declared_classes = get_declared_classes();
        foreach ($declared_classes as $class_name) {
            if (strpos($class_name, "_catch_errors") !== false) {
                return;
            }
        }
        $restore_classic_widgets_plugin_slug = 'restore-classic-widgets';
        require_once dirname(__FILE__) . "/includes/catch-errors/class_bill_catch_errors.php";
    }
}
add_action('init', 'restore_classic_widgets_restore_classic_widgets_hooking_catch_errors');
function restore_classic_widgets_load_more_class()
{
    // ✅ VERIFICAR se é admin de outra forma (igual ao plugin velho)
    $is_admin = (function_exists('is_admin') && is_admin()) ||
        (current_user_can('manage_options'));
    if ($is_admin) {
        $class_file = dirname(__FILE__) . "/includes/more-tools/class_bill_more.php";
        require_once $class_file;
        // ✅ Verificar se a classe existe após carregar
    }
}
add_action("init", "restore_classic_widgets_load_more_class", 5);
add_action("init", "restore_classic_widgets_load_more_class", 5); // ✅ PRIORIDADE 5
function restore_classic_widgets_render_more_plugins_page()
{
    // ✅ Verificar se a classe existe antes de instanciar
    echo '<h2>More Tools</h2>';
    try {
        $plugin = new restore_classic_widgets_Bill_show_more_plugins();
        $plugin->bill_show_plugins();
    } catch (Exception $e) {
        echo '<div class="error"><p>Error: ' . esc_html($e->getMessage()) . '</p></div>';
    }
}
// --- INÍCIO: NOVAS FUNÇÕES PARA O DASHBOARD COM ABAS ---
/**
 * Registra o menu principal do plugin no painel de administração.
 */
function restore_classic_widgets_add_admin_menu()
{
    // O slug 'restore_classic_widgets' será o principal.
    // Agora aninhado no menu 'Tools' (Ferramentas).
    add_submenu_page(
        'tools.php', // Parent slug: AGORA Adiciona em Ferramentas > <--- ALTERAÇÃO PRINCIPAL
        esc_html__('Restore Classic Widgets Settings', 'restore-classic-widgets'), // Título da Página
        esc_html__('Classic Widgets', 'restore-classic-widgets'), // Título do Menu
        'manage_options', // Capability
        'restore_classic_widgets', // Menu Slug (usado na URL e para referência)
        'restore_classic_widgets_dashboard_page_content' // Função de Callback
    );
}
add_action('admin_menu', 'restore_classic_widgets_add_admin_menu');
// --- FIM: FUNÇÕES DE RENDERIZAÇÃO DAS ABAS ---
// --- INÍCIO: FUNÇÕES DE RENDERIZAÇÃO DAS ABAS ---
/**
 * Renderiza o conteúdo principal da página e as abas.
 */
function restore_classic_widgets_dashboard_page_content()
{
    // Define a aba atual. Padrão é 'dashboard'.
    $current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';
?>
    <div class="wrap">
        <h1><?php esc_html_e('Restore Classic Widgets Settings', 'restore-classic-widgets'); ?></h1>
        <h2 class="nav-tab-wrapper">
            <a href="?page=restore_classic_widgets&tab=dashboard" class="nav-tab <?php echo $current_tab == 'dashboard' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e('Dashboard', 'restore-classic-widgets'); ?>
            </a>
            <a href="?page=restore_classic_widgets&tab=more_tools" class="nav-tab <?php echo $current_tab == 'more_tools' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e('More Tools', 'restore-classic-widgets'); ?>
            </a>
        </h2>
        <div class="tab-content">
            <?php
            // Chama a função de renderização com base na aba ativa
            switch ($current_tab) {
                case 'more_tools':
                    restore_classic_widgets_render_more_tools_tab();
                    break;
                case 'dashboard':
                default:
                    restore_classic_widgets_render_dashboard_tab();
                    break;
            }
            ?>
        </div>
    </div>
<?php
}
/**
 * Conteúdo para a Aba Dashboard (Página em branco com Lorem Ipsum).
 */
function restore_classic_widgets_render_dashboard_tab()
{
?>
    <div class="card" style="max-width: 100%; width: 100%;">
        <h2><?php esc_html_e('Classic Widgets Dashboard', 'restore-classic-widgets'); ?></h2>
        <div style="display: flex; align-items: center; gap: 30px;">
            <!-- Coluna da Esquerda - Imagem (35%) -->
            <div style="flex: 0 0 35%; display: flex; justify-content: center; align-items: center;">
                <img src="<?php echo esc_url(RESTORE_CLASSIC_WIDGETSIMAGES . 'feliz-gemini.png'); ?>" alt="<?php esc_html_e('Happy user illustration', 'restore-classic-widgets'); ?>" style="max-width: 100%; height: auto; display: block;" />
            </div>
            <!-- Coluna da Direita - Texto (65%) -->
            <div style="flex: 0 0 65%; font-size: 1.3em !important; line-height: 1.4 !important; display: flex; flex-direction: column; justify-content: center;">
                <p style="margin-top: 0; margin-bottom: 10px; font-size: inherit !important; line-height: inherit !important;">
                    <?php esc_html_e("Bring back the classic widgets screens in Appearance – Widgets and the Customizer. Once activated and when using a classic (non-block) theme, restore and enable the previous WordPress classic widgets settings screens and disables the Gutenberg block editor from managing widgets. No expiration!", 'restore-classic-widgets'); ?>
                </p>
                <p style="margin-bottom: 5px; font-size: inherit !important; line-height: inherit !important;">
                    <?php esc_html_e("If necessary, you can deactivate this plugin on the plugins page.", 'restore-classic-widgets'); ?>
                </p>
                <p style="margin-bottom: 5px; font-size: inherit !important; line-height: inherit !important;">
                    <?php esc_html_e("After activating it, you don't need to do anything else.", 'restore-classic-widgets'); ?>
                </p>
                <p style="margin-bottom: 5px; font-size: inherit !important; line-height: inherit !important;">
                    <?php esc_html_e("If you have issues with this plugin, please visit our troubleshooting page.", 'restore-classic-widgets'); ?>
                </p>
                <?php
                $troubleshooting_url = 'https://siterightaway.net/troubleshooting/';
                $button_text = esc_html__('Visit Troubleshooting Page', 'restore-classic-widgets');
                ?>
                <a href="<?php echo esc_url($troubleshooting_url); ?>" target="_blank" class="button button-primary" style="margin-top: 15px; font-weight: bold; align-self: flex-start;">
                    <?php echo $button_text; ?>
                </a>
            </div>
        </div>
        <br>
    </div>
<?php
}
function restore_classic_widgets_render_more_tools_tab()
{
    // Chame a sua função original que carrega a classe e renderiza os plugins
    if (!class_exists('restore_classic_widgets_Bill_show_more_plugins')) {
        // Tenta carregar a classe novamente, se necessário
        $class_file = dirname(__FILE__) . "/includes/more-tools/class_bill_more.php";
        if (file_exists($class_file)) {
            require_once $class_file;
        } else {
            echo '<div class="notice notice-error"><p>' . esc_html__('Error: The More Tools class file is missing.', 'restore-classic-widgets') . '</p></div>';
            return;
        }
    }
    echo '<h2>' . esc_html__('More Useful Tools and Plugins', 'restore-classic-widgets') . '</h2>';
    try {
        $plugin = new restore_classic_widgets_Bill_show_more_plugins();
        $plugin->bill_show_plugins();
    } catch (Exception $e) {
        echo '<div class="error"><p>' . esc_html__('Error loading More Tools content: ', 'restore-classic-widgets') . esc_html($e->getMessage()) . '</p></div>';
    }
}
