jQuery(document).ready(function ($) {
  //console.log('More... scripts loaded');
  // console.log('showToast available:', typeof $.fn.showToast !== 'undefined');

  // ✅ TESTE RÁPIDO com status correto
  // console.log('Testing showToast with "ok" status...');


  $(".bill-install-now-24").on('click', function (e) {
    e.preventDefault();
    // console.log('Install button clicked');
    window.scrollTo(0, 0);

    $("#bill-wrap-install-modal").show();
    $("#loading-spinner").show();
    $(".bill-install-now").hide();
    var main_slug = $("#main_slug").val();
    var clickedButtonId = this.id;
    var slug = clickedButtonId.substring(1);
    $("#billimagewaitfbl").show();

    // console.log('Installing:', slug);

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "restore_classic_widgets_install_plugin2",
        slug: slug,
        nonce: restore_classic_widgets_install_params.nonce,
      },
      success: function (response) {
        // console.log("Success response:", response);
        // console.log("Response trimmed:", response.trim());

        if (response.trim() === "OK") {
          // console.log("✅ Showing toast for:", slug);

          // ✅ USAR STATUS "ok" (conforme definido no seu código)
          try {
            $("body").showToast(
              "Plugin " + slug + " Installed Successfully! <br> Go To Plugins page and activate it!",
              8000,
              "ok" // ✅ CORRETO: "ok" para verde
            );
            // console.log("✅ showToast called successfully with 'ok' status");
          } catch (e) {
            console.error("❌ showToast failed:", e);
            // Fallback para alert
            alert("Plugin " + slug + " installed successfully!\nGo to Plugins page and activate it!");
          }

          $(".bill-install-now").show();
          $("#loading-spinner").hide();
          $("#billimagewaitfbl").hide();

          // Recarregar após 8 segundos (tempo do toast)
          setTimeout(function () {
            window.location.reload();
          }, 8000);
        } else {
          console.log("❌ Response not OK:", response);
          // ✅ Toast de erro com status "nok"
          try {
            $("body").showToast("Installation failed!", 5000, "nok");
          } catch (e) {
            alert("Installation failed!");
          }
        }
      },
      error: function (xhr, status, error) {
        console.error("Error installing plugin:", error, xhr);
        // ✅ Toast de erro com status "nok"
        try {
          $("body").showToast("Error, please try again later!", 5000, "nok");
        } catch (e) {
          alert("Error, please try again later!");
        }
      }
    });
  });
});