/**
 * External dependencies
 */
import pick from "lodash/pick";
import get from "lodash/get";
import findIndex from "lodash/findIndex";

/**
 * WordPress dependencies
 */
import { isBlobURL } from "@wordpress/blob";

// Set dim ratio.
export function overlayToClass(ratio) {
  return ratio === 0 || ratio === 50
    ? null
    : "has-background-overlay-" + 10 * Math.round(ratio / 10);
}

// Pick image media attributes.
export const pickRelevantMediaFiles = (image, images) => {
  const imageProps = pick(image, ["alt", "id", "link", "caption", "imgLink", "rba_category"]);
  imageProps.url =
    get(image, ["sizes", "large", "url"]) ||
    get(image, ["media_details", "sizes", "large", "source_url"]) ||
    image.url;
  const imgKey = findIndex(images, function (img) {
    return img.url === imageProps.url;
  });
  imageProps.imgLink = imgKey >= 0 ? images[imgKey].imgLink : "";
  return imageProps;
};

/**
 * Is the URL a temporary blob URL? A blob URL is one that is used temporarily
 * while the image is being uploaded and will not have an id yet allocated.
 *
 * @param {number=} id The id of the image.
 * @param {string=} url The url of the image.
 *
 * @return {boolean} Is the URL a Blob URL
 */
export const isTemporaryImage = (id, url) => !id && isBlobURL(url);

// Define accepted media for gallery blocks.
export const ALLOWED_GALLERY_MEDIA_TYPES = ["image"];

export const convertTruthyFalsyValue = ( value ) => {
  switch( value ) {
    case "0":
    case 0:
    case false:
    case "false":
    case null:
    case undefined:
    case "":
      return false;
    case "1":
    case 1:
    case true:
    case "true":
      return true;
  }
};