/**
 * Internal dependencies
 */
import linkOptions from "./options/link-options";
import RbeaTabRadioControl from "../rbea-tab-radio-control";
/**
 * WordPress dependencies
 */
import { __ } from "@wordpress/i18n";
import { Component, Fragment } from "@wordpress/element";
import {
  SelectControl,
  ToggleControl,
  PanelBody,
  TextControl,
} from "@wordpress/components";

class GalleryLinkSettings extends Component {
  constructor() {
    super(...arguments);
    this.setNewTab = this.setNewTab.bind(this);
    this.setLinkRel = this.setLinkRel.bind(this);
    this.setLinkTo = this.setLinkTo.bind(this);
  }

  setLinkTo(value) {
    this.props.setAttributes({ linkTo: value });
  }

  setLinkRel(value) {
    this.props.setAttributes({ rel: value });
  }

  setNewTab(value) {
    const { rel } = this.props.attributes;
    const target = value ? "_blank" : undefined;

    let updatedRel = rel;
    if (target && !rel) {
      updatedRel = "noreferrer noopener";
    } else if (!target && rel === "noreferrer noopener") {
      updatedRel = undefined;
    }

    this.props.setAttributes({
      target,
      rel: updatedRel,
    });
  }

  render() {
    const { attributes, setAttributes } = this.props;

    const { lightbox, linkTo, target, rel } = attributes;

    return (
      <Fragment>
        {!lightbox && (
          <PanelBody
            title={__("Link settings", "responsive-block-editor-addons")}
            initialOpen={false}
          >
            <SelectControl
              label={__("Link to", "responsive-block-editor-addons")}
              value={linkTo}
              options={linkOptions}
              onChange={this.setLinkTo}
              __nextHasNoMarginBottom
              __next40pxDefaultSize={true}
            />
            {linkTo !== "none" && (
              <Fragment>
                <ToggleControl
                  label={__(
                    "Open in new tab",
                    "responsive-block-editor-addons"
                  )}
                  onChange={this.setNewTab}
                  checked={target === "_blank"}
                  __nextHasNoMarginBottom
                />
                <TextControl
                  /* translators: html attribute that specifies the relationship between two pages */
                  label={__("Link rel", "responsive-block-editor-addons")}
                  value={rel}
                  onChange={(value) => setAttributes({ rel: value })}
                  __nextHasNoMarginBottom
                  __next40pxDefaultSize={true}
                />
              </Fragment>
            )}
          </PanelBody>
        )}
      </Fragment>
    );
  }
}

export default GalleryLinkSettings;
