/**
 * External dependencies
 */
import { urlIsVideo, __getValue } from "../index.js";
import { camelCase } from "lodash";
import classnames from "classnames";

/**
 * WordPress dependencies
 */
import { Fragment } from "@wordpress/element";
import { sprintf } from "@wordpress/i18n";

export const createVideoBackground = (attrNameTemplate, blockProps) => {
  const getAttrName = (attrName) =>
    camelCase(sprintf(attrNameTemplate, attrName));
  const getValue = __getValue(blockProps.attributes, getAttrName, "");

  const mediaUrl = getValue("BackgroundMediaUrl");
  const tabletMediaUrl = getValue("TabletBackgroundMediaUrl");
  const mobileMediaUrl = getValue("MobileBackgroundMediaUrl");

  const desktopClassNames = classnames(
    ["responsive-block-editor-addons-video-background"],
    {
      "responsive-block-editor-addons--video-hide-tablet": tabletMediaUrl,
      "responsive-block-editor-addons--video-hide-mobile": mobileMediaUrl,
    }
  );
  const tabletClassNames = classnames(
    ["responsive-block-editor-addons-video-background"],
    {
      "responsive-block-editor-addons--video-hide-desktop": true,
      "responsive-block-editor-addons--video-hide-mobile": mobileMediaUrl,
    }
  );
  const mobileClassNames = classnames(
    ["responsive-block-editor-addons-video-background"],
    {
      "responsive-block-editor-addons--video-hide-desktop": true,
      "responsive-block-editor-addons--video-hide-tablet": true,
    }
  );

  return (
    <Fragment>
      {urlIsVideo(mediaUrl) && (
        <video
          className={desktopClassNames}
          autoPlay
          muted
          loop
          playsinline
          src={mediaUrl}
        />
      )}
      {urlIsVideo(tabletMediaUrl) && (
        <video
          className={tabletClassNames}
          autoPlay
          muted
          loop
          playsinline
          src={tabletMediaUrl}
        />
      )}
      {urlIsVideo(mobileMediaUrl) && (
        <video
          className={mobileClassNames}
          autoPlay
          muted
          loop
          playsinline
          src={mobileMediaUrl}
        />
      )}
    </Fragment>
  );
};
