const presets = [
    {
        id: 'info-preset-icon-center',
        label: 'Centered with Icon',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M31 42h47v8H31zM14 54h80v3H14zM30 61h48v3H30z" ></path> <path fill="#BFBFBF" stroke="#BFBFBF" strokeWidth="2" d="M52.59 22.017c.535-1.334.802-2.001 1.237-2.094a.8.8 0 0 1 .346 0c.435.093.703.76 1.238 2.094.304.758.456 1.137.74 1.395q.12.11.26.193c.329.198.74.235 1.56.308 1.392.125 2.087.187 2.3.584a.8.8 0 0 1 .088.263c.07.444-.441.909-1.463 1.84l-.284.257c-.478.435-.717.653-.855.924a1.7 1.7 0 0 0-.165.519c-.044.301.026.617.166 1.247l.05.226c.252 1.131.377 1.697.22 1.975-.14.25-.4.41-.686.423-.319.015-.768-.35-1.666-1.083-.592-.482-.888-.723-1.217-.817a1.67 1.67 0 0 0-.918 0c-.329.094-.625.335-1.216.817-.899.732-1.348 1.098-1.667 1.083a.83.83 0 0 1-.686-.423c-.157-.278-.031-.844.22-1.975l.05-.226c.14-.63.21-.946.166-1.247a1.7 1.7 0 0 0-.164-.519c-.138-.271-.377-.489-.855-.924l-.284-.258c-1.023-.93-1.534-1.395-1.463-1.84a.8.8 0 0 1 .088-.262c.212-.397.908-.459 2.298-.584.822-.073 1.233-.11 1.562-.308a1.7 1.7 0 0 0 .258-.193c.285-.258.437-.637.742-1.395Z" ></path> </svg>',
        attributes: {
            resheadingAlign: 'center',
            source_type: 'icon',
        },
    },
    {
        id: 'info-preset-icon-left',
        label: 'Left with Icon',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M14 42h47v8H14z"></path> <path fill="#D3D3D3" d="M14 54h80v3H14zM14 61h48v3H14z"></path> <path fill="#BFBFBF" stroke="#BFBFBF" strokeWidth="2" d="M22.59 22.017c.535-1.334.802-2.001 1.237-2.094a.8.8 0 0 1 .346 0c.435.093.703.76 1.238 2.094.304.758.456 1.137.74 1.395q.12.11.26.193c.329.198.74.235 1.56.308 1.392.125 2.087.187 2.3.584a.8.8 0 0 1 .088.263c.07.444-.441.909-1.463 1.84l-.284.257c-.478.435-.717.653-.855.924a1.7 1.7 0 0 0-.165.519c-.043.301.027.617.167 1.247l.05.226c.25 1.131.376 1.697.22 1.975-.141.25-.4.41-.687.423-.319.015-.768-.35-1.666-1.083-.592-.482-.888-.723-1.216-.817a1.67 1.67 0 0 0-.92 0c-.328.094-.624.335-1.215.817-.899.732-1.348 1.098-1.667 1.083a.83.83 0 0 1-.686-.423c-.157-.278-.031-.844.22-1.975l.05-.226c.14-.63.21-.946.166-1.247a1.7 1.7 0 0 0-.164-.519c-.138-.271-.377-.489-.855-.924l-.284-.258c-1.023-.93-1.534-1.395-1.463-1.84a.8.8 0 0 1 .088-.262c.212-.397.908-.459 2.298-.584.822-.073 1.233-.11 1.562-.308a1.7 1.7 0 0 0 .259-.193c.284-.258.436-.637.74-1.395Z" ></path> </svg>',
        attributes: {
            resheadingAlign: 'left',
            source_type: 'icon',
        },
    },
    {
        id: 'info-preset-image-center',
        label: 'Centered with Image',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" viewBox="0 0 108 80" fill="none"> <rect x="0.5" y="0.5" width="107" height="79" rx="3.5" fill="white" stroke="#D9D9D9"/> <rect x="31" y="42" width="47" height="8" fill="#BFBFBF"/> <rect x="14" y="54" width="80" height="3" fill="#D3D3D3"/> <rect x="30" y="61" width="48" height="3" fill="#D3D3D3"/> <rect width="24" height="24" transform="translate(42 12)" fill="#B2B2B2" fill-opacity="0.3"/> <path d="M59.5 28.2778V19.7222C59.5 19.05 58.95 18.5 58.2778 18.5H49.7222C49.05 18.5 48.5 19.05 48.5 19.7222V28.2778C48.5 28.95 49.05 29.5 49.7222 29.5H58.2778C58.95 29.5 59.5 28.95 59.5 28.2778ZM51.8611 24.9167L53.3889 26.7561L55.5278 24L58.2778 27.6667H49.7222L51.8611 24.9167Z" fill="#B2B2B2"/> </svg>',
        attributes: {
            resheadingAlign: 'center',
            source_type: 'image',
        },
    },
    {
        id: 'info-preset-image-left',
        label: 'Left with Image',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" viewBox="0 0 108 80" fill="none"> <rect x="0.5" y="0.5" width="107" height="79" rx="3.5" fill="white" stroke="#D9D9D9"/> <rect x="14" y="42" width="47" height="8" fill="#BFBFBF"/> <rect x="14" y="54" width="80" height="3" fill="#D3D3D3"/> <rect x="14" y="61" width="48" height="3" fill="#D3D3D3"/> <rect width="24" height="24" transform="translate(14 12)" fill="#B2B2B2" fill-opacity="0.3"/> <path d="M31.5 28.2778V19.7222C31.5 19.05 30.95 18.5 30.2778 18.5H21.7222C21.05 18.5 20.5 19.05 20.5 19.7222V28.2778C20.5 28.95 21.05 29.5 21.7222 29.5H30.2778C30.95 29.5 31.5 28.95 31.5 28.2778ZM23.8611 24.9167L25.3889 26.7561L27.5278 24L30.2778 27.6667H21.7222L23.8611 24.9167Z" fill="#B2B2B2"/> </svg>',
        attributes: {
            resheadingAlign: 'left',
            source_type: 'image',
        },
    },
    {
        id: 'info-preset-center',
        label: 'Centered',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M31 19h47v8H31zM43 55h23v6H43z"></path> <path fill="#D3D3D3" d="M14 33h80v3H14zM30 40h48v3H30z"></path> </svg>',
        attributes: {
            resheadingAlign: 'center',
            source_type: 'none',
        },
    },
    {
        id: 'info-preset-left',
        label: 'Left',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M14 19h47v8H14zM14 55h23v6H14z"></path> <path fill="#D3D3D3" d="M14 33h80v3H14zM14 40h48v3H14z"></path> </svg>',
        attributes: {
            resheadingAlign: 'left',
            source_type: 'none',
        },
    },
];

const resetPreset = {
    resheadingAlign: 'center',
    source_type: 'icon',
};

const filledPreset = {
    buttonbackgroundType: 'color',
    ctaBackColor: '#000000',
    ctaColor: '#ffffff',
}

const outlinedPreset = {
    buttonbackgroundType: 'color',
    ctaBackColor: '#ffffff',
    ctaColor: '#000000',
    ctaBorderColor: '#000000',
}

const preset1BorderRadius = {
    ctaBlockBottomRadius: 0,
    ctaBlockBottomRadiusMobile: 0,
    ctaBlockBottomRadiusTablet: 0,
    ctaBlockLeftRadius: 0,
    ctaBlockLeftRadiusMobile: 0,
    ctaBlockLeftRadiusTablet: 0,
    ctaBlockRightRadius: 0,
    ctaBlockRightRadiusMobile: 0,
    ctaBlockRightRadiusTablet: 0,
    ctaBlockTopRadius: 0,
    ctaBlockTopRadiusMobile: 0,
    ctaBlockTopRadiusTablet: 0,
}

const preset2BorderRadius = {
    ctaBlockBottomRadius: 10,
    ctaBlockBottomRadiusMobile: 10,
    ctaBlockBottomRadiusTablet: 10,
    ctaBlockLeftRadius: 10,
    ctaBlockLeftRadiusMobile: 10,
    ctaBlockLeftRadiusTablet: 10,
    ctaBlockRightRadius: 10,
    ctaBlockRightRadiusMobile: 10,
    ctaBlockRightRadiusTablet: 10,
    ctaBlockTopRadius: 10,
    ctaBlockTopRadiusMobile: 10,
    ctaBlockTopRadiusTablet: 10,
}

const preset3BorderRadius = {
    ctaBlockBottomRadius: 50,
    ctaBlockBottomRadiusMobile: 50,
    ctaBlockBottomRadiusTablet: 50,
    ctaBlockLeftRadius: 50,
    ctaBlockLeftRadiusMobile: 50,
    ctaBlockLeftRadiusTablet: 50,
    ctaBlockRightRadius: 50,
    ctaBlockRightRadiusMobile: 50,
    ctaBlockRightRadiusTablet: 50,
    ctaBlockTopRadius: 50,
    ctaBlockTopRadiusMobile: 50,
    ctaBlockTopRadiusTablet: 50,
}

const resetButtonPreset = {
    buttonbackgroundType: 'color',
    ctaBackColor: '',
    ctaColor: '#000000',
    ctaBlockBottomRadius: 0,
    ctaBlockBottomRadiusMobile: 0,
    ctaBlockBottomRadiusTablet: 0,
    ctaBlockLeftRadius: 0,
    ctaBlockLeftRadiusMobile: 0,
    ctaBlockLeftRadiusTablet: 0,
    ctaBlockRightRadius: 0,
    ctaBlockRightRadiusMobile: 0,
    ctaBlockRightRadiusTablet: 0,
    ctaBlockTopRadius: 0,
    ctaBlockTopRadiusMobile: 0,
    ctaBlockTopRadiusTablet: 0,
}

const buttonPreset = [
    {
        id: 'button-preset1',
        label: 'Preset1',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M17 31h74v18H17z"></path> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset1BorderRadius,
            ...filledPreset,
        },
    },
    {
        id: 'button-preset2',
        label: 'Preset2',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="74" height="18" x="17" y="31" fill="#BFBFBF" rx="3"></rect> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...filledPreset,
        },
    },
    {
        id: 'button-preset3',
        label: 'Preset3',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="74" height="18" x="17" y="31" fill="#BFBFBF" rx="9"></rect> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset3BorderRadius,
            ...filledPreset,
        },
    },
    {
        id: 'button-preset4',
        label: 'Preset4',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#fff" stroke="#BFBFBF" d="M17.5 31.5h73v17h-73z"></path> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset1BorderRadius,
            ...outlinedPreset,
        },
    },
    {
        id: 'button-preset5',
        label: 'Preset5',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="73" height="17" x="17.5" y="31.5" fill="#fff" stroke="#BFBFBF" rx="2.5" ></rect> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...outlinedPreset,
        },
    },
    {
        id: 'button-preset6',
        label: 'Preset6',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="73" height="17" x="17.5" y="31.5" fill="#fff" stroke="#BFBFBF" rx="8.5" ></rect> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset3BorderRadius,
            ...outlinedPreset,
        },
    },
];

export {presets, resetPreset, buttonPreset, resetButtonPreset};