/**
 * Returns Dynamic Generated CSS
 */

import generateCSS from "../../../generateCSS";
import generateCSSUnit from "../../../generateCSSUnit";

function EditorStyles(props) {
  const {
    formLabelSize,
    formLabelInputGap,
    formInputSize,
    formFieldInputGap,
    inputFieldPadding,
    inputFieldPaddingTablet,
    inputFieldPaddingMobile,
    formButtonLabelColor,
    formButtonLabelBGColor,
    formButtonLabelHoverColor,
    formButtonLabelHoverBGColor,
    formButtonPadding,
    formButtonPaddingTablet,
    formButtonPaddingMobile,
    formButtonBorderRadius,
    formButtonTopRadius,
    formButtonRightRadius,
    formButtonBottomRadius,
    formButtonLeftRadius,
    formButtonTopRadiusTablet,
    formButtonRightRadiusTablet,
    formButtonBottomRadiusTablet,
    formButtonLeftRadiusTablet,
    formButtonTopRadiusMobile,
    formButtonRightRadiusMobile,
    formButtonBottomRadiusMobile,
    formButtonLeftRadiusMobile,
    formButtonAlign,
    formButtonAlignTablet,
    formButtonAlignMobile,
    formLabelColor,
    formInputTextColor,
    formInputBGColor,
    formBorderColor,
    formHelperLabelColor,
    formRequiredLabelColor,
    formSuccessMessageColor,
    formErrorMessageColor,
    formBorderRadius,
    formTopRadius,
    formRightRadius,
    formBottomRadius,
    formLeftRadius,
    formTopRadiusTablet,
    formRightRadiusTablet,
    formBottomRadiusTablet,
    formLeftRadiusTablet,
    formTopRadiusMobile,
    formRightRadiusMobile,
    formBottomRadiusMobile,
    formLeftRadiusMobile,
    formBorderWidth,
    formHelperTextSize,
    formSuccessErrorMessageSize,
    block_id,
    hideWidget,
    hideWidgetTablet,
    hideWidgetMobile,
    formTopPadding,
    formTopPaddingMobile,
    formTopPaddingTablet,
    formBottomPadding,
    formBottomPaddingMobile,
    formBottomPaddingTablet,
    formLeftPadding,
    formLeftPaddingMobile,
    formLeftPaddingTablet,
    formRightPadding,
    formRightPaddingMobile,
    formRightPaddingTablet,
    formTopMargin,
    formTopMarginMobile,
    formTopMarginTablet,
    formBottomMargin,
    formBottomMarginMobile,
    formBottomMarginTablet,
    formLeftMargin,
    formLeftMarginMobile,
    formLeftMarginTablet,
    formRightMargin,
    formRightMarginMobile,
    formRightMarginTablet,

    formButtonTopPadding,
    formButtonBottomPadding,
    formButtonLeftPadding,
    formButtonRightPadding,
    formButtonTopPaddingTablet,
    formButtonBottomPaddingTablet,
    formButtonRightPaddingTablet,
    formButtonLeftPaddingTablet,
    formButtonTopPaddingMobile,
    formButtonBottomPaddingMobile,
    formButtonLeftPaddingMobile,
    formButtonRightPaddingMobile,
    inputFieldTopPadding,
    inputFieldBottomPadding,
    inputFieldLeftPadding,
    inputFieldRightPadding,
    inputFieldTopPaddingTablet,
    inputFieldBottomPaddingTablet,
    inputFieldRightPaddingTablet,
    inputFieldLeftPaddingTablet,
    inputFieldTopPaddingMobile,
    inputFieldBottomPaddingMobile,
    inputFieldLeftPaddingMobile,
    inputFieldRightPaddingMobile,

    formBlockBorderTopWidth,
    formBlockBorderTopWidthMobile,
    formBlockBorderTopWidthTablet,
    formBlockBorderBottomWidth,
    formBlockBorderBottomWidthMobile,
    formBlockBorderBottomWidthTablet,
    formBlockBorderLeftWidth,
    formBlockBorderLeftWidthMobile,
    formBlockBorderLeftWidthTablet,
    formBlockBorderRightWidth,
    formBlockBorderRightWidthTablet,
    formBlockBorderRightWidthMobile,
  } = props.attributes;
  const isOn = responsive_globals?.is_responsive_conditions_on ?? 1;

  var selectors = {
    "": {
      "opacity": hideWidget && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(formTopPadding, "px"),
      "padding-right": generateCSSUnit(formRightPadding, "px"),
      "padding-bottom": generateCSSUnit(formBottomPadding, "px"),
      "padding-left": generateCSSUnit(formLeftPadding, "px"),
      "margin-top": generateCSSUnit(formTopMargin, "px"),
      "margin-right": generateCSSUnit(formRightMargin, "px"),
      "margin-bottom": generateCSSUnit(formBottomMargin, "px"),
      "margin-left": generateCSSUnit(formLeftMargin, "px"),
    },
    " .responsive-block-editor-addons-form-input": {
      "margin-bottom": generateCSSUnit(formFieldInputGap, "px"),
    },
    " .responsive-block-editor-addons-form-input-label": {
      "font-size": formLabelSize,
      "margin-bottom": generateCSSUnit(formLabelInputGap, "px"),
    },
    " .responsive-block-editor-addons-form-input__label": {
      "color": formLabelColor,
    },
    " .responsive-block-editor-addons-form-input__required": {
      "color": formRequiredLabelColor === undefined || formRequiredLabelColor === '' ? '#ff0000' : formRequiredLabelColor,
    },
    " .responsive-block-editor-addons-form-input__input": {
      "font-size": formInputSize,
      "color": formInputTextColor,
      "background-color": formInputBGColor,
      "border-color": formBorderColor === undefined || formBorderColor === '' ? '#111111': formBorderColor,
      "border-top-left-radius": generateCSSUnit(formTopRadius, "px"),
      "border-top-right-radius": generateCSSUnit(formRightRadius, "px"),
      "border-bottom-right-radius": generateCSSUnit(formBottomRadius, "px"),
      "border-bottom-left-radius": generateCSSUnit(formLeftRadius, "px"),
      "border-top-width": generateCSSUnit(formBlockBorderTopWidth, "px"),
      "border-bottom-width": generateCSSUnit(formBlockBorderBottomWidth, "px"),
      "border-left-width": generateCSSUnit(formBlockBorderLeftWidth, "px"),
      "border-right-width": generateCSSUnit(formBlockBorderRightWidth, "px"),
    },
    " .responsive-block-editor-addons-form-input__text": {
      "padding-top": inputFieldTopPadding,
      "padding-bottom": inputFieldBottomPadding,
      "padding-left": inputFieldLeftPadding,
      "padding-right": inputFieldRightPadding,
    },
    " .responsive-block-editor-addons-form-input__helper": {
      "color": formHelperLabelColor,
      "font-size": formHelperTextSize,
    },
    " .responsive-block-editor-addons-form-submit-button-container": {
      "justify-content": formButtonAlign,
      "margin-top": generateCSSUnit(formFieldInputGap, "px"),
    },
    " .responsive-block-editor-addons-form-submit-button": {
      "color": formButtonLabelColor,
      "background-color": formButtonLabelBGColor,
      "padding-top": generateCSSUnit(formButtonTopPadding, "px"),
      "padding-bottom": generateCSSUnit(formButtonBottomPadding, "px"),
      "padding-left": generateCSSUnit(formButtonLeftPadding, "px"),
      "padding-right": generateCSSUnit(formButtonRightPadding, "px"),
      "border-top-left-radius": generateCSSUnit(formButtonTopRadius, "px"),
      "border-top-right-radius": generateCSSUnit(formButtonRightRadius, "px"),
      "border-bottom-right-radius": generateCSSUnit(formButtonBottomRadius, "px"),
      "border-bottom-left-radius": generateCSSUnit(formButtonLeftRadius, "px"),
    },
    " .responsive-block-editor-addons-form-submit-button:hover": {
      "color": formButtonLabelHoverColor,
      "background-color": formButtonLabelHoverBGColor,
    },
    " .responsive-block-editor-addons-form-submit-success-message": {
      "color": formSuccessMessageColor === undefined || formSuccessMessageColor === '' ? '#008000' : formSuccessMessageColor,
      "font-size": formSuccessErrorMessageSize,
    },
    " .responsive-block-editor-addons-form-submit-error-message": {
      "color": formErrorMessageColor === undefined || formErrorMessageColor === '' ? '#FF0000' : formErrorMessageColor,
      "font-size": formSuccessErrorMessageSize,
    },
  };

  var mobile_selectors = {
    "": {
      "opacity": hideWidgetMobile && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(formTopPaddingMobile, "px"),
      "padding-right": generateCSSUnit(formRightPaddingMobile, "px"),
      "padding-bottom": generateCSSUnit(formBottomPaddingMobile, "px"),
      "padding-left": generateCSSUnit(formLeftPaddingMobile, "px"),
      "margin-top": generateCSSUnit(formTopMarginMobile, "px"),
      "margin-right": generateCSSUnit(formRightMarginMobile, "px"),
      "margin-bottom": generateCSSUnit(formBottomMarginMobile, "px"),
      "margin-left": generateCSSUnit(formLeftMarginMobile, "px"),
    },
    " .responsive-block-editor-addons-form-input__input": {
      "border-top-left-radius": generateCSSUnit(formTopRadiusMobile, "px"),
      "border-top-right-radius": generateCSSUnit(formRightRadiusMobile, "px"),
      "border-bottom-right-radius": generateCSSUnit(formBottomRadiusMobile, "px"),
      "border-bottom-left-radius": generateCSSUnit(formLeftRadiusMobile, "px"),

      "border-top-width": generateCSSUnit(formBlockBorderTopWidthMobile, "px"),
      "border-bottom-width": generateCSSUnit(formBlockBorderBottomWidthMobile, "px"),
      "border-left-width": generateCSSUnit(formBlockBorderLeftWidthMobile, "px"),
      "border-right-width": generateCSSUnit(formBlockBorderRightWidthMobile, "px"),
    },
    " .responsive-block-editor-addons-form-input__text": {
      "padding-top": inputFieldTopPaddingMobile,
      "padding-bottom": inputFieldBottomPaddingMobile,
      "padding-left": inputFieldLeftPaddingMobile,
      "padding-right": inputFieldRightPaddingMobile,
    },
    " .responsive-block-editor-addons-form-submit-button-container": {
      "justify-content": formButtonAlignMobile,
    },
    " .responsive-block-editor-addons-form-submit-button": {
      "padding-top": generateCSSUnit(formButtonTopPaddingMobile, "px"),
      "padding-bottom": generateCSSUnit(formButtonBottomPaddingMobile, "px"),
      "padding-left": generateCSSUnit(formButtonLeftPaddingMobile, "px"),
      "padding-right": generateCSSUnit(formButtonRightPaddingMobile, "px"),
      "border-top-left-radius": generateCSSUnit(formButtonTopRadiusMobile, "px"),
      "border-top-right-radius": generateCSSUnit(formButtonRightRadiusMobile, "px"),
      "border-bottom-right-radius": generateCSSUnit(formButtonBottomRadiusMobile, "px"),
      "border-bottom-left-radius": generateCSSUnit(formButtonLeftRadiusMobile, "px"),
    },
  };

  var tablet_selectors = {
    "": {
      "opacity": hideWidgetTablet && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(formTopPaddingTablet, "px"),
      "padding-right": generateCSSUnit(formRightPaddingTablet, "px"),
      "padding-bottom": generateCSSUnit(formBottomPaddingTablet, "px"),
      "padding-left": generateCSSUnit(formLeftPaddingTablet, "px"),
      "margin-top": generateCSSUnit(formTopMarginTablet, "px"),
      "margin-right": generateCSSUnit(formRightMarginTablet, "px"),
      "margin-bottom": generateCSSUnit(formBottomMarginTablet, "px"),
      "margin-left": generateCSSUnit(formLeftMarginTablet, "px"),
    },
    " .responsive-block-editor-addons-form-input__input": {
      "border-top-left-radius": generateCSSUnit(formTopRadiusTablet, "px"),
      "border-top-right-radius": generateCSSUnit(formRightRadiusTablet, "px"),
      "border-bottom-right-radius": generateCSSUnit(formBottomRadiusTablet, "px"),
      "border-bottom-left-radius": generateCSSUnit(formLeftRadiusTablet, "px"),

      "border-top-width": generateCSSUnit(formBlockBorderTopWidthTablet, "px"),
      "border-bottom-width": generateCSSUnit(formBlockBorderBottomWidthTablet, "px"),
      "border-left-width": generateCSSUnit(formBlockBorderLeftWidthTablet, "px"),
      "border-right-width": generateCSSUnit(formBlockBorderRightWidthTablet, "px"),
    },
    " .responsive-block-editor-addons-form-input__text": {
      "padding-top": inputFieldTopPaddingTablet,
      "padding-bottom": inputFieldBottomPaddingTablet,
      "padding-left": inputFieldLeftPaddingTablet,
      "padding-right": inputFieldRightPaddingTablet,
    },
    " .responsive-block-editor-addons-form-submit-button-container": {
      "justify-content": formButtonAlignTablet,
    },
    " .responsive-block-editor-addons-form-submit-button": {
      "padding-top": generateCSSUnit(formButtonTopPaddingTablet, "px"),
      "padding-bottom": generateCSSUnit(formButtonBottomPaddingTablet, "px"),
      "padding-left": generateCSSUnit(formButtonLeftPaddingTablet, "px"),
      "padding-right": generateCSSUnit(formButtonRightPaddingTablet, "px"),
      "border-top-left-radius": generateCSSUnit(formButtonTopRadiusTablet, "px"),
      "border-top-right-radius": generateCSSUnit(formButtonRightRadiusTablet, "px"),
      "border-bottom-right-radius": generateCSSUnit(formButtonBottomRadiusTablet, "px"),
      "border-bottom-left-radius": generateCSSUnit(formButtonLeftRadiusTablet, "px"),
    },
  };

  var styling_css = "";
  var id = `.responsive-block-editor-addons-block-form.block-${block_id}`;

  styling_css = generateCSS(selectors, id);
  styling_css += generateCSS(tablet_selectors, id, true, "tablet");
  styling_css += generateCSS(mobile_selectors, id, true, "mobile");

  return styling_css;
}

export default EditorStyles;
