/**
 * Returns Dynamic Generated CSS
 */

import generateCSS from "../../../generateCSS";
import generateCSSUnit from "../../../generateCSSUnit";

function EditorStyles(props) {
  const {
    block_id,
    expandAlignment,
    linkSpace,
    textSpace,
    titleSpace,
    linkSpaceMobile,
    textSpaceMobile,
    titleSpaceMobile,
    linkSpaceTablet,
    textSpaceTablet,
    titleSpaceTablet,
    titleFontFamily,
    titleFontSize,
    titleFontWeight,
    titleLineHeight,
    textFontFamily,
    textFontSize,
    textFontWeight,
    textLineHeight,
    linkFontFamily,
    linkFontSize,
    linkFontWeight,
    linkLineHeight,
    textColor,
    linkColor,
    titleColor,
	titleFontSizeMobile,
	titleFontSizeTablet,
	textFontSizeMobile,
	textFontSizeTablet,
	linkFontSizeMobile,
	linkFontSizeTablet,
  hideWidget,
  hideWidgetTablet,
  hideWidgetMobile,
  blockTopPadding,
  blockTopPaddingMobile,
  blockTopPaddingTablet,
  blockBottomPadding,
  blockBottomPaddingMobile,
  blockBottomPaddingTablet,
  blockLeftPadding,
  blockLeftPaddingMobile,
  blockLeftPaddingTablet,
  blockRightPadding,
  blockRightPaddingMobile,
  blockRightPaddingTablet,
  blockTopMargin,
  blockTopMarginMobile,
  blockTopMarginTablet,
  blockBottomMargin,
  blockBottomMarginMobile,
  blockBottomMarginTablet,
  blockLeftMargin,
  blockLeftMarginMobile,
  blockLeftMarginTablet,
  blockRightMargin,
  blockRightMarginMobile,
  blockRightMarginTablet,
  titleTypographyColor,
  linkTypographyColor,
  textTypographyColor,
  titleBottomSpacing,
        titleBottomSpacingTablet,
        titleBottomSpacingMobile,

        textBottomSpacing,
        textBottomSpacingTablet,
        textBottomSpacingMobile,

        linkBottomSpacing,
        linkBottomSpacingTablet,
        linkBottomSpacingMobile,
        titleTextTransform,
        titleFontStyle,
        textTextTransform,
        textFontStyle,
        linkTextTransform,
        linkFontStyle,
  } = props.attributes;
  const isOn = responsive_globals?.is_responsive_conditions_on ?? 1;

  var selectors = {
    " ": {
      "opacity": hideWidget && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(blockTopPadding, "px"),
      "padding-right": generateCSSUnit(blockRightPadding, "px"),
      "padding-bottom": generateCSSUnit(blockBottomPadding, "px"),
      "padding-left": generateCSSUnit(blockLeftPadding, "px"),
      "margin-top": generateCSSUnit(blockTopMargin, "px"),
      "margin-right": generateCSSUnit(blockRightMargin, "px"),
      "margin-bottom": generateCSSUnit(blockBottomMargin, "px"),
      "margin-left": generateCSSUnit(blockLeftMargin, "px"),
    },

    " .responsive-block-editor-addons-expand-block-content": {
      "text-align": expandAlignment,
    },

    " .responsive-block-editor-addons-expand-title": {
      "margin-bottom": generateCSSUnit(titleBottomSpacing, "px"),
      "font-family": titleFontFamily,
      "font-size": generateCSSUnit(titleFontSize, "px"),
      "font-weight": titleFontWeight,
      "line-height": titleLineHeight,
      "color": titleTypographyColor,
      "text-transform": titleTextTransform,
      "font-style": titleFontStyle,
    },

    " .responsive-block-editor-addons-expand-less-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacing, "px"),
      "font-family": textFontFamily,
      "font-size": generateCSSUnit(textFontSize, "px"),
      "font-weight": textFontWeight,
      "line-height": textLineHeight,
      "color": textTypographyColor,
      "text-transform": textTextTransform,
      "font-style": textFontStyle,
    },

    " .responsive-block-editor-addons-expand-more-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacing, "px"),
      "font-family": linkFontFamily,
      "font-size": generateCSSUnit(linkFontSize, "px"),
      "font-weight": linkFontWeight,
      "line-height": linkLineHeight,
      "color": linkTypographyColor,
      "text-transform": linkTextTransform,
      "font-style": linkFontStyle,
    },

    " .responsive-block-editor-addons-expand-more-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacing, "px"),
      "font-family": textFontFamily,
      "font-size": generateCSSUnit(textFontSize, "px"),
      "font-weight": textFontWeight,
      "line-height": textLineHeight,
      "color": textTypographyColor,
      "text-transform": textTextTransform,
      "font-style": textFontStyle,
    },

    " .responsive-block-editor-addons-expand-less-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacing, "px"),
      "font-family": linkFontFamily,
      "font-size": generateCSSUnit(linkFontSize, "px"),
      "font-weight": linkFontWeight,
      "line-height": linkLineHeight,
      "color": linkTypographyColor,
      "text-transform": linkTextTransform,
      "font-style": linkFontStyle,
    },
  };

  var mobile_selectors = {
    " ": {
      "opacity": hideWidgetMobile && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(blockTopPaddingMobile, "px"),
      "padding-right": generateCSSUnit(blockRightPaddingMobile, "px"),
      "padding-bottom": generateCSSUnit(blockBottomPaddingMobile, "px"),
      "padding-left": generateCSSUnit(blockLeftPaddingMobile, "px"),
      "margin-top": generateCSSUnit(blockTopMarginMobile, "px"),
      "margin-right": generateCSSUnit(blockRightMarginMobile, "px"),
      "margin-bottom": generateCSSUnit(blockBottomMarginMobile, "px"),
      "margin-left": generateCSSUnit(blockLeftMarginMobile, "px"),
    },
    " .responsive-block-editor-addons-expand-title": {
      "margin-bottom": generateCSSUnit(titleBottomSpacingMobile, "px"),
	  "font-size": generateCSSUnit(titleFontSizeMobile, "px"),
    },
    " .responsive-block-editor-addons-expand-less-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacingMobile, "px"),
	  "font-size": generateCSSUnit(textFontSizeMobile, "px"),
    },
    " .responsive-block-editor-addons-expand-more-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacingMobile, "px"),
	  "font-size": generateCSSUnit(linkFontSizeMobile, "px"),
    },
    " .responsive-block-editor-addons-expand-more-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacingMobile, "px"),
	  "font-size": generateCSSUnit(textFontSizeMobile, "px"),
    },
    " .responsive-block-editor-addons-expand-less-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacingMobile, "px"),
	  "font-size": generateCSSUnit(linkFontSizeMobile, "px"),
    },
  };

  var tablet_selectors = {
    " ": {
      "opacity": hideWidgetTablet && isOn ? 0.2 : 1,
      "padding-top": generateCSSUnit(blockTopPaddingTablet, "px"),
      "padding-right": generateCSSUnit(blockRightPaddingTablet, "px"),
      "padding-bottom": generateCSSUnit(blockBottomPaddingTablet, "px"),
      "padding-left": generateCSSUnit(blockLeftPaddingTablet, "px"),
      "margin-top": generateCSSUnit(blockTopMarginTablet, "px"),
      "margin-right": generateCSSUnit(blockRightMarginTablet, "px"),
      "margin-bottom": generateCSSUnit(blockBottomMarginTablet, "px"),
      "margin-left": generateCSSUnit(blockLeftMarginTablet, "px"),
    },
    " .responsive-block-editor-addons-expand-title": {
      "margin-bottom": generateCSSUnit(titleBottomSpacingTablet, "px"),
	  "font-size": generateCSSUnit(titleFontSizeTablet, "px"),
    },
    " .responsive-block-editor-addons-expand-less-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacingTablet, "px"),
	  "font-size": generateCSSUnit(textFontSizeTablet, "px"),
    },
    " .responsive-block-editor-addons-expand-more-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacingTablet, "px"),
	  "font-size": generateCSSUnit(linkFontSizeTablet, "px"),
    },
    " .responsive-block-editor-addons-expand-more-text": {
      "margin-bottom": generateCSSUnit(textBottomSpacingTablet, "px"),
	  "font-size": generateCSSUnit(textFontSizeTablet, "px"),
    },
    " .responsive-block-editor-addons-expand-less-toggle-text": {
      "margin-bottom": generateCSSUnit(linkBottomSpacingTablet, "px"),
	  "font-size": generateCSSUnit(linkFontSizeTablet, "px"),
    },
  };

  var styling_css = "";
  var id = `.responsive-block-editor-addons-block-expand.block-${block_id}`;

  styling_css = generateCSS(selectors, id);
  styling_css += generateCSS(tablet_selectors, id, true, "tablet");
  styling_css += generateCSS(mobile_selectors, id, true, "mobile");

  return styling_css;
}

export default EditorStyles;
