function renderCustomIcon( svg ) {
	let customSVG = '';

	switch ( svg ) {
		// Align
		case 'align-center':
			customSVG = (
				<svg id="icon-format_align_center" viewBox="0 0 24 24">
					<path d="M3 3h18v2.016h-18v-2.016zM6.984 6.984h10.031v2.016h-10.031v-2.016zM3 12.984v-1.969h18v1.969h-18zM3 21v-2.016h18v2.016h-18zM6.984 15h10.031v2.016h-10.031v-2.016z"></path>
				</svg>
			);
			break;
		case 'align-left':
			customSVG = (
				<svg id="icon-format_align_left" viewBox="0 0 24 24">
					<path d="M3 3h18v2.016h-18v-2.016zM3 21v-2.016h18v2.016h-18zM3 12.984v-1.969h18v1.969h-18zM15 6.984v2.016h-12v-2.016h12zM15 15v2.016h-12v-2.016h12z"></path>
				</svg>
			);
			break;
		case 'align-right':
			customSVG = (
				<svg id="icon-format_align_right" viewBox="0 0 24 24">
					<path d="M3 3h18v2.016h-18v-2.016zM9 9v-2.016h12v2.016h-12zM3 12.984v-1.969h18v1.969h-18zM9 17.016v-2.016h12v2.016h-12zM3 21v-2.016h18v2.016h-18z"></path>
				</svg>
			);
			break;
		// Flex Row
		case 'flex-row-start':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
					<path d="M5 6L9 6C9.53027 6.00053 10.0387 6.21141 10.4136 6.58637C10.7886 6.96133 10.9995 7.46973 11 8L11 23C10.9995 23.5303 10.7886 24.0387 10.4136 24.4136C10.0387 24.7886 9.53027 24.9995 9 25H5C4.46973 24.9995 3.96133 24.7886 3.58637 24.4136C3.21141 24.0387 3.00053 23.5303 3 23L3 8C3.00053 7.46973 3.21141 6.96133 3.58637 6.58637C3.96133 6.21141 4.46973 6.00053 5 6Z" />
					<path d="M14 6L18 6C18.5303 6.00053 19.0387 6.21141 19.4136 6.58637C19.7886 6.96133 19.9995 7.46973 20 8L20 23C19.9995 23.5303 19.7886 24.0387 19.4136 24.4136C19.0387 24.7886 18.5303 24.9995 18 25H14C13.4697 24.9995 12.9613 24.7886 12.5864 24.4136C12.2114 24.0387 12.0005 23.5303 12 23L12 8C12.0005 7.46973 12.2114 6.96133 12.5864 6.58637C12.9613 6.21141 13.4697 6.00053 14 6Z" />
				</svg>
			);
			break;
		case 'flex-row-end':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path d="M14 6L18 6C18.5303 6.00053 19.0387 6.21141 19.4136 6.58637C19.7886 6.96133 19.9995 7.46973 20 8L20 23C19.9995 23.5303 19.7886 24.0387 19.4136 24.4136C19.0387 24.7886 18.5303 24.9995 18 25H14C13.4697 24.9995 12.9613 24.7886 12.5864 24.4136C12.2114 24.0387 12.0005 23.5303 12 23L12 8C12.0005 7.46973 12.2114 6.96133 12.5864 6.58637C12.9613 6.21141 13.4697 6.00053 14 6Z" />
					<path d="M23 6L27 6C27.5303 6.00053 28.0387 6.21141 28.4136 6.58637C28.7886 6.96133 28.9995 7.46973 29 8L29 23C28.9995 23.5303 28.7886 24.0387 28.4136 24.4136C28.0387 24.7886 27.5303 24.9995 27 25H23C22.4697 24.9995 21.9613 24.7886 21.5864 24.4136C21.2114 24.0387 21.0005 23.5303 21 23L21 8C21.0005 7.46973 21.2114 6.96133 21.5864 6.58637C21.9613 6.21141 22.4697 6.00053 23 6Z" />
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
				</svg>
			);
			break;
		case 'flex-row-center':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
					<path d="M9 6L13 6C13.5303 6.00053 14.0387 6.21141 14.4136 6.58637C14.7886 6.96133 14.9995 7.46973 15 8L15 23C14.9995 23.5303 14.7886 24.0387 14.4136 24.4136C14.0387 24.7886 13.5303 24.9995 13 25H9C8.46973 24.9995 7.96133 24.7886 7.58637 24.4136C7.21141 24.0387 7.00053 23.5303 7 23L7 8C7.00053 7.46973 7.21141 6.96133 7.58637 6.58637C7.96133 6.21141 8.46973 6.00053 9 6Z" />
					<path d="M19 6L23 6C23.5303 6.00053 24.0387 6.21141 24.4136 6.58637C24.7886 6.96133 24.9995 7.46973 25 8L25 23C24.9995 23.5303 24.7886 24.0387 24.4136 24.4136C24.0387 24.7886 23.5303 24.9995 23 25H19C18.4697 24.9995 17.9613 24.7886 17.5864 24.4136C17.2114 24.0387 17.0005 23.5303 17 23L17 8C17.0005 7.46973 17.2114 6.96133 17.5864 6.58637C17.9613 6.21141 18.4697 6.00053 19 6Z" />
				</svg>
			);
			break;
		case 'flex-row-strech':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path d="M19 6L26.9988 6C27.5291 6.00053 28.0375 6.21141 28.4125 6.58637C28.7874 6.96133 28.9983 7.46973 28.9988 8L28.9988 23C28.9983 23.5303 28.7874 24.0387 28.4125 24.4136C28.0375 24.7886 27.5291 24.9995 26.9988 25L19 25C18.4698 24.9995 17.9614 24.7886 17.5864 24.4136C17.2114 24.0387 17.0006 23.5303 17 23L17 8C17.0006 7.46973 17.2114 6.96133 17.5864 6.58637C17.9614 6.21141 18.4698 6.00053 19 6Z" />
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
					<path d="M5.00021 6L12.999 6C13.5293 6.00053 14.0377 6.21141 14.4127 6.58637C14.7876 6.96133 14.9985 7.46973 14.999 8L14.999 23C14.9985 23.5303 14.7876 24.0387 14.4127 24.4136C14.0377 24.7886 13.5293 24.9995 12.999 25L5.00021 25C4.46993 24.9995 3.96153 24.7886 3.58658 24.4136C3.21162 24.0387 3.00073 23.5303 3.00021 23L3.00021 8C3.00074 7.46973 3.21162 6.96133 3.58658 6.58637C3.96153 6.21141 4.46994 6.00053 5.00021 6Z" />
				</svg>
			);
			break;
		case 'flex-row-space-between':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
					<path d="M5 6L9 6C9.53027 6.00053 10.0387 6.21141 10.4136 6.58637C10.7886 6.96133 10.9995 7.46973 11 8L11 23C10.9995 23.5303 10.7886 24.0387 10.4136 24.4136C10.0387 24.7886 9.53027 24.9995 9 25L5 25C4.46973 24.9995 3.96133 24.7886 3.58637 24.4136C3.21141 24.0387 3.00053 23.5303 3 23L3 8C3.00053 7.46973 3.21141 6.96133 3.58637 6.58637C3.96133 6.21141 4.46973 6.00053 5 6Z" />
					<path d="M23 6L27 6C27.5303 6.00053 28.0387 6.21141 28.4136 6.58637C28.7886 6.96133 28.9995 7.46973 29 8L29 23C28.9995 23.5303 28.7886 24.0387 28.4136 24.4136C28.0387 24.7886 27.5303 24.9995 27 25L23 25C22.4697 24.9995 21.9613 24.7886 21.5864 24.4136C21.2114 24.0387 21.0005 23.5303 21 23L21 8C21.0005 7.46973 21.2114 6.96133 21.5864 6.58637C21.9613 6.21141 22.4697 6.00053 23 6Z" />
				</svg>
			);
			break;
		case 'flex-row-space-around':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 0C1.55228 0 2 0.447715 2 1V30.5C2 31.0523 1.55228 31.5 1 31.5C0.447715 31.5 0 31.0523 0 30.5V1C0 0.447715 0.447715 0 1 0Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 0C31.5523 0 32 0.447715 32 1V30.5C32 31.0523 31.5523 31.5 31 31.5C30.4477 31.5 30 31.0523 30 30.5V1C30 0.447715 30.4477 0 31 0Z"
					/>
					<path d="M7 6L11 6C11.5303 6.00053 12.0387 6.21141 12.4136 6.58637C12.7886 6.96133 12.9995 7.46973 13 8L13 23C12.9995 23.5303 12.7886 24.0387 12.4136 24.4136C12.0387 24.7886 11.5303 24.9995 11 25L7 25C6.46973 24.9995 5.96133 24.7886 5.58637 24.4136C5.21141 24.0387 5.00053 23.5303 5 23L5 8C5.00053 7.46973 5.21141 6.96133 5.58637 6.58637C5.96133 6.21141 6.46973 6.00053 7 6Z" />
					<path d="M21 6L25 6C25.5303 6.00053 26.0387 6.21141 26.4136 6.58637C26.7886 6.96133 26.9995 7.46973 27 8L27 23C26.9995 23.5303 26.7886 24.0387 26.4136 24.4136C26.0387 24.7886 25.5303 24.9995 25 25L21 25C20.4697 24.9995 19.9613 24.7886 19.5864 24.4136C19.2114 24.0387 19.0005 23.5303 19 23L19 8C19.0005 7.46973 19.2114 6.96133 19.5864 6.58637C19.9613 6.21141 20.4697 6.00053 21 6Z" />
				</svg>
			);
			break;
		case 'flex-row-space-evenly':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31 31.5C30.4477 31.5 30 31.0523 30 30.5L30 1C30 0.447716 30.4477 -1.35705e-07 31 -8.74228e-08C31.5523 -3.91405e-08 32 0.447716 32 1L32 30.5C32 31.0523 31.5523 31.5 31 31.5Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1 31.5C0.447715 31.5 3.91405e-08 31.0523 8.74228e-08 30.5L2.66639e-06 1C2.71468e-06 0.447716 0.447718 -1.35705e-07 1 -8.74228e-08C1.55229 -3.91405e-08 2 0.447716 2 1L2 30.5C2 31.0523 1.55228 31.5 1 31.5Z"
					/>
					<path d="M12 25.5L8 25.5C7.46973 25.4995 6.96133 25.2886 6.58637 24.9136C6.21141 24.5387 6.00053 24.0303 6 23.5L6 8.5C6.00053 7.96973 6.21141 7.46133 6.58637 7.08637C6.96133 6.71141 7.46973 6.50053 8 6.5L12 6.5C12.5303 6.50053 13.0387 6.71141 13.4136 7.08637C13.7886 7.46133 13.9995 7.96973 14 8.5L14 23.5C13.9995 24.0303 13.7886 24.5387 13.4136 24.9136C13.0387 25.2886 12.5303 25.4995 12 25.5Z" />
					<path d="M24 25.5L20 25.5C19.4697 25.4995 18.9613 25.2886 18.5864 24.9136C18.2114 24.5387 18.0005 24.0303 18 23.5L18 8.5C18.0005 7.96973 18.2114 7.46133 18.5864 7.08637C18.9613 6.71141 19.4697 6.50053 20 6.5L24 6.5C24.5303 6.50053 25.0387 6.71141 25.4136 7.08637C25.7886 7.46133 25.9995 7.96973 26 8.5L26 23.5C25.9995 24.0303 25.7886 24.5387 25.4136 24.9136C25.0387 25.2886 24.5303 25.4995 24 25.5Z" />
				</svg>
			);
			break;
		// Flex Column
		case 'flex-column-start':
			customSVG = (
				<svg width="32" height="33" viewBox="0 0 32 33" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 1.75C31.5 2.30228 31.0523 2.75 30.5 2.75L1 2.75C0.447716 2.75 -6.78525e-08 2.30228 -4.37114e-08 1.75C-1.95703e-08 1.19771 0.447716 0.749999 1 0.749999L30.5 0.75C31.0523 0.75 31.5 1.19772 31.5 1.75Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 31.75C31.5 32.3023 31.0523 32.75 30.5 32.75L1 32.75C0.447716 32.75 -6.78525e-08 32.3023 -4.37114e-08 31.75C-1.95703e-08 31.1977 0.447716 30.75 1 30.75L30.5 30.75C31.0523 30.75 31.5 31.1977 31.5 31.75Z"
					/>
					<path d="M25.5 5.75L25.5 9.75C25.4995 10.2803 25.2886 10.7887 24.9136 11.1636C24.5387 11.5386 24.0303 11.7495 23.5 11.75L8.5 11.75C7.96973 11.7495 7.46133 11.5386 7.08637 11.1636C6.71141 10.7887 6.50053 10.2803 6.5 9.75L6.5 5.75C6.50053 5.21973 6.71141 4.71133 7.08637 4.33637C7.46133 3.96141 7.96973 3.75053 8.5 3.75L23.5 3.75C24.0303 3.75053 24.5387 3.96141 24.9136 4.33637C25.2886 4.71133 25.4995 5.21973 25.5 5.75Z" />
					<path d="M25.5 14.75L25.5 18.75C25.4995 19.2803 25.2886 19.7887 24.9136 20.1636C24.5387 20.5386 24.0303 20.7495 23.5 20.75L8.5 20.75C7.96973 20.7495 7.46133 20.5386 7.08637 20.1636C6.71141 19.7887 6.50053 19.2803 6.5 18.75L6.5 14.75C6.50053 14.2197 6.71141 13.7113 7.08637 13.3364C7.46133 12.9614 7.96973 12.7505 8.5 12.75L23.5 12.75C24.0303 12.7505 24.5387 12.9614 24.9136 13.3364C25.2886 13.7113 25.4995 14.2197 25.5 14.75Z" />
				</svg>
			);
			break;
		case 'flex-column-end':
			customSVG = (
				<svg width="32" height="33" viewBox="0 0 32 33" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M30.5 2.75C31.0523 2.75 31.5 2.30228 31.5 1.75C31.5 1.19772 31.0523 0.75 30.5 0.75H1C0.447716 0.75 0 1.19771 0 1.75C0 2.30228 0.447716 2.75 1 2.75L30.5 2.75ZM30.5 32.75C31.0523 32.75 31.5 32.3023 31.5 31.75C31.5 31.1977 31.0523 30.75 30.5 30.75L1 30.75C0.447716 30.75 0 31.1977 0 31.75C0 32.3023 0.447716 32.75 1 32.75L30.5 32.75ZM25.5 14.75V18.75C25.4995 19.2803 25.2886 19.7887 24.9136 20.1636C24.5387 20.5386 24.0303 20.7495 23.5 20.75L8.5 20.75C7.96973 20.7495 7.46133 20.5386 7.08637 20.1636C6.71141 19.7887 6.50053 19.2803 6.5 18.75L6.5 14.75C6.50053 14.2197 6.71141 13.7113 7.08637 13.3364C7.46133 12.9614 7.96973 12.7505 8.5 12.75L23.5 12.75C24.0303 12.7505 24.5387 12.9614 24.9136 13.3364C25.2886 13.7113 25.4995 14.2197 25.5 14.75ZM25.5 27.75V23.75C25.4995 23.2197 25.2886 22.7113 24.9136 22.3364C24.5387 21.9614 24.0303 21.7505 23.5 21.75L8.5 21.75C7.96973 21.7505 7.46133 21.9614 7.08637 22.3364C6.71141 22.7113 6.50053 23.2197 6.5 23.75L6.5 27.75C6.50053 28.2803 6.71141 28.7887 7.08637 29.1636C7.46133 29.5386 7.96973 29.7495 8.5 29.75L23.5 29.75C24.0303 29.7495 24.5387 29.5386 24.9136 29.1636C25.2886 28.7887 25.4995 28.2803 25.5 27.75Z"
					/>
				</svg>
			);
			break;
		case 'flex-column-center':
			customSVG = (
				<svg width="32" height="33" viewBox="0 0 32 33" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 1.75C31.5 2.30228 31.0523 2.75 30.5 2.75L1 2.75C0.447716 2.75 -6.78525e-08 2.30228 -4.37114e-08 1.75C-1.95703e-08 1.19771 0.447716 0.749999 1 0.749999L30.5 0.75C31.0523 0.75 31.5 1.19772 31.5 1.75Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 31.75C31.5 32.3023 31.0523 32.75 30.5 32.75L1 32.75C0.447716 32.75 -6.78525e-08 32.3023 -4.37114e-08 31.75C-1.95703e-08 31.1977 0.447716 30.75 1 30.75L30.5 30.75C31.0523 30.75 31.5 31.1977 31.5 31.75Z"
					/>
					<path d="M25.5 9.75L25.5 13.75C25.4995 14.2803 25.2886 14.7887 24.9136 15.1636C24.5387 15.5386 24.0303 15.7495 23.5 15.75L8.5 15.75C7.96973 15.7495 7.46133 15.5386 7.08637 15.1636C6.71141 14.7887 6.50053 14.2803 6.5 13.75L6.5 9.75C6.50053 9.21973 6.71141 8.71133 7.08637 8.33637C7.46133 7.96141 7.96973 7.75053 8.5 7.75L23.5 7.75C24.0303 7.75053 24.5387 7.96141 24.9136 8.33637C25.2886 8.71133 25.4995 9.21973 25.5 9.75Z" />
					<path d="M25.5 19.75L25.5 23.75C25.4995 24.2803 25.2886 24.7887 24.9136 25.1636C24.5387 25.5386 24.0303 25.7495 23.5 25.75L8.5 25.75C7.96973 25.7495 7.46133 25.5386 7.08637 25.1636C6.71141 24.7887 6.50053 24.2803 6.5 23.75L6.5 19.75C6.50053 19.2197 6.71141 18.7113 7.08637 18.3364C7.46133 17.9614 7.96973 17.7505 8.5 17.75L23.5 17.75C24.0303 17.7505 24.5387 17.9614 24.9136 18.3364C25.2886 18.7113 25.4995 19.2197 25.5 19.75Z" />
				</svg>
			);
			break;
		case 'flex-column-strech':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M30.5 2C31.0523 2 31.5 1.55228 31.5 1C31.5 0.447715 31.0523 0 30.5 0H1C0.447716 0 0 0.447714 0 0.999999C0 1.55228 0.447716 2 1 2L30.5 2ZM30.5 32C31.0523 32 31.5 31.5523 31.5 31C31.5 30.4477 31.0523 30 30.5 30L1 30C0.447716 30 0 30.4477 0 31C0 31.5523 0.447716 32 1 32L30.5 32ZM25.5 5.00018V12.999C25.4995 13.5293 25.2886 14.0377 24.9136 14.4126C24.5387 14.7876 24.0303 14.9985 23.5 14.999L8.5 14.999C7.96973 14.9985 7.46133 14.7876 7.08637 14.4126C6.71141 14.0377 6.50053 13.5293 6.5 12.999L6.5 5.00017C6.50053 4.4699 6.71141 3.9615 7.08637 3.58654C7.46133 3.21159 7.96973 3.0007 8.5 3.00017L23.5 3.00018C24.0303 3.0007 24.5387 3.21159 24.9136 3.58655C25.2886 3.9615 25.4995 4.4699 25.5 5.00018ZM25.5 18.9999V26.9987C25.4995 27.529 25.2886 28.0374 24.9136 28.4124C24.5387 28.7873 24.0303 28.9982 23.5 28.9987L8.5 28.9987C7.96973 28.9982 7.46133 28.7873 7.08637 28.4124C6.71141 28.0374 6.50053 27.529 6.5 26.9987L6.5 18.9999C6.50053 18.4697 6.71141 17.9613 7.08637 17.5863C7.46133 17.2113 7.96973 17.0005 8.5 16.9999L23.5 16.9999C24.0303 17.0005 24.5387 17.2113 24.9136 17.5863C25.2886 17.9613 25.4995 18.4697 25.5 18.9999Z"
					/>
				</svg>
			);
			break;
		case 'flex-column-space-between':
			customSVG = (
				<svg width="32" height="33" viewBox="0 0 32 33" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 1.75C31.5 2.30228 31.0523 2.75 30.5 2.75L1 2.75C0.447716 2.75 -6.78525e-08 2.30228 -4.37114e-08 1.75C-1.95703e-08 1.19771 0.447716 0.749999 1 0.749999L30.5 0.75C31.0523 0.75 31.5 1.19772 31.5 1.75Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 31.75C31.5 32.3023 31.0523 32.75 30.5 32.75L1 32.75C0.447716 32.75 -6.78525e-08 32.3023 -4.37114e-08 31.75C-1.95703e-08 31.1977 0.447716 30.75 1 30.75L30.5 30.75C31.0523 30.75 31.5 31.1977 31.5 31.75Z"
					/>
					<path d="M25.5 5.75L25.5 9.75C25.4995 10.2803 25.2886 10.7887 24.9136 11.1636C24.5387 11.5386 24.0303 11.7495 23.5 11.75L8.5 11.75C7.96973 11.7495 7.46133 11.5386 7.08637 11.1636C6.71141 10.7887 6.50053 10.2803 6.5 9.75L6.5 5.75C6.50053 5.21973 6.71141 4.71133 7.08637 4.33637C7.46133 3.96141 7.96973 3.75053 8.5 3.75L23.5 3.75C24.0303 3.75053 24.5387 3.96141 24.9136 4.33637C25.2886 4.71133 25.4995 5.21973 25.5 5.75Z" />
					<path d="M25.5 23.75L25.5 27.75C25.4995 28.2803 25.2886 28.7887 24.9136 29.1636C24.5387 29.5386 24.0303 29.7495 23.5 29.75L8.5 29.75C7.96973 29.7495 7.46133 29.5386 7.08637 29.1636C6.71141 28.7887 6.50053 28.2803 6.5 27.75L6.5 23.75C6.50053 23.2197 6.71141 22.7113 7.08637 22.3364C7.46133 21.9614 7.96973 21.7505 8.5 21.75L23.5 21.75C24.0303 21.7505 24.5387 21.9614 24.9136 22.3364C25.2886 22.7113 25.4995 23.2197 25.5 23.75Z" />
				</svg>
			);
			break;
		case 'flex-column-space-around':
			customSVG = (
				<svg width="32" height="33" viewBox="0 0 32 33" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 1.75C31.5 2.30228 31.0523 2.75 30.5 2.75L1 2.75C0.447716 2.75 -6.78525e-08 2.30228 -4.37114e-08 1.75C-1.95703e-08 1.19771 0.447716 0.749999 1 0.749999L30.5 0.75C31.0523 0.75 31.5 1.19772 31.5 1.75Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M31.5 31.75C31.5 32.3023 31.0523 32.75 30.5 32.75L1 32.75C0.447716 32.75 -6.78525e-08 32.3023 -4.37114e-08 31.75C-1.95703e-08 31.1977 0.447716 30.75 1 30.75L30.5 30.75C31.0523 30.75 31.5 31.1977 31.5 31.75Z"
					/>
					<path d="M25.5 7.75L25.5 11.75C25.4995 12.2803 25.2886 12.7887 24.9136 13.1636C24.5387 13.5386 24.0303 13.7495 23.5 13.75L8.5 13.75C7.96973 13.7495 7.46133 13.5386 7.08637 13.1636C6.71141 12.7887 6.50053 12.2803 6.5 11.75L6.5 7.75C6.50053 7.21973 6.71141 6.71133 7.08637 6.33637C7.46133 5.96141 7.96973 5.75053 8.5 5.75L23.5 5.75C24.0303 5.75053 24.5387 5.96141 24.9136 6.33637C25.2886 6.71133 25.4995 7.21973 25.5 7.75Z" />
					<path d="M25.5 21.75L25.5 25.75C25.4995 26.2803 25.2886 26.7887 24.9136 27.1636C24.5387 27.5386 24.0303 27.7495 23.5 27.75L8.5 27.75C7.96973 27.7495 7.46133 27.5386 7.08637 27.1636C6.71141 26.7887 6.50053 26.2803 6.5 25.75L6.5 21.75C6.50053 21.2197 6.71141 20.7113 7.08637 20.3364C7.46133 19.9614 7.96973 19.7505 8.5 19.75L23.5 19.75C24.0303 19.7505 24.5387 19.9614 24.9136 20.3364C25.2886 20.7113 25.4995 21.2197 25.5 21.75Z" />
				</svg>
			);
			break;
		case 'flex-column-space-evenly':
			customSVG = (
				<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1.31134e-07 31C2.03558e-07 30.4477 0.447715 30 1 30L30.5 30C31.0523 30 31.5 30.4477 31.5 31C31.5 31.5523 31.0523 32 30.5 32L1 32C0.447715 32 5.87108e-08 31.5523 1.31134e-07 31Z"
					/>
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M1.31134e-07 0.999996C2.03558e-07 0.447711 0.447715 -3.75599e-06 1 -3.68356e-06L30.5 1.84895e-07C31.0523 2.57318e-07 31.5 0.447716 31.5 1C31.5 1.55229 31.0523 2 30.5 2L1 2C0.447715 2 5.87108e-08 1.55228 1.31134e-07 0.999996Z"
					/>
					<path d="M6 24L6 20C6.00053 19.4697 6.21141 18.9613 6.58637 18.5864C6.96133 18.2114 7.46973 18.0005 8 18L23 18C23.5303 18.0005 24.0387 18.2114 24.4136 18.5864C24.7886 18.9613 24.9995 19.4697 25 20L25 24C24.9995 24.5303 24.7886 25.0387 24.4136 25.4136C24.0387 25.7886 23.5303 25.9995 23 26L8 26C7.46973 25.9995 6.96133 25.7886 6.58637 25.4136C6.21141 25.0387 6.00053 24.5303 6 24Z" />
					<path d="M6 12L6 8C6.00053 7.46973 6.21141 6.96132 6.58637 6.58637C6.96133 6.21141 7.46973 6.00053 8 6L23 6C23.5303 6.00053 24.0387 6.21141 24.4136 6.58637C24.7886 6.96133 24.9995 7.46973 25 8L25 12C24.9995 12.5303 24.7886 13.0387 24.4136 13.4136C24.0387 13.7886 23.5303 13.9995 23 14L8 14C7.46973 13.9995 6.96133 13.7886 6.58637 13.4136C6.21141 13.0387 6.00053 12.5303 6 12Z" />
				</svg>
			);
			break;
		// Flex Direction
		case 'flex-direction-row':
			customSVG = (
				<svg viewBox="0 0 23 22" xmlns="http://www.w3.org/2000/svg">
					<path d="M19.0834 11L19.7905 10.2929L20.4976 11L19.7905 11.7071L19.0834 11ZM5.33337 12C4.78109 12 4.33337 11.5523 4.33337 11C4.33337 10.4477 4.78109 10 5.33337 10V12ZM14.2905 4.79289L19.7905 10.2929L18.3763 11.7071L12.8763 6.20711L14.2905 4.79289ZM19.7905 11.7071L14.2905 17.2071L12.8763 15.7929L18.3763 10.2929L19.7905 11.7071ZM19.0834 12H5.33337V10H19.0834V12Z"/>
				</svg>
			);
			break;
		case 'flex-direction-column':
			customSVG = (
				<svg viewBox="0 0 23 22" xmlns="http://www.w3.org/2000/svg">
					<path d="M11.25 18.3334L10.5429 19.0405L11.25 19.7476L11.9571 19.0405L11.25 18.3334ZM12.25 4.58337C12.25 4.03109 11.8023 3.58337 11.25 3.58337C10.6977 3.58337 10.25 4.03109 10.25 4.58337L12.25 4.58337ZM5.04289 13.5405L10.5429 19.0405L11.9571 17.6263L6.45711 12.1263L5.04289 13.5405ZM11.9571 19.0405L17.4571 13.5405L16.0429 12.1263L10.5429 17.6263L11.9571 19.0405ZM12.25 18.3334L12.25 4.58337L10.25 4.58337L10.25 18.3334L12.25 18.3334Z"/>
				</svg>
			);
			break;
		case 'flex-direction-row-reverse':
			customSVG = (
				<svg viewBox="0 0 23 22" xmlns="http://www.w3.org/2000/svg">
					<path d="M4.41663 11L3.70952 10.2929L3.00241 11L3.70952 11.7071L4.41663 11ZM18.1666 12C18.7189 12 19.1666 11.5523 19.1666 11C19.1666 10.4477 18.7189 10 18.1666 10V12ZM9.20952 4.79289L3.70952 10.2929L5.12373 11.7071L10.6237 6.20711L9.20952 4.79289ZM3.70952 11.7071L9.20952 17.2071L10.6237 15.7929L5.12373 10.2929L3.70952 11.7071ZM4.41663 12H18.1666V10H4.41663V12Z"/>
				</svg>
			);
			break;
		case 'flex-direction-column-reverse':
			customSVG = (
				<svg viewBox="0 0 23 22" xmlns="http://www.w3.org/2000/svg">
					<path d="M11.25 3.66663L10.5429 2.95952L11.25 2.25241L11.9571 2.95952L11.25 3.66663ZM12.25 17.4166C12.25 17.9689 11.8023 18.4166 11.25 18.4166C10.6977 18.4166 10.25 17.9689 10.25 17.4166L12.25 17.4166ZM5.04289 8.45952L10.5429 2.95952L11.9571 4.37373L6.45711 9.87373L5.04289 8.45952ZM11.9571 2.95952L17.4571 8.45952L16.0429 9.87373L10.5429 4.37373L11.9571 2.95952ZM12.25 3.66663L12.25 17.4166L10.25 17.4166L10.25 3.66663L12.25 3.66663Z"/>
				</svg>
			);
			break;
		// Flex Wrap
		case 'flex-wrap':
			customSVG = (
				<svg viewBox="0 0 33 32" xmlns="http://www.w3.org/2000/svg">
					<path d="M1.33984 0C1.89213 0 2.33984 0.447715 2.33984 1V30.5C2.33984 31.0523 1.89213 31.5 1.33984 31.5C0.787559 31.5 0.339844 31.0523 0.339844 30.5V1C0.339844 0.447715 0.787559 0 1.33984 0Z" />
					<path d="M31.3398 0C31.8921 0 32.3398 0.447715 32.3398 1V30.5C32.3398 31.0523 31.8921 31.5 31.3398 31.5C30.7876 31.5 30.3398 31.0523 30.3398 30.5V1C30.3398 0.447715 30.7876 0 31.3398 0Z" />
					<path d="M27.3398 5C27.8921 5 28.3398 5.44772 28.3398 6V22C28.3398 22.0022 28.3398 22.0043 28.3398 22.0065C28.3363 22.5558 27.89 23 27.3398 23L10.8398 23L12.7185 24.8786C13.1091 25.2692 13.1091 25.9023 12.7185 26.2929C12.328 26.6834 11.6949 26.6834 11.3043 26.2929L7.71852 22.7071C7.328 22.3166 7.328 21.6834 7.71852 21.2929L11.3043 17.7071C11.6949 17.3166 12.328 17.3166 12.7185 17.7071C13.1091 18.0977 13.1091 18.7308 12.7185 19.1213L10.8398 21L26.3398 21V7L5.33984 7C4.78756 7 4.33984 6.55228 4.33984 6C4.33984 5.44771 4.78756 5 5.33984 5H27.3398Z" />
				</svg>
			);
			break;
		case 'flex-no-wrap':
			customSVG = (
				<svg viewBox="0 0 33 32" xmlns="http://www.w3.org/2000/svg">
					<path d="M1.33984 0C1.89213 0 2.33984 0.447715 2.33984 1V30.5C2.33984 31.0523 1.89213 31.5 1.33984 31.5C0.787559 31.5 0.339844 31.0523 0.339844 30.5V1C0.339844 0.447715 0.787559 0 1.33984 0Z" />
					<path d="M31.3398 0C31.8921 0 32.3398 0.447715 32.3398 1V30.5C32.3398 31.0523 31.8921 31.5 31.3398 31.5C30.7876 31.5 30.3398 31.0523 30.3398 30.5V1C30.3398 0.447715 30.7876 0 31.3398 0Z" />
					<path d="M24.3754 11.2929L27.9612 14.8786C28.3517 15.2692 28.3517 15.9023 27.9612 16.2929L24.3754 19.8786C23.9848 20.2691 23.3517 20.2691 22.9611 19.8786C22.5706 19.4881 22.5706 18.8549 22.9611 18.4644L24.8398 16.5857L5.33984 16.5857C4.78756 16.5857 4.33984 16.138 4.33984 15.5857C4.33984 15.0334 4.78756 14.5857 5.33984 14.5857L24.8398 14.5857L22.9611 12.7071C22.5706 12.3166 22.5706 11.6834 22.9611 11.2929C23.3517 10.9024 23.9848 10.9024 24.3754 11.2929Z" />
				</svg>
			);
			break;
		case 'flex-wrap-reverse':
			customSVG = (
				<svg viewBox="0 0 33 32" xmlns="http://www.w3.org/2000/svg">
					<path d="M1.33984 32C1.89213 32 2.33984 31.5452 2.33984 30.9841V1.01587C2.33984 0.454821 1.89213 0 1.33984 0C0.787559 0 0.339844 0.454821 0.339844 1.01587V30.9841C0.339844 31.5452 0.787559 32 1.33984 32Z" />
					<path d="M31.3398 32C31.8921 32 32.3398 31.5452 32.3398 30.9841V1.01587C32.3398 0.454821 31.8921 0 31.3398 0C30.7876 0 30.3398 0.454821 30.3398 1.01587V30.9841C30.3398 31.5452 30.7876 32 31.3398 32Z" />
					<path d="M27.3398 26.5C27.8921 26.5 28.3398 26.0523 28.3398 25.5V9.5C28.3398 9.49784 28.3398 9.49569 28.3398 9.49353C28.3363 8.94422 27.89 8.5 27.3398 8.5L10.8398 8.5L12.7185 6.62136C13.1091 6.23084 13.1091 5.59767 12.7185 5.20715C12.328 4.81663 11.6949 4.81663 11.3043 5.20715L7.71852 8.79289C7.328 9.18342 7.328 9.81658 7.71852 10.2071L11.3043 13.7929C11.6949 14.1834 12.328 14.1834 12.7185 13.7929C13.1091 13.4023 13.1091 12.7692 12.7185 12.3787L10.8398 10.5L26.3398 10.5V24.5H5.33984C4.78756 24.5 4.33984 24.9477 4.33984 25.5C4.33984 26.0523 4.78756 26.5 5.33984 26.5H27.3398Z" />
				</svg>
			);
			break;
		case 'start-order':
			customSVG = (
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M3 3V21M21 12H7M7 12L14 19M7 12L14 5" stroke="#1E1E1E" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
			);
			break;
		case 'end-order':
			customSVG = (
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M21 21V3M3 12H17M17 12L10 5M17 12L10 19" stroke="#1E1E1E" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
			);
			break;
		case 'custom-order':
			customSVG = (
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M12 5L12 5.01M12 12L12 12.01M12 19L12 19.01M12 6C11.4477 6 11 5.55228 11 5C11 4.44772 11.4477 4 12 4C12.5523 4 13 4.44772 13 5C13 5.55228 12.5523 6 12 6ZM12 13C11.4477 13 11 12.5523 11 12C11 11.4477 11.4477 11 12 11C12.5523 11 13 11.4477 13 12C13 12.5523 12.5523 13 12 13ZM12 20C11.4477 20 11 19.5523 11 19C11 18.4477 11.4477 18 12 18C12.5523 18 13 18.4477 13 19C13 19.5523 12.5523 20 12 20Z" stroke="#111827" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
			);
			break;
	}

	return customSVG;
}

export default renderCustomIcon;
