const filledPreset = {
    background: '#007cba',
    color: '#ffffff',
	hColor: '#ffffff',
    borderStyle: 'none',
    borderWidth: 0,
}

const outlinedPreset = {
    background: '#ffffff',
    color: '#007cba',
	hColor: '#007cba',
    borderColor: '#007cba',
	borderHColor: '#007cba',
    borderStyle: 'solid',
    borderWidth: 1,
}

const preset1BorderRadius = {
    blockLeftRadius: 0,
    blockLeftRadiusMobile: 0,
    blockLeftRadiusTablet: 0,
    blockRightRadius: 0,
    blockRightRadiusMobile: 0,
    blockRightRadiusTablet: 0,
    blockTopRadius: 0,
    blockTopRadiusMobile: 0,
    blockTopRadiusTablet: 0,
    blockBottomRadius: 0,
    blockBottomRadiusMobile: 0,
    blockBottomRadiusTablet: 0,
}

const preset2BorderRadius = {
    blockLeftRadius: 10,
    blockLeftRadiusMobile: 10,
    blockLeftRadiusTablet: 10,
    blockRightRadius: 10,
    blockRightRadiusMobile: 10,
    blockRightRadiusTablet: 10,
    blockTopRadius: 10,
    blockTopRadiusMobile: 10,
    blockTopRadiusTablet: 10,
    blockBottomRadius: 10,
    blockBottomRadiusMobile: 10,
    blockBottomRadiusTablet: 10,
}

const preset3BorderRadius = {
    blockLeftRadius: 50,
    blockLeftRadiusMobile: 50,
    blockLeftRadiusTablet: 50,
    blockRightRadius: 50,
    blockRightRadiusMobile: 50,
    blockRightRadiusTablet: 50,
    blockTopRadius: 50,
    blockTopRadiusMobile: 50,
    blockTopRadiusTablet: 50,
    blockBottomRadius: 50,
    blockBottomRadiusMobile: 50,
    blockBottomRadiusTablet: 50,
}

const resetPreset = {
    background: '#007cba',
    color: '#ffffff',
    hColor: '#ffffff',
    borderColor: '',
	borderHColor: '',
    borderStyle: 'none',
    borderWidth: 0,
    blockLeftRadius: 0,
    blockLeftRadiusMobile: 0,
    blockLeftRadiusTablet: 0,
    blockRightRadius: 0,
    blockRightRadiusMobile: 0,
    blockRightRadiusTablet: 0,
    blockTopRadius: 0,
    blockTopRadiusMobile: 0,
    blockTopRadiusTablet: 0,
    blockBottomRadius: 0,
    blockBottomRadiusMobile: 0,
    blockBottomRadiusTablet: 0,
    icon: '',
    icon_color: '',
}

const presets = [
    {
        id: 'button-preset1',
        label: 'Preset1',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#BFBFBF" d="M17 31h74v18H17z"></path> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset1BorderRadius,
            ...filledPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset2',
        label: 'Preset2',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="74" height="18" x="17" y="31" fill="#BFBFBF" rx="3"></rect> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...filledPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset3',
        label: 'Preset3',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="74" height="18" x="17" y="31" fill="#BFBFBF" rx="9"></rect> <path fill="#fff" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset3BorderRadius,
            ...filledPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset4',
        label: 'Preset4',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="74" height="18" x="17" y="31" fill="#BFBFBF" rx="3"></rect> <path fill="#fff" d="M38.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM38.883 43H37.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.093.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996M70.334 40l.353-.354.354.354-.354.354zm-6.25.5a.5.5 0 0 1 0-1v1m3.75-3 .353-.354 2.5 2.5-.353.354-.354.354-2.5-2.5zm2.5 2.5.353.354-2.5 2.5-.353-.354-.354-.354 2.5-2.5zm0 0v.5h-6.25v-1h6.25z" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...filledPreset,
            icon: 'arrow-right',
            icon_color: '#ffffff',
        },
    },
    {
        id: 'button-preset5',
        label: 'Preset5',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <path fill="#fff" stroke="#BFBFBF" d="M17.5 31.5h73v17h-73z"></path> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset1BorderRadius,
            ...outlinedPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset6',
        label: 'Preset6',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="73" height="17" x="17.5" y="31.5" fill="#fff" stroke="#BFBFBF" rx="2.5" ></rect> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...outlinedPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset7',
        label: 'Preset7',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="73" height="17" x="17.5" y="31.5" fill="#fff" stroke="#BFBFBF" rx="8.5" ></rect> <path fill="#666" d="M44.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM44.883 43H43.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.094.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996" ></path> </svg>',
        attributes: {
            ...preset3BorderRadius,
            ...outlinedPreset,
            icon: '',
            icon_color: '',
        },
    },
    {
        id: 'button-preset8',
        label: 'Preset8',
        icon: '<svg xmlns="http://www.w3.org/2000/svg" width="108" height="80" fill="none" viewBox="0 0 108 80" > <rect width="107" height="79" x="0.5" y="0.5" fill="#fff" stroke="#D9D9D9" rx="3.5" ></rect> <rect width="73" height="17" x="17.5" y="31.5" fill="#fff" stroke="#BFBFBF" rx="2.5" ></rect> <path fill="#666" d="M38.918 40.34h-1.441l-.008-.606h1.308q.324 0 .567-.109a.86.86 0 0 0 .375-.312.87.87 0 0 0 .136-.493.95.95 0 0 0-.12-.508.67.67 0 0 0-.364-.289 1.7 1.7 0 0 0-.617-.093h-1.11V43h-.753v-5.687h1.863q.438 0 .781.09.344.086.582.273.243.183.367.468.126.286.125.684 0 .352-.18.637-.18.281-.5.46-.316.18-.742.231zM38.883 43H37.18l.425-.613h1.278q.359 0 .61-.125a.9.9 0 0 0 .386-.352 1.07 1.07 0 0 0 .133-.543q0-.316-.114-.547a.8.8 0 0 0-.355-.355q-.242-.126-.625-.125h-1.074l.008-.606h1.468l.16.22a1.4 1.4 0 0 1 .696.233q.285.195.433.5.153.306.153.672 0 .532-.235.899a1.47 1.47 0 0 1-.652.554 2.4 2.4 0 0 1-.992.188m5.469-.977v-3.25h.726V43h-.691zm.136-.89.301-.008q0 .422-.09.781a1.7 1.7 0 0 1-.281.617q-.195.263-.512.41-.315.145-.77.145-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.488 2.4 2.4 0 0 1-.098-.723v-2.727h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.305.121-.676m3.461-2.36v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .171.145q.105.035.227.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.356-.352q-.129-.25-.129-.672zm4.128 1.027v.555h-2.285v-.555zm-1.511-1.027h.722v4.207q0 .214.067.324a.32.32 0 0 0 .172.145q.105.035.226.035.09 0 .188-.016l.152-.03.004.589a2 2 0 0 1-.227.05 1.7 1.7 0 0 1-.332.028q-.266 0-.488-.105a.8.8 0 0 1-.355-.352q-.13-.25-.13-.672zm2.09 3.188v-.09q0-.457.132-.848.133-.394.383-.684.25-.292.606-.453a1.9 1.9 0 0 1 .797-.164q.444 0 .8.164.36.16.61.453.254.29.386.684.133.39.133.848v.09q0 .457-.133.847a2 2 0 0 1-.386.684 1.8 1.8 0 0 1-.606.453q-.351.16-.797.16a1.9 1.9 0 0 1-.8-.16q-.355-.164-.61-.453a2.1 2.1 0 0 1-.383-.684 2.6 2.6 0 0 1-.133-.847m.722-.09v.09q0 .316.074.597.075.278.223.492.153.216.379.34.227.121.527.121.297 0 .52-.12a1.1 1.1 0 0 0 .375-.34q.148-.216.222-.493.08-.28.079-.597v-.09q0-.313-.078-.59a1.5 1.5 0 0 0-.227-.496 1.051 1.051 0 0 0-.898-.469q-.297 0-.524.125a1.1 1.1 0 0 0-.375.344 1.6 1.6 0 0 0-.223.496q-.075.277-.074.59m4.754-1.168V43h-.723v-4.227h.684zm-.172 1.05-.3-.011q.003-.434.128-.8.125-.372.352-.645a1.56 1.56 0 0 1 1.238-.575q.313 0 .563.086.25.083.425.266.18.183.274.476.093.29.094.707V43h-.727v-2.777q0-.333-.098-.532a.6.6 0 0 0-.285-.293 1 1 0 0 0-.46-.093q-.27 0-.493.113-.219.113-.379.313a1.57 1.57 0 0 0-.332.996M70.334 40l.353-.354.354.354-.354.354zm-6.25.5a.5.5 0 0 1 0-1v1m3.75-3 .353-.354 2.5 2.5-.353.354-.354.354-2.5-2.5zm2.5 2.5.353.354-2.5 2.5-.353-.354-.354-.354 2.5-2.5zm0 0v.5h-6.25v-1h6.25z" ></path> </svg>',
        attributes: {
            ...preset2BorderRadius,
            ...outlinedPreset,
            icon: 'arrow-right',
            icon_color: '#007cba',
        },
    },
];

export { presets, resetPreset };