/**
 * Block icons
 */

import { createElement as svgIcon } from '@wordpress/element';

const colorStop1 = "#2563EB";
const colorStop2 = "#130061";

const accordionIcon = <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <rect x="2.5" y="9" width="20" height="7" rx="2" stroke="url(#paint0_linear_2282_1404)" strokeWidth="1.5" /> <rect x="2.5" y="2" width="20" height="4" rx="1" stroke="url(#paint1_linear_2282_1404)" strokeWidth="1.5" /> <rect x="2.5" y="19" width="20" height="4" rx="1" stroke="url(#paint2_linear_2282_1404)" strokeWidth="1.5" /> <defs> <linearGradient id="paint0_linear_2282_1404" x1="12.5" y1="9" x2="12.5" y2="16" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2282_1404" x1="12.5" y1="2" x2="12.5" y2="6" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2282_1404" x1="12.5" y1="19" x2="12.5" y2="23" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> </defs> </svg>;

const advancedColumnsIcon = <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2262_1527)"> <rect x="18.75" y="3.125" width="4.16667" height="18.75" rx="1" stroke="url(#paint0_linear_2262_1527)" strokeWidth="1.5" strokeLinejoin="round" /> <rect x="10.4166" y="3.125" width="4.16667" height="10.4167" rx="1" stroke="url(#paint1_linear_2262_1527)" strokeWidth="1.5" strokeLinejoin="round" /> <rect x="2.08337" y="3.125" width="4.16667" height="15.625" rx="1" stroke="url(#paint2_linear_2262_1527)" strokeWidth="1.5" strokeLinejoin="round" /> </g> <defs> <linearGradient id="paint0_linear_2262_1527" x1="20.8333" y1="3.125" x2="20.8333" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint1_linear_2262_1527" x1="12.5" y1="3.125" x2="12.5" y2="13.5417" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint2_linear_2262_1527" x1="4.16671" y1="3.125" x2="4.16671" y2="18.75" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <clipPath id="clip0_2262_1527"> <rect width="25" height="25" fill="white" /></clipPath> </defs> </svg>;

const buttonIcon = <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2270_1392)"> <rect x="4.16663" y="5.20834" width="16.6667" height="5.20833" rx="1" stroke="url(#paint0_linear_2270_1392)" strokeWidth="1.5" strokeLinejoin="round" /> <rect x="4.16663" y="14.5833" width="16.6667" height="5.20833" rx="1" stroke="url(#paint1_linear_2270_1392)" strokeWidth="1.5" strokeLinejoin="round" /> <line x1="7" y1="7.79999" x2="18" y2="7.79999" stroke="url(#paint2_linear_2270_1392)" strokeLinecap="round" /> <line x1="7" y1="17.2" x2="18" y2="17.2" stroke="url(#paint3_linear_2270_1392)" strokeLinecap="round" /> </g> <defs> <linearGradient id="paint0_linear_2270_1392" x1="12.5" y1="5.20834" x2="12.5" y2="10.4167" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2270_1392" x1="12.5" y1="14.5833" x2="12.5" y2="19.7917" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2270_1392" x1="12.5" y1="8.29999" x2="12.5" y2="9.29999" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2270_1392" x1="12.5" y1="17.7" x2="12.5" y2="18.7" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2270_1392"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>;

const iconListIcon = <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2276_1846)"> <path stroke="url(#paint0_linear_2276_1846)" strokeLinecap="round" strokeWidth="1.5" d="M8.646 5.563h7.708" ></path> <path stroke="url(#paint1_linear_2276_1846)" strokeLinecap="round" strokeWidth="1.5" d="M8.646 10.188h4.625" ></path> <path stroke="url(#paint2_linear_2276_1846)" strokeLinecap="round" strokeWidth="1.5" d="M8.646 14.813h6.166" ></path> <path stroke="url(#paint3_linear_2276_1846)" strokeLinecap="round" strokeWidth="1.5" d="M8.646 19.438h4.625" ></path> <rect width="1.542" height="1.542" x="4.792" y="4.792" fill="url(#paint4_linear_2276_1846)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="4.792" y="9.417" fill="url(#paint5_linear_2276_1846)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="4.792" y="14.042" fill="url(#paint6_linear_2276_1846)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="4.792" y="18.667" fill="url(#paint7_linear_2276_1846)" rx="0.771" ></rect> </g> <defs> <linearGradient id="paint0_linear_2276_1846" x1="10.38" x2="-10647800" y1="-12868300" y2="2749170" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2276_1846" x1="10.962" x2="10.573" y1="-3145610" y2="3717560" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2276_1846" x1="13.685" x2="41.892" y1="-6195900" y2="5242710" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2276_1846" x1="10.177" x2="9.92" y1="-2001740" y2="2573710" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2276_1846" x1="5.562" x2="5.562" y1="4.792" y2="6.333" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2276_1846" x1="5.562" x2="5.562" y1="9.417" y2="10.958" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2276_1846" x1="5.562" x2="5.562" y1="14.042" y2="15.583" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint7_linear_2276_1846" x1="5.562" x2="5.562" y1="18.667" y2="20.208" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2276_1846"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>;

const formIcon = <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_2290_1482)"> <rect x="5.20837" y="4.16663" width="14.5833" height="17.7083" rx="2" stroke="url(#paint0_linear_2290_1482)" strokeWidth="1.5" /> <path d="M8.5 10L16.5 10" stroke="url(#paint1_linear_2290_1482)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M8.5 13L16.5 13" stroke="url(#paint2_linear_2290_1482)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M8.5 7H11.5" stroke="url(#paint3_linear_2290_1482)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M13.5 7H16.5" stroke="url(#paint4_linear_2290_1482)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M12.5 18H16.6667" stroke="url(#paint5_linear_2290_1482)" strokeWidth="1.5" strokeLinecap="round" /> </g> <defs> <linearGradient id="paint0_linear_2290_1482" x1="12.5" y1="4.16663" x2="12.5" y2="21.875" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2290_1482" x1="12.5" y1="10" x2="12.5" y2="11" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2290_1482" x1="12.5" y1="13" x2="12.5" y2="14" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2290_1482" x1="10" y1="7" x2="10" y2="8" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint4_linear_2290_1482" x1="15" y1="7" x2="15" y2="8" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint5_linear_2290_1482" x1="14.5833" y1="18" x2="14.5833" y2="19" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2290_1482"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>;

const ResponsiveBlockEditorAddonsIcons = {
    accordion: accordionIcon,

    accordion_item: accordionIcon,

    advance_columns: advancedColumnsIcon,

    column: advancedColumnsIcon,

    advanced_text: <svg className="rbea-editor-icons" width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg" ><rect x="0.75" y="0.75" width="21.5" height="21.5" rx="3.25" stroke="url(#paint0_linear_2297_1597)" strokeWidth="1.5" /> <path d="M6.2229 14.5636L7.9029 10.7101M7.9029 10.7101H13.9492M7.9029 10.7101L10.4754 4.80649C10.511 4.71612 10.573 4.63856 10.6533 4.5839C10.7336 4.52923 10.8285 4.5 10.9256 4.5C11.0227 4.5 11.1176 4.52923 11.1979 4.5839C11.2782 4.63856 11.3402 4.71612 11.3758 4.80649L13.9492 10.7101M13.9492 10.7101L15.0788 13.0709" stroke="url(#paint1_linear_2297_1597)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <path d="M4.5 17.571L4.997 17.7757C5.55525 18.0059 6.1905 17.9289 6.7085 17.6182C7.31225 17.2586 8.15138 16.8176 8.88113 16.6557C9.39125 16.542 9.96875 16.8299 9.83575 17.3347C9.687 17.8965 9.232 18.5562 9.66775 18.8616C10.324 19.321 14.0699 18.1459 14.0699 18.1459" stroke="url(#paint2_linear_2297_1597)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <path className="rbea-editor-icon-selected-fill" d="M15.1617 18.4819C15.4429 18.4183 15.7003 18.2762 15.9039 18.0721L19.2245 14.7537C19.3724 14.6121 19.4905 14.4424 19.5719 14.2546C19.6533 14.0668 19.6964 13.8646 19.6987 13.6598C19.7009 13.4551 19.6623 13.252 19.585 13.0624C19.5078 12.8729 19.3935 12.7006 19.2488 12.5558C19.1041 12.411 18.9319 12.2965 18.7424 12.2191C18.5529 12.1417 18.3498 12.1029 18.1451 12.1049C17.9404 12.107 17.7382 12.15 17.5503 12.2312C17.3624 12.3125 17.1926 12.4304 17.0509 12.5782L13.7309 15.8978C13.5269 16.1024 13.3844 16.3605 13.3205 16.6418L12.9942 18.0751C12.9711 18.1763 12.974 18.2817 13.0027 18.3814C13.0314 18.4811 13.085 18.5719 13.1583 18.6453C13.2317 18.7186 13.3225 18.7722 13.4222 18.8009C13.5219 18.8296 13.6273 18.8326 13.7284 18.8095L15.1617 18.4819Z" fill="url(#paint3_linear_2297_1597)" /> <defs> <linearGradient id="paint0_linear_2297_1597" x1="11.5" y1="0" x2="11.5" y2="23" gradientUnits="userSpaceOnUse" ><stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2297_1597" x1="10.6508" y1="4.5" x2="10.6508" y2="14.5636" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2297_1597" x1="9.28494" y1="16.631" x2="9.28494" y2="18.9681" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2297_1597" x1="16.3388" y1="12.1049" x2="16.3388" y2="18.8249" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> </defs> </svg>,

    advanced_heading: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <rect x="1.75" y="1.75" width="21.5" height="21.5" rx="3.25" stroke="url(#paint0_linear_2297_1586)" strokeWidth="1.5" /> <path className="rbea-editor-icon-selected-fill rbea-editor-icon-selected-no-stroke" d="M10.063 12.941C9.927 12.941 9.859 13.0033 9.859 13.128V18.16C9.859 18.3867 9.72867 18.5 9.468 18.5H7.666C7.54133 18.5 7.45633 18.4773 7.411 18.432C7.36567 18.3753 7.343 18.296 7.343 18.194V6.175C7.343 5.98233 7.428 5.886 7.598 5.886H9.621C9.77967 5.886 9.859 5.97667 9.859 6.158V10.731C9.859 10.9123 9.93833 11.003 10.097 11.003H14.585C14.7437 11.003 14.823 10.918 14.823 10.748V6.158C14.823 5.97667 14.9023 5.886 15.061 5.886H17.084C17.254 5.886 17.339 5.98233 17.339 6.175V18.194C17.339 18.296 17.3163 18.3753 17.271 18.432C17.2257 18.4773 17.1407 18.5 17.016 18.5H15.214C14.9533 18.5 14.823 18.3867 14.823 18.16V13.128C14.823 13.0033 14.755 12.941 14.619 12.941H10.063Z" fill="url(#paint1_linear_2297_1586)" /> <defs> <linearGradient id="paint0_linear_2297_1586" x1="12.5" y1="1" x2="12.5" y2="24" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2297_1586" x1="12.5" y1="4.5" x2="12.5" y2="20.5" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> </defs> </svg>,

    anchor: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_2284_1191)"> <path d="M12.5 9.375V21.875M12.5 9.375C11.6712 9.375 10.8763 9.04576 10.2903 8.45971C9.70424 7.87366 9.375 7.0788 9.375 6.25C9.375 5.4212 9.70424 4.62634 10.2903 4.04029C10.8763 3.45424 11.6712 3.125 12.5 3.125C13.3288 3.125 14.1237 3.45424 14.7097 4.04029C15.2958 4.62634 15.625 5.4212 15.625 6.25C15.625 7.0788 15.2958 7.87366 14.7097 8.45971C14.1237 9.04576 13.3288 9.375 12.5 9.375ZM12.5 21.875C10.2899 21.875 8.17025 20.997 6.60744 19.4342C5.04464 17.8714 4.16667 15.7518 4.16667 13.5417M12.5 21.875C14.7101 21.875 16.8298 20.997 18.3926 19.4342C19.9554 17.8714 20.8333 15.7518 20.8333 13.5417M21.875 13.5417H19.7917M5.20833 13.5417H3.125" stroke="url(#paint0_linear_2284_1191)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> </g> <defs> <linearGradient id="paint0_linear_2284_1191" x1="12.5" y1="3.125" x2="12.5" y2="21.875" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2284_1191"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    blockquote: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2270_1428)"> <path d="M14.3757 14.6671L14.3896 14.4851C14.3896 9.79292 17.2305 7.3208 20.8436 6M14.3757 14.6671C14.3756 14.0981 14.4871 13.5347 14.7037 13.009C14.9203 12.4832 15.2378 12.0055 15.6382 11.6031C16.4468 10.7904 17.5435 10.3338 18.6872 10.3336C19.2534 10.3335 19.8142 10.4455 20.3374 10.6631C20.8606 10.8808 21.336 11.1999 21.7365 11.6021C22.5453 12.4146 22.9998 13.5166 23 14.6657C23.0002 15.8149 22.546 16.917 21.7375 17.7297C20.9289 18.5424 19.8322 18.9991 18.6885 18.9993C17.5449 18.9995 16.448 18.5432 15.6392 17.7307C14.8304 16.9183 14.3759 15.8163 14.3757 14.6671ZM2 14.6671L2.01394 14.4851C2.01394 9.79292 4.85479 7.3208 8.46788 6M2 14.6671C2 13.518 2.45432 12.4159 3.263 11.6033C4.07169 10.7908 5.1685 10.3343 6.31215 10.3343C7.45581 10.3343 8.55262 10.7908 9.3613 11.6033C10.17 12.4159 10.6243 13.518 10.6243 14.6671C10.6243 15.8163 10.17 16.9184 9.3613 17.7309C8.55262 18.5435 7.45581 19 6.31215 19C5.1685 19 4.07169 18.5435 3.263 17.7309C2.45432 16.9184 2 15.8163 2 14.6671Z" stroke="url(#paint0_linear_2270_1428)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> </g> <defs> <linearGradient id="paint0_linear_2270_1428" x1="12.5" y1="19" x2="12.5" y2="6" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop2} /> <stop offset="1" stopColor={colorStop1} /></linearGradient> <clipPath id="clip0_2270_1428"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    buttons: buttonIcon,

    buttons_child: buttonIcon,

    call_mail_button: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2297_1681)"> <g clipPath="url(#clip1_2297_1681)"> <path d="M17.7709 13.25V7M17.7709 7H11.5209M17.7709 7L11 13.7708" stroke="url(#paint0_linear_2297_1681)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <path d="M16.7071 15.7071L19.3552 18.3552C19.7113 18.7113 19.7113 19.2887 19.3552 19.6448C17.43 21.57 14.3821 21.7866 12.204 20.153L10.6286 18.9714C8.88504 17.6638 7.33622 16.115 6.02857 14.3714L4.84701 12.796C3.21341 10.6179 3.43001 7.56999 5.35523 5.64477C5.71133 5.28867 6.28867 5.28867 6.64477 5.64477L9.29289 8.29289C9.68342 8.68342 9.68342 9.31658 9.29289 9.70711L8.27175 10.7283C8.10946 10.8905 8.06923 11.1385 8.17187 11.3437C9.35853 13.7171 11.2829 15.6415 13.6563 16.8281C13.8615 16.9308 14.1095 16.8905 14.2717 16.7283L15.2929 15.7071C15.6834 15.3166 16.3166 15.3166 16.7071 15.7071Z" stroke="url(#paint1_linear_2297_1681)" strokeWidth="1.5" strokeLinejoin="round" /> </g> </g> <defs> <linearGradient id="paint0_linear_2297_1681" x1="14.3855" y1="7" x2="14.3855" y2="13.7708" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2297_1681" x1="11" y1="5" x2="11" y2="23" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2297_1681"> <rect width="25" height="25" fill="white" /> </clipPath> <clipPath id="clip1_2297_1681"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    call_to_action: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" clipPath="url(#clip0_2270_1402)" > <path stroke="url(#paint0_linear_2270_1402)" d="M8.333 13.542V4.688a1.562 1.562 0 1 1 3.125 0V12.5m0-.52V9.895a1.563 1.563 0 1 1 3.125 0V12.5m0-1.562a1.563 1.563 0 1 1 3.125 0V12.5" ></path> <path stroke="url(#paint1_linear_2270_1402)" d="M17.708 11.98a1.563 1.563 0 0 1 3.125 0v4.687a6.25 6.25 0 0 1-6.25 6.25H12.5h.217a6.25 6.25 0 0 1-5.221-2.813l-.204-.312q-.488-.748-3.423-5.967a1.56 1.56 0 0 1 .558-2.106 1.95 1.95 0 0 1 2.375.291l1.531 1.532M5.208 3.125 4.167 2.083m0 5.209H3.125m11.458-4.167 1.042-1.042m0 4.167h1.042" ></path> </g> <defs> <linearGradient id="paint0_linear_2270_1402" x1="13.021" x2="13.021" y1="3.125" y2="13.542" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2270_1402" x1="11.979" x2="11.979" y1="2.083" y2="22.917" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2270_1402"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    card: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_2314_1266)"> <g clipPath="url(#clip1_2314_1266)"> <rect x="2" y="4" width="21" height="18" rx="2" stroke="url(#paint0_linear_2314_1266)" strokeWidth="1.5" /> <path d="M6 15.5L19 15.5" stroke="url(#paint1_linear_2314_1266)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M10 18.5L15 18.5" stroke="url(#paint2_linear_2314_1266)" strokeWidth="1.5" strokeLinecap="round" /> <mask id="path-4-inside-1_2314_1266" fill="white"> <rect x="4" y="6" width="17" height="7" rx="1" /> </mask> <rect x="4" y="6" width="17" height="7" rx="1" stroke="url(#paint3_linear_2314_1266)" strokeWidth="3" mask="url(#path-4-inside-1_2314_1266)" /> </g> </g> <defs> <linearGradient id="paint0_linear_2314_1266" x1="12.5" y1="4" x2="12.5" y2="22" gradientUnits="userSpaceOnUse"><stop stopColor={colorStop1} /><stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2314_1266" x1="12.5" y1="15.5" x2="12.5" y2="16.5" gradientUnits="userSpaceOnUse"><stop stopColor={colorStop1} /><stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2314_1266" x1="12.5" y1="18.5" x2="12.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stopColor={colorStop1} /><stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2314_1266" x1="12.5" y1="6" x2="12.5" y2="13" gradientUnits="userSpaceOnUse"><stop stopColor={colorStop1} /><stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2314_1266"> <rect width="25" height="25" fill="white" /> </clipPath> <clipPath id="clip1_2314_1266"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    content_timeline: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2282_1257)"> <line x1="12.5" y1="3" x2="12.5" y2="22" stroke="url(#paint0_linear_2282_1257)" strokeLinecap="round" /> <circle cx="12.5" cy="5.5" r="1" fill="white" stroke="url(#paint1_linear_2282_1257)" /> <circle cx="12.5" cy="19.5" r="1" fill="white" stroke="url(#paint2_linear_2282_1257)" /> <circle cx="12.5" cy="12.5" r="1" fill="white" stroke="url(#paint3_linear_2282_1257)" /> <path d="M18.834 2.25H19.5C20.464 2.25 21.1117 2.25146 21.5947 2.31641C22.0561 2.37845 22.2535 2.4859 22.3838 2.61621C22.5141 2.74652 22.6215 2.94388 22.6836 3.40527C22.7485 3.88831 22.75 4.53599 22.75 5.5C22.75 6.46401 22.7485 7.11169 22.6836 7.59473C22.6215 8.05612 22.5141 8.25348 22.3838 8.38379C22.2535 8.5141 22.0561 8.62155 21.5947 8.68359C21.1117 8.74854 20.464 8.75 19.5 8.75H18.583C17.9728 8.75 17.57 8.74891 17.2588 8.71777C16.9635 8.68821 16.8155 8.63654 16.707 8.57129C16.6694 8.54863 16.6327 8.52356 16.5977 8.49707C16.4968 8.42074 16.3933 8.30367 16.2559 8.04102C16.1108 7.76379 15.9601 7.38971 15.7324 6.82324C15.461 6.14792 15.3983 5.96596 15.3887 5.78809C15.3872 5.76153 15.3865 5.7346 15.3867 5.70801C15.3886 5.52999 15.4434 5.34541 15.6846 4.65918L15.7676 4.42285C16.0002 3.76091 16.1558 3.32299 16.3115 3.00098C16.4588 2.6965 16.5754 2.5648 16.6943 2.48047C16.8134 2.39612 16.977 2.32903 17.3135 2.29102C17.6688 2.25091 18.1327 2.25 18.834 2.25Z" stroke="url(#paint4_linear_2282_1257)" strokeWidth="1.5" /> <path d="M18.7725 16.25H19.5C20.464 16.25 21.1117 16.2515 21.5947 16.3164C22.0561 16.3785 22.2535 16.4859 22.3838 16.6162C22.5141 16.7465 22.6215 16.9439 22.6836 17.4053C22.7485 17.8883 22.75 18.536 22.75 19.5C22.75 20.464 22.7485 21.1117 22.6836 21.5947C22.6215 22.0561 22.5141 22.2535 22.3838 22.3838C22.2535 22.5141 22.0561 22.6215 21.5947 22.6836C21.1117 22.7485 20.464 22.75 19.5 22.75H18.7725C18.0852 22.75 17.6306 22.7488 17.2822 22.71C16.9527 22.6732 16.7917 22.609 16.6738 22.5273C16.556 22.4456 16.4392 22.3171 16.2891 22.0215C16.1305 21.709 15.9696 21.2846 15.7285 20.6416C15.4488 19.8956 15.3857 19.6952 15.3857 19.5C15.3857 19.3048 15.4488 19.1044 15.7285 18.3584C15.9696 17.7154 16.1305 17.291 16.2891 16.9785C16.4392 16.6829 16.556 16.5544 16.6738 16.4727C16.7917 16.391 16.9527 16.3268 17.2822 16.29C17.6306 16.2512 18.0852 16.25 18.7725 16.25Z" stroke="url(#paint5_linear_2282_1257)" strokeWidth="1.5" /> <path d="M5.5 9.25H6.22754C6.91475 9.25 7.36941 9.25121 7.71777 9.29004C8.04733 9.32678 8.20827 9.39095 8.32617 9.47266C8.44404 9.55438 8.56085 9.68287 8.71094 9.97852C8.86952 10.291 9.03036 10.7154 9.27148 11.3584C9.55123 12.1044 9.61426 12.3048 9.61426 12.5C9.61426 12.6952 9.55123 12.8956 9.27148 13.6416C9.03036 14.2846 8.86952 14.709 8.71094 15.0215C8.56085 15.3171 8.44404 15.4456 8.32617 15.5273C8.20827 15.609 8.04733 15.6732 7.71777 15.71C7.36941 15.7488 6.91475 15.75 6.22754 15.75H5.5C4.53599 15.75 3.88831 15.7485 3.40527 15.6836C2.94388 15.6215 2.74652 15.5141 2.61621 15.3838C2.4859 15.2535 2.37845 15.0561 2.31641 14.5947C2.25146 14.1117 2.25 13.464 2.25 12.5C2.25 11.536 2.25146 10.8883 2.31641 10.4053C2.37845 9.94388 2.4859 9.74652 2.61621 9.61621C2.74652 9.4859 2.94388 9.37845 3.40527 9.31641C3.88831 9.25146 4.53599 9.25 5.5 9.25Z" stroke="url(#paint6_linear_2282_1257)" strokeWidth="1.5" /> </g> <defs> <linearGradient id="paint0_linear_2282_1257" x1="11.5" y1="3.5" x2="11.5" y2="22.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2282_1257" x1="12.5" y1="4" x2="12.5" y2="7" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2282_1257" x1="12.5" y1="18" x2="12.5" y2="21" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2282_1257" x1="12.5" y1="11" x2="12.5" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint4_linear_2282_1257" x1="19" y1="1.5" x2="19" y2="9.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint5_linear_2282_1257" x1="19" y1="15.5" x2="19" y2="23.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint6_linear_2282_1257" x1="6" y1="8.5" x2="6" y2="16.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2282_1257"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    count_down: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2274_1506)"> <path d="M18.2291 7.8125L19.7916 6.25" stroke="url(#paint0_linear_2274_1506)" strokeWidth="2" strokeLinecap="round" /> <circle cx="12.5" cy="14.5833" r="8.33333" stroke="url(#paint1_linear_2274_1506)" strokeWidth="2" /> <path d="M12.5 14.5833L12.5 11.4583" stroke="url(#paint2_linear_2274_1506)" strokeWidth="2" strokeLinecap="round" /> <path d="M10.4877 2.46938C10.6064 2.35863 10.8679 2.26077 11.2318 2.19097C11.5956 2.12118 12.0414 2.08334 12.5 2.08334C12.9587 2.08334 13.4045 2.12118 13.7683 2.19097C14.1321 2.26077 14.3937 2.35863 14.5124 2.46938" stroke="url(#paint3_linear_2274_1506)" strokeWidth="2" strokeLinecap="round" /> </g> <defs> <linearGradient id="paint0_linear_2274_1506" x1="19.0104" y1="6.25" x2="19.0104" y2="7.8125" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2274_1506" x1="12.5" y1="6.25" x2="12.5" y2="22.9167" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2274_1506" x1="13" y1="11.4583" x2="13" y2="14.5833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint3_linear_2274_1506" x1="12.5" y1="2.08334" x2="12.5" y2="3.12501" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2274_1506"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    count_up: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2274_1750)"> <path d="M22 7.5L24 9.5M22 7.5L20 9.5M22 7.5L22 15.5" stroke="url(#paint0_linear_2274_1750)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <path className="rbea-editor-icon-selected-fill rbea-editor-icon-selected-no-stroke" d="M5.42599 14.339C5.53399 14.339 5.58799 14.384 5.58799 14.474V15.347C5.58799 15.383 5.57299 15.419 5.54299 15.455C5.51899 15.485 5.47399 15.5 5.40799 15.5H1.85299C1.73899 15.5 1.68199 15.449 1.68199 15.347V14.474C1.68199 14.384 1.73299 14.339 1.83499 14.339H2.77099C2.83699 14.339 2.86999 14.318 2.86999 14.276V10.496C2.86999 10.406 2.82799 10.373 2.74399 10.397L1.87099 10.658C1.73899 10.688 1.67299 10.631 1.67299 10.487V9.893C1.67299 9.827 1.68199 9.782 1.69999 9.758C1.71799 9.734 1.75399 9.707 1.80799 9.677L3.31099 8.93C3.39499 8.888 3.46099 8.861 3.50899 8.849C3.55699 8.831 3.61699 8.822 3.68899 8.822H4.30999C4.39999 8.822 4.44499 8.876 4.44499 8.984V14.249C4.44499 14.309 4.47199 14.339 4.52599 14.339H5.42599ZM8.31309 12.611C8.60109 12.359 8.83509 12.146 9.01509 11.972C9.19509 11.792 9.33609 11.636 9.43809 11.504C9.54009 11.372 9.60909 11.249 9.64509 11.135C9.68709 11.015 9.70809 10.889 9.70809 10.757C9.70809 10.571 9.66309 10.415 9.57309 10.289C9.48309 10.157 9.36309 10.055 9.21309 9.983C9.06909 9.911 8.90109 9.875 8.70909 9.875C8.54709 9.875 8.39109 9.905 8.24109 9.965C8.09709 10.025 7.95309 10.124 7.80909 10.262C7.67109 10.4 7.53309 10.586 7.39509 10.82C7.37709 10.856 7.34709 10.88 7.30509 10.892C7.26309 10.898 7.21209 10.886 7.15209 10.856L6.35109 10.442C6.29109 10.406 6.25509 10.361 6.24309 10.307C6.23709 10.253 6.25209 10.199 6.28809 10.145C6.60009 9.659 6.96309 9.302 7.37709 9.074C7.79709 8.846 8.27109 8.732 8.79909 8.732C9.27909 8.732 9.70209 8.813 10.0681 8.975C10.4341 9.137 10.7191 9.371 10.9231 9.677C11.1331 9.977 11.2381 10.337 11.2381 10.757C11.2381 10.997 11.1961 11.225 11.1121 11.441C11.0281 11.657 10.8901 11.873 10.6981 12.089C10.5121 12.305 10.2601 12.539 9.94209 12.791L8.27709 14.096C8.23509 14.12 8.21409 14.144 8.21409 14.168C8.22009 14.192 8.25909 14.204 8.33109 14.204H11.1301C11.2441 14.204 11.3011 14.252 11.3011 14.348V15.338C11.3011 15.386 11.2861 15.425 11.2561 15.455C11.2321 15.485 11.1871 15.5 11.1211 15.5H6.43209C6.35409 15.5 6.30009 15.488 6.27009 15.464C6.24009 15.434 6.22509 15.383 6.22509 15.311V14.618C6.22509 14.588 6.23109 14.555 6.24309 14.519C6.26109 14.483 6.30009 14.435 6.36009 14.375C6.42009 14.309 6.51309 14.225 6.63909 14.123L8.31309 12.611ZM12.2691 9.866C12.2211 9.812 12.2211 9.746 12.2691 9.668C12.4311 9.476 12.6351 9.311 12.8811 9.173C13.1271 9.029 13.3971 8.921 13.6911 8.849C13.9851 8.771 14.2881 8.732 14.6001 8.732C15.1281 8.732 15.5781 8.807 15.9501 8.957C16.3281 9.101 16.6161 9.305 16.8141 9.569C17.0181 9.827 17.1201 10.13 17.1201 10.478C17.1201 10.76 17.0301 11.033 16.8501 11.297C16.6701 11.555 16.4061 11.738 16.0581 11.846C15.9921 11.87 15.9561 11.9 15.9501 11.936C15.9501 11.966 15.9831 11.99 16.0491 12.008C16.3011 12.086 16.5231 12.203 16.7151 12.359C16.9071 12.509 17.0571 12.686 17.1651 12.89C17.2731 13.094 17.3271 13.319 17.3271 13.565C17.3271 13.991 17.2221 14.357 17.0121 14.663C16.8021 14.963 16.4871 15.194 16.0671 15.356C15.6471 15.512 15.1221 15.59 14.4921 15.59C14.1501 15.59 13.8201 15.545 13.5021 15.455C13.1841 15.365 12.8961 15.236 12.6381 15.068C12.3801 14.9 12.1671 14.702 11.9991 14.474C11.9631 14.426 11.9511 14.381 11.9631 14.339C11.9751 14.291 12.0051 14.249 12.0531 14.213L12.7551 13.718C12.8031 13.682 12.8421 13.667 12.8721 13.673C12.9081 13.673 12.9351 13.685 12.9531 13.709C13.1391 13.895 13.3131 14.045 13.4751 14.159C13.6371 14.267 13.8051 14.348 13.9791 14.402C14.1591 14.456 14.3601 14.483 14.5821 14.483C14.9601 14.483 15.2541 14.402 15.4641 14.24C15.6741 14.078 15.7791 13.865 15.7791 13.601C15.7791 13.397 15.7221 13.223 15.6081 13.079C15.4941 12.935 15.3411 12.824 15.1491 12.746C14.9631 12.668 14.7561 12.629 14.5281 12.629L13.7541 12.611C13.6521 12.611 13.6011 12.569 13.6011 12.485V11.639C13.6011 11.567 13.6521 11.525 13.7541 11.513L14.3751 11.486C14.6151 11.48 14.8251 11.438 15.0051 11.36C15.1851 11.276 15.3261 11.168 15.4281 11.036C15.5301 10.898 15.5811 10.745 15.5811 10.577C15.5811 10.433 15.5361 10.304 15.4461 10.19C15.3621 10.076 15.2451 9.986 15.0951 9.92C14.9451 9.848 14.7741 9.812 14.5821 9.812C14.3061 9.812 14.0541 9.866 13.8261 9.974C13.5981 10.076 13.3641 10.244 13.1241 10.478C13.0881 10.514 13.0551 10.535 13.0251 10.541C13.0011 10.541 12.9681 10.52 12.9261 10.478L12.2691 9.866Z" fill="url(#paint1_linear_2274_1750)" /> </g> <defs> <linearGradient id="paint0_linear_2274_1750" x1="22" y1="7.5" x2="22" y2="15.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2274_1750" x1="9.5" y1="6.5" x2="9.5" y2="17.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2274_1750"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    contact_form_7_styler: formIcon,

    divider: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M14.5 8L12.5 6L10.5 8" stroke="url(#paint0_linear_2270_1454)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <path d="M14.5 17L12.5 19L10.5 17" stroke="url(#paint1_linear_2270_1454)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <line x1="0.75" y1="12.25" x2="24.25" y2="12.25" stroke="url(#paint2_linear_2270_1454)" strokeWidth="1.5" strokeLinecap="round" /> <defs> <linearGradient id="paint0_linear_2270_1454" x1="12.5" y1="5" x2="12.5" y2="9" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2270_1454" x1="12.5" y1="16" x2="12.5" y2="20" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2270_1454" x1="12.5" y1="11.5" x2="12.5" y2="13" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> </defs> </svg>,

    expand: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_2282_1432)"> <path d="M3.125 11V6.125C3.125 4.46815 4.46815 3.125 6.125 3.125H18.875C20.5319 3.125 21.875 4.46815 21.875 6.125V18.875C21.875 20.5319 20.5319 21.875 18.875 21.875H14" stroke="url(#paint0_linear_2282_1432)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M16.6666 14.5834V8.33337M16.6666 8.33337H10.4166M16.6666 8.33337L9.89579 15.1042" stroke="url(#paint1_linear_2282_1432)" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" /> <rect x="3.125" y="14.5834" width="7.29167" height="7.29167" rx="2" stroke="url(#paint2_linear_2282_1432)" strokeWidth="1.5" strokeLinecap="round" /> </g> <defs> <linearGradient id="paint0_linear_2282_1432" x1="8" y1="-2.5" x2="22.5" y2="28.5" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="0.799616" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2282_1432" x1="13.2812" y1="8.33337" x2="13.2812" y2="15.1042" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2282_1432" x1="6.77083" y1="14.5834" x2="6.77083" y2="21.875" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2282_1432"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    feature_grid: <svg width="25" className="rbea-editor-icons" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_2282_1750)"> <g clipPath="url(#clip1_2282_1750)"> <rect x="1" y="1" width="10" height="23" rx="2" stroke="url(#paint0_linear_2282_1750)" strokeWidth="1.5" /> <rect x="14" y="1" width="10" height="23" rx="2" stroke="url(#paint1_linear_2282_1750)" strokeWidth="1.5" /> <path d="M4.125 6.5C4.125 5.67813 4.125 5.26719 4.35199 4.99061C4.39354 4.93997 4.43997 4.89354 4.49061 4.85199C4.76719 4.625 5.17813 4.625 6 4.625C6.82187 4.625 7.23281 4.625 7.50939 4.85199C7.56003 4.89354 7.60646 4.93997 7.64801 4.99061C7.875 5.26719 7.875 5.67813 7.875 6.5C7.875 7.32187 7.875 7.73281 7.64801 8.00939C7.60646 8.06003 7.56003 8.10646 7.50939 8.14801C7.23281 8.375 6.82187 8.375 6 8.375C5.17813 8.375 4.76719 8.375 4.49061 8.14801C4.43997 8.10646 4.39354 8.06003 4.35199 8.00939C4.125 7.73281 4.125 7.32187 4.125 6.5Z" stroke="url(#paint2_linear_2282_1750)" strokeWidth="1.5" /> <path d="M17.125 6.5C17.125 5.67813 17.125 5.26719 17.352 4.99061C17.3935 4.93997 17.44 4.89354 17.4906 4.85199C17.7672 4.625 18.1781 4.625 19 4.625C19.8219 4.625 20.2328 4.625 20.5094 4.85199C20.56 4.89354 20.6065 4.93997 20.648 4.99061C20.875 5.26719 20.875 5.67813 20.875 6.5C20.875 7.32187 20.875 7.73281 20.648 8.00939C20.6065 8.06003 20.56 8.10646 20.5094 8.14801C20.2328 8.375 19.8219 8.375 19 8.375C18.1781 8.375 17.7672 8.375 17.4906 8.14801C17.44 8.10646 17.3935 8.06003 17.352 8.00939C17.125 7.73281 17.125 7.32187 17.125 6.5Z" stroke="url(#paint3_linear_2282_1750)" strokeWidth="1.5" /> <line x1="4.25" y1="12.25" x2="7.75" y2="12.25" stroke="url(#paint4_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> <line x1="17.25" y1="12.25" x2="20.75" y2="12.25" stroke="url(#paint5_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> <line x1="4.25" y1="15.25" x2="7.75" y2="15.25" stroke="url(#paint6_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> <line x1="17.25" y1="15.25" x2="20.75" y2="15.25" stroke="url(#paint7_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> <line x1="4.25" y1="20.25" x2="7.75" y2="20.25" stroke="url(#paint8_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> <line x1="17.25" y1="20.25" x2="20.75" y2="20.25" stroke="url(#paint9_linear_2282_1750)" strokeWidth="1.5" strokeLinecap="round" /> </g> </g> <defs> <linearGradient id="paint0_linear_2282_1750" x1="6" y1="1" x2="6" y2="24" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint1_linear_2282_1750" x1="19" y1="1" x2="19" y2="24" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint2_linear_2282_1750" x1="6" y1="4.625" x2="6" y2="8.375" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint3_linear_2282_1750" x1="19" y1="4.625" x2="19" y2="8.375" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint4_linear_2282_1750" x1="6" y1="12" x2="6" y2="13" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint5_linear_2282_1750" x1="19" y1="12" x2="19" y2="13" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint6_linear_2282_1750" x1="6" y1="15" x2="6" y2="16" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint7_linear_2282_1750" x1="19" y1="15" x2="19" y2="16" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint8_linear_2282_1750" x1="6" y1="20" x2="6" y2="21" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint9_linear_2282_1750" x1="19" y1="20" x2="19" y2="21" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <clipPath id="clip0_2282_1750"> <rect width="25" height="25" fill="white" /> </clipPath> <clipPath id="clip1_2282_1750"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    portfolio: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint0_linear_2314_1242)" strokeWidth="1.5" rx="3.25" ></rect> <rect width="4.958" height="4.958" x="6.125" y="6.125" stroke="url(#paint1_linear_2314_1242)" strokeLinecap="round" strokeWidth="1.5" rx="0.708" ></rect> <rect width="4.958" height="4.958" x="6.125" y="13.917" stroke="url(#paint2_linear_2314_1242)" strokeLinecap="round" strokeWidth="1.5" rx="0.708" ></rect> <rect width="4.958" height="4.958" x="13.917" y="6.125" stroke="url(#paint3_linear_2314_1242)" strokeLinecap="round" strokeWidth="1.5" rx="0.708" ></rect> <path stroke="url(#paint4_linear_2314_1242)" strokeLinecap="round" strokeWidth="1.5" d="M16.396 13.917v4.958" ></path> <path stroke="url(#paint5_linear_2314_1242)" strokeLinecap="round" strokeWidth="1.5" d="M18.875 16.396h-4.958" ></path> <defs> <linearGradient id="paint0_linear_2314_1242" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2314_1242" x1="8.604" x2="8.604" y1="6.125" y2="11.083" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2314_1242" x1="8.604" x2="8.604" y1="13.917" y2="18.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2314_1242" x1="16.396" x2="16.396" y1="6.125" y2="11.083" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2314_1242" x1="16.396" x2="16.396" y1="13.917" y2="18.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2314_1242" x1="18.875" x2="13.917" y1="16.396" y2="16.396" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    flipbox: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <rect x="1.75" y="1.75" width="21.5" height="21.5" rx="3.25" stroke="url(#paint0_linear_2297_1606)" strokeWidth="1.5" /> <path d="M6.16663 15.6666L9.33329 18.8333M9.33329 18.8333L12.5 15.6666M9.33329 18.8333L9.33329 10.1666C9.33329 7.95751 11.1242 6.16665 13.3333 6.16665L14.0833 6.16665" stroke="url(#paint1_linear_2297_1606)" strokeWidth="1.5" strokeLinecap="round" /> <path d="M12.5 12.5L15.6667 9.33331M15.6667 9.33331L18.8333 12.5M15.6667 9.33331L15.6667 15.6666C15.6667 16.9783 14.6033 18.0416 13.2917 18.0416" stroke="url(#paint2_linear_2297_1606)" strokeWidth="1.5" strokeLinecap="round" /> <defs> <linearGradient id="paint0_linear_2297_1606" x1="12.5" y1="1" x2="12.5" y2="24" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint1_linear_2297_1606" x1="10.125" y1="6.16665" x2="10.125" y2="18.8333" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> <linearGradient id="paint2_linear_2297_1606" x1="15.6667" y1="9.33331" x2="15.6667" y2="18.0416" gradientUnits="userSpaceOnUse"> <stop stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /> </linearGradient> </defs> </svg>,

    gallery_masonry: <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" className="rbea-editor-icons" > <mask id="mask0_2281_1214" width="9" height="10" x="2" y="2" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="m2.375 7 .001-.223a4 4 0 0 1 3.9-3.9c.05-.002.108-.002.224-.002l.223.001A4 4 0 0 1 10.625 7l-.001.223a4 4 0 0 1-3.9 3.9c-.05.002-.108.002-.224.002l-.223-.001a4 4 0 0 1-3.9-3.9c-.002-.05-.002-.108-.002-.224" ></path> </mask> <g mask="url(#mask0_2281_1214)"> <path stroke="url(#paint0_linear_2281_1214)" d="m2.25 12.5-.152-2.61a3.53 3.53 0 0 1 1.16-2.816c.862-.78 2.244-.517 2.742.534.25.525.94.656 1.371.266a1.78 1.78 0 0 1 2.307-.062A3.58 3.58 0 0 1 11 10.582V12.5z" ></path> </g> <path stroke="url(#paint1_linear_2281_1214)" d="M2.375 4.875c0-.943 0-1.414.293-1.707s.764-.293 1.707-.293h4.25c.943 0 1.414 0 1.707.293s.293.764.293 1.707v4.25c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293h-4.25c-.943 0-1.414 0-1.707-.293s-.293-.764-.293-1.707z" ></path> <circle cx="8.563" cy="4.938" r="0.688" fill="url(#paint2_linear_2281_1214)" ></circle> <mask id="mask1_2281_1214" width="9" height="10" x="14" y="2" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="m14.375 7 .001-.223a4 4 0 0 1 3.9-3.9c.05-.002.108-.002.224-.002l.223.001A4 4 0 0 1 22.625 7l-.001.223a4 4 0 0 1-3.9 3.9c-.05.002-.108.002-.224.002l-.223-.001a4 4 0 0 1-3.9-3.9c-.002-.05-.002-.108-.002-.224" ></path> </mask> <g mask="url(#mask1_2281_1214)"> <path stroke="url(#paint3_linear_2281_1214)" d="m14.25 12.5-.152-2.61a3.53 3.53 0 0 1 1.16-2.816c.862-.78 2.244-.517 2.742.534.25.525.94.656 1.371.266a1.78 1.78 0 0 1 2.307-.062A3.58 3.58 0 0 1 23 10.582V12.5z" ></path> </g> <path stroke="url(#paint4_linear_2281_1214)" d="M14.375 4.875c0-.943 0-1.414.293-1.707s.764-.293 1.707-.293h4.25c.943 0 1.414 0 1.707.293s.293.764.293 1.707v4.25c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293h-4.25c-.943 0-1.414 0-1.707-.293s-.293-.764-.293-1.707z" ></path> <circle cx="20.563" cy="4.938" r="0.688" fill="url(#paint5_linear_2281_1214)" ></circle> <mask id="mask2_2281_1214" width="9" height="10" x="2" y="13" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="m2.375 18 .001-.223a4 4 0 0 1 3.9-3.9c.05-.002.108-.002.224-.002l.223.001A4 4 0 0 1 10.625 18l-.001.223a4 4 0 0 1-3.9 3.9c-.05.002-.108.002-.224.002l-.223-.001a4 4 0 0 1-3.9-3.9c-.002-.05-.002-.108-.002-.224" ></path> </mask> <g mask="url(#mask2_2281_1214)"> <path stroke="url(#paint6_linear_2281_1214)" d="m2.25 23.5-.152-2.61a3.53 3.53 0 0 1 1.16-2.816c.862-.78 2.244-.517 2.742.534.25.525.94.656 1.371.266a1.78 1.78 0 0 1 2.307-.062A3.58 3.58 0 0 1 11 21.582V23.5z" ></path> </g> <path stroke="url(#paint7_linear_2281_1214)" d="M2.375 15.875c0-.943 0-1.414.293-1.707s.764-.293 1.707-.293h4.25c.943 0 1.414 0 1.707.293s.293.764.293 1.707v4.25c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293h-4.25c-.943 0-1.414 0-1.707-.293s-.293-.764-.293-1.707z" ></path> <circle cx="8.563" cy="15.938" r="0.688" fill="url(#paint8_linear_2281_1214)" ></circle> <mask id="mask3_2281_1214" width="9" height="10" x="14" y="13" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="m14.375 18 .001-.223a4 4 0 0 1 3.9-3.9c.05-.002.108-.002.224-.002l.223.001A4 4 0 0 1 22.625 18l-.001.223a4 4 0 0 1-3.9 3.9c-.05.002-.108.002-.224.002l-.223-.001a4 4 0 0 1-3.9-3.9c-.002-.05-.002-.108-.002-.224" ></path> </mask> <g mask="url(#mask3_2281_1214)"> <path stroke="url(#paint9_linear_2281_1214)" d="m14.25 23.5-.152-2.61a3.53 3.53 0 0 1 1.16-2.816c.862-.78 2.244-.517 2.742.534.25.525.94.656 1.371.266a1.78 1.78 0 0 1 2.307-.062A3.58 3.58 0 0 1 23 21.582V23.5z" ></path> </g> <path stroke="url(#paint10_linear_2281_1214)" d="M14.375 15.875c0-.943 0-1.414.293-1.707s.764-.293 1.707-.293h4.25c.943 0 1.414 0 1.707.293s.293.764.293 1.707v4.25c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293h-4.25c-.943 0-1.414 0-1.707-.293s-.293-.764-.293-1.707z" ></path> <circle cx="20.563" cy="15.938" r="0.688" fill="url(#paint11_linear_2281_1214)" ></circle> <defs> <linearGradient id="paint0_linear_2281_1214" x1="6.5" x2="6.5" y1="5.5" y2="12.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2281_1214" x1="6.5" x2="6.5" y1="2.875" y2="11.125" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2281_1214" x1="8.563" x2="8.563" y1="4.25" y2="5.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2281_1214" x1="18.5" x2="18.5" y1="5.5" y2="12.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2281_1214" x1="18.5" x2="18.5" y1="2.875" y2="11.125" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2281_1214" x1="20.563" x2="20.563" y1="4.25" y2="5.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2281_1214" x1="6.5" x2="6.5" y1="16.5" y2="23.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint7_linear_2281_1214" x1="6.5" x2="6.5" y1="13.875" y2="22.125" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint8_linear_2281_1214" x1="8.563" x2="8.563" y1="15.25" y2="16.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint9_linear_2281_1214" x1="18.5" x2="18.5" y1="16.5" y2="23.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint10_linear_2281_1214" x1="18.5" x2="18.5" y1="13.875" y2="22.125" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint11_linear_2281_1214" x1="20.563" x2="20.563" y1="15.25" y2="16.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    googlemap: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <path className="rbea-editor-icon-selected-no-fill" fill="url(#paint0_linear_2278_1146)" d="M12.5 2.083v-.75zm7.292 7.292h.75zm-6.895 9.18.345.666zm-.795 0-.344.666zm-6.894-9.18h-.75zM12.5 2.083v.75a6.54 6.54 0 0 1 6.542 6.542h1.5c0-4.441-3.6-8.042-8.042-8.042zm7.292 7.292h-.75c0 2.35-1.201 4.268-2.658 5.732s-3.103 2.405-3.83 2.781l.344.667.344.666c.795-.41 2.594-1.437 4.205-3.055 1.61-1.619 3.095-3.896 3.095-6.791zm-6.895 9.18-.344-.667a.1.1 0 0 1-.106 0l-.344.667-.345.666a1.6 1.6 0 0 0 1.484 0zm-.795 0 .345-.667c-.728-.376-2.375-1.317-3.831-2.78-1.457-1.465-2.658-3.384-2.658-5.733h-1.5c0 2.895 1.485 5.172 3.095 6.79 1.61 1.62 3.41 2.645 4.205 3.056zm-6.894-9.18h.75A6.54 6.54 0 0 1 12.5 2.833v-1.5a8.04 8.04 0 0 0-8.042 8.042zM12.5 6.25V5.5a3.875 3.875 0 0 0-3.875 3.875h1.5A2.375 2.375 0 0 1 12.5 7zM9.375 9.375h-.75A3.875 3.875 0 0 0 12.5 13.25v-1.5a2.375 2.375 0 0 1-2.375-2.375zM12.5 12.5v.75a3.875 3.875 0 0 0 3.875-3.875h-1.5A2.375 2.375 0 0 1 12.5 11.75zm3.125-3.125h.75A3.875 3.875 0 0 0 12.5 5.5V7a2.375 2.375 0 0 1 2.375 2.375z" ></path> <path stroke="url(#paint1_linear_2278_1146)" strokeLinecap="round" strokeWidth="1.5" d="M20.619 18.23c.823.474 1.256 1.013 1.256 1.562 0 .548-.433 1.087-1.256 1.562s-2.006.87-3.431 1.144-3.042.419-4.688.419-3.262-.145-4.687-.419-2.61-.669-3.432-1.144-1.256-1.014-1.256-1.562c0-.549.433-1.088 1.256-1.563" ></path> <defs> <linearGradient id="paint0_linear_2278_1146" x1="12.5" x2="12.5" y1="2.083" y2="18.653" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2278_1146" x1="12.5" x2="12.5" y1="16.667" y2="22.917" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    icons_list: iconListIcon,

    icons_list_child: iconListIcon,

    image_boxes: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint0_linear_2297_1631)" strokeWidth="1.5" rx="3.25" ></rect> <path stroke="url(#paint1_linear_2297_1631)" strokeLinecap="round" strokeWidth="1.5" d="M6 16.5h13" ></path> <path stroke="url(#paint2_linear_2297_1631)" strokeLinecap="round" strokeWidth="1.5" d="M6 19.5h7" ></path> <mask id="mask0_2297_1631" width="16" height="8" x="4" y="5" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="M4 9a4 4 0 0 1 4-4h8a4 4 0 0 1 0 8H8a4 4 0 0 1-4-4" ></path> </mask> <g mask="url(#mask0_2297_1631)"> <path stroke="url(#paint3_linear_2297_1631)" d="m8.634 9.29-.078.075c-.24.232-.36.348-.465.468a4 4 0 0 0-.996 2.54c-.005.16.004.327.023.66L7.333 17H19v-2.96c0-.373 0-.56-.016-.737a4 4 0 0 0-1.099-2.414 9 9 0 0 0-.544-.496l-.102-.088a5 5 0 0 0-.345-.287 2 2 0 0 0-2.396.062 5 5 0 0 0-.33.305c-.123.12-.185.18-.237.219a1 1 0 0 1-1.451-.283 3 3 0 0 1-.141-.298c-.158-.356-.237-.534-.313-.656A2 2 0 0 0 9.16 8.81c-.116.084-.253.216-.526.48Z" ></path> </g> <path stroke="url(#paint4_linear_2297_1631)" d="M6 9c0-1.886 0-2.828.586-3.414S8.114 5 10 5h5c1.886 0 2.828 0 3.414.586S19 7.114 19 9s0 2.828-.586 3.414S16.886 13 15 13h-5c-1.886 0-2.828 0-3.414-.586S6 10.886 6 9Z" ></path> <circle cx="14.563" cy="6.938" r="0.688" fill="url(#paint5_linear_2297_1631)" ></circle> <defs> <linearGradient id="paint0_linear_2297_1631" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2297_1631" x1="12.5" x2="12.5" y1="16.5" y2="17.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2297_1631" x1="9.5" x2="9.5" y1="19.5" y2="20.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2297_1631" x1="13" x2="13" y1="7" y2="17" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2297_1631" x1="12.5" x2="12.5" y1="5" y2="13" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2297_1631" x1="14.563" x2="14.563" y1="6.25" y2="7.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    image_hotspot: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2297_1812)"> <g clipPath="url(#clip1_2297_1812)"> <path stroke="url(#paint0_linear_2297_1812)" strokeWidth="1.5" d="M3.125 10c0-2.69 0-4.035.62-5.015a4 4 0 0 1 1.24-1.24c.98-.62 2.325-.62 5.015-.62h3.875c3.771 0 5.657 0 6.828 1.172s1.172 3.057 1.172 6.828v2.75c0 3.771 0 5.657-1.172 6.828s-3.057 1.172-6.828 1.172H10.5" ></path> <path className="rbea-editor-icon-selected-no-fill" fill="url(#paint1_linear_2297_1812)" d="M7.845 8.806a.75.75 0 0 1 1.058.08l5.183 6.049.083.095q.015.018.019.02a.25.25 0 0 0 .387-.047l.013-.024.058-.114c.09-.18.155-.315.22-.42a2.75 2.75 0 0 1 4.125-.669c.093.08.199.186.341.329l.541.54a59 59 0 0 1-.03 2.091l-1.571-1.571a5 5 0 0 0-.25-.243 1.25 1.25 0 0 0-1.875.304c-.023.037-.055.1-.16.31-.045.089-.089.18-.133.252a1.75 1.75 0 0 1-2.717.334c-.06-.06-.125-.137-.19-.212L7.765 9.863a.75.75 0 0 1 .081-1.057" ></path> <circle className="rbea-editor-icon-selected-no-fill" cx="17.188" cy="7.813" r="1.563" fill="url(#paint2_linear_2297_1812)" ></circle> <path stroke="url(#paint3_linear_2297_1812)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.7" d="M5.358 15.379h.037" ></path> <path stroke="url(#paint4_linear_2297_1812)" strokeLinecap="round" strokeLinejoin="round" d="M2.99 17.765a3.376 3.376 0 1 1 4.772 0" ></path> <path stroke="url(#paint5_linear_2297_1812)" strokeLinecap="round" strokeLinejoin="round" d="M6.704 16.707a1.876 1.876 0 1 0-2.656 0" ></path> <path stroke="url(#paint6_linear_2297_1812)" strokeLinecap="round" d="M5.4 15.5v7" ></path> </g> </g> <defs> <linearGradient id="paint0_linear_2297_1812" x1="12.5" x2="12.5" y1="3.125" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2297_1812" x1="13.853" x2="13.853" y1="8.875" y2="16.395" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2297_1812" x1="17.188" x2="17.188" y1="6.25" y2="9.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2297_1812" x1="5.376" x2="5.376" y1="15.379" y2="16.379" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2297_1812" x1="5.376" x2="5.376" y1="12" y2="17.765" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2297_1812" x1="5.376" x2="5.376" y1="13.507" y2="16.707" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2297_1812" x1="4.4" x2="4.4" y1="16" y2="23" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2297_1812"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> <clipPath id="clip1_2297_1812"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    image_slider: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2282_1304)"> <g clipPath="url(#clip1_2282_1304)"> <mask id="mask0_2282_1304" width="17" height="17" x="4" y="4" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="M4.625 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139C7.025 4.625 8.85 4.625 12.5 4.625s5.475 0 6.633 1.103q.072.067.139.139c1.103 1.158 1.103 2.983 1.103 6.633s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139C4.625 17.975 4.625 16.15 4.625 12.5" ></path> </mask> <g mask="url(#mask0_2282_1304)"> <path stroke="url(#paint0_linear_2282_1304)" strokeWidth="1.5" d="m6.734 13.016-.134.134c-.702.702-1.053 1.053-1.302 1.462a4 4 0 0 0-.516 1.345c-.088.47-.062.965-.01 1.957l.29 5.523h15.313v-4.15c0-1.049 0-1.573-.126-2.063a4 4 0 0 0-.543-1.22c-.28-.42-.67-.771-1.45-1.473l-.187-.17c-.617-.554-.925-.831-1.258-.963a2 2 0 0 0-1.574.04c-.325.15-.619.444-1.205 1.03-.434.434-.651.651-.87.726a1 1 0 0 1-.977-.187c-.176-.152-.299-.44-.546-1.015-.532-1.242-.798-1.863-1.19-2.176a2 2 0 0 0-1.828-.352c-.48.145-.95.614-1.887 1.552Z" ></path> </g> <path stroke="url(#paint1_linear_2282_1304)" strokeWidth="1.5" d="M4.625 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139C7.025 4.625 8.85 4.625 12.5 4.625s5.475 0 6.633 1.103q.072.067.139.139c1.103 1.158 1.103 2.983 1.103 6.633s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139C4.625 17.975 4.625 16.15 4.625 12.5Z" ></path> <circle className="rbea-editor-icon-selected-no-fill" cx="16.438" cy="8.563" r="1.313" fill="url(#paint2_linear_2282_1304)" ></circle> <mask id="mask1_2282_1304" width="17" height="17" x="-15" y="4" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="M-14.375 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139c1.158-1.103 2.983-1.103 6.633-1.103s5.475 0 6.633 1.103q.072.067.139.139C1.375 7.025 1.375 8.85 1.375 12.5s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139c-1.103-1.158-1.103-2.983-1.103-6.633" ></path> </mask> <g mask="url(#mask1_2282_1304)"> <path stroke="url(#paint3_linear_2282_1304)" strokeWidth="1.5" d="m-12.266 13.016-.134.134c-.702.702-1.053 1.053-1.302 1.462a4 4 0 0 0-.516 1.345c-.088.47-.062.965-.01 1.957l.29 5.523H1.376v-4.15c0-1.049 0-1.573-.126-2.063a4 4 0 0 0-.543-1.22c-.28-.42-.67-.771-1.45-1.473l-.187-.17c-.617-.554-.925-.831-1.258-.963a2 2 0 0 0-1.574.04c-.326.15-.619.444-1.205 1.03-.434.434-.651.651-.87.726a1 1 0 0 1-.977-.187c-.176-.152-.299-.44-.545-1.015-.533-1.242-.799-1.863-1.19-2.176a2 2 0 0 0-1.829-.352c-.48.145-.95.614-1.887 1.552Z" ></path> </g> <path stroke="url(#paint4_linear_2282_1304)" strokeWidth="1.5" d="M-14.375 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139c1.158-1.103 2.983-1.103 6.633-1.103s5.475 0 6.633 1.103q.072.067.139.139C1.375 7.025 1.375 8.85 1.375 12.5s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139c-1.103-1.158-1.103-2.983-1.103-6.633Z" ></path> <mask id="mask2_2282_1304" width="17" height="17" x="23" y="4" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="M23.625 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139c1.158-1.103 2.983-1.103 6.633-1.103s5.475 0 6.633 1.103q.072.067.139.139c1.103 1.158 1.103 2.983 1.103 6.633s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139c-1.103-1.158-1.103-2.983-1.103-6.633" ></path> </mask> <g mask="url(#mask2_2282_1304)"> <path stroke="url(#paint5_linear_2282_1304)" strokeWidth="1.5" d="m25.734 13.016-.134.134c-.702.702-1.053 1.053-1.302 1.462a4 4 0 0 0-.516 1.345c-.088.47-.062.965-.01 1.957l.29 5.523h15.313v-4.15c0-1.049 0-1.573-.126-2.063a4 4 0 0 0-.543-1.22c-.28-.42-.67-.771-1.45-1.473l-.187-.17c-.617-.554-.925-.831-1.258-.963a2 2 0 0 0-1.574.04c-.326.15-.619.444-1.205 1.03-.434.434-.651.651-.87.726a1 1 0 0 1-.977-.187c-.175-.152-.299-.44-.545-1.015-.533-1.242-.799-1.863-1.19-2.176a2 2 0 0 0-1.829-.352c-.48.145-.95.614-1.887 1.552Z" ></path> </g> <path stroke="url(#paint6_linear_2282_1304)" strokeWidth="1.5" d="M23.625 12.5c0-3.65 0-5.475 1.103-6.633q.067-.072.139-.139c1.158-1.103 2.983-1.103 6.633-1.103s5.475 0 6.633 1.103q.072.067.139.139c1.103 1.158 1.103 2.983 1.103 6.633s0 5.475-1.103 6.633a4 4 0 0 1-.139.139c-1.158 1.103-2.983 1.103-6.633 1.103s-5.475 0-6.633-1.103a4 4 0 0 1-.139-.139c-1.103-1.158-1.103-2.983-1.103-6.633Z" ></path> </g> </g> <defs> <linearGradient id="paint0_linear_2282_1304" x1="12.5" x2="12.5" y1="9.875" y2="23.438" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1304" x1="12.5" x2="12.5" y1="4.625" y2="20.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1304" x1="16.438" x2="16.438" y1="7.25" y2="9.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2282_1304" x1="-6.5" x2="-6.5" y1="9.875" y2="23.438" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2282_1304" x1="-6.5" x2="-6.5" y1="4.625" y2="20.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2282_1304" x1="31.5" x2="31.5" y1="9.875" y2="23.438" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2282_1304" x1="31.5" x2="31.5" y1="4.625" y2="20.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2282_1304"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> <clipPath id="clip1_2282_1304"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    info_block: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2274_1476)"> <rect width="14.583" height="17.708" x="5.208" y="4.167" stroke="url(#paint0_linear_2274_1476)" strokeWidth="1.5" rx="2" ></rect> <path stroke="url(#paint1_linear_2274_1476)" strokeLinecap="round" strokeWidth="2" d="M9.38 9.38h0" ></path> <path stroke="url(#paint2_linear_2274_1476)" strokeLinecap="round" strokeWidth="1.5" d="M9.375 13.542h6.25" ></path> <path stroke="url(#paint3_linear_2274_1476)" strokeLinecap="round" strokeWidth="1.5" d="M9.375 17.708h4.167" ></path> </g> <defs> <linearGradient id="paint0_linear_2274_1476" x1="12.5" x2="12.5" y1="4.167" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2274_1476" x1="9.38" x2="9.38" y1="9.38" y2="10.38" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2274_1476" x1="12.5" x2="12.5" y1="13.542" y2="14.542" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2274_1476" x1="11.458" x2="11.458" y1="17.708" y2="18.708" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2274_1476"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    inline_notice: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2274_1618)"> <path stroke="url(#paint0_linear_2274_1618)" strokeWidth="1.5" d="M1 12.5c0-2.056 0-3.084.462-3.85a3.4 3.4 0 0 1 1.263-1.208C3.525 7 4.6 7 6.75 7h11.5c2.15 0 3.224 0 4.025.442.524.29.96.706 1.263 1.208.462.766.462 1.794.462 3.85s0 3.084-.462 3.85a3.4 3.4 0 0 1-1.263 1.208C21.475 18 20.4 18 18.25 18H6.75c-2.15 0-3.224 0-4.025-.442a3.4 3.4 0 0 1-1.263-1.208C1 15.584 1 14.556 1 12.5Z" ></path> <rect className="rbea-editor-icon-selected-no-fill" width="13" height="2" x="8" y="11.5" fill="url(#paint1_linear_2274_1618)" stroke="url(#paint2_linear_2274_1618)" rx="1" ></rect> <circle className="rbea-editor-icon-selected-no-fill" cx="5" cy="12.5" r="1.5" fill="url(#paint3_linear_2274_1618)" ></circle> </g> <defs> <linearGradient id="paint0_linear_2274_1618" x1="12.5" x2="12.5" y1="7" y2="18" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2274_1618" x1="14.5" x2="14.5" y1="11" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2274_1618" x1="14.5" x2="14.5" y1="11" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2274_1618" x1="5" x2="5" y1="11" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2274_1618"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    instagram: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2285_1383)"> <path stroke="url(#paint0_linear_2285_1383)" strokeWidth="1.5" d="M3.125 11.125c0-3.771 0-5.657 1.172-6.828s3.057-1.172 6.828-1.172h2.75c3.771 0 5.657 0 6.828 1.172s1.172 3.057 1.172 6.828v2.75c0 3.771 0 5.657-1.172 6.828s-3.057 1.172-6.828 1.172h-2.75c-3.771 0-5.657 0-6.828-1.172s-1.172-3.057-1.172-6.828z" ></path> <circle className="rbea-editor-icon-selected-no-fill" cx="17.188" cy="7.813" r="1.563" fill="url(#paint1_linear_2285_1383)" ></circle> <circle cx="12.5" cy="12.5" r="3.417" stroke="url(#paint2_linear_2285_1383)" strokeWidth="1.5" ></circle> </g> <defs> <linearGradient id="paint0_linear_2285_1383" x1="12.5" x2="12.5" y1="3.125" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2285_1383" x1="17.188" x2="17.188" y1="6.25" y2="9.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2285_1383" x1="12.5" x2="12.5" y1="8.333" y2="16.667" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2285_1383"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    post_carousel: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2281_1311)"> <g strokeWidth="1.5" clipPath="url(#clip1_2281_1311)"> <rect width="15" height="17" x="5" y="4" stroke="url(#paint0_linear_2281_1311)" rx="2" ></rect> <path stroke="url(#paint1_linear_2281_1311)" strokeLinecap="round" d="M7.75 7.95h9.5" ></path> <path stroke="url(#paint2_linear_2281_1311)" strokeLinecap="round" d="M7.75 12.45h9.5" ></path> <path stroke="url(#paint3_linear_2281_1311)" strokeLinecap="round" d="M7.75 17.05h6.5" ></path> <path stroke="url(#paint4_linear_2281_1311)" d="M-2 4h2a2 2 0 0 1 2 2v13a2 2 0 0 1-2 2h-2" ></path> <path stroke="url(#paint5_linear_2281_1311)" d="M27 4h-2a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2h2" ></path> </g> </g> <defs> <linearGradient id="paint0_linear_2281_1311" x1="12.5" x2="12.5" y1="4" y2="21" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2281_1311" x1="12.5" x2="12.5" y1="7.2" y2="8.7" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2281_1311" x1="12.5" x2="12.5" y1="11.7" y2="13.2" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2281_1311" x1="11" x2="11" y1="16.3" y2="17.8" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2281_1311" x1="0" x2="0" y1="4" y2="21" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2281_1311" x1="25" x2="25" y1="4" y2="21" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2281_1311"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> <clipPath id="clip1_2281_1311"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    post_grid: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeLinejoin="round" strokeWidth="1.5" clipPath="url(#clip0_2281_1263)" > <rect width="6.25" height="7.292" x="4.167" y="4.167" stroke="url(#paint0_linear_2281_1263)" rx="1" ></rect> <rect width="6.25" height="5.208" x="4.167" y="15.625" stroke="url(#paint1_linear_2281_1263)" rx="1" ></rect> <rect width="6.25" height="5.208" x="14.583" y="4.167" stroke="url(#paint2_linear_2281_1263)" rx="1" ></rect> <rect width="6.25" height="7.292" x="14.583" y="13.542" stroke="url(#paint3_linear_2281_1263)" rx="1" ></rect> </g> <defs> <linearGradient id="paint0_linear_2281_1263" x1="7.292" x2="7.292" y1="4.167" y2="11.458" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2281_1263" x1="7.292" x2="7.292" y1="15.625" y2="20.833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2281_1263" x1="17.708" x2="17.708" y1="4.167" y2="9.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2281_1263" x1="17.708" x2="17.708" y1="13.542" y2="20.833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2281_1263"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    post_timeline: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2281_1357)"> <path stroke="url(#paint0_linear_2281_1357)" strokeLinecap="round" strokeWidth="1.5" d="M3.45 2.75v18.5" ></path> <circle cx="3.5" cy="7" r="1.5" fill="#fff" stroke="url(#paint1_linear_2281_1357)" ></circle> <circle cx="3.5" cy="17" r="1.5" fill="#fff" stroke="url(#paint2_linear_2281_1357)" ></circle> <rect width="15.5" height="6.5" x="6.75" y="3.75" stroke="url(#paint3_linear_2281_1357)" strokeWidth="1.5" rx="1.25" ></rect> <rect width="15.5" height="6.5" x="6.75" y="13.75" stroke="url(#paint4_linear_2281_1357)" strokeWidth="1.5" rx="1.25" ></rect> <path stroke="url(#paint5_linear_2281_1357)" strokeLinecap="round" d="M9.5 7h10" ></path> <path stroke="url(#paint6_linear_2281_1357)" strokeLinecap="round" d="M9.5 17h10" ></path> </g> <defs> <linearGradient id="paint0_linear_2281_1357" x1="2.2" x2="2.2" y1="3" y2="22" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2281_1357" x1="3.5" x2="3.5" y1="5" y2="9" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2281_1357" x1="3.5" x2="3.5" y1="15" y2="19" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2281_1357" x1="14.5" x2="14.5" y1="3" y2="11" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2281_1357" x1="14.5" x2="14.5" y1="13" y2="21" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2281_1357" x1="14.5" x2="14.5" y1="5.5" y2="7.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2281_1357" x1="14.5" x2="14.5" y1="15.5" y2="17.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2281_1357"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    pricing_list: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint0_linear_2282_1556)" strokeWidth="1.5" rx="3.25" ></rect> <path stroke="url(#paint1_linear_2282_1556)" strokeLinecap="round" strokeWidth="1.5" d="M5.75 7.25h6.5" ></path> <path stroke="url(#paint2_linear_2282_1556)" strokeLinecap="round" strokeWidth="1.5" d="M5.75 15.25h6.5" ></path> <path stroke="url(#paint3_linear_2282_1556)" strokeLinecap="round" strokeWidth="1.5" d="M5.75 10.25h4.5" ></path> <path stroke="url(#paint4_linear_2282_1556)" strokeLinecap="round" strokeWidth="1.5" d="M5.75 18.25h4.5" ></path> <path stroke="url(#paint5_linear_2282_1556)" strokeLinecap="round" strokeWidth="0.7" d="M19.875 7.014c0-.527-.616-.954-1.375-.954-.76 0-1.375.427-1.375.954s.375.818 1.375.818 1.5.272 1.5.954-.672.954-1.5.954-1.5-.427-1.5-.954" ></path> <path stroke="url(#paint6_linear_2282_1556)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.7" d="M18.5 5.6v4.6" ></path> <path stroke="url(#paint7_linear_2282_1556)" strokeLinecap="round" strokeWidth="0.7" d="M19.875 15.214c0-.527-.616-.954-1.375-.954-.76 0-1.375.427-1.375.954s.375.818 1.375.818 1.5.273 1.5.954-.672.954-1.5.954-1.5-.427-1.5-.954" ></path> <path stroke="url(#paint8_linear_2282_1556)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.7" d="M18.5 13.8v4.6" ></path> <defs> <linearGradient id="paint0_linear_2282_1556" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1556" x1="9" x2="9" y1="6.5" y2="8" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1556" x1="9" x2="9" y1="14.5" y2="16" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2282_1556" x1="8" x2="8" y1="9.5" y2="11" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2282_1556" x1="8" x2="8" y1="17.5" y2="19" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2282_1556" x1="18.5" x2="18.5" y1="6.06" y2="9.74" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2282_1556" x1="19" x2="19" y1="5.6" y2="10.2" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint7_linear_2282_1556" x1="18.5" x2="18.5" y1="14.26" y2="17.94" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint8_linear_2282_1556" x1="19" x2="19" y1="13.8" y2="18.4" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    pricing_table: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2282_1522)"> <g clipPath="url(#clip1_2282_1522)"> <rect width="10" height="23" x="1" y="1" stroke="url(#paint0_linear_2282_1522)" strokeWidth="1.5" rx="2" ></rect> <rect width="10" height="23" x="14" y="1" stroke="url(#paint1_linear_2282_1522)" strokeWidth="1.5" rx="2" ></rect> <path stroke="url(#paint2_linear_2282_1522)" strokeLinecap="round" strokeWidth="0.7" d="M7.554 6.537c0-.572-.718-1.037-1.604-1.037s-1.604.464-1.604 1.037.437.889 1.604.889 1.75.296 1.75 1.037S6.916 9.5 5.95 9.5c-.967 0-1.75-.464-1.75-1.037" ></path> <path stroke="url(#paint3_linear_2282_1522)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.7" d="M5.95 5v5" ></path> <path stroke="url(#paint4_linear_2282_1522)" strokeLinecap="round" strokeWidth="0.7" d="M20.554 6.537c0-.572-.718-1.037-1.604-1.037s-1.604.464-1.604 1.037.437.889 1.604.889 1.75.296 1.75 1.037S19.916 9.5 18.95 9.5s-1.75-.464-1.75-1.037" ></path> <path stroke="url(#paint5_linear_2282_1522)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.7" d="M18.95 5v5" ></path> <path stroke="url(#paint6_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M4.25 13.25h3.5" ></path> <path stroke="url(#paint7_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M17.25 13.25h3.5" ></path> <path stroke="url(#paint8_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M4.25 16.25h3.5" ></path> <path stroke="url(#paint9_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M17.25 16.25h3.5" ></path> <path stroke="url(#paint10_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M4.25 19.25h3.5" ></path> <path stroke="url(#paint11_linear_2282_1522)" strokeLinecap="round" strokeWidth="1.5" d="M17.25 19.25h3.5" ></path> </g> </g> <defs> <linearGradient id="paint0_linear_2282_1522" x1="6" x2="6" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1522" x1="19" x2="19" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1522" x1="5.95" x2="5.95" y1="5.5" y2="9.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2282_1522" x1="6.45" x2="6.45" y1="5" y2="10" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2282_1522" x1="18.95" x2="18.95" y1="5.5" y2="9.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2282_1522" x1="19.45" x2="19.45" y1="5" y2="10" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2282_1522" x1="6" x2="6" y1="13" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint7_linear_2282_1522" x1="19" x2="19" y1="13" y2="14" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint8_linear_2282_1522" x1="6" x2="6" y1="16" y2="17" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint9_linear_2282_1522" x1="19" x2="19" y1="16" y2="17" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint10_linear_2282_1522" x1="6" x2="6" y1="19" y2="20" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint11_linear_2282_1522" x1="19" x2="19" y1="19" y2="20" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2282_1522"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> <clipPath id="clip1_2282_1522"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    progress_bar: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2274_1650)"> <rect width="9.5" height="20.5" x="22.75" y="7.75" stroke="url(#paint0_linear_2274_1650)" strokeWidth="1.5" rx="1.75" transform="rotate(90 22.75 7.75)" ></rect> <rect className="rbea-editor-icon-selected-fill" width="6" height="6" x="10" y="9.5" fill="url(#paint1_linear_2274_1650)" rx="0.8" transform="rotate(90 10 9.5)" ></rect> </g> <defs> <linearGradient id="paint0_linear_2274_1650" x1="26" x2="26" y1="8.5" y2="27.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2274_1650" x1="13" x2="13" y1="9.5" y2="15.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2274_1650"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    section: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2270_1142)"> <rect width="14.583" height="17.708" x="5.208" y="4.167" stroke="url(#paint0_linear_2270_1142)" strokeWidth="1.5" rx="2" ></rect> <path stroke="url(#paint1_linear_2270_1142)" strokeLinecap="round" strokeWidth="1.5" d="M9 15.5h7" ></path> <path stroke="url(#paint2_linear_2270_1142)" strokeLinecap="round" strokeWidth="1.5" d="M9 18.5h5" ></path> <mask id="path-4-inside-1_2270_1142" fill="#fff"> <rect width="9" height="6" x="8" y="7" rx="1"></rect> </mask> <rect width="9" height="6" x="8" y="7" stroke="url(#paint3_linear_2270_1142)" strokeWidth="3" mask="url(#path-4-inside-1_2270_1142)" rx="1" ></rect> </g> <defs> <linearGradient id="paint0_linear_2270_1142" x1="12.5" x2="12.5" y1="4.167" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2270_1142" x1="12.5" x2="12.5" y1="15.5" y2="16.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2270_1142" x1="11.5" x2="11.5" y1="18.5" y2="19.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2270_1142" x1="12.5" x2="12.5" y1="7" y2="13" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2270_1142"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    shape_divider: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint0_linear_2297_1645)" strokeWidth="1.5" rx="3.25" ></rect> <path stroke="url(#paint1_linear_2297_1645)" strokeWidth="1.5" d="m11.846 13.481-1.043-1.623c-1.831-2.85-5.936-3.02-7.997-.33A3.9 3.9 0 0 0 2 13.907V23h21v-6.916a4 4 0 0 0-1.427-3.048l-.023-.02-.042-.035a5 5 0 0 0-5.732-.445l-.048.028-2.19 1.313c-.192.116-.289.174-.38.207a1 1 0 0 1-1.064-.25c-.066-.069-.127-.164-.248-.353Z" ></path> <defs> <linearGradient id="paint0_linear_2297_1645" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2297_1645" x1="12.5" x2="12.5" y1="6" y2="23" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    social_icons: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" clipPath="url(#clip0_2285_1276)" > <path stroke="url(#paint0_linear_2285_1276)" d="m9 14 7 4m0-11-7 4" ></path> <path stroke="url(#paint1_linear_2285_1276)" d="M18.75 8.333a3.125 3.125 0 1 0 0-6.25 3.125 3.125 0 0 0 0 6.25" ></path> <path stroke="url(#paint2_linear_2285_1276)" d="M6.25 15.625a3.125 3.125 0 1 0 0-6.25 3.125 3.125 0 0 0 0 6.25" ></path> <path stroke="url(#paint3_linear_2285_1276)" d="M18.75 22.917a3.125 3.125 0 1 0 0-6.25 3.125 3.125 0 0 0 0 6.25" ></path> </g> <defs> <linearGradient id="paint0_linear_2285_1276" x1="12.5" x2="12.5" y1="7" y2="18" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2285_1276" x1="18.75" x2="18.75" y1="2.083" y2="8.333" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2285_1276" x1="6.25" x2="6.25" y1="9.375" y2="15.625" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2285_1276" x1="18.75" x2="18.75" y1="16.667" y2="22.917" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2285_1276"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    spacer: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeLinecap="round" strokeWidth="1.5" clipPath="url(#clip0_2274_1587)"> <path stroke="url(#paint0_linear_2274_1587)" strokeLinejoin="round" d="m7.5 8.5 5-5m0 0 5 5m-5-5v11" ></path> <path stroke="url(#paint1_linear_2274_1587)" strokeLinejoin="round" d="m7.5 16.5 5 5m0 0 5-5m-5 5v-7" ></path> <path stroke="url(#paint2_linear_2274_1587)" d="M3.25 1.75h18.5"></path> <path stroke="url(#paint3_linear_2274_1587)" d="M3.25 22.75h18.5"></path> </g> <defs> <linearGradient id="paint0_linear_2274_1587" x1="12.5" x2="12.5" y1="14.5" y2="3.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2274_1587" x1="12.5" x2="12.5" y1="14.5" y2="21.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2274_1587" x1="12.5" x2="12.5" y1="2.5" y2="3.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2274_1587" x1="12.5" x2="12.5" y1="23.5" y2="24.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2274_1587"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    table_of_contents: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeWidth="1.5" clipPath="url(#clip0_2274_1684)"> <rect width="14.583" height="17.708" x="5.208" y="4.167" stroke="url(#paint0_linear_2274_1684)" rx="2" ></rect> <path stroke="url(#paint1_linear_2274_1684)" strokeLinecap="round" d="M9.375 9.375h6.25" ></path> <path stroke="url(#paint2_linear_2274_1684)" strokeLinecap="round" d="M9.375 13.542h6.25" ></path> <path stroke="url(#paint3_linear_2274_1684)" strokeLinecap="round" d="M9.375 17.708h4.167" ></path> </g> <defs> <linearGradient id="paint0_linear_2274_1684" x1="12.5" x2="12.5" y1="4.167" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2274_1684" x1="12.5" x2="12.5" y1="9.375" y2="10.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2274_1684" x1="12.5" x2="12.5" y1="13.542" y2="14.542" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2274_1684" x1="11.458" x2="11.458" y1="17.708" y2="18.708" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2274_1684"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    tabs: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeWidth="1.5" clipPath="url(#clip0_2285_1298)"> <path stroke="url(#paint0_linear_2285_1298)" strokeLinecap="round" strokeLinejoin="round" d="M22.917 8.333h-6.771m0 0H9.375V4.167m6.77 4.166V4.167" ></path> <path stroke="url(#paint1_linear_2285_1298)" d="M2.083 18.452V6.548c0-1.316 1.037-2.381 2.315-2.381h16.204c1.278 0 2.315 1.065 2.315 2.38v11.905c0 1.316-1.037 2.381-2.315 2.381H4.398c-1.278 0-2.315-1.065-2.315-2.381Z" ></path> </g> <defs> <linearGradient id="paint0_linear_2285_1298" x1="16.146" x2="16.146" y1="4.167" y2="8.333" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2285_1298" x1="12.5" x2="12.5" y1="4.167" y2="20.833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2285_1298"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    taxonomy_list: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2297_1727)"> <path stroke="url(#paint0_linear_2297_1727)" strokeLinecap="round" strokeWidth="1.5" d="M9.646 6.563h7.708" ></path> <path stroke="url(#paint1_linear_2297_1727)" strokeLinecap="round" strokeWidth="1.5" d="M9.646 10.563h4.625" ></path> <path stroke="url(#paint2_linear_2297_1727)" strokeLinecap="round" strokeWidth="1.5" d="M9.646 14.563h6.166" ></path> <path stroke="url(#paint3_linear_2297_1727)" strokeLinecap="round" strokeWidth="1.5" d="M9.646 18.563h4.625" ></path> <rect width="1.542" height="1.542" x="5.792" y="5.792" fill="url(#paint4_linear_2297_1727)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="5.792" y="9.833" fill="url(#paint5_linear_2297_1727)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="5.792" y="13.875" fill="url(#paint6_linear_2297_1727)" rx="0.771" ></rect> <rect width="1.542" height="1.542" x="5.792" y="17.916" fill="url(#paint7_linear_2297_1727)" rx="0.771" ></rect> </g> <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint8_linear_2297_1727)" strokeWidth="1.5" rx="3.25" ></rect> <defs> <linearGradient id="paint0_linear_2297_1727" x1="11.38" x2="-10647700" y1="-12868300" y2="2749180" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2297_1727" x1="11.962" x2="11.573" y1="-3145610" y2="3717560" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2297_1727" x1="14.685" x2="42.892" y1="-6195900" y2="5242710" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2297_1727" x1="11.177" x2="10.92" y1="-2001740" y2="2573710" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2297_1727" x1="6.562" x2="6.562" y1="5.792" y2="7.333" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2297_1727" x1="6.562" x2="6.562" y1="9.833" y2="11.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2297_1727" x1="6.562" x2="6.562" y1="13.875" y2="15.416" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint7_linear_2297_1727" x1="6.562" x2="6.562" y1="17.916" y2="19.458" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint8_linear_2297_1727" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2297_1727"> <rect width="23" height="23" x="1" y="1" fill="#fff" rx="4"></rect> </clipPath> </defs> </svg>,

    team: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2282_1363)"> <circle cx="12.583" cy="8.333" r="3.417" stroke="url(#paint0_linear_2282_1363)" strokeLinecap="round" strokeWidth="1.5" ></circle> <path stroke="url(#paint1_linear_2282_1363)" strokeWidth="1.5" d="M16.818 8.188a2.375 2.375 0 1 1 4.114 2.374 2.375 2.375 0 0 1-4.114-2.374Z" ></path> <path stroke="url(#paint2_linear_2282_1363)" strokeWidth="1.5" d="M4.235 8.188a2.375 2.375 0 1 1 4.113 2.374 2.375 2.375 0 0 1-4.113-2.374Z" ></path> <path className="rbea-editor-icon-selected-no-fill" fill="url(#paint3_linear_2282_1363)" d="M19.332 14.583v-.75zm3.891 3.071.709-.245zM17.86 18.75l-.737.143.118.607h.619zm-1.43-2.868-.568-.49-.478.551.54.493zm2.902-1.299v.75c1.923 0 2.786 1.423 3.182 2.567l.709-.246.709-.245c-.46-1.325-1.683-3.576-4.6-3.576zm3.891 3.071-.709.246.006.022v.005q.001.002-.01.017c-.017.021-.064.056-.144.056v1.5c1.01 0 1.965-.94 1.566-2.091zm-.857 1.096V18H17.86v1.5h4.506zm-4.506 0 .736-.143c-.183-.946-.611-2.32-1.661-3.279l-.506.554-.506.554c.693.632 1.038 1.618 1.2 2.457zm-1.43-2.868.566.49c.503-.58 1.228-1.039 2.336-1.039v-1.5c-1.6 0-2.722.693-3.47 1.558z" ></path> <path className="rbea-editor-icon-selected-no-fill" fill="url(#paint4_linear_2282_1363)" d="M6.292 14.583v-.75zm2.891 1.287.486.571.578-.492-.499-.572zm-1.535 2.88v.75h.611l.124-.599zm-5.247-1.096-.709-.245zm3.89-3.071v.75c1.102 0 1.824.454 2.327 1.03l.565-.493.565-.493c-.747-.858-1.865-1.544-3.456-1.544zm2.892 1.287-.486-.571c-1.124.956-1.586 2.34-1.784 3.3l.735.151.735.151c.171-.835.54-1.824 1.286-2.46zm-1.535 2.88V18h-4.39v1.5h4.39zm-4.39 0V18c-.08 0-.127-.035-.144-.056a.04.04 0 0 1-.01-.017v-.005l.006-.022-.71-.246-.708-.245c-.398 1.151.556 2.091 1.566 2.091zm-.857-1.096.709.246c.396-1.144 1.259-2.567 3.182-2.567v-1.5c-2.917 0-4.14 2.25-4.6 3.576z" ></path> <path stroke="url(#paint5_linear_2282_1363)" strokeLinecap="round" strokeWidth="1.5" d="M12.812 14.583c3.753 0 4.802 2.706 5.095 4.217.105.542-.335.992-.887.992H8.603c-.552 0-.991-.45-.886-.992.293-1.511 1.341-4.217 5.095-4.217Z" ></path> </g> <defs> <linearGradient id="paint0_linear_2282_1363" x1="12.583" x2="12.583" y1="4.167" y2="12.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1363" x1="18.875" x2="18.875" y1="6.25" y2="12.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1363" x1="6.292" x2="6.292" y1="6.25" y2="12.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2282_1363" x1="19.849" x2="19.849" y1="14.583" y2="18.75" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2282_1363" x1="5.769" x2="5.769" y1="14.583" y2="18.75" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2282_1363" x1="12.812" x2="12.812" y1="14.583" y2="19.792" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2282_1363"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    testimonial: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" clipPath="url(#clip0_2282_1616)" > <path stroke="url(#paint0_linear_2282_1616)" d="M20.131 6.018c.702 1.051.702 2.514.702 5.44s0 4.39-.702 5.44a4.2 4.2 0 0 1-1.15 1.15c-.918.613-2.15.69-4.398.7v.002l-1.151 2.303a1.042 1.042 0 0 1-1.864 0l-1.151-2.303v-.001c-2.248-.01-3.48-.088-4.399-.701a4.2 4.2 0 0 1-1.15-1.15c-.701-1.05-.701-2.514-.701-5.44s0-4.389.702-5.44a4.2 4.2 0 0 1 1.15-1.15c1.05-.701 2.513-.701 5.44-.701h2.083c2.926 0 4.389 0 5.44.702.454.304.845.695 1.15 1.15" ></path> <path stroke="url(#paint1_linear_2282_1616)" d="M9.375 9.375h6.25"></path> <path stroke="url(#paint2_linear_2282_1616)" d="M9.375 13.542H12.5" ></path> </g> <defs> <linearGradient id="paint0_linear_2282_1616" x1="12.5" x2="12.5" y1="4.167" y2="21.629" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1616" x1="12.5" x2="12.5" y1="9.375" y2="10.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1616" x1="10.938" x2="10.938" y1="13.542" y2="14.542" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2282_1616"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    testimonial_slider: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2282_1660)"> <g strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" clipPath="url(#clip1_2282_1660)" > <path stroke="url(#paint0_linear_2282_1660)" d="M18.91 7.056c.59.882.59 2.111.59 4.569s0 3.687-.59 4.57c-.255.382-.583.71-.965.965-.772.515-1.807.58-3.695.589v.001l-.967 1.935a.875.875 0 0 1-1.566 0l-.967-1.935v-.001c-1.888-.008-2.923-.074-3.694-.589a3.5 3.5 0 0 1-.966-.965c-.59-.883-.59-2.112-.59-4.57s0-3.687.59-4.57a3.5 3.5 0 0 1 .966-.965c.882-.59 2.111-.59 4.569-.59h1.75c2.458 0 3.687 0 4.57.59.382.255.71.583.965.966" ></path> <path stroke="url(#paint1_linear_2282_1660)" d="M9.875 9.875h5.25" ></path> <path stroke="url(#paint2_linear_2282_1660)" d="M9.875 13.375H12.5" ></path> <path stroke="url(#paint3_linear_2282_1660)" d="M1.91 7.056c.59.882.59 2.111.59 4.569s0 3.687-.59 4.57c-.255.382-.583.71-.966.965-.77.515-1.806.58-3.694.589v.001l-.967 1.935a.875.875 0 0 1-1.566 0l-.967-1.935v-.001c-1.888-.008-2.923-.074-3.694-.589a3.5 3.5 0 0 1-.966-.965c-.59-.883-.59-2.112-.59-4.57s0-3.687.59-4.57c.255-.382.583-.71.966-.965.882-.59 2.111-.59 4.569-.59h1.75c2.458 0 3.687 0 4.57.59a3.5 3.5 0 0 1 .965.966" ></path> <path stroke="url(#paint4_linear_2282_1660)" d="M35.91 7.056c.59.882.59 2.111.59 4.569s0 3.687-.59 4.57c-.255.382-.583.71-.965.965-.772.515-1.807.58-3.695.589v.001l-.967 1.935a.875.875 0 0 1-1.566 0l-.967-1.935v-.001c-1.888-.008-2.923-.074-3.695-.589a3.5 3.5 0 0 1-.965-.965c-.59-.883-.59-2.112-.59-4.57s0-3.687.59-4.57c.255-.382.583-.71.965-.965.883-.59 2.112-.59 4.57-.59h1.75c2.458 0 3.687 0 4.57.59.382.255.71.583.965.966" ></path> </g> </g> <defs> <linearGradient id="paint0_linear_2282_1660" x1="12.5" x2="12.5" y1="5.5" y2="20.168" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2282_1660" x1="12.5" x2="12.5" y1="9.875" y2="10.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2282_1660" x1="11.188" x2="11.188" y1="13.375" y2="14.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2282_1660" x1="-4.5" x2="-4.5" y1="5.5" y2="20.168" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2282_1660" x1="29.5" x2="29.5" y1="5.5" y2="20.168" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2282_1660"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> <clipPath id="clip1_2282_1660"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    video_popup: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <rect width="21.5" height="21.5" x="1.75" y="1.75" stroke="url(#paint0_linear_2297_1655)" strokeWidth="1.5" rx="3.25" ></rect> <path stroke="url(#paint1_linear_2297_1655)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="1.5" d="m14.961 11.606-3.558-1.78A1.2 1.2 0 0 0 9.667 10.9v3.2a1.2 1.2 0 0 0 1.736 1.073l3.558-1.778a1 1 0 0 0 0-1.79" ></path> <circle cx="12.5" cy="12.5" r="6.375" stroke="url(#paint2_linear_2297_1655)" strokeWidth="1.5" ></circle> <defs> <linearGradient id="paint0_linear_2297_1655" x1="12.5" x2="12.5" y1="1" y2="24" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2297_1655" x1="13.208" x2="13.208" y1="8.958" y2="16.042" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2297_1655" x1="12.5" x2="12.5" y1="6.125" y2="18.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    wp_search: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeWidth="1.5" clipPath="url(#clip0_2285_1359)"> <path stroke="url(#paint0_linear_2285_1359)" strokeLinecap="round" d="m20.833 20.833-4.166-4.166" ></path> <circle cx="11.458" cy="11.458" r="7.292" stroke="url(#paint1_linear_2285_1359)" ></circle> </g> <defs> <linearGradient id="paint0_linear_2285_1359" x1="18.75" x2="18.75" y1="16.667" y2="20.833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2285_1359" x1="11.458" x2="11.458" y1="4.167" y2="18.75" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2285_1359"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    carousel_left: svgIcon("svg", { width: 20, height: 20, viewBox: "0 0 256 512" },
        svgIcon("path", { d: "M31.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L127.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L201.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34z" }),
    ),

    carousel_right: svgIcon("svg", { width: 20, height: 20, viewBox: "0 0 256 512" },
        svgIcon("path", { d: "M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z" }),
    ),

    image: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2263_1744)"> <mask id="mask0_2263_1744" width="19" height="19" x="3" y="3" maskUnits="userSpaceOnUse" style={{ maskType: "alpha" }} > <path fill="#273B4A" d="M3.125 11.125c0-3.771 0-5.657 1.172-6.828s3.057-1.172 6.828-1.172h2.75c3.771 0 5.657 0 6.828 1.172s1.172 3.057 1.172 6.828v2.75c0 3.771 0 5.657-1.172 6.828s-3.057 1.172-6.828 1.172h-2.75c-3.771 0-5.657 0-6.828-1.172s-1.172-3.057-1.172-6.828z" ></path> </mask> <g mask="url(#mask0_2263_1744)"> <path stroke="url(#paint0_linear_2263_1744)" strokeWidth="1.5" d="m5.635 13.115-.159.159c-1.074 1.074-1.61 1.61-1.911 2.28a4 4 0 0 0-.16.418c-.225.699-.185 1.457-.105 2.973l.346 6.576h18.229v-4.94c0-1.586 0-2.38-.284-3.092a4 4 0 0 0-.13-.292c-.34-.688-.93-1.218-2.108-2.28l-.224-.2c-.99-.892-1.485-1.337-2.059-1.433a2 2 0 0 0-.765.02c-.569.126-1.04.597-1.981 1.539-.7.7-1.049 1.049-1.43 1.07a1 1 0 0 1-.48-.092c-.346-.162-.543-.623-.938-1.545-.838-1.954-1.257-2.932-2.006-3.244a2 2 0 0 0-.798-.154c-.812.012-1.553.754-3.037 2.237Z" ></path> </g> <path stroke="url(#paint1_linear_2263_1744)" strokeWidth="1.5" d="M3.125 11.125c0-3.771 0-5.657 1.172-6.828s3.057-1.172 6.828-1.172h2.75c3.771 0 5.657 0 6.828 1.172s1.172 3.057 1.172 6.828v2.75c0 3.771 0 5.657-1.172 6.828s-3.057 1.172-6.828 1.172h-2.75c-3.771 0-5.657 0-6.828-1.172s-1.172-3.057-1.172-6.828z" ></path> <circle className="rbea-editor-icon-selected-no-fill" cx="17.188" cy="7.813" r="1.563" fill="url(#paint2_linear_2263_1744)" ></circle> </g> <defs> <linearGradient id="paint0_linear_2263_1744" x1="12.5" x2="12.5" y1="9.375" y2="25.521" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2263_1744" x1="12.5" x2="12.5" y1="3.125" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2263_1744" x1="17.188" x2="17.188" y1="6.25" y2="9.375" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2263_1744"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    popup: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeWidth="1.5" clipPath="url(#clip0_2290_1508)"> <path stroke="url(#paint0_linear_2290_1508)" d="M14.583 17.708c0 1.05 0 1.575-.192 1.98a2 2 0 0 1-.953.953c-.406.192-.93.192-1.98.192H8.167c-1.886 0-2.829 0-3.415-.585-.585-.586-.585-1.529-.585-3.415v-3.291c0-1.05 0-1.574.192-1.98a2 2 0 0 1 .953-.953c.406-.192.93-.192 1.98-.192" ></path> <rect width="14" height="14" stroke="url(#paint1_linear_2290_1508)" rx="2" transform="matrix(1 0 0 -1 7 18)" ></rect> </g> <defs> <linearGradient id="paint0_linear_2290_1508" x1="9.375" x2="9.375" y1="10.417" y2="20.833" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2290_1508" x1="7" x2="7" y1="14" y2="0" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2290_1508"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    template_library: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g clipPath="url(#clip0_2290_1543)"> <mask id="mask0_2290_1543" width="21" height="19" x="2" y="3" maskUnits="userSpaceOnUse" style={{ maskType: "luminance" }} > <path fill="#fff" d="M2.39 3.5H23v18H2.39z"></path> </mask> <g mask="url(#mask0_2290_1543)"> <path className="rbea-editor-icon-selected-fill" fill="url(#paint0_linear_2290_1543)" fillRule="evenodd" d="M15.989 12.208c1.767 0 3.016-.82 3.016-2.593 0-1.85-1.326-2.559-3.094-2.559h-3.126a.777.777 0 0 0-.774.776v3.589c0 .432.354.776.774.776h3.204zm-8.132.842H9.05c.575 0 .575.875 0 .875H6.222c-.575 0-.575.875 0 .875H9.05c.575 0 .575.875 0 .875H6.564c-.574 0-.574.876 0 .876h1.912c.574 0 .574.875 0 .875H7.249c-.574 0-.574.875 0 .875h.829c.618 0 .585.875.022.875H5.515c-.575 0-.575.875 0 .875H8.84c.575 0 .575.876 0 .876h-.762a.426.426 0 0 0-.409.542h3.569a.777.777 0 0 0 .773-.775v-4.177c0-.432.354-.775.774-.775h1.9c.265 0 .497.122.64.343l3.37 5.052a.74.74 0 0 0 .641.343h2.707c.63 0 .995-.698.641-1.218l-2.994-4.465a.78.78 0 0 1 .276-1.13c1.989-1.052 3.028-2.792 3.028-5.196 0-3.988-2.763-5.971-6.74-5.971H6.321c-.574 0-.574.875 0 .875h3.072c.475.044.497.864-.078.864H5.747c-.575 0-.575.876 0 .876h2.585a.44.44 0 0 1 .364.432c0 .221-.176.398-.331.42H6.929c-.575 0-.575.876 0 .876H8.74c.475.044.497.864-.078.864H8.31c-.575 0-.575.875 0 .875h1.613c.575 0 .575.875 0 .875H7.06c-.574 0-.574.875 0 .875H8.2c.575 0 .575.876 0 .876h-.353c-.564-.034-.564.842.01.842M2.874 5.24H4.52c.575 0 .575.875 0 .875H2.874c-.575-.012-.575-.876 0-.876m.088 13.903h.917c.575 0 .575.875 0 .875h-.917c-.574 0-.574-.875 0-.875" clipRule="evenodd" ></path> </g> <path fill="url(#paint1_linear_2290_1543)" fillRule="evenodd" d="M2.588 15.668h2.685c.574 0 .574.875 0 .875H2.588c-.575-.01-.575-.875 0-.875" clipRule="evenodd" ></path> <mask id="mask1_2290_1543" width="5" height="2" x="2" y="12" maskUnits="userSpaceOnUse" style={{ maskType: "luminance" }} > <path fill="#fff" d="M2 12.049h4.49v.953H2z"></path> </mask> <g mask="url(#mask1_2290_1543)"> <path fill="url(#paint2_linear_2290_1543)" fillRule="evenodd" d="M6.475 12.533a.43.43 0 0 0-.431-.432H2.43a.432.432 0 0 0 0 .864h3.602a.434.434 0 0 0 .442-.432" clipRule="evenodd" ></path> </g> <path fill="url(#paint3_linear_2290_1543)" fillRule="evenodd" d="M7.526 9.13a.43.43 0 0 0-.431-.433h-.409a.432.432 0 0 0 0 .865h.409c.232 0 .43-.189.43-.433" clipRule="evenodd" ></path> <path fill="url(#paint4_linear_2290_1543)" fillRule="evenodd" d="M5.206 14.358a.43.43 0 0 0-.43-.432h-1.05a.432.432 0 0 0 0 .864h1.05c.232 0 .43-.199.43-.432" clipRule="evenodd" ></path> <path fill="url(#paint5_linear_2290_1543)" fillRule="evenodd" d="M5.671 9.13a.43.43 0 0 0-.43-.433H4.19a.432.432 0 0 0 0 .865h1.05c.231 0 .43-.189.43-.433" clipRule="evenodd" ></path> </g> <defs> <linearGradient id="paint0_linear_2290_1543" x1="12.718" x2="12.718" y1="3.5" y2="21.48" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2290_1543" x1="3.93" x2="3.93" y1="15.668" y2="16.543" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2290_1543" x1="4.237" x2="4.237" y1="12.101" y2="12.965" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2290_1543" x1="6.89" x2="6.89" y1="8.697" y2="9.562" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2290_1543" x1="4.251" x2="4.251" y1="13.926" y2="14.79" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2290_1543" x1="4.715" x2="4.715" y1="8.697" y2="9.562" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2290_1543"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    form: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="none" viewBox="0 0 25 25" > <g strokeWidth="1.5" clipPath="url(#clip0_2370_8994)"> <rect width="14.583" height="17.708" x="5.208" y="4.167" stroke="url(#paint0_linear_2370_8994)" rx="2" ></rect> <path stroke="url(#paint1_linear_2370_8994)" strokeLinecap="round" d="M8.5 10.5h8" ></path> <path stroke="url(#paint2_linear_2370_8994)" strokeLinecap="round" d="M8.5 13.5h8" ></path> <path stroke="url(#paint3_linear_2370_8994)" strokeLinecap="round" d="M8.5 7.5h3" ></path> <path stroke="url(#paint4_linear_2370_8994)" strokeLinecap="round" d="M13.5 7.5h3" ></path> <path stroke="url(#paint5_linear_2370_8994)" strokeLinecap="round" d="M12.5 18h4.167" ></path> </g> <defs> <linearGradient id="paint0_linear_2370_8994" x1="12.5" x2="12.5" y1="4.167" y2="21.875" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2370_8994" x1="12.5" x2="12.5" y1="10.5" y2="11.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2370_8994" x1="12.5" x2="12.5" y1="13.5" y2="14.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2370_8994" x1="10" x2="10" y1="7.5" y2="8.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2370_8994" x1="15" x2="15" y1="7.5" y2="8.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2370_8994" x1="14.583" x2="14.583" y1="18" y2="19" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2370_8994"> <path fill="#fff" d="M0 0h25v25H0z"></path> </clipPath> </defs> </svg>,

    formInput: <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="24" height="24" className="o-block-icon" aria-hidden="true" focusable="false"><path fill="#FE6E5A" fillRule="evenodd" d="M19 10H5v4h14v-4ZM5 9a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1H5Z" clipRule="evenodd"></path><path fill="#FE6E5A" d="M6 12.5a.5.5 0 0 1 .5-.5h8a.5.5 0 0 1 0 1h-8a.5.5 0 0 1-.5-.5Z"></path></svg>,

    container: <svg className="rbea-editor-icons" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" > <g clipPath="url(#clip0_2270_1135)"> <rect x="4.16663" y="4.16666" width="16.6667" height="7.29167" rx="1" stroke="url(#paint0_linear_2270_1135)" strokeWidth="1.5" /> <rect x="4.16663" y="14.5833" width="6.25" height="6.25" rx="1" stroke="url(#paint1_linear_2270_1135)" strokeWidth="1.5" /> <rect x="14.5834" y="14.5833" width="6.25" height="6.25" rx="1" stroke="url(#paint2_linear_2270_1135)" strokeWidth="1.5" /> </g> <defs> <linearGradient id="paint0_linear_2270_1135" x1="12.5" y1="4.16666" x2="12.5" y2="11.4583" gradientUnits="userSpaceOnUse" > <stop offset="0" stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint1_linear_2270_1135" x1="7.29163" y1="14.5833" x2="7.29163" y2="20.8333" gradientUnits="userSpaceOnUse" > <stop offset="0" stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <linearGradient id="paint2_linear_2270_1135" x1="17.7084" y1="14.5833" x2="17.7084" y2="20.8333" gradientUnits="userSpaceOnUse" > <stop offset="0" stopColor={colorStop1} /> <stop offset="1" stopColor={colorStop2} /></linearGradient> <clipPath id="clip0_2270_1135"> <rect width="25" height="25" fill="white" /> </clipPath> </defs> </svg>,

    animations: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="35" height="25" fill="none" viewBox="0 0 35 25" > <circle cx="7.5" cy="12.5" r="6.5" stroke={colorStop1} strokeWidth="2" opacity="0.2" ></circle> <circle cx="14.5" cy="12.5" r="6.5" stroke={colorStop1} strokeWidth="2" opacity="0.4" ></circle> <circle cx="20.5" cy="12.5" r="6.5" stroke={colorStop1} strokeWidth="2" opacity="0.7" ></circle> <circle cx="27.5" cy="12.5" r="6.5" stroke={colorStop2} strokeWidth="2" opacity="0.9" ></circle> </svg>,
    
    display_conditions: <svg className="rbea-editor-icons" xmlns="http://www.w3.org/2000/svg" width="27" height="17" fill="none" viewBox="0 0 27 17" > <path fill="url(#paint0_linear_2811_2191)" stroke="url(#paint1_linear_2811_2191)" strokeLinecap="round" strokeLinejoin="round" strokeWidth="0.2" d="M.246 9.646a.5.5 0 0 1 .708 0L3.6 12.293l2.646-2.647a.5.5 0 1 1 .708.708L4.307 13l2.647 2.646a.5.5 0 0 1-.708.708L3.6 13.707.954 16.354a.5.5 0 0 1-.708-.708L2.893 13 .246 10.354a.5.5 0 0 1 0-.708" ></path> <path stroke="url(#paint2_linear_2811_2191)" strokeLinecap="round" d="M23.1 4.5v4" ></path> <path stroke="url(#paint3_linear_2811_2191)" strokeLinecap="round" d="M4.1 4.5v4" ></path> <path stroke="url(#paint4_linear_2811_2191)" strokeLinecap="round" d="M4.1 4.5h19" ></path> <path stroke="url(#paint5_linear_2811_2191)" strokeLinecap="round" d="M14.1.5v4" ></path> <path fill="url(#paint6_linear_2811_2191)" d="M26.387 10.22a.767.767 0 0 1 0 1.06l-4.364 4.5a.72.72 0 0 1-.514.22.72.72 0 0 1-.514-.22l-2.182-2.25a.767.767 0 0 1 0-1.06.71.71 0 0 1 1.029 0l1.667 1.72 3.85-3.97a.71.71 0 0 1 1.028 0" ></path> <defs> <linearGradient id="paint0_linear_2811_2191" x1="3.6" x2="3.6" y1="9.5" y2="16.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2811_2191" x1="3.6" x2="3.6" y1="9.5" y2="16.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2811_2191" x1="22.6" x2="21.6" y1="6.5" y2="6.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2811_2191" x1="3.6" x2="2.6" y1="6.5" y2="6.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2811_2191" x1="13.6" x2="13.6" y1="5" y2="6" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2811_2191" x1="13.6" x2="12.6" y1="2.5" y2="2.5" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint6_linear_2811_2191" x1="22.6" x2="22.6" y1="10" y2="16" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,

    contact_form: <svg xmlns="http://www.w3.org/2000/svg" width="38" height="40" fill="none" viewBox="0 0 38 40" > <g clipPath="url(#clip0_2939_2591)"> <rect width="23" height="34" x="8.5" y="3" stroke="url(#paint0_linear_2939_2591)" rx="3.04" ></rect> <rect width="16" height="11" x="12" y="21.5" stroke="url(#paint1_linear_2939_2591)" rx="0.5" ></rect> <rect width="16" height="4" x="12" y="7.5" stroke="url(#paint2_linear_2939_2591)" rx="0.5" ></rect> <rect width="16" height="4" x="12" y="14.5" stroke="url(#paint3_linear_2939_2591)" rx="0.5" ></rect> </g> <defs> <linearGradient id="paint0_linear_2939_2591" x1="20" x2="20" y1="3" y2="37" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2939_2591" x1="20" x2="20" y1="21" y2="33" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2939_2591" x1="20" x2="20" y1="7" y2="12" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2939_2591" x1="20" x2="20" y1="14" y2="19" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <clipPath id="clip0_2939_2591"> <path fill="#fff" d="M0 0h38v40H0z"></path> </clipPath> </defs> </svg>,

    subscribe_form: <svg xmlns="http://www.w3.org/2000/svg" width="38" height="40" fill="none" viewBox="0 0 38 40" > <rect width="22" height="33" x="9.5" y="3.5" stroke="url(#paint0_linear_2939_2617)" rx="2.5" ></rect> <rect width="8" height="3" x="20.5" y="29.5" stroke="url(#paint1_linear_2939_2617)" rx="0.5" ></rect> <rect width="16" height="3" x="12.5" y="11.5" stroke="url(#paint2_linear_2939_2617)" rx="0.5" ></rect> <rect width="16" height="3" x="12.5" y="21.5" stroke="url(#paint3_linear_2939_2617)" rx="0.5" ></rect> <path stroke="url(#paint4_linear_2939_2617)" strokeLinecap="round" d="M13 19h6" ></path> <path stroke="url(#paint5_linear_2939_2617)" strokeLinecap="round" d="M13 9h6" ></path> <defs> <linearGradient id="paint0_linear_2939_2617" x1="20.5" x2="20.5" y1="3" y2="37" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint1_linear_2939_2617" x1="24.5" x2="24.5" y1="29" y2="33" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint2_linear_2939_2617" x1="20.5" x2="20.5" y1="11" y2="15" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint3_linear_2939_2617" x1="20.5" x2="20.5" y1="21" y2="25" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint4_linear_2939_2617" x1="16" x2="16" y1="19" y2="20" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> <linearGradient id="paint5_linear_2939_2617" x1="16" x2="16" y1="9" y2="10" gradientUnits="userSpaceOnUse" > <stop stopColor={colorStop1}></stop> <stop offset="1" stopColor={colorStop2}></stop> </linearGradient> </defs> </svg>,
}


export default ResponsiveBlockEditorAddonsIcons;