<?php
/**
 * RBEA Styles.
 *
 * @package category
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Responsive_Block_Editor_Addons_Frontend_Styles' ) ) {

	/**
	 * Class Responsive_Block_Editor_Addons_Frontend_Styles.
	 */
	final class Responsive_Block_Editor_Addons_Frontend_Styles {
		
		/**
		 * Get Advanced Heading CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_advanced_heading_css( $attr, $id ) {
			$defaults = self::get_responsive_block_advanced_heading_default_attributes();

			$new_typography_spacing_keys = array(
				'subHeadingTitleTypographyColor'     => 'subHeadingTitleColor' ? 'subHeadingTitleColor' : '',
				'headingTitleTypographyColor'        => 'headingTitleColor' ? 'headingTitleColor' : '',
				'headingTitleBottomSpacing'          => 'headSpacing' ? 'headSpacing' : '',
				'headingTitleBottomSpacingTablet'    => 'headSpacingTablet' ? 'headSpacingTablet' : '',
				'headingTitleBottomSpacingMobile'    => 'headSpacingMobile' ? 'headSpacingMobile' : '',
				'subHeadingTitleBottomSpacing'       => 'subheadSpacing' ? 'subheadSpacing' : '',
				'subHeadingTitleBottomSpacingTablet' => 'subheadSpacingTablet' ? 'subheadSpacingTablet' : '',
				'subHeadingTitleBottomSpacingMobile' => 'subheadSpacingMobile' ? 'subheadSpacingMobile' : '',
				'headingTitleTextDecoration'         => 'textDecoration' ? 'textDecoration' : '',
				'subHeadingTitleTextDecoration'      => 'textDecorationSubHeading' ? 'textDecorationSubHeading' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_spacing_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$selectors        = array(
				''                                => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'text-align'     => $attr['headingAlignment'],
					'margin-top'     => 999 !== $attr['topMargin'] && 0 === $attr['blockTopMargin'] ? self::get_css_value( $attr['topMargin'], 'px' ) : self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-bottom'  => 999 !== $attr['bottomMargin'] && 0 === $attr['blockBottomMargin'] ? self::get_css_value( $attr['bottomMargin'], 'px' ) : self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => 999 !== $attr['leftMargin'] && 0 === $attr['blockLeftMargin'] ? self::get_css_value( $attr['leftMargin'], 'px' ) : self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'margin-right'   => 999 !== $attr['rightMargin'] && 0 === $attr['blockRightMargin'] ? self::get_css_value( $attr['rightMargin'], 'px' ) : self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'padding-top'    => 999 !== $attr['topPadding'] && 10 === $attr['blockTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom' => 999 !== $attr['bottomPadding'] && 10 === $attr['blockBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => 999 !== $attr['leftPadding'] && 10 === $attr['blockLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'  => 999 !== $attr['rightPadding'] && 10 === $attr['blockRightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['blockRightPadding'], 'px' ),
				),
				' .responsive-heading-title-text' => array(
					'color'           => $attr['headingTitleTypographyColor'],
					'font-family'     => $attr['headingTitleFontFamily'],
					'font-size'       => self::get_css_value( $attr['headingTitleFontSize'], 'px' ),
					'font-weight'     => $attr['headingTitleFontWeight'],
					'line-height'     => $attr['headingTitleLineHeight'],
					'letter-spacing'  => self::get_css_value( $attr['headingTitleLetterSpacing'], 'px' ),
					'margin-bottom'   => self::get_css_value( $attr['headingTitleBottomSpacing'], 'px' ),
					'text-decoration' => $attr['headingTitleTextDecoration'],
					'text-transform'  => $attr['headingTitleTextTransform'],
					'font-style'      => $attr['headingTitleFontStyle'],
				),
				' .responsive-heading-seperator'  => array(
					'border-top-style' => $attr['seperatorStyle'],
					'border-color'     => $attr['separatorColor'],
					'border-top-width' => self::get_css_value( $attr['separatorHeight'], 'px' ),
					'width'            => self::get_css_value( $attr['separatorWidth'], $attr['widthType'] ),
					'margin-bottom'    => self::get_css_value( $attr['separatorSpacing'], 'px' ),
				),
				' .responsive-heading-desc-text'  => array(
					'color'           => $attr['subHeadingTitleTypographyColor'],
					'font-family'     => $attr['subHeadingTitleFontFamily'],
					'font-size'       => self::get_css_value( $attr['subHeadingTitleFontSize'], 'px' ),
					'font-weight'     => $attr['subHeadingTitleFontWeight'],
					'line-height'     => $attr['subHeadingTitleLineHeight'],
					'letter-spacing'  => self::get_css_value( $attr['subHeadingTitleLetterSpacing'], 'px' ),
					'margin-bottom'   => self::get_css_value( $attr['subHeadingTitleBottomSpacing'], 'px' ),
					'text-decoration' => $attr['subHeadingTitleTextDecoration'],
					'text-transform'  => $attr['subHeadingTitleTextTransform'],
					'font-style'      => $attr['subHeadingTitleFontStyle'],
				),
			);
			$mobile_selectors = array(
				''                                => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'text-align'     => $attr['headingAlignmentMobile'],
					'margin-top'     => 999 !== $attr['topMarginMobile'] && '' === $attr['blockTopMarginMobile'] ? self::get_css_value( $attr['topMarginMobile'], 'px' ) : self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-bottom'  => 999 !== $attr['bottomMarginMobile'] && '' === $attr['blockBottomMarginMobile'] ? self::get_css_value( $attr['bottomMarginMobile'], 'px' ) : self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => 999 !== $attr['leftMarginMobile'] && '' === $attr['blockLeftMarginMobile'] ? self::get_css_value( $attr['leftMarginMobile'], 'px' ) : self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'margin-right'   => 999 !== $attr['rightMarginMobile'] && '' === $attr['blockRightMarginMobile'] ? self::get_css_value( $attr['rightMarginMobile'], 'px' ) : self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'padding-top'    => 999 !== $attr['topPaddingMobile'] && 10 === $attr['blockTopPaddingMobile'] ? self::get_css_value( $attr['topPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => 999 !== $attr['bottomPaddingMobile'] && 10 === $attr['blockBottomPaddingMobile'] ? self::get_css_value( $attr['bottomPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => 999 !== $attr['leftPaddingMobile'] && 10 === $attr['blockLeftPaddingMobile'] ? self::get_css_value( $attr['leftPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => 999 !== $attr['rightPaddingMobile'] && 10 === $attr['blockRightPaddingMobile'] ? self::get_css_value( $attr['rightPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
				),
				' .responsive-heading-title-text' => array(
					'font-size'     => self::get_css_value( $attr['headingTitleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['headingTitleBottomSpacingMobile'], 'px' ),
				),
				' .responsive-heading-seperator'  => array(
					'margin-bottom' => self::get_css_value( $attr['separatorSpacingMobile'], 'px' ),
				),
				' .responsive-heading-desc-text'  => array(
					'font-size'     => self::get_css_value( $attr['subHeadingTitleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['subHeadingTitleBottomSpacingMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				''                                => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'text-align'     => $attr['headingAlignmentTablet'],
					'margin-top'     => 999 !== $attr['topMarginTablet'] && '' === $attr['blockTopMarginTablet'] ? self::get_css_value( $attr['topMarginTablet'], 'px' ) : self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-bottom'  => 999 !== $attr['bottomMarginTablet'] && '' === $attr['blockBottomMarginTablet'] ? self::get_css_value( $attr['bottomMarginTablet'], 'px' ) : self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => 999 !== $attr['leftMarginTablet'] && '' === $attr['blockLeftMarginTablet'] ? self::get_css_value( $attr['leftMarginTablet'], 'px' ) : self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'margin-right'   => 999 !== $attr['rightMarginTablet'] && '' === $attr['blockRightMarginTablet'] ? self::get_css_value( $attr['rightMarginTablet'], 'px' ) : self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'padding-top'    => 999 !== $attr['topPaddingTablet'] && 10 === $attr['blockTopPaddingTablet'] ? self::get_css_value( $attr['topPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => 999 !== $attr['bottomPaddingTablet'] && 10 === $attr['blockBottomPaddingTablet'] ? self::get_css_value( $attr['bottomPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => 999 !== $attr['leftPaddingTablet'] && 10 === $attr['blockLeftPaddingTablet'] ? self::get_css_value( $attr['leftPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => 999 !== $attr['rightPaddingTablet'] && 10 === $attr['blockRightPaddingTablet'] ? self::get_css_value( $attr['rightPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
				),
				' .responsive-heading-title-text' => array(
					'font-size'     => self::get_css_value( $attr['headingTitleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['headingTitleBottomSpacingTablet'], 'px' ),
				),
				' .responsive-heading-seperator'  => array(
					'margin-bottom' => self::get_css_value( $attr['separatorSpacingTablet'], 'px' ),
				),
				' .responsive-heading-desc-text'  => array(
					'font-size'     => self::get_css_value( $attr['subHeadingTitleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['subHeadingTitleBottomSpacingTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-advanced-heading.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}


		/**
		 * Get Advanced Columns CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_advanced_columns_css( $attr, $id ) {
			$defaults = self::get_responsive_block_advanced_columns_default_attributes();

			$new_spacing_attribute_keys = array(
				'boxTopMargin'            => 'topMargin',
				'boxBottomMargin'         => 'bottomMargin',
				'boxTopMarginTablet'      => 'topMarginTablet',
				'boxBottomMarginTablet'   => 'bottomMarginTablet',
				'boxTopMarginMobile'      => 'topMarginMobile',
				'boxBottomMarginMobile'   => 'bottomMarginMobile',
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity          = $attr['opacity'] / 100;
			$column_height_style = '';
			if ( 'half' === $attr['height'] ) {
				$column_height_style = '50vh !important';
			}
			if ( 'full' === $attr['height'] ) {
				$column_height_style = '100vh !important';
			}
			if ( 'custom' === $attr['height'] ) {
				$column_height_style = $attr['customHeight'] . 'px !important';
			}

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$max_width = '100%';

			if ( 'custom' === $attr['contentWidth'] ) {
				if ( '' !== $attr['width'] ) {
					$max_width = self::get_css_value( $attr['width'], $attr['widthType'] );
				}
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}


			$background_type_image_styles = array();
			if ( 'image' === $attr['backgroundType'] && $attr['backgroundImage'] ) {
				$background_type_image_styles = array(
					'background-image'      => 'linear-gradient(' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . ',' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . '),url(' . $attr['backgroundImage'] . ')',
					'background-position'   => $background_position_focal,
					'background-attachment' => $attr['backgroundAttachment'],
					'background-repeat'     => $attr['backgroundRepeat'],
					'background-size'       => $attr['backgroundSize'],
				);
			}

			$background_type_image_styles_mobile = array();
			if ( 'image' === $attr['backgroundType'] && $attr['backgroundImage'] ) {
				$background_type_image_styles_mobile = array(
					'background-position' => $background_position_focal_tablet,
					'background-size'     => $attr['backgroundSizeMobile'],
				);
			}

			$background_type_image_styles_tablet = array();
			if ( 'image' === $attr['backgroundType'] && $attr['backgroundImage'] ) {
				$background_type_image_styles_tablet = array(
					'background-position' => $background_position_focal_mobile,
					'background-size'     => $attr['backgroundSizeTablet'],
				);
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$selectors = array(
				''                                => array(
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
				),
				' .responsive-columns-wrap'       => array(
					'text-align'                 => $attr['blockAlign'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-color'               => $attr['blockBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ) . '!important',
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'background-color'           => 'color' === $attr['backgroundType'] ? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ) : '',
					'background-image'           => 'gradient' === $attr['backgroundType'] ? self::generate_background_image_effect(
						self::hex_to_rgb( $attr['backgroundColor1'], $imgopacity ),
						self::hex_to_rgb( $attr['backgroundColor2'], $imgopacity ),
						$attr['gradientDirection'],
						$attr['colorLocation1'],
						$attr['colorLocation2']
					) : '',
					'box-shadow'                 => self::get_css_value( $attr['boxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowSpread'], 'px' ) . ' ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
				),
				' .responsive-columns-wrap:hover'       => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) . ' ' . $attr['hoverboxShadowColor'] . ' ' . $hover_box_shadow_position_css : '',
				),
				' .responsive-columns-inner-wrap' => array(
					'max-width' => $max_width,
				),
				'.background-type-image'          => $background_type_image_styles,
				' .responsive-block-editor-addons-block-columns.overlay-type-color' => array(
					'background-color' => 'image' === $attr['backgroundType'] ? self::hex_to_rgb( $attr['backgroundImageColor'], $imgopacity ) : '',
				),
				' .responsive-block-editor-addons-block-columns.overlay-type-gradient.linear' => array(
					'background-image' => self::generate_background_image_effect(
						self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ),
						self::hex_to_rgb( $attr['gradientOverlayColor2'], $imgopacity ),
						$attr['gradientOverlayAngle'],
						$attr['gradientOverlayLocation1'],
						$attr['gradientOverlayLocation2']
					),
				),
				' .responsive-block-editor-addons-block-columns.overlay-type-gradient.radial' => array(
					'background-image' => 'radial-gradient( at ' . $attr['gradientOverlayPosition'] . ',' . self::hex_to_rgb( $attr['gradientOverlayColor1'] ? $attr['gradientOverlayColor1'] : '#fff', $imgopacity ) .
						' ' . $attr['gradientOverlayLocation1'] . '%,' . self::hex_to_rgb( $attr['gradientOverlayColor2'] ? $attr['gradientOverlayColor2'] : '#fff', $imgopacity ) .
						' ' . $attr['gradientOverlayLocation2'] . '%)',
				),
				'> .responsive-block-editor-addons-block-column' => array(
					'min-height'  => $column_height_style,
					'align-items' => $attr['verticalAlign'],
				),
				' .responsive-block-editor-addons-block-columns' => array(
					'padding-top'    => self::get_css_value( $attr['boxTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['boxBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['boxLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['boxRightPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['boxTopMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['boxBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['boxLeftMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['boxRightMargin'], 'px' ),
				),

				' .responsive-columns__gap-narrow .responsive-columns-inner-wrap' => array(
					'gap' => '5px',
				),

				' .responsive-columns__gap-medium .responsive-columns-inner-wrap' => array(
					'gap' => '10px',
				),

				' .responsive-columns__gap-extended .responsive-columns-inner-wrap' => array(
					'gap' => '15px',
				),

				' .responsive-columns__gap-wide .responsive-columns-inner-wrap' => array(
					'gap' => '20px',
				),

				' .responsive-columns__gap-wider .responsive-columns-inner-wrap' => array(
					'gap' => '30px',
				),
			);
			$mobile_selectors = array(
				''                          => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
				),
				' .responsive-block-editor-addons-block-columns' => array(
					'padding-top'    => self::get_css_value( $attr['boxTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['boxBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['boxLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['boxRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['boxTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['boxBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['boxLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['boxRightMarginMobile'], 'px' ),
				),
				' .responsive-columns-wrap' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ) . '!important',
				),
				'.background-type-image'    => $background_type_image_styles_mobile,
			);

			$tablet_selectors = array(
				''                          => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
				),
				' .responsive-block-editor-addons-block-columns' => array(
					'padding-top'    => self::get_css_value( $attr['boxTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['boxBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['boxLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['boxRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['boxTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['boxBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['boxLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['boxRightMarginTablet'], 'px' ),
				),
				' .responsive-columns-wrap' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ) . '!important',
				),
				'.background-type-image'    => $background_type_image_styles_tablet,
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);
			$id                 = '.responsive-block-editor-addons-advanced-column-outer-wrap.block-' . $id;
			$css                = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Post Carousel CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_post_carousel_css( $attr, $id ) {
			$defaults = self::get_responsive_block_post_carousel_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			// Frontend Backward Compatibility For Border Radius.
			$new_border_radius_keys = array(
				'arrowTopRadius'          => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadius'        => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadius'       => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadius'         => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowTopRadiusTablet'    => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadiusTablet'  => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadiusTablet' => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadiusTablet'   => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowTopRadiusMobile'    => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadiusMobile'  => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadiusMobile' => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadiusMobile'   => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For TypographySettings For Post Carousel.
			$new_typography_settings_keys = array(
				'excerptTypographyColor' => 'contentColor' ? 'contentColor' : '',
				'titleTypographyColor'   => 'titleColor' ? 'titleColor' : '',
				'metaTypographyColor'    => 'metaColor' ? 'metaColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$inner_height               = $attr['displayPostImage'] ? '' : '100% !important';
			$slick_button_styles        = array(
				'border-color'               => $attr['arrowDotsColor'],
				'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadius'], 'px' ),
				'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadius'], 'px' ),
				'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadius'], 'px' ),
				'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadius'], 'px' ),
				'border-width'               => self::get_css_value( $attr['arrowBorderSize'], 'px' ),
			);
			$slick_button_styles_mobile = array(
				'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadiusMobile'], 'px' ),
				'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadiusMobile'], 'px' ),
				'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadiusMobile'], 'px' ),
				'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadiusMobile'], 'px' ),
			);
			$slick_button_styles_tablet = array(
				'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadiusTablet'], 'px' ),
				'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadiusTablet'], 'px' ),
				'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadiusTablet'], 'px' ),
				'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadiusTablet'], 'px' ),
			);
			$imgopacity                 = $attr['opacity'] / 100;

			$pc_background_image_gradient = '';
			$pc_color                     = '';
			if ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$pc_background_image_gradient = 'linear-gradient(' . $attr['buttongradientDirection'] . 'deg, ' . $attr['buttonbackgroundColor1'] . ' ' . $attr['buttoncolorLocation1'] . '%, ' . $attr['buttonbackgroundColor2'] . ' ' . $attr['buttoncolorLocation2'] . '%)';
			} elseif ( 'color' === $attr['buttonbackgroundType'] ) {
				$pc_background_image_gradient = '';
				$pc_color                     = $attr['ctaBackColor'];
			}

			$updated_buttonh_color = '';
			if ( 'color' === $attr['buttonHbackgroundType'] ) {
				$updated_buttonh_color = $attr['ctaHoverBackColor'] ? $attr['ctaHoverBackColor'] : 'none';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                               => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
				),
				' .responsive-post-slick-carousel-' . $id . ' .slick-prev.slick-arrow' => $slick_button_styles,
				' .responsive-post-slick-carousel-' . $id . ' .slick-next.slick-arrow' => $slick_button_styles,
				' .responsive-post-slick-carousel-' . $id . ' .slick-slide>div:first-child' => array(
					'margin-left'  => self::get_css_value( ( $attr['columnGap'] / 2 ), 'px' ),
					'margin-right' => self::get_css_value( ( $attr['columnGap'] / 2 ), 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleSpace'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['imageSpace'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-title a' => array(
					'font-family'   => $attr['titleFontFamily'],
					'text-transform'  => $attr['titleTextTransform'],
					'font-style'      => $attr['titleFontStyle'],
					'color' => $attr['titleTypographyColor'],
					'font-weight'   => $attr['titleFontWeight'],
					'line-height'   => $attr['titleLineHeight'],
				),
				' .responsive-block-editor-addons-block-post-carousel-byline' => array(
					'color'         => $attr['metaTypographyColor'],
					'text-transform'  => $attr['metaTextTransform'],
					'font-style'      => $attr['metaFontStyle'],
					'font-family'   => $attr['metaFontFamily'],
					'font-size'     => self::get_css_value( $attr['metaFontSize'], 'px' ),
					'font-weight'   => $attr['metaFontWeight'],
					'line-height'   => $attr['metaLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['dateSpace'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-excerpt' => array(
					'text-align'  => $attr['blockAlign'],
					'color'       => $attr['excerptTypographyColor'],
					'text-transform'  => $attr['excerptTextTransform'],
					'font-style'      => $attr['excerptFontStyle'],
					'font-family' => $attr['excerptFontFamily'],
					'font-size'   => self::get_css_value( $attr['excerptFontSize'], 'px' ),
					'font-weight' => $attr['excerptFontWeight'],
					'line-height' => $attr['excerptLineHeight'],
				),
				' .responsive-block-editor-addons-block-post-carousel-excerpt p:first-child' => array(
					'margin-bottom' => self::get_css_value( $attr['excerptSpace'], 'px' ),

				),
				' .responsive-block-editor-addons-block-post-carousel-date' => array(
					'color' => $attr['metaTypographyColor'],
				),
				' .responsive-block-editor-addons-block-post-carousel-author a' => array(
					'color' => $attr['metaTypographyColor'],
				),
				' .responsive-block-editor-addons-block-post-carousel-taxonomy a' => array(
					'color' => $attr['metaTypographyColor'],
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link-wrapper' => array(
					'font-family'   => $attr['ctaFontFamily'],
					'text-transform'  => $attr['ctaTextTransform'],
					'font-style'      => $attr['ctaFontStyle'],
					'font-size'     => self::get_css_value( $attr['ctaFontSize'], 'px' ),
					'font-weight'   => $attr['ctaFontWeight'],
					'line-height'   => $attr['ctaLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['ctaSpace'], 'px' ) . ' !important',
					'margin-top'    => '0px',
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link.responsive-block-editor-addons-text-link' => array(
					'color'            => $attr['ctaColor'],
					'text-transform'  => $attr['ctaTextTransform'],
					'font-style'      => $attr['ctaFontStyle'],
					'background-color' => $pc_color,
					'background-image' => $pc_background_image_gradient,
					'border-color'     => $attr['ctaBorderColor'],
					'border-style'     => $attr['ctaBorderStyle'],
					'border-radius'    => self::get_css_value( $attr['ctaBorderRadius'], 'px' ),
					'border-width'     => self::get_css_value( $attr['ctaBorderWidth'], 'px' ),
					'padding-left'     => self::get_css_value( $attr['ctaHpadding'], 'px' ),
					'padding-right'    => self::get_css_value( $attr['ctaHpadding'], 'px' ),
					'padding-top'      => self::get_css_value( $attr['ctaVpadding'], 'px' ),
					'padding-bottom'   => self::get_css_value( $attr['ctaVpadding'], 'px' ),
					'display'          => 'inline-block',
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link:hover' => array(
					'color'            => $attr['ctaHoverColor'],
					'background-color' => $updated_buttonh_color,
					'border-color'     => $attr['ctaHoverBorderColor'],
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $pc_background_image_gradient,
				),
				' .slick-slide'                   => array(
					'margin-bottom' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-text-wrap' => array(
					'text-align' => $attr['blockAlign'],
					'padding'    => self::get_css_value( $attr['contentPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-header' => array(
					'text-align' => $attr['blockAlign'],
				),
				' .responsive-block-editor-addons-post-carousel-inner' => array(
					'background-color' => $attr['bgColor'],
					'height'           => $inner_height,
				),
				' .responsive-block-editor-addons-block-post-carousel-image-background img' => array(
					'opacity' => $imgopacity,
				),
				' ul.slick-dots li button:before' => array(
					'color' => $attr['arrowDotsColor'],
				),
				' ul.slick-dots li.slick-active button:before' => array(
					'color' => $attr['arrowDotsColor'],
				),

			);
			$mobile_selectors = array(
				' ' => array(
					'z-index'        => $attr['z_indexMobile'],
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
				),
				' .responsive-post-slick-carousel-' . $id . ' .slick-prev.slick-arrow' => $slick_button_styles_mobile,
				' .responsive-post-slick-carousel-' . $id . ' .slick-next.slick-arrow' => $slick_button_styles_mobile,
				' .responsive-block-editor-addons-block-post-carousel-text-wrap' => array(
					'padding' => self::get_css_value( $attr['contentPaddingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-byline' => array(
					'font-size' => self::get_css_value( $attr['metaFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-excerpt' => array(
					'font-size' => self::get_css_value( $attr['excerptFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link-wrapper' => array(
					'font-size' => self::get_css_value( $attr['ctaFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link.responsive-block-editor-addons-text-link' => array(
					'padding-left'   => self::get_css_value( $attr['ctaHpaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['ctaHpaddingMobile'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['ctaVpaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['ctaVpaddingMobile'], 'px' ),
				),
				' .responsive-post-slick-carousel-' . $id . ' .slick-slide>div:first-child' => array(
					'margin-left'  => self::get_css_value( ( $attr['columnGapMobile'] / 2 ), 'px' ),
					'margin-right' => self::get_css_value( ( $attr['columnGapMobile'] / 2 ), 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
				),
				' .responsive-post-slick-carousel-' . $id . ' .slick-prev.slick-arrow' => $slick_button_styles_tablet,
				' .responsive-post-slick-carousel-' . $id . ' .slick-next.slick-arrow' => $slick_button_styles_tablet,
				' .responsive-block-editor-addons-block-post-carousel-text-wrap' => array(
					'padding' => self::get_css_value( $attr['contentPaddingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-byline' => array(
					'font-size' => self::get_css_value( $attr['metaFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-excerpt' => array(
					'font-size' => self::get_css_value( $attr['excerptFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link-wrapper' => array(
					'font-size' => self::get_css_value( $attr['ctaFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-carousel-more-link.responsive-block-editor-addons-text-link' => array(
					'padding-left'   => self::get_css_value( $attr['ctaHpaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['ctaHpaddingTablet'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['ctaVpaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['ctaVpaddingTablet'], 'px' ),
				),
				' .responsive-post-slick-carousel-' . $id . ' .slick-slide>div:first-child' => array(
					'margin-left'  => self::get_css_value( ( $attr['columnGapTablet'] / 2 ), 'px' ),
					'margin-right' => self::get_css_value( ( $attr['columnGapTablet'] / 2 ), 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);
			$id                 = '.responsive-block-editor-addons-block-post-carousel.block-' . $id;
			$css                = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Post Grid CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_post_grid_css( $attr, $id ) {
			$defaults = self::get_responsive_block_post_grid_block_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'               => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'             => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'            => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'              => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet'      => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile'      => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'imageTopRadius'               => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageRightRadius'             => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageBottomRadius'            => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageLeftRadius'              => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageTopRadiusTablet'         => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageRightRadiusTablet'       => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageBottomRadiusTablet'      => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageLeftRadiusTablet'        => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageTopRadiusMobile'         => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageRightRadiusMobile'       => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageBottomRadiusMobile'      => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'imageLeftRadiusMobile'        => 'imageBorderRadius' ? 'imageBorderRadius' : 0,
				'paginationTopRadius'          => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationRightRadius'        => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationBottomRadius'       => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationLeftRadius'         => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationTopRadiusTablet'    => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationRightRadiusTablet'  => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationBottomRadiusTablet' => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationLeftRadiusTablet'   => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationTopRadiusMobile'    => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationRightRadiusMobile'  => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationBottomRadiusMobile' => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
				'paginationLeftRadiusMobile'   => 'paginationBorderRadius' ? 'paginationBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'metaTypographyColor'    => 'metaColor' ? 'metaColor' : '',
				'excerptTypographyColor' => 'textColor' ? 'textColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$box_shadow_position_css = $attr['boxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			$hoverbox_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hoverbox_shadow_position_css = '';
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$display_link = 'none';
			if ( $attr['displayPostLink'] ) {
				$display_link = 'block';
			}

			$link_styles = array();
			$link_styles = array(
				'display'        => $display_link,
				'color'          => $attr['readMoreLinkColor'],
				'font-size'      => self::get_css_value( $attr['continueFontSize'], 'px' ),
				'font-weight'    => $attr['continueFontWeight'],
				'line-height'    => $attr['continueLineHeight'],
				'text-transform' => $attr['continueTextTransform'],
				'font-style'     => $attr['continueFontStyle'],
				'font-family'    => $attr['continueFontFamily'],
			);

			$boxed_content_padding = 0;
			$content_padding       = 0;
			if ( 'content' === $attr['layout'] ) {
				$content_padding       = $attr['contentPadding'];
				$boxed_content_padding = 0;
			}
			if ( 'boxed' === $attr['layout'] ) {
				$boxed_content_padding = $attr['contentPadding'];
			}

			$column_gap = '';
			if ( $attr['columnGap'] ) {
				$column_gap = $attr['columnGap'];
			}
			$column_gap_tablet = '';
			if ( $attr['columnGapTablet'] ) {
				$column_gap_tablet = $attr['columnGapTablet'];
			}
			$column_gap_mobile = '';
			if ( $attr['columnGapMobile'] ) {
				$column_gap_mobile = $attr['columnGapMobile'];
			}
			$row_gap = '';
			if ( $attr['rowGap'] ) {
				$row_gap = $attr['rowGap'];
			}
			$row_gap_tablet = '';
			if ( $attr['columnGapTablet'] ) {
				$row_gap_tablet = $attr['rowGapTablet'];
			}
			$row_gap_mobile = '';
			if ( $attr['rowGapMobile'] ) {
				$row_gap_mobile = $attr['rowGapMobile'];
			}
			$equal_height = 'fit-content';
			if ( $attr['equalHeight'] ) {
				$equal_height = 'auto';
			}
			$pagination_background        = 'transparent';
			$pagination_background_active = 'transparent';
			if ( 'filled' === $attr['paginationLayout'] ) {
				$pagination_background        = $attr['paginationBorderColor'];
				$pagination_background_active = $attr['paginationActiveBorderColor'];
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                            => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-post-grid-items' => array(
					'grid-column-gap' => self::get_css_value( $column_gap, 'px' ),
					'grid-row-gap'    => self::get_css_value( $row_gap, 'px' ),
				),
				' article'                     => array(
					'background-color'           => $attr['bgColor'] . ' !important',
					'border-style'               => $attr['blockBorderStyle'],
					'border-color'               => $attr['blockBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'height'                     => $equal_height,
					'box-shadow'                 => self::get_css_value( $attr['boxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowSpread'], 'px' ) . ' ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
					'padding'                    => self::get_css_value( $boxed_content_padding, 'px' ),

				),
				' article:hover'               => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) . ' ' . $attr['hoverboxShadowColor'] . ' ' . $hoverbox_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-post-grid-items article' => array(
					'padding' => self::get_css_value( $boxed_content_padding, 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-text' => array(
					'padding'    => self::get_css_value( $content_padding, 'px' ),
					'text-align' => $attr['textAlignment'],
					'display'    => 'block',
				),
				' header .responsive-block-editor-addons-block-post-grid-title' => array(
					'font-family'    => $attr['titleFontFamily'],
					'font-size'      => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-weight'    => $attr['titleFontWeight'],
					'line-height'    => $attr['titleLineHeight'],
					'text-transform' => $attr['titleTextTransform'],
					'font-style'     => $attr['titleFontStyle'],
					'margin-bottom'  => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
				),
				' header .responsive-block-editor-addons-block-post-grid-title a' => array(
					'color' => $attr['titleColor'],
				),
				' header .responsive-block-editor-addons-block-post-grid-title a:hover' => array(
					'color' => $attr['titleHoverColor'],
				),
				' .responsive-block-editor-addons-block-post-grid-byline' => array(
					'color'          => $attr['metaTypographyColor'],
					'font-family'    => $attr['metaFontFamily'],
					'font-size'      => self::get_css_value( $attr['metaFontSize'], 'px' ),
					'font-weight'    => $attr['metaFontWeight'],
					'line-height'    => $attr['metaLineHeight'],
					'text-transform' => $attr['metaTextTransform'],
					'font-style'     => $attr['metaFontStyle'],
					'margin-bottom'  => self::get_css_value( $attr['metaBottomSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-text .responsive-block-editor-addons-block-post-grid-excerpt' => array(
					'color'          => $attr['excerptTypographyColor'],
					'font-family'    => $attr['excerptFontFamily'],
					'font-size'      => self::get_css_value( $attr['excerptFontSize'], 'px' ),
					'font-weight'    => $attr['excerptFontWeight'],
					'line-height'    => $attr['excerptLineHeight'],
					'text-transform' => $attr['excerptTextTransform'],
					'font-style'     => $attr['excerptFontStyle'],
					'margin-bottom'  => self::get_css_value( $attr['excerptBottomSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-more-link' => $link_styles,
				' .responsive-block-editor-addons-block-post-grid-more-link:hover' => array(
					'color'           => $attr['readMoreHoverColor'],
					'text-decoration' => 'none',
				),
				' .read-more a'                => $link_styles,
				' .responsive-block-editor-addons-post-grid-item' => array(
					'margin-bottom' => 0,
				),
				' .is-list .responsive-block-editor-addons-post-grid-item:not(:last-child)' => array(
					'margin-bottom' => self::get_css_value( $row_gap, 'px' ),
				),
				' .is-list article:last-child' => array(
					'margin-bottom' => 0,
				),
				' .responsive-block-editor-addons-block-post-grid-image' => array(
					'width' => 'fit-content',
				),
				' .responsive-block-editor-addons-block-post-grid-image img' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['imageTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['imageRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['imageBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['imageLeftRadius'], 'px' ),
					'object-fit'                 => 'cover',
					'height'                     => '100%',
					'margin-bottom'              => self::get_css_value( $attr['imageBottomSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-image a' => array(
					'display' => 'block',
					'width'   => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageWidth'], 'px' ) : null,
					'height'  => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageHeight'], 'px' ) : null,
				),
				' .responsive-block-editor-addons-post-pagination-wrap > *' => array(
					'border-width'               => self::get_css_value( $attr['paginationBorderWidth'], 'px' ),
					'border-color'               => $attr['paginationBorderColor'],
					'border-style'               => ' solid ',
					'background-color'           => $pagination_background,
					'border-top-left-radius'     => self::get_css_value( $attr['paginationTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['paginationRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['paginationBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['paginationLeftRadius'], 'px' ),
					'color'                      => $attr['paginationTextColor'] . ' !important',
					'margin-right'               => '10px',
					'padding'                    => '0.5em',
				),
				' .responsive-block-editor-addons-post-pagination-wrap > *:last-child' => array(
					'margin-right' => '0',
				),
				' .responsive-block-editor-addons-post-pagination-wrap > span' => array(
					'border-width'     => self::get_css_value( $attr['paginationBorderWidth'], 'px' ),
					'border-color'     => $attr['paginationActiveBorderColor'],
					'border-style'     => ' solid ',
					'background-color' => $pagination_background_active,
					'color'            => $attr['paginationTextActiveColor'] . ' !important',
				),
				' .responsive-block-editor-addons-post-pagination-wrap' => array(
					'text-align' => $attr['paginationAlignment'],
					'margin-top' => self::get_css_value( $attr['paginationSpacing'], 'px' ),
				),

			);

			$grid_template_columns = '1fr 1fr';
			if ( $attr['stackonMobile'] ) {
				$grid_template_columns = '1fr';
			}
			$mobile_content_padding = '0';
			if ( 'boxed' === $attr['layout'] && $attr['contentPaddingMobile'] || $attr['mobileContentPadding'] ) { // For compatibility with v1.3.2.
				$mobile_content_padding = ( 999 !== $attr['mobileContentPadding'] && 10 === $attr['contentPaddingMobile'] ) ? $attr['mobileContentPadding'] : $attr['contentPaddingMobile']; // For compatibility with v1.3.2.
			}
			$tablet_content_padding = '0';
			if ( 'boxed' === $attr['layout'] && $attr['contentPaddingTablet'] ) {
				$tablet_content_padding = $attr['contentPaddingTablet'];
			}
			$mobile_selectors = array(
				' '                 => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-image img' => array(
					'margin-bottom'              => self::get_css_value( $attr['imageBottomSpacingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['imageTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['imageRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['imageBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['imageLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-post-pagination-wrap > *' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['paginationTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['paginationRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['paginationBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['paginationLeftRadiusMobile'], 'px' ),
				),
				' header .responsive-block-editor-addons-block-post-grid-title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-post-grid-items article' => array(
					'padding'    => self::get_css_value( $mobile_content_padding, 'px' ) . ' !important',
					'text-align' => $attr['textAlignment'],
				),
				' .is-list article' => array(
					'grid-template-columns' => $grid_template_columns,
				),
				' .responsive-block-editor-addons-post-grid-items' => array(
					'grid-column-gap' => self::get_css_value( $column_gap_mobile, 'px' ),
					'grid-row-gap'    => self::get_css_value( $row_gap_mobile, 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-text .responsive-block-editor-addons-block-post-grid-excerpt' => array(
					'margin-bottom' => self::get_css_value( $attr['excerptBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['excerptFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-byline' => array(
					'font-size'     => self::get_css_value( $attr['metaFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['metaBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-more-link' => array(
					'font-size' => self::get_css_value( $attr['continueFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-image a' => array(
					'width'  => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageWidthMobile'], 'px' ) : null,
					'height' => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageHeightMobile'], 'px' ) : null,
				),
				' article'          => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '        => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-image img' => array(
					'margin-bottom'              => self::get_css_value( $attr['imageBottomSpacingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['imageTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['imageRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['imageBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['imageLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-post-pagination-wrap > *' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['paginationTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['paginationRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['paginationBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['paginationLeftRadiusTablet'], 'px' ),
				),
				' header .responsive-block-editor-addons-block-post-grid-title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-post-grid-items' => array(
					'grid-column-gap' => self::get_css_value( $column_gap_tablet, 'px' ),
					'grid-row-gap'    => self::get_css_value( $row_gap_tablet, 'px' ),
				),
				' .responsive-block-editor-addons-post-grid-items article' => array(
					'padding' => self::get_css_value( $tablet_content_padding, 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-block-post-grid-text .responsive-block-editor-addons-block-post-grid-excerpt' => array(
					'margin-bottom' => self::get_css_value( $attr['excerptBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['excerptFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-byline' => array(
					'font-size'     => self::get_css_value( $attr['metaFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['metaBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-more-link' => array(
					'font-size' => self::get_css_value( $attr['continueFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-grid-image a' => array(
					'width'  => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageWidthTablet'], 'px' ) : null,
					'height' => 'list' === $attr['postLayout'] ? self::get_css_value( $attr['imageHeightTablet'], 'px' ) : null,
				),
				' article' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id              = '.responsive-block-editor-addons-block-post-grid.block-id-' . $id;
			$css             = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			$css['desktop'] .= '.page-template-gutenberg-fullwidth ' . $id . ' .responsive-block-editor-addons-post-grid-items article {padding:' . ( 'boxed' === $attr['layout'] ? $attr['contentPadding'] ? $attr['contentPadding'] : '0' : '0' ) . 'px;}
    ';
			return $css;
		}

		/**
		 * Get Count Up CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_count_up_css( $attr, $id ) {
			$defaults = self::get_responsive_block_count_up_default_attributes();

			$new_spacing_attribute_keys = array(
				'blockTopPadding'               => 'contentSpacing',
				'blockRightPadding'             => 'contentSpacing',
				'blockBottomPadding'            => 'contentSpacing',
				'blockLeftPadding'              => 'contentSpacing',
				'blockTopPaddingTablet'         => 'contentSpacingTablet',
				'blockRightPaddingTablet'       => 'contentSpacingTablet',
				'blockBottomPaddingTablet'      => 'contentSpacingTablet',
				'blockLeftPaddingTablet'        => 'contentSpacingTablet',
				'blockTopPaddingMobile'         => 'contentSpacingMobile',
				'blockRightPaddingMobile'       => 'contentSpacingMobile',
				'blockBottomPaddingMobile'      => 'contentSpacingMobile',
				'blockLeftPaddingMobile'        => 'contentSpacingMobile',
				'shapeBorderTopRadius'          => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderRightRadius'        => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderBottomRadius'       => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderLeftRadius'         => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderTopRadiusTablet'    => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderRightRadiusTablet'  => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderBottomRadiusTablet' => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderLeftRadiusTablet'   => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderTopRadiusMobile'    => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderRightRadiusMobile'  => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderBottomRadiusMobile' => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'shapeBorderLeftRadiusMobile'   => 'shapeBorderRadius' ? 'shapeBorderRadius' : 100,
				'blockTopRadius'                => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'              => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'             => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'               => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'contentTypographyColor' => 'textColor' ? 'textColor' : '',
				'headingTypographyColor' => 'titleColor' ? 'titleColor' : '',
				'dateTypographyColor'    => 'numColor' ? 'numColor' : '',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_alignment_keys = array(
				'contentAlign'       => 'contentAlign' ? 'contentAlign' : 'center',
				'contentAlignMobile' => 'contentAlign' ? 'contentAlign' : 'center',
				'contentAlignTablet' => 'contentAlign' ? 'contentAlign' : 'center',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_alignment_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity = $attr['opacity'] / 100;
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                 => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'grid',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'text-align'     => $attr['contentAlign'],
				),
				'.responsive-count__inner .responsive-count-item__title' => array(
					'font-size' => self::get_css_value( $attr['headingFontSize'], 'px' ),
				),
				'.responsive-count__inner .responsive-count-item__features li' => array(
					'line-height' => $attr['contentLineHeight'],
				),
				'.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-shaped .responsive-block-editor-addons-count-up__source-icon' => array(
					'background-color'           => $attr['iconShapeColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadius'], 'px' ),
					'padding'                    => self::get_css_value( $attr['shapePadding'], 'px' ),
				),
				'.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-outline .responsive-block-editor-addons-count-up__source-icon' => array(
					'border-color'               => $attr['iconShapeColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadius'], 'px' ),
					'padding'                    => self::get_css_value( $attr['shapePadding'], 'px' ),
					'border-width'               => self::get_css_value( $attr['shapeBorder'], 'px' ),
				),
				'.responsive-count__inner .responsive-block-editor-addons-count-up__source-icon svg' => array(
					'width'  => self::get_css_value( $attr['iconsize'], 'px' ),
					'height' => self::get_css_value( $attr['iconsize'], 'px' ),
					'fill'   => $attr['icon_color'],
				),
				' .responsive-count-item'           => array(
					'background-color'           => self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ),
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),
				' .responsive-block-editor-addons-count-up__source-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconSpacing'], 'px' ),
				),
				' .responsive-count-item__title'    => array(
					'color'         => $attr['headingTypographyColor'],
					'line-height'   => $attr['headingLineHeight'],
					'font-size'     => self::get_css_value( $attr['headingFontSize'], 'px' ),
					'font-family'   => $attr['headingFontFamily'],
					'font-weight'   => 'empty' !== $attr['titleFontWeight'] && '900' === $attr['headingFontWeight'] ? $attr['titleFontWeight'] : $attr['headingFontWeight'], // For compatibility with v1.3.2.
					'margin-bottom' => self::get_css_value( $attr['titleSpace'], 'px' ),
					'text-transform'=> $attr['headingTextTransform'],
					'font-style'=> $attr['headingFontStyle'],
				),
				'.responsive-count__inner .responsive-count-item__price-wrapper .responsive-count-item__amount' => array(
					'color'         => $attr['dateTypographyColor'],
					'line-height'   => $attr['dateLineHeight'],
					'font-weight'   => $attr['dateFontWeight'],
					'font-size'     => self::get_css_value( $attr['dateFontSize'], 'px' ),
					'font-family'   => $attr['dateFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['numSpace'], 'px' ),
					'text-transform'=> $attr['dateTextTransform'],
					'font-style'=> $attr['dateFontStyle'],
				),
				' .responsive-count-item__features' => array(
					'color'         => $attr['contentTypographyColor'],
					'line-height'   => $attr['contentLineHeight'],
					'font-weight'   => $attr['contentFontWeight'],
					'font-size'     => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-family'   => $attr['contentFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['contentSpace'], 'px' ),
					'text-transform'=> $attr['contentTextTransform'],
					'font-style'=> $attr['contentFontStyle'],
				),
			);

			$mobile_selectors = array(
				' '                                 => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'grid',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'text-align'     => $attr['contentAlignMobile'],
				),
				'.responsive-count__inner .responsive-count-item__title' => array(
					'font-size' => self::get_css_value( $attr['headingFontSizeMobile'], 'px' ),
				),
				'.responsive-count__inner .responsive-count-item__price-wrapper .responsive-count-item__amount' => array(
					'font-size'     => self::get_css_value( $attr['dateFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['numSpaceMobile'], 'px' ),
				),
				' .responsive-count-item__features' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-count-up__source-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconSpacingMobile'], 'px' ),
				),
				' .responsive-count-item__title'    => array(
					'margin-bottom' => self::get_css_value( $attr['titleSpaceMobile'], 'px' ),
				),
				'.responsive-count-item.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-outline .responsive-block-editor-addons-count-up__source-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadiusMobile'], 'px' ),
				),
				'.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-shaped .responsive-block-editor-addons-count-up__source-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadiusMobile'], 'px' ),
				),
				' .responsive-count-item'           => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                                 => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'grid',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'text-align'     => $attr['contentAlignTablet'],
				),
				'.responsive-count__inner .responsive-count-item__title' => array(
					'font-size' => self::get_css_value( $attr['headingFontSizeTablet'], 'px' ),
				),
				'.responsive-count__inner .responsive-count-item__price-wrapper .responsive-count-item__amount' => array(
					'font-size'     => self::get_css_value( $attr['dateFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['numSpaceTablet'], 'px' ),
				),
				' .responsive-count-item__features' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-count-up__source-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconSpacingTablet'], 'px' ),
				),
				' .responsive-count-item__title'    => array(
					'margin-bottom' => self::get_css_value( $attr['titleSpaceTablet'], 'px' ),
				),
				'.responsive-count-item.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-outline .responsive-block-editor-addons-count-up__source-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadiusTablet'], 'px' ),
				),
				'.responsive-count__inner .responsive-block-editor-addons-count-up__source-wrap.res-countup-icon-design-shaped .responsive-block-editor-addons-count-up__source-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['shapeBorderTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['shapeBorderRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['shapeBorderBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['shapeBorderLeftRadiusTablet'], 'px' ),
				),
				' .responsive-count-item'           => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id              = '.responsive-block-editor-addons-block-count-up.block-' . $id;
			$css             = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			$css['desktop'] .= '
            .responsive-count {
               padding:' . $attr['contentSpacing'] . 'px !important
            }
            ';
			$css['tablet']  .= '
            .responsive-count {
               padding:' . $attr['contentSpacingTablet'] . 'px !important
            }
            ';
			$css['mobile']  .= '
            .responsive-count {
               padding:' . $attr['contentSpacingMobile'] . 'px !important
            }
            ';

			return $css;
		}

		/**
		 * Get Blockquote CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_blockquote_css( $attr, $id ) {
			$defaults = self::get_responsive_block_blockquote_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_alignment_keys = array(
				'quoteAlign'       => 'quoteAlign' ? 'quoteAlign' : '',
				'quoteAlignTablet' => 'quoteAlign' ? 'quoteAlign' : '',
				'quoteAlignMobile' => 'quoteAlign' ? 'quoteAlign' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_alignment_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$quoteopacity                  = $attr['quoteOpacity'] / 100;
			$imgopacity                    = $attr['opacity'] / 100;
			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_index'],
					'position'                   => 'relative',
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ) : '',
					'color'                      => $attr['quoteTypographyColor'],
					'border-color'               => 'empty' !== $attr['borderColor'] && '' === $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'], // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'], // For compatibility with v1.3.2.
					'border-width'               => 999 !== $attr['borderWidth'] && 1 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
					'position'                   => 'relative',
					'text-align'                 => $attr['quoteAlign'],
					'padding-left'               => 999 !== $attr['leftPadding'] && 60 === $attr['blockLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['blockLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['rightPadding'] && 60 === $attr['blockRightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['blockRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'                => 999 !== $attr['topPadding'] && 70 === $attr['blockTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['blockTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['bottomPadding'] && 70 === $attr['blockBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['blockBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity )
						: null,
					'background-image'           =>
						'gradient' === $attr['backgroundType']
						? 'linear-gradient(' .
							$attr['gradientDirection'] .
							'deg,' .
							self::hex_to_rgb( $attr['backgroundColor1'] ? $attr['backgroundColor1'] : '#ffffff', $imgopacity ) .
							',' .
							self::hex_to_rgb( $attr['backgroundColor2'] ? $attr['backgroundColor2'] : '#ffffff', $imgopacity ) .
							')'
						: null,
					'margin-top'                 => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				':hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-section__video-wrap' => array(
					'opacity' => $imgopacity,
				),
				' .responsive-block-editor-addons-section-background-image-wrap .responsive-block-editor-addons-section-background-image' => array(
					'height'                     => 100 . '%',
					'opacity'                    => $imgopacity,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),
				' .responsive-block-editor-addons-block-blockquote-item .responsive-block-editor-addons-block-blockquote-quote' => array(
					'height'  => self::get_css_value( $attr['quoteSize'], 'px' ),
					'width'   => self::get_css_value( $attr['quoteSize'], 'px' ),
					'fill'    => $attr['quoteColor'],
					'left'    => self::get_css_value( $attr['quoteHposition'], 'px' ),
					'top'     => self::get_css_value( $attr['quoteVposition'], 'px' ),
					'opacity' => $quoteopacity,
				),
				' .responsive-block-editor-addons-block-blockquote-text' => array(
					'text-align'  => $attr['quoteAlign'],
					'font-family' => $attr['quoteFontFamily'],
					'font-size'   => self::get_css_value( $attr['quoteFontSize'], 'px' ),
					'font-weight' => $attr['quoteFontWeight'],
					'line-height' => $attr['quoteLineHeight'],
					"text-transform" => $attr['quoteTextTransform'],
      				"font-style"     => $attr['quoteFontStyle'],
				),
				' .responsive-block-editor-addons-block-blockquote-item' => array(
					'padding-left'   => self::get_css_value( $attr['textLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['textRightPadding'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['textTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['textBottomPadding'], 'px' ),
				),
				' .rbea-bq__tweet' => array(
					'font-family'    => $attr['twFontFamily'],
					'font-size'      => self::get_css_value( $attr['twFontSize'], 'px' ),
					'font-weight'    => $attr['twFontWeight'],
					'font-style'     => $attr['twFontStyle'],
					'line-height'    => $attr['twLineHeight'],
					'padding-top'    => self::get_css_value( $attr['twTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['twRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['twBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['twLeftPadding'], 'px' ),
					'color'          => $attr['twColor'],
					'background-color' => $attr['twBg'],
					'text-transform' => $attr['twTextTransform'],
					'text-decoration' => $attr['twTextDecoration'],
					'gap'            => self::get_css_value( $attr['twIconTextSpacing'], 'px' ),
					'--icon-text-spacing' => self::get_css_value( $attr['twIconTextSpacing'], 'px' ),
					'--hover-color'  => $attr['twHColor'],
					'--hover-bg'     => $attr['twHBg'],
				),
				' .rbea-bq__tweet svg' => array(
					'width'          => self::get_css_value( $attr['twFontSize'], 'px' ),
					'height'         => self::get_css_value( $attr['twFontSize'], 'px' ),
				),
				' .rbea-bq__tweet:hover' => array(
					'color'          => $attr['twHColor'],
					'background-color' => $attr['twHBg'],
				),

			);
			$mobile_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexMobile'],
					'text-align'                 => $attr['quoteAlignMobile'],
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . '!important',
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-blockquote-item' => array(
					'padding-left'   => self::get_css_value( $attr['textLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['textRightPaddingMobile'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['textTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['textBottomPaddingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-blockquote-text' => array(
					'font-size' => self::get_css_value( $attr['quoteFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-section-background-image-wrap .responsive-block-editor-addons-section-background-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .rbea-bq__tweet' => array(
					'font-size'      => self::get_css_value( $attr['twFontSizeMobile'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['twTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['twRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['twBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['twLeftPaddingMobile'], 'px' ),
				),
				' .rbea-bq__tweet svg' => array(
					'width'          => self::get_css_value( $attr['twFontSizeMobile'], 'px' ),
					'height'         => self::get_css_value( $attr['twFontSizeMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexTablet'],
					'text-align'                 => $attr['quoteAlignTablet'],
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . '!important',
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-blockquote-item' => array(
					'padding-left'   => self::get_css_value( $attr['textLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['textRightPaddingTablet'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['textTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['textBottomPaddingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-blockquote-text' => array(
					'font-size' => self::get_css_value( $attr['quoteFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-section-background-image-wrap .responsive-block-editor-addons-section-background-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .rbea-bq__tweet' => array(
					'font-size'      => self::get_css_value( $attr['twFontSizeTablet'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['twTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['twRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['twBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['twLeftPaddingTablet'], 'px' ),
				),
				' .rbea-bq__tweet svg' => array(
					'width'          => self::get_css_value( $attr['twFontSizeTablet'], 'px' ),
					'height'         => self::get_css_value( $attr['twFontSizeTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-blockquote.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Divider CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_divider_css( $attr, $id ) {
			$defaults = self::get_responsive_block_divider_default_attributes();

			$new_spacing_attribute_keys = array(
				'blockTopPadding'          => 'spacerHeight',
				'blockBottomPadding'       => 'spacerHeight',
				'blockTopPaddingTablet'    => 'spacerHeightTablet',
				'blockBottomPaddingTablet' => 'spacerHeightTablet',
				'blockTopPaddingMobile'    => 'spacerHeightMobile',
				'blockBottomPaddingMobile' => 'spacerHeightMobile',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' ' => array(
					'color'    => $attr['spacerDividerColor'],
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
				),
				' .responsive-block-editor-addons-spacer-handle' => array(
					'color' => $attr['spacerDividerColor'],
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content .responsive-block-editor-addons-divider_hr' => array(
					'height'           => self::get_css_value( $attr['spacerDividerHeight'], 'px' ),
					'width'            => $attr['spacerDividerWidth'] . '%',
					'background-color' => $attr['spacerDividerColor'],
					'border-radius'    =>
						'basic' === $attr['spacerDividerStyle']
						? 0
						: self::get_css_value( $attr['spacerDividerHeight'] / 2, 'px' ),
					'margin-left'      => 'left' === $attr['spacerDividerAlignment'] ? 0 : 'auto',
					'margin-right'     => 'right' === $attr['spacerDividerAlignment'] ? 0 : 'auto',
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content .rgbl-divider__dots' => array(
					'width'        => $attr['spacerDividerWidth'] . '%',
					'margin-left'  => 'left' === $attr['spacerDividerAlignment'] ? 0 : 'auto',
					'margin-right' => 'right' === $attr['spacerDividerAlignment'] ? 0 : 'auto',
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content .rgbl-divider__dots .rgbl-divider__dot' => array(
					'height'           => self::get_css_value( $attr['spacerDividerHeight'], 'px' ),
					'background-color' => $attr['spacerDividerColor'],
					'font-size'        => self::get_css_value( $attr['spacerDividerHeight'] * 1.8, 'px' ),
					'width'            => self::get_css_value( $attr['spacerDividerHeight'], 'px' ),
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
				),
				' .responsive-block-editor-addons-divider-inner .responsive-block-editor-addons-divider-content' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-divider.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for post grid block
		 *
		 * @return array
		 */
		public static function get_responsive_block_post_grid_block_default_attributes() {
			return array(
				'textAlignment'                => 'left',
				'postsToShow'                  => 6,
				'stackonMobile'                => true,
				'displayPostDate'              => true,
				'excludeCurrentPost'           => true,
				'displayPostExcerpt'           => true,
				'displayPostAuthor'            => true,
				'displayPostImage'             => true,
				'displayPostLink'              => true,
				'displayPostTitle'             => true,
				'displaySectionTitle'          => false,
				'postPagination'               => false,
				'equalHeight'                  => true,
				'postTitleTag'                 => 'h3',
				'postLayout'                   => 'grid',
				'columns'                      => 2,
				'align'                        => 'center',
				'width'                        => 'wide',
				'orderBy'                      => 'date',
				'order'                        => 'desc',
				'readMoreText'                 => 'Read More »',
				'offset'                       => 0,
				'excerptLength'                => 55,
				'postType'                     => 'post',
				'postTaxonomy'                 => 'category',
				'taxonomyType'                 => 'category',
				'paginationAlignment'          => 'left',
				'paginationLayout'             => '',
				'sectionTag'                   => 'section',
				'sectionTitle'                 => '',
				'sectionTitleTag'              => 'h2',
				'imageSize'                    => 'full',
				'id'                           => '',
				'bgColor'                      => '#e4e4e4',
				'paginationBorderColor'        => '#e4e4e4',
				'paginationTextActiveColor'    => '',
				'paginationTextColor'          => '',
				'paginationActiveBorderColor'  => '',
				'paginationBorderWidth'        => '',
				'paginationBorderRadius'       => '',
				'paginationTopRadiusMobile'    => 0,
				'paginationRightRadiusMobile'  => 0,
				'paginationBottomRadiusMobile' => 0,
				'paginationLeftRadiusMobile'   => 0,
				'paginationTopRadiusTablet'    => 0,
				'paginationRightRadiusTablet'  => 0,
				'paginationBottomRadiusTablet' => 0,
				'paginationLeftRadiusTablet'   => 0,
				'paginationTopRadius'          => 0,
				'paginationRightRadius'        => 0,
				'paginationBottomRadius'       => 0,
				'paginationLeftRadius'         => 0,
				'paginationSpacing'            => '',
				'imageBorderRadius'            => '',
				'imageTopRadiusMobile'         => 0,
				'imageRightRadiusMobile'       => 0,
				'imageBottomRadiusMobile'      => 0,
				'imageLeftRadiusMobile'        => 0,
				'imageTopRadiusTablet'         => 0,
				'imageRightRadiusTablet'       => 0,
				'imageBottomRadiusTablet'      => 0,
				'imageLeftRadiusTablet'        => 0,
				'imageTopRadius'               => 0,
				'imageRightRadius'             => 0,
				'imageBottomRadius'            => 0,
				'imageLeftRadius'              => 0,
				'textColor'                    => '#444444',
				'previousButtonText'           => 'Previous',
				'nextButtonText'               => 'Next',
				'imagePosition'                => 'top',
				'layout'                       => 'boxed',
				'metaColor'                    => '#444444',
				'readMoreLinkColor'            => '#0066cc',
				'readMoreHoverColor'           => '#0558ab',
				'titleColor'                   => '#444444',
				'titleHoverColor'              => '#444444',
				'contentPadding'               => 30,
				'contentPaddingMobile'         => '',
				'mobileContentPadding'         => 999, // For compatibility with v1.3.2.
				'contentPaddingTablet'         => '',
				'continueFontSize'             => '',
				'continueLineHeight'           => '',
				'continueFontWeight'           => '',
				'continueTextTransform'        => '',
				'continueFontFamily'           => '',
				'titleFontSize'                => '',
				'titleFontSizeMobile'          => '',
				'titleFontSizeTablet'          => '',
				'titleLineHeight'              => '',
				'titleFontWeight'              => '',
				'titleTextTransform'           => '',
				'metaFontSize'                 => '',
				'metaLineHeight'               => '',
				'metaFontWeight'               => '',
				'metaTextTransform'            => '',
				'titleFontFamily'              => '',
				'metaFontFamily'               => '',
				'excerptFontFamily'            => '',
				'excerptFontSize'              => '',
				'excerptLineHeight'            => '',
				'excerptFontWeight'            => '',
				'excerptTextTransform'         => '',
				'excerptBottomSpacing'         => '',
				'metaBottomSpacing'            => '',
				'imageBottomSpacing'           => '',
				'imageBottomSpacingMobile'     => '',
				'imageBottomSpacingTablet'     => '',
				'titleBottomSpacing'           => '',
				'columnGap'                    => 20,
				'excerptBottomSpacingMobile'   => '',
				'metaBottomSpacingMobile'      => '',
				'titleBottomSpacingMobile'     => '',
				'excerptBottomSpacingTablet'   => '',
				'metaBottomSpacingTablet'      => '',
				'titleBottomSpacingTablet'     => '',
				'rowGap'                       => 0,
				'rowGapMobile'                 => 0,
				'rowGapTablet'                 => 0,
				'blockBorderWidth'             => '0',
				'blockBorderRadius'            => '0',
				'blockBorderStyle'             => 'none',
				'blockBorderColor'             => '#333',
				'pageLimit'                    => '10',
				'taxonomyType'                 => 'category',
				'postGridBlockId'              => '',
				'boxShadowColor'               => '',
				'boxShadowHOffset'             => 0,
				'boxShadowVOffset'             => 0,
				'boxShadowBlur'                => 0,
				'boxShadowSpread'              => 0,
				'boxShadowPosition'            => 'outset',
				'hoverboxShadowColor'          => '',
				'hoverboxShadowHOffset'        => 0,
				'hoverboxShadowVOffset'        => 0,
				'hoverboxShadowBlur'           => 0,
				'hoverboxShadowSpread'         => 0,
				'hoverboxShadowPosition'       => 'outset',
				'columnGapTablet'              => '',
				'columnGapMobile'              => '',
				'continueFontSizeMobile'       => '',
				'continueFontSizeTablet'       => '',
				'metaFontSizeMobile'           => '',
				'metaFontSizeTablet'           => '',
				'excerptFontSizeMobile'        => '',
				'excerptFontSizeTablet'        => '',
				'imageWidth'                   => '',
				'imageWidthTablet'             => '',
				'imageWidthMobile'             => '',
				'imageHeight'                  => '',
				'imageHeightTablet'            => '',
				'imageHeightMobile'            => '',
				'hideWidgetTablet'             => false,
				'hideWidgetMobile'             => false,
				'hideWidget'                   => false,
				'z_index'                      => 1,
				'z_indexTablet'                => 1,
				'z_indexMobile'                => 1,
				'blockTopPadding'              => '',
				'blockTopPaddingMobile'        => '',
				'blockTopPaddingTablet'        => '',
				'blockBottomPadding'           => '',
				'blockBottomPaddingMobile'     => '',
				'blockBottomPaddingTablet'     => '',
				'blockLeftPadding'             => '',
				'blockLeftPaddingMobile'       => '',
				'blockLeftPaddingTablet'       => '',
				'blockRightPadding'            => '',
				'blockRightPaddingMobile'      => '',
				'blockRightPaddingTablet'      => '',
				'blockTopMargin'               => '',
				'blockTopMarginMobile'         => '',
				'blockTopMarginTablet'         => '',
				'blockBottomMargin'            => '',
				'blockBottomMarginMobile'      => '',
				'blockBottomMarginTablet'      => '',
				'blockLeftMargin'              => '',
				'blockLeftMarginMobile'        => '',
				'blockLeftMarginTablet'        => '',
				'blockRightMargin'             => '',
				'blockRightMarginMobile'       => '',
				'blockRightMarginTablet'       => '',
				'blockTopRadiusMobile'         => 0,
				'blockRightRadiusMobile'       => 0,
				'blockBottomRadiusMobile'      => 0,
				'blockLeftRadiusMobile'        => 0,
				'blockTopRadiusTablet'         => 0,
				'blockRightRadiusTablet'       => 0,
				'blockBottomRadiusTablet'      => 0,
				'blockLeftRadiusTablet'        => 0,
				'blockTopRadius'               => 0,
				'blockRightRadius'             => 0,
				'blockBottomRadius'            => 0,
				'blockLeftRadius'              => 0,
				'excerptTypographyColor'       => '#444444',
				'metaTypographyColor'          => '#444444',
				'excerptFontStyle'             => '',  
				'metaFontStyle'                => '',  
				'titleFontStyle'               => '',  
				'continueFontStyle'            => '',  

			);
		}

		/**
		 * Get Defaults for post carousel block
		 *
		 * @return array
		 */
		public static function get_responsive_block_post_carousel_default_attributes() {
			return array(
				'blockAlign'               => 'left',
				'columns'                  => 2,
				'tcolumns'                 => 1,
				'mcolumns'                 => 1,
				'block_id'                 => 1,
				'autoplaySpeed'            => 2000,
				'autoplay'                 => true,
				'infiniteLoop'             => true,
				'pauseOnHover'             => true,
				'transitionSpeed'          => 500,
				'arrowSize'                => 20,
				'arrowDots'                => 'arrows_dots',
				'arrowBorderSize'          => 1,
				'arrowBorderRadius'        => 0,
				'arrowTopRadiusMobile'     => 0,
				'arrowRightRadiusMobile'   => 0,
				'arrowBottomRadiusMobile'  => 0,
				'arrowLeftRadiusMobile'    => 0,
				'arrowTopRadiusTablet'     => 0,
				'arrowRightRadiusTablet'   => 0,
				'arrowBottomRadiusTablet'  => 0,
				'arrowLeftRadiusTablet'    => 0,
				'arrowTopRadius'           => 0,
				'arrowRightRadius'         => 0,
				'arrowBottomRadius'        => 0,
				'arrowLeftRadius'          => 0,
				'postsToShow'              => 6,
				'displayPostDate'          => true,
				'displayPostExcerpt'       => true,
				'displayPostAuthor'        => true,
				'displayPostImage'         => true,
				'displayPostLink'          => true,
				'displayPostTitle'         => true,
				'displayPostComment'       => true,
				'displayPostTaxonomy'      => true,
				'buttonTarget'             => false,
				'equalHeight'              => true,
				'categories'               => '',
				'className'                => '',
				'postTitleTag'             => 'h3',
				'align'                    => 'center',
				'order'                    => 'desc',
				'orderBy'                  => 'date',
				'readMoreText'             => 'Continue Reading',
				'offset'                   => 0,
				'excerptLength'            => 20,
				'postType'                 => 'post',
				'sectionTag'               => 'section',
				'sectionTitle'             => '',
				'sectionTitleTag'          => 'h2',
				'imageSize'                => 'full',
				'ctaHoverColor'            => '#ffffff',
				'bgColor'                  => '#ffffff',
				'ctaColor'                 => '#ffffff',
				'ctaBackColor'             => '#333333',
				'titleColor'               => '#333333',
				'contentColor'             => '#333333',
				'metaColor'                => '#333333',
				'arrowDotsColor'           => '#333333',
				'ctaHoverBackColor'        => '#444444',
				'ctaBorderColor'           => '',
				'ctaHoverBorderColor'      => '',
				'ctaBorderStyle'           => 'none',
				'ctaBorderRadius'          => 0,
				'ctaBorderWidth'           => 2,
				'ctaHpadding'              => 20,
				'ctaVpadding'              => 15,
				'contentPadding'           => 20,
				'contentPaddingMobile'     => 20,
				'contentPaddingTablet'     => 20,
				'rowGap'                   => 20,
				'columnGap'                => 20,
				'columnGapMobile'          => 20,
				'columnGapTablet'          => 20,
				'imageSpace'               => null,
				'titleSpace'               => null,
				'dateSpace'                => 20,
				'excerptSpace'             => 20,
				'ctaSpace'                 => 20,
				'titleFontSize'            => 20,
				'titleFontSizeMobile'      => 20,
				'titleFontSizeTablet'      => 20,
				'titleFontWeight'          => 600,
				'titleLineHeight'          => 1,
				'metaFontSize'             => 16,
				'metaFontWeight'           => 300,
				'metaLineHeight'           => 1,
				'excerptFontSize'          => 16,
				'excerptFontWeight'        => 300,
				'excerptLineHeight'        => 1,
				'ctaFontSize'              => 16,
				'ctaFontWeight'            => 100,
				'ctaLineHeight'            => 1,
				'opacity'                  => 50,
				'imagePosition'            => 'background',
				'titleFontFamily'          => '',
				'metaFontFamily'           => '',
				'excerptFontFamily'        => '',
				'ctaFontFamily'            => '',
				'metaFontSizeMobile'       => '',
				'metaFontSizeTablet'       => '',
				'excerptFontSizeMobile'    => '',
				'excerptFontSizeTablet'    => '',
				'ctaFontSizeMobile'        => '',
				'ctaFontSizeTablet'        => '',
				'buttoncolorLocation1'     => 0,
				'buttoncolorLocation2'     => 100,
				'buttongradientDirection'  => 90,
				'buttonbackgroundColor1'   => '',
				'buttonbackgroundColor2'   => '#fff',
				'buttonbackgroundType'     => 'color',
				'ctaHpaddingTablet'        => 20,
				'ctaHpaddingMobile'        => 20,
				'ctaVpaddingTablet'        => 15,
				'ctaVpaddingMobile'        => 15,
				'buttonHbackgroundType'    => 'none',
				'hideWidgetTablet'         => false,
				'hideWidgetMobile'         => false,
				'hideWidget'               => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'excerptTypographyColor'   => '#333333',
				'titleTypographyColor'     => '#333333',
				'metaTypographyColor'      => '#333333',
				'titleTextTransform'       => '',
				'titleFontStyle'           => '',
				'metaTextTransform'        => '',
				'metaFontStyle'            => '',
				'excerptTextTransform'     => '',
				'excerptFontStyle'         => '',
				'ctaTextTransform'         => '',
				'ctaFontStyle'             => '',
			);
		}

		/**
		 * Get Accordian Block CSS
		 * *
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_accordian_css( $attr, $id ) {
			$defaults                   = self::get_responsive_block_accordian_block_default_attributes();
			$new_spacing_attribute_keys = array(
				'blockTopMargin'          => 'marginV',
				'blockRightMargin'        => 'marginH',
				'blockBottomMargin'       => 'marginV',
				'blockLeftMargin'         => 'marginH',
				'blockTopMarginTablet'    => 'marginVTablet',
				'blockRightMarginTablet'  => 'marginHTablet',
				'blockBottomMarginTablet' => 'marginVTablet',
				'blockLeftMarginTablet'   => 'marginHTablet',
				'blockTopMarginMobile'    => 'marginVMobile',
				'blockRightMarginMobile'  => 'marginHMobile',
				'blockBottomMarginMobile' => 'marginVMobile',
				'blockLeftMarginMobile'   => 'marginHMobile',
			);

			// To populate new control values with existing typography color control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_attribute_keys = array(
				'titleTypographyColor'   => 'titleTextColor',
				'contentTypographyColor' => 'contentTextColor',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_typography_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_padding_attribute_keys = array(
				'blockTitleLeftPadding'         => 'titleLeftSpacing' ? 'titleLeftSpacing' : '',
				'blockTitleLeftPaddingTablet'   => 'titleLeftSpacingTablet' ? 'titleLeftSpacingTablet' : '',
				'blockTitleLeftPaddingMobile'   => 'titleLeftSpacingMobile' ? 'titleLeftSpacingMobile' : '',
				'blockTitleTopPadding'          => 'titleTopSpacing' ? 'titleTopSpacing' : '',
				'blockTitleTopPaddingTablet'    => 'titleTopSpacingTablet' ? 'titleTopSpacingTablet' : '',
				'blockTitleTopPaddingMobile'    => 'titleTopSpacingMobile' ? 'titleTopSpacingMobile' : '',
				'blockTitleBottomPadding'       => 'titleBottomSpacing' ? 'titleBottomSpacing' : '',
				'blockTitleBottomPaddingTablet' => 'titleBottomSpacingTablet' ? 'titleBottomSpacingTablet' : '',
				'blockTitleBottomPaddingMobile' => 'titleBottomSpacingMobile' ? 'titleBottomSpacingMobile' : '',
				'blockTitleRightPadding'        => 'titleRightSpacing' ? 'titleRightSpacing' : '',
				'blockTitleRightPaddingTablet'  => 'titleRightSpacingTablet' ? 'titleRightSpacingTablet' : '',
				'blockTitleRightPaddingMobile'  => 'titleRightSpacingMobile' ? 'titleRightSpacingMobile' : '',

				'contentLeftPadding'            => 'contentLeftSpacing' ? 'contentLeftSpacing' : '',
				'contentLeftPaddingTablet'      => 'contentLeftSpacingTablet' ? 'contentLeftSpacingTablet' : '',
				'contentLeftPaddingMobile'      => 'contentLeftSpacingMobile' ? 'contentLeftSpacingMobile' : '',
				'contentTopPadding'             => 'contentTopSpacing' ? 'contentTopSpacing' : '',
				'contentTopPaddingTablet'       => 'contentTopSpacingTablet' ? 'contentTopSpacingTablet' : '',
				'contentTopPaddingMobile'       => 'contentTopSpacingMobile' ? 'contentTopSpacingMobile' : '',
				'contentBottomPadding'          => 'contentBottomSpacing' ? 'contentBottomSpacing' : '',
				'contentBottomPaddingTablet'    => 'contentBottomSpacingTablet' ? 'contentBottomSpacingTablet' : '',
				'contentBottomPaddingMobile'    => 'contentBottomSpacingMobile' ? 'contentBottomSpacingMobile' : '',
				'contentRightPadding'           => 'contentRightSpacing' ? 'contentRightSpacing' : '',
				'contentRightPaddingTablet'     => 'contentRightSpacingTablet' ? 'contentRightSpacingTablet' : '',
				'contentRightPaddingMobile'     => 'contentRightSpacingMobile' ? 'contentRightSpacingMobile' : '',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_padding_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}
			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$icon_color        = $attr['iconColor'];
			$icon_active_color = $attr['iconActiveColor'];
			if ( ! $attr['iconColor'] ) {
				$icon_color = $attr['titleTypographyColor'];
			}
			if ( ! $attr['iconActiveColor'] ) {
				$icon_active_color = $attr['titleTextActiveColor'];
			}

			$content_opacity                   = $attr['titleBackgroundColorOpacity'] / 100;
			$content_background_colors_opacity = $attr['contentBackgroundColorOpacity'] / 100;

			$temptitle_secondary_background_color = $attr['titleBgGradient'] ? $attr['titleSecondaryBackgroundColor'] : $attr['titleBackgroundColor'];
			$title_gradient                       = '';
			if ( $attr['titleBgGradient'] ) {
				$title_gradient = 'linear-gradient(' .
					$attr['titleGradientDegree'] .
					'deg,' .
					self::hex_to_rgb( $attr['titleBackgroundColor'] ? $attr['titleBackgroundColor'] : '#ffffff', $content_opacity ) .
					',' .
					self::hex_to_rgb( $temptitle_secondary_background_color ? $temptitle_secondary_background_color : '#ffffff', $content_opacity ) .
					')';
			}

			$temp_active_secondary_background_color = $attr['contentBgGradient'] ? $attr['contentSecondaryBackgroundColor'] : $attr['contentBackgroundColor'];
			$content_gradient                       = 'linear-gradient(' .
				$attr['contentGradientDegree'] .
				'deg,' .
				self::hex_to_rgb( $attr['contentBackgroundColor'] ? $attr['contentBackgroundColor'] : '#ffffff', $content_background_colors_opacity ) .
				',' .
				self::hex_to_rgb( $temp_active_secondary_background_color ? $temp_active_secondary_background_color : '#ffffff', $content_background_colors_opacity ) .
				')';

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-icon svg' => array(
					'width'        => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'height'       => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'font-size'    => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'fill'         => $icon_color,
					'margin-right' => '10px',
				),
				' .responsive-block-editor-addons-icon-active svg' => array(
					'width'        => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'height'       => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'font-size'    => self::get_css_value( ( $attr['iconSize'] ), $attr['iconSizeType'] ),
					'fill'         => $icon_active_color,
					'margin-right' => '10px',
				),
				' .responsive-block-editor-addons-accordion-item__outer-wrap' => array(
					'margin-bottom' => self::get_css_value( ( $attr['rowsGap'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion__wrap.responsive-block-editor-addons-buttons-layout-wrap' => array(
					'grid-column-gap' => self::get_css_value( ( $attr['columnsGap'] ), 'px' ),
					'grid-row-gap'    => self::get_css_value( ( $attr['rowsGap'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion-titles-button' => array(
					'background-image' => $title_gradient,
					'padding-top'      => self::get_css_value( ( $attr['vtitlePaddingDesktop'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-bottom'   => self::get_css_value( ( $attr['titleBottomPaddingDesktop'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-right'    => self::get_css_value( ( $attr['htitlePaddingDesktop'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-left'     => self::get_css_value( ( $attr['titleLeftPaddingDesktop'] ), $attr['titlePaddingTypeDesktop'] ),
				),
				' .responsive-block-editor-addons-accordion-content span' => array(
					'margin-top'     => self::get_css_value( ( $attr['vcontentPaddingDesktop'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-bottom'  => self::get_css_value( ( $attr['vcontentPaddingDesktop'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-right'   => self::get_css_value( ( $attr['hcontentPaddingDesktop'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-left'    => self::get_css_value( ( $attr['hcontentPaddingDesktop'] ), $attr['contentPaddingTypeDesktop'] ),

					'padding-top'    => self::get_css_value( $attr['contentTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['contentBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['contentLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['contentRightPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'flex-direction' => $attr['iconAlign'],
				),
				' .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-title' => array(
					'font-family' => $attr['titleFontFamily'],
					'font-size'   => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-weight' => $attr['titleFontWeight'],
					'line-height' => $attr['titleLineHeight'],
					'text-transform' => $attr['titleTextTransform'],
					'font-style'  => $attr['titleFontStyle'],
				),
				' .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-content' => array(
					'background-image' => $content_gradient,
					'font-family'      => $attr['contentFontFamily'],
					'font-size'        => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-weight'      => $attr['contentFontWeight'],
					'line-height'      => $attr['contentLineHeight'],
					'color'            => $attr['contentTypographyColor'],
					'text-transform'   => $attr['contentTextTransform'],
					'font-style'       => $attr['contentFontStyle'],
				),
				' .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'color'                      => $attr['titleTypographyColor'],
					'background-color'           => self::hex_to_rgb( $attr['titleBackgroundColor'] ? $attr['titleBackgroundColor'] : '#fff', $content_opacity ),
					'border-style'               => $attr['parentBlockBorderStyle'],
					'border-color'               => $attr['parentBlockBorderColor'],
					'border-top-width'           => self::get_css_value( $attr['parentBlockBorderTopWidth'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['parentBlockBorderBottomWidth'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['parentBlockBorderLeftWidth'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['parentBlockBorderRightWidth'], 'px' ),

					'border-top-left-radius'     => self::get_css_value( $attr['parentBlockBorderTopRadius'], 'px' ) . ' !important',
					'border-top-right-radius'    => self::get_css_value( $attr['parentBlockBorderRightRadius'], 'px' ) . ' !important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['parentBlockBorderLeftRadius'], 'px' ) . ' !important',
					'border-bottom-right-radius' => self::get_css_value( $attr['parentBlockBorderBottomRadius'], 'px' ) . ' !important',

					'padding-top'                => self::get_css_value( $attr['blockTitleTopPadding'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockTitleBottomPadding'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockTitleLeftPadding'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockTitleRightPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item-active .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'color'            => $attr['titleActiveTextColor'],
					'background-color' => $attr['titleActiveBackgroundColor'],
				),

			);
			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-titles-button' => array(
					'padding-top'    => self::get_css_value( ( $attr['vtitlePaddingMobile'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-bottom' => self::get_css_value( ( $attr['titleBottomPaddingMobile'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-right'  => self::get_css_value( ( $attr['htitlePaddingMobile'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-left'   => self::get_css_value( ( $attr['titleLeftPaddingMobile'] ), $attr['titlePaddingTypeDesktop'] ),
				),
				' .responsive-block-editor-addons-accordion-content span' => array(
					'margin-top'     => self::get_css_value( ( $attr['vcontentPaddingMobile'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-bottom'  => self::get_css_value( ( $attr['vcontentPaddingMobile'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-right'   => self::get_css_value( ( $attr['hcontentPaddingMobile'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-left'    => self::get_css_value( ( $attr['hcontentPaddingMobile'] ), $attr['contentPaddingTypeDesktop'] ),

					'padding-top'    => self::get_css_value( $attr['contentTopPaddingMobile'], 'px' ) . ' !important',
					'padding-bottom' => self::get_css_value( $attr['contentBottomPaddingMobile'], 'px' ) . ' !important',
					'padding-left'   => self::get_css_value( $attr['contentLeftPaddingMobile'], 'px' ) . ' !important',
					'padding-right'  => self::get_css_value( $attr['contentRightPaddingMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-icon svg' => array(
					'width'     => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
					'height'    => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
					'font-size' => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-active svg' => array(
					'width'     => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
					'height'    => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
					'font-size' => self::get_css_value( ( $attr['iconSizeMobile'] ), $attr['iconSizeType'] ),
				),
				' .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-content' => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item__outer-wrap' => array(
					'margin-bottom' => self::get_css_value( ( $attr['rowsGapMobile'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion__wrap.responsive-block-editor-addons-buttons-layout-wrap' => array(
					'grid-column-gap' => self::get_css_value( ( $attr['columnsGapMobile'] ), 'px' ),
					'grid-row-gap'    => self::get_css_value( ( $attr['rowsGapMobile'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'padding-top'                => self::get_css_value( $attr['blockTitleTopPaddingMobile'], 'px' ) . ' !important',
					'padding-bottom'             => self::get_css_value( $attr['blockTitleBottomPaddingMobile'], 'px' ) . ' !important',
					'padding-left'               => self::get_css_value( $attr['blockTitleLeftPaddingMobile'], 'px' ) . ' !important',
					'padding-right'              => self::get_css_value( $attr['blockTitleRightPaddingMobile'], 'px' ) . ' !important',

					'border-top-width'           => self::get_css_value( $attr['parentBlockBorderTopWidthMobile'], 'px' ) . ' !important',
					'border-bottom-width'        => self::get_css_value( $attr['parentBlockBorderBottomWidthMobile'], 'px' ) . ' !important',
					'border-left-width'          => self::get_css_value( $attr['parentBlockBorderLeftWidthMobile'], 'px' ) . ' !important',
					'border-right-width'         => self::get_css_value( $attr['parentBlockBorderRightWidthMobile'], 'px' ) . ' !important',

					'border-top-left-radius'     => self::get_css_value( $attr['parentBlockBorderTopRadiusMobile'], 'px' ) . ' !important',
					'border-top-right-radius'    => self::get_css_value( $attr['parentBlockBorderRightRadiusMobile'], 'px' ) . ' !important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['parentBlockBorderLeftRadiusMobile'], 'px' ) . ' !important',
					'border-bottom-right-radius' => self::get_css_value( $attr['parentBlockBorderBottomRadiusMobile'], 'px' ) . ' !important',
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-titles-button' => array(
					'padding-top'    => self::get_css_value( ( $attr['vtitlePaddingTablet'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-bottom' => self::get_css_value( ( $attr['titleBottomPaddingTablet'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-right'  => self::get_css_value( ( $attr['htitlePaddingTablet'] ), $attr['titlePaddingTypeDesktop'] ),
					'padding-left'   => self::get_css_value( ( $attr['titleLeftPaddingTablet'] ), $attr['titlePaddingTypeDesktop'] ),
				),
				' .responsive-block-editor-addons-accordion-content span' => array(
					'margin-top'     => self::get_css_value( ( $attr['vcontentPaddingTablet'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-bottom'  => self::get_css_value( ( $attr['vcontentPaddingTablet'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-right'   => self::get_css_value( ( $attr['hcontentPaddingTablet'] ), $attr['contentPaddingTypeDesktop'] ),
					'margin-left'    => self::get_css_value( ( $attr['hcontentPaddingTablet'] ), $attr['contentPaddingTypeDesktop'] ),

					'padding-top'    => self::get_css_value( $attr['contentTopPaddingTablet'], 'px' ) . ' !important',
					'padding-bottom' => self::get_css_value( $attr['contentBottomPaddingTablet'], 'px' ) . ' !important',
					'padding-left'   => self::get_css_value( $attr['contentLeftPaddingTablet'], 'px' ) . ' !important',
					'padding-right'  => self::get_css_value( $attr['contentRightPaddingTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-icon svg' => array(
					'width'     => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
					'height'    => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
					'font-size' => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-active svg' => array(
					'width'     => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
					'height'    => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
					'font-size' => self::get_css_value( ( $attr['iconSizeTablet'] ), $attr['iconSizeType'] ),
				),
				' .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-content' => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-accordion-item__outer-wrap' => array(
					'margin-bottom' => self::get_css_value( ( $attr['rowsGapTablet'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion__wrap.responsive-block-editor-addons-buttons-layout-wrap' => array(
					'grid-column-gap' => self::get_css_value( ( $attr['columnsGapTablet'] ), 'px' ),
					'grid-row-gap'    => self::get_css_value( ( $attr['rowsGapTablet'] ), 'px' ),
				),
				' .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'padding-top'                => self::get_css_value( $attr['blockTitleTopPaddingTablet'], 'px' ) . ' !important',
					'padding-bottom'             => self::get_css_value( $attr['blockTitleBottomPaddingTablet'], 'px' ) . ' !important',
					'padding-left'               => self::get_css_value( $attr['blockTitleLeftPaddingTablet'], 'px' ) . ' !important',
					'padding-right'              => self::get_css_value( $attr['blockTitleRightPaddingTablet'], 'px' ) . ' !important',

					'border-top-width'           => self::get_css_value( $attr['parentBlockBorderTopWidthTablet'], 'px' ) . ' !important',
					'border-bottom-width'        => self::get_css_value( $attr['parentBlockBorderBottomWidthTablet'], 'px' ) . ' !important',
					'border-left-width'          => self::get_css_value( $attr['parentBlockBorderLeftWidthTablet'], 'px' ) . ' !important',
					'border-right-width'         => self::get_css_value( $attr['parentBlockBorderRightWidthTablet'], 'px' ) . ' !important',

					'border-top-left-radius'     => self::get_css_value( $attr['parentBlockBorderTopRadiusTablet'], 'px' ) . ' !important',
					'border-top-right-radius'    => self::get_css_value( $attr['parentBlockBorderRightRadiusTablet'], 'px' ) . ' !important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['parentBlockBorderLeftRadiusTablet'], 'px' ) . ' !important',
					'border-bottom-right-radius' => self::get_css_value( $attr['parentBlockBorderBottomRadiusTablet'], 'px' ) . ' !important',
				),
			);

			if ( 'accordion' === $attr['layout'] && true === $attr['inactiveOtherItems'] ) {
				$selectors = array_merge(
					$selectors,
					array(
						' .responsive-block-editor-addons-accordion-item__outer-wrap .responsive-block-editor-addons-accordion-content' => array(
							'display' => 'none',
						),
					)
				);
			}

			if ( 'accordion' === $attr['layout'] && true === $attr['expandFirstItem'] ) {
				$selectors = array_merge(
					$selectors,
					array(
						'  .responsive-block-editor-addons-accordion__wrap > div:first-child > .responsive-block-editor-addons-accordion-item__outer-wrap .responsive-block-editor-addons-accordion-content' => array(
							'display' => 'block',
						),
						'  .responsive-block-editor-addons-accordion__wrap > div:first-child > .responsive-block-editor-addons-accordion-item__outer-wrap .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-icon-active' => array(
							'display' => 'inline-block',
						),
						'  .responsive-block-editor-addons-accordion__wrap > div:first-child > .responsive-block-editor-addons-accordion-item__outer-wrap .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-icon' => array(
							'display' => 'none',
						),
					)
				);
			}
			if ( 'grid' === $attr['layout'] ) {
				$selectors = array_merge(
					$selectors,
					array(
						'  .responsive-block-editor-addons-accordion-item__outer-wrap' => array(
							'text-align' => $attr['align'],
						),
						'   .responsive-block-editor-addons-accordion__wrap.responsive-block-editor-addons-buttons-layout-wrap' => array(
							'grid-template-columns' => 'repeat(' . $attr['columns'] . ', 1fr)',
							'display'               => 'grid',
						),
						'  > div:first-child > .responsive-block-editor-addons-accordion-item__outer-wrap .responsive-block-editor-addons-accordion-item .responsive-block-editor-addons-accordion-titles-button .responsive-block-editor-addons-icon' => array(
							'display' => 'none',
						),
					)
				);
			}

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-accordion__outer-wrap.responsive-block-editor-addons-block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for Accordian block
		 *
		 * @return array
		 */
		public static function get_responsive_block_accordian_block_default_attributes() {
			return array(
				'block_id'                            => '',
				'layout'                              => 'accordion',
				'inactiveOtherItems'                  => true,
				'expandFirstItem'                     => false,
				'z_index'                             => 1,
				'z_indexTablet'                       => 1,
				'z_indexMobile'                       => 1,
				'enableSchemaSupport'                 => false,
				'align'                               => 'left',
				'rowsGap'                             => 10,
				'columnsGap'                          => 10,
				'rowsGapMobile'                       => 10,
				'columnsGapMobile'                    => 10,
				'rowsGapTablet'                       => 10,
				'columnsGapTablet'                    => 10,
				'boxPaddingTypeMobile'                => 'px',
				'boxPaddingTypeTablet'                => 'px',
				'boxPaddingTypeDesktop'               => 'px',
				'vBoxPaddingMobile'                   => 10,
				'hBoxPaddingMobile'                   => 10,
				'vBoxPaddingTablet'                   => 10,
				'hBoxPaddingTablet'                   => 10,
				'vBoxPaddingDesktop'                  => 10,
				'hBoxPaddingDesktop'                  => 10,
				'titleTextColor'                      => '#313131',
				'titleTextActiveColor'                => '#656565',
				'titlePaddingTypeDesktop'             => 'px',
				'vtitlePaddingMobile'                 => 10,
				'vtitlePaddingTablet'                 => 10,
				'vtitlePaddingDesktop'                => 10,
				'htitlePaddingMobile'                 => 10,
				'htitlePaddingTablet'                 => 10,
				'htitlePaddingDesktop'                => 10,
				'contentTextColor'                    => '#313131',
				'contentPaddingTypeDesktop'           => 'px',
				'vcontentPaddingMobile'               => 10,
				'vcontentPaddingTablet'               => 10,
				'vcontentPaddingDesktop'              => 10,
				'hcontentPaddingMobile'               => 10,
				'hcontentPaddingTablet'               => 10,
				'hcontentPaddingDesktop'              => 10,
				'titleActiveTextColor'                => '',
				'titleActiveBackgroundColor'          => '',
				'iconColor'                           => '',
				'iconActiveColor'                     => '',
				'titleFontWeight'                     => '',
				'titleFontSize'                       => '',
				'titleLineHeight'                     => '',
				'titleFontFamily'                     => '',
				'contentFontFamily'                   => '',
				'contentFontWeight'                   => '',
				'contentFontSize'                     => '',
				'contentLineHeight'                   => '',
				'icon'                                => 'fas fa-plus',
				'iconActive'                          => 'fas fa-minus',
				'iconAlign'                           => 'row',
				'iconSize'                            => 12,
				'iconSizeTablet'                      => 12,
				'iconSizeMobile'                      => 12,
				'iconSizeType'                        => 'px',
				'columns'                             => 2,
				'schema'                              => '',
				'enableToggle'                        => true,
				'equalHeight'                         => true,
				'titleLeftPaddingTablet'              => 10,
				'titleBottomPaddingTablet'            => 10,
				'titleLeftPaddingDesktop'             => 10,
				'titleBottomPaddingDesktop'           => 10,
				'titleLeftPaddingMobile'              => 10,
				'titleBottomPaddingMobile'            => 10,
				'headingTag'                          => 'span',
				'titleBackgroundColorOpacity'         => 100,
				'marginV'                             => '',
				'marginH'                             => '',
				'marginVMobile'                       => '',
				'marginHMobile'                       => '',
				'marginVTablet'                       => '',
				'marginHTablet'                       => '',
				'titleSecondaryBackgroundColor'       => '',
				'titleGradientDegree'                 => 100,
				'titleBgGradient'                     => false,
				'titleBackgroundColor'                => '#ffffff',
				'contentSecondaryBackgroundColor'     => '',
				'contentGradientDegree'               => 100,
				'contentBgGradient'                   => false,
				'contentBackgroundColor'              => '#eeeeee',
				'contentBackgroundColorOpacity'       => 100,
				'borderStyle'                         => 'solid',
				'borderColor'                         => '',
				'borderRadius'                        => 2,
				'borderWidth'                         => 1,
				'titleFontSizeMobile'                 => '',
				'titleFontSizeTablet'                 => '',
				'contentFontSizeMobile'               => '',
				'contentFontSizeTablet'               => '',
				'hideWidgetTablet'                    => false,
				'hideWidgetMobile'                    => false,
				'hideWidget'                          => false,
				'parentBlockBorderStyle'              => 'solid',
				'parentBlockBorderColor'              => 'black',
				'parentBlockBorderTopWidth'           => 1,
				'parentBlockBorderBottomWidth'        => 1,
				'parentBlockBorderLeftWidth'          => 1,
				'parentBlockBorderRightWidth'         => 1,
				'parentBlockBorderTopWidthTablet'     => 1,
				'parentBlockBorderBottomWidthTablet'  => 1,
				'parentBlockBorderLeftWidthTablet'    => 1,
				'parentBlockBorderRightWidthTablet'   => 1,
				'parentBlockBorderTopWidthMobile'     => 1,
				'parentBlockBorderBottomWidthMobile'  => 1,
				'parentBlockBorderLeftWidthMobile'    => 1,
				'parentBlockBorderRightWidthMobile'   => 1,
				'parentBlockBorderTopRadius'          => 0,
				'parentBlockBorderTopRadiusMobile'    => 0,
				'parentBlockBorderTopRadiusTablet'    => 0,
				'parentBlockBorderRightRadius'        => 0,
				'parentBlockBorderRightRadiusTablet'  => 0,
				'parentBlockBorderRightRadiusMobile'  => 0,
				'parentBlockBorderLeftRadius'         => 0,
				'parentBlockBorderLeftRadiusTablet'   => 0,
				'parentBlockBorderLeftRadiusMobile'   => 0,
				'parentBlockBorderBottomRadius'       => 0,
				'parentBlockBorderBottomRadiusMobile' => 0,
				'parentBlockBorderBottomRadiusTablet' => 0,
				'titleTopSpacing'                     => 10,
				'titleTopSpacingMobile'               => 10,
				'titleTopSpacingTablet'               => 10,
				'titleBottomSpacing'                  => 10,
				'titleBottomSpacingMobile'            => 10,
				'titleBottomSpacingTablet'            => 10,
				'titleLeftSpacing'                    => 10,
				'titleLeftSpacingMobile'              => 10,
				'titleLeftSpacingTablet'              => 10,
				'titleRightSpacing'                   => 10,
				'titleRightSpacingMobile'             => 10,
				'titleRightSpacingTablet'             => 10,
				// content spacing.
				'contentTopSpacing'                   => 10,
				'contentTopSpacingMobile'             => 10,
				'contentTopSpacingTablet'             => 10,
				'contentBottomSpacing'                => 10,
				'contentBottomSpacingMobile'          => 10,
				'contentBottomSpacingTablet'          => 10,
				'contentLeftSpacing'                  => 10,
				'contentLeftSpacingMobile'            => 10,
				'contentLeftSpacingTablet'            => 10,
				'contentRightSpacing'                 => 10,
				'contentRightSpacingMobile'           => 10,
				'contentRightSpacingTablet'           => 10,
				'blockTopPadding'                     => '',
				'blockTopPaddingMobile'               => '',
				'blockTopPaddingTablet'               => '',
				'blockBottomPadding'                  => '',
				'blockBottomPaddingMobile'            => '',
				'blockBottomPaddingTablet'            => '',
				'blockLeftPadding'                    => '',
				'blockLeftPaddingMobile'              => '',
				'blockLeftPaddingTablet'              => '',
				'blockRightPadding'                   => '',
				'blockRightPaddingMobile'             => '',
				'blockRightPaddingTablet'             => '',
				'blockTopMargin'                      => '',
				'blockTopMarginMobile'                => '',
				'blockTopMarginTablet'                => '',
				'blockBottomMargin'                   => '',
				'blockBottomMarginMobile'             => '',
				'blockBottomMarginTablet'             => '',
				'blockLeftMargin'                     => '',
				'blockLeftMarginMobile'               => '',
				'blockLeftMarginTablet'               => '',
				'blockRightMargin'                    => '',
				'blockRightMarginMobile'              => '',
				'blockRightMarginTablet'              => '',
				'contentTypographyColor'              => '#313131',
				'titleTypographyColor'                => '#313131',
				'blockTitleLeftPadding'               => 10,
				'blockTitleLeftPaddingTablet'         => 10,
				'blockTitleLeftPaddingMobile'         => 10,
				'blockTitleTopPadding'                => 10,
				'blockTitleTopPaddingTablet'          => 10,
				'blockTitleTopPaddingMobile'          => 10,
				'blockTitleBottomPadding'             => 10,
				'blockTitleBottomPaddingTablet'       => 10,
				'blockTitleBottomPaddingMobile'       => 10,
				'blockTitleRightPadding'              => 10,
				'blockTitleRightPaddingTablet'        => 10,
				'blockTitleRightPaddingMobile'        => 10,
				'contentLeftPadding'                  => 10,
				'contentLeftPaddingTablet'            => 10,
				'contentLeftPaddingMobile'            => 10,
				'contentTopPadding'                   => 10,
				'contentTopPaddingTablet'             => 10,
				'contentTopPaddingMobile'             => 10,
				'contentBottomPadding'                => 10,
				'contentBottomPaddingTablet'          => 10,
				'contentBottomPaddingMobile'          => 10,
				'contentRightPadding'                 => 10,
				'contentRightPaddingTablet'           => 10,
				'contentRightPaddingMobile'           => 10,
				'titleTextTransform'                  => '',
				'titleFontStyle'                      => '',
				'contentTextTransform'                => '',
				'contentFontStyle'                    => '',
			);
		}

		/**
		 * Get Accordian Child Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_accordian_child_css( $attr, $id ) {
			$defaults         = self::get_responsive_block_accordian_child_block_default_attributes();
			$attr             = array_merge( $defaults, (array) $attr );
			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$selectors = array(
				' ' => array(
					'box-shadow' =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
					'overflow'   => 'hidden',

				),
				':hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? 
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',

				),
				' .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles' => array(
					'box-shadow' => 'inset' === $box_shadow_position_css ?
						$box_shadow_position_css .
						' ' .
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] : '',
				),
				' .responsive-block-editor-addons-accordion-titles-button.responsive-block-editor-addons-accordion-titles:hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? ('inset' === $hover_box_shadow_position_css ?
						$hover_box_shadow_position_css .
						' ' .
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] : '') : '',
				),
				' .responsive-block-editor-addons-accordion-content span' => array(
					'margin' => '0',
				),
			);
			$mobile_selectors = array();

			$tablet_selectors = array();

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-accordion-item__outer-wrap.responsive-block-editor-addons-block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for Accordian Child block
		 *
		 * @return array
		 */
		public static function get_responsive_block_accordian_child_block_default_attributes() {
			return array(
				'block_id'               => '',
				'title'                  => 'What is Accordion?',
				'content'                => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
				'icon'                   => 'fas fa-plus',
				'iconActive'             => 'fas fa-minus',
				'layout'                 => 'accordion',
				'headingTag'             => 'span',
				'blockBorderStyle'       => 'solid',
				'blockBorderColor'       => 'black',
				'blockBorderWidth'       => 1,
				'blockBorderRadius'      => 2,
				'boxShadowColor'         => '',
				'boxShadowHOffset'       => 0,
				'boxShadowVOffset'       => 0,
				'boxShadowBlur'          => 0,
				'boxShadowSpread'        => 0,
				'boxShadowPosition'      => 'outset',
				'hoverboxShadowColor'    => '',
				'hoverboxShadowHOffset'  => 0,
				'hoverboxShadowVOffset'  => 0,
				'hoverboxShadowBlur'     => 0,
				'hoverboxShadowSpread'   => 0,
				'hoverboxShadowPosition' => 'outset',
				'titlePadding'           => 10,
				'contentPadding'         => 10,
				'titlePaddingMobile'     => '',
				'contentPaddingMobile'   => '',
				'titlePaddingTablet'     => '',
				'contentPaddingTablet'   => '',
				'borderColor'            => 'empty', // For compatibility with v1.3.2.
				'borderStyle'            => 'empty', // For compatibility with v1.3.2.
				'borderWidth'            => 999, // For compatibility with v1.3.2.
				'borderRadius'           => 999, // For compatibility with v1.3.2.
			);
		}

		/**
		 * Get Defaults for advanced heading block
		 *
		 * @return array
		 */
		public static function get_responsive_block_advanced_heading_default_attributes() {
			return array(
				'block_id'                           => '',
				'headingTitle'                       => '',
				'headingDesc'                        => '',
				'seperatorStyle'                     => 'solid',
				'separatorWidthType'                 => '%',
				'separatorColor'                     => '',
				'headingTitleColor'                  => '',
				'subHeadingTitleColor'               => '',
				'headingTitleFontFamily'             => '',
				'subHeadingTitleFontFamily'          => '',
				'headingTitleFontSize'               => '',
				'subHeadingTitleFontSize'            => '',
				'headingTitleFontSizeTablet'         => '',
				'subHeadingTitleFontSizeTablet'      => '',
				'headingTitleFontSizeMobile'         => '',
				'subHeadingTitleFontSizeMobile'      => '',
				'headingTitleFontWeight'             => '600',
				'subHeadingTitleFontWeight'          => '400',
				'headingTag'                         => 'h2',
				'headingAlignment'                   => 'center',
				'headingAlignmentTablet'             => 'center',
				'headingAlignmentMobile'             => 'center',
				'showHeading'                        => true,
				'showSubHeading'                     => true,
				'showSeparator'                      => true,
				'separatorHeight'                    => 3,
				'separatorWidth'                     => 20,
				'headSpacing'                        => 15,
				'subheadSpacing'                     => 15,
				'separatorSpacing'                   => 15,
				'headSpacingTablet'                  => 15,
				'subheadSpacingTablet'               => 15,
				'separatorSpacingTablet'             => 15,
				'headSpacingMobile'                  => 15,
				'subheadSpacingMobile'               => 15,
				'separatorSpacingMobile'             => 15,
				'headingTitleLineHeight'             => 1,
				'subHeadingTitleLineHeight'          => 1,
				'headingTitleLetterSpacing'          => 0,
				'subHeadingTitleLetterSpacing'       => 0,
				'level'                              => 2,
				'textDecoration'                     => 'none',
				'textDecorationSubHeading'           => 'none',
				'hideWidgetTablet'                   => false,
				'hideWidgetMobile'                   => false,
				'hideWidget'                         => false,
				'z_index'                            => 1,
				'z_indexTablet'                      => 1,
				'z_indexMobile'                      => 1,
				'blockTopPadding'                    => 10,
				'blockTopPaddingMobile'              => '',
				'blockTopPaddingTablet'              => '',
				'blockBottomPadding'                 => 10,
				'blockBottomPaddingMobile'           => '',
				'blockBottomPaddingTablet'           => '',
				'blockLeftPadding'                   => 10,
				'blockLeftPaddingMobile'             => '',
				'blockLeftPaddingTablet'             => '',
				'blockRightPadding'                  => 10,
				'blockRightPaddingMobile'            => '',
				'blockRightPaddingTablet'            => '',
				'blockTopMargin'                     => 0,
				'blockBottomMargin'                  => 0,
				'blockLeftMargin'                    => 0,
				'blockRightMargin'                   => 0,
				'blockTopMarginTablet'               => '',
				'blockBottomMarginTablet'            => '',
				'blockLeftMarginTablet'              => '',
				'blockRightMarginTablet'             => '',
				'blockTopMarginMobile'               => '',
				'blockBottomMarginMobile'            => '',
				'blockLeftMarginMobile'              => '',
				'blockRightMarginMobile'             => '',
				'topMargin'                          => 999,
				'bottomMargin'                       => 999,
				'leftMargin'                         => 999,
				'rightMargin'                        => 999,
				'topPadding'                         => 999,
				'bottomPadding'                      => 999,
				'leftPadding'                        => 999,
				'rightPadding'                       => 999,
				'topMarginMobile'                    => 999,
				'bottomMarginMobile'                 => 999,
				'leftMarginMobile'                   => 999,
				'rightMarginMobile'                  => 999,
				'topPaddingMobile'                   => 999,
				'bottomPaddingMobile'                => 999,
				'leftPaddingMobile'                  => 999,
				'rightPaddingMobile'                 => 999,
				'topMarginTablet'                    => 999,
				'bottomMarginTablet'                 => 999,
				'leftMarginTablet'                   => 999,
				'rightMarginTablet'                  => 999,
				'topPaddingTablet'                   => 999,
				'bottomPaddingTablet'                => 999,
				'leftPaddingTablet'                  => 999,
				'rightPaddingTablet'                 => 999,
				'blockIsTypographyColorValueUpdated' => false,
				'blockIsBottomSpacingValueUpdated'   => false,
				'subHeadingTitleTypographyColor'     => '',
				'headingTitleTypographyColor'        => '',
				'headingTitleBottomSpacing'          => 15,
				'headingTitleBottomSpacingMobile'    => 15,
				'headingTitleBottomSpacingTablet'    => 15,
				'subHeadingTitleBottomSpacing'       => 15,
				'subHeadingTitleBottomSpacingMobile' => 15,
				'subHeadingTitleBottomSpacingTablet' => 15,
				'headingTitleTextDecoration'         => 'none',
				'subHeadingTitleTextDecoration'      => 'none',
				'widthType'                          => '%',
				'headingTitleTextTransform'          => '',
				'headingTitleFontStyle'              => '',
				'subHeadingTitleTextTransform'       => '',
				'subHeadingTitleFontStyle'           => '',
			);
		}

		/**
		 * Get Advanced column child Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_advanced_column_child_css( $attr, $id ) {
			$defaults = self::get_responsive_block_advanced_column_child_block_default_attributes();

			$new_spacing_attribute_keys = array(
				'columnTopPadding'          => 'topPadding',
				'columnTopPaddingTablet'    => 'topPaddingTablet',
				'columnTopPaddingMobile'    => 'topPaddingMobile',
				'columnBottomPadding'       => 'bottomPadding',
				'columnBottomPaddingTablet' => 'bottomPaddingTablet',
				'columnBottomPaddingMobile' => 'bottomPaddingMobile',
				'columnLeftPadding'         => 'leftPadding',
				'columnLeftPaddingTablet'   => 'leftPaddingTablet',
				'columnLeftPaddingMobile'   => 'leftPaddingMobile',
				'columnRightPadding'        => 'rightPadding',
				'columnRightPaddingTablet'  => 'rightPaddingTablet',
				'columnRightPaddingMobile'  => 'rightPaddingMobile',
				'columnTopMargin'           => 'topMargin',
				'columnTopMarginTablet'     => 'topMarginTablet',
				'columnTopMarginMobile'     => 'topMarginMobile',
				'columnBottomMargin'        => 'bottomMargin',
				'columnBottomMarginTablet'  => 'bottomMarginTablet',
				'columnBottomMarginMobile'  => 'bottomMarginMobile',
				'columnLeftMargin'          => 'leftMargin',
				'columnLeftMarginTablet'    => 'leftMarginTablet',
				'columnLeftMarginMobile'    => 'leftMarginMobile',
				'columnRightMargin'         => 'rightMargin',
				'columnRightMarginTablet'   => 'rightMarginTablet',
				'columnRightMarginMobile'   => 'rightMarginMobile',
				'blockTopRadius'            => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'           => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'      => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'     => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'      => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'     => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$background_keys = array(
				'backgroundRepeat'         => 'backgroundImageRepeat' ? 'backgroundImageRepeat' : 'backgroundRepeat',
				'backgroundPosition'       => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPosition',
				'backgroundPositionMobile' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionMobile',
				'backgroundPositionTablet' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionTablet',
				'backgroundSize'           => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSize',
				'backgroundSizeMobile'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeMobile',
				'backgroundSizeTablet'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeTablet',
			);

			// To populate new control values with existing background control values for backward compatibility.
			foreach ( $background_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity              = $attr['opacity'] / 100 === 0 ? '0.0' : $attr['opacity'] / 100; //phpcs:ignore
			$column_width            = $attr['width'] . '%';
			$box_shadow_position_css = $attr['boxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			$hoverbox_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hoverbox_shadow_position_css = '';
			}

			$background_type_image_styles       = array();
			$background_type_image_hover_styles = array();
			if ( 'image' === $attr['backgroundType'] && $attr['backgroundImage'] ) {

				if ( 'gradient' === $attr['overlayType'] && 'linear' === $attr['gradientOverlayType'] ) {
					$background_type_image_styles       = array(
						'background-image' => self::generate_background_image_effect(
							self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ),
							self::hex_to_rgb( $attr['gradientOverlayColor2'], $imgopacity ),
							$attr['gradientOverlayAngle'],
							$attr['gradientOverlayLocation1'],
							$attr['gradientOverlayLocation2']
						) . ',url(' . $attr['backgroundImage'] . ')',
					);
					$background_type_image_hover_styles = array(
						'background-image' => $attr['backgroundHoverImage'] ? self::generate_background_image_effect(
							self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ),
							self::hex_to_rgb( $attr['gradientOverlayColor2'], $imgopacity ),
							$attr['gradientOverlayAngle'],
							$attr['gradientOverlayLocation1'],
							$attr['gradientOverlayLocation2']
						) . ',url(' . $attr['backgroundHoverImage'] . ')' : null,
					);
				} elseif ( 'gradient' === $attr['overlayType'] && 'radial' === $attr['gradientOverlayType'] ) {
					$background_type_image_styles       = array(
						'background-image' => 'radial-gradient( at ' . $attr['gradientOverlayPosition'] . ','
							. self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ) .
							' ' . $attr['gradientOverlayLocation1'] . '%,' . self::hex_to_rgb( $attr['gradientOverlayColor2'] ? $attr['gradientOverlayColor2'] : '#fff', $imgopacity ) .
							' ' . $attr['gradientOverlayLocation2'] . '%),url(' . $attr['backgroundImage'] . ')',
					);
					$background_type_image_hover_styles = array(
						'background-image' => $attr['backgroundHoverImage'] ? 'radial-gradient( at ' . $attr['gradientOverlayPosition'] . ','
							. self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ) .
							' ' . $attr['gradientOverlayLocation1'] . '%,' . self::hex_to_rgb( $attr['gradientOverlayColor2'] ? $attr['gradientOverlayColor2'] : '#fff', $imgopacity ) .
							' ' . $attr['gradientOverlayLocation2'] . '%),url(' . $attr['backgroundHoverImage'] . ')' : null,
					);
				} else {
					$background_type_image_styles       = array(
						'background-image' => 'linear-gradient(' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . ',' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . '),url(' . $attr['backgroundImage'] . ')',
					);
					$background_type_image_hover_styles = array(
						'background-image' => $attr['backgroundHoverImage'] ? 'linear-gradient(' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . ',' . self::hex_to_rgb( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) . '),url(' . $attr['backgroundHoverImage'] . ')' : null,
					);
				}
				$background_type_image_styles       = array_merge(
					$background_type_image_styles,
					array(
						'background-position'   => 'empty' !== $attr['backgroundPosition'] && 'center center' === $attr['backgroundImagePosition'] ? $attr['backgroundPosition'] : $attr['backgroundImagePosition'], // For compatibility with v1.3.2.
						'background-attachment' => $attr['backgroundAttachment'],
						'background-repeat'     => 'empty' !== $attr['backgroundRepeat'] && 'no-repeat' === $attr['backgroundImageRpeat'] ? $attr['backgroundRepeat'] : $attr['backgroundImageRepeat'], // For compatibility with v1.3.2.
						'background-size'       => 'empty' !== $attr['backgroundSize'] && 'cover' === $attr['backgroundImageSize'] ? $attr['backgroundSize'] : $attr['backgroundImageSize'], // For compatibility with v1.3.2.
					)
				);
				$background_type_image_styles       = array_merge(
					$background_type_image_styles,
					array(
						'background-position'   => 'empty' !== $attr['backgroundPosition'] && 'center center' === $attr['backgroundImagePosition'] ? $attr['backgroundPosition'] : $attr['backgroundImagePosition'], // For compatibility with v1.3.2.
						'background-attachment' => $attr['backgroundAttachment'],
						'background-repeat'     => 'empty' !== $attr['backgroundRepeat'] && 'no-repeat' === $attr['backgroundImageRpeat'] ? $attr['backgroundRepeat'] : $attr['backgroundImageRepeat'], // For compatibility with v1.3.2.
						'background-size'       => 'empty' !== $attr['backgroundSize'] && 'cover' === $attr['backgroundImageSize'] ? $attr['backgroundSize'] : $attr['backgroundImageSize'], // For compatibility with v1.3.2.
					)
				);
				$background_type_image_styles       = array_merge(
					$background_type_image_styles,
					array(
						'background-position'   => 'empty' !== $attr['backgroundPosition'] && 'center center' === $attr['backgroundImagePosition'] ? $attr['backgroundPosition'] : $attr['backgroundImagePosition'], // For compatibility with v1.3.2.
						'background-attachment' => $attr['backgroundAttachment'],
						'background-repeat'     => 'empty' !== $attr['backgroundRepeat'] && 'no-repeat' === $attr['backgroundImageRpeat'] ? $attr['backgroundRepeat'] : $attr['backgroundImageRepeat'], // For compatibility with v1.3.2.
						'background-size'       => 'empty' !== $attr['backgroundSize'] && 'cover' === $attr['backgroundImageSize'] ? $attr['backgroundSize'] : $attr['backgroundImageSize'], // For compatibility with v1.3.2.
					)
				);
				$background_type_image_hover_styles = array_merge(
					$background_type_image_hover_styles,
					array(
						'background-position'   => $attr['backgroundImageHoverPosition'],
						'background-attachment' => $attr['backgroundImageHoverAttachment'],
						'background-repeat'     => $attr['backgroundImageHoverRepeat'],
						'background-size'       => $attr['backgroundImageHoverSize'],
					)
				);
			}
			$selectors = array(
				'' => array(
					'width' => $column_width,
				),
				'> .responsive-block-editor-addons-block-column' => array_merge(
					array(
						'padding-top'                => self::get_css_value( $attr['columnTopPadding'], 'px' ),
						'padding-right'              => self::get_css_value( $attr['columnRightPadding'], 'px' ),
						'padding-bottom'             => self::get_css_value( $attr['columnBottomPadding'], 'px' ),
						'padding-left'               => self::get_css_value( $attr['columnLeftPadding'], 'px' ),
						'margin-top'                 => self::get_css_value( $attr['columnTopMargin'], 'px' ),
						'margin-right'               => self::get_css_value( $attr['columnRightMargin'], 'px' ),
						'margin-bottom'              => self::get_css_value( $attr['columnBottomMargin'], 'px' ),
						'margin-left'                => self::get_css_value( $attr['columnLeftMargin'], 'px' ),
						'box-shadow'                 => self::get_css_value( $attr['boxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['boxShadowSpread'], 'px' ) . ' ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
						'background-color'           => 'color' === $attr['backgroundType'] ? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ) : '',
						'background-image'           => 'gradient' === $attr['backgroundType'] ? self::generate_background_image_effect(
							self::hex_to_rgb( $attr['backgroundColor1'], $imgopacity ),
							self::hex_to_rgb( $attr['backgroundColor2'], $imgopacity ),
							$attr['gradientDirection'],
							$attr['colorLocation1'],
							$attr['colorLocation2']
						) : '',
						'border-style'               => $attr['blockBorderStyle'],
						'border-color'               => $attr['blockBorderColor'],
						'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ) . ' !important',
						'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ) . ' !important',
						'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ) . ' !important',
						'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ) . ' !important',
						'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),

					),
					$background_type_image_styles
				),
				'> .responsive-block-editor-addons-block-column:hover' => array_merge(
					array(
						'box-shadow'       => '' !== $attr['hoverboxShadowColor'] ? self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) . ' ' . self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) . ' ' . $attr['hoverboxShadowColor'] . ' ' . $hoverbox_shadow_position_css : '',
						'background-image' => 'gradient' === $attr['backgroundType'] ? self::generate_background_image_effect(
							self::hex_to_rgb( $attr['hoverbackgroundColor1'], $imgopacity ),
							self::hex_to_rgb( $attr['hoverbackgroundColor2'], $imgopacity ),
							$attr['hovergradientDirection'],
							$attr['hovercolorLocation1'],
							$attr['hovercolorLocation2']
						) : '',
						'background-color' => 'color' === $attr['backgroundType'] && '' !== $attr['backgroundColorHover'] ? self::hex_to_rgb( $attr['backgroundColorHover'] ? $attr['backgroundColorHover'] : '#fff', $imgopacity ) : '',
					),
					$background_type_image_hover_styles
				),
			);
			$mobile_selectors = array(
				'> .responsive-block-editor-addons-block-column' => array(
					'padding-top'                => self::get_css_value( $attr['columnTopPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['columnRightPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['columnBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['columnLeftPaddingMobile'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['columnTopMarginMobile'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['columnRightMarginMobile'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['columnBottomMarginMobile'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['columnLeftMarginMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ) . ' !important',
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ) . ' !important',
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ) . ' !important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ) . ' !important',
				),
			);

			$tablet_selectors = array(
				'> .responsive-block-editor-addons-block-column' => array(
					'padding-top'                => self::get_css_value( $attr['columnTopPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['columnRightPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['columnBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['columnLeftPaddingTablet'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['columnTopMarginTablet'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['columnRightMarginTablet'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['columnBottomMarginTablet'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['columnLeftMarginTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ) . ' !important',
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ) . ' !important',
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ) . ' !important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ) . ' !important',
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-advanced-column-child.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for advanced column child block
		 *
		 * @return array
		 */
		public static function get_responsive_block_advanced_column_child_block_default_attributes() {
			return array(
				'width'                          => '',
				'topPadding'                     => '',
				'bottomPadding'                  => '',
				'leftPadding'                    => '',
				'rightPadding'                   => '',
				'leftMargin'                     => '',
				'rightMargin'                    => '',
				'topMargin'                      => '',
				'bottomMargin'                   => '',
				'topPaddingTablet'               => '',
				'bottomPaddingTablet'            => '',
				'leftPaddingTablet'              => '',
				'rightPaddingTablet'             => '',
				'leftMarginTablet'               => '',
				'rightMarginTablet'              => '',
				'topMarginTablet'                => '',
				'bottomMarginTablet'             => '',
				'topPaddingMobile'               => '',
				'bottomPaddingMobile'            => '',
				'leftPaddingMobile'              => '',
				'rightPaddingMobile'             => '',
				'leftMarginMobile'               => '',
				'rightMarginMobile'              => '',
				'topMarginMobile'                => '',
				'bottomMarginMobile'             => '',
				'block_id'                       => '',
				'blockBorderStyle'               => 'none',
				'blockBorderWidth'               => 1,
				'blockBorderRadius'              => '',
				'blockTopRadiusMobile'           => 0,
				'blockRightRadiusMobile'         => 0,
				'blockBottomRadiusMobile'        => 0,
				'blockLeftRadiusMobile'          => 0,
				'blockTopRadiusTablet'           => 0,
				'blockRightRadiusTablet'         => 0,
				'blockBottomRadiusTablet'        => 0,
				'blockLeftRadiusTablet'          => 0,
				'blockTopRadius'                 => 0,
				'blockRightRadius'               => 0,
				'blockBottomRadius'              => 0,
				'blockLeftRadius'                => 0,
				'blockBorderColor'               => '',
				'boxShadowColor'                 => '',
				'boxShadowHOffset'               => 0,
				'boxShadowVOffset'               => 0,
				'boxShadowBlur'                  => 0,
				'boxShadowSpread'                => 0,
				'boxShadowPosition'              => 'outset',
				'hoverboxShadowColor'            => '',
				'hoverboxShadowHOffset'          => 0,
				'hoverboxShadowVOffset'          => 0,
				'hoverboxShadowBlur'             => 6,
				'hoverboxShadowSpread'           => 1,
				'hoverboxShadowPosition'         => 'outset',
				'opacity'                        => 20,
				'colorLocation1'                 => 0,
				'colorLocation2'                 => 100,
				'gradientDirection'              => 90,
				'hovercolorLocation1'            => 0,
				'hovercolorLocation2'            => 100,
				'hovergradientDirection'         => 90,
				'backgroundImage'                => '',
				'backgroundImagePosition'        => 'center center',
				'backgroundImageSize'            => 'cover',
				'backgroundImageRepeat'          => 'no-repeat',
				'backgroundAttachment'           => 'scroll',
				'backgroundImageColor'           => '',
				'overlayType'                    => 'color',
				'gradientOverlayColor1'          => '',
				'gradientOverlayColor2'          => '',
				'gradientOverlayType'            => 'linear',
				'gradientOverlayLocation1'       => 0,
				'gradientOverlayLocation2'       => 100,
				'gradientOverlayAngle'           => 0,
				'gradientOverlayPosition'        => 'center center',
				'backgroundType'                 => '',
				'backgroundColor'                => '',
				'backgroundColorHover'           => '',
				'backgroundColor1'               => '',
				'backgroundColor2'               => '#fff',
				'hoverbackgroundColor1'          => '',
				'hoverbackgroundColor2'          => '#fff',
				'backgroundPosition'             => 'empty', // For compatibility with v1.3.2.
				'backgroundRepeat'               => 'empty', // For compatibility with v1.3.2.
				'backgroundSize'                 => 'empty', // For compatibility with v1.3.2.
				'backgroundHoverImage'           => '',
				'backgroundImageHoverPosition'   => '',
				'backgroundImageHoverRepeat'     => '',
				'backgroundImageHoverAttachment' => '',
				'backgroundImageHoverSize'       => '',
				'columnTopPadding'               => 0,
				'columnTopPaddingTablet'         => 0,
				'columnTopPaddingMobile'         => 0,
				'columnBottomPadding'            => 0,
				'columnBottomPaddingTablet'      => 0,
				'columnBottomPaddingMobile'      => 0,
				'columnLeftPadding'              => 0,
				'columnLeftPaddingTablet'        => 0,
				'columnLeftPaddingMobile'        => 0,
				'columnRightPadding'             => 0,
				'columnRightPaddingTablet'       => 0,
				'columnRightPaddingMobile'       => 0,
				'columnTopMargin'                => 0,
				'columnTopMarginTablet'          => 0,
				'columnTopMarginMobile'          => 0,
				'columnBottomMargin'             => 0,
				'columnBottomMarginTablet'       => 0,
				'columnBottomMarginMobile'       => 0,
				'columnLeftMargin'               => 0,
				'columnLeftMarginTablet'         => 0,
				'columnLeftMarginMobile'         => 0,
				'columnRightMargin'              => 0,
				'columnRightMarginTablet'        => 0,
				'columnRightMarginMobile'        => 0,
				'backgroundPositionMobile'       => 'empty',
				'backgroundSizeMobile'           => 'empty',
				'backgroundPositionTablet'       => 'empty',
				'backgroundSizeTablet'           => 'empty',
			);
		}

		/**
		 * Get Buttons Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_buttons_css( $attr, $id ) {
			$defaults = self::get_responsive_block_buttons_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-buttons.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for buttons block
		 *
		 * @return array
		 */
		public static function get_responsive_block_buttons_default_attributes() {
			return array(
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
			);
		}

		/**
		 * Get Buttons Child Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_buttons_child_css( $attr, $id ) {
			$defaults = self::get_responsive_block_buttons_child_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$new_margin_padding_keys = array(
				'blockTopPadding'          => 'vPadding' ? 'vPadding' : '',
				'blockRightPadding'        => 'hPadding' ? 'hPadding' : '',
				'blockBottomPadding'       => 'vPadding' ? 'vPadding' : '',
				'blockLeftPadding'         => 'hPadding' ? 'hPadding' : '',
				'blockTopPaddingTablet'    => 'vPaddingTablet' ? 'vPaddingTablet' : '',
				'blockBottomPaddingTablet' => 'vPaddingTablet' ? 'vPaddingTablet' : '',
				'blockRightPaddingTablet'  => 'hPaddingTablet' ? 'hPaddingTablet' : '',
				'blockLeftPaddingTablet'   => 'hPaddingTablet' ? 'hPaddingTablet' : '',
				'blockTopPaddingMobile'    => 'vPaddingMobile' ? 'vPaddingMobile' : '',
				'blockBottomPaddingMobile' => 'vPaddingMobile' ? 'vPaddingMobile' : '',
				'blockRightPaddingMobile'  => 'hPaddingMobile' ? 'hPaddingMobile' : '',
				'blockLeftPaddingMobile'   => 'hPaddingMobile' ? 'hPaddingMobile' : '',
				'blockTopMargin'           => 'vMargin' ? 'vMargin' : '',
				'blockBottomMargin'        => 'vMargin' ? 'vMargin' : '',
				'blockRightMargin'         => 'hMargin' ? 'hMargin' : '',
				'blockLeftMargin'          => 'hMargin' ? 'hMargin' : '',
				'blockTopMarginTablet'     => 'vMarginTablet' ? 'vMarginTablet' : '',
				'blockBottomMarginTablet'  => 'vMarginTablet' ? 'vMarginTablet' : '',
				'blockRightMarginTablet'   => 'hMarginTablet' ? 'hMarginTablet' : '',
				'blockLeftMarginTablet'    => 'hMarginTablet' ? 'hMarginTablet' : '',
				'blockTopMarginMobile'     => 'vMarginMobile' ? 'vMarginMobile' : '',
				'blockBottomMarginMobile'  => 'vMarginMobile' ? 'vMarginMobile' : '',
				'blockRightMarginMobile'   => 'hMarginMobile' ? 'hMarginMobile' : '',
				'blockLeftMarginMobile'    => 'hMarginMobile' ? 'hMarginMobile' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_margin_padding_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_block_radius_keys = array(
				'blockTopRadius'          => 'borderRadius' ? 'borderRadius' : 2,
				'blockRightRadius'        => 'borderRadius' ? 'borderRadius' : 2,
				'blockBottomRadius'       => 'borderRadius' ? 'borderRadius' : 2,
				'blockLeftRadius'         => 'borderRadius' ? 'borderRadius' : 2,
				'blockTopRadiusMobile'    => 'borderRadius' ? 'borderRadius' : 2,
				'blockRightRadiusMobile'  => 'borderRadius' ? 'borderRadius' : 2,
				'blockBottomRadiusMobile' => 'borderRadius' ? 'borderRadius' : 2,
				'blockLeftRadiusMobile'   => 'borderRadius' ? 'borderRadius' : 2,
				'blockTopRadiusTablet'    => 'borderRadius' ? 'borderRadius' : 2,
				'blockRightRadiusTablet'  => 'borderRadius' ? 'borderRadius' : 2,
				'blockBottomRadiusTablet' => 'borderRadius' ? 'borderRadius' : 2,
				'blockLeftRadiusTablet'   => 'borderRadius' ? 'borderRadius' : 2,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_block_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity = $attr['opacity'] / 100;

			$typography_opacity_control_value = $attr['typographyOpacity'] / 100;

			$border_opacity_control_value = $attr['borderOpacity'] / 100;

			$box_shadow_position_css = $attr['boxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$icon_space_right = '';
			if ( 'before' === $attr['iconPosition'] ) {
				$icon_space_right = $attr['iconSpace'];
			}
			$icon_space_left = '';
			if ( 'after' === $attr['iconPosition'] ) {
				$icon_space_left = $attr['iconSpace'];
			}

			$updated_v_margin_tablet = '';
			if ( isset( $attr['vMarginTablet'] ) ) {
				$updated_v_margin_tablet = $attr['vMarginTablet'];
			}

			$updated_v_margin_mobile = '';
			if ( isset( $attr['vMarginMobile'] ) ) {
				$updated_v_margin_mobile = $attr['vMarginMobile'];
			}

			$updated_h__margin_tablet = '';
			if ( isset( $attr['hMarginTablet'] ) ) {
				$updated_h__margin_tablet = $attr['hMarginTablet'];
			}

			$updated_h_margin_mobile = '';
			if ( isset( $attr['hMarginMobile'] ) ) {
				$updated_h_margin_mobile = $attr['hMarginMobile'];
			}

			$updated_v__padding_tablet = '';
			if ( isset( $attr['vPaddingTablet'] ) ) {
				$updated_v__padding_tablet = $attr['vPaddingTablet'];
			}

			$updated_v_padding_mobile = '';
			if ( isset( $attr['vPaddingMobile'] ) ) {
				$updated_v_padding_mobile = $attr['vPaddingMobile'];
			}

			$updated_h_padding_tablet = '';
			if ( isset( $attr['hPaddingTablet'] ) ) {
				$updated_h_padding_tablet = $attr['hPaddingTablet'];
			}

			$updated_h_padding_mobile = '';
			if ( isset( $attr['hPaddingMobile'] ) ) {
				$updated_h_padding_mobile = $attr['hPaddingMobile'];
			}

			$updated_background_color   = '';
			$updated_background_h_color = '';
			$updated_background_image   = '';
			if ( 'color' === $attr['backgroundType'] && ! $attr['inheritFromTheme'] ) {
				$updated_background_color   = $attr['background'];
				$updated_background_h_color = $attr['hbackground'];
			}

			$updated_border_color   = '';
			$updated_border_h_color = '';
			if ( $attr['borderColor'] && ! $attr['inheritFromTheme'] ) {
				$updated_border_color = $attr['borderColor'];
			}
			if ( $attr['borderHColor'] && ! $attr['inheritFromTheme'] ) {
				$updated_border_h_color = $attr['borderHColor'];
			}

			$updated_text_color   = '';
			$updated_text_h_color = '';
			if ( $attr['color'] && ! $attr['inheritFromTheme'] ) {
				$updated_text_color = $attr['color'];
			}
			if ( $attr['hColor'] && ! $attr['inheritFromTheme'] ) {
				$updated_text_h_color = $attr['hColor'];
			}

			if ( 'gradient' === $attr['backgroundType'] ) {
				$updated_background_image = self::generate_background_image_effect(
					$attr['backgroundColor1'],
					$attr['backgroundColor2'],
					$attr['gradientDirection'],
					$attr['colorLocation1'],
					$attr['colorLocation2']
				);
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$global_inherit_from_theme = get_option( 'rbea_global_inherit_from_theme');
			$rbea_global_inherit_from_theme_last_changed = get_option( 'rbea_global_inherit_from_theme_last_changed');
			$inheritFromThemeLocalTimestamp = isset($attr['inheritFromThemeLocalTimestamp']) ? $attr['inheritFromThemeLocalTimestamp'] : '';
			$flag = ($rbea_global_inherit_from_theme_last_changed && (!$inheritFromThemeLocalTimestamp || strtotime($rbea_global_inherit_from_theme_last_changed) > strtotime($inheritFromThemeLocalTimestamp))) || $attr['inheritFromTheme'];
			$flag = $flag && ($attr['inheritFromThemesaved'] || $global_inherit_from_theme);

			$selectors        = array(
				' ' => array(
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
				),
				' .responsive-block-editor-addons-button__wrapper .responsive-block-editor-addons-button__icon svg' => array(
					'color'  => $attr['icon_color'],
					'width'  => self::get_css_value( $attr['iconsize'], 'px' ),
					'height' => self::get_css_value( $attr['iconsize'], 'px' ),
				),
				' .responsive-block-editor-addons-button__wrapper a:hover .responsive-block-editor-addons-button__icon svg' => array(
					'color' => $attr['icon_hover_color'],
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper:hover .responsive-block-editor-addons-button__link_child, .edit-post-visual-editor.editor-styles-wrapper .wp-block-cover .responsive-block-editor-addons-buttons-child .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper:hover .responsive-block-editor-addons-button__link_child' => array(
					'color'   => $flag ? '' : $attr['hColor'],
					'opacity' => $typography_opacity_control_value,
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper .responsive-block-editor-addons-button__link_child, .edit-post-visual-editor.editor-styles-wrapper .wp-block-cover .responsive-block-editor-addons-buttons-child .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper .responsive-block-editor-addons-button__link_child' => array(
					'color'   => $flag ? '' : ( $attr['color'] ? $attr['color'] : '#000' ),
					'opacity' => $typography_opacity_control_value,
				),
				' .responsive-block-editor-addons-1.responsive-block-editor-addons-button__wrapper' => array(
					'margin-left'   => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper' => array(
					'border-color'               => $flag ? '' : ($attr['borderColor'] ? self::hex_to_rgb( $updated_border_color, $border_opacity_control_value ) : '#000'),
					'border-top-left-radius'     => $flag ? '' : self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => $flag ? '' : self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => $flag ? '' : self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => $flag ? '' : self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-style'               => $flag ? '' : $attr['borderStyle'],
					'border-width'               => $flag ? '' : (self::get_css_value( $attr['borderWidth'], 'px' )),
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
					'padding-left'               => $flag ? '' : self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'              => $flag ? '' : self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-top'                => $flag ? '' : self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom'             => $flag ? '' : self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'background-image'           => $updated_background_image,
					'background-color'           => $flag ? '' : $attr['background'],
					'font-size'                  => $flag ? '' : self::get_css_value( $attr['buttonFontSize'], 'px' ),
					'font-family'                => $flag ? 'Default' : $attr['buttonFontFamily'],
					'font-weight'                => $flag ? '' : $attr['buttonFontWeight'],
					'line-height'                => $flag ? '' : $attr['buttonLineHeight'],
					'opacity'                    => $imgopacity,
					'color'                      => $flag ? '' : ( $attr['color'] ? $attr['color'] : '#000' ),
					'text-decoration'            => 'none',
					'text-transform'             => $attr['buttonTextTransform'],
					'font-style'                 => $attr['buttonFontStyle']
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper div' => array(
					'color' => $flag ? '' : ( $attr['color'] ? $attr['color'] : '#000' ),
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper:hover' => array(
					'border-color'     => $flag ? '' : ($attr['borderHColor'] ? self::hex_to_rgb( $updated_border_h_color, $border_opacity_control_value ) : '#000'),
					'background-color' => $updated_background_h_color,
					'box-shadow'       => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-button__icon' => array(
					'margin-left'  => $icon_space_left . 'px',
					'margin-right' => $icon_space_right . 'px',
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'z-index' => $attr['z_indexMobile'],
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
				),
				' .responsive-block-editor-addons-1.responsive-block-editor-addons-button__wrapper' => array(
					'margin-left'   => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper' => array(
					'padding-left'               => $flag ? '' : self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'              => $flag ? '' : self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-top'                => $flag ? '' : self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom'             => $flag ? '' : self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'font-size'                  => $flag ? '' : self::get_css_value( $attr['buttonFontSizeMobile'], 'px' ) . '',
					'border-top-left-radius'     => $flag ? '' : self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => $flag ? '' : self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => $flag ? '' : self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => $flag ? '' : self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'z-index' => $attr['z_indexTablet'],
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
				),
				' .responsive-block-editor-addons-1.responsive-block-editor-addons-button__wrapper' => array(
					'margin-left'   => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-buttons-repeater.responsive-block-editor-addons-button__wrapper' => array(
					'padding-left'               => $flag ? '' : self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'              => $flag ? '' : self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-top'                => $flag ? '' : self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom'             => $flag ? '' : self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'font-size'                  => $flag ? '' : self::get_css_value( $attr['buttonFontSizeTablet'], 'px' ),
					'border-top-left-radius'     => $flag ? '' : self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => $flag ? '' : self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => $flag ? '' : self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => $flag ? '' : self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);
			$id                 = '.responsive-block-editor-addons-buttons-child.block-' . $id;
			$css                = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for buttons block
		 *
		 * @return array
		 */
		public static function get_responsive_block_buttons_child_default_attributes() {
			return array(
				'buttonAlignment'          => 'center',
				'fontFamily'               => 'Default',
				'fontWeight'               => '',
				'fontSubset'               => '',
				'label'                    => '#Click Here',
				'link'                     => '',
				'target'                   => '_blank',
				'iconsize'                 => 16,
				'counterId'                => 1,
				'vPadding'                 => 10,
				'hPadding'                 => 14,
				'vPaddingTablet'           => '',
				'hPaddingTablet'           => '',
				'vPaddingMobile'           => '',
				'hPaddingMobile'           => '',
				'vMargin'                  => 10,
				'vMarginTablet'            => '',
				'vMarginMobile'            => '',
				'hMargin'                  => 14,
				'hMarginTablet'            => '',
				'hMarginMobile'            => '',
				'borderWidth'              => 0,
				'borderRadius'             => 0,
				'borderStyle'              => 'none',
				'borderColor'              => '',
				'borderHColor'             => '',
				'color'                    => 'white',
				'background'               => '#007cba',
				'hColor'                   => 'white',
				'sizeType'                 => 'px',
				'sizeMobile'               => '',
				'sizeTablet'               => '',
				'lineHeight'               => '',
				'lineHeightType'           => 'em',
				'lineHeightMobile'         => '',
				'lineHeightTablet'         => '',
				'opensInNewTab'            => '',
				'colorLocation1'           => 0,
				'colorLocation2'           => 100,
				'gradientDirection'        => 90,
				'backgroundColor1'         => '',
				'backgroundColor2'         => '',
				'opacity'                  => 100,
				'icon'                     => '',
				'iconPosition'             => 'after',
				'buttonFontFamily'         => '',
				'buttonFontSize'           => '',
				'buttonFontSizeTablet'     => '',
				'buttonFontSizeMobile'     => '',
				'buttonLineHeight'         => '',
				'boxShadowColor'           => '',
				'boxShadowHOffset'         => 0,
				'boxShadowVOffset'         => 0,
				'boxShadowBlur'            => 0,
				'boxShadowSpread'          => 0,
				'boxShadowPosition'        => 'outset',
				'hoverboxShadowColor'      => '',
				'hoverboxShadowHOffset'    => 0,
				'hoverboxShadowVOffset'    => 0,
				'hoverboxShadowBlur'       => 0,
				'hoverboxShadowSpread'     => 0,
				'hoverboxShadowPosition'   => 'outset',
				'icon_color'               => '#3a3a3a',
				'icon_hover_color'         => '',
				'hbackground'              => '',
				'iconSpace'                => 8,
				'buttonFontWeight'         => '400',
				'inheritFromTheme'         => false,
				'hoverEffect'              => '',
				'backgroundType'           => 'color',
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => 10,
				'blockBottomPadding'       => 10,
				'blockLeftPadding'         => 14,
				'blockRightPadding'        => 14,
				'blockTopPaddingMobile'    => '',
				'blockBottomPaddingMobile' => '',
				'blockLeftPaddingMobile'   => '',
				'blockRightPaddingMobile'  => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => 10,
				'blockBottomMargin'        => 10,
				'blockLeftMargin'          => 14,
				'blockRightMargin'         => 14,
				'blockTopMarginMobile'     => '',
				'blockBottomMarginMobile'  => '',
				'blockLeftMarginMobile'    => '',
				'blockRightMarginMobile'   => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMarginTablet'   => '',
				'blockTopRadius'           => 2,
				'blockRightRadius'         => 2,
				'blockBottomRadius'        => 2,
				'blockLeftRadius'          => 2,
				'blockTopRadiusMobile'     => 2,
				'blockRightRadiusMobile'   => 2,
				'blockBottomRadiusMobile'  => 2,
				'blockLeftRadiusMobile'    => 2,
				'blockTopRadiusTablet'     => 2,
				'blockRightRadiusTablet'   => 2,
				'blockBottomRadiusTablet'  => 2,
				'blockLeftRadiusTablet'    => 2,
				'typographyOpacity'        => 100,
				'borderOpacity'            => 100,
				'buttonTextTransform'      => '',
				'buttonFontStyle'          => '',
				'hideWidget'			   => false,
    			'hideWidgetTablet'		   => false,
    			'hideWidgetMobile'		   => false,
				'inheritFromThemesaved'	   => false,
			);
		}

		/**
		 * Get Call to action Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_call_to_action_css( $attr, $id ) {

			$defaults = self::get_responsive_block_call_to_action_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'             => 'borderRadius' ? 'borderRadius' : 12,
				'blockRightRadius'           => 'borderRadius' ? 'borderRadius' : 12,
				'blockBottomRadius'          => 'borderRadius' ? 'borderRadius' : 12,
				'blockLeftRadius'            => 'borderRadius' ? 'borderRadius' : 12,
				'blockTopRadiusTablet'       => 'borderRadius' ? 'borderRadius' : 12,
				'blockRightRadiusTablet'     => 'borderRadius' ? 'borderRadius' : 12,
				'blockBottomRadiusTablet'    => 'borderRadius' ? 'borderRadius' : 12,
				'blockLeftRadiusTablet'      => 'borderRadius' ? 'borderRadius' : 12,
				'blockTopRadiusMobile'       => 'borderRadius' ? 'borderRadius' : 12,
				'blockRightRadiusMobile'     => 'borderRadius' ? 'borderRadius' : 12,
				'blockBottomRadiusMobile'    => 'borderRadius' ? 'borderRadius' : 12,
				'blockLeftRadiusMobile'      => 'borderRadius' ? 'borderRadius' : 12,
				'ctaBlockTopRadius'          => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockRightRadius'        => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockBottomRadius'       => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockLeftRadius'         => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockTopRadiusTablet'    => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockRightRadiusTablet'  => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockBottomRadiusTablet' => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockLeftRadiusTablet'   => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockTopRadiusMobile'    => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockRightRadiusMobile'  => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockBottomRadiusMobile' => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,
				'ctaBlockLeftRadiusMobile'   => 'ctaBorderRadius' ? 'ctaBorderRadius' : 4,

			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'ctaTitleTypographyColor'     => 'ctaTextColor' ? 'ctaTextColor' : '',
				'ctaTitleBottomSpacing'       => 'titleSpace' ? 'titleSpace' : '',
				'ctaTitleBottomSpacingMobile' => 'titleSpaceMobile' ? 'titleSpaceMobile' : '',
				'ctaTitleBottomSpacingTablet' => 'titleSpaceTablet' ? 'titleSpaceTablet' : '',
				'ctaTextBottomSpacing'        => 'subtitleSpace' ? 'subtitleSpace' : '',
				'ctaTextBottomSpacingMobile'  => 'subtitleSpaceMobile' ? 'subtitleSpaceMobile' : '',
				'ctaTextBottomSpacingTablet'  => 'subtitleSpaceTablet' ? 'subtitleSpaceTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$background_keys = array(
				'backgroundRepeat'         => 'backgroundImageRepeat' ? 'backgroundImageRepeat' : 'backgroundRepeat',
				'backgroundPosition'       => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPosition',
				'backgroundPositionMobile' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionMobile',
				'backgroundPositionTablet' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionTablet',
				'backgroundSize'           => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSize',
				'backgroundSizeMobile'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeMobile',
				'backgroundSizeTablet'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeTablet',
			);

			// To populate new control values with existing background control values for backward compatibility.
			foreach ( $background_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity                    = $attr['opacity'] / 100;
			$button_text_opacity           = $attr['ctaTextOpacity'] / 100;
			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$updated_button_background_color   = '';
			$updated_button_background_h_color = '';
			$updated_background_color          = '';
			$updated_background_type           = '';
			$updated_button_background_type    = '';

			if ( 'color' === $attr['buttonbackgroundType'] ) {
				$updated_button_background_color = 'empty' !== $attr['buttonBackgroundColor'] && '#2091e1' === $attr['ctaBackColor'] ? $attr['buttonBackgroundColor'] : $attr['ctaBackColor']; // For compatibility with v1.3.2.
			}

			if ( 'color' === $attr['buttonHbackgroundType'] ) {
				$updated_button_background_h_color = 'empty' !== $attr['hbuttonBackgroundColor'] && '' === $attr['ctaHoverBackColor'] ? $attr['hbuttonBackgroundColor'] : ( $attr['ctaHoverBackColor'] ? $attr['ctaHoverBackColor'] : 'none' ); // For compatibility with v1.3.2.
			}

			if ( 'color' === $attr['backgroundType'] ) {
				$updated_background_color = 'empty' !== $attr['ctaBackgroundColor'] && '#f2f2f2' === $attr['backgroundColor'] ? self::hex_to_rgb( $attr['ctaBackgroundColor'], $imgopacity ) : self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ); // For compatibility with v1.3.2.
			} else {
				$updated_background_color = '#ffffff';
			}

			if ( 'gradient' === $attr['backgroundType'] ) {
				$updated_background_type = self::generate_background_image_effect( $attr['backgroundColor1'], $attr['backgroundColor2'], $attr['gradientDirection'], $attr['colorLocation1'], $attr['colorLocation2'] );
			}

			if ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$updated_button_background_type = self::generate_background_image_effect( $attr['buttonbackgroundColor1'], $attr['buttonbackgroundColor2'], $attr['buttongradientDirection'], $attr['buttoncolorLocation1'], $attr['buttoncolorLocation2'] );

			}

			$cta_icon_margin = '';
			if ( 'before' === $attr['iconPosition'] ) {
				$cta_icon_margin = 'auto ' . self::get_css_value( $attr['iconSpace'], 'px' ) . ' auto 0';
			} elseif ( 'after' === $attr['iconPosition'] ) {
				$cta_icon_margin = 'auto 0 auto ' . self::get_css_value( $attr['iconSpace'], 'px' );
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$global_inherit_from_theme = get_option( 'rbea_global_inherit_from_theme');
			$rbea_global_inherit_from_theme_last_changed = get_option( 'rbea_global_inherit_from_theme_last_changed');
			$inheritFromThemeLocalTimestamp = isset($attr['inheritFromThemeLocalTimestamp']) ? $attr['inheritFromThemeLocalTimestamp'] : '';
			$flag = ($rbea_global_inherit_from_theme_last_changed && (!$inheritFromThemeLocalTimestamp || strtotime($rbea_global_inherit_from_theme_last_changed) > strtotime($inheritFromThemeLocalTimestamp))) || $attr['inheritFromTheme'];
			$flag = $flag && ($attr['inheritFromThemesaved'] || $global_inherit_from_theme);

			$selectors = array(
				' .responsive-block-editor-addons-cta-button-wrapper .responsive-block-editor-addons-cta-button' => array(
					'color'   => $flag ? '' : ('empty' !== $attr['buttonTextColor'] && '#fff' === $attr['ctaColor'] ? $attr['buttonTextColor'] : $attr['ctaColor']), // For compatibility with v1.3.2.
					'opacity' => $button_text_opacity,
				),

				' .responsive-block-editor-addons-cta-button-wrapper:hover .responsive-block-editor-addons-cta-button' => array(
					'color' => $flag ? '' : ('empty' !== $attr['hbuttonTextColor'] && '#e6f2ff' === $attr['ctaHoverColor'] ? $attr['hbuttonTextColor'] : $attr['ctaHoverColor']), // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-cta-button-wrapper:hover' => array(
					'border-color'     => 'empty' !== $attr['buttonborderHColor'] && '' === $attr['ctaHoverBorderColor'] ? $attr['buttonborderHColor'] : $attr['ctaHoverBorderColor'], // For compatibility with v1.3.2.
					'background-color' => $updated_button_background_h_color,
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $updated_button_background_color,
				),

				' .responsive-block-editor-addons-cta-link-text' => array(
					'color'       => 'empty' !== $attr['buttonTextColor'] && '#fff' === $attr['ctaColor'] ? $attr['buttonTextColor'] : $attr['ctaColor'], // For compatibility with v1.3.2.
					'font-family' => $flag ? 'Default' : $attr['buttonTextFontFamily'],
					'font-size'   => self::get_css_value( $attr['buttonTextFontSize'], 'px' ),
					'font-weight' => $flag ? '' : $attr['buttonTextFontWeight'],
					'line-height' => $attr['buttonTextLineHeight'],
					'text-transform'=> $attr['buttonTextTextTransform'],
					'font-style'    => $attr['buttonTextFontStyle'],
				),

				' .responsive-block-editor-addons-cta-link-text:hover' => array(
					'color' => 'empty' !== $attr['hbuttonTextColor'] && '#e6f2ff' === $attr['ctaHoverColor'] ? $attr['hbuttonTextColor'] : $attr['ctaHoverColor'], // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-cta-button__icon svg' => array(
					'fill' => $attr['icon_color'],
				),

				' .responsive-block-editor-addons-cta-title' => array(
					'font-size'     => self::get_css_value( $attr['ctaTitleFontSize'], 'px' ),
					'color'         => $attr['ctaTitleTypographyColor'],
					'line-height'   => 999 !== $attr['headingLineHeight'] && 1.8 === $attr['ctaTitleLineHeight'] ? $attr['headingLineHeight'] : $attr['ctaTitleLineHeight'], // For compatibility with v1.3.2.
					'font-family'   => $attr['ctaTitleFontFamily'],
					'font-weight'   => 'empty' !== $attr['headingFontWeight'] && '400' === $attr['ctaTitleFontWeight'] ? $attr['headingFontWeight'] : $attr['ctaTitleFontWeight'], // For compatibility with v1.3.2.
					'margin-bottom' => self::get_css_value( $attr['ctaTitleBottomSpacing'], 'px' ),
					'text-transform'=> $attr['ctaTitleTextTransform'],
					'font-style'    => $attr['ctaTitleFontStyle'],
				),

				'' => array(
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'background-color'           => $updated_background_color,
					'background-image'           => $updated_background_type,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
					'padding-top'                => 999 !== $attr['topPadding'] && 20 === $attr['blockTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['blockTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['bottomPadding'] && 20 === $attr['blockBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['blockBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['leftPadding'] && 20 === $attr['blockLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['blockLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['rightPadding'] && 20 === $attr['blockRightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['blockRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'position'                   => 'relative',
					'z-index'                    => $attr['z_index'],
					'margin-top'                 => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				':hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',
				),

				' .responsive-block-editor-addons-cta-image' => array(
					'background-image'           => 'empty' !== $attr['imgURL'] && '' === $attr['backgroundImage'] ? $attr['imgURL'] : ( $attr['backgroundImage'] ? 'url(' . $attr['backgroundImage'] . ')' : null ), // For compatibility with v1.3.2.
					'height'                     => 100 . '%',
					'background-position'        => $background_position_focal,
					'background-repeat'          => 'empty' !== $attr['imageRepeat'] && 'no-repeat' === $attr['backgroundRepeat'] ? $attr['imageRepeat'] : $attr['backgroundRepeat'], // For compatibility with v1.3.2.
					'background-size'            => 'empty' !== $attr['thumbsize'] && 'cover' === $attr['backgroundSize'] ? $attr['thumbsize'] : $attr['backgroundSize'], // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),

				' .responsive-block-editor-addons-cta-text' => array(
					'color'         => $attr['ctaTitleTypographyColor'],
					'font-size'     => self::get_css_value( $attr['ctaTextFontSize'], 'px' ),
					'font-family'   => $attr['ctaTextFontFamily'],
					'line-height'   => 999 !== $attr['contentLineHeight'] && 1.75 === $attr['ctaTextLineHeight'] ? $attr['contentLineHeight'] : $attr['ctaTextLineHeight'], // For compatibility with v1.3.2.
					'font-weight'   => 'empty' !== $attr['contentFontWeight'] && '400' === $attr['ctaTextFontWeight'] ? $attr['contentFontWeight'] : $attr['ctaTextFontWeight'], // For compatibility with v1.3.2.
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacing'], 'px' ),
					'text-transform'=> $attr['ctaTextTextTransform'],
					'font-style'    => $attr['ctaTextFontStyle'],
				),

				' .responsive-block-editor-addons-cta-button-wrapper' => array(
					'color'                      => $attr['ctaColor'],
					'background-color'           => $attr['ctaBackColor'],
					'padding-top'                => 999 !== $attr['buttonvPadding'] && 10 === $attr['ctaVpadding'] ? self::get_css_value( $attr['buttonvPadding'], 'px' ) : self::get_css_value( $attr['ctaVpadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['buttonvPadding'] && 10 === $attr['ctaVpadding'] ? self::get_css_value( $attr['buttonvPadding'], 'px' ) : self::get_css_value( $attr['ctaVpadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['buttonhPadding'] && 14 === $attr['ctaHpadding'] ? self::get_css_value( $attr['buttonhPadding'], 'px' ) : self::get_css_value( $attr['ctaHpadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['buttonhPadding'] && 14 === $attr['ctaHpadding'] ? self::get_css_value( $attr['buttonhPadding'], 'px' ) : self::get_css_value( $attr['ctaHpadding'], 'px' ), // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['buttonborderStyle'] && 'solid' === $attr['ctaBorderStyle'] ? $attr['buttonborderStyle'] : ( $attr['ctaBorderStyle'] ? $attr['ctaBorderStyle'] : 'solid' ), // For compatibility with v1.3.2.
					'border-width'               => $flag ? '0px' : (999 !== $attr['buttonborderWidth'] && 1 === $attr['ctaBorderWidth'] ? $attr['buttonborderWidth'] : ( $attr['ctaBorderWidth'] ? self::get_css_value( $attr['ctaBorderWidth'], 'px' ) : '0px' )), // For compatibility with v1.3.2.
					'background-image'           => $updated_button_background_type,
					'margin-bottom'              => self::get_css_value( $attr['buttonSpace'], 'px' ),
					'border-color'               => $flag ? 'none' : ('empty' !== $attr['buttonborderColor'] && '' === $attr['ctaBorderColor'] ? $attr['buttonborderColor'] : $attr['ctaBorderColor']), // For compatibility with v1.3.2.
					'background-color'           => $flag ? '0px' : $updated_button_background_color,
					'border-top-left-radius'     => $flag ? '0px' : self::get_css_value( $attr['ctaBlockTopRadius'], 'px' ),
					'border-top-right-radius'    => $flag ? '0px' : self::get_css_value( $attr['ctaBlockRightRadius'], 'px' ),
					'border-bottom-right-radius' => $flag ? '0px' : self::get_css_value( $attr['ctaBlockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => $flag ? '0px' : self::get_css_value( $attr['ctaBlockLeftRadius'], 'px' ),
				),

				' .responsive-block-editor-addons-cta-button__icon' => array(
					'margin' => $cta_icon_margin,
				),
				' .responsive-block-editor-addons-cta-button' => array(
					'font-family' => $flag ? 'Default' : $attr['buttonTextFontFamily'],
					'font-size'   => $flag ? '' : self::get_css_value( $attr['buttonTextFontSize'], 'px' ),
					'font-weight' => $flag ? '' : $attr['buttonTextFontWeight'],
					'line-height' => $flag ? '' : $attr['buttonTextLineHeight'],
					'text-transform'=> $flag ? '' : $attr['buttonTextTextTransform'],
					'font-style'    => $flag ? '' : $attr['buttonTextFontStyle'],
				),

			);
			$mobile_selectors = array(
				' h2.responsive-block-editor-addons-cta-title' => array(
					'font-size' => self::get_css_value( $attr['ctaTitleFontSizeMobile'], 'px' ),
				),
				'' => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexMobile'],
					$box_shadow_position_css,
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-title' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTitleBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-text' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['ctaTextFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-button-wrapper' => array(
					'margin-bottom'              => self::get_css_value( $attr['buttonSpaceMobile'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['ctaVpaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['ctaVpaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['ctaHpaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['ctaHpaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-button' => array(
					'font-size' => $flag ? '' : self::get_css_value( $attr['buttonTextFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-link-text' => array(
					'font-size' => self::get_css_value( $attr['buttonTextFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
					'background-position'        => $background_position_focal_mobile,
					'background-size'            => 'empty' !== $attr['thumbsize'] && 'cover' === $attr['backgroundSizeMobile'] ? $attr['thumbsize'] : $attr['backgroundSizeMobile'], // For compatibility with v1.3.2.
				),
			);

			$tablet_selectors = array(
				' h2.responsive-block-editor-addons-cta-title' => array(
					'font-size' => self::get_css_value( $attr['ctaTitleFontSizeTablet'], 'px' ),
				),
				'' => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexTablet'],
					$box_shadow_position_css,
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-title' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTitleBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-text' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['ctaTextFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-button-wrapper' => array(
					'margin-bottom'              => self::get_css_value( $attr['buttonSpaceTablet'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['ctaVpaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['ctaVpaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['ctaHpaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['ctaHpaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-button' => array(
					'font-size' => $flag ? '' : self::get_css_value( $attr['buttonTextFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-link-text' => array(
					'font-size' => self::get_css_value( $attr['buttonTextFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-cta-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
					'background-position'        => $background_position_focal_tablet,
					'background-size'            => 'empty' !== $attr['thumbsize'] && 'cover' === $attr['backgroundSizeTablet'] ? $attr['thumbsize'] : $attr['backgroundSizeTablet'], // For compatibility with v1.3.2.
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-call-to-action.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for Call to action block
		 *
		 * @return array
		 */
		public static function get_responsive_block_call_to_action_default_attributes() {
			return array(
				'block_id'                    => '',
				'buttonText'                  => '',
				'buttonUrl'                   => '',
				'buttonAlignment'             => 'center',
				'ctaBackColor'                => '#2091e1',
				'ctaColor'                    => '#fff',
				'buttonSize'                  => 'responsive-block-editor-addons-cta-button-size-medium',
				'buttonShape'                 => 'responsive-block-editor-addons-cta-button-shape-rounded',
				'buttonTarget'                => false,
				'ctaTitle'                    => '',
				'ctaTitleFontFamily'          => '',
				'ctaTextFontFamily'           => '',
				'ctaTitleFontSize'            => '22',
				'ctaTitleFontSizeMobile'      => '22',
				'ctaTitleFontSizeTablet'      => '22',
				'ctaTextFontSize'             => '16',
				'ctaTextFontSizeMobile'       => '16',
				'ctaTextFontSizeTablet'       => '16',
				'ctaText'                     => '',
				'ctaWidth'                    => '',
				'backgroundColor'             => '#f2f2f2',
				'ctaTextColor'                => '',
				'backgroundImage'             => '',
				'imgID'                       => '',
				'imgAlt'                      => '',
				'dimRatio'                    => 50,
				'opacity'                     => 100,
				'ctaTitleLineHeight'          => 1.8,
				'ctaTitleFontWeight'          => '400',
				'ctaTextLineHeight'           => 1.75,
				'ctaTextFontWeight'           => '400',
				'ctaVpadding'                 => 18,
				'ctaHpadding'                 => 14,
				'ctaBorderWidth'              => 1,
				'ctaBorderStyle'              => 'solid',
				'icon'                        => '',
				'iconPosition'                => 'after',
				'counterId'                   => 1,
				'ctaHoverBackColor'           => '',
				'ctaHoverColor'               => '#e6f2ff',
				'ctaBorderColor'              => '',
				'ctaHoverBorderColor'         => '',
				'resctaType'                  => 'button',
				'ctalinkText'                 => '',
				'titleSpace'                  => 25,
				'subtitleSpace'               => 28,
				'titleSpaceMobile'            => 25,
				'subtitleSpaceMobile'         => 28,
				'titleSpaceTablet'            => 25,
				'subtitleSpaceTablet'         => 28,
				'iconSpace'                   => 8,
				'colorLocation1'              => 0,
				'colorLocation2'              => 100,
				'gradientDirection'           => 90,
				'backgroundColor1'            => '',
				'backgroundColor2'            => '',
				'backgroundType'              => 'color',
				'buttoncolorLocation1'        => 0,
				'buttoncolorLocation2'        => 100,
				'buttongradientDirection'     => 90,
				'buttonbackgroundColor1'      => '',
				'buttonbackgroundColor2'      => '',
				'buttonbackgroundType'        => 'color',
				'boxShadowColor'              => '',
				'boxShadowHOffset'            => 0,
				'boxShadowVOffset'            => 0,
				'boxShadowBlur'               => 0,
				'boxShadowSpread'             => 0,
				'boxShadowPosition'           => 'outset',
				'hoverboxShadowColor'         => '',
				'hoverboxShadowHOffset'       => 0,
				'hoverboxShadowVOffset'       => 0,
				'hoverboxShadowBlur'          => 0,
				'hoverboxShadowSpread'        => 0,
				'hoverboxShadowPosition'      => 'outset',
				'icon_color'                  => '#3a3a3a',
				'blockTopPadding'             => 20,
				'blockBottomPadding'          => 20,
				'blockLeftPadding'            => 20,
				'blockRightPadding'           => 20,
				'blockTopPaddingMobile'       => 20,
				'blockBottomPaddingMobile'    => 20,
				'blockLeftPaddingMobile'      => 20,
				'blockRightPaddingMobile'     => 20,
				'blockTopPaddingTablet'       => 20,
				'blockBottomPaddingTablet'    => 20,
				'blockLeftPaddingTablet'      => 20,
				'blockRightPaddingTablet'     => 20,
				'backgroundImagePosition'     => 'center center',
				'backgroundImageRepeat'       => 'no-repeat',
				'backgroundImageSize'         => 'cover',
				'buttonSpace'                 => 28,
				'buttonSpaceMobile'           => 28,
				'buttonSpaceTablet'           => 28,
				'borderRadius'                => 12,
				'blockTopRadius'              => 0,
				'blockRightRadius'            => 0,
				'blockBottomRadius'           => 0,
				'blockLeftRadius'             => 0,
				'blockTopRadiusTablet'        => 0,
				'blockRightRadiusTablet'      => 0,
				'blockBottomRadiusTablet'     => 0,
				'blockLeftRadiusTablet'       => 0,
				'blockTopRadiusMobile'        => 0,
				'blockRightRadiusMobile'      => 0,
				'blockBottomRadiusMobile'     => 0,
				'blockLeftRadiusMobile'       => 0,
				'buttonTextFontFamily'        => '',
				'buttonTextFontSize'          => 18,
				'buttonTextFontSizeMobile'    => '',
				'buttonTextFontSizeTablet'    => '',
				'buttonTextLineHeight'        => 1,
				'buttonTextFontWeight'        => '400',
				'ctaBorderRadius'             => 4,
				'ctaBlockTopRadius'           => 0,
				'ctaBlockRightRadius'         => 0,
				'ctaBlockBottomRadius'        => 0,
				'ctaBlockLeftRadius'          => 0,
				'ctaBlockTopRadiusTablet'     => 0,
				'ctaBlockRightRadiusTablet'   => 0,
				'ctaBlockBottomRadiusTablet'  => 0,
				'ctaBlockLeftRadiusTablet'    => 0,
				'ctaBlockTopRadiusMobile'     => 0,
				'ctaBlockRightRadiusMobile'   => 0,
				'ctaBlockBottomRadiusMobile'  => 0,
				'ctaBlockLeftRadiusMobile'    => 0,
				'ctaVpaddingMobile'           => '',
				'ctaHpaddingMobile'           => '',
				'ctaVpaddingTablet'           => '',
				'ctaHpaddingTablet'           => '',
				'ctaTextOpacity'              => 100,
				'z_index'                     => 1,
				'z_indexTablet'               => 1,
				'z_indexMobile'               => 1,
				'buttonHbackgroundType'       => 'none',
				'buttonBackgroundColor'       => 'empty', // For compatibility with v1.3.2.
				'hbuttonBackgroundColor'      => 'empty', // For compatibility with v1.3.2.
				'buttonTextColor'             => 'empty', // For compatibility with v1.3.2.
				'hbuttonTextColor'            => 'empty', // For compatibility with v1.3.2.
				'buttonborderHColor'          => 'empty', // For compatibility with v1.3.2.
				'topPadding'                  => 999, // For compatibility with v1.3.2.
				'bottomPadding'               => 999, // For compatibility with v1.3.2.
				'leftPadding'                 => 999, // For compatibility with v1.3.2.
				'rightPadding'                => 999, // For compatibility with v1.3.2.
				'imgURL'                      => 'empty', // For compatibility with v1.3.2.
				'imagePosition'               => 'empty', // For compatibility with v1.3.2.
				'imageRepeat'                 => 'empty', // For compatibility with v1.3.2.
				'thumbsize'                   => 'empty', // For compatibility with v1.3.2.
				'buttonvPadding'              => 999, // For compatibility with v1.3.2.
				'buttonhPadding'              => 999, // For compatibility with v1.3.2.
				'buttonborderStyle'           => 'empty', // For compatibility with v1.3.2.
				'buttonborderColor'           => 'empty', // For compatibility with v1.3.2.
				'buttonborderWidth'           => 999, // For compatibility with v1.3.2.
				'ctaBackgroundColor'          => 'empty', // For compatibility with v1.3.2.
				'headingLineHeight'           => 999, // For compatibility with v1.3.2.
				'headingFontWeight'           => 'empty', // For compatibility with v1.3.2.
				'contentLineHeight'           => 999, // For compatibility with v1.3.2.
				'contentFontWeight'           => 'empty', // For compatibility with v1.3.2.
				'hideWidgetTablet'            => false,
				'hideWidgetMobile'            => false,
				'hideWidget'                  => false,
				'blockTopMargin'              => '',
				'blockBottomMargin'           => '',
				'blockLeftMargin'             => '',
				'blockRightMargin'            => '',
				'blockTopMarginMobile'        => '',
				'blockBottomMarginMobile'     => '',
				'blockLeftMarginMobile'       => '',
				'blockRightMarginMobile'      => '',
				'blockTopMarginTablet'        => '',
				'blockBottomMarginTablet'     => '',
				'blockLeftMarginTablet'       => '',
				'blockRightMarginTablet'      => '',
				'ctaTitleTypographyColor'     => '',
				'ctaTitleBottomSpacing'       => 25,
				'ctaTitleBottomSpacingMobile' => 25,
				'ctaTitleBottomSpacingTablet' => 25,
				'ctaTextBottomSpacing'        => 28,
				'ctaTextBottomSpacingMobile'  => 28,
				'ctaTextBottomSpacingTablet'  => 28,
				'backgroundPosition'          => 'center center',
				'backgroundPositionMobile'    => 'center center',
				'backgroundPositionTablet'    => 'center center',
				'backgroundPositionFocal'     => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundRepeat'            => 'no-repeat',
				'backgroundSize'              => 'cover',
				'backgroundSizeTablet'        => 'cover',
				'backgroundSizeMobile'        => 'cover',
				'ctaTitleTextTransform'       => '',
				'ctaTitleFontStyle'           => '',
				'ctaTextTextTransform'        => '',
				'ctaTextFontStyle'            => '',
				'buttonTextTextTransform'     => '',
				'buttonTextFontStyle'         => '',
				'inheritFromTheme'		   => false,
				'inheritFromThemesaved'	   => false,
			);
		}

		/**
		 * Get Card Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_card_css( $attr, $id ) {
			$defaults                   = self::get_responsive_block_card_default_attributes();
			$new_spacing_attribute_keys = array(
				'blockTopMargin'          => 'blockmargin',
				'blockTopMarginMobile'    => 'blockmarginMobile',
				'blockTopMarginTablet'    => 'blockmarginTablet',
				'blockBottomMargin'       => 'blockbotmargin',
				'blockBottomMarginMobile' => 'blockbotmarginMobile',
				'blockBottomMarginTablet' => 'blockbotmarginTablet',
				'blockLeftMargin'         => 'blockleftmargin',
				'blockLeftMarginMobile'   => 'blockleftmarginMobile',
				'blockLeftMarginTablet'   => 'blockleftmarginTablet',
				'blockRightMargin'        => 'blockrightmargin',
				'blockRightMarginMobile'  => 'blockrightmarginMobile',
				'blockRightMarginTablet'  => 'blockrightmarginTablet',

				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 12,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_spacing_attribute_keys = array(
				'headingTypographyColor'     => 'textColor' ? 'textColor' : '',
				'headingBottomSpacing'       => 'titleSpace' ? 'titleSpace' : '',
				'headingBottomSpacingMobile' => 'titleSpaceMobile' ? 'titleSpaceMobile' : '',
				'headingBottomSpacingTablet' => 'titleSpaceTablet' ? 'titleSpaceTablet' : '',
				'subBottomSpacing'           => 'subtitleSpace' ? 'subtitleSpace' : '',
				'subBottomSpacingMobile'     => 'subtitleSpaceMobile' ? 'subtitleSpaceMobile' : '',
				'subBottomSpacingTablet'     => 'subtitleSpaceTablet' ? 'subtitleSpaceTablet' : '',
				'contentBottomSpacing'       => 'contentSpace' ? 'contentSpace' : '',
				'contentBottomSpacingMobile' => 'contentSpaceMobile' ? 'contentSpaceMobile' : '',
				'contentBottomSpacingTablet' => 'contentSpaceTablet' ? 'contentSpaceTablet' : '',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_button_padding_keys = array(
				'ctaButtonTopPadding'          => 'ctaVpadding' ? 'ctaVpadding' : 14,
				'ctaButtonBottomPadding'       => 'ctaVpadding' ? 'ctaVpadding' : 14,
				'ctaButtonLeftPadding'         => 'ctaHpadding' ? 'ctaHpadding' : 10,
				'ctaButtonRightPadding'        => 'ctaHpadding' ? 'ctaHpadding' : 10,
				'ctaButtonTopPaddingTablet'    => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 14,
				'ctaButtonBottomPaddingTablet' => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 14,
				'ctaButtonRightPaddingTablet'  => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 10,
				'ctaButtonLeftPaddingTablet'   => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 10,
				'ctaButtonTopPaddingMobile'    => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 14,
				'ctaButtonBottomPaddingMobile' => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 14,
				'ctaButtonLeftPaddingMobile'   => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 10,
				'ctaButtonRightPaddingMobile'  => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 10,

				'ctaButtonTopMargin'           => 'vMargin' ? 'vMargin' : 10,
				'ctaButtonBottomMargin'        => 'vMargin' ? 'vMargin' : 10,
				'ctaButtonLeftMargin'          => 'hMargin' ? 'hMargin' : 0,
				'ctaButtonRightMargin'         => 'hMargin' ? 'hMargin' : 0,
				'ctaButtonTopMarginTablet'     => 'vMarginTablet' ? 'vMarginTablet' : 10,
				'ctaButtonBottomMarginTablet'  => 'vMarginTablet' ? 'vMarginTablet' : 10,
				'ctaButtonRightMarginTablet'   => 'hMarginTablet' ? 'hMarginTablet' : 0,
				'ctaButtonLeftMarginTablet'    => 'hMarginTablet' ? 'hMarginTablet' : 0,
				'ctaButtonTopMarginMobile'     => 'vMarginMobile' ? 'vMarginMobile' : 10,
				'ctaButtonBottomMarginMobile'  => 'vMarginMobile' ? 'vMarginMobile' : 10,
				'ctaButtonLeftMarginMobile'    => 'hMarginMobile' ? 'hMarginMobile' : 0,
				'ctaButtonRightMarginMobile'   => 'hMarginMobile' ? 'hMarginMobile' : 0,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_button_padding_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity  = $attr['opacity'] / 100;
			$butopacity  = 999 !== $attr['butopacity'] && 100 === $attr['butopacity'] ? $attr['butopacity'] / 100 : $attr['buttonopacity'] / 100; // For compatibility with v1.3.2.
			$buthopacity = $attr['buttonHopacity'] / 100;
			$textopacity = $attr['ctaTextOpacity'] / 100;

			$updated_button_color            = '';
			$updated_buttonh_color           = '';
			$updated_background_color        = '';
			$updated_background_type         = '';
			$updated_button_background_color = '';
			$box_shadow_position_css         = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css   = $attr['hoverboxShadowPosition'];
			$background_image_url_check      = $attr['backgroundImage'] ? $attr['backgroundImage'] : null;

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			if ( 'color' === $attr['buttonbackgroundType'] ) {
				$updated_button_color = 'empty' !== $attr['buttonColor'] && '' === $attr['ctaBackColor'] ? self::hex_to_rgb( $attr['buttonColor'], $butopacity ) : self::hex_to_rgb( $attr['ctaBackColor'] ? $attr['ctaBackColor'] : '#2091e1', $butopacity ); // For compatibility with v1.3.2.
			}

			if ( 'color' === $attr['buttonHbackgroundType'] ) {
				$updated_buttonh_color = 'empty' !== $attr['buttonhColor'] && '' === $attr['ctaHoverBackColor'] ? self::hex_to_rgb( $attr['buttonhColor'], $buthopacity ) : self::hex_to_rgb( $attr['ctaHoverBackColor'] ? $attr['ctaHoverBackColor'] : 'none', $buthopacity ); // For compatibility with v1.3.2.
			}

			if ( 'color' === $attr['backgroundType'] ) {
				$updated_background_color = 'empty' !== $attr['itemBackgroundColor'] && '' === $attr['backgroundColor'] ? self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ) : self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity );  // For compatibility with v1.3.2.
			} else {
				$updated_background_color = '#fff';
			}

			if ( 'gradient' === $attr['backgroundType'] ) {
				$updated_background_type = self::generate_background_image_effect( self::hex_to_rgba($attr['backgroundColor1'],$imgopacity), self::hex_to_rgba($attr['backgroundColor2'],$imgopacity), $attr['gradientDirection'], $attr['colorLocation1'], $attr['colorLocation2']);
			}

			if ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$updated_button_background_color = self::generate_background_image_effect( $attr['buttonbackgroundColor1'], $attr['buttonbackgroundColor2'], $attr['buttongradientDirection'], $attr['buttoncolorLocation1'], $attr['buttoncolorLocation2'] );
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );
			$card_image_position_focal        = self::get_background_position( $attr['cardImagePosition'] );
			$card_image_position_focal_tablet = self::get_background_position( $attr['cardImagePositionMobile'] );
			$card_image_position_focal_mobile = self::get_background_position( $attr['cardImagePositionTablet'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
				$card_image_position_focal        = self::get_background_position( $attr['cardImagePositionFocal'] );
				$card_image_position_focal_tablet = self::get_background_position( $attr['cardImagePositionFocalTablet'] );
				$card_image_position_focal_mobile = self::get_background_position( $attr['cardImagePositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$global_inherit_from_theme = get_option( 'rbea_global_inherit_from_theme');
			$rbea_global_inherit_from_theme_last_changed = get_option( 'rbea_global_inherit_from_theme_last_changed');
			$inheritFromThemeLocalTimestamp = isset($attr['inheritFromThemeLocalTimestamp']) ? $attr['inheritFromThemeLocalTimestamp'] : '';
			$flag = ($rbea_global_inherit_from_theme_last_changed && (!$inheritFromThemeLocalTimestamp || strtotime($rbea_global_inherit_from_theme_last_changed) > strtotime($inheritFromThemeLocalTimestamp))) || $attr['inheritFromTheme'];
			$flag = $flag && ($attr['inheritFromThemesaved'] || $global_inherit_from_theme);

			$selectors = array(
				' .responsive-block-editor-addons-card-button-inner .res-button' => array(
					'color'   => $flag ? '' : ('empty' !== $attr['buttonTextColor'] && '#fff' === $attr['ctaColor'] ? $attr['buttonTextColor'] : $attr['ctaColor']), // For compatibility with v1.3.2.
					'opacity' => $textopacity,
				),

				' .responsive-block-editor-addons-card-button-inner:hover .res-button' => array(
					'color' => $flag ? '' : ('empty' !== $attr['buttonhTextColor'] && '#e6f2ff' === $attr['ctaHoverColor'] ? $attr['buttonhTextColor'] : $attr['ctaHoverColor']), // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-card-button-inner .responsive-block-editor-addons-button__icon svg' => array(
					'fill' => $attr['icon_color'],
				),

				' .responsive-block-editor-addons-card-button-inner:hover .responsive-block-editor-addons-button__icon svg' => array(
					'fill' => $attr['icon_hcolor'],
				),

				' .wp-block-responsive-block-editor-addons-card-item__button-wrapper .responsive-block-editor-addons-card-button-inner' => array(
					'background-color' => $flag ? '' : ($updated_button_color ? $updated_button_color : '#2091e1'),
				),

				' .responsive-block-editor-addons-card-button-inner:hover' => array(
					'background-color' => $updated_buttonh_color,
					'border-color'     => $attr['ctaHoverBorderColor'],
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $updated_button_background_color,
				),

				''                    => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-card-item' => array(
					'border-color'               => 'empty' !== $attr['borderColor'] && '' === $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'], // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'], // For compatibility with v1.3.2.
					'border-width'               => 999 !== $attr['borderWidth'] && 0 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'background-color'           => $updated_background_color,
					'background-image'           => $updated_background_type,
					'box-shadow'                 => self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
				),
				' .wp-block-responsive-block-editor-addons-card-item:hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',
				),

				' .responsive-block-editor-addons-card-background-image' => array(
					'background-image'    => 'url(' . $background_image_url_check . ')',
					'height'              => 100 . '%',
					'background-position' => $background_position_focal,
					'background-repeat'   => null !== $attr['backgroundRepeat'] ? $attr['backgroundRepeat'] : $attr['bgimageRepeat'], // For compatibility with v1.3.2.
					'background-size'     => null !== $attr['backgroundSize'] ? $attr['backgroundSize'] : $attr['bgthumbsize'], // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-card-avatar' => array(
					'height' => self::get_css_value( $attr['imageheight'], 'px' ),
				),

				' .responsive-block-editor-addons-card-avatar-img' => array(
					'background-position' => $card_image_position_focal,
					'background-repeat'   => $attr['cardImageRepeat'],
					'background-size'     => $attr['cardImageSize'],
				),

				' .responsive-block-editor-addons-card-avatar-img.responsive-block-editor-addons-card-avatar-img-0' => array(
					'background-image' => 'url(' . $attr['backgroundImageOne'] . ')',
					'display'          => $attr['backgroundImageOne'] ? 'block' : 'none',
				),

				' .responsive-block-editor-addons-card-avatar-img.responsive-block-editor-addons-card-avatar-img-1' => array(
					'background-image' => 'url(' . $attr['backgroundImageTwo'] . ')',
					'display'          => $attr['backgroundImageTwo'] ? 'block' : 'none',
				),

				' .responsive-block-editor-addons-card-avatar-img.responsive-block-editor-addons-card-avatar-img-2' => array(
					'background-image' => 'url(' . $attr['backgroundImageThree'] . ')',
					'display'          => $attr['backgroundImageThree'] ? 'block' : 'none',
				),

				' .responsive-block-editor-addons-card-avatar-img.responsive-block-editor-addons-card-avatar-img-3' => array(
					'background-image' => 'url(' . $attr['backgroundImageFour'] . ')',
					'display'          => $attr['backgroundImageFour'] ? 'block' : 'none',
				),

				' .card-content-wrap' => array(
					'text-align' => $attr['contentAlignment'],
				),

				' .wp-block-responsive-block-editor-addons-card-item__title' => array(
					'margin-top'    => 0,
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacing'], 'px' ),
					'color'         => $attr['headingTypographyColor'],
					'line-height'   => $attr['headingLineHeight'],
					'font-family'   => $attr['headingFontFamily'],
					'font-weight'   => $attr['headingFontWeight'],
					'font-size'     => self::get_css_value( $attr['headingFontSize'], 'px' ),
					'text-transform'=> $attr['headingTextTransform'],
					'font-style'    => $attr['headingFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-card-item__subtitle' => array(
					'margin-top'    => 0,
					'margin-bottom' => self::get_css_value( $attr['subBottomSpacing'], 'px' ),
					'color'         => $attr['headingTypographyColor'],
					'line-height'   => $attr['subLineHeight'],
					'font-weight'   => $attr['subFontWeight'],
					'font-family'   => $attr['subFontFamily'],
					'font-size'     => self::get_css_value( $attr['subFontSize'], 'px' ),
					'text-transform'=> $attr['subTextTransform'],
					'font-style'    => $attr['subFontStyle'],

				),

				' .wp-block-responsive-block-editor-addons-card-item__content' => array(
					'margin-top'    => 0,
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacing'], 'px' ),
					'color'         => $attr['headingTypographyColor'],
					'line-height'   => $attr['contentLineHeight'],
					'font-weight'   => $attr['contentFontWeight'],
					'font-size'     => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-family'   => $attr['contentFontFamily'],
					'text-transform'=> $attr['contentTextTransform'],
					'font-style'    => $attr['contentFontStyle'],
				),

				' .responsive-block-editor-addons-card-button-inner' => array(
					'padding-top'      => self::get_css_value( $attr['ctaButtonTopPadding'], 'px' ),
					'padding-bottom'   => self::get_css_value( $attr['ctaButtonBottomPadding'], 'px' ),
					'padding-left'     => self::get_css_value( $attr['ctaButtonLeftPadding'], 'px' ),
					'padding-right'    => self::get_css_value( $attr['ctaButtonRightPadding'], 'px' ),
					'margin-top'       => self::get_css_value( $attr['ctaButtonTopMargin'], 'px' ),
					'margin-bottom'    => self::get_css_value( $attr['ctaButtonBottomMargin'], 'px' ),
					'margin-left'      => self::get_css_value( $attr['ctaButtonLeftMargin'], 'px' ),
					'margin-right'     => self::get_css_value( $attr['ctaButtonRightMargin'], 'px' ),
					'border-style'     => 'empty' !== $attr['butborderStyle'] && 'none' !== $attr['ctaBorderStyle'] ? $attr['butborderStyle'] : $attr['ctaBorderStyle'], // For compatibility with v1.3.2.
					'border-radius'    => 999 !== $attr['butborderRadius'] && 2 === $attr['ctaBorderRadius'] ? self::get_css_value( $attr['butborderRadius'], 'px' ) : self::get_css_value( $attr['ctaBorderRadius'], 'px' ), // For compatibility with v1.3.2.
					'border-width'     => 999 !== $attr['butborderWidth'] && 1 === $attr['ctaBorderWidth'] ? self::get_css_value( $attr['butborderWidth'], 'px' ) : self::get_css_value( $attr['ctaBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'background-image' => $updated_button_background_color,
					'border-color'     => $attr['ctaBorderColor'],
				),

			);

			$mobile_selectors = array(
				'' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-card-item__title' => array(
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['headingFontSizeMobile'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-card-item__subtitle' => array(
					'margin-bottom' => self::get_css_value( $attr['subBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['subFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-card-item__content' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-card-button-inner' => array(
					'padding-top'    => self::get_css_value( $attr['ctaButtonTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['ctaButtonBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['ctaButtonLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['ctaButtonRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['ctaButtonTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['ctaButtonBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['ctaButtonLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['ctaButtonRightMarginMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-card-item' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-card-background-image' => array(
					'background-position' => $background_position_focal_mobile,
					'background-size'     => null !== $attr['backgroundSizeMobile'] ? $attr['backgroundSizeMobile'] : $attr['bgthumbsize'], // For compatibility with v1.3.2.
				),
				' .responsive-block-editor-addons-card-avatar-img' => array(
					'background-position' => $card_image_position_focal_mobile,
					'background-size'     => $attr['cardImageSizeMobile'],
				),
			);

			$tablet_selectors = array(
				'' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-card-item__title' => array(
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['headingFontSizeTablet'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-card-item__subtitle' => array(
					'margin-bottom' => self::get_css_value( $attr['subBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['subFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-card-item__content' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-card-button-inner' => array(
					'padding-top'    => self::get_css_value( $attr['ctaButtonTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['ctaButtonBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['ctaButtonLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['ctaButtonRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['ctaButtonTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['ctaButtonBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['ctaButtonLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['ctaButtonRightMarginTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-card-item' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-card-background-image' => array(
					'background-position' => $background_position_focal_tablet,
					'background-size'     => null !== $attr['backgroundSizeTablet'] ? $attr['backgroundSizeTablet'] : $attr['bgthumbsize'], // For compatibility with v1.3.2.
				),
				' .responsive-block-editor-addons-card-avatar-img' => array(
					'background-position' => $card_image_position_focal_tablet,
					'background-size'     => $attr['cardImageSizeTablet'],
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-card.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for card block
		 *
		 * @return array
		 */
		public static function get_responsive_block_card_default_attributes() {
			return array(
				'block_id'                     => '',
				'cardsArray'                   => '',
				'count'                        => '',
				'gutter'                       => 'medium',
				'stack'                        => 'mobile',
				'contentAlign'                 => 'center',
				'textColor'                    => '',
				'backgroundColor'              => '',
				'itemBackgroundColor'          => 'empty', // For compatibility with v1.3.2.
				'ctaBackColor'                 => '',
				'ctaColor'                     => '#fff',
				'buttonColor'                  => 'empty', // For compatibility with v1.3.2.
				'buttonTextColor'              => 'empty', // For compatibility with v1.3.2.
				'boxShadowColor'               => '',
				'boxShadowHOffset'             => 0,
				'boxShadowVOffset'             => 0,
				'boxShadowBlur'                => 0,
				'boxShadowSpread'              => 0,
				'boxShadowPosition'            => 'outset',
				'hoverboxShadowColor'          => '',
				'hoverboxShadowHOffset'        => 0,
				'hoverboxShadowVOffset'        => 0,
				'hoverboxShadowBlur'           => 0,
				'hoverboxShadowSpread'         => 0,
				'hoverboxShadowPosition'       => 'outset',
				'titleSpace'                   => 8,
				'subtitleSpace'                => 16,
				'contentSpace'                 => 16,
				'titleSpaceMobile'             => '',
				'subtitleSpaceMobile'          => '',
				'contentSpaceMobile'           => '',
				'titleSpaceTablet'             => '',
				'subtitleSpaceTablet'          => '',
				'contentSpaceTablet'           => '',
				'buttonSpace'                  => 20,
				'opacity'                      => 100,
				'resshowImage'                 => true,
				'colorLocation1'               => 0,
				'colorLocation2'               => 100,
				'gradientDirection'            => 90,
				'backgroundImage'              => '',
				'backgroundColor1'             => '',
				'backgroundColor2'             => '#fff',
				'backgroundType'               => 'none',
				'imageopacity'                 => 20,
				'imageSize'                    => 'full',
				'imagePosition'                => 'center center',
				'imageRepeat'                  => 'no-repeat',
				'thumbsize'                    => 'cover',
				'imageheight'                  => 200,
				'blockmargin'                  => 2,
				'blockmarginMobile'            => '',
				'blockmarginTablet'            => '',
				'blockzindex'                  => 1,
				'icon'                         => '',
				'iconPosition'                 => 'after',
				'icon_color'                   => '#3a3a3a',
				'counterId'                    => 1,
				'ctaHoverBackColor'            => '',
				'ctaHoverColor'                => '#e6f2ff',
				'buttonhColor'                 => 'empty', // For compatibility with v1.3.2.
				'buttonhTextColor'             => 'empty', // For compatibility with v1.3.2.
				'buttonopacity'                => 100,
				'butopacity'                   => 999,  // For compatibility with v1.3.2.
				'buttonHopacity'               => 100,
				'ctaVpadding'                  => 10,
				'ctaHpadding'                  => 14,
				'vPadding'                     => 999, // For compatibility with v1.3.2.
				'hPadding'                     => 999, // For compatibility with v1.3.2.
				'vMargin'                      => 10,
				'hMargin'                      => 0,
				'ctaBorderWidth'               => 1,
				'ctaBorderRadius'              => 2,
				'butborderWidth'               => 999, // For compatibility with v1.3.2.
				'butborderRadius'              => 999, // For compatibility with v1.3.2.
				'butborderStyle'               => 'empty', // For compatibility with v1.3.2.
				'ctaBorderStyle'               => 'none',
				'buttonSize'                   => 'responsive-block-editor-addons-button-size-medium',
				'buttoncolorLocation1'         => 0,
				'buttoncolorLocation2'         => 100,
				'buttongradientDirection'      => 90,
				'buttonbackgroundColor1'       => '',
				'buttonbackgroundColor2'       => '#fff',
				'buttonbackgroundType'         => 'none',
				'icon_hcolor'                  => '#3a3a3a',
				'headingFontFamily'            => '',
				'subFontFamily'                => '',
				'contentFontFamily'            => '',
				'subLineHeight'                => 1,
				'subFontWeight'                => 400,
				'subFontSize'                  => 16,
				'headingLineHeight'            => 1,
				'headingFontWeight'            => 900,
				'headingFontSize'              => 20,
				'contentLineHeight'            => 2,
				'contentFontSize'              => 16,
				'contentFontWeight'            => 400,
				'blockbotmargin'               => 2,
				'blockleftmargin'              => 0,
				'blockrightmargin'             => 0,
				'blockbotmarginMobile'         => '',
				'blockleftmarginMobile'        => '',
				'blockrightmarginMobile'       => '',
				'blockbotmarginTablet'         => '',
				'blockleftmarginTablet'        => '',
				'blockrightmarginTablet'       => '',
				'bgimageSize'                  => 'full', // For compatibility with v1.3.2.
				'bgimagePosition'              => 'center center', // For compatibility with v1.3.2.
				'bgimageRepeat'                => 'no-repeat', // For compatibility with v1.3.2.
				'bgthumbsize'                  => 'cover',
				'blockBorderStyle'             => 'none',
				'blockBorderColor'             => '',
				'blockBorderWidth'             => 0,
				'blockBorderRadius'            => 12,
				'blockTopRadiusMobile'         => 0,
				'blockRightRadiusMobile'       => 0,
				'blockBottomRadiusMobile'      => 0,
				'blockLeftRadiusMobile'        => 0,
				'blockTopRadiusTablet'         => 0,
				'blockRightRadiusTablet'       => 0,
				'blockBottomRadiusTablet'      => 0,
				'blockLeftRadiusTablet'        => 0,
				'blockTopRadius'               => 0,
				'blockRightRadius'             => 0,
				'blockBottomRadius'            => 0,
				'blockLeftRadius'              => 0,
				'borderStyle'                  => 'empty', // For compatibility with v1.3.2.
				'borderColor'                  => 'empty', // For compatibility with v1.3.2.
				'borderWidth'                  => 999, // For compatibility with v1.3.2.
				'borderRadius'                 => 999, // For compatibility with v1.3.2.
				'buttonTarget'                 => 'false',
				'contentAlignment'             => 'left',
				'backgroundImageOne'           => '',
				'backgroundImageTwo'           => '',
				'backgroundImageThree'         => '',
				'backgroundImageFour'          => '',
				'backgroundImagePosition'      => 'center center',
				'backgroundImageRepeat'        => 'no-repeat',
				'backgroundImageSize'          => 'cover',
				'headingFontSizeMobile'        => '',
				'headingFontSizeTablet'        => '',
				'subFontSizeMobile'            => '',
				'subFontSizeTablet'            => '',
				'contentFontSizeMobile'        => '',
				'contentFontSizeTablet'        => '',
				'ctaBorderColor'               => '',
				'ctaHoverBorderColor'          => '',
				'ctaTextOpacity'               => 100,
				'ctaHpaddingTablet'            => '',
				'ctaHpaddingMobile'            => '',
				'ctaVpaddingTablet'            => '',
				'ctaVpaddingMobile'            => '',
				'vMarginTablet'                => '',
				'vMarginMobile'                => '',
				'hMarginTablet'                => '',
				'hMarginMobile'                => '',
				'buttonHbackgroundType'        => 'none',
				'hideWidgetTablet'             => false,
				'hideWidgetMobile'             => false,
				'hideWidget'                   => false,
				'z_index'                      => 1,
				'z_indexTablet'                => 1,
				'z_indexMobile'                => 1,
				'blockTopPadding'              => '',
				'blockTopPaddingMobile'        => '',
				'blockTopPaddingTablet'        => '',
				'blockBottomPadding'           => '',
				'blockBottomPaddingMobile'     => '',
				'blockBottomPaddingTablet'     => '',
				'blockLeftPadding'             => '',
				'blockLeftPaddingMobile'       => '',
				'blockLeftPaddingTablet'       => '',
				'blockRightPadding'            => '',
				'blockRightPaddingMobile'      => '',
				'blockRightPaddingTablet'      => '',
				'blockTopMargin'               => 2,
				'blockTopMarginMobile'         => '',
				'blockTopMarginTablet'         => '',
				'blockBottomMargin'            => 2,
				'blockBottomMarginMobile'      => '',
				'blockBottomMarginTablet'      => '',
				'blockLeftMargin'              => 0,
				'blockLeftMarginMobile'        => '',
				'blockLeftMarginTablet'        => '',
				'blockRightMargin'             => 0,
				'blockRightMarginMobile'       => '',
				'blockRightMarginTablet'       => '',
				'imagePositionTab'             => 'desktop',
				'backgroundSize'               => 'cover',
				'backgroundSizeTablet'         => 'cover',
				'backgroundSizeMobile'         => 'cover',
				'backgroundPosition'           => 'center center',
				'backgroundPositionMobile'     => 'center center',
				'backgroundPositionTablet'     => 'center center',
				'backgroundPositionFocal'      => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundAttachment'         => 'scroll',
				'imageSizeTab'                 => 'desktop',
				'backgroundRepeat'             => 'no-repeat',
				'cardImageSize'                => 'cover',
				'cardImageSizeTablet'          => 'cover',
				'cardImageSizeMobile'          => 'cover',
				'cardImagePosition'            => 'center center',
				'cardImagePositionMobile'      => 'center center',
				'cardImagePositionTablet'      => 'center center',
				'cardImagePositionFocal'       => '50% 50%',
				'cardImagePositionFocalMobile' => '50% 50%',
				'cardImagePositionFocalTablet' => '50% 50%',
				'cardImageRepeat'              => 'no-repeat',
				'headingTypographyColor'       => '',
				'headingBottomSpacing'         => 8,
				'headingBottomSpacingMobile'   => 8,
				'headingBottomSpacingTablet'   => 8,
				'subBottomSpacing'             => 16,
				'subBottomSpacingMobile'       => 16,
				'subBottomSpacingTablet'       => 16,
				'contentBottomSpacing'         => 16,
				'contentBottomSpacingMobile'   => 16,
				'contentBottomSpacingTablet'   => 16,

				'ctaButtonTopPadding'          => 10,
				'ctaButtonBottomPadding'       => 10,
				'ctaButtonLeftPadding'         => 14,
				'ctaButtonRightPadding'        => 14,
				'ctaButtonTopPaddingTablet'    => 10,
				'ctaButtonBottomPaddingTablet' => 10,
				'ctaButtonRightPaddingTablet'  => 14,
				'ctaButtonLeftPaddingTablet'   => 14,
				'ctaButtonTopPaddingMobile'    => 10,
				'ctaButtonBottomPaddingMobile' => 10,
				'ctaButtonLeftPaddingMobile'   => 14,
				'ctaButtonRightPaddingMobile'  => 14,

				'ctaButtonTopMargin'           => 10,
				'ctaButtonBottomMargin'        => 10,
				'ctaButtonLeftMargin'          => 0,
				'ctaButtonRightMargin'         => 0,
				'ctaButtonTopMarginTablet'     => 10,
				'ctaButtonBottomMarginTablet'  => 10,
				'ctaButtonRightMarginTablet'   => 0,
				'ctaButtonLeftMarginTablet'    => 0,
				'ctaButtonTopMarginMobile'     => 10,
				'ctaButtonBottomMarginMobile'  => 10,
				'ctaButtonLeftMarginMobile'    => 0,
				'ctaButtonRightMarginMobile'   => 0,
				'headingTextTransform'         => '',
    			'headingFontStyle'             => '',
    			'subTextTransform'             => '',
    			'subFontStyle'                 => '',
    			'contentTextTransform'         => '',
    			'contentFontStyle'             => '',
				'inheritFromThemesaved'	   => false,
				'inheritFromTheme'		   => false,
			);
		}

		/**
		 * Get Content timeline Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_content_timeline_css( $attr, $id ) {
			$defaults = self::get_responsive_block_content_timeline_default_attributes();

			$new_border_radius_keys = array(
				'itemTopRadius'          => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemRightRadius'        => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemBottomRadius'       => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemLeftRadius'         => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemTopRadiusTablet'    => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemRightRadiusTablet'  => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemBottomRadiusTablet' => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemLeftRadiusTablet'   => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemTopRadiusMobile'    => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemRightRadiusMobile'  => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemBottomRadiusMobile' => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
				'itemLeftRadiusMobile'   => 'itemBorderRadius' ? 'itemBorderRadius' : 2,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_setting_keys = array(
				'contentTypographyColor' => 'contentColor' ? 'contentColor' : '',
				'headingTypographyColor' => 'headingColor' ? 'headingColor' : '',
				'dateTypographyColor'    => 'dateColor' ? 'dateColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_setting_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$border_with_color = '13px solid' . $attr['backgroundColor'];

			$imgopacity = $attr['opacity'] / 100;
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                       => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),

				' .responsive-timeline__left .responsive-timeline__day-left .responsive-timeline__arrow:after' => array(
					'border-right' => $border_with_color,
				),

				' .responsive-timeline__right .responsive-timeline__day-right .responsive-timeline__arrow:after' => array(
					'border-left' => $border_with_color,
				),

				' .responsive-timeline__line'             => array(
					'background-color' => $attr['separatorColor'],
					'width'            => self::get_css_value( $attr['separatorwidth'], 'px' ),
					'margin-left'      => 'center' !== $attr['timelinAlignment'] ? self::get_css_value( $attr['horizontalSpace'], 'px' ) : '',
					'margin-right'     => 'center' !== $attr['timelinAlignment'] ? self::get_css_value( $attr['horizontalSpace'], 'px' ) : '',
				),

				' .responsive-timeline__line__inner'      => array(
					'background-color' => $attr['separatorFillColor'],
				),

				' .responsive-timeline__main .responsive-block-editor-addons-ifb-icon' => array(
					'color' => $attr['iconColor'],
				),

				' .responsive-timeline__main .responsive-block-editor-addons-ifb-icon svg' => array(
					'fill' => $attr['iconColor'],
				),

				' .responsive-timeline__marker'           => array(
					'background-color' => $attr['separatorBg'],
					'border-color'     => $attr['separatorBorder'],
				),

				' .responsive-timeline__main .responsive-timeline__marker.responsive-timeline__in-view-icon' => array(
					'background'   => $attr['iconBgFocus'],
					'border-color' => $attr['borderFocus'],
					'color'        => $attr['iconFocus'],
				),

				' .responsive-timeline__main .responsive-timeline__marker.responsive-timeline__in-view-icon svg' => array(
					'fill' => $attr['iconFocus'],
				),

				' .responsive-timeline__main .responsive-timeline__marker.responsive-timeline__in-view-icon .responsive-timeline__icon-new' => array(
					'color' => $attr['iconFocus'],
				),

				' .responsive-timeline__left-block .responsive-timeline__line' => array(
					'left' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__rightt-block .responsive-timeline__line' => array(
					'right' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__field.responsive-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verticalSpace'], 'px' ),
				),

				' .responsive-timeline__marker.out-view-responsive-timeline__icon, .responsive-timeline__marker.in-view-responsive-timeline__icon' => array(
					'margin-left'  => self::get_css_value( $attr['horizontalSpace'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horizontalSpace'], 'px' ),
					'min-width'    => self::get_css_value( $attr['connectorBgsize'], 'px' ),
					'min-height'   => self::get_css_value( $attr['connectorBgsize'], 'px' ),
					'border-width' => self::get_css_value( $attr['borderwidth'], 'px' ),
				),

				' .responsive-block-editor-addons-ifb-icon' => array(
					'width'  => self::get_css_value( $attr['iconSize'], 'px' ),
					'height' => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-timeline__events-inner-new' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['itemTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['itemRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['itemBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['itemLeftRadius'], 'px' ),
					'border-width'               => self::get_css_value( $attr['itemBorderWidth'], 'px' ),
					'border-style'               => $attr['itemBorderStyle'],
					'border-color'               => $attr['itemBorderColor'],
					'padding'                    => self::get_css_value( $attr['itemPadding'], 'px' ),
					'background-color'           => self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ),
				),

				' .responsive-timeline__inner-date-new'   => array(
					'color'       => $attr['dateTypographyColor'],
					'line-height' => $attr['dateLineHeight'],
					'font-weight' => $attr['dateFontWeight'],
					'font-size'   => self::get_css_value( $attr['dateFontSize'], 'px' ),
					'font-family' => $attr['dateFontFamily'],
					'text-transform' => $attr['dateTextTransform'],
					'font-style'  => $attr['dateFontStyle']
				),

				' .responsive-timeline__heading'          => array(
					'color'         => $attr['headingTypographyColor'],
					'line-height'   => $attr['headingLineHeight'],
					'font-weight'   => $attr['headingFontWeight'],
					'font-size'     => self::get_css_value( $attr['headingFontSize'], 'px' ),
					'font-family'   => $attr['headingFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['headingBottomMargin'], 'px' ),
					'text-transform' => $attr['headingTextTransform'],
					'font-style'  => $attr['headingFontStyle']
				),

				' .responsive-timeline-desc-content'      => array(
					'color'       => $attr['contentTypographyColor'],
					'line-height' => $attr['contentLineHeight'],
					'font-weight' => $attr['contentFontWeight'],
					'font-size'   => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-family' => $attr['contentFontFamily'],
					'text-transform' => $attr['contentTextTransform'],
					'font-style'  => $attr['contentFontStyle']
				),

				' .responsive-timeline__date-new'         => array(
					'color'       => $attr['dateTypographyColor'],
					'line-height' => $attr['dateLineHeight'],
					'font-weight' => $attr['dateFontWeight'],
					'font-size'   => self::get_css_value( $attr['dateFontSize'], 'px' ),
					'font-family' => $attr['dateFontFamily'],
					'text-transform' => $attr['dateTextTransform'],
					'font-style'  => $attr['dateFontStyle']
				),

			);

			$mobile_selectors = array(
				' '                                       => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-timeline__center-block.responsive-timeline__responsive-mobile .responsive-timeline__line' => array(
					'left'  => $attr['connectorBgsize'] / 2 . 'px',
					'right' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__left-block.responsive-timeline__responsive-mobile .responsive-timeline__line' => array(
					'left' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__right-block.responsive-timeline__responsive-mobile .responsive-timeline__line' => array(
					'right' => $attr['connectorBgsize'] / 2 . 'px',
				),
				' .responsive-timeline__field.responsive-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verticalSpaceMobile'], 'px' ),
				),

				' .responsive-timeline__marker.out-view-responsive-timeline__icon, .responsive-timeline__marker.in-view-responsive-timeline__icon' => array(
					'margin-left'  => self::get_css_value( $attr['horizontalSpaceMobile'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horizontalSpaceMobile'], 'px' ),
				),
				' .responsive-timeline__date-new'         => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeMobile'], 'px' ),
				),
				' .responsive-timeline-desc-content'      => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
				),
				' .responsive-timeline__heading'          => array(
					'font-size'     => self::get_css_value( $attr['headingFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['headingBottomMarginMobile'], 'px' ),
				),
				' .responsive-timeline__inner-date-new'   => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeMobile'], 'px' ),
				),
				' .responsive-timeline__events-inner-new' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['itemTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['itemRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['itemBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['itemLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                                       => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-timeline__center-block.responsive-timeline__responsive-tablet .responsive-timeline__line' => array(
					'left'  => $attr['connectorBgsize'] / 2 . 'px',
					'right' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__left-block.responsive-timeline__responsive-tablet .responsive-timeline__line' => array(
					'left' => $attr['connectorBgsize'] / 2 . 'px',
				),

				' .responsive-timeline__right-block.responsive-timeline__responsive-tablet .responsive-timeline__line' => array(
					'right' => $attr['connectorBgsize'] / 2 . 'px',
				),
				' .responsive-timeline__field.responsive-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verticalSpaceTablet'], 'px' ),
				),

				' .responsive-timeline__marker.out-view-responsive-timeline__icon, .responsive-timeline__marker.in-view-responsive-timeline__icon' => array(
					'margin-left'  => self::get_css_value( $attr['horizontalSpaceTablet'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horizontalSpaceTablet'], 'px' ),
				),
				' .responsive-timeline__date-new'         => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeTablet'], 'px' ),
				),
				' .responsive-timeline-desc-content'      => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
				),
				' .responsive-timeline__heading'          => array(
					'font-size'     => self::get_css_value( $attr['headingFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['headingBottomMarginTablet'], 'px' ),
				),
				' .responsive-timeline__inner-date-new'   => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeTablet'], 'px' ),
				),
				' .responsive-timeline__events-inner-new' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['itemTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['itemRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['itemBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['itemLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-content-timeline.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for content timeline block
		 *
		 * @return array
		 */
		public static function get_responsive_block_content_timeline_default_attributes() {
			return array(
				'block_id'                  => '',
				'timelinAlignment'          => 'center',
				'timelineItems'             => '',
				'dateFormat'                => 'F j, Y',
				'headingTag'                => 'h4',
				't_date'                    => '',
				'displayPostDate'           => true,
				'count'                     => 5,
				'dateBottomspace'           => 5,
				'itemBorderStyle'           => 'none',
				'itemBorderColor'           => '',
				'itemBorderWidth'           => 1,
				'itemBorderRadius'          => 2,
				'itemTopRadiusMobile'       => 0,
				'itemRightRadiusMobile'     => 0,
				'itemBottomRadiusMobile'    => 0,
				'itemLeftRadiusMobile'      => 0,
				'itemTopRadiusTablet'       => 0,
				'itemRightRadiusTablet'     => 0,
				'itemBottomRadiusTablet'    => 0,
				'itemLeftRadiusTablet'      => 0,
				'itemTopRadius'             => 0,
				'itemRightRadius'           => 0,
				'itemBottomRadius'          => 0,
				'itemLeftRadius'            => 0,
				'itemPadding'               => 20,
				'horizontalSpace'           => 0,
				'verticalSpace'             => 15,
				'headingBottomMargin'       => 15,
				'horizontalSpaceMobile'     => '',
				'verticalSpaceMobile'       => '',
				'headingBottomMarginMobile' => '',
				'horizontalSpaceTablet'     => '',
				'verticalSpaceTablet'       => '',
				'headingBottomMarginTablet' => '',
				'dateLineHeight'            => 1,
				'contentFontFamily'         => '',
				'headingFontFamily'         => '',
				'dateFontFamily'            => '',
				'dateFontWeight'            => '400',
				'dateFontSize'              => 16,
				'headingLineHeight'         => 1,
				'headingFontWeight'         => '400',
				'headingFontSize'           => 20,
				'dateColor'                 => '',
				'headingColor'              => '',
				'contentColor'              => '',
				'backgroundColor'           => '#eee',
				'counterId'                 => 1,
				'contentLineHeight'         => 2,
				'contentFontSize'           => 16,
				'contentFontWeight'         => '400',
				'opacity'                   => 100,
				'separatorColor'            => '#eee',
				'iconColor'                 => '#333',
				'separatorBg'               => '#eee',
				'separatorBorder'           => '#eee',
				'separatorFillColor'        => '#61ce70',
				'iconFocus'                 => '#fff',
				'iconBgFocus'               => '#61ce70',
				'borderFocus'               => '#5cb85c',
				'separatorwidth'            => 3,
				'borderwidth'               => 0,
				'connectorBgsize'           => 35,
				'iconSize'                  => 20,
				'icon'                      => 'fa fa-calendar-alt',
				'stack'                     => 'mobile',
				'arrowlinAlignment'         => 'center',
				'dateFontSizeMobile'        => '',
				'dateFontSizeTablet'        => '',
				'headingFontSizeMobile'     => '',
				'headingFontSizeTablet'     => '',
				'contentFontSizeMobile'     => '',
				'contentFontSizeTablet'     => '',
				'hideWidgetMobile'          => false,
				'hideWidgetTablet'          => false,
				'hideWidget'                => false,
				'z_index'                   => 1,
				'z_indexTablet'             => 1,
				'z_indexMobile'             => 1,
				'blockTopPadding'           => '',
				'blockTopPaddingMobile'     => '',
				'blockTopPaddingTablet'     => '',
				'blockBottomPadding'        => '',
				'blockBottomPaddingMobile'  => '',
				'blockBottomPaddingTablet'  => '',
				'blockLeftPadding'          => '',
				'blockLeftPaddingMobile'    => '',
				'blockLeftPaddingTablet'    => '',
				'blockRightPadding'         => '',
				'blockRightPaddingMobile'   => '',
				'blockRightPaddingTablet'   => '',
				'blockTopMargin'            => '',
				'blockTopMarginMobile'      => '',
				'blockTopMarginTablet'      => '',
				'blockBottomMargin'         => '',
				'blockBottomMarginMobile'   => '',
				'blockBottomMarginTablet'   => '',
				'blockLeftMargin'           => '',
				'blockLeftMarginMobile'     => '',
				'blockLeftMarginTablet'     => '',
				'blockRightMargin'          => '',
				'blockRightMarginMobile'    => '',
				'blockRightMarginTablet'    => '',
				'contentTypographyColor'    => '',
				'headingTypographyColor'    => '',
				'dateTypographyColor'       => '',
				'dateTextTransform'         => '',
                'dateFontStyle'             => '',
                'headingTextTransform'      => '',
                'headingFontStyle'          => '',
                'contentTextTransform'      => '',
                'contentFontStyle'          => '',
			);
		}

		/**
		 * Get Expand Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_expand_css( $attr, $id ) {
			$defaults = self::get_responsive_block_expand_default_attributes();

			$new_typography_settings_keys = array(
				'titleTypographyColor'     => 'titleColor' ? 'titleColor' : '',
				'linkTypographyColor'      => 'linkColor' ? 'linkColor' : '',
				'textTypographyColor'      => 'textColor' ? 'textColor' : '',
				'titleBottomSpacing'       => 'titleSpace' ? 'titleSpace' : 28,
				'titleBottomSpacingTablet' => 'titleSpaceTablet' ? 'titleSpaceTablet' : '',
				'titleBottomSpacingMobile' => 'titleSpaceMobile' ? 'titleSpaceMobile' : '',
				'textBottomSpacing'        => 'textSpace' ? 'textSpace' : 20,
				'textBottomSpacingTablet'  => 'textSpaceTablet' ? 'textSpaceTablet' : '',
				'textBottomSpacingMobile'  => 'textSpaceMobile' ? 'textSpaceMobile' : '',
				'linkBottomSpacing'        => 'linkSpace' ? 'linkSpace' : 18,
				'linkBottomSpacingTablet'  => 'linkSpaceTablet' ? 'linkSpaceTablet' : '',
				'linkBottomSpacingMobile'  => 'linkSpaceMobile' ? 'linkSpaceMobile' : '',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}
			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' .responsive-block-editor-addons-expand-block-content' => array(
					'text-align' => $attr['expandAlignment'],
				),

				' .responsive-block-editor-addons-expand-title' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
					'font-family'   => $attr['titleFontFamily'],
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-weight'   => $attr['titleFontWeight'],
					'line-height'   => $attr['titleLineHeight'],
					'color'         => $attr['titleTypographyColor'],
					'text-transform'=> $attr['titleTextTransform'],
					'font-style'    => $attr['titleFontStyle'],
				),

				' .responsive-block-editor-addons-expand-less-text' => array(
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacing'], 'px' ),
					'font-family'   => $attr['textFontFamily'],
					'font-size'     => self::get_css_value( $attr['textFontSize'], 'px' ),
					'font-weight'   => $attr['textFontWeight'],
					'line-height'   => $attr['textLineHeight'],
					'color'         => $attr['textTypographyColor'],
					'text-transform'=> $attr['textTextTransform'],
					'font-style'    => $attr['textFontStyle'],
				),

				' .responsive-block-editor-addons-expand-more-text' => array(
					'display'       => 'none',
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacing'], 'px' ),
					'font-family'   => $attr['textFontFamily'],
					'font-size'     => self::get_css_value( $attr['textFontSize'], 'px' ),
					'font-weight'   => $attr['textFontWeight'],
					'line-height'   => $attr['textLineHeight'],
					'color'         => $attr['textTypographyColor'],
					'text-transform'=> $attr['textTextTransform'],
					'font-style'    => $attr['textFontStyle'],
				),

				' .responsive-block-editor-addons-expand-more-toggle-text' => array(
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacing'], 'px' ),
					'font-family'   => $attr['linkFontFamily'],
					'font-size'     => self::get_css_value( $attr['linkFontSize'], 'px' ),
					'font-weight'   => $attr['linkFontWeight'],
					'line-height'   => $attr['linkLineHeight'],
					'color'         => $attr['linkTypographyColor'],
					'text-transform'=> $attr['linkTextTransform'],
					'font-style'    => $attr['linkFontStyle'],
				),

				' .responsive-block-editor-addons-expand-less-toggle-text' => array(
					'display'       => 'none',
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacing'], 'px' ),
					'font-family'   => $attr['linkFontFamily'],
					'font-size'     => self::get_css_value( $attr['linkFontSize'], 'px' ),
					'font-weight'   => $attr['linkFontWeight'],
					'line-height'   => $attr['linkLineHeight'],
					'color'         => $attr['linkTypographyColor'],
					'text-transform'=> $attr['linkTextTransform'],
					'font-style'    => $attr['linkFontStyle'],
				),
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
			);

			$mobile_selectors = array(
				' .responsive-block-editor-addons-expand-title' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-less-text' => array(
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['textFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-more-text' => array(
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['textFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-more-toggle-text' => array(
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['linkFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-less-toggle-text' => array(
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['linkFontSizeMobile'], 'px' ),
				),
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' .responsive-block-editor-addons-expand-title' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-less-text' => array(
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['textFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-more-text' => array(
					'margin-bottom' => self::get_css_value( $attr['textBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['textFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-more-toggle-text' => array(
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['linkFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-expand-less-toggle-text' => array(
					'margin-bottom' => self::get_css_value( $attr['linkBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['linkFontSizeTablet'], 'px' ),
				),
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-expand.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for expand block
		 *
		 * @return array
		 */
		public static function get_responsive_block_expand_default_attributes() {
			return array(
				'block_id'                 => '',
				'blockTitle'               => 'Title for this block',
				'expandLessText'           => 'Some short text that can be expanded to show more details.',
				'expandMoreText'           => 'Some short text that can be expanded to show more details. Description for this block. Use this space for describing your block. Any text will do. Description for this block. You can use this space for describing your block.',
				'moreLabel'                => 'Show more',
				'lessLabel'                => 'Show less',
				'showTitle'                => true,
				'expandAlignment'          => '',
				'textColor'                => '',
				'linkColor'                => '#0066cc',
				'titleColor'               => '',
				'titleSpace'               => 28,
				'textSpace'                => 20,
				'linkSpace'                => 18,
				'titleSpaceMobile'         => '',
				'textSpaceMobile'          => '',
				'linkSpaceMobile'          => '',
				'titleSpaceTablet'         => '',
				'textSpaceTablet'          => '',
				'linkSpaceTablet'          => '',
				'titleFontFamily'          => '',
				'textFontFamily'           => '',
				'linkFontFamily'           => '',
				'titleFontSize'            => 20,
				'titleFontWeight'          => 400,
				'titleLineHeight'          => 1,
				'textFontSize'             => 16,
				'textFontWeight'           => 400,
				'textLineHeight'           => 2,
				'linkFontSize'             => 16,
				'linkFontWeight'           => 400,
				'linkLineHeight'           => 1,
				'titleFontSizeMobile'      => '',
				'titleFontSizeTablet'      => '',
				'textFontSizeMobile'       => '',
				'textFontSizeTablet'       => '',
				'linkFontSizeMobile'       => '',
				'linkFontSizeTablet'       => '',
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'titleTypographyColor'     => '',
				'linkTypographyColor'      => '#0066cc',
				'textTypographyColor'      => '',
				'titleBottomSpacing'       => 28,
				'titleBottomSpacingTablet' => '',
				'titleBottomSpacingMobile' => '',
				'textBottomSpacing'        => 20,
				'textBottomSpacingTablet'  => '',
				'textBottomSpacingMobile'  => '',
				'linkBottomSpacing'        => 18,
				'linkBottomSpacingTablet'  => '',
				'linkBottomSpacingMobile'  => '',
				'titleTextTransform'       => '',
				'titleFontStyle'           => '',
				'textTextTransform'        => '',
				'textFontStyle'            => '',
				'linkTextTransform'        => '',
				'linkFontStyle'            => '',
			);
		}

		/**
		 * Get Flipbox Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_flipbox_css( $attr, $id ) {
			$defaults                   = self::get_responsive_block_flipbox_default_attributes();
			$new_spacing_attribute_keys = array(
				'blockTopMargin'          => 'topMargin',
				'blockBottomMargin'       => 'bottomMargin',
				'blockTopMarginTablet'    => 'topMarginTablet',
				'blockBottomMarginTablet' => 'bottomMarginTablet',
				'blockTopMarginMobile'    => 'topMarginMobile',
				'blockBottomMarginMobile' => 'bottomMarginMobile',
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'frontTitleTypographyColor' => 'frontTextColor' ? 'frontTextColor' : '',
				'backTitleTypographyColor'  => 'backTextColor' ? 'backTextColor' : '',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_button_padding_keys = array(
				'ctaButtonTopPadding'          => 'ctaVpadding' ? 'ctaVpadding' : 10,
				'ctaButtonBottomPadding'       => 'ctaVpadding' ? 'ctaVpadding' : 10,
				'ctaButtonLeftPadding'         => 'ctaHpadding' ? 'ctaHpadding' : 20,
				'ctaButtonRightPadding'        => 'ctaHpadding' ? 'ctaHpadding' : 20,
				'ctaButtonTopPaddingTablet'    => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 15,
				'ctaButtonBottomPaddingTablet' => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 15,
				'ctaButtonRightPaddingTablet'  => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 30,
				'ctaButtonLeftPaddingTablet'   => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 30,
				'ctaButtonTopPaddingMobile'    => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 15,
				'ctaButtonBottomPaddingMobile' => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 15,
				'ctaButtonLeftPaddingMobile'   => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 30,
				'ctaButtonRightPaddingMobile'  => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 30,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_button_padding_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$flip_style = 'rotateY(0deg)';
			$flip_style_back;
			$flip_class;

			if ( 'back_selected' === $attr['colorButtonSelected'] ) {
				$flip_class = 'backSelected';
				if ( 'LTR' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateY(180deg)';
					$flip_style_back = 'rotateY(180deg)';
				}
				if ( 'RTL' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateY(-180deg)';
					$flip_style_back = 'rotateY(-180deg)';
				}
				if ( 'BTT' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateX(180deg)';
					$flip_style_back = 'rotateX(180deg)';
				}
				if ( 'TTB' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateX(-180deg)';
					$flip_style_back = 'rotateX(-180deg)';
				}
			} else {
				$flip_class = 'frontSelected';
				if ( 'LTR' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateY(0deg)';
					$flip_style_back = 'rotateY(180deg)';
				}
				if ( 'RTL' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateY(0deg)';
					$flip_style_back = 'rotateY(-180deg)';
				}
				if ( 'BTT' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateX(0deg)';
					$flip_style_back = 'rotateX(180deg)';
				}
				if ( 'TTB' === $attr['flipStyleSelected'] ) {
					$flip_style      = 'rotateX(0deg)';
					$flip_style_back = 'rotateX(-180deg)';
				}
			}

			$transition_speed_sec = $attr['transitionSpeed'] / 10;

			$flipbox_transition =
				$attr['transitionSpeed'] < 10
				? 'transform 0.' . $attr['transitionSpeed'] . 's'
				: 'transform ' . $transition_speed_sec . 's';

			$coloropacity     = $attr['colorOpacity'] / 100;
			$backcoloropacity = $attr['backColorOpacity'] / 100;
			$imageopacity     = $attr['imageOpacity'] / 100;
			$backimageopacity = $attr['backImageOpacity'] / 100;

			$background_front = '';
			$background_back  = '';

			if ( $attr['backgroundImage'] ) {
				$background_front = 'linear-gradient(' .

				self::hex_to_rgb( $attr['frontBackgroundColor'], $coloropacity ) .

				',' .

				self::hex_to_rgb( $attr['frontBackgroundColor'], $coloropacity ) .

				'),url(' .

				$attr['backgroundImage'] .

				')';
			}
			if ( $attr['backBackgroundImage'] ) {
				$background_back = 'linear-gradient(' .

				self::hex_to_rgb( $attr['backBackgroundColor'], $backcoloropacity ) .

				',' .

				self::hex_to_rgb( $attr['backBackgroundColor'], $backcoloropacity ) .

				'),url(' .

				$attr['backBackgroundImage'] .

				')';
			}

			$background_image_gradient = '';
			$btn_color                 = $attr['ctaBackColor'];
			$btn_opacity               = $attr['buttonopacity'];
			if ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$background_image_gradient = 'linear-gradient(' . $attr['buttongradientDirection'] . 'deg, ' . $attr['buttonbackgroundColor1'] . ' ' . $attr['buttoncolorLocation1'] . '%, ' . $attr['buttonbackgroundColor2'] . ' ' . $attr['buttoncolorLocation2'] . '%)';
			} elseif ( 'color' === $attr['buttonbackgroundType'] ) {
				$btn_color   = $attr['ctaBackColor'];
				$btn_opacity = $attr['buttonopacity'];
			}

			$background_hover_image_gradient = '';
			$btn_h_color                     = $attr['ctaHoverBackColor'];
			$btn_h_opacity                   = $attr['buttonHopacity'];
			if ( 'gradient' === $attr['buttonHbackgroundType'] ) {
				$background_hover_image_gradient = 'linear-gradient(' . $attr['buttonHgradientDirection'] . 'deg, ' . $attr['buttonHbackgroundColor1'] . ' ' . $attr['buttonHcolorLocation1'] . '%, ' . $attr['buttonHbackgroundColor2'] . ' ' . $attr['buttonHcolorLocation2'] . '%)';
			} elseif ( 'color' === $attr['buttonHbackgroundType'] ) {
				$btn_h_color   = $attr['ctaHoverBackColor'];
				$btn_h_opacity = $attr['buttonHopacity'];
			}

			$background_position_focal             = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet      = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile      = self::get_background_position( $attr['backgroundPositionMobile'] );
			$back_background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$back_background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$back_background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal             = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet      = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile      = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
				$back_background_position_focal        = self::get_background_position( $attr['backBackgroundPositionFocal'] );
				$back_background_position_focal_tablet = self::get_background_position( $attr['backBackgroundPositionFocalTablet'] );
				$back_background_position_focal_mobile = self::get_background_position( $attr['backBackgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' '               => array(
					'display'       => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'margin-top'    => self::get_css_value( $attr['blockTopMargin'], 'px' ) . ' !important',
					'margin-right'  => self::get_css_value( $attr['blockRightMargin'], 'px' ) . ' !important',
					'margin-bottom' => self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ' !important',
					'margin-left'   => self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ' !important',
					'position'      => 'relative',
					'z-index'       => $attr['z_index'],
				),
				' .wp-block-responsive-block-editor-addons-flip-box' => array(
					'height' => self::get_css_value( $attr['height'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box .flip-box-inner' => array(
					'transition' => $flipbox_transition,
				),
				' .wp-block-responsive-block-editor-addons-flip-box .flip-box-front' => array(
					'background-image'           => $background_front,
					'background-position'        => $background_position_focal,
					'background-attachment'      => $attr['backgroundAttachment'],
					'background-repeat'          => $attr['backgroundRepeat'],
					'background-size'            => $attr['backgroundSize'],
					'background-color'           => self::hex_to_rgb( $attr['frontBackgroundColor'], $coloropacity ),
					'color'                      => $attr['frontTitleTypographyColor'],
					'text-transform'             => $attr['frontTitleTextTransform'],
					'font-style'                 => $attr['frontTitleFontStyle'],
					'border-color'               => 'empty' !== $attr['borderColor'] && ! $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'], // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'], // For compatibility with v1.3.2.
					'border-width'               => 999 !== $attr['borderWidth'] && 2 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
					'height'                     => self::get_css_value( $attr['height'], 'px' ),
					'padding-top'                => 999 !== $attr['topPadding'] && 0 === $attr['frontTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['frontTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['bottomPadding'] && 0 === $attr['frontBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['frontBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['leftPadding'] && 0 === $attr['frontLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['frontLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['frontRightPadding'] && 0 === $attr['rightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['frontRightPadding'], 'px' ),  // For compatibility with v1.3.2.
				),
				' .wp-block-responsive-block-editor-addons-flip-box .flip-box-front:hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),
				' .wp-block-responsive-block-editor-addons-flip-box__title' => array(
					'color'       => $attr['frontTitleTypographyColor'],
					'font-family' => $attr['frontTitleFontFamily'],
					'font-size'   => self::get_css_value( $attr['frontTitleFontSize'], 'px' ),
					'font-weight' => $attr['frontTitleFontWeight'],
					'line-height' => $attr['frontTitleLineHeight'],
					'text-transform'   => $attr['frontTitleTextTransform'],
					'font-style'       => $attr['frontTitleFontStyle'],
				),
				' .wp-block-responsive-block-editor-addons-flip-box__subtitle' => array(
					'color'       => $attr['frontTitleTypographyColor'],
					'font-family' => $attr['frontSubtitleFontFamily'],
					'font-size'   => self::get_css_value( $attr['frontSubtitleFontSize'], 'px' ),
					'font-weight' => $attr['frontSubtitleFontWeight'],
					'line-height' => $attr['frontSubtitleLineHeight'],
					'text-transform'   => $attr['frontSubtitleTextTransform'],
					'font-style'       => $attr['frontSubtitleFontStyle'],
				),
				' .flip-box-back' => array(
					'background-image'           => $background_back,
					'background-position'        => $back_background_position_focal,
					'background-attachment'      => $attr['backBackgroundAttachment'],
					'background-repeat'          => $attr['backBackgroundRepeat'],
					'background-size'            => $attr['backBackgroundSize'],
					'background-color'           => self::hex_to_rgb( $attr['backBackgroundColor'], $backcoloropacity ),
					'color'                      => $attr['backTitleTypographyColor'],
					'text-transform'             => $attr['backTitleTextTransform'],
					'font-style'                 => $attr['backTitleFontStyle'],
					'transform'                  => $flip_style_back,
					'border-color'               => 'empty' !== $attr['borderColor'] && ! $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'], // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'], // For compatibility with v1.3.2.
					'border-width'               => 999 !== $attr['borderWidth'] && 2 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
					'height'                     => self::get_css_value( $attr['height'], 'px' ),
					'padding-top'                => 999 !== $attr['backtopPadding'] && 0 === $attr['backTopPadding'] ? self::get_css_value( $attr['backtopPadding'], 'px' ) : self::get_css_value( $attr['backTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['backbottomPadding'] && 0 === $attr['backBottomPadding'] ? self::get_css_value( $attr['backbottomPadding'], 'px' ) : self::get_css_value( $attr['backBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['backleftPadding'] && 0 === $attr['backLeftPadding'] ? self::get_css_value( $attr['backleftPadding'], 'px' ) : self::get_css_value( $attr['backLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['backrightPadding'] && 0 === $attr['backRightPadding'] ? self::get_css_value( $attr['backrightPadding'], 'px' ) : self::get_css_value( $attr['backRightPadding'], 'px' ), // For compatibility with v1.3.2.
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backtitle' => array(
					'color'       => $attr['backTitleTypographyColor'],
					'text-transform'   => $attr['backTitleTextTransform'],
					'font-style'       => $attr['backTitleFontStyle'],
					'font-family' => $attr['backTitleFontFamily'],
					'font-size'   => self::get_css_value( $attr['backTitleFontSize'], 'px' ),
					'font-weight' => $attr['backTitleFontWeight'],
					'line-height' => $attr['backTitleLineHeight'],
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backsubtitle' => array(
					'color'       => $attr['backTitleTypographyColor'],
					'text-transform'   => $attr['backSubtitleTextTransform'],
					'font-style'       => $attr['backSubtitleFontStyle'],
					'font-family' => $attr['backSubtitleFontFamily'],
					'font-size'   => self::get_css_value( $attr['backSubtitleFontSize'], 'px' ),
					'font-weight' => $attr['backSubtitleFontWeight'],
					'line-height' => $attr['backSubtitleLineHeight'],
				),
				' .wp-block-responsive-block-editor-addons-flip-box-dashicon-fronticon-wrap' => array(
					'font-size' => self::get_css_value( $attr['iconSize'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box-dashicon-fronticon-wrap svg' => array(
					'font-size' => self::get_css_value( $attr['iconSize'], 'px' ),
					'fill'      => $attr['iconColor'],
					'height'    => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'     => self::get_css_value( $attr['iconSize'], 'px' ),
				),
				' .dashicons'     => array(
					'width'  => 'auto !important',
					'height' => 'auto !important',
				),
				' .wp-block-responsive-block-editor-addons-flip-box-dashicon-backicon-wrap' => array(
					'font-size' => self::get_css_value( $attr['backIconSize'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box-dashicon-backicon-wrap svg' => array(
					'font-size' => self::get_css_value( $attr['backIconSize'], 'px' ),
					'fill'      => $attr['backIconColor'],
					'height'    => self::get_css_value( $attr['backIconSize'], 'px' ),
					'width'     => self::get_css_value( $attr['backIconSize'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flipbox-item__button.wp-block-button__link' => array(
					'border-style'               => $attr['ctaBorderStyle'],
					'border-width'               => self::get_css_value( $attr['ctaBorderWidth'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadius'], 'px' ),
					'border-color'               => $attr['ctaBorderColor'],
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPadding'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPadding'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPadding'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPadding'], 'px' ),
					'background-image'           => $background_image_gradient,
					'background-color'           => $btn_color . '!important',
					'opacity'                    => $btn_opacity / 100,
					'color'                      => $attr['ctaColor'] . '!important',
					'font-family'                => $attr['backButtonFontFamily'],
					'font-size'                  => self::get_css_value( $attr['backButtonFontSize'], 'px' ),
					'font-weight'                => $attr['backButtonFontWeight'],
					'line-height'                => $attr['backButtonLineHeight'],
					'text-transform'             => $attr['backButtonTextTransform'],
					'font-style'                 => $attr['backButtonFontStyle'],
				),
				' .wp-block-responsive-block-editor-addons-flipbox-item__button.wp-block-button__link:hover' => array(
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $background_hover_image_gradient,
					'background-color' => $btn_h_color . '!important',
					'border-color'     => $attr['ctaHoverBorderColor'],
					'opacity'          => $btn_h_opacity / 100,
					'color'            => $attr['ctaHoverColor'] . '!important',
				),
				' .has-medium-gutter.has-2-columns > *:not(.block-editor-inner-blocks)' => array(
					'max-width' => 'calc(100% / 2 - ' . $attr['flipBoxGutterGap'] . 'px) !important',
				),
				' .has-medium-gutter.has-3-columns > *:not(.block-editor-inner-blocks)' => array(
					'max-width' => 'calc(100% / 3 - ' . $attr['flipBoxGutterGap'] . 'px) !important',
				),
				' .has-medium-gutter.has-4-columns > *:not(.block-editor-inner-blocks)' => array(
					'max-width' => 'calc(100% / 4 - ' . $attr['flipBoxGutterGap'] . 'px) !important',
				),
			);
			$mobile_selectors = array(
				' .has-medium-gutter.responsive-flipbox-columns__stack-mobile > *:not(.block-editor-inner-blocks)' => array(
					'min-width' => '100%',
					'max-width' => '100%',
				),
				' .has-medium-gutter.responsive-flipbox-columns__stack-mobile > .wp-block-responsive-block-editor-addons-flip-box:not(:last-child)' => array(
					'margin-bottom' => self::get_css_value( $attr['flipBoxGutterGap'], 'px' ),
				),
				' '               => array(
					'margin-top'    => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ' !important',
					'margin-right'  => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ' !important',
					'margin-bottom' => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ' !important',
					'margin-left'   => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ' !important',
					'z-index'       => $attr['z_indexMobile'],
					'display'       => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
				),
				' .wp-block-responsive-block-editor-addons-flip-box .flip-box-front' => array(
					'background-position'        => $background_position_focal_mobile,
					'background-size'            => $attr['backgroundSizeMobile'],
					'padding-top'                => self::get_css_value( $attr['frontTopPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['frontBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['frontLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['frontRightPaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .flip-box-back' => array(
					'background-position'        => $back_background_position_focal_mobile,
					'background-size'            => $attr['backBackgroundSizeMobile'],
					'padding-top'                => self::get_css_value( $attr['backTopPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['backBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['backLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['backRightPaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__title' => array(
					'font-size' => self::get_css_value( $attr['frontTitleFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__subtitle' => array(
					'font-size' => self::get_css_value( $attr['frontSubtitleFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backtitle' => array(
					'font-size' => self::get_css_value( $attr['backTitleFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backsubtitle' => array(
					'font-size' => self::get_css_value( $attr['backSubtitleFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flipbox-item__button.wp-block-button__link' => array(
					'font-size'                  => self::get_css_value( $attr['backButtonFontSizeMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPaddingMobile'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' .has-medium-gutter.responsive-flipbox-columns__stack-tablet > *:not(.block-editor-inner-blocks)' => array(
					'min-width' => '100%',
					'max-width' => '100%',
				),
				' .has-medium-gutter.responsive-flipbox-columns__stack-tablet > .wp-block-responsive-block-editor-addons-flip-box:not(:last-child)' => array(
					'margin-bottom' => self::get_css_value( $attr['flipBoxGutterGap'], 'px' ),
				),
				' '               => array(
					'margin-top'    => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ' !important',
					'margin-right'  => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ' !important',
					'margin-bottom' => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ' !important',
					'margin-left'   => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ' !important',
					'z-index'       => $attr['z_indexTablet'],
					'display'       => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
				),
				' .wp-block-responsive-block-editor-addons-flip-box .flip-box-front' => array(
					'background-position'        => $background_position_focal_tablet,
					'background-size'            => $attr['backgroundSizeTablet'],
					'padding-top'                => self::get_css_value( $attr['frontTopPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['frontBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['frontLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['frontRightPaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .flip-box-back' => array(
					'background-position'        => $back_background_position_focal_tablet,
					'background-size'            => $attr['backBackgroundSizeTablet'],
					'padding-top'                => self::get_css_value( $attr['backTopPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['backBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['backLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['backRightPaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__title' => array(
					'font-size' => self::get_css_value( $attr['frontTitleFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__subtitle' => array(
					'font-size' => self::get_css_value( $attr['frontSubtitleFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backtitle' => array(
					'font-size' => self::get_css_value( $attr['backTitleFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flip-box__backsubtitle' => array(
					'font-size' => self::get_css_value( $attr['backSubtitleFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-flipbox-item__button.wp-block-button__link' => array(
					'font-size'                  => self::get_css_value( $attr['backButtonFontSizeTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPaddingTablet'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-flipbox.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for flipbox block
		 *
		 * @return array
		 */
		public static function get_responsive_block_flipbox_default_attributes() {
			return array(
				'block_id'                     => '',
				'flipboxArray'                 => '',
				'count'                        => '',
				'height'                       => 420,
				'iconSize'                     => 50,
				'backIconSize'                 => 50,
				'transitionSpeed'              => 8,
				'backgroundImage'              => '',
				'backgroundPosition'           => 'center center',
				'backgroundAttachment'         => 'scroll',
				'backgroundRepeat'             => 'no-repeat',
				'backgroundSize'               => 'cover',
				'backBackgroundImage'          => '',
				'backBackgroundPosition'       => 'center center',
				'backBackgroundAttachment'     => 'scroll',
				'backBackgroundRepeat'         => 'no-repeat',
				'backBackgroundSize'           => 'cover',
				'imagePositionTab'             => 'desktop',
				'backgroundSizeTablet'         => 'cover',
				'backgroundSizeMobile'         => 'cover',
				'backgroundPositionMobile'     => 'center center',
				'backgroundPositionTablet'     => 'center center',
				'backgroundPositionFocal'      => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'imageSizeTab'                 => 'desktop',
				'backImagePositionTab'         => 'desktop',
				'backBackgroundSizeTablet'     => 'cover',
				'backBackgroundSizeMobile'     => 'cover',
				'backBackgroundPositionMobile' => 'center center',
				'backBackgroundPositionTablet' => 'center center',
				'backBackgroundPositionFocal'  => '50% 50%',
				'backBackgroundPositionFocalMobile' => '50% 50%',
				'backBackgroundPositionFocalTablet' => '50% 50%',
				'backImageSizeTab'             => 'desktop',
				'colorOpacity'                 => 30,
				'backColorOpacity'             => 30,
				'imageOpacity'                 => 30,
				'backImageOpacity'             => 30,
				'buttonbackgroundType'         => 'none',
				'buttoncolorLocation1'         => 0,
				'buttoncolorLocation2'         => 100,
				'buttongradientDirection'      => 90,
				'buttonbackgroundColor1'       => '#333',
				'buttonbackgroundColor2'       => '',
				'buttonHTextColor'             => '#fff',
				'buttonHColor'                 => '#333',
				'buttonopacity'                => 100,
				'buttonHopacity'               => 100,
				'buttonHbackgroundType'        => 'none',
				'buttonHcolorLocation1'        => 0,
				'buttonHcolorLocation2'        => 100,
				'buttonHgradientDirection'     => 90,
				'buttonHbackgroundColor1'      => '#333',
				'buttonHbackgroundColor2'      => '',
				'buttonBorderRadius'           => 0,
				'ctaHpadding'                  => 20,
				'ctaVpadding'                  => 10,
				'buttonHPadding'               => 999, // For compatibility with v1.3.2.
				'buttonVPadding'               => 999, // For compatibility with v1.3.2.
				'iconSelected'                 => 'editor-textcolor',
				'flipStyleSelected'            => 'LTR',
				'align'                        => 'wide',
				'gutter'                       => 'medium',
				'contentAlign'                 => 'center',
				'frontTextColor'               => '',
				'frontBackgroundColor'         => '#fff',
				'backTextColor'                => '',
				'backBackgroundColor'          => '#fff',
				'buttonColor'                  => '#333',
				'buttonTextColor'              => '',
				'iconColor'                    => '',
				'backIconColor'                => '',
				'blockBorderStyle'             => 'none',
				'blockBorderWidth'             => 2,
				'blockBorderRadius'            => '',
				'blockTopRadiusMobile'         => 0,
				'blockRightRadiusMobile'       => 0,
				'blockBottomRadiusMobile'      => 0,
				'blockLeftRadiusMobile'        => 0,
				'blockTopRadiusTablet'         => 0,
				'blockRightRadiusTablet'       => 0,
				'blockBottomRadiusTablet'      => 0,
				'blockLeftRadiusTablet'        => 0,
				'blockTopRadius'               => 0,
				'blockRightRadius'             => 0,
				'blockBottomRadius'            => 0,
				'blockLeftRadius'              => 0,
				'blockBorderColor'             => '',
				'borderStyle'                  => 'empty',
				'borderWidth'                  => 999, // For compatibility with v1.3.2.
				'borderRadius'                 => 999, // For compatibility with v1.3.2.
				'borderColor'                  => 'empty', // For compatibility with v1.3.2.
				'boxShadowColor'               => '', // For compatibility with v1.3.2.
				'boxShadowHOffset'             => 0,
				'boxShadowVOffset'             => 0,
				'boxShadowBlur'                => 0,
				'boxShadowSpread'              => 0,
				'boxShadowPosition'            => 'outset',
				'hoverboxShadowColor'          => '',
				'hoverboxShadowHOffset'        => 0,
				'hoverboxShadowVOffset'        => 0,
				'hoverboxShadowBlur'           => 0,
				'hoverboxShadowSpread'         => 0,
				'hoverboxShadowPosition'       => 'outset',
				'showFrontIcon'                => true,
				'showFrontTitle'               => true,
				'showFrontSubtitle'            => true,
				'showBackIcon'                 => true,
				'showBackTitle'                => true,
				'showBackSubtitle'             => true,
				'showBackButton'               => true,
				'colorButtonSelected'          => 'front_selected',
				'topMargin'                    => '',
				'bottomMargin'                 => '',
				'frontTopPadding'              => '',
				'frontBottomPadding'           => '',
				'frontLeftPadding'             => '',
				'frontRightPadding'            => '',
				'topPadding'                   => 999, // For compatibility with v1.3.2.
				'bottomPadding'                => 999, // For compatibility with v1.3.2.
				'leftPadding'                  => 999, // For compatibility with v1.3.2.
				'rightPadding'                 => 999, // For compatibility with v1.3.2.
				'backTopPadding'               => '',
				'backBottomPadding'            => '',
				'backLeftPadding'              => '',
				'backRightPadding'             => '',
				'backtopPadding'               => 999, // For compatibility with v1.3.2.
				'backbottomPadding'            => 999, // For compatibility with v1.3.2.
				'backleftPadding'              => 999, // For compatibility with v1.3.2.
				'backrightPadding'             => 999, // For compatibility with v1.3.2.
				'topMarginMobile'              => '',
				'bottomMarginMobile'           => '',
				'frontTopPaddingMobile'        => '',
				'frontBottomPaddingMobile'     => '',
				'frontLeftPaddingMobile'       => '',
				'frontRightPaddingMobile'      => '',
				'backTopPaddingMobile'         => '',
				'backBottomPaddingMobile'      => '',
				'backLeftPaddingMobile'        => '',
				'backRightPaddingMobile'       => '',
				'topMarginTablet'              => '',
				'bottomMarginTablet'           => '',
				'frontTopPaddingTablet'        => '',
				'frontBottomPaddingTablet'     => '',
				'frontLeftPaddingTablet'       => '',
				'frontRightPaddingTablet'      => '',
				'backTopPaddingTablet'         => '',
				'backBottomPaddingTablet'      => '',
				'backLeftPaddingTablet'        => '',
				'backRightPaddingTablet'       => '',
				'flipBoxGutterGap'             => 10,
				'stack'                        => 'mobile',
				'frontTitleFontSize'           => 16,
				'frontTitleFontSizeMobile'     => 16,
				'frontTitleFontSizeTablet'     => 16,
				'frontTitleFontWeight'         => '100',
				'frontTitleLineHeight'         => 1,
				'frontTitleFontFamily'         => '',
				'frontSubtitleFontFamily'      => '',
				'frontSubtitleFontSize'        => 16,
				'frontSubtitleFontSizeMobile'  => 16,
				'frontSubtitleFontSizeTablet'  => 16,
				'frontSubtitleFontWeight'      => '100',
				'frontSubtitleLineHeight'      => 1,
				'backTitleFontSize'            => 16,
				'backTitleFontSizeMobile'      => 16,
				'backTitleFontSizeTablet'      => 16,
				'backTitleFontWeight'          => '100',
				'backTitleLineHeight'          => 1,
				'backTitleFontFamily'          => '',
				'backSubtitleFontFamily'       => '',
				'backSubtitleFontSize'         => 16,
				'backSubtitleFontSizeMobile'   => 16,
				'backSubtitleFontSizeTablet'   => 16,
				'backSubtitleFontWeight'       => '100',
				'backSubtitleLineHeight'       => 1,
				'backButtonFontSize'           => 16,
				'backButtonFontSizeMobile'     => 16,
				'backButtonFontSizeTablet'     => 16,
				'backButtonFontWeight'         => '100',
				'backButtonLineHeight'         => 1,
				'backButtonFontFamily'         => '',
				'ctaBorderWidth'               => 2,
				'ctaBorderStyle'               => 'none',
				'ctaBorderRadius'              => 0,
				'ctaVpaddingTablet'            => 10,
				'ctaVpaddingMobile'            => 10,
				'ctaHpaddingTablet'            => 20,
				'ctaHpaddingMobile'            => 20,
				'ctaHoverColor'                => '#fff',
				'ctaHoverBackColor'            => '#333',
				'ctaBackColor'                 => '#333',
				'ctaColor'                     => '',
				'ctaBorderColor'               => '#0066cc',
				'ctaHoverBorderColor'          => '#0066cc',
				'hideWidget'                   => false,
				'hideWidgetMobile'             => false,
				'hideWidgetTablet'             => false,
				'z_index'                      => 1,
				'z_indexMobile'                => 1,
				'z_indexTablet'                => 1,
				'blockTopMargin'               => '',
				'blockTopMarginMobile'         => '',
				'blockTopMarginTablet'         => '',
				'blockBottomMargin'            => '',
				'blockBottomMarginMobile'      => '',
				'blockBottomMarginTablet'      => '',
				'blockLeftMargin'              => '',
				'blockLeftMarginMobile'        => '',
				'blockLeftMarginTablet'        => '',
				'blockRightMargin'             => '',
				'blockRightMarginMobile'       => '',
				'blockRightMarginTablet'       => '',
				'frontTitleTypographyColor'    => '',
				'backTitleTypographyColor'     => '',

				'ctaButtonTopPadding'          => 10,
				'ctaButtonBottomPadding'       => 10,
				'ctaButtonLeftPadding'         => 20,
				'ctaButtonRightPadding'        => 20,
				'ctaButtonTopPaddingTablet'    => 15,
				'ctaButtonBottomPaddingTablet' => 15,
				'ctaButtonRightPaddingTablet'  => 30,
				'ctaButtonLeftPaddingTablet'   => 30,
				'ctaButtonTopPaddingMobile'    => 15,
				'ctaButtonBottomPaddingMobile' => 15,
				'ctaButtonLeftPaddingMobile'   => 30,
				'ctaButtonRightPaddingMobile'  => 30,

				'ctaBlockTopRadius'            => 0,
				'ctaBlockRightRadius'          => 0,
				'ctaBlockBottomRadius'         => 0,
				'ctaBlockLeftRadius'           => 0,
				'ctaBlockTopRadiusTablet'      => 0,
				'ctaBlockRightRadiusTablet'    => 0,
				'ctaBlockBottomRadiusTablet'   => 0,
				'ctaBlockLeftRadiusTablet'     => 0,
				'ctaBlockTopRadiusMobile'      => 0,
				'ctaBlockRightRadiusMobile'    => 0,
				'ctaBlockBottomRadiusMobile'   => 0,
				'ctaBlockLeftRadiusMobile'     => 0,
				"frontTitleTextTransform"      => '',
				"frontTitleFontStyle"          => '',
				"frontSubtitleTextTransform"   => '',
				"frontSubtitleFontStyle"       => '',
				"backTitleTextTransform"       => '',
				"backTitleFontStyle"           => '',
				"backSubtitleTextTransform"    => '',
				"backSubtitleFontStyle"        => '',
				"backButtonTextTransform"      => '',
				'backButtonFontStyle'          => '',
			);
		}

		/**
		 * Get Gallery Masonry Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_gallery_masonry_css( $attr, $id ) {
			$defaults = self::get_responsive_block_gallery_masonry_block_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' ' => array(
					'display'    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'z-index'    => $attr['z_index'],
					'--filter-tab-hover-background-color' => isset( $attr['filterTabHoverBackgroundColor'] ) ? $attr['filterTabHoverBackgroundColor'] : '#0073aa',
					'--filter-tab-hover-text-color' => isset( $attr['filterTabHoverTextColor'] ) ? $attr['filterTabHoverTextColor'] : '#fff',
				),
				'.wp-block-responsive-block-editor-addons-gallery-masonry.block-' . $attr['block_id'] => array(
					'padding-top'           => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'         => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom'        => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'          => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'            => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'          => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'         => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'           => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				'[data-rba-gallery-block] .rba-gallery-items' => array(
					'column-count'          => (int) $attr['columnsize'],
					'column-gap'            => self::get_css_value( $attr['gutter'], 'px' ),
					'position'				=> 'relative',
				),
				'[data-rba-gallery-block] .responsive-block-editor-addons-gallery--item' => array(
					'display'                => 'block',
					'width'                  => '100%',
					'break-inside'           => 'avoid',
					'-webkit-column-break-inside' => 'avoid',
					'page-break-inside'      => 'avoid',
					'margin'                 => '0 0 ' . self::get_css_value( $attr['gutter'], 'px' ) . ' 0',
					'position'				 => 'absolute',
					'width' 				 => 'calc((100% / ' . $attr['columnsize'] . ') - ' . ( $attr['gutter'] === 0 ? '0px' : self::get_css_value( $attr['gutter'], 'px' ) ) . ')',	
				),
				' .responsive-block-editor-addons-gallery--figure' => array(
					'height'                 => 'auto',
					'display'                => 'block',
					'margin-bottom'			 => self::get_css_value( $attr['gutter'], 'px' )
				),
				' .responsive-block-editor-addons-gallery--figure img' => array(
					'width'  => ( isset( $attr['customWidth'] ) && '' !== $attr['customWidth'] ) ? self::get_css_value( $attr['customWidth'], 'px' ) : '100%',
					'height' => ( isset( $attr['customHeight'] ) && '' !== $attr['customHeight'] ) ? self::get_css_value( $attr['customHeight'], 'px' ) : 'auto',
					'border-radius' => ( isset( $attr['radius'] ) && $attr['radius'] > 0 ) ? self::get_css_value( $attr['radius'], 'px' ) : '',
					'display'                => 'block',
				),
				' .is-hidden-by-default' => array(
					'display' => 'none',
				),
				' .gallery-filter-wrapper' => array(
					'margin-bottom'  => isset( $attr['filterTabBottomSpacing'] ) ? self::get_css_value( $attr['filterTabBottomSpacing'], 'px' ) : '20px',
					'text-align'     => isset( $attr['filterTabAlignment'] ) ? $attr['filterTabAlignment'] : 'left',
					'font-family'    => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'      => self::get_css_value( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '', 'px' ),
					'font-weight'    => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight'] : '',
					'line-height'    => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight'] : '',
					'letter-spacing' => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ) : '',
					'text-transform' => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'=> isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
				),
				' .gallery-filter-wrapper .gallery-filter-button' => array(
					'margin-right'   => self::get_css_value( isset( $attr['filterTabSpacingBetween'] ) ? $attr['filterTabSpacingBetween'] : 17, 'px' ),
					'margin-bottom'  => '8px',
					'padding-top'    => self::get_css_value( ( isset( $attr['filterTabTopPadding'] ) && $attr['filterTabTopPadding'] !== '' ) ? $attr['filterTabTopPadding'] : 7, 'px' ),
					'padding-right'  => self::get_css_value( ( isset( $attr['filterTabRightPadding'] ) && $attr['filterTabRightPadding'] !== '' ) ? $attr['filterTabRightPadding'] : 7, 'px' ),
					'padding-bottom' => self::get_css_value( ( isset( $attr['filterTabBottomPadding'] ) && $attr['filterTabBottomPadding'] !== '' ) ? $attr['filterTabBottomPadding'] : 7, 'px' ),
					'padding-left'   => self::get_css_value( ( isset( $attr['filterTabLeftPadding'] ) && $attr['filterTabLeftPadding'] !== '' ) ? $attr['filterTabLeftPadding'] : 7, 'px' ),
					'background-color' => isset( $attr['filterTabBackgroundColor'] ) ? $attr['filterTabBackgroundColor'] : '#F2F2F2',
					'color'            => isset( $attr['filterTabTextColor'] ) ? $attr['filterTabTextColor'] : '#000000',
					'border-top'       => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabTopBorderwidth'] ) && $attr['filterTabTopBorderwidth'] !== '' ) ? $attr['filterTabTopBorderwidth'] : 1, 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-right'     => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabRightBorderwidth'] ) && $attr['filterTabRightBorderwidth'] !== '' ) ? $attr['filterTabRightBorderwidth'] : 1, 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-bottom'    => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabBottomBorderwidth'] ) && $attr['filterTabBottomBorderwidth'] !== '' ) ? $attr['filterTabBottomBorderwidth'] : 1, 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-left'      => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabLeftBorderwidth'] ) && $attr['filterTabLeftBorderwidth'] !== '' ) ? $attr['filterTabLeftBorderwidth'] : 1, 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-radius'    => '4px',
					'cursor'           => 'pointer',
					'font-family'      => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'        => self::get_css_value( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '', 'px' ),
					'font-weight'      => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight'] : '',
					'font-style'       => isset( $attr['filterTabTypographyFontStyle'] ) ? $attr['filterTabTypographyFontStyle'] : 'normal',
					'line-height'      => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight'] : '',
					'letter-spacing'   => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ) : '',
					'text-transform'   => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'  => isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
				),
				' .gallery-filter-wrapper .gallery-filter-button:hover, .gallery-filter-wrapper .gallery-filter-button.is-active' => array(
					'background-color' => ( isset( $attr['filterTabHoverBackgroundColor'] ) ? $attr['filterTabHoverBackgroundColor'] : '#0073aa' ),
   					'color'            => ( isset( $attr['filterTabHoverTextColor'] ) ? $attr['filterTabHoverTextColor'] : '#ffffff' ),
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display'    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'    => $attr['z_indexMobile'],
				),
				'.wp-block-responsive-block-editor-addons-gallery-masonry.block-' . $attr['block_id'] => array(
					'padding-top'           => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'         => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom'        => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'          => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'            => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'          => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'         => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'           => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				'[data-rba-gallery-block] .rba-gallery-items' => array(
					'column-count'   => (int) $attr['columnsize'],
					'column-gap'     => self::get_css_value( $attr['gutterMobile'], 'px' ),
				),
				'[data-rba-gallery-block] .responsive-block-editor-addons-gallery--item' => array(
					'display'                => 'block',
					'width'                  => '100%',
					'break-inside'           => 'avoid',
					'-webkit-column-break-inside' => 'avoid',
					'page-break-inside'      => 'avoid',
					'margin'                 => '0 0 ' . self::get_css_value( $attr['gutterMobile'], 'px' ) . ' 0',
					'width' 				 => 'calc((100% / ' . $attr['columnsize'] . ') - ' . ( $attr['gutterMobile'] === 0 ? '0px' : self::get_css_value( $attr['gutterMobile'], 'px' ) ) . ')',
				),
				' .responsive-block-editor-addons-gallery--figure' => array(
					'margin-bottom'			 => self::get_css_value( $attr['gutterMobile'], 'px' )
				),
				' .gallery-filter-wrapper' => array(
					'margin-bottom'  => ( $v = ( isset( $attr['filterTabBottomSpacingMobile'] ) ? self::get_css_value( $attr['filterTabBottomSpacingMobile'], 'px' ) : ( isset( $attr['filterTabBottomSpacing'] ) ? self::get_css_value( $attr['filterTabBottomSpacing'], 'px' ) : '20px' ) ) ) ? $v : '',
					'text-align' => $attr['filterTabAlignmentMobile'] ?? 'left',
					'font-family'    => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'      => self::get_css_value( isset( $attr['filterTabTypographyFontSizeMobile'] ) ? $attr['filterTabTypographyFontSizeMobile'] : ( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '' ), 'px' ),
					'font-weight'    => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight'] : '',
					'line-height'    => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight'] : '',
					'letter-spacing' => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ) : '',
					'text-transform' => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'=> isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
				),
				' .gallery-filter-wrapper .gallery-filter-button' => array(
					'font-family'      => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'        => self::get_css_value( isset( $attr['filterTabTypographyFontSizeMobile'] ) ? $attr['filterTabTypographyFontSizeMobile'] : ( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '' ), 'px' ),
					'font-weight'      => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight']: '',
					'line-height'      => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight']: '',
					'letter-spacing'   => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ): '',
					'text-transform'   => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'  => isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
					'padding-top'      => ( $v = self::get_css_value( ( isset( $attr['filterTabTopPaddingMobile'] ) && $attr['filterTabTopPaddingMobile'] !== '' ) ? $attr['filterTabTopPaddingMobile'] : ( ( isset( $attr['filterTabTopPadding'] ) && $attr['filterTabTopPadding'] !== '' ) ? $attr['filterTabTopPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-right'    => ( $v = self::get_css_value( ( isset( $attr['filterTabRightPaddingMobile'] ) && $attr['filterTabRightPaddingMobile'] !== '' ) ? $attr['filterTabRightPaddingMobile'] : ( ( isset( $attr['filterTabRightPadding'] ) && $attr['filterTabRightPadding'] !== '' ) ? $attr['filterTabRightPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-bottom'   => ( $v = self::get_css_value( ( isset( $attr['filterTabBottomPaddingMobile'] ) && $attr['filterTabBottomPaddingMobile'] !== '' ) ? $attr['filterTabBottomPaddingMobile'] : ( ( isset( $attr['filterTabBottomPadding'] ) && $attr['filterTabBottomPadding'] !== '' ) ? $attr['filterTabBottomPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-left'     => ( $v = self::get_css_value( ( isset( $attr['filterTabLeftPaddingMobile'] ) && $attr['filterTabLeftPaddingMobile'] !== '' ) ? $attr['filterTabLeftPaddingMobile'] : ( ( isset( $attr['filterTabLeftPadding'] ) && $attr['filterTabLeftPadding'] !== '' ) ? $attr['filterTabLeftPadding'] : 7 ), 'px' ) ) ? $v : '',
					'margin-right'     => ( $v = self::get_css_value( isset( $attr['filterTabSpacingBetweenMobile'] ) ? $attr['filterTabSpacingBetweenMobile'] : ( isset( $attr['filterTabSpacingBetween'] ) ? $attr['filterTabSpacingBetween'] : 17 ), 'px' ) ) ? $v : '',
					'background-color' => isset( $attr['filterTabBackgroundColor'] ) ? $attr['filterTabBackgroundColor'] : '#F2F2F2',
					'color'            => isset( $attr['filterTabTextColor'] ) ? $attr['filterTabTextColor'] : '#000000',
					'border-radius'    => '4px',
					'cursor'           => 'pointer',
					'border-top'       => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabTopBorderwidthMobile'] ) && $attr['filterTabTopBorderwidthMobile'] !== '' ) ? $attr['filterTabTopBorderwidthMobile'] : ( ( isset( $attr['filterTabTopBorderwidth'] ) && $attr['filterTabTopBorderwidth'] !== '' ) ? $attr['filterTabTopBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-right'     => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabRightBorderwidthMobile'] ) && $attr['filterTabRightBorderwidthMobile'] !== '' ) ? $attr['filterTabRightBorderwidthMobile'] : ( ( isset( $attr['filterTabRightBorderwidth'] ) && $attr['filterTabRightBorderwidth'] !== '' ) ? $attr['filterTabRightBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-bottom'    => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabBottomBorderwidthMobile'] ) && $attr['filterTabBottomBorderwidthMobile'] !== '' ) ? $attr['filterTabBottomBorderwidthMobile'] : ( ( isset( $attr['filterTabBottomBorderwidth'] ) && $attr['filterTabBottomBorderwidth'] !== '' ) ? $attr['filterTabBottomBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-left'      => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabLeftBorderwidthMobile'] ) && $attr['filterTabLeftBorderwidthMobile'] !== '' ) ? $attr['filterTabLeftBorderwidthMobile'] : ( ( isset( $attr['filterTabLeftBorderwidth'] ) && $attr['filterTabLeftBorderwidth'] !== '' ) ? $attr['filterTabLeftBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
				),
				' .gallery-filter-wrapper .gallery-filter-button:hover, .gallery-filter-wrapper .gallery-filter-button.is-active' => array(
					'background-color' => ( isset( $attr['filterTabHoverBackgroundColor'] ) ? $attr['filterTabHoverBackgroundColor'] : '#0073aa' ),
					'color'            => ( isset( $attr['filterTabHoverTextColor'] ) ? $attr['filterTabHoverTextColor'] : '#ffffff' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'    => $attr['z_indexTablet'],
				),
				'.wp-block-responsive-block-editor-addons-gallery-masonry.block-' . $attr['block_id'] => array(
					'padding-top'           => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'         => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom'        => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'          => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'            => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'          => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'         => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'           => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				'[data-rba-gallery-block] .rba-gallery-items' => array(
					'column-count'          => (int) $attr['columnsize'],
					'column-gap'            => self::get_css_value( $attr['gutterTablet'], 'px' ),
				),
				'[data-rba-gallery-block] .responsive-block-editor-addons-gallery--item' => array(
					'display'                => 'block',
					'width'                  => '100%',
					'break-inside'           => 'avoid',
					'-webkit-column-break-inside' => 'avoid',
					'page-break-inside'      => 'avoid',
					'margin'                 => '0 0 ' . self::get_css_value( $attr['gutterTablet'], 'px' ) . ' 0',
					'width' 				 => 'calc((100% / ' . $attr['columnsize'] . ') - ' . ( $attr['gutterTablet'] === 0 ? '0px' : self::get_css_value( $attr['gutterTablet'], 'px' ) ) . ')',	
				),
				' .responsive-block-editor-addons-gallery--figure' => array(
					'margin-bottom'			 => self::get_css_value( $attr['gutterTablet'], 'px' )
				),
				' .gallery-filter-wrapper' => array(
					'margin-bottom' => '' !== ( $v = ( isset( $attr['filterTabBottomSpacingTablet'] ) ? self::get_css_value( $attr['filterTabBottomSpacingTablet'], 'px' ) : ( isset( $attr['filterTabBottomSpacing'] ) ? self::get_css_value( $attr['filterTabBottomSpacing'], 'px' ) : '20px' ) ) ) ? $v : '',
					'text-align' => $attr['filterTabAlignmentTablet'] ?? 'left',
					'font-family'    => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'      => self::get_css_value( isset( $attr['filterTabTypographyFontSizeTablet'] ) ? $attr['filterTabTypographyFontSizeTablet'] : ( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '' ), 'px' ),
					'font-weight'    => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight'] : '',
					'line-height'    => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight'] : '',
					'letter-spacing' => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ) : '',
					'text-transform' => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'=> isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
				),
				' .gallery-filter-wrapper .gallery-filter-button' => array(
					'font-family'      => isset( $attr['filterTabTypographyFontFamily'] ) && 'Default' !== $attr['filterTabTypographyFontFamily'] ? $attr['filterTabTypographyFontFamily'] : '',
					'font-size'        => self::get_css_value( isset( $attr['filterTabTypographyFontSizeTablet'] ) ? $attr['filterTabTypographyFontSizeTablet'] : ( isset( $attr['filterTabTypographyFontSize'] ) ? $attr['filterTabTypographyFontSize'] : '' ), 'px' ),
					'font-weight'      => ( isset( $attr['filterTabTypographyFontWeight'] ) && '' !== $attr['filterTabTypographyFontWeight'] ) ? $attr['filterTabTypographyFontWeight'] : '',
					'line-height'      => ( isset( $attr['filterTabTypographyLineHeight'] ) && '' !== $attr['filterTabTypographyLineHeight'] ) ? $attr['filterTabTypographyLineHeight'] : '',
					'letter-spacing'   => ( isset( $attr['filterTabTypographyLetterSpacing'] ) && '' !== $attr['filterTabTypographyLetterSpacing'] ) ? self::get_css_value( $attr['filterTabTypographyLetterSpacing'], 'px' ) : '',
					'text-transform'   => isset( $attr['filterTabTypographyTextTransform'] ) ? $attr['filterTabTypographyTextTransform'] : '',
					'text-decoration'  => isset( $attr['filterTabTypographyTextDecoration'] ) ? $attr['filterTabTypographyTextDecoration'] : '',
					'padding-top'    => '' !== ( $v = self::get_css_value( ( isset( $attr['filterTabTopPaddingTablet'] ) && $attr['filterTabTopPaddingTablet'] !== '' ) ? $attr['filterTabTopPaddingTablet'] : ( ( isset( $attr['filterTabTopPadding'] ) && $attr['filterTabTopPadding'] !== '' ) ? $attr['filterTabTopPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-right'  => '' !== ( $v = self::get_css_value( ( isset( $attr['filterTabRightPaddingTablet'] ) && $attr['filterTabRightPaddingTablet'] !== '' ) ? $attr['filterTabRightPaddingTablet'] : ( ( isset( $attr['filterTabRightPadding'] ) && $attr['filterTabRightPadding'] !== '' ) ? $attr['filterTabRightPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-bottom' => '' !== ( $v = self::get_css_value( ( isset( $attr['filterTabBottomPaddingTablet'] ) && $attr['filterTabBottomPaddingTablet'] !== '' ) ? $attr['filterTabBottomPaddingTablet'] : ( ( isset( $attr['filterTabBottomPadding'] ) && $attr['filterTabBottomPadding'] !== '' ) ? $attr['filterTabBottomPadding'] : 7 ), 'px' ) ) ? $v : '',
					'padding-left'   => '' !== ( $v = self::get_css_value( ( isset( $attr['filterTabLeftPaddingTablet'] ) && $attr['filterTabLeftPaddingTablet'] !== '' ) ? $attr['filterTabLeftPaddingTablet'] : ( ( isset( $attr['filterTabLeftPadding'] ) && $attr['filterTabLeftPadding'] !== '' ) ? $attr['filterTabLeftPadding'] : 7 ), 'px' ) ) ? $v : '',
					'margin-right' => '' !== ( $v = self::get_css_value( isset( $attr['filterTabSpacingBetweenTablet'] ) ? $attr['filterTabSpacingBetweenTablet'] : ( isset( $attr['filterTabSpacingBetween'] ) ? $attr['filterTabSpacingBetween'] : 17 ), 'px' ) ) ? $v : '',
					'background-color' => isset( $attr['filterTabBackgroundColor'] ) ? $attr['filterTabBackgroundColor'] : '#F2F2F2',
					'color'            => isset( $attr['filterTabTextColor'] ) ? $attr['filterTabTextColor'] : '#000000',
					'border-radius'    => '4px',
					'cursor'           => 'pointer',
					'border-top'       => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabTopBorderwidthTablet'] ) && $attr['filterTabTopBorderwidthTablet'] !== '' ) ? $attr['filterTabTopBorderwidthTablet'] : ( ( isset( $attr['filterTabTopBorderwidth'] ) && $attr['filterTabTopBorderwidth'] !== '' ) ? $attr['filterTabTopBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-right'     => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabRightBorderwidthTablet'] ) && $attr['filterTabRightBorderwidthTablet'] !== '' ) ? $attr['filterTabRightBorderwidthTablet'] : ( ( isset( $attr['filterTabRightBorderwidth'] ) && $attr['filterTabRightBorderwidth'] !== '' ) ? $attr['filterTabRightBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-bottom'    => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabBottomBorderwidthTablet'] ) && $attr['filterTabBottomBorderwidthTablet'] !== '' ) ? $attr['filterTabBottomBorderwidthTablet'] : ( ( isset( $attr['filterTabBottomBorderwidth'] ) && $attr['filterTabBottomBorderwidth'] !== '' ) ? $attr['filterTabBottomBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
					'border-left'      => ( isset( $attr['filterTabBorderStyle'] ) && 'none' !== $attr['filterTabBorderStyle'] ) ? self::get_css_value( ( isset( $attr['filterTabLeftBorderwidthTablet'] ) && $attr['filterTabLeftBorderwidthTablet'] !== '' ) ? $attr['filterTabLeftBorderwidthTablet'] : ( ( isset( $attr['filterTabLeftBorderwidth'] ) && $attr['filterTabLeftBorderwidth'] !== '' ) ? $attr['filterTabLeftBorderwidth'] : 1 ), 'px' ) . ' ' . $attr['filterTabBorderStyle'] . ' ' . ( isset( $attr['filterTabBorderColor'] ) ? $attr['filterTabBorderColor'] : '#000000' ) : 'none',
				),
				' .gallery-filter-wrapper .gallery-filter-button:hover, .gallery-filter-wrapper .gallery-filter-button.is-active' => array(
					'background-color' => ( isset( $attr['filterTabHoverBackgroundColor'] ) ? $attr['filterTabHoverBackgroundColor'] : '#0073aa' ),
					'color'            => ( isset( $attr['filterTabHoverTextColor'] ) ? $attr['filterTabHoverTextColor'] : '#ffffff' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.wp-block-responsive-block-editor-addons-gallery-masonry.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for gallery masonry block
		 *
		 * @return array
		 */
		public static function get_responsive_block_gallery_masonry_block_default_attributes() {
			return array(
				'block_id'                 => '',
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'gutter'       			   => 15,
				'gutterTablet' 			   => 15,
				'gutterMobile' 			   => 15,
				'customWidth'              => '',
				'customHeight'             => '',
				'columnsize'               => 3,
				'filterTabRightPaddingMobile' => 30,
			);
		}

		/**
		 * Get Googlemap Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_googlemap_css( $attr, $id ) {
			$defaults = self::get_responsive_block_googlemap_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' '       => array(
					'display'    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'max-height' => $attr['height'] ? self::get_css_value( $attr['height'], 'px' ) : '400px',
					'position'   => 'relative',
					'z-index'    => $attr['z_index'],
				),
				' iframe' => array(
					'width'  => '100%',
					'height' => $attr['height'] ? self::get_css_value( $attr['height'], 'px' ) : '400px',
				),
			);
			$mobile_selectors = array(
				' '       => array(
					'display'    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'max-height' => self::get_css_value( $attr['heightMobile'], 'px' ),
					'z-index'    => $attr['z_indexMobile'],
				),
				' iframe' => array(
					'width'  => '100%',
					'height' => self::get_css_value( $attr['heightMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '       => array(
					'display'    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'max-height' => self::get_css_value( $attr['heightTablet'], 'px' ),
					'z-index'    => $attr['z_indexTablet'],
				),
				' iframe' => array(
					'width'  => '100%',
					'height' => self::get_css_value( $attr['heightTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id              = '.responsive-block-editor-addons-block-googlemap.block-' . $id;
			$css             = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			$css['mobile']  .= '
				.wp-block-responsive-block-editor-addons-googlemap.responsive-block-editor-addons-block-googlemap {
                    padding-top: ' . self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ';
                }
            ';
			$css['desktop'] .= '
                .wp-block-responsive-block-editor-addons-googlemap.responsive-block-editor-addons-block-googlemap {
                    padding-top: ' . self::get_css_value( $attr['blockTopPadding'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPadding'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPadding'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPadding'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMargin'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMargin'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ';
                }
            ';
			$css['tablet']  .= '
                .wp-block-responsive-block-editor-addons-googlemap.responsive-block-editor-addons-block-googlemap {
                    padding-top: ' . self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ';
                }
            ';
			return $css;
		}

		/**
		 * Get Defaults for googlemap block
		 *
		 * @return array
		 */
		public static function get_responsive_block_googlemap_default_attributes() {
			return array(
				'address'                  => '',
				'apiKey'                   => '',
				'zoom'                     => 12,
				'height'                   => 400,
				'heightTablet'             => '',
				'heightMobile'             => '',
				'pinned'                   => false,
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
			);
		}

		/**
		 * Get Icon List Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_icon_list_css( $attr, $id ) {
			$defaults = self::get_responsive_block_icon_list_block_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadius'        => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadius'       => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadius'         => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusTablet'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusTablet'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusTablet' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusTablet'   => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusMobile'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusMobile'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusMobile' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusMobile'   => 'borderRadius' ? 'borderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$editor_gap = 0;
			if ( '' !== $attr['gap'] ) { //phpcs:ignore
				$editor_gap = $attr['gap'];
			}

			$alignment = 'center';
			if ( 'left' === $attr['align'] ) {
				$alignment = 'flex-start';
			}
			if ( 'right' === $attr['align'] ) {
				$alignment = 'flex-end';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon svg' => array(
					'width'  => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				'.responsive-block-editor-addons-icon-list__layout-horizontal .wp-block-responsive-block-editor-addons-icons-list-child' => array(
					'margin-left'  => self::get_css_value( $editor_gap / 2, 'px' ),
					'margin-right' => self::get_css_value( $editor_gap / 2, 'px' ),
				),
				'.responsive-block-editor-addons-icon-list__layout-horizontal .wp-block-responsive-block-editor-addons-icons-list-child:first-child' => array(
					'margin-left' => '0',
				),
				'.responsive-block-editor-addons-icon-list__layout-horizontal .wp-block-responsive-block-editor-addons-icons-list-child:nth-last-child(2)' => array(
					'margin-right' => '0',
				),
				'.responsive-block-editor-addons-icon-list__layout-vertical .responsive-block-editor-addons-icon-list__content-wrap' => array(
					'margin-bottom' => self::get_css_value( $editor_gap, 'px' ),
				),
				'.responsive-block-editor-addons-icon-list__layout-vertical .wp-block-responsive-block-editor-addons-icons-list-child:last-child .responsive-block-editor-addons-icon-list__content-wrap' => array(
					'margin-bottom' => '0px',
				),
				' .responsive-block-editor-addons-icon-list__source-wrap' => array(
					'padding'                    => self::get_css_value( $attr['bgSize'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-width'               => self::get_css_value( $attr['border'], 'px' ),
					'margin-right'               => $attr['hideLabel'] ? '0px' : self::get_css_value( $attr['inner_gap'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon' => array(
					'width'     => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height'    => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'font-size' => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__source-image' => array(
					'width'  => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__label-wrap' => array(
					'text-align' => $attr['align'],
				),
				' .responsive-block-editor-addons-icon-list__wrap' => array(
					'align-items'     => $alignment,
					'justify-content' => $alignment,
				),
				'.responsive-block-editor-addons-icon-list__layout-horizontal .block-editor-block-list__layout' => array(
					'justify-content'  => $alignment,
					'-webkit-box-pack' => $alignment,
					'-ms-flex-pack'    => $alignment,
				),
				' .responsive-block-editor-addons-icon-list__label' => array(
					'font-family' => $attr['labelFontFamily'],
					'font-weight' => $attr['labelFontWeight'],
					'line-height' => 999 !== $attr['labelFontLineHeight'] && 1 === $attr['labelLineHeight'] ? $attr['labelFontLineHeight'] : $attr['labelLineHeight'], // For compatibility with v1.3.2.
					'font-size'   => self::get_css_value( $attr['labelFontSize'], 'px' ),
					'text-transform'  => $attr['labelTextTransform'],
					'font-style'      => $attr['labelFontStyle'],
				),
			);
			$alignment = 'center';
			if ( 'left' === $attr['alignMobile'] ) {
				$alignment = 'flex-start';
			}
			if ( 'right' === $attr['alignMobile'] ) {
				$alignment = 'flex-end';
			}
			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon' => array(
					'width'  => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon svg' => array(
					'width'  => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__label' => array(
					'font-size' => $attr['labelFontSizeMobile'] ? self::get_css_value( $attr['labelFontSizeMobile'], 'px' ) : self::get_css_value( $attr['labelFontSize'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-wrap' => array(
					'padding'                    => $attr['bgSizeMobile'] ? self::get_css_value( $attr['bgSizeMobile'], 'px' ) : self::get_css_value( $attr['bgSize'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__wrap' => array(
					'align-items'     => $alignment,
					'justify-content' => $alignment,
				),
			);

			$alignment = 'center';
			if ( 'left' === $attr['alignTablet'] ) {
				$alignment = 'flex-start';
			}
			if ( 'right' === $attr['alignTablet'] ) {
				$alignment = 'flex-end';
			}
			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon' => array(
					'width'  => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__source-icon svg' => array(
					'width'  => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
					'height' => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], $attr['fontSizeType'] ) : self::get_css_value( $attr['size'], $attr['fontSizeType'] ),
				),
				' .responsive-block-editor-addons-icon-list__label' => array(
					'font-size' => $attr['labelFontSizeTablet'] ? self::get_css_value( $attr['labelFontSizeTablet'], 'px' ) : self::get_css_value( $attr['labelFontSize'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__source-wrap' => array(
					'padding'                    => $attr['bgSizeTablet'] ? self::get_css_value( $attr['bgSizeTablet'], 'px' ) : self::get_css_value( $attr['bgSize'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-icon-list__wrap' => array(
					'align-items'     => $alignment,
					'justify-content' => $alignment,
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-icon-list__outer-wrap.responsive-block-editor-addons-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for icon list block
		 *
		 * @return array
		 */
		public static function get_responsive_block_icon_list_block_default_attributes() {

			return array(
				'align'                    => 'left',
				'alignTablet'              => 'left',
				'alignMobile'              => 'left',
				'icon_count'               => 1,
				'icons'                    => array(),
				'gap'                      => 10,
				'inner_gap'                => 15,
				'iconPosition'             => 'middle',
				'size'                     => 16,
				'sizeMobile'               => '',
				'sizeTablet'               => '',
				'bgSize'                   => 0,
				'bgSizeMobile'             => '',
				'bgSizeTablet'             => '',
				'border'                   => 0,
				'borderRadius'             => 0,
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
				'hideLabel'                => false,
				'labelFontFamily'          => '',
				'labelFontWeight'          => '',
				'labelFontSize'            => '',
				'labelFontSizeTablet'      => '',
				'labelFontSizeMobile'      => '',
				'labelLineHeight'          => 1,
				'labelFontColor'           => '',
				'labelFontColorHover'      => '',
				'iconColor'                => '#3a3a3a',
				'iconBorderColor'          => '',
				'iconBackgroundColor'      => '',
				'iconColorHover'           => '',
				'iconBorderColorHover'     => '',
				'iconBackgroundColorHover' => '',
				'icon_layout'              => 'vertical',
				'fontSizeType'             => 'px',
				'block_id'                 => 1,
				'labelFontLineHeight'      => 999, // For compatibility with v1.3.2.
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'labelTextTransform'       => '',
				'labelFontStyle'           => '', 
			);
		}

		/**
		 * Get Icon List Child Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_icon_list_child_css( $attr, $id ) {

			$defaults = self::get_responsive_block_icon_list_child_block_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$selectors        = array(
				' .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-icon' => array(
					'color' => $attr['icon_color'],
				),
				' .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-icon:hover' => array(
					'color' => $attr['icon_hover_color'],
				),
				' .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-wrap' => array(
					'background-color' => $attr['icon_bg_color'],
					'border-color'     => $attr['icon_border_color'],
				),
				':hover .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-wrap' => array(
					'background-color' => $attr['icon_bg_hover_color'],
					'border-color'     => $attr['icon_border_hover_color'],
				),
				' .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-icon svg' => array(
					'fill' => $attr['icon_color'],
				),
				':hover .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__source-icon svg' => array(
					'fill' => $attr['icon_hover_color'],
				),
				' .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__label' => array(
					'color' => $attr['label_color'],
				),
				':hover .responsive-block-editor-addons-icon-list__content-wrap .responsive-block-editor-addons-icon-list__label' => array(
					'color' => $attr['label_hover_color'],
				),
				' .block-editor-block-list__layout .block-editor-block-list__block' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
			);
			$mobile_selectors = array(
				' .block-editor-block-list__layout .block-editor-block-list__block' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' .block-editor-block-list__layout .block-editor-block-list__block' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-icon-list-repeater.responsive-block-editor-addons-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for icon list child block
		 *
		 * @return array
		 */
		public static function get_responsive_block_icon_list_child_block_default_attributes() {
			return array(
				'label'                    => '#Label',
				'image_icon'               => 'icon',
				'icon'                     => 'fab fa-arrow-circle-right',
				'hideLabel'                => false,
				'image'                    => '',
				'icon_color'               => '#3a3a3a',
				'label_color'              => '',
				'icon_hover_color'         => '',
				'label_hover_color'        => '',
				'icon_bg_color'            => '',
				'icon_bg_hover_color'      => '',
				'icon_border_color'        => '',
				'icon_border_hover_color'  => '',
				'link'                     => '#',
				'target'                   => true,
				'disableLink'              => true,
				'enableLink'			   => false,
				'block_id'                 => 1,
				'source_type'              => 'icon',
				'blockTopMargin'           => '',
				'blockBottomMargin'        => '',
				'blockLeftMargin'          => '',
				'blockRightMargin'         => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMarginTablet'   => '',
				'blockTopMarginMobile'     => '',
				'blockBottomMarginMobile'  => '',
				'blockLeftMarginMobile'    => '',
				'blockRightMarginMobile'   => '',
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
			);
		}

		/**
		 * Get Image Box Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_image_boxes_css( $attr, $id ) {
			$defaults = self::get_responsive_block_image_boxes_default_attributes();

			// Frontend Backward Compatibility For BorderRadius For Image Boxes.
			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : '',
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_box_image_keys = [
				'boxImagePosition'          => 'backgroundPosition' ? 'backgroundPosition' : '',
				'boxImagePositionTablet'    => 'backgroundPosition' ? 'backgroundPosition' : '',
				'boxImagePositionMobile'    => 'backgroundPosition' ? 'backgroundPosition' : '',
				'boxImageRepeat'            => 'backgroundRepeat' ? 'backgroundRepeat' : '',
				'boxImageSize'              => 'backgroundSize' ? 'backgroundSize' : '',
				'boxImageSizeTablet'        => 'backgroundSize' ? 'backgroundSize' : '',
				'boxImageSizeMobile'        => 'backgroundSize' ? 'backgroundSize' : '',
			];	
			
			// To populate new control values with existing control values for backward compatibility.
			foreach ($new_box_image_keys as $attrKey => $defaultKey) {
				if (array_key_exists($attrKey, $defaults)) {
					$defaults[$attrKey] = isset($attr[$defaultKey]) ? $attr[$defaultKey] : $defaults[$attrKey];
				}
			}	

			// Frontend Backward Compatibility For TypographySettings For Image Boxes.
			$new_typography_settings_keys = array(
				'descriptionTypographyColor'     => 'descriptionColor' ? 'descriptionColor' : '',
				'titleTypographyColor'           => 'titleColor' ? 'titleColor' : '',
				'descriptionBottomSpacing'       => 'descriptionSpacing' ? 'descriptionSpacing' : '',
				'descriptionBottomSpacingMobile' => 'descriptionSpacingMobile' ? 'descriptionSpacingMobile' : '',
				'descriptionBottomSpacingTablet' => 'descriptionSpacingTablet' ? 'descriptionSpacingTablet' : '',
				'titleBottomSpacing'             => 'titleSpacing' ? 'titleSpacing' : '',
				'titleBottomSpacingMobile'       => 'titleSpacingMobile' ? 'titleSpacingMobile' : '',
				'titleBottomSpacingTablet'       => 'titleSpacingTablet' ? 'titleSpacingTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For BoxPaddingSettings For Image Boxes.
			$new_padding_margin_keys = array(
				'boxTopPadding'          => 'boxPaddingTop' ? 'boxPaddingTop' : '',
				'boxRightPadding'        => 'boxPaddingRight' ? 'boxPaddingRight' : '',
				'boxLeftPadding'         => 'boxPaddingLeft' ? 'boxPaddingLeft' : '',
				'boxBottomPadding'       => 'boxPaddingBottom' ? 'boxPaddingBottom' : '',
				'boxTopPaddingTablet'    => 'boxPaddingTop' ? 'boxPaddingTop' : '',
				'boxRightPaddingTablet'  => 'boxPaddingRight' ? 'boxPaddingRight' : '',
				'boxLeftPaddingTablet'   => 'boxPaddingLeft' ? 'boxPaddingLeft' : '',
				'boxBottomPaddingTablet' => 'boxPaddingBottom' ? 'boxPaddingBottom' : '',
				'boxTopPaddingMobile'    => 'boxPaddingTop' ? 'boxPaddingTop' : '',
				'boxRightPaddingMobile'  => 'boxPaddingRight' ? 'boxPaddingRight' : '',
				'boxLeftPaddingMobile'   => 'boxPaddingLeft' ? 'boxPaddingLeft' : '',
				'boxBottomPaddingMobile' => 'boxPaddingBottom' ? 'boxPaddingBottom' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_padding_margin_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For Alignment For Image Boxes.
			$new_alignment_keys = array(
				'contentAlignMobile'      => 'contentAlign' ? 'contentAlign' : '',
				'contentAlignTablet'      => 'contentAlign' ? 'contentAlign' : '',
				'verticalAlignmentMobile' => 'verticalAlignment' ? 'verticalAlignment' : '',
				'verticalAlignmentTablet' => 'verticalAlignment' ? 'verticalAlignment' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_alignment_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr     = array_merge( $defaults, (array) $attr );
			
			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity       = $attr['opacity'] / 100;
			$hover_imgopacity = $attr['hoverOpacity'] / 100;

			$tempsecondary_background_color        = $attr['bgGradient']
			? $attr['secondaryBackgroundColor']
			: $attr['itemBackgroundColor'];
			$temp_hover_secondary_background_color = $attr['hoverBgGradient']
			? $attr['hoverSecondaryBackgroundColor']
			: $attr['itemHoverBackgroundColor'];

			$hover_gradient =
			'linear-gradient(' .
			$attr['hoverGradientDegree'] .
			'deg,' .
			self::hex_to_rgb( $attr['itemHoverBackgroundColor'], $hover_imgopacity ) .
			',' .
			self::hex_to_rgb(
				$temp_hover_secondary_background_color,
				$hover_imgopacity
			) .
			')';

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$background_image_first  = '';
			$background_image_second = '';
			$background_image_third  = '';
			$background_image_fourth = '';

			$background_image_first = 'linear-gradient(' . $attr['gradientDegree'] . 'deg, ' .

			self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ) .

			',' .

			self::hex_to_rgb( $tempsecondary_background_color, $imgopacity ) .

			'),url(' .

			$attr['backgroundImageOne'] .

			')';

			$background_image_second = 'linear-gradient(' . $attr['gradientDegree'] . 'deg, ' .

			self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ) .

			',' .

			self::hex_to_rgb( $tempsecondary_background_color, $imgopacity ) .

			'),url(' .

			$attr['backgroundImageTwo'] .

			')';

			$background_image_third = 'linear-gradient(' . $attr['gradientDegree'] . 'deg, ' .

			self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ) .

			',' .

			self::hex_to_rgb( $tempsecondary_background_color, $imgopacity ) .

			'),url(' .

			$attr['backgroundImageThree'] .

			')';

			$background_image_fourth = 'linear-gradient(' . $attr['gradientDegree'] . 'deg, ' .

			self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ) .

			',' .

			self::hex_to_rgb( $tempsecondary_background_color, $imgopacity ) .

			'),url(' .

			$attr['backgroundImageFour'] .

			')';

			$gutter_margin_ib = '';
			if ( $attr['count'] > 1 ) {
				if ( 'small' === $attr['gutter'] ) {
					$gutter_margin_ib = '20px';
				} elseif ( 'medium' === $attr['gutter'] ) {
					$gutter_margin_ib = '30px';
				} elseif ( 'large' === $attr['gutter'] ) {
					$gutter_margin_ib = '40px';
				} elseif ( 'huge' === $attr['gutter'] ) {
					$gutter_margin_ib = '50px';
				} else {
					$gutter_margin_ib = '';
				}
			}

			$box_image_position_focal = self::get_background_position( $attr['boxImagePosition'] );
			$box_image_position_focal_tablet = self::get_background_position( $attr['boxImagePositionTablet'] );
			$box_image_position_focal_mobile = self::get_background_position( $attr['boxImagePositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$box_image_position_focal        = self::get_background_position( $attr['boxImagePositionFocal'] );
				$box_image_position_focal_tablet = self::get_background_position( $attr['boxImagePositionFocalTablet'] );
				$box_image_position_focal_mobile = self::get_background_position( $attr['boxImagePositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                => array(
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'position'                   => 'relative',
					'z-index'                    => $attr['z_index'],
					'text-align'                 => $attr['contentAlign'],
					'justify-content'            => $attr['verticalAlignment'] . '!important',
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'background-color'           => self::hex_to_rgb( $attr['itemBackgroundColor'], $imgopacity ),
					'background-size'            => $attr['boxImageSize'],
					'background-repeat'          => $attr['boxImageRepeat'],
					'background-position'        => $box_image_position_focal,
					'padding-left'               => self::get_css_value( $attr['boxLeftPadding'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['boxRightPadding'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['boxBottomPadding'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['boxTopPadding'], 'px' ),
					'height'                     => self::get_css_value( $attr['boxHeight'], 'px' ),
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
				),

				':hover .responsive-block-editor-addons-add-image' => array(
					'background-image'           => $hover_gradient,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),

				':hover'           => array(
					'transform' => 'scale(' . $attr['imageHoverEffect'] . ')',
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',
				),

				' .responsive-block-editor-addons-imagebox-image' => array(
					'width'     => $attr['imageSize'],
					'max-width' => 100 . '%',
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__title' => array(
					'font-family'   => $attr['titleFontFamily'],
					'font-weight'   => $attr['titleFontWeight'],
					'text-transform'=> $attr['titleTextTransform'],
					'font-style'    => $attr['titleFontStyle'],
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'line-height'   => $attr['titleLineHeight'],
					'color'         => $attr['titleTypographyColor'],
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__description' => array(
					'font-family'   => $attr['descriptionFontFamily'],
					'text-transform'=> $attr['descriptionTextTransform'],
					'font-style'    => $attr['descriptionFontStyle'],
					'font-size'     => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'   => $attr['descriptionFontWeight'],
					'line-height'   => $attr['descriptionLineHeight'],
					'color'         => $attr['descriptionTypographyColor'],
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacing'], 'px' ),
				),
				' .imagebox-arrow' => array(
					'color'     => $attr['arrowColor'],
					'font-size' => self::get_css_value( $attr['arrowSize'], 'px' ),
				),
				'.responsive-block-editor-addons-block-image-boxes-0' => array(
					'background-image' => $background_image_first,
				),
				'.responsive-block-editor-addons-block-image-boxes-1' => array(
					'background-image' => $background_image_second,
				),
				'.responsive-block-editor-addons-block-image-boxes-2' => array(
					'background-image' => $background_image_third,
				),
				'.responsive-block-editor-addons-block-image-boxes-3' => array(
					'background-image' => $background_image_fourth,
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'flex',
					'z-index'                    => $attr['z_indexMobile'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
					'background-size'            => $attr['boxImageSizeMobile'],
					'background-position'        => $box_image_position_focal_mobile,
					'text-align'                 => $attr['contentAlignMobile'],
					'justify-content'            => $attr['verticalAlignmentMobile'] . '!important',
					'padding-left'               => self::get_css_value( $attr['boxLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['boxRightPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['boxBottomPaddingMobile'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['boxTopPaddingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__description' => array(
					'font-size'     => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacingMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'flex',
					'z-index'                    => $attr['z_indexTablet'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
					'background-size'            => $attr['boxImageSizeTablet'],
					'background-position'        => $box_image_position_focal_tablet,
					'text-align'                 => $attr['contentAlignTablet'],
					'justify-content'            => $attr['verticalAlignmentTablet'] . '!important',
					'padding-left'               => self::get_css_value( $attr['boxLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['boxRightPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['boxBottomPaddingTablet'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['boxTopPaddingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-image-boxes-block-item__description' => array(
					'font-size'     => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacingTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id              = '.responsive-block-editor-addons-block-image-boxes.block-' . $id;
			$css             = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			$css['mobile']  .= '
                .wp-block-responsive-block-editor-addons-image-boxes-block__inner a {
                    margin-bottom: ' . $gutter_margin_ib . '!important;
					max-width: 100% !important;
                }
				.wp-block-responsive-block-editor-addons-image-boxes-block__inner {
                    flex-direction: column;
					align-items: center;
                }
				.wp-block-responsive-block-editor-addons-image-boxes-block {
                    padding-top: ' . self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ';
                }
            ';
			$css['desktop'] .= '
                .wp-block-responsive-block-editor-addons-image-boxes-block {
                    padding-top: ' . self::get_css_value( $attr['blockTopPadding'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPadding'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPadding'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPadding'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMargin'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMargin'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ';
                }
            ';
			$css['tablet']  .= '
                .wp-block-responsive-block-editor-addons-image-boxes-block {
                    padding-top: ' . self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . ';
                    padding-right: ' . self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . ';
                    padding-bottom: ' . self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . ';
                    padding-left: ' . self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . ';
                    margin-top: ' . self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ';
                    margin-right: ' . self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ';
                    margin-bottom: ' . self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ';
                    margin-left: ' . self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ';
                }
            ';

			return $css;
		}

		/**
		 * Get Defaults for image box block
		 *
		 * @return array
		 */
		public static function get_responsive_block_image_boxes_default_attributes() {
			return array(
				'block_id'                       => '',
				'imageboxesBlock'                => '',
				'counterId'                      => 1,
				'count'                          => '',
				'titleHeadingTag'                => 'h3',
				'gutter'                         => 'medium',
				'contentAlign'                   => 'center',
				'textColor'                      => '',
				'itemBackgroundColor'            => '#fff',
				'hoverTextColor'                 => '',
				'verticalAlignment'              => 'center',
				'itemHoverBackgroundColor'       => '#fff',
				'hoverBorderColor'               => '',
				'titleSpacing'                   => '',
				'descriptionSpacing'             => '',
				'titleSpacingMobile'             => '',
				'descriptionSpacingMobile'       => '',
				'titleSpacingTablet'             => '',
				'descriptionSpacingTablet'       => '',
				'blockBorderRadius'              => '',
				'blockTopRadiusMobile'           => '',
				'blockRightRadiusMobile'         => '',
				'blockBottomRadiusMobile'        => '',
				'blockLeftRadiusMobile'          => '',
				'blockTopRadiusTablet'           => '',
				'blockRightRadiusTablet'         => '',
				'blockBottomRadiusTablet'        => '',
				'blockLeftRadiusTablet'          => '',
				'blockTopRadius'                 => '',
				'blockRightRadius'               => '',
				'blockBottomRadius'              => '',
				'blockLeftRadius'                => '',
				'blockBorderStyle'               => 'solid',
				'blockBorderWidth'               => 2,
				'blockBorderColor'               => '#1E1E1E',
				'boxPaddingLeft'                 => 15,
				'boxPaddingRight'                => 15,
				'boxPaddingBottom'               => 15,
				'boxPaddingTop'                  => 15,
				'boxHeight'                      => '',
				'hasArrow'                       => '',
				'arrowColor'                     => '',
				'arrowSize'                      => '',
				'boxShadowColor'                 => '#fff',
				'boxShadowHOffset'               => 0,
				'boxShadowVOffset'               => 0,
				'boxShadowBlur'                  => 0,
				'boxShadowPosition'              => 'outset',
				'opacity'                        => 70,
				'hoverOpacity'                   => 70,
				'boxShadowSpread'                => 0,
				'hoverboxShadowColor'            => '',
				'hoverboxShadowHOffset'          => 0,
				'hoverboxShadowVOffset'          => 0,
				'hoverboxShadowBlur'             => 0,
				'hoverboxShadowSpread'           => 0,
				'hoverboxShadowPosition'         => 'outset',
				'backgroundPosition'             => '',
				'backgroundSize'                 => '',
				'backgroundRepeat'               => '',
				'imageHoverEffect'               => '',
				'bggradient'                     => '',
				'secondaryBackgroundColor'       => '',
				'hoverSecondaryBackgroundColor'  => '',
				'gradientDegree'                 => 180,
				'bgGradient'                     => false,
				'hoverGradientDegree'            => 180,
				'hoverBgGradient'                => false,
				'titleFontFamily'                => '',
				'descriptionFontFamily'          => '',
				'titleFontSize'                  => '',
				'titleFontSizeMobile'            => '',
				'titleFontSizeTablet'            => '',
				'titleFontWeight'                => '',
				'imageSize'                      => 'full',
				'titleLineHeight'                => '',
				'titleColor'                     => '#1E1E1E',
				'descriptionFontSize'            => '',
				'descriptionFontWeight'          => '',
				'descriptionLineHeight'          => '',
				'descriptionColor'               => '#1E1E1E',
				'backgroundImageOne'             => '',
				'backgroundImageTwo'             => '',
				'backgroundImageThree'           => '',
				'backgroundImageFour'            => '',
				'descriptionFontSizeMobile'      => '',
				'descriptionFontSizeTablet'      => '',
				'boxRadius'                      => 999, // For compatibility with v1.3.2.
				'hideWidgetMobile'               => false,
				'hideWidgetTablet'               => false,
				'hideWidget'                     => false,
				'z_index'                        => 1,
				'z_indexMobile'                  => 1,
				'z_indexTablet'                  => 1,
				'blockTopPadding'                => '',
				'blockTopPaddingMobile'          => '',
				'blockTopPaddingTablet'          => '',
				'blockBottomPadding'             => '',
				'blockBottomPaddingMobile'       => '',
				'blockBottomPaddingTablet'       => '',
				'blockLeftPadding'               => '',
				'blockLeftPaddingMobile'         => '',
				'blockLeftPaddingTablet'         => '',
				'blockRightPadding'              => '',
				'blockRightPaddingMobile'        => '',
				'blockRightPaddingTablet'        => '',
				'blockTopMargin'                 => '',
				'blockTopMarginMobile'           => '',
				'blockTopMarginTablet'           => '',
				'blockBottomMargin'              => '',
				'blockBottomMarginMobile'        => '',
				'blockBottomMarginTablet'        => '',
				'blockLeftMargin'                => '',
				'blockLeftMarginMobile'          => '',
				'blockLeftMarginTablet'          => '',
				'blockRightMargin'               => '',
				'blockRightMarginMobile'         => '',
				'blockRightMarginTablet'         => '',
				'boxImageSize'                   => 'cover',
				'boxImageSizeTablet'             => 'cover',
				'boxImageSizeMobile'             => 'cover',
				'boxImagePosition'               => 'center center',
				'boxImagePositionMobile'         => 'center center',
				'boxImagePositionTablet'         => 'center center',
				'boxImagePositionFocal'          => '50% 50%',
				'boxImagePositionFocalTablet'    => '50% 50%',
				'boxImagePositionFocalMobile'    => '50% 50%',
				'boxImageRepeat'                 => 'no-repeat',
				'descriptionTypographyColor'     => '#1E1E1E',
				'titleTypographyColor'           => '#1E1E1E',
				'descriptionBottomSpacing'       => '',
				'descriptionBottomSpacingMobile' => '',
				'descriptionBottomSpacingTablet' => '',
				'titleBottomSpacing'             => '',
				'titleBottomSpacingMobile'       => '',
				'titleBottomSpacingTablet'       => '',
				'contentAlignMobile'             => 'center',
				'contentAlignTablet'             => 'center',
				'verticalAlignmentMobile'        => 'center',
				'verticalAlignmentTablet'        => 'center',
				'boxRightPadding'                => 15,
				'boxLeftPadding'                 => 15,
				'boxTopPadding'                  => 15,
				'boxBottomPadding'               => 15,
				'boxRightPaddingTablet'          => 15,
				'boxLeftPaddingTablet'           => 15,
				'boxTopPaddingTablet'            => 15,
				'boxBottomPaddingTablet'         => 15,
				'boxRightPaddingMobile'          => 15,
				'boxLeftPaddingMobile'           => 15,
				'boxTopPaddingMobile'            => 15,
				'boxBottomPaddingMobile'         => 15,
				'titleTextTransform'             => '',
				'titleFontStyle'                 => '',
				'descriptionTextTransform'       => '',
				'descriptionFontStyle'           => '',
			);
		}

		/**
		 * Get Image Slider Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_image_slider_css( $attr, $id ) {
			$defaults = self::get_responsive_block_image_slider_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius',
				'blockRightRadius'        => 'blockBorderRadius',
				'blockBottomRadius'       => 'blockBorderRadius',
				'blockLeftRadius'         => 'blockBorderRadius',
				'blockTopRadiusTablet'    => 'blockBorderRadius',
				'blockRightRadiusTablet'  => 'blockBorderRadius',
				'blockBottomRadiusTablet' => 'blockBorderRadius',
				'blockLeftRadiusTablet'   => 'blockBorderRadius',
				'blockTopRadiusMobile'    => 'blockBorderRadius',
				'blockRightRadiusMobile'  => 'blockBorderRadius',
				'blockBottomRadiusMobile' => 'blockBorderRadius',
				'blockLeftRadiusMobile'   => 'blockBorderRadius',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$imgopacity = $attr['iconBackgroundOpacity'] / 100;
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                       => array(
					'display'        => true === $attr['hideWidget'] && $is_on? 'none' : 'block',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),

				' .flickity-button .flickity-button-icon' => array(
					'fill' => $attr['iconColor'],
				),

				' .flickity-button'                       => array(
					'background-color' => self::hex_to_rgb( $attr['iconBackgroundColor'] ? $attr['iconBackgroundColor'] : '#ffffff', $imgopacity ),
					'border-radius'    => $attr['iconBackgroundRadius'] . '%',
				),

				' .responsive-block-editor-addons-gallery--item figure' => array(
					'height' => ( $attr['height'] - ( $attr['blockBorderWidth'] ? $attr['blockBorderWidth'] * 2 : 0 ) ) . 'px',
				),

				' .has-carousel-lrg .responsive-block-editor-addons-gallery--item' => array(
					'width' => self::get_css_value( $attr['width'], 'px' ),
				),

				' .responsive-block-editor-addons-gallery--item' => array(
					'margin-left'                => $attr['gutter'] > 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutter'] . 'px' : null,
					'margin-right'               => $attr['gutter'] > 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutter'] . 'px' : null,
					'border-width'               => 999 !== $attr['borderWidth'] && '' === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-style'               => 'empty' !== $attr['borderStyle'] && '' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'], // For compatibility with v1.3.2.
					'border-color'               => 'empty' !== $attr['borderColor'] && '' === $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'], // For compatibility with v1.3.2.
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-gallery--item' => array(
					'margin-left'                => $attr['gutterMobile'] >= 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutterMobile'] . 'px' : null,
					'margin-right'               => $attr['gutterMobile'] >= 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutterMobile'] . 'px' : null,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-gallery--item' => array(
					'margin-left'                => $attr['gutterTablet'] > 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutterTablet'] . 'px' : null,
					'margin-right'               => $attr['gutterTablet'] > 0 && ! ( $attr['responsiveHeight'] ) ? $attr['gutterTablet'] . 'px' : null,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-image-slider.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for image slider block
		 *
		 * @return array
		 */
		public static function get_responsive_block_image_slider_default_attributes() {
			return array(
				'block_id'                 => '',
				'gutter'                   => 5,
				'gutterMobile'             => 5,
				'gutterTablet'             => 5,
				'gridSize'                 => 'lrg',
				'height'                   => 400,
				'width'                    => '',
				'customWidth'              => false,
				'pageDots'                 => false,
				'prevNextButtons'          => true,
				'autoPlay'                 => false,
				'autoPlaySpeed'            => 3000,
				'draggable'                => true,
				'alignCells'               => false,
				'pauseHover'               => false,
				'freeScroll'               => false,
				'isSmallImage'             => false,
				'thumbnails'               => false,
				'responsiveHeight'         => false,
				'blockBorderWidth'         => '',
				'blockBorderRadius'        => '',
				'iconBackgroundRadius'     => 20,
				'iconBackgroundOpacity'    => 90,
				'iconBackgroundColor'      => '',
				'blockBorderColor'         => '',
				'iconColor'                => '',
				'blockBorderStyle'         => '',
				'counterId'                => '',
				'borderWidth'              => 999, // For compatibility with v1.3.2.
				'borderStyle'              => 'empty', // For compatibility with v1.3.2.
				'borderColor'              => 'empty', // For compatibility with v1.3.2.
				'hideWidgetTablet'         => false,
				'hideWidgetMobile'         => false,
				'hideWidget'               => false,
				'z_index'                  => 1,
				'z_indexTablet'            => 1,
				'z_indexMobile'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'blockTopRadiusMobile'     => '',
				'blockRightRadiusMobile'   => '',
				'blockBottomRadiusMobile'  => '',
				'blockLeftRadiusMobile'    => '',
				'blockTopRadiusTablet'     => '',
				'blockRightRadiusTablet'   => '',
				'blockBottomRadiusTablet'  => '',
				'blockLeftRadiusTablet'    => '',
				'blockTopRadius'           => '',
				'blockRightRadius'         => '',
				'blockBottomRadius'        => '',
				'blockLeftRadius'          => '',
			);
		}

		/**
		 * Get Info Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_info_block_css( $attr, $id ) {
			$defaults = self::get_responsive_block_info_block_default_attributes();

			$new_margin_spacing_attribute_keys = array(
				'blockTopPadding'          => 'contentPadding',
				'blockBottomPadding'       => 'contentPadding',
				'blockLeftPadding'         => 'contentPadding',
				'blockRightPadding'        => 'contentPadding',
				'blockTopPaddingTablet'    => 'contentPaddingTablet',
				'blockBottomPaddingTablet' => 'contentPaddingTablet',
				'blockLeftPaddingTablet'   => 'contentPaddingTablet',
				'blockRightPaddingTablet'  => 'contentPaddingTablet',
				'blockTopPaddingMobile'    => 'contentPaddingMobile',
				'blockBottomPaddingMobile' => 'contentPaddingMobile',
				'blockLeftPaddingMobile'   => 'contentPaddingMobile',
				'blockRightPaddingMobile'  => 'contentPaddingMobile',
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_margin_spacing_attribute_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For BorderRadius for InfoBox, Image and Icon.
			$new_border_radius_keys = array(
				'blockTopRadius'             => 'blockBorderRadius',
				'blockRightRadius'           => 'blockBorderRadius',
				'blockBottomRadius'          => 'blockBorderRadius',
				'blockLeftRadius'            => 'blockBorderRadius',
				'blockTopRadiusTablet'       => 'blockBorderRadius',
				'blockRightRadiusTablet'     => 'blockBorderRadius',
				'blockBottomRadiusTablet'    => 'blockBorderRadius',
				'blockLeftRadiusTablet'      => 'blockBorderRadius',
				'blockTopRadiusMobile'       => 'blockBorderRadius',
				'blockRightRadiusMobile'     => 'blockBorderRadius',
				'blockBottomRadiusMobile'    => 'blockBorderRadius',
				'blockLeftRadiusMobile'      => 'blockBorderRadius',
				'resImageTopRadius'          => 'resImageBorderRadius',
				'resImageRightRadius'        => 'resImageBorderRadius',
				'resImageBottomRadius'       => 'resImageBorderRadius',
				'resImageLeftRadius'         => 'resImageBorderRadius',
				'resImageTopRadiusTablet'    => 'resImageBorderRadius',
				'resImageRightRadiusTablet'  => 'resImageBorderRadius',
				'resImageBottomRadiusTablet' => 'resImageBorderRadius',
				'resImageLeftRadiusTablet'   => 'resImageBorderRadius',
				'resImageTopRadiusMobile'    => 'resImageBorderRadius',
				'resImageRightRadiusMobile'  => 'resImageBorderRadius',
				'resImageBottomRadiusMobile' => 'resImageBorderRadius',
				'resImageLeftRadiusMobile'   => 'resImageBorderRadius',
				'iconTopRadius'              => 'iconBorderRadius',
				'iconRightRadius'            => 'iconBorderRadius',
				'iconBottomRadius'           => 'iconBorderRadius',
				'iconLeftRadius'             => 'iconBorderRadius',
				'iconTopRadiusTablet'        => 'iconBorderRadius',
				'iconRightRadiusTablet'      => 'iconBorderRadius',
				'iconBottomRadiusTablet'     => 'iconBorderRadius',
				'iconLeftRadiusTablet'       => 'iconBorderRadius',
				'iconTopRadiusMobile'        => 'iconBorderRadius',
				'iconRightRadiusMobile'      => 'iconBorderRadius',
				'iconBottomRadiusMobile'     => 'iconBorderRadius',
				'iconLeftRadiusMobile'       => 'iconBorderRadius',
				'ctaBlockTopRadius'          => 'ctaBorderRadius',
				'ctaBlockTopRadiusTablet'    => 'ctaBorderRadius',
				'ctaBlockTopRadiusMobile'    => 'ctaBorderRadius',
				'ctaBlockBottomRadius'       => 'ctaBorderRadius',
				'ctaBlockBottomRadiusTablet' => 'ctaBorderRadius',
				'ctaBlockBottomRadiusMobile' => 'ctaBorderRadius',
				'ctaBlockLeftRadius'         => 'ctaBorderRadius',
				'ctaBlockLeftRadiusTablet'   => 'ctaBorderRadius',
				'ctaBlockLeftRadiusMobile'   => 'ctaBorderRadius',
				'ctaBlockRightRadius'        => 'ctaBorderRadius',
				'ctaBlockRightRadiusTablet'  => 'ctaBorderRadius',
				'ctaBlockRightRadiusMobile'  => 'ctaBorderRadius',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For TypographySettings For Image Boxes.
			$new_typography_settings_keys = array(
				'ctaTextTypographyColor'        => 'resctaLinkColor' ? 'resctaLinkColor' : '',
				'resheadTypographyColor'        => 'resheadingColor' ? 'resheadingColor' : '',
				'ressubHeadTypographyColor'     => 'ressubheadingColor' ? 'ressubheadingColor' : '',

				'resheadBottomSpacing'          => 'resheadSpace' ? 'resheadSpace' : '',
				'resheadBottomSpacingMobile'    => 'resheadSpaceMobile' ? 'resheadSpaceMobile' : '',
				'resheadBottomSpacingTablet'    => 'resheadSpaceTablet' ? 'resheadSpaceTablet' : '',

				'ressubHeadBottomSpacing'       => 'ressubHeadSpace' ? 'ressubHeadSpace' : '',
				'ressubHeadBottomSpacingMobile' => 'ressubHeadSpaceMobile' ? 'ressubHeadSpaceMobile' : '',
				'ressubHeadBottomSpacingTablet' => 'ressubHeadSpaceTablet' ? 'ressubHeadSpaceTablet' : '',

				'ctaTextBottomSpacing'          => 'ctaBottomMargin' ? 'ctaBottomMargin' : '',
				'ctaTextBottomSpacingMobile'    => 'ctaBottomMarginMobile' ? 'ctaBottomMarginMobile' : '',
				'ctaTextBottomSpacingTablet'    => 'ctaBottomMarginTablet' ? 'ctaBottomMarginTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$image_box_shadow_position_css = $attr['imageBoxShadowPosition'];
			if ( 'outset' === $attr['imageBoxShadowPosition'] ) {
				$image_box_shadow_position_css = '';
			}

			$updated_background_h_color = '';

			if ( 'color' === $attr['buttonHbackgroundType'] ) {
				$updated_background_h_color = ( 'empty' !== $attr['hoverctaBgColor'] && '#333' === $attr['ctaBackColor'] ? $attr['hoverctaBgColor'] : $attr['ctaHoverBackColor'] ) ? $attr['ctaHoverBackColor'] : 'none'; // For compatibility with v1.3.2.
			}

			$box_shadow_position_css = $attr['boxShadowPosition'];
			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}

			$hoverbox_shadow_position_css = $attr['hoverboxShadowPosition'];
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hoverbox_shadow_position_css = '';
			}

			$newopacity = $attr['opacity'] / 100;

			$imgopacity = $attr['imageopacity'] / 100;

			$icon_bg_color = '';
			if ( 'solid' === $attr['iconBackgroundType'] ) {
				$icon_bg_color = $attr['iconBackgroundColor'];
			}

			$icon_bg_hover_color = '';
			if ( 'solid' === $attr['iconBackgroundType'] ) {
				$icon_bg_hover_color = $attr['iconBackgroundHoverColor'];
			}

			$icon_bg_padding = 0;
			if ( 'none' !== $attr['iconBackgroundType'] ) {
				$icon_bg_padding = self::get_css_value( $attr['iconPadding'], 'px' );
			}

			$icon_border = 'none';
			if ( 'outline' === $attr['iconBackgroundType'] ) {
				$icon_border = self::get_css_value( $attr['iconBorderWidth'], 'px' ) . ' solid ' . $attr['iconBackgroundColor'];
			}

			$icon_hover_border = 'none';
			if ( 'outline' === $attr['iconBackgroundType'] ) {
				$icon_hover_border = self::get_css_value( $attr['iconBorderWidth'], 'px' ) . ' solid ' . $attr['iconBackgroundHoverColor'];
			}

			$background_image_gradient = '';
			$button_color              = '';
			if ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$background_image_gradient = 'linear-gradient(' . $attr['buttongradientDirection'] . 'deg, ' . $attr['buttonbackgroundColor1'] . ' ' . $attr['buttoncolorLocation1'] . '%, ' . $attr['buttonbackgroundColor2'] . ' ' . $attr['buttoncolorLocation2'] . '%)';
			} elseif ( 'color' === $attr['buttonbackgroundType'] ) {
				$background_image_gradient = '';
				$button_color              = 'empty' !== $attr['resctaBgColor'] && 'transparent' === $attr['ctaBackColor'] ? $attr['resctaBgColor'] : $attr['ctaBackColor']; // For compatibility with v1.3.2.
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                        => array(
					'z-index'                    => $attr['z_index'],
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'background-color'           => 'empty' !== $attr['boxBackgroundColor'] && '#ffffff' === $attr['backgroundColor'] ? self::hex_to_rgb( $attr['boxBackgroundColor'], $newopacity ) : self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $newopacity ), // For compatibility with v1.3.2.
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-radius'              => self::get_css_value( $attr['blockBorderRadius'], 'px' ),
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
					'padding-top'                => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),

				':hover'                                   => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hoverbox_shadow_position_css : '',
				),

				' .responsive-block-editor-addons-ifb-image-icon-content.responsive-block-editor-addons-ifb-imgicon-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconBottomMargin'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['iconTopMargin'], 'px' ),
					'margin-left'   => self::get_css_value( $attr['iconLeftMargin'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['iconRightMargin'], 'px' ),
				),

				' .responsive-block-editor-addons-ifb-icon' => array(
					'width'                      => self::get_css_value( $attr['resIconSize'], 'px' ),
					'height'                     => self::get_css_value( $attr['resIconSize'], 'px' ),
					'background-color'           => $icon_bg_color,
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadius'], 'px' ),
					'padding'                    => $icon_bg_padding,
					'border'                     => $icon_border,
				),

				' .responsive-block-editor-addons-ifb-icon:hover' => array(
					'background-color'          => $icon_bg_hover_color,
					'border'                    => $icon_hover_border,
					'animation-name'            => $attr['animationName'] . '' . $attr['animationDirection'],
					'animation-timing-function' => $attr['animationCurve'],
					'animation-duration'        => $attr['animationDuration'] . 'ms',
					'animation-delay'           => $attr['animationDelay'] . 'ms',
					'animation-iteration-count' => 'once' === $attr['animationRepeat'] ? 1 : 'infinite',
				),

				' .responsive-block-editor-addons-ifb-image-content > img' => array(
					'border-color'               => $attr['resImageBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['resImageTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['resImageRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['resImageBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['resImageLeftRadius'], 'px' ),
					'border-width'               => self::get_css_value( $attr['resImageBorderWidth'], 'px' ),
					'border-style'               => $attr['resImageBorderStyle'],
					'box-shadow'                 =>
						self::get_css_value( $attr['imageBoxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['imageBoxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['imageBoxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['imageBoxShadowSpread'], 'px' ) .
						' ' .
						$attr['imageBoxShadowColor'] .
						' ' .
						$image_box_shadow_position_css,
					'opacity'                    => $imgopacity,
				),

				' .responsive-block-editor-addons-ifb-separator' => array(
					'border-width'     => self::get_css_value( $attr['resseperatorThickness'], 'px' ),
					'border-color'     => $attr['resseperatorColor'],
					'border-top-style' => $attr['resseperatorStyle'],
					'width'            => self::get_css_value( $attr['resseperatorWidth'], $attr['widthType'] ),
					'margin-bottom'    => self::get_css_value( $attr['sepSpace'], 'px' ),
				),

				' .responsive-block-editor-addons-ifb-cta-button' => array(
					'background-color' => $button_color,
					'background-image' => $background_image_gradient,
					'border-color'     => 'empty' !== $attr['resctaBorderColor'] && '#333' !== $attr['ctaBorderColor'] ? $attr['resctaBorderColor'] : $attr['ctaBorderColor'], // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-ifb-cta-button .responsive-block-editor-addons-inline-editing' => array(
					'color' => 'empty' !== $attr['resctaBtnLinkColor'] && '#333' === $attr['ctaColor'] ? $attr['resctaBtnLinkColor'] : $attr['ctaColor'], // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-ifb-cta-button:hover' => array(
					'background-color' => $updated_background_h_color,
					'border-color'     => 'empty' !== $attr['hoverctaBorderColor'] && '#333' === $attr['ctaHoverBorderColor'] ? $attr['hoverctaBorderColor'] : $attr['ctaHoverBorderColor'], // For compatibility with v1.3.2.
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $background_image_gradient,
				),

				' .responsive-block-editor-addons-ifb-cta-button:hover .responsive-block-editor-addons-inline-editing' => array(
					'color' => 'empty' !== $attr['hoverctaBtnLinkColor'] && '#333' === $attr['ctaHoverColor'] ? $attr['hoverctaBtnLinkColor'] : $attr['ctaHoverColor'], // For compatibility with v1.3.2.
				),

				' .responsive-block-editor-addons-ifb-icon svg' => array(
					'fill' => $attr['icon_color'],
				),

				' .responsive-block-editor-addons-ifb-icon:hover svg' => array(
					'fill' => $attr['icon_hcolor'],
				),

				' .responsive-block-editor-addons-infobox__content-wrap' => array(
					'text-align' => ( 'above-title' === $attr['imgiconPosition'] || 'below-title' === $attr['imgiconPosition'] ) ? $attr['resheadingAlign'] : '',
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-title' => array(
					'font-size' => self::get_css_value( $attr['resheadFontSize'], 'px !important' ),
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-desc' => array(
					'font-size' => self::get_css_value( $attr['ressubHeadFontSize'], 'px !important' ),
				),

				' .responsive-block-editor-addons-ifb-image-content img' => array(
					'width'     => self::get_css_value( $attr['imageWidth'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidth'], 'px' ),
				),

				' .responsive-block-editor-addons-cta-image' => array(
					'background-image'      => 'empty' !== $attr['imgURL'] && '' === $attr['backgroundImage'] ? 'url(' . $attr['imgURL'] . ')' : 'url(' . $attr['backgroundImage'] . ')', // For compatibility with v1.3.2.
					'background-position'   => $background_position_focal,
					'background-repeat'     => $attr['backgroundRepeat'],
					'background-size'       => $attr['backgroundSize'],
					'background-attachment' => $attr['backgroundAttachment'],
				),

				' .responsive-block-editor-addons-ifb-title-prefix' => array(
					'color'         => $attr['resprefixColor'],
					'font-size'     => self::get_css_value( $attr['resprefixFontSize'], 'px' ),
					'font-weight'   => $attr['resprefixFontWeight'],
					'line-height'   => $attr['resprefixLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['resprefixSpace'], 'px' ),
				),

				' .responsive-block-editor-addons-ifb-title' => array(
					'color'         => $attr['resheadTypographyColor'],
					'font-family'   => $attr['resheadFontFamily'],
					'font-weight'   => $attr['resheadFontWeight'],
					'line-height'   => $attr['resheadLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['resheadBottomSpacing'], 'px' ),
					"text-transform"=> $attr['resheadTextTransform'],
      				"font-style"    => $attr['resheadFontStyle'],
				),

				' .responsive-block-editor-addons-ifb-desc' => array(
					'color'         => $attr['ressubHeadTypographyColor'],
					'font-family'   => $attr['ressubHeadFontFamily'],
					'font-weight'   => $attr['ressubHeadFontWeight'],
					'line-height'   => $attr['ressubHeadLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['ressubHeadBottomSpacing'], 'px' ),
					"text-transform"=> $attr['ressubHeadTextTransform'],
					"font-style"    => $attr['ressubHeadFontStyle'],
				),

				' .responsive-block-editor-addons-infobox-cta-link' => array(
					'color'          => $attr['ctaTextTypographyColor'],
					'padding-top'    => 'text' !== $attr['resctaType'] ? ( 999 !== $attr['ctaVertPadding'] && 10 === $attr['ctaVpadding'] ? self::get_css_value( $attr['ctaVertPadding'], 'px' ) : self::get_css_value( $attr['ctaVpadding'], 'px' ) ) : 0, // For compatibility with v1.3.2.
					'padding-bottom' => 'text' !== $attr['resctaType'] ? ( 999 !== $attr['ctaVertPadding'] && 10 === $attr['ctaVpadding'] ? self::get_css_value( $attr['ctaVertPadding'], 'px' ) : self::get_css_value( $attr['ctaVpadding'], 'px' ) ) : 0, // For compatibility with v1.3.2.
					'padding-left'   => 'text' !== $attr['resctaType'] ? ( 999 !== $attr['ctaHrPadding'] && 14 === $attr['ctaHpadding'] ? self::get_css_value( $attr['ctaHrPadding'], 'px' ) : self::get_css_value( $attr['ctaHpadding'], 'px' ) ) : 0, // For compatibility with v1.3.2.
					'padding-right'  => 'text' !== $attr['resctaType'] ? ( 999 !== $attr['ctaHrPadding'] && 14 === $attr['ctaHpadding'] ? self::get_css_value( $attr['ctaHrPadding'], 'px' ) : self::get_css_value( $attr['ctaHpadding'], 'px' ) ) : 0, // For compatibility with v1.3.2.
					'font-size'      => self::get_css_value( $attr['ctaTextFontSize'], 'px' ),
					'font-weight'    => $attr['ctaTextFontWeight'],
					'font-family'    => $attr['ctaTextFontFamily'],
					'line-height'    => $attr['ctaTextLineHeight'],
					"text-transform" => $attr['ctaTextTextTransform'],
      				"font-style"     => $attr['ctaTextFontStyle'],
				),

				' .responsive-block-editor-addons-inline-editing ' => array(
					'color'     => $attr['ctaTextTypographyColor'],
					'font-size' => self::get_css_value( $attr['resctaFontSize'], 'px' ),
				),

				' .responsive-block-editor-addons-infobox-cta-link.responsive-block-editor-addons-ifb-cta-button' => array(
					'border-width'               => 999 !== $attr['resctaBorderWidth'] && 1 === $attr['ctaBorderWidth'] ? self::get_css_value( $attr['resctaBorderWidth'], 'px' ) : self::get_css_value( $attr['ctaBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['resctaBorderStyle'] && 'solid' === $attr['ctaBorderStyle'] ? $attr['resctaBorderStyle'] : $attr['ctaBorderStyle'], // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadius'], 'px'),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadius'], 'px'),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadius'], 'px'),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadius'], 'px'),
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPadding'], 'px'),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPadding'], 'px'),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPadding'], 'px'),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPadding'], 'px'),
					'font-size'                  => self::get_css_value( $attr['resctaFontSize'], 'px' ),
					'font-weight'                => $attr['resctaFontWeight'],
				),

				' .responsive-block-editor-addons-ifb-cta' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacing'], 'px' ),
				),
			);

			$mobile_selectors = array(
				' '                                        => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexMobile'],
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-image-icon-content.responsive-block-editor-addons-ifb-imgicon-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconBottomMarginMobile'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['iconTopMarginMobile'], 'px' ),
					'margin-left'   => self::get_css_value( $attr['iconLeftMarginMobile'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['iconRightMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-mobile .responsive-block-editor-addons-ifb-content' => array(
					'text-align' => $attr['alignment'],
				),
				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-mobile .responsive-block-editor-addons-ifb-icon-wrap' => array(
					'text-align' => $attr['alignment'],
				),
				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-mobile .responsive-block-editor-addons-ifb-imgicon-wrap' => array(
					'text-align' => $attr['alignment'],
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-title' => array(
					'font-size' => self::get_css_value( $attr['resheadFontSizeMobile'], 'px !important' ),
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-desc' => array(
					'font-size' => self::get_css_value( $attr['ressubHeadFontSizeMobile'], 'px !important' ),
				),

				' .responsive-block-editor-addons-ifb-image-content img' => array(
					'width'     => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox-cta-link' => array(
					'font-size' => self::get_css_value( $attr['ctaTextFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-title-prefix' => array(
					'margin-bottom' => self::get_css_value( $attr['resprefixSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-title' => array(
					'margin-bottom' => self::get_css_value( $attr['resheadBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-image-content > img' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['resImageTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['resImageRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['resImageBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['resImageLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-separator' => array(
					'margin-bottom' => self::get_css_value( $attr['sepSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-desc' => array(
					'margin-bottom' => self::get_css_value( $attr['ressubHeadBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-cta' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox-cta-link.responsive-block-editor-addons-ifb-cta-button' => array(
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPaddingTablet'], 'px'),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPaddingTablet'], 'px'),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPaddingTablet'], 'px'),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPaddingTablet'], 'px'),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusMobile'], 'px'),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusMobile'], 'px'),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusMobile'], 'px'),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusMobile'], 'px'),
				),
				' .responsive-block-editor-addons-cta-image' => array(
					'background-position' => $background_position_focal_mobile,
					'background-size'     => $attr['backgroundSizeMobile'],
				),
			);

			$tablet_selectors = array(
				' '                                        => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'                    => $attr['z_indexTablet'],
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-image-icon-content.responsive-block-editor-addons-ifb-imgicon-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['iconBottomMarginTablet'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['iconTopMarginTablet'], 'px' ),
					'margin-left'   => self::get_css_value( $attr['iconLeftMarginTablet'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['iconRightMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-tablet .responsive-block-editor-addons-ifb-content' => array(
					'text-align' => $attr['alignment'],
				),

				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-tablet .responsive-block-editor-addons-ifb-icon-wrap' => array(
					'text-align' => $attr['alignment'],
				),

				' .responsive-block-editor-addons-infobox__content-wrap.responsive-block-editor-addons-infobox-stacked-tablet .responsive-block-editor-addons-ifb-imgicon-wrap' => array(
					'text-align' => $attr['alignment'],
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-title' => array(
					'font-size' => self::get_css_value( $attr['resheadFontSizeTablet'], 'px !important' ),
				),

				' .responsive-block-editor-addons-infobox__content-wrap .responsive-block-editor-addons-ifb-desc' => array(
					'font-size' => self::get_css_value( $attr['ressubHeadFontSizeTablet'], 'px !important' ),
				),

				' .responsive-block-editor-addons-ifb-image-content img' => array(
					'width'     => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox-cta-link' => array(
					'font-size' => self::get_css_value( $attr['ctaTextFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-title-prefix' => array(
					'margin-bottom' => self::get_css_value( $attr['resprefixSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-title' => array(
					'margin-bottom' => self::get_css_value( $attr['resheadBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-icon' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-image-content > img' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['resImageTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['resImageRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['resImageBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['resImageLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-separator' => array(
					'margin-bottom' => self::get_css_value( $attr['sepSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-desc' => array(
					'margin-bottom' => self::get_css_value( $attr['ressubHeadBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-ifb-cta' => array(
					'margin-bottom' => self::get_css_value( $attr['ctaTextBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-infobox-cta-link.responsive-block-editor-addons-ifb-cta-button' => array(
					'padding-top'                => self::get_css_value( $attr['ctaButtonTopPaddingMobile'], 'px'),
					'padding-bottom'             => self::get_css_value( $attr['ctaButtonBottomPaddingMobile'], 'px'),
					'padding-left'               => self::get_css_value( $attr['ctaButtonLeftPaddingMobile'], 'px'),
					'padding-right'              => self::get_css_value( $attr['ctaButtonRightPaddingMobile'], 'px'),
					'border-top-left-radius'     => self::get_css_value( $attr['ctaBlockTopRadiusTablet'], 'px'),
					'border-top-right-radius'    => self::get_css_value( $attr['ctaBlockRightRadiusTablet'], 'px'),
					'border-bottom-right-radius' => self::get_css_value( $attr['ctaBlockBottomRadiusTablet'], 'px'),
					'border-bottom-left-radius'  => self::get_css_value( $attr['ctaBlockLeftRadiusTablet'], 'px'),
				),
				' .responsive-block-editor-addons-cta-image' => array(
					'background-position' => $background_position_focal_tablet,
					'background-size'     => $attr['backgroundSizeTablet'],
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-info-block.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for info block
		 *
		 * @return array
		 */
		public static function get_responsive_block_info_block_default_attributes() {
			return array(
				'block_id'                      => '',
				'inheritFromTheme'              => false,
				'resprefixTitle'                => 'Prefix',
				'classMigrate'                  => false,
				'resinfoBlockTitle'             => 'Info Box',
				'resDescHeading'                => 'Click here to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
				'resheadingAlign'               => 'center',
				'alignment'                     => 'center',
				'resheadingColor'               => '',
				'ressubheadingColor'            => '',
				'resprefixColor'                => '',
				'icon'                          => 'fa fa-star',
				'imgiconPosition'               => 'above-title',
				'resIconSize'                   => 40,
				'iconColor'                     => '#333',
				'resprefixFontSize'             => '',
				'resprefixFontWeight'           => '',
				'resprefixLineHeight'           => '',
				'resheadingTag'                 => 'h3',
				'resheadFontFamily'             => '',
				'ressubHeadFontFamily'          => '',
				'resheadFontSize'               => '',
				'resheadFontSizeMobile'         => '',
				'resheadFontSizeTablet'         => '',
				'resheadFontWeight'             => '700',
				'resheadLineHeight'             => '',
				'ressubHeadFontSize'            => '',
				'ressubHeadFontSizeTablet'      => '',
				'ressubHeadFontSizeMobile'      => '',
				'ressubHeadFontWeight'          => '100',
				'ressubHeadLineHeight'          => '',
				'resheadSpace'                  => 10,
				'resheadSpaceMobile'            => '',
				'resheadSpaceTablet'            => '',
				'ressubHeadSpace'               => 10,
				'ressubHeadSpaceMobile'         => '',
				'ressubHeadSpaceTablet'         => '',
				'resseperatorSpace'             => 10,
				'source_type'                   => 'icon',
				'ressourceAlign'                => 'top',
				'resctaTarget'                  => false,
				'ctaIcon'                       => '',
				'resseperatorPosition'          => 'after_title',
				'resseperatorStyle'             => 'solid',
				'resseperatorColor'             => '',
				'resseperatorWidth'             => 30,
				'resseparatorWidthType'         => '%',
				'resseperatorThickness'         => 2,
				'resctaType'                    => 'none',
				'resctaText'                    => 'Read More',
				'resctaLink'                    => '#',
				'resctaLinkColor'               => '#333',
				'resctaFontSize'                => '',
				'resctaFontWeight'              => '',
				'ctaColor'                      => '#333',
				'resctaBtnLinkColor'            => 'empty', // For compatibility with v1.3.2.
				'ctaBackColor'                  => 'transparent',
				'resctaBgColor'                 => 'empty', // For compatibility with v1.3.2.
				'ctaBorderColor'                => '#333',
				'resctaBorderColor'             => 'empty', // For compatibility with v1.3.2.
				'ctaBorderStyle'                => 'solid',
				'resctaBorderStyle'             => 'empty', // For compatibility with v1.3.2.
				'ctaVpadding'                   => 10,
				'ctaHpadding'                   => 14,
				'ctaVertPadding'                => 999, // For compatibility with v1.3.2.
				'ctaHrPadding'                  => 999, // For compatibility with v1.3.2.
				'ctaBorderWidth'                => 1,
				'ctaBorderRadius'               => 0,
				'resctaBorderWidth'             => 999, // For compatibility with v1.3.2.
				'resctaBorderRadius'            => 999, // For compatibility with v1.3.2.
				'resprefixSpace'                => 5,
				'resprefixSpaceMobile'          => '',
				'resprefixSpaceTablet'          => '',
				'iconLeftMargin'                => 0,
				'iconRightMargin'               => 0,
				'iconTopMargin'                 => 5,
				'iconBottomMargin'              => 5,
				'iconLeftMarginMobile'          => '',
				'iconRightMarginMobile'         => '',
				'iconTopMarginMobile'           => '',
				'iconBottomMarginMobile'        => '',
				'iconLeftMarginTablet'          => '',
				'iconRightMarginTablet'         => '',
				'iconTopMarginTablet'           => '',
				'iconBottomMarginTablet'        => '',
				'iconImage'                     => '',
				'imageSize'                     => 'thumbnail',
				'imageWidth'                    => 120,
				'imageWidthTablet'              => '',
				'imageWidthMobile'              => '',
				'imageWidthType'                => true,
				'stack'                         => 'tablet',
				'resshowPrefix'                 => true,
				'resshowTitle'                  => true,
				'resshowDesc'                   => true,
				'blockBorderStyle'              => 'none',
				'blockBorderWidth'              => 1,
				'blockBorderRadius'             => '',
				'blockTopRadiusMobile'          => '',
				'blockRightRadiusMobile'        => '',
				'blockBottomRadiusMobile'       => '',
				'blockLeftRadiusMobile'         => '',
				'blockTopRadiusTablet'          => '',
				'blockRightRadiusTablet'        => '',
				'blockBottomRadiusTablet'       => '',
				'blockLeftRadiusTablet'         => '',
				'blockTopRadius'                => '',
				'blockRightRadius'              => '',
				'blockBottomRadius'             => '',
				'blockLeftRadius'               => '',
				'blockBorderColor'              => '',
				'boxShadowColor'                => '',
				'boxShadowHOffset'              => 0,
				'boxShadowVOffset'              => 0,
				'boxShadowBlur'                 => '',
				'boxShadowSpread'               => '',
				'boxShadowPosition'             => 'outset',
				'imageBoxShadowColor'           => '',
				'imageBoxShadowHOffset'         => 0,
				'imageBoxShadowVOffset'         => 0,
				'imageBoxShadowBlur'            => '',
				'imageBoxShadowSpread'          => '',
				'imageBoxShadowPosition'        => 'outset',
				'counterId'                     => 1,
				'backgroundColor'               => '#ffffff',
				'boxBackgroundColor'            => 'empty', // For compatibility with v1.3.2.
				'contentPadding'                => '',
				'contentPaddingMobile'          => '',
				'contentPaddingTablet'          => '',
				'opacity'                       => 100,
				'imageopacity'                  => 100,
				'imgURL'                        => '', // For compatibility with v1.3.2.
				'imgID'                         => '',
				'imgAlt'                        => '',
				'dimRatio'                      => 50,
				'ctaHoverColor'                 => '#333',
				'ctaHoverBackColor'             => '#333',
				'ctaHoverBorderColor'           => '#333',
				'hoverctaBorderColor'           => 'empty',  // For compatibility with v1.3.2.
				'hoverctaBtnLinkColor'          => 'empty',  // For compatibility with v1.3.2.
				'hoverctaBgColor'               => 'empty',  // For compatibility with v1.3.2.
				'imagePosition'                 => 'center center', // For compatibility with v1.3.2.
				'imageRepeat'                   => 'no-repeat', // For compatibility with v1.3.2.
				'thumbsize'                     => 'cover', // For compatibility with v1.3.2.
				'backgroundAttachment'          => 'scroll',
				'sepSpace'                      => 10,
				'sepSpaceMobile'                => '',
				'sepSpaceTablet'                => '',
				'icon_color'                    => '#3a3a3a',
				'icon_hcolor'                   => '#3a3a3a',
				'resImageBorderColor'           => '#333',
				'resImageBorderStyle'           => 'none',
				'resImageBorderRadius'          => 0,
				'resImageTopRadiusMobile'       => '',
				'resImageRightRadiusMobile'     => '',
				'resImageBottomRadiusMobile'    => '',
				'resImageLeftRadiusMobile'      => '',
				'resImageTopRadiusTablet'       => '',
				'resImageRightRadiusTablet'     => '',
				'resImageBottomRadiusTablet'    => '',
				'resImageLeftRadiusTablet'      => '',
				'resImageTopRadius'             => '',
				'resImageRightRadius'           => '',
				'resImageBottomRadius'          => '',
				'resImageLeftRadius'            => '',
				'resImageBorderWidth'           => 2,
				'ctaTextFontFamily'             => '',
				'ctaTextFontSize'               => '',
				'ctaTextFontSizeMobile'         => '',
				'ctaTextFontSizeTablet'         => '',
				'ctaTextFontWeight'             => '100',
				'ctaTextLineHeight'             => '',
				'ctaBottomMargin'               => 10,
				'ctaBottomMarginMobile'         => '',
				'ctaBottomMarginTablet'         => '',
				'hoverboxShadowColor'           => '',
				'hoverboxShadowHOffset'         => 0,
				'hoverboxShadowVOffset'         => 0,
				'hoverboxShadowBlur'            => 0,
				'hoverboxShadowSpread'          => 0,
				'hoverboxShadowPosition'        => 'outset',
				'iconBackgroundColor'           => '#0066cc',
				'iconBackgroundHoverColor'      => '',
				'iconBackgroundType'            => 'none',
				'iconPadding'                   => 5,
				'iconBorderRadius'              => 0,
				'iconTopRadiusMobile'           => '',
				'iconRightRadiusMobile'         => '',
				'iconBottomRadiusMobile'        => '',
				'iconLeftRadiusMobile'          => '',
				'iconTopRadiusTablet'           => '',
				'iconRightRadiusTablet'         => '',
				'iconBottomRadiusTablet'        => '',
				'iconLeftRadiusTablet'          => '',
				'iconTopRadius'                 => '',
				'iconRightRadius'               => '',
				'iconBottomRadius'              => '',
				'iconLeftRadius'                => '',
				'iconBorderWidth'               => 1,
				'backgroundImage'               => '',
				'backgroundImagePosition'       => 'center center',
				'backgroundImageRepeat'         => 'no-repeat',
				'backgroundImageSize'           => 'cover',
				'ctaHpaddingTablet'             => 14,
				'ctaHpaddingMobile'             => 14,
				'ctaVpaddingTablet'             => 10,
				'ctaVpaddingMobile'             => 10,
				'buttoncolorLocation1'          => 0,
				'buttoncolorLocation2'          => 100,
				'buttongradientDirection'       => 90,
				'buttonbackgroundColor1'        => '',
				'buttonbackgroundColor2'        => '#fff',
				'buttonbackgroundType'          => '',
				'buttonHbackgroundType'         => 'none',
				'animationName'                 => 'none',
				'animationDirection'            => 'Left',
				'animationRepeat'               => 'once',
				'animationDuration'             => 1000,
				'animationDelay'                => 1000,
				'animationCurve'                => '',
				'hideWidget'                    => false,
				'hideWidgetMobile'              => false,
				'hideWidgetTablet'              => false,
				'z_index'                       => 1,
				'z_indexMobile'                 => 1,
				'z_indexTablet'                 => 1,
				'blockTopPadding'               => '',
				'blockTopPaddingMobile'         => '',
				'blockTopPaddingTablet'         => '',
				'blockBottomPadding'            => '',
				'blockBottomPaddingMobile'      => '',
				'blockBottomPaddingTablet'      => '',
				'blockLeftPadding'              => '',
				'blockLeftPaddingMobile'        => '',
				'blockLeftPaddingTablet'        => '',
				'blockRightPadding'             => '',
				'blockRightPaddingMobile'       => '',
				'blockRightPaddingTablet'       => '',
				'blockTopMargin'                => '',
				'blockTopMarginMobile'          => '',
				'blockTopMarginTablet'          => '',
				'blockBottomMargin'             => '',
				'blockBottomMarginMobile'       => '',
				'blockBottomMarginTablet'       => '',
				'blockLeftMargin'               => '',
				'blockLeftMarginMobile'         => '',
				'blockLeftMarginTablet'         => '',
				'blockRightMargin'              => '',
				'blockRightMarginMobile'        => '',
				'blockRightMarginTablet'        => '',
				'ressubHeadTypographyColor'     => '',
				'resheadTypographyColor'        => '',
				'ctaTextTypographyColor'        => '#333',
				'resheadBottomSpacing'          => 10,
				'resheadBottomSpacingMobile'    => '',
				'resheadBottomSpacingTablet'    => '',
				'ressubHeadBottomSpacing'       => 10,
				'ressubHeadBottomSpacingMobile' => '',
				'ressubHeadBottomSpacingTablet' => '',
				'ctaTextBottomSpacing'          => 10,
				'ctaTextBottomSpacingMobile'    => '',
				'ctaTextBottomSpacingTablet'    => '',
				'backgroundPosition'            => 'center-center',
				'backgroundPositionTablet'      => 'center center',
				'backgroundPositionMobile'      => 'center center',
				'backgroundPositionFocal'       => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundSize'                => 'cover',
				'backgroundSizeTablet'          => 'cover',
				'backgroundSizeMobile'          => 'cover',
				'backgroundRepeat'              => 'no-repeat',
				'widthType'                     => '%',
				'ctaTextTextTransform'          => '',
				'ctaTextFontStyle'              => '',
				'resheadTextTransform'          => '',
				'resheadFontStyle'              => '',
				'ressubHeadTextTransform'       => '',
				'ressubHeadFontStyle'           => '',
				'ctaBlockTopRadius'             => '',
				'ctaBlockTopRadiusTablet'       => '',
				'ctaBlockTopRadiusMobile'       => '',
				'ctaBlockBottomRadius'          => '',
				'ctaBlockBottomRadiusTablet'    => '',
				'ctaBlockBottomRadiusMobile'    => '',
				'ctaBlockLeftRadius'            => '',
				'ctaBlockLeftRadiusTablet'      => '',
				'ctaBlockLeftRadiusMobile'      => '',
				'ctaBlockRightRadius'           => '',
				'ctaBlockRightRadiusTablet'     => '',
				'ctaBlockRightRadiusMobile'     => '',
				'ctaButtonTopPadding'           => 10,
				'ctaButtonBottomPadding'        => 10,
				'ctaButtonLeftPadding'          => 14,
				'ctaButtonRightPadding'         => 14,
				'ctaButtonTopPaddingTablet'     => 10,
				'ctaButtonBottomPaddingTablet'  => 10,
				'ctaButtonLeftPaddingTablet'    => 14,
				'ctaButtonRightPaddingTablet'   => 14,
				'ctaButtonTopPaddingMobile'     => 10,
				'ctaButtonBottomPaddingMobile'  => 10,
				'ctaButtonLeftPaddingMobile'    => 14,
				'ctaButtonRightPaddingMobile'   => 14,
			);
		}

		/**
		 * Get Post timeline Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_post_timeline_css( $attr, $id ) {
			$defaults = self::get_responsive_block_post_timeline_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadius'        => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadius'       => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadius'         => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusTablet'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusTablet'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusTablet' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusTablet'   => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusMobile'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusMobile'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusMobile' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusMobile'   => 'borderRadius' ? 'borderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'headingTypographyColor'     => 'headingColor' ? 'headingColor' : '',
				'authorTypographyColor'      => 'authorColor' ? 'authorColor' : '',
				'contentTypographyColor'     => 'textColor' ? 'textColor' : '',
				'headingBottomSpacing'       => 'headingSpace' ? 'headingSpace' : '',
				'headingBottomSpacingMobile' => 'headingSpaceMobile' ? 'headingSpaceMobile' : '',
				'headingBottomSpacingTablet' => 'headingSpaceTablet' ? 'headingSpaceTablet' : '',
				'authorBottomSpacing'        => 'authorSpace' ? 'authorSpace' : '',
				'authorBottomSpacingMobile'  => 'authorSpaceMobile' ? 'authorSpaceMobile' : '',
				'authorBottomSpacingTablet'  => 'authorSpaceTablet' ? 'authorSpaceTablet' : '',
				'contentBottomSpacing'       => 'excerptSpace' ? 'excerptSpace' : '',
				'contentBottomSpacingMobile' => 'excerptSpaceMobile' ? 'excerptSpaceMobile' : '',
				'contentBottomSpacingTablet' => 'excerptSpaceTablet' ? 'excerptSpaceTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                        => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				'.responsive-block-editor-addons-block-post-timeline' => array(
					'z-index' => $attr['z_index'],
				),
				' .responsive-block-editor-addons-timeline__icon-new svg' => array(
					'width'  => self::get_css_value( $attr['iconSize'], 'px' ),
					'height' => self::get_css_value( $attr['iconSize'], 'px' ),
					'fill'   => $attr['iconColor'],
				),
				' .responsive-block-editor-addons-timeline__marker' => array(
					'border'           => self::get_css_value( $attr['borderWidth'], 'px solid' ),
					'border-color'     => $attr['separatorBorder'],
					'background-color' => $attr['separatorBg'],
					'min-width'        => self::get_css_value( $attr['bgSize'], 'px' ),
					'min-height'       => self::get_css_value( $attr['bgSize'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__line' => array(
					'background-color' => $attr['connectorColor'],
					'width'            => self::get_css_value( $attr['connectorWidth'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__link_parent' => array(
					'background-color' => $attr['continuebgColor'],
					'border'           => '1px solid ' . $attr['borderColor'] . '',
					'box-shadow'       =>
					self::get_css_value(
						$attr['boxShadowHOffset'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['boxShadowVOffset'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['boxShadowBlur'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['boxShadowSpread'],
						'px'
					) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
				),
				' .responsive-block-editor-addons-timeline__link_parent:hover' => array(
					'background-color' => $attr['continuebghColor'],
					'border'           => '1px solid ' . $attr['borderHColor'] . '',
					'box-shadow'       => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value(
						$attr['hoverboxShadowHOffset'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['hoverboxShadowVOffset'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['hoverboxShadowBlur'],
						'px'
					) .
					' ' .
					self::get_css_value(
						$attr['hoverboxShadowSpread'],
						'px'
					) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-timeline__link_parent .responsive-block-editor-addons-timeline__link' => array(
					'color'       => $attr['continueColor'] . '!important',
					'line-height' => $attr['continueLineHeight'],
					'font-weight' => $attr['continueFontWeight'],
					'font-size'   => self::get_css_value( $attr['continueFontSize'], 'px' ),
					'font-family' => $attr['continueFontFamily'],
					'text-transform' => $attr['continueTextTransform'],
					'font-style'  => $attr['continueFontStyle'], 
				),
				' .responsive-block-editor-addons-timeline__link_parent:hover .responsive-block-editor-addons-timeline__link' => array(
					'color' => $attr['hColor'] . '!important',
				),
				'.responsive-block-editor-addons-timeline__center-block .responsive-block-editor-addons-timeline__marker' => array(
					'margin-left'  => self::get_css_value( $attr['horSpace'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horSpace'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__left-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-left' => self::get_css_value( $attr['horSpace'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__right-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-right' => self::get_css_value( $attr['horSpace'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__field.responsive-block-editor-addons-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verSpace'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__left-block .responsive-block-editor-addons-timeline__line' => array(
					'left' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__right-block .responsive-block-editor-addons-timeline__line' => array(
					'right' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__main .responsive-block-editor-addons-timeline__post p' => array(
					'line-height' => $attr['contentLineHeight'],
				),
				' .responsive-block-editor-addons-timeline__events-new' => array(
					'margin-bottom' => self::get_css_value( $attr['blockSpace'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__events-new .responsive-block-editor-addons-timeline__events-inner-new' => array(
					'background-color'           => $attr['bgColor']
					? $attr['bgColor'] : '#e4e4e4',
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__date-hide.responsive-block-editor-addons-timeline__date-inner .responsive-block-editor-addons-timeline__date-new' => array(
					'line-height' => $attr['dateLineHeight'],
					'font-weight' => $attr['dateFontWeight'],
					'font-size'   => self::get_css_value( $attr['dateFontSize'], 'px' ),
					'font-family' => $attr['dateFontFamily'],
					'text-transform'=> $attr['dateTextTransform'],
      				'font-style'=> $attr['dateFontStyle'],
				),
				' .responsive-block-editor-addons-content' => array(
					'padding' => self::get_css_value( $attr['contentPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title' => array(
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title .responsive-block-editor-addons-block-post-timeline-title-heading' => array(
					'color'       => $attr['headingTypographyColor']
					? $attr['headingTypographyColor'] . '!important'
					: '#333',
					'line-height' => $attr['headingLineHeight'],
					'font-weight' => $attr['headingFontWeight'],
					'font-size'   => self::get_css_value( $attr['headingFontSize'], 'px' ),
					'font-family' => $attr['headingFontFamily'],
					'text-transform'=> $attr['headingTextTransform'],
      				'font-style'=> $attr['headingFontStyle'],
				),
				' .responsive-block-editor-addons-block-post-timeline-byline' => array(
					'margin-bottom' => self::get_css_value( $attr['authorBottomSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-author .responsive-block-editor-addons-text-link' => array(
					'color'       => $attr['authorTypographyColor']
					? $attr['authorTypographyColor'] . '!important'
					: '#626e81',
					'line-height' => $attr['authorLineHeight'],
					'font-weight' => $attr['authorFontWeight'],
					'font-size'   => self::get_css_value( $attr['authorFontSize'], 'px' ),
					'font-family' => $attr['authorFontFamily'],
					'text-transform'=> $attr['authorTextTransform'],
      				'font-style'=> $attr['authorFontStyle'],
				),
				' .responsive-block-editor-addons-block-post-timeline-excerpt .responsive-block-editor-addons-timeline__post' => array(
					'color'         => $attr['contentTypographyColor']
					? $attr['contentTypographyColor'] . '!important'
					: '#333',
					'font-weight'   => $attr['contentFontWeight'],
					'font-size'     => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-family'   => $attr['contentFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacing'], 'px' ),
					'text-transform'=> $attr['contentTextTransform'],
      				'font-style'=> $attr['contentFontStyle'],
				),
				' .responsive-block-editor-addons-timeline__date-new.responsive-block-editor-addons-timeline__date-outer' => array(
					'line-height' => $attr['dateLineHeight'],
					'font-weight' => $attr['dateFontWeight'],
					'font-size'   => self::get_css_value( $attr['dateFontSize'], 'px' ),
					'font-family' => $attr['dateFontFamily'],
					'text-transform'=> $attr['dateTextTransform'],
      				'font-style'=> $attr['dateFontStyle'],
				),
				' .responsive-block-editor-addons-timeline__main .responsive-block-editor-addons-timeline__line__inner' => array(
					'background-color' => $attr['separatorFillColor'],
				),
				' .responsive-block-editor-addons-timeline__main .responsive-block-editor-addons-timeline__marker.responsive-block-editor-addons-timeline__in-view-icon' => array(
					'background'   => $attr['iconBgFocus'],
					'border-color' => $attr['borderFocus'],
					'color'        => $attr['iconFocus'],
				),

				' .responsive-block-editor-addons-timeline__main .responsive-block-editor-addons-timeline__marker.responsive-block-editor-addons-timeline__in-view-icon svg' => array(
					'fill' => $attr['iconFocus'],
				),

				' .responsive-block-editor-addons-timeline__main .responsive-block-editor-addons-timeline__marker.responsive-block-editor-addons-timeline__in-view-icon .responsive-block-editor-addons-timeline__icon-new' => array(
					'color' => $attr['iconFocus'],
				),
			);

			$mobile_selectors = array(
				' '                                        => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
				),
				'.responsive-block-editor-addons-block-post-timeline' => array(
					'z-index' => $attr['z_indexMobile'],
				),
				' .responsive-block-editor-addons-timeline__center-block.responsive-block-editor-addons-timeline__responsive-mobile .responsive-block-editor-addons-timeline__line' => array(
					'left'  => 'calc(' . $attr['bgSize'] . '/2)px',
					'right' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__left-block.responsive-block-editor-addons-timeline__responsive-mobile .responsive-block-editor-addons-timeline__line' => array(
					'left' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__right-block.responsive-block-editor-addons-timeline__responsive-mobile .responsive-block-editor-addons-timeline__line' => array(
					'right' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__link_parent .responsive-block-editor-addons-timeline__link' => array(
					'font-size' => self::get_css_value( $attr['continueFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__date-hide.responsive-block-editor-addons-timeline__date-inner .responsive-block-editor-addons-timeline__date-new' => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title .responsive-block-editor-addons-block-post-timeline-title-heading' => array(
					'font-size' => self::get_css_value( $attr['headingFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-author .responsive-block-editor-addons-text-link' => array(
					'font-size' => self::get_css_value( $attr['authorFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-excerpt .responsive-block-editor-addons-timeline__post' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__date-new.responsive-block-editor-addons-timeline__date-outer' => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-content' => array(
					'padding' => self::get_css_value( $attr['contentPaddingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__events-new' => array(
					'margin-bottom' => self::get_css_value( $attr['blockSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title' => array(
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-byline' => array(
					'margin-bottom' => self::get_css_value( $attr['authorBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__field.responsive-block-editor-addons-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verSpaceMobile'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__center-block .responsive-block-editor-addons-timeline__marker' => array(
					'margin-left'  => self::get_css_value( $attr['horSpaceMobile'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horSpaceMobile'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__left-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-left' => self::get_css_value( $attr['horSpaceMobile'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__right-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-right' => self::get_css_value( $attr['horSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__events-new .responsive-block-editor-addons-timeline__events-inner-new' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                                        => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
				),
				'.responsive-block-editor-addons-block-post-timeline' => array(
					'z-index' => $attr['z_indexTablet'],
				),
				' .responsive-block-editor-addons-timeline__center-block.responsive-block-editor-addons-timeline__responsive-tablet .responsive-block-editor-addons-timeline__line' => array(
					'left'  => 'calc(' . $attr['bgSize'] . '/2)px',
					'right' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__left-block.responsive-block-editor-addons-timeline__responsive-tablet .responsive-block-editor-addons-timeline__line' => array(
					'left' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__right-block.responsive-block-editor-addons-timeline__responsive-tablet .responsive-block-editor-addons-timeline__line' => array(
					'right' => 'calc(' . $attr['bgSize'] . '/2)px',
				),
				' .responsive-block-editor-addons-timeline__link_parent .responsive-block-editor-addons-timeline__link' => array(
					'font-size' => self::get_css_value( $attr['continueFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__date-hide.responsive-block-editor-addons-timeline__date-inner .responsive-block-editor-addons-timeline__date-new' => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title .responsive-block-editor-addons-block-post-timeline-title-heading' => array(
					'font-size' => self::get_css_value( $attr['headingFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-author .responsive-block-editor-addons-text-link' => array(
					'font-size' => self::get_css_value( $attr['authorFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-excerpt .responsive-block-editor-addons-timeline__post' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__date-new.responsive-block-editor-addons-timeline__date-outer' => array(
					'font-size' => self::get_css_value( $attr['dateFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-content' => array(
					'padding' => self::get_css_value( $attr['contentPaddingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__events-new' => array(
					'margin-bottom' => self::get_css_value( $attr['blockSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-title' => array(
					'margin-bottom' => self::get_css_value( $attr['headingBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-post-timeline-byline' => array(
					'margin-bottom' => self::get_css_value( $attr['authorBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__field.responsive-block-editor-addons-timeline__field-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['verSpaceTablet'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__center-block .responsive-block-editor-addons-timeline__marker' => array(
					'margin-left'  => self::get_css_value( $attr['horSpaceTablet'], 'px' ),
					'margin-right' => self::get_css_value( $attr['horSpaceTablet'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__left-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-left' => self::get_css_value( $attr['horSpaceTablet'], 'px' ),
				),
				'.responsive-block-editor-addons-timeline__right-block .responsive-block-editor-addons-timeline__day-new' => array(
					'margin-right' => self::get_css_value( $attr['horSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-timeline__events-new .responsive-block-editor-addons-timeline__events-inner-new' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-post-timeline.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for post timeline block
		 *
		 * @return array
		 */
		public static function get_responsive_block_post_timeline_default_attributes() {
			return array(
				'categories'                 => '',
				'className'                  => '',
				'postsToShow'                => 6,
				'displayPostDate'            => true,
				'displayPostExcerpt'         => true,
				'displayPostAuthor'          => true,
				'displayPostImage'           => true,
				'displayPostLink'            => true,
				'displayPostTitle'           => true,
				'displaySectionTitle'        => false,
				'postTitleTag'               => 'h3',
				'postLayout'                 => 'grid',
				'columns'                    => 2,
				'align'                      => 'center',
				'timelinAlignment'           => 'center',
				'arrowlinAlignment'          => 'center',
				'width'                      => 'wide',
				'order'                      => 'desc',
				'orderBy'                    => 'date',
				'readMoreText'               => 'Continue Reading',
				'offset'                     => 0,
				'excerptLength'              => 55,
				'postType'                   => 'post',
				'sectionTag'                 => 'section',
				'sectionTitle'               => '',
				'sectionTitleTag'            => 'h2',
				'imageSize'                  => 'full',
				'url'                        => '',
				'source'                     => 'attribute',
				'selector'                   => 'img',
				'attribute'                  => 'src',
				'id'                         => '',
				'bgColor'                    => '#e4e4e4',
				'textColor'                  => '#333',
				'contentPadding'             => 20,
				'contentPaddingMobile'       => '',
				'contentPaddingTablet'       => '',
				'authorSpace'                => '',
				'authorSpaceTablet'          => '',
				'authorSpaceMobile'          => '',
				'excerptSpace'               => '',
				'excerptSpaceTablet'         => '',
				'excerptSpaceMobile'         => '',
				'blockSpace'                 => '',
				'blockSpaceTablet'           => '',
				'blockSpaceMobile'           => '',
				'headingSpace'               => '',
				'headingSpaceTablet'         => '',
				'headingSpaceMobile'         => '',
				'headingColor'               => '#333',
				'authorColor'                => '#626e81',
				'continueColor'              => '#333',
				'dateFontFamily'             => '',
				'headingFontFamily'          => '',
				'authorFontFamily'           => '',
				'contentFontFamily'          => '',
				'continueFontFamily'         => '',
				'connectorColor'             => '#eeeeee',
				'dateFontSize'               => 16,
				'dateFontWeight'             => 400,
				'dateLineHeight'             => 1.75,
				'headingFontSize'            => 20,
				'headingFontWeight'          => 700,
				'headingLineHeight'          => 1.5,
				'authorFontSize'             => 14,
				'authorFontWeight'           => 400,
				'authorLineHeight'           => 1.5,
				'contentFontSize'            => 16,
				'contentFontWeight'          => 400,
				'contentLineHeight'          => 1.75,
				'continueFontSize'           => 16,
				'continueFontWeight'         => 700,
				'continueLineHeight'         => 1.75,
				'icon'                       => 'calendar-alt',
				'iconSize'                   => 16,
				'bgSize'                     => 35,
				'borderWidth'                => 0,
				'connectorWidth'             => 3,
				'iconColor'                  => '#333',
				'separatorBg'                => '#eee',
				'separatorBorder'            => '#eee',
				'separatorFillColor'         => '#61ce70',
				'iconFocus'                  => '#fff',
				'iconBgFocus'                => '#61ce70',
				'borderFocus'                => '#5cb85c',
				'continuebgColor'            => '',
				'borderColor'                => '',
				'hColor'                     => '#333',
				'continuebghColor'           => '',
				'borderHColor'               => '',
				'target'                     => true,
				'borderRadius'               => 0,
				'verSpace'                   => 0,
				'verSpaceTablet'             => 0,
				'verSpaceMobile'             => 0,
				'horSpace'                   => 0,
				'horSpaceTablet'             => 0,
				'horSpaceMobile'             => 0,
				'stack'                      => 'mobile',
				'boxShadowColor'             => '',
				'boxShadowPosition'          => 'outset',
				'boxShadowHOffset'           => 0,
				'boxShadowVOffset'           => 0,
				'boxShadowBlur'              => 0,
				'boxShadowSpread'            => 0,
				'hoverboxShadowColor'        => '',
				'hoverboxShadowPosition'     => 'outset',
				'hoverboxShadowHOffset'      => 0,
				'hoverboxShadowVOffset'      => 0,
				'hoverboxShadowBlur'         => 0,
				'hoverboxShadowSpread'       => 0,
				'taxonomyType'               => 'category',
				'block_id'                   => '',
				'dateFontSizeMobile'         => '',
				'dateFontSizeTablet'         => '',
				'headingFontSizeMobile'      => '',
				'headingFontSizeTablet'      => '',
				'authorFontSizeMobile'       => '',
				'authorFontSizeTablet'       => '',
				'contentFontSizeMobile'      => '',
				'contentFontSizeTablet'      => '',
				'continueFontSizeMobile'     => '',
				'continueFontSizeTablet'     => '',
				'hideWidget'                 => false,
				'hideWidgetMobile'           => false,
				'hideWidgetTablet'           => false,
				'z_index'                    => 1,
				'z_indexMobile'              => 1,
				'z_indexTablet'              => 1,
				'blockTopPadding'            => '',
				'blockTopPaddingMobile'      => '',
				'blockTopPaddingTablet'      => '',
				'blockBottomPadding'         => '',
				'blockBottomPaddingMobile'   => '',
				'blockBottomPaddingTablet'   => '',
				'blockLeftPadding'           => '',
				'blockLeftPaddingMobile'     => '',
				'blockLeftPaddingTablet'     => '',
				'blockRightPadding'          => '',
				'blockRightPaddingMobile'    => '',
				'blockRightPaddingTablet'    => '',
				'blockTopMargin'             => '',
				'blockTopMarginMobile'       => '',
				'blockTopMarginTablet'       => '',
				'blockBottomMargin'          => '',
				'blockBottomMarginMobile'    => '',
				'blockBottomMarginTablet'    => '',
				'blockLeftMargin'            => '',
				'blockLeftMarginMobile'      => '',
				'blockLeftMarginTablet'      => '',
				'blockRightMargin'           => '',
				'blockRightMarginMobile'     => '',
				'blockRightMarginTablet'     => '',
				'blockTopRadiusMobile'       => 0,
				'blockRightRadiusMobile'     => 0,
				'blockBottomRadiusMobile'    => 0,
				'blockLeftRadiusMobile'      => 0,
				'blockTopRadiusTablet'       => 0,
				'blockRightRadiusTablet'     => 0,
				'blockBottomRadiusTablet'    => 0,
				'blockLeftRadiusTablet'      => 0,
				'blockTopRadius'             => 0,
				'blockRightRadius'           => 0,
				'blockBottomRadius'          => 0,
				'blockLeftRadius'            => 0,
				'headingTypographyColor'     => '#333',
				'authorTypographyColor'      => '#626e81',
				'contentTypographyColor'     => '#333',
				'headingBottomSpacing'       => '',
				'headingBottomSpacingMobile' => '',
				'headingBottomSpacingTablet' => '',
				'authorBottomSpacing'        => '',
				'authorBottomSpacingMobile'  => '',
				'authorBottomSpacingTablet'  => '',
				'contentBottomSpacing'       => '',
				'contentBottomSpacingMobile' => '',
				'contentBottomSpacingTablet' => '',
				'dateTextTransform'          => '',
				'dateFontStyle'              => '',
				'headingTextTransform'       => '',
				'headingFontStyle'           => '',
				'authorTextTransform'        => '',
				'authorFontStyle'            => '',
				'contentTextTransform'       => '',
				'contentFontStyle'           => '',
				'continueTextTransform'      => '',
				'continueFontStyle'          => '',
			);
		}

		/**
		 * Get Pricing list Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_pricing_list_css( $attr, $id ) {
			$defaults = self::get_responsive_block_pricing_list_default_attributes();

			$new_border_radius_keys = array(
				'priceTypographyColor'       => 'priceColor' ? 'priceColor' : '',
				'descriptionTypographyColor' => 'descColor' ? 'descColor' : '',
				'titleTypographyColor'       => 'titleColor' ? 'titleColor' : '',
				'titleBottomSpacing'         => 'titleSpace' ? 'titleSpace' : '',
				'titleBottomSpacingMobile'   => 'titleSpaceMobile' ? 'titleSpaceMobile' : '',
				'titleBottomSpacingTablet'   => 'titleSpaceTablet' ? 'titleSpaceTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$align = $attr['contentAlign'];
			if ( 'left' === $align ) {
				$align = 'flex-start';
			} elseif ( 'right' === $align ) {
				$align = 'flex-end';
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'grid',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['pricingTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['pricingRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['pricingBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['pricingLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['pricingTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['pricingRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['pricingBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['pricingLeftMargin'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['rowGap'], 'px' ),
					'padding-left'  => self::get_css_value( $attr['columnGap'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGap'] / 2, 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap .responsive-block-editior-addons-pricing-list-item-content' => array(
					'padding-top'    => 999 !== $attr['topPadding'] && 5 === $attr['blockTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['blockTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['bottomPadding'] && 5 === $attr['blockBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['blockBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['leftPadding'] && 5 === $attr['blockLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['blockLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['rightPadding'] && 5 === $attr['blockRightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['blockRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'text-align'     => $attr['contentAlign'],
				),
				' .responsive-block-editior-addons-pricing-list-item-image-wrap .responsive-block-editior-addons-pricing-list-item-image' => array(
					'height'    => 'auto',
					'width'     => self::get_css_value( $attr['imageWidth'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidth'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-title' => array(
					'color'         => $attr['titleTypographyColor'],
					'text-transform'=> $attr['titleTextTransform'],
					'font-style'    => $attr['titleFontStyle'],
					'line-height'   => $attr['titleLineHeight'],
					'font-weight'   => $attr['titleFontWeight'],
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-family'   => $attr['titleFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-description' => array(
					'color'       => $attr['descriptionTypographyColor'],
					'text-transform'=> $attr['descriptionTextTransform'],
					'font-style'    => $attr['descriptionFontStyle'],
					'line-height' => $attr['descriptionLineHeight'],
					'font-weight' => $attr['descriptionFontWeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-family' => $attr['descriptionFontFamily'],
				),
				' .responsive-block-editior-addons-pricing-list-item-price-wrap' => array(
					'color'       => $attr['priceTypographyColor'],
					'text-transform'=> $attr['priceTextTransform'],
					'font-style'    => $attr['priceFontStyle'],
					'line-height' => $attr['priceLineHeight'],
					'font-weight' => $attr['priceFontWeight'],
					'font-size'   => self::get_css_value( $attr['priceFontSize'], 'px' ),
					'font-family' => $attr['priceFontFamily'],
				),
				' .responsive-block-editior-addons-pricing-list-item-image-wrap responsive-block-editior-addons-pricing-list-item-image' => array(
					'height'    => 'auto',
					'width'     => self::get_css_value( $attr['imageWidth'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidth'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-separator-wrap' => array(
					'justify-content' => $align,
				),
				' .responsive-block-editior-addons-pricing-list-item-separator' => array(
					'border-top-color' => $attr['seperatorColor'],
					'border-top-style' => $attr['seperatorStyle'],
					'border-top-width' => self::get_css_value( $attr['seperatorThickness'], 'px' ),
					'width'            => $attr['seperatorWidth'] . '%',
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'grid',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['pricingTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['pricingBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['pricingLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['pricingRightPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['pricingTopMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['pricingBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['pricingLeftMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['pricingRightMarginMobile'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
					'padding-left'  => self::get_css_value( $attr['columnGapMobile'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGapMobile'] / 2, 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap .responsive-block-editior-addons-pricing-list-item-content' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-description' => array(
					'font-size' => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-price-wrap' => array(
					'font-size' => self::get_css_value( $attr['priceFontSizeMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'grid',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['pricingTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['pricingBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['pricingLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['pricingRightPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['pricingTopMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['pricingBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['pricingLeftMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['pricingRightMarginTablet'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap' => array(
					'margin-bottom' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
					'padding-left'  => self::get_css_value( $attr['columnGapTablet'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGapTablet'] / 2, 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-wrap .responsive-block-editior-addons-pricing-list-item-content' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-description' => array(
					'font-size' => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editior-addons-pricing-list-item-price-wrap' => array(
					'font-size' => self::get_css_value( $attr['priceFontSizeTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-pricing-list.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for pricing list block
		 *
		 * @return array
		 */
		public static function get_responsive_block_pricing_list_default_attributes() {
			return array(
				'block_id'                   => '',
				'pricingList'                => '',
				'blockTopPadding'            => 5,
				'blockBottomPadding'         => 5,
				'blockLeftPadding'           => 5,
				'blockRightPadding'          => 5,
				'rowGap'                     => 10,
				'columnGap'                  => 10,
				'titleSpace'                 => 10,
				'blockTopPaddingMobile'      => 5,
				'blockBottomPaddingMobile'   => 5,
				'blockLeftPaddingMobile'     => 5,
				'blockRightPaddingMobile'    => 5,
				'rowGapMobile'               => 10,
				'columnGapMobile'            => 10,
				'titleSpaceMobile'           => 10,
				'blockTopPaddingTablet'      => 5,
				'blockBottomPaddingTablet'   => 5,
				'blockLeftPaddingTablet'     => 5,
				'blockRightPaddingTablet'    => 5,
				'rowGapTablet'               => 10,
				'columnGapTablet'            => 10,
				'titleSpaceTablet'           => 10,
				'titleFontFamily'            => '',
				'descriptionFontFamily'      => '',
				'priceFontFamily'            => '',
				'titleFontSize'              => '',
				'titleFontWeight'            => '',
				'titleLineHeight'            => '',
				'descriptionFontSize'        => '',
				'descriptionFontWeight'      => '',
				'descriptionLineHeight'      => '',
				'priceFontSize'              => '',
				'priceFontWeight'            => '',
				'priceLineHeight'            => '',
				'seperatorStyle'             => 'dashed',
				'seperatorWidth'             => 100,
				'seperatorThickness'         => 1,
				'seperatorColor'             => '',
				'titleColor'                 => '',
				'descColor'                  => '',
				'priceColor'                 => '',
				'columns'                    => 2,
				'count'                      => '',
				'contentAlign'               => 'left',
				'imagePosition'              => 'top',
				'imageAlignment'             => 'middle',
				'imageSize'                  => 'medium',
				'imageWidth'                 => '',
				'titleFontSizeMobile'        => '',
				'titleFontSizeTablet'        => '',
				'descriptionFontSizeMobile'  => '',
				'descriptionFontSizeTablet'  => '',
				'priceFontSizeMobile'        => '',
				'priceFontSizeTablet'        => '',
				'topPadding'                 => 999, // For compatibility with v1.3.2.
				'bottomPadding'              => 999, // For compatibility with v1.3.2.
				'leftPadding'                => 999, // For compatibility with v1.3.2.
				'rightPadding'               => 999, // For compatibility with v1.3.2.
				'hideWidget'                 => false,
				'hideWidgetMobile'           => false,
				'hideWidgetTablet'           => false,
				'z_index'                    => 1,
				'z_indexMobile'              => 1,
				'z_indexTablet'              => 1,
				'pricingTopPadding'          => '',
				'pricingTopPaddingMobile'    => '',
				'pricingTopPaddingTablet'    => '',
				'pricingBottomPadding'       => '',
				'pricingBottomPaddingMobile' => '',
				'pricingBottomPaddingTablet' => '',
				'pricingLeftPadding'         => '',
				'pricingLeftPaddingMobile'   => '',
				'pricingLeftPaddingTablet'   => '',
				'pricingRightPadding'        => '',
				'pricingRightPaddingMobile'  => '',
				'pricingRightPaddingTablet'  => '',
				'pricingTopMargin'           => '',
				'pricingTopMarginMobile'     => '',
				'pricingTopMarginTablet'     => '',
				'pricingBottomMargin'        => '',
				'pricingBottomMarginMobile'  => '',
				'pricingBottomMarginTablet'  => '',
				'pricingLeftMargin'          => '',
				'pricingLeftMarginMobile'    => '',
				'pricingLeftMarginTablet'    => '',
				'pricingRightMargin'         => '',
				'pricingRightMarginMobile'   => '',
				'pricingRightMarginTablet'   => '',
				'priceTypographyColor'       => '',
				'descriptionTypographyColor' => '',
				'titleTypographyColor'       => '',
				'titleBottomSpacing'         => 10,
				'titleBottomSpacingMobile'   => 10,
				'titleBottomSpacingTablet'   => 10,
				'titleTextTransform'         => '',
    			'titleFontStyle'             => '',
    			'descriptionTextTransform'   => '',
    			'descriptionFontStyle'       => '',
    			'priceTextTransform'         => '',
    			'priceFontStyle'             => '',
			);
		}

		/**
		 * Get Pricing table Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_pricing_table_css( $attr, $id ) {
			$defaults = self::get_responsive_block_pricing_table_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'titleTypographyColor'        => 'titleColor' ? 'titleColor' : '',
				'prefixTypographyColor'       => 'prefixColor' ? 'prefixColor' : '',
				'amountTypographyColor'       => 'priceColor' ? 'priceColor' : '',
				'suffixTypographyColor'       => 'suffixColor' ? 'suffixColor' : '',
				'subpriceTypographyColor'     => 'subpriceColor' ? 'subpriceColor' : '',
				'featuresTypographyColor'     => 'featuresColor' ? 'featuresColor' : '',
				'titleBottomSpacing'          => 'titleSpace' ? 'titleSpace' : '',
				'titleBottomSpacingMobile'    => 'titleSpaceMobile' ? 'titleSpaceMobile' : '',
				'titleBottomSpacingTablet'    => 'titleSpaceTablet' ? 'titleSpaceTablet' : '',
				'amountBottomSpacing'         => 'priceSpace' ? 'priceSpace' : '',
				'amountBottomSpacingMobile'   => 'priceSpaceMobile' ? 'priceSpaceMobile' : '',
				'amountBottomSpacingTablet'   => 'priceSpaceTablet' ? 'priceSpaceTablet' : '',
				'featuresBottomSpacing'       => 'featuresSpace' ? 'featuresSpace' : '',
				'featuresBottomSpacingMobile' => 'featuresSpaceMobile' ? 'featuresSpaceMobile' : '',
				'featuresBottomSpacingTablet' => 'featuresSpaceTablet' ? 'featuresSpaceTablet' : '',
				'subpriceBottomSpacing'       => 'subpriceSpace' ? 'subpriceSpace' : '',
				'subpriceBottomSpacingMobile' => 'subpriceSpaceMobile' ? 'subpriceSpaceMobile' : '',
				'subpriceBottomSpacingTablet' => 'subpriceSpaceTablet' ? 'subpriceSpaceTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_button_padding_keys = array(
				'ctaButtonTopPadding'          => 'ctaVpadding' ? 'ctaVpadding' : 15,
				'ctaButtonBottomPadding'       => 'ctaVpadding' ? 'ctaVpadding' : 15,
				'ctaButtonLeftPadding'         => 'ctaHpadding' ? 'ctaHpadding' : 30,
				'ctaButtonRightPadding'        => 'ctaHpadding' ? 'ctaHpadding' : 30,
				'ctaButtonTopPaddingTablet'    => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 15,
				'ctaButtonBottomPaddingTablet' => 'ctaVpaddingTablet' ? 'ctaVpaddingTablet' : 15,
				'ctaButtonRightPaddingTablet'  => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 30,
				'ctaButtonLeftPaddingTablet'   => 'ctaHpaddingTablet' ? 'ctaHpaddingTablet' : 30,
				'ctaButtonTopPaddingMobile'    => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 15,
				'ctaButtonBottomPaddingMobile' => 'ctaVpaddingMobile' ? 'ctaVpaddingMobile' : 15,
				'ctaButtonLeftPaddingMobile'   => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 30,
				'ctaButtonRightPaddingMobile'  => 'ctaHpaddingMobile' ? 'ctaHpaddingMobile' : 30,
			);

			// To populate new control values with existing padding margin control values for backward compatibility.
			foreach ( $new_button_padding_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];
			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$button_box_shadow_position_css = $attr['buttonBoxShadowPosition'];
			if ( 'outset' === $attr['buttonBoxShadowPosition'] ) {
				$button_box_shadow_position_css = '';
			}

			$imgopacity             = $attr['opacity'] / 100;
			$blockimgopacity        = $attr['blockopacity'] / 100;
			$blockbackcoloropacity  = $attr['blockBackColorOpacity'] / 100;
			$columnbackcoloropacity = $attr['columnBackColorOpacity'] / 100;

			$align_style = 'center';
			if ( 'left' === $attr['blockAlign'] ) {
				$align_style = 'flex-start';
			}
			if ( 'right' === $attr['blockAlign'] ) {
				$align_style = 'flex-end';
			}

			$updated_button_bg_h_image = '';
			if ( 'gradient' === $attr['buttonHbackgroundType'] ) {
				$updated_button_bg_h_image = 'linear-gradient(' . $attr['buttonHgradientDirection'] . 'deg, ' . $attr['buttonHbackgroundColor1'] . ' ' . $attr['buttonHcolorLocation1'] . '% , ' . $attr['buttonHbackgroundColor2'] . ' ' . $attr['buttonHcolorLocation2'] . '%)';
			}

			$updated_button_background_color = '';
			$updated_button_background_image = '';
			if ( 'color' === $attr['buttonbackgroundType'] ) {
				$updated_button_background_color = $attr['ctaBackColor'];
			} elseif ( 'gradient' === $attr['buttonbackgroundType'] ) {
				$updated_button_background_image = 'linear-gradient(' . $attr['buttongradientDirection'] . 'deg, ' . $attr['buttonbackgroundColor1'] . ' ' . $attr['buttoncolorLocation1'] . '%, ' . $attr['buttonbackgroundColor2'] . ' ' . $attr['buttoncolorLocation2'] . '%)';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$global_inherit_from_theme = get_option( 'rbea_global_inherit_from_theme');
			$rbea_global_inherit_from_theme_last_changed = get_option( 'rbea_global_inherit_from_theme_last_changed');
			$inheritFromThemeLocalTimestamp = isset($attr['inheritFromThemeLocalTimestamp']) ? $attr['inheritFromThemeLocalTimestamp'] : '';
			$flag = ($rbea_global_inherit_from_theme_last_changed && (!$inheritFromThemeLocalTimestamp || strtotime($rbea_global_inherit_from_theme_last_changed) > strtotime($inheritFromThemeLocalTimestamp))) || $attr['inheritFromTheme'];
			$flag = $flag && ($attr['inheritFromThemesaved'] || $global_inherit_from_theme);

			$selectors = array(
				' .wp-block-responsive-block-editor-addons-pricing-table-item__button' => array(
					'color'            => $flag ? '' : $attr['ctaColor'] . '!important',
					'display'          => 'block',
					'background-color' => $flag ? '' : $updated_button_background_color,
					'background-image' => $updated_button_background_image,
					'margin-left'      => 'left' === $attr['blockAlign'] ? 0 : '',
					'margin-right'     => 'right' === $attr['blockAlign'] ? 0 : '',
					'margin-bottom'    => self::get_css_value( $attr['buttonSpace'], 'px' ),
					'padding-left'     => $flag ? '' : self::get_css_value( $attr['ctaButtonLeftPadding'], 'px' ),
					'padding-right'    => $flag ? '' : self::get_css_value( $attr['ctaButtonRightPadding'], 'px' ),
					'padding-top'      => $flag ? '' : self::get_css_value( $attr['ctaButtonTopPadding'], 'px' ),
					'padding-bottom'   => $flag ? '' : self::get_css_value( $attr['ctaButtonBottomPadding'], 'px' ),
					'border-color'     => $flag ? '' : $attr['ctaBorderColor'],
					'border-radius'    => $flag ? '' : self::get_css_value( $attr['ctaBorderRadius'], 'px' ),
					'border-width'     => $flag ? '' : self::get_css_value( $attr['ctaBorderWidth'], 'px' ),
					'border-style'     => $flag ? '' : $attr['ctaBorderStyle'],
					'line-height'      => $attr['ctaLineHeight'],
					'font-weight'      => $flag ? 'Default' : $attr['ctaFontWeight'],
					'font-size'        => self::get_css_value( $attr['ctaFontSize'], 'px' ),
					'font-family'      => $flag ? '' : $attr['ctaFontFamily'],
					'box-shadow'       =>
						self::get_css_value( $attr['buttonBoxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['buttonBoxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['buttonBoxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['buttonBoxShadowSpread'], 'px' ) .
						' ' .
						$attr['buttonBoxShadowColor'] .
						' ' .
						$button_box_shadow_position_css,
					'text-transform'=> $attr['ctaTextTransform'],
					'font-style'    => $attr['ctaFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__button:hover' => array(
					'color'            => $flag ? '' : $attr['ctaHoverColor'] . '!important',
					'background-color' => $flag ? '' : ('color' === $attr['buttonHbackgroundType'] ? $attr['ctaHoverBackColor'] : ' '),
					'background-image' => 'color' === $attr['buttonHbackgroundType'] ? 'none' : $updated_button_bg_h_image,
					'border-color'     => $flag ? '' : $attr['ctaHoverBorderColor'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item.background-type-image' => array(
					'background-image'      => 'linear-gradient(' .
					self::hex_to_rgb( '#fff', 1 - $imgopacity ) .
					',' .
					self::hex_to_rgb( '#fff', 1 - $imgopacity ) .
					'),' .
					'url(' . $attr['backgroundImage'] . ')',
					'background-position'   => 'center center',
					'background-attachment' => 'scroll',
					'background-repeat'     => 'no-repeat',
					'background-size'       => 'cover',
				),

				'' => array(
					'display'          => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'         => 'relative',
					'z-index'          => $attr['z_index'],
					'text-align'       => $attr['blockAlign'],
					'padding-top'      => self::get_css_value( $attr['blockTopPadding'], 'px!important' ),
					'padding-bottom'   => self::get_css_value( $attr['blockBottomPadding'], 'px!important' ),
					'padding-left'     => self::get_css_value( $attr['blockLeftPadding'], 'px!important' ),
					'padding-right'    => self::get_css_value( $attr['blockRightPadding'], 'px!important' ),
					'margin-top'       => self::get_css_value( $attr['blockTopMargin'], 'px' ) . ' !important',
					'margin-right'     => self::get_css_value( $attr['blockRightMargin'], 'px' ) . ' !important',
					'margin-bottom'    => self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ' !important',
					'margin-left'      => self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ' !important',
					'background-color' => 'color' === $attr['blockbackgroundType'] ? self::hex_to_rgb( $attr['blockbackgroundColor'], 0 ) : '',
					'opacity'          => 'color' === $attr['blockbackgroundType'] ? $attr['blockBackColorOpacity'] : 100,
					'background-image' =>
						'gradient' === $attr['blockbackgroundType']
						? self::generate_background_image_effect(
							$attr['blockbackgroundColor1'],
							$attr['blockbackgroundColor2'],
							$attr['blockgradientDirection'],
							$attr['blockcolorLocation1'],
							$attr['blockcolorLocation2']
						)
						: null,
				),

				' .responsive-block-editor-addons-pricing-table-background-image' => array(
					'height'  => '100%',
					'opacity' => $blockimgopacity,
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item' => array(
					'padding-top'                => self::get_css_value( $attr['columnTopPadding'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['columnBottomPadding'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['columnLeftPadding'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['columnRightPadding'], 'px' ),
					'color'                      => $attr['textColor'],
					'background-color'           => $attr['itemBackgroundColor'],
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#eee', $columnbackcoloropacity )
						: '#eee',
					'background-image'           =>
						'gradient' === $attr['backgroundType']
						? self::generate_background_image_effect(
							self::hex_to_rgb(
								$attr['backgroundColor1'],
								$columnbackcoloropacity
							),
							self::hex_to_rgb(
								$attr['backgroundColor2'],
								$columnbackcoloropacity
							),
							$attr['gradientDirection'],
							$attr['colorLocation1'],
							$attr['colorLocation2']
						)
						: null,
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item:hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__title' => array(
					'color'         => $attr['titleTypographyColor'],
					'line-height'   => $attr['titleLineHeight'],
					'font-weight'   => $attr['titleFontWeight'],
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-family'   => $attr['titleFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
					'text-transform'=> $attr['titleTextTransform'],
					'font-style'    => $attr['titleFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__price-wrapper' => array(
					'margin-bottom'   => self::get_css_value( $attr['amountBottomSpacing'], 'px' ),
					'justify-content' => $align_style,
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__currency' => array(
					'color'       => $attr['prefixTypographyColor'],
					'line-height' => $attr['prefixLineHeight'],
					'font-weight' => $attr['prefixFontWeight'],
					'font-size'   => self::get_css_value( $attr['prefixFontSize'], 'px' ),
					'font-family' => $attr['prefixFontFamily'],
					'text-transform'=> $attr['prefixTextTransform'],
					'font-style'    => $attr['prefixFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__amount' => array(
					'color'       => $attr['amountTypographyColor'],
					'line-height' => $attr['amountLineHeight'],
					'font-weight' => $attr['amountFontWeight'],
					'font-size'   => self::get_css_value( $attr['amountFontSize'], 'px' ),
					'font-family' => $attr['amountFontFamily'],
					'text-transform'=> $attr['amountTextTransform'],
					'font-style'    => $attr['amountFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__price_suffix' => array(
					'color'       => $attr['suffixTypographyColor'],
					'line-height' => $attr['suffixLineHeight'],
					'font-weight' => $attr['suffixFontWeight'],
					'font-size'   => self::get_css_value( $attr['suffixFontSize'], 'px' ),
					'font-family' => $attr['suffixFontFamily'],
					'text-transform'=> $attr['suffixTextTransform'],
					'font-style'    => $attr['suffixFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__sub_price' => array(
					'color'          => $attr['subpriceTypographyColor'],
					'line-height'    => $attr['subpriceLineHeight'],
					'text-transform' => $attr['subpriceTextTransform'],
					'font-weight'    => $attr['subpriceFontWeight'],
					'font-size'      => self::get_css_value( $attr['subpriceFontSize'], 'px' ),
					'font-family'    => $attr['subpriceFontFamily'],
					'margin-bottom'  => self::get_css_value( $attr['subpriceBottomSpacing'], 'px' ),
					'text-transform'=> $attr['subpriceTextTransform'],
					'font-style'    => $attr['subpriceFontStyle'],
				),

				' .wp-block-responsive-block-editor-addons-pricing-table-item__features' => array(
					'color'         => $attr['featuresTypographyColor'],
					'line-height'   => $attr['featuresLineHeight'],
					'font-weight'   => $attr['featuresFontWeight'],
					'font-size'     => self::get_css_value( $attr['featuresFontSize'], 'px' ),
					'font-family'   => $attr['featuresFontFamily'],
					'margin-bottom' => self::get_css_value( $attr['featuresBottomSpacing'], 'px' ),
					'text-transform'=> $attr['featuresTextTransform'],
					'font-style'    => $attr['featuresFontStyle'],
				),
				' .responsive-block-editor-addons-pricing-image' => array(
					'width' => self::get_css_value( $attr['imageWidth'], 'px' ),
				),

			);

			$mobile_selectors = array(
				'' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . ' !important',
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . ' !important',
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . ' !important',
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . ' !important',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ' !important',
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ' !important',
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ' !important',
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ' !important',
					'z-index'        => $attr['z_indexMobile'],
				),
				' .wp-block-responsive-block-editor-addons-pricing-table__inner' => array(
					'flex-direction' => 'column',
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__price-wrapper' => array(
					'margin-bottom' => self::get_css_value( $attr['amountBottomSpacingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item' => array(
					'max-width'                  => 'none',
					'padding-top'                => self::get_css_value( $attr['columnTopPaddingMobile'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['columnBottomPaddingMobile'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['columnLeftPaddingMobile'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['columnRightPaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__currency' => array(
					'font-size' => self::get_css_value( $attr['prefixFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__amount' => array(
					'font-size' => self::get_css_value( $attr['amountFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__price_suffix' => array(
					'font-size' => self::get_css_value( $attr['suffixFontSizeMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__sub_price' => array(
					'font-size'     => self::get_css_value( $attr['subpriceFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['subpriceBottomSpacingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__features' => array(
					'font-size'     => self::get_css_value( $attr['featuresFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['featuresBottomSpacingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__button' => array(
					'padding-left'   => $flag ? '' : self::get_css_value( $attr['ctaButtonLeftPaddingMobile'], 'px' ),
					'padding-right'  => $flag ? '' : self::get_css_value( $attr['ctaButtonRightPaddingMobile'], 'px' ),
					'padding-top'    => $flag ? '' : self::get_css_value( $attr['ctaButtonTopPaddingMobile'], 'px' ),
					'padding-bottom' => $flag ? '' : self::get_css_value( $attr['ctaButtonBottomPaddingMobile'], 'px' ),
					'font-size'      => self::get_css_value( $attr['ctaFontSizeMobile'], 'px' ),
					'font-size'      => self::get_css_value( $attr['ctaFontSizeMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['buttonSpaceMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-pricing-image' => array(
					'width' => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				'' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . ' !important',
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . ' !important',
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . ' !important',
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . ' !important',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ' !important',
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ' !important',
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ' !important',
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ' !important',
					'z-index'        => $attr['z_indexTablet'],
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item' => array(
					'padding-top'                => self::get_css_value( $attr['columnTopPaddingTablet'], 'px' ),
					'padding-bottom'             => self::get_css_value( $attr['columnBottomPaddingTablet'], 'px' ),
					'padding-left'               => self::get_css_value( $attr['columnLeftPaddingTablet'], 'px' ),
					'padding-right'              => self::get_css_value( $attr['columnRightPaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__price-wrapper' => array(
					'margin-bottom' => self::get_css_value( $attr['amountBottomSpacingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__title' => array(
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__currency' => array(
					'font-size' => self::get_css_value( $attr['prefixFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__amount' => array(
					'font-size' => self::get_css_value( $attr['amountFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__price_suffix' => array(
					'font-size' => self::get_css_value( $attr['suffixFontSizeTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__sub_price' => array(
					'font-size'     => self::get_css_value( $attr['subpriceFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['subpriceBottomSpacingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__features' => array(
					'font-size'     => self::get_css_value( $attr['featuresFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['featuresBottomSpacingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-pricing-table-item__button' => array(
					'padding-left'   => $flag ? '' : self::get_css_value( $attr['ctaButtonLeftPaddingTablet'], 'px' ),
					'padding-right'  => $flag ? '' : self::get_css_value( $attr['ctaButtonRightPaddingTablet'], 'px' ),
					'padding-top'    => $flag ? '' : self::get_css_value( $attr['ctaButtonTopPaddingTablet'], 'px' ),
					'padding-bottom' => $flag ? '' : self::get_css_value( $attr['ctaButtonBottomPaddingTablet'], 'px' ),
					'font-size'      => self::get_css_value( $attr['ctaFontSizeTablet'], 'px' ),
					'font-size'      => self::get_css_value( $attr['ctaFontSizeTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['buttonSpaceTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-pricing-image' => array(
					'width' => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-pricing-table.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for pricing table block
		 *
		 * @return array
		 */
		public static function get_responsive_block_pricing_table_default_attributes() {
			return array(
				'block_id'                     => '',
				'pricingTable'                 => '',
				'blockId'                      => '',
				'count'                        => 2,
				'gutter'                       => 'medium',
				'contentAlign'                 => 'center',
				'textColor'                    => '',
				'titleColor'                   => '',
				'prefixColor'                  => '',
				'priceColor'                   => '',
				'suffixColor'                  => '',
				'subpriceColor'                => '',
				'featuresColor'                => '',
				'itemBackgroundColor'          => '',
				'blockBorderStyle'             => 'none',
				'blockBorderWidth'             => 1,
				'blockBorderRadius'            => 0,
				'blockBorderColor'             => '',
				'sectionTag'                   => 'section',
				'opacity'                      => 30,
				'blockBackColorOpacity'        => 100,
				'columnBackColorOpacity'       => 100,
				'colorLocation1'               => 0,
				'colorLocation2'               => 100,
				'gradientDirection'            => 90,
				'backgroundImage'              => '',
				'backgroundColor'              => '',
				'backgroundColor1'             => '',
				'backgroundColor2'             => '#fff',
				'backgroundType'               => 'none',
				'blockopacity'                 => '30',
				'blockcolorLocation1'          => 0,
				'blockcolorLocation2'          => 100,
				'blockgradientDirection'       => 90,
				'blockbackgroundImage'         => '',
				'blockbackgroundColor'         => '',
				'blockbackgroundColor1'        => '',
				'blockbackgroundColor2'        => '#fff',
				'blockbackgroundType'          => 'none',
				'boxShadowColor'               => '',
				'boxShadowHOffset'             => 0,
				'boxShadowVOffset'             => 0,
				'boxShadowBlur'                => 0,
				'boxShadowSpread'              => 0,
				'boxShadowPosition'            => 'outset',
				'hoverboxShadowColor'          => '',
				'hoverboxShadowHOffset'        => 0,
				'hoverboxShadowVOffset'        => 0,
				'hoverboxShadowBlur'           => 0,
				'hoverboxShadowSpread'         => 0,
				'hoverboxShadowPosition'       => 'outset',
				'buttonBoxShadowColor'         => '',
				'buttonBoxShadowHOffset'       => 0,
				'buttonBoxShadowVOffset'       => 0,
				'buttonBoxShadowBlur'          => 0,
				'buttonBoxShadowSpread'        => 0,
				'buttonBoxShadowPosition'      => 'outset',
				'ctaColor'                     => '#ffffff',
				'ctaBackColor'                 => '#3f46ae',
				'ctaHoverColor'                => '#ffffff',
				'ctaHoverBackColor'            => '#3f46ae',
				'ctaBorderColor'               => '#333',
				'ctaBorderStyle'               => 'none',
				'ctaBorderRadius'              => 0,
				'ctaBorderWidth'               => 2,
				'ctaHpadding'                  => 30,
				'ctaVpadding'                  => 15,
				'buttonbackgroundType'         => 'color',
				'buttoncolorLocation1'         => 0,
				'buttoncolorLocation2'         => 100,
				'buttongradientDirection'      => 90,
				'buttonbackgroundColor1'       => '',
				'buttonbackgroundColor2'       => '#fff',
				'buttonHbackgroundType'        => 'color',
				'buttonHcolorLocation1'        => 0,
				'buttonHcolorLocation2'        => 100,
				'buttonHgradientDirection'     => 90,
				'buttonHbackgroundColor1'      => '',
				'buttonHbackgroundColor2'      => '#fff',
				'titleFontFamily'              => '',
				'amountFontFamily'             => '',
				'prefixFontFamily'             => '',
				'suffixFontFamily'             => '',
				'subpriceFontFamily'           => '',
				'featuresFontFamily'           => '',
				'ctaFontFamily'                => '',
				'titleFontSize'                => '',
				'titleFontWeight'              => '',
				'titleLineHeight'              => '',
				'amountFontSize'               => '',
				'amountFontWeight'             => '',
				'amountLineHeight'             => '',
				'subpriceFontSize'             => '',
				'subpriceFontWeight'           => '',
				'subpriceLineHeight'           => '',
				'subpriceTextTransform'        => 'uppercase',
				'prefixFontSize'               => '',
				'prefixFontWeight'             => '',
				'prefixLineHeight'             => '',
				'suffixFontSize'               => '',
				'suffixFontWeight'             => '',
				'suffixLineHeight'             => '',
				'featuresFontSize'             => '',
				'featuresFontWeight'           => '',
				'featuresLineHeight'           => '',
				'ctaFontSize'                  => '',
				'ctaFontWeight'                => '',
				'ctaLineHeight'                => '',
				'blockTopPadding'              => '',
				'blockBottomPadding'           => '',
				'blockLeftPadding'             => '',
				'blockRightPadding'            => '',
				'columnTopPadding'             => 64,
				'columnBottomPadding'          => 64,
				'columnLeftPadding'            => 24,
				'columnRightPadding'           => 24,
				'blockTopPaddingMobile'        => '',
				'blockBottomPaddingMobile'     => '',
				'blockLeftPaddingMobile'       => '',
				'blockRightPaddingMobile'      => '',
				'columnTopPaddingMobile'       => '',
				'columnBottomPaddingMobile'    => '',
				'columnLeftPaddingMobile'      => '',
				'columnRightPaddingMobile'     => '',
				'blockTopPaddingTablet'        => '',
				'blockBottomPaddingTablet'     => '',
				'blockLeftPaddingTablet'       => '',
				'blockRightPaddingTablet'      => '',
				'columnTopPaddingTablet'       => '',
				'columnBottomPaddingTablet'    => '',
				'columnLeftPaddingTablet'      => '',
				'columnRightPaddingTablet'     => '',
				'showImage'                    => true,
				'showTitle'                    => true,
				'showPrefix'                   => true,
				'showPrice'                    => true,
				'showSuffix'                   => true,
				'showSubprice'                 => true,
				'showFeatures'                 => true,
				'showButton'                   => true,
				'buttonTarget'                 => false,
				'titleSpace'                   => '',
				'priceSpace'                   => '',
				'subpriceSpace'                => 0,
				'buttonSpace'                  => '',
				'featuresSpace'                => '',
				'titleSpaceMobile'             => '',
				'priceSpaceMobile'             => '',
				'subpriceSpaceMobile'          => '',
				'buttonSpaceMobile'            => '',
				'featuresSpaceMobile'          => '',
				'titleSpaceTablet'             => '',
				'priceSpaceTablet'             => '',
				'subpriceSpaceTablet'          => '',
				'buttonSpaceTablet'            => '',
				'featuresSpaceTablet'          => '',
				'blockAlign'                   => 'center',
				'imageWidth'                   => '',
				'imageWidthTablet'             => '',
				'imageWidthMobile'             => '',
				'imageSize'                    => 'full',
				'imageShape'                   => '',
				'ctaHoverBorderColor'          => '#333',
				'ctaHpaddingTablet'            => '',
				'ctaHpaddingMobile'            => '',
				'ctaVpaddingTablet'            => '',
				'ctaVpaddingMobile'            => '',
				'titleFontSizeMobile'          => '',
				'titleFontSizeTablet'          => '',
				'prefixFontSizeMobile'         => '',
				'prefixFontSizeTablet'         => '',
				'amountFontSizeMobile'         => '',
				'amountFontSizeTablet'         => '',
				'suffixFontSizeMobile'         => '',
				'suffixFontSizeTablet'         => '',
				'subpriceFontSizeMobile'       => '',
				'subpriceFontSizeTablet'       => '',
				'featuresFontSizeMobile'       => '',
				'featuresFontSizeTablet'       => '',
				'ctaFontSizeMobile'            => '',
				'ctaFontSizeTablet'            => '',
				'hideWidget'                   => false,
				'hideWidgetMobile'             => false,
				'hideWidgetTablet'             => false,
				'z_index'                      => 1,
				'z_indexTablet'                => 1,
				'z_indexMobile'                => 1,
				'blockTopMargin'               => '',
				'blockTopMarginMobile'         => '',
				'blockTopMarginTablet'         => '',
				'blockBottomMargin'            => '',
				'blockBottomMarginMobile'      => '',
				'blockBottomMarginTablet'      => '',
				'blockLeftMargin'              => '',
				'blockLeftMarginMobile'        => '',
				'blockLeftMarginTablet'        => '',
				'blockRightMargin'             => '',
				'blockRightMarginMobile'       => '',
				'blockRightMarginTablet'       => '',
				'blockTopRadiusMobile'         => 0,
				'blockRightRadiusMobile'       => 0,
				'blockBottomRadiusMobile'      => 0,
				'blockLeftRadiusMobile'        => 0,
				'blockTopRadiusTablet'         => 0,
				'blockRightRadiusTablet'       => 0,
				'blockBottomRadiusTablet'      => 0,
				'blockLeftRadiusTablet'        => 0,
				'blockTopRadius'               => 0,
				'blockRightRadius'             => 0,
				'blockBottomRadius'            => 0,
				'blockLeftRadius'              => 0,
				'titleTypographyColor'         => '',
				'prefixTypographyColor'        => '',
				'amountTypographyColor'        => '',
				'suffixTypographyColor'        => '',
				'subpriceTypographyColor'      => '',
				'featuresTypographyColor'      => '',
				'titleBottomSpacing'           => '',
				'titleBottomSpacingMobile'     => '',
				'titleBottomSpacingTablet'     => '',
				'amountBottomSpacing'          => '',
				'amountBottomSpacingMobile'    => '',
				'amountBottomSpacingTablet'    => '',
				'featuresBottomSpacing'        => '',
				'featuresBottomSpacingMobile'  => '',
				'featuresBottomSpacingTablet'  => '',
				'subpriceBottomSpacing'        => '',
				'subpriceBottomSpacingMobile'  => '',
				'subpriceBottomSpacingTablet'  => '',

				'ctaButtonTopPadding'          => 15,
				'ctaButtonBottomPadding'       => 15,
				'ctaButtonLeftPadding'         => 30,
				'ctaButtonRightPadding'        => 30,
				'ctaButtonTopPaddingTablet'    => 15,
				'ctaButtonBottomPaddingTablet' => 15,
				'ctaButtonRightPaddingTablet'  => 30,
				'ctaButtonLeftPaddingTablet'   => 30,
				'ctaButtonTopPaddingMobile'    => 15,
				'ctaButtonBottomPaddingMobile' => 15,
				'ctaButtonLeftPaddingMobile'   => 30,
				'ctaButtonRightPaddingMobile'  => 30,
				'titleTextTransform'           => '',
        		'titleFontStyle'               => '',
        		'prefixTextTransform'          => '',
        		'prefixFontStyle'              => '',
        		'amountTextTransform'          => '',
        		'amountFontStyle'              => '',
        		'suffixTextTransform'          => '',
        		'suffixFontStyle'              => '',
        		'subpriceFontStyle'            => '',
        		'featuresTextTransform'        => '',
        		'featuresFontStyle'            => '',
        		'ctaTextTransform'             => '',
        		'ctaFontStyle'                 => '',
				'inheritFromThemesaved'	   => false,
				'inheritFromTheme'		   => false,
			);
		}

		/**
		 * Get Defaults for section block
		 *
		 * @return array
		 */
		public static function get_responsive_block_section_default_attributes() {
			return array(
				'block_id'                 => '',
				'blockId'                  => '',
				'align'                    => '',
				'width'                    => 900,
				'innerWidth'               => 1140,
				'innerWidthTablet'         => 1140,
				'innerWidthMobile'         => 1140,
				'innerWidthType'           => 'px',
				'themeWidth'               => false,
				'blockTopPadding'          => 10,
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => 10,
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => 10,
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => 10,
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockBottomMargin'        => '',
				'blockLeftMargin'          => '',
				'blockRightMargin'         => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMarginTablet'   => '',
				'blockTopMarginMobile'     => '',
				'blockBottomMarginMobile'  => '',
				'blockLeftMarginMobile'    => '',
				'blockRightMarginMobile'   => '',
				'blockBorderStyle'         => 'none',
				'blockBorderWidth'         => 1,
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
				'blockBorderColor'         => '#000',
				'sectionTag'               => 'section',
				'opacity'                  => 20,
				'colorLocation1'           => 0,
				'colorLocation2'           => 100,
				'gradientDirection'        => 90,
				'backgroundImage'          => '',
				'backgroundPosition'       => 'center center',
				'backgroundPositionTablet' => 'center center',
				'backgroundPositionMobile' => 'center center',
				'backgroundPositionFocal'  => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundSize'           => 'cover',
				'backgroundSizeTablet'     => 'cover',
				'backgroundSizeMobile'     => 'cover',
				'backgroundRepeat'         => 'no-repeat',
				'backgroundAttachment'     => 'scroll',
				'backgroundImageColor'     => '#fff',
				'overlayType'              => 'color',
				'gradientOverlayColor1'    => '#fff',
				'gradientOverlayColor2'    => '#fff',
				'gradientOverlayType'      => 'linear',
				'gradientOverlayLocation1' => 0,
				'gradientOverlayLocation2' => 100,
				'gradientOverlayAngle'     => 0,
				'gradientOverlayPosition'  => 'center center',
				'backgroundVideo'          => '',
				'backgroundColor'          => '#fff',
				'backgroundColor1'         => '#fff',
				'backgroundColor2'         => '#fff',
				'backgroundType'           => 'none',
				'boxShadowColor'           => '#fff',
				'boxShadowHOffset'         => 0,
				'boxShadowVOffset'         => 0,
				'boxShadowBlur'            => 0,
				'boxShadowSpread'          => 0,
				'boxShadowPosition'        => 'outset',
				'hoverboxShadowColor'      => '',
				'hoverboxShadowHOffset'    => 0,
				'hoverboxShadowVOffset'    => 0,
				'hoverboxShadowBlur'       => 0,
				'hoverboxShadowSpread'     => 0,
				'hoverboxShadowPosition'   => 'outset',
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'topMargin'                => 999, // For compatibility with v1.3.2.
				'bottomMargin'             => 999, // For compatibility with v1.3.2.
				'leftMargin'               => 999, // For compatibility with v1.3.2.
				'rightMargin'              => 999, // For compatibility with v1.3.2.
				'topPadding'               => 999, // For compatibility with v1.3.2.
				'bottomPadding'            => 999, // For compatibility with v1.3.2.
				'leftPadding'              => 999, // For compatibility with v1.3.2.
				'rightPadding'             => 999, // For compatibility with v1.3.2.
				'topMarginMobile'          => 999, // For compatibility with v1.3.2.
				'bottomMarginMobile'       => 999, // For compatibility with v1.3.2.
				'leftMarginMobile'         => 999, // For compatibility with v1.3.2.
				'rightMarginMobile'        => 999, // For compatibility with v1.3.2.
				'topPaddingMobile'         => 999, // For compatibility with v1.3.2.
				'bottomPaddingMobile'      => 999, // For compatibility with v1.3.2.
				'leftPaddingMobile'        => 999, // For compatibility with v1.3.2.
				'rightPaddingMobile'       => 999, // For compatibility with v1.3.2.
				'topMarginTablet'          => 999, // For compatibility with v1.3.2.
				'bottomMarginTablet'       => 999, // For compatibility with v1.3.2.
				'leftMarginTablet'         => 999, // For compatibility with v1.3.2.
				'rightMarginTablet'        => 999, // For compatibility with v1.3.2.
				'topPaddingTablet'         => 999, // For compatibility with v1.3.2.
				'bottomPaddingTablet'      => 999, // For compatibility with v1.3.2.
				'leftPaddingTablet'        => 999, // For compatibility with v1.3.2.
				'rightPaddingTablet'       => 999, // For compatibility with v1.3.2.
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
			);
		}

		/**
		 * Get Shape divider Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_shape_divider_css( $attr, $id ) {
			$defaults = self::get_responsive_block_shape_divider_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$updated_background_color = null;
			if ( 'color' === $attr['backgroundType'] && null !== $attr['backgroundColor'] ) {
				$updated_background_color = $attr['backgroundColor'];
			}

			$updated_background_image = null;
			if ( 'gradient' === $attr['backgroundType'] ) {
				$updated_background_image = self::generate_background_image_effect( $attr['backgroundColor1'], $attr['backgroundColor2'], $attr['gradientDirection'], $attr['colorLocation1'], $attr['colorLocation2'] );
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				'' => array(
					'display'          => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'background-color' => $updated_background_color,
					'background-image' => $updated_background_image,
					'color'            => $attr['customColor'],
					'position'         => 'relative',
					'z-index'          => $attr['z_index'],
					'padding-top'      => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'    => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom'   => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'     => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'       => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'     => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'    => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'      => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-shape-divider__svg-wrapper' => array(
					'min-height' => self::get_css_value( $attr['shapeHeight'], 'px' ),
				),

				' .wp-block-responsive-block-editor-addons-shape-divider__alt-wrapper' => array(
					'min-height' => self::get_css_value( $attr['backgroundHeight'], 'px' ),
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-shape-divider__svg-wrapper' => array(
					'min-height' => $attr['shapeHeightMobile'] ? self::get_css_value( $attr['shapeHeightMobile'], 'px' ) : self::get_css_value( $attr['shapeHeight'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-shape-divider__alt-wrapper' => array(
					'min-height' => $attr['backgroundHeightMobile'] ? self::get_css_value( $attr['backgroundHeightMobile'], 'px' ) : self::get_css_value( $attr['backgroundHeight'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-shape-divider__svg-wrapper' => array(
					'min-height' => $attr['shapeHeightTablet'] ? self::get_css_value( $attr['shapeHeightTablet'], 'px' ) : self::get_css_value( $attr['shapeHeight'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-shape-divider__alt-wrapper' => array(
					'min-height' => $attr['backgroundHeightTablet'] ? self::get_css_value( $attr['backgroundHeightTablet'], 'px' ) : self::get_css_value( $attr['backgroundHeight'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-shape-divider.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for shape divider block
		 *
		 * @return array
		 */
		public static function get_responsive_block_shape_divider_default_attributes() {
			return array(
				'block_id'                 => '',
				'align'                    => 'full',
				'height'                   => 100,
				'heightTablet'             => '',
				'heightMobile'             => '',
				'shapeHeight'              => 100,
				'shapeHeightTablet'        => 0,
				'shapeHeightMobile'        => 0,
				'backgroundHeight'         => 50,
				'backgroundHeightTablet'   => '',
				'backgroundHeightMobile'   => '',
				'syncHeight'               => true,
				'syncHeightAlt'            => true,
				'verticalFlip'             => false,
				'horizontalFlip'           => false,
				'color'                    => '',
				'customColor'              => '',
				'backgroundColor'          => '#fff',
				'customBackgroundColor'    => '#fff',
				'noBottomMargin'           => true,
				'noTopMargin'              => true,
				'justAdded'                => true,
				'colorLocation1'           => 0,
				'colorLocation2'           => 100,
				'gradientDirection'        => 90,
				'backgroundColor1'         => '#fff',
				'backgroundColor2'         => '#fff',
				'backgroundType'           => 'none',
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexTablet'            => 1,
				'z_indexMobile'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
			);
		}

		/**
		 * Get Spacer Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_spacer_css( $attr, $id ) {
			$defaults = self::get_responsive_block_spacer_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                      => array(
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
				),
				'.responsive-block-editor-addons-spacer' => array(
					'height' => self::get_css_value( $attr['height'], 'px' ),
					'margin' => '0px',
				),
			);

			$mobile_selectors = array(
				' '                                      => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
				),
				'.responsive-block-editor-addons-spacer' => array(
					'height' => self::get_css_value( $attr['heightMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                                      => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
				),
				'.responsive-block-editor-addons-spacer' => array(
					'height' => self::get_css_value( $attr['heightTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-spacer.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for spacer block
		 *
		 * @return array
		 */
		public static function get_responsive_block_spacer_default_attributes() {
			return array(
				'block_id'         => '',
				'height'           => 100,
				'heightTablet'     => '',
				'heightMobile'     => '',
				'hideWidget'       => false,
				'hideWidgetMobile' => false,
				'hideWidgetTablet' => false,
				'z_index'          => 1,
				'z_indexMobile'    => 1,
				'z_indexTablet'    => 1,
			);
		}

		/**
		 * Get Team Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_team_css( $attr, $id ) {
			$defaults = self::get_responsive_block_team_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			// Frontend Backward Compatibility For Border Radius
			$new_border_radius_keys = array(
				'blockTopRadius'          => 'borderRadius',
				'blockRightRadius'        => 'borderRadius',
				'blockBottomRadius'       => 'borderRadius',
				'blockLeftRadius'         => 'borderRadius',
				'blockTopRadiusTablet'    => 'borderRadius',
				'blockRightRadiusTablet'  => 'borderRadius',
				'blockBottomRadiusTablet' => 'borderRadius',
				'blockLeftRadiusTablet'   => 'borderRadius',
				'blockTopRadiusMobile'    => 'borderRadius',
				'blockRightRadiusMobile'  => 'borderRadius',
				'blockBottomRadiusMobile' => 'borderRadius',
				'blockLeftRadiusMobile'   => 'borderRadius',
				'iconTopRadius'           => 'iconBorderRadius',
				'iconRightRadius'         => 'iconBorderRadius',
				'iconBottomRadius'        => 'iconBorderRadius',
				'iconLeftRadius'          => 'iconBorderRadius',
				'iconTopRadiusTablet'     => 'iconBorderRadius',
				'iconRightRadiusTablet'   => 'iconBorderRadius',
				'iconBottomRadiusTablet'  => 'iconBorderRadius',
				'iconLeftRadiusTablet'    => 'iconBorderRadius',
				'iconTopRadiusMobile'     => 'iconBorderRadius',
				'iconRightRadiusMobile'   => 'iconBorderRadius',
				'iconBottomRadiusMobile'  => 'iconBorderRadius',
				'iconLeftRadiusMobile'    => 'iconBorderRadius',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Frontend Backward Compatibility For Border Radius
			$new_border_radius_keys = array(
				'titleTypographyColor'           => 'titleColor' ? 'titleColor' : '',
				'descriptionTypographyColor'     => 'descriptionColor' ? 'descriptionColor' : '',
				'designationTypographyColor'     => 'designationColor' ? 'designationColor' : '',
				'designationBottomSpacing'       => 'designationSpacing' ? 'designationSpacing' : '',
				'designationBottomSpacingMobile' => 'designationSpacingMobile' ? 'designationSpacingMobile' : '',
				'designationBottomSpacingTablet' => 'designationSpacingTablet' ? 'designationSpacingTablet' : '',
				'descriptionBottomSpacing'       => 'descriptionSpacing' ? 'descriptionSpacing' : '',
				'descriptionBottomSpacingMobile' => 'descriptionSpacingMobile' ? 'descriptionSpacingMobile' : '',
				'descriptionBottomSpacingTablet' => 'descriptionSpacingTablet' ? 'descriptionSpacingTablet' : '',
				'titleBottomSpacing'             => 'titleSpacing' ? 'titleSpacing' : '',
				'titleBottomSpacingMobile'       => 'titleSpacingMobile' ? 'titleSpacingMobile' : '',
				'titleBottomSpacingTablet'       => 'titleSpacingTablet' ? 'titleSpacingTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$background_keys = array(
				'backgroundRepeat'         => 'backgroundImageRepeat' ? 'backgroundImageRepeat' : 'backgroundRepeat',
				'backgroundPosition'       => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPosition',
				'backgroundPositionMobile' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionMobile',
				'backgroundPositionTablet' => 'backgroundImagePosition' ? 'backgroundImagePosition' : 'backgroundPositionTablet',
				'backgroundSize'           => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSize',
				'backgroundSizeMobile'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeMobile',
				'backgroundSizeTablet'     => 'backgroundImageSize' ? 'backgroundImageSize' : 'backgroundSizeTablet',
			);

			// To populate new control values with existing background control values for backward compatibility.
			foreach ( $background_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$gutter_margin = '';
			if ( $attr['count'] > 1 ) {
				if ( 'small' === $attr['gutter'] ) {
					$gutter_margin = '20px';
				} elseif ( 'medium' === $attr['gutter'] ) {
					$gutter_margin = '30px';
				} elseif ( 'large' === $attr['gutter'] ) {
					$gutter_margin = '40px';
				} elseif ( 'huge' === $attr['gutter'] ) {
					$gutter_margin = '50px';
				} else {
					$gutter_margin = '';
				}
			}

			$imgopacity = $attr['opacity'] / 100;

			$background_image_effect  = '';
			$updated_background_image = '';

			$color_type = '';
			if ( 'color' === $attr['overlayType'] || '' === $attr['overlayType'] || 'none' === $attr['overlayType'] ) {
				$color_type = self::hex_to_rgba(
					$attr['backgroundImageColor'] || '#fff',
					$imgopacity || 0
				);

				if ( $attr['backgroundImage'] ) {
					$updated_background_image = 'linear-gradient(' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					',' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					'),url(' .
					$attr['backgroundImage'] .
					')';
				}
				$background_image_effect = '';
			} else {
				if ( 'linear' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'linear-gradient(' .
					$attr['gradientOverlayAngle'] .
					'deg,' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';

				}
				if ( 'radial' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'radial-gradient(' .
					'at ' . $attr['gradientOverlayPosition'] . ', ' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'], $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'], $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-team-avatar-wrapper' => array(
					'text-align' => $attr['alignment'],
					'text-align' => '-webkit-' . $attr['alignment'],
				),

				' .responsive-block-editor-addons-team-avatar' => array(
					'width'         => self::get_css_value( $attr['imageWidth'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['imageMarginTop'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['imageMarginBottom'], 'px' ),
					'text-align'    => 'justify',
				),

				' .responsive-block-editor-addons-team-name' => array(
					'color'         => $attr['titleTypographyColor'],
					'font-family'   => $attr['titleFontFamily'],
					'font-size'     => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-weight'   => $attr['titleFontWeight'],
					'line-height'   => $attr['titleLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
					'text-transform'=> $attr['titleTextTransform'],
					'font-style'    => $attr['titleFontStyle'],
				),

				' .responsive-block-editor-addons-team-designation' => array(
					'color'         => $attr['designationTypographyColor'],
					'font-family'   => $attr['designationFontFamily'],
					'font-size'     => self::get_css_value( $attr['designationFontSize'], 'px' ),
					'font-weight'   => $attr['designationFontWeight'],
					'line-height'   => $attr['designationLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['designationBottomSpacing'], 'px' ),
					'text-transform'=> $attr['designationTextTransform'],
					'font-style'    => $attr['designationFontStyle'],
				),

				' .responsive-block-editor-addons-team-description' => array(
					'color'         => $attr['descriptionTypographyColor'],
					'font-family'   => $attr['descriptionFontFamily'],
					'font-size'     => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'   => $attr['descriptionFontWeight'],
					'line-height'   => $attr['descriptionLineHeight'],
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacing'], 'px' ),
					'text-transform'=> $attr['descriptionTextTransform'],
					'font-style'    => $attr['descriptionFontStyle'],
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons' => array(
					'display' => 'inline-block',
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-twitter' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-facebook' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-linkedin' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-instagram' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-email' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-youtube' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons .dashicons.dashicons-pinterest' => array(
					'color'           => $attr['socialIconColor'],
					'font-size'       => self::get_css_value( $attr['iconSize'], 'px' ),
					'text-decoration' => 'none',
					'height'          => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'           => self::get_css_value( $attr['iconSize'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons a' => array(
					'line-height'                => '1',
					'margin-left'                => self::get_css_value( $attr['socialIconSpacing'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['socialIconSpacing'], 'px' ),
					'padding'                    => self::get_css_value( $attr['iconBackgroundSize'], 'px' ),
					'background-color'           => $attr['socialIconBackgroundColor'],
					'border-width'               => self::get_css_value( $attr['iconBorderSize'], 'px' ),
					'border-style'               => 'solid',
					'border-color'               => $attr['socialIconBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadius'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons li:hover a' => array(
					'background-color' => $attr['socialIconBackgroundHoverColor'],
					'border-width'     => self::get_css_value( $attr['iconBorderSize'], 'px' ),
					'border-style'     => 'solid',
					'border-color'     => $attr['socialIconBorderHoverColor'],
				),

				' .responsive-block-editor-addons-team-social-icons li:hover .dashicons' => array(
					'color' => $attr['socialIconHoverColor'] . '!important',
				),

				' .wp-block-responsive-block-editor-addons-team' => array(
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity ? $imgopacity : 0 )
						: '',
					'background-image'           =>
						'image' === $attr['backgroundType'] && 'gradient' === $attr['overlayType']
						? $background_image_effect
						: (
							'gradient' === $attr['backgroundType']
							? self::generate_background_image_effect(
								self::hex_to_rgb( $attr['backgroundColor1'] ? $attr['backgroundColor1'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								self::hex_to_rgb( $attr['backgroundColor2'] ? $attr['backgroundColor2'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								$attr['gradientDirection'],
								$attr['colorLocation1'],
								$attr['colorLocation2']
							)
							: ( 'image' === $attr['backgroundType'] ? $updated_background_image : '' )
						),
					'background-size'            => $attr['backgroundSize'],
					'background-repeat'          => $attr['backgroundRepeat'],
					'background-position'        => $background_position_focal,
					'background-attachment'      => $attr['backgroundAttachment'],
					'border-width'               => self::get_css_value( $attr['borderWidth'], 'px' ),
					'border-color'               => $attr['borderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'padding'                    => self::get_css_value( $attr['padding'], 'px' ),
					'text-align'                 => $attr['alignment'],
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
				),
				' .wp-block-responsive-block-editor-addons-team:hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hover_box_shadow_position_css : '',
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'flex',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-team' => array(
					'background-size'            => $attr['backgroundSizeMobile'],
					'background-position'        => $background_position_focal_mobile,
					'margin-bottom'              => $gutter_margin,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-team-avatar' => array(
					'width'         => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'max-width'     => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['imageMarginTopMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['imageMarginBottomMobile'], 'px' ),
				),
				'.has-columns.has-responsive-columns.responsive-team-block-columns__stack-mobile > *:not(.block-editor-inner-blocks)' => array(
					'max-width' => '100%',
					'min-width' => '100%',
				),
				' .responsive-block-editor-addons-team-name' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
				),

				' .responsive-block-editor-addons-team-designation' => array(
					'margin-bottom' => self::get_css_value( $attr['designationBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['designationFontSizeMobile'], 'px' ),
				),

				' .responsive-block-editor-addons-team-description' => array(
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacingMobile'], 'px' ),
					'font-size'     => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons a' => array(
					'margin-left'                => self::get_css_value( $attr['socialIconSpacingMobile'], 'px' ),
					'margin-right'               => self::get_css_value( $attr['socialIconSpacingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'flex',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-team' => array(
					'background-size'            => $attr['backgroundSizeTablet'],
					'background-position'        => $background_position_focal_tablet,
					'margin-bottom'              => $gutter_margin,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-team-avatar' => array(
					'width'         => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'max-width'     => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'margin-top'    => self::get_css_value( $attr['imageMarginTopTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['imageMarginBottomTablet'], 'px' ),
				),
				'.has-columns.has-responsive-columns.responsive-team-block-columns__stack-tablet > *:not(.block-editor-inner-blocks)' => array(
					'max-width' => '100%',
					'min-width' => '100%',
				),

				' .responsive-block-editor-addons-team-name' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
				),

				' .responsive-block-editor-addons-team-designation' => array(
					'margin-bottom' => self::get_css_value( $attr['designationBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['designationFontSizeTablet'], 'px' ),
				),

				' .responsive-block-editor-addons-team-description' => array(
					'margin-bottom' => self::get_css_value( $attr['descriptionBottomSpacingTablet'], 'px' ),
					'font-size'     => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),

				' .responsive-block-editor-addons-team-social-icons a' => array(
					'margin-left'                => self::get_css_value( $attr['socialIconSpacingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['iconTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['iconRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['iconBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['iconLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.wp-block-responsive-block-editor-addons-team-wrapper.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for team block
		 *
		 * @return array
		 */
		public static function get_responsive_block_team_default_attributes() {
			return array(
				'block_id'                       => '',
				'teamBlock'                      => 'teamBlock',
				'teamImgURL'                     => '',
				'counterId'                      => '1',
				'count'                          => 2,
				'gutter'                         => 'medium',
				'designationColor'               => '',
				'descriptionColor'               => '',
				'socialIconColor'                => '#0066CC',
				'titleColor'                     => '',
				'titleFontWeight'                => '',
				'designationFontWeight'          => '',
				'descriptionFontWeight'          => '',
				'titleLineHeight'                => '',
				'designationLineHeight'          => '',
				'descriptionLineHeight'          => '',
				'imageSize'                      => 'full',
				'titleFontFamily'                => '',
				'designationFontFamily'          => '',
				'descriptionFontFamily'          => '',
				'titleFontSize'                  => 23,
				'designationFontSize'            => 15,
				'descriptionFontSize'            => 15,
				'socialIconFontSize'             => 23,
				'imageMarginTop'                 => '',
				'imageMarginBottom'              => '',
				'imageMarginTopMobile'           => '',
				'imageMarginBottomMobile'        => '',
				'imageMarginTopTablet'           => '',
				'imageMarginBottomTablet'        => '',
				'iconSize'                       => '',
				'titleSpacing'                   => '',
				'designationSpacing'             => '',
				'descriptionSpacing'             => '',
				'socialIconSpacing'              => '',
				'titleSpacingMobile'             => '',
				'designationSpacingMobile'       => '',
				'descriptionSpacingMobile'       => '',
				'socialIconSpacingMobile'        => '',
				'titleSpacingTablet'             => '',
				'designationSpacingTablet'       => '',
				'descriptionSpacingTablet'       => '',
				'socialIconSpacingTablet'        => '',
				'imageStyle'                     => '0%',
				'imageWidth'                     => 120,
				'imageWidthMobile'               => 120,
				'imageWidthTablet'               => 120,
				'backgroundColor'                => '',
				'borderColor'                    => '',
				'borderWidth'                    => 2,
				'borderRadius'                   => 2,
				'blockTopRadiusMobile'           => '',
				'blockRightRadiusMobile'         => '',
				'blockBottomRadiusMobile'        => '',
				'blockLeftRadiusMobile'          => '',
				'blockTopRadiusTablet'           => '',
				'blockRightRadiusTablet'         => '',
				'blockBottomRadiusTablet'        => '',
				'blockLeftRadiusTablet'          => '',
				'blockTopRadius'                 => '',
				'blockRightRadius'               => '',
				'blockBottomRadius'              => '',
				'blockLeftRadius'                => '',
				'padding'                        => 2,
				'alignment'                      => 'center',
				'imageShape'                     => '',
				'boxShadowColor'                 => '',
				'boxShadowHOffset'               => 0,
				'boxShadowVOffset'               => 0,
				'boxShadowBlur'                  => 0,
				'boxShadowSpread'                => 0,
				'boxShadowPosition'              => 'outset',
				'hoverboxShadowColor'            => '',
				'hoverboxShadowHOffset'          => 0,
				'hoverboxShadowVOffset'          => 0,
				'hoverboxShadowBlur'             => 0,
				'hoverboxShadowSpread'           => 0,
				'hoverboxShadowPosition'         => 'outset',
				'opacity'                        => 50,
				'backgroundColor2'               => '',
				'gradientDirection'              => 90,
				'colorLocation1'                 => 0,
				'colorLocation2'                 => 100,
				'bgGradient'                     => '',
				'backgroundImage'                => '',
				'backgroundImagePosition'        => 'center center',
				'backgroundImageRepeat'          => 'no-repeat',
				'backgroundImageSize'            => 'cover',
				'backgroundAttachment'           => 'scroll',
				'showImage'                      => true,
				'showName'                       => true,
				'showDesignation'                => true,
				'showDescription'                => true,
				'showSocialIcons'                => true,
				'facebook'                       => '',
				'twitter'                        => '',
				'linkedin'                       => '',
				'instagram'                      => '',
				'email'                          => '',
				'youtube'                        => '',
				'pinterest'                      => '',
				'stack'                          => 'mobile',
				'titleFontSizeMobile'            => '',
				'titleFontSizeTablet'            => '',
				'designationFontSizeMobile'      => '',
				'designationFontSizeTablet'      => '',
				'descriptionFontSizeMobile'      => '',
				'descriptionFontSizeTablet'      => '',
				'socialIconBorderColor'          => '#fff',
				'socialIconHoverColor'           => '',
				'socialIconBackgroundHoverColor' => '',
				'socialIconBackgroundColor'      => '',
				'socialIconBorderHoverColor'     => '#fff',
				'iconBackgroundSize'             => '',
				'iconBorderSize'                 => '',
				'iconBorderRadius'               => 0,
				'iconTopRadiusMobile'            => '',
				'iconRightRadiusMobile'          => '',
				'iconBottomRadiusMobile'         => '',
				'iconLeftRadiusMobile'           => '',
				'iconTopRadiusTablet'            => '',
				'iconRightRadiusTablet'          => '',
				'iconBottomRadiusTablet'         => '',
				'iconLeftRadiusTablet'           => '',
				'iconTopRadius'                  => '',
				'iconRightRadius'                => '',
				'iconBottomRadius'               => '',
				'iconLeftRadius'                 => '',
				'hideWidget'                     => false,
				'hideWidgetMobile'               => false,
				'hideWidgetTablet'               => false,
				'z_index'                        => 1,
				'z_indexTablet'                  => 1,
				'z_indexMobile'                  => 1,
				'blockTopPadding'                => '',
				'blockTopPaddingMobile'          => '',
				'blockTopPaddingTablet'          => '',
				'blockBottomPadding'             => '',
				'blockBottomPaddingMobile'       => '',
				'blockBottomPaddingTablet'       => '',
				'blockLeftPadding'               => '',
				'blockLeftPaddingMobile'         => '',
				'blockLeftPaddingTablet'         => '',
				'blockRightPadding'              => '',
				'blockRightPaddingMobile'        => '',
				'blockRightPaddingTablet'        => '',
				'blockTopMargin'                 => '',
				'blockTopMarginMobile'           => '',
				'blockTopMarginTablet'           => '',
				'blockBottomMargin'              => '',
				'blockBottomMarginMobile'        => '',
				'blockBottomMarginTablet'        => '',
				'blockLeftMargin'                => '',
				'blockLeftMarginMobile'          => '',
				'blockLeftMarginTablet'          => '',
				'blockRightMargin'               => '',
				'blockRightMarginMobile'         => '',
				'blockRightMarginTablet'         => '',
				'titleTypographyColor'           => '',
				'descriptionTypographyColor'     => '',
				'designationTypographyColor'     => '',
				'designationBottomSpacing'       => '',
				'designationBottomSpacingMobile' => '',
				'designationBottomSpacingTablet' => '',
				'descriptionBottomSpacing'       => '',
				'descriptionBottomSpacingMobile' => '',
				'descriptionBottomSpacingTablet' => '',
				'titleBottomSpacing'             => '',
				'titleBottomSpacingMobile'       => '',
				'titleBottomSpacingTablet'       => '',

				'backgroundRepeat'               => 'no-repeat',
				'overlayType'                    => '',
				'gradientOverlayColor1'          => '#fff',
				'gradientOverlayLocation1'       => 0,
				'gradientOverlayColor2'          => '#fff',
				'gradientOverlayLocation2'       => 100,
				'gradientOverlayType'            => 'linear',
				'gradientOverlayAngle'           => 0,
				'gradientOverlayPosition'        => 'center center',
				'backgroundType'                 => '',
				'backgroundColor1'               => '',
				'backgroundPositionTablet'       => 'center center',
				'backgroundPositionMobile'       => 'center center',
				'backgroundPositionFocal'        => '50% 50%',
				'backgroundPositionFocalMobile'  => '50% 50%',
				'backgroundPositionFocalTablet'  => '50% 50%',
				'backgroundSizeTablet'           => 'cover',
				'backgroundSizeMobile'           => 'cover',
				'backgroundImageColor'           => '',
				'backgroundPosition'             => 'center center',
				'backgroundSize'                 => 'cover',
				'titleTextTransform'             => '',
				'titleFontStyle'                 => '',
				'designationTextTransform'       => '',
				'designationFontStyle'           => '',
				'descriptionTextTransform'       => '',
				'descriptionFontStyle'           => '',
			);
		}

		/**
		 * Get testimonial Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_testimonial_css( $attr, $id ) {
			$defaults = self::get_responsive_block_testimonial_default_attributes();
			// Frontend backward compatibility.
			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 2,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// To Populate the Alignment Keys
			$new_alignment_keys = array(
				'newTestimonialCiteAlign'       => 'testimonialCiteAlign' ? 'testimonialCiteAlign' : '',
				'testimonialCiteAlignTablet' => 'testimonialCiteAlign' ? 'testimonialCiteAlign' : '',
				'testimonialCiteAlignMobile' => 'testimonialCiteAlign' ? 'testimonialCiteAlign' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_alignment_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// To Populate the Typography Control
			$new_typography_control_keys = array(
				'contentTypographyColor'          => 'testimonialTextColor' ? 'testimonialTextColor' : '',
				'nameTypographyColor'             => 'testimonialNameColor' ? 'testimonialNameColor' : '',
				'titleTypographyColor'            => 'testimonialTitleColor' ? 'testimonialTitleColor' : '',

				'contentBottomSpacing'            => 'contentSpacing' ? 'contentSpacing' : '',
				'contentBottomSpacingMobile'      => 'contentSpacingMobile' ? 'contentSpacingMobile' : '',
				'contentBottomSpacingTablet'      => 'contentSpacingTablet' ? 'contentSpacingTablet' : '',

				'nameBottomSpacing'               => 'nameSpacing' ? 'nameSpacing' : '',
				'nameBottomSpacingMobile'         => 'nameSpacingMobile' ? 'nameSpacingMobile' : '',
				'nameBottomSpacingTablet'         => 'nameSpacingTablet' ? 'nameSpacingTablet' : '',

				'titleBottomSpacing'              => 'titleSpacing' ? 'titleSpacing' : '',
				'titleBottomSpacingMobile'        => 'titleSpacingMobile' ? 'titleSpacingMobile' : '',
				'titleBottomSpacingTablet'        => 'titleSpacingTablet' ? 'titleSpacingTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_control_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// To Populate the Background Colors for various types of backgrounds.
			$new_background_color_keys = array(
				'backgroundColor'        => 'testimonialBackgroundColor' ? 'testimonialBackgroundColor' : 'backgroundColor',
				'backgroundColor1'       => 'testimonialBackgroundColor' ? 'testimonialBackgroundColor' : 'backgroundColor1',
				'backgroundImageColor'   => 'testimonialBackgroundColor' ? 'testimonialBackgroundColor' : 'backgroundImageColor',
				'gradientOverlayColor1'  => 'testimonialBackgroundColor' ? 'testimonialBackgroundColor' : 'gradientOverlayColor1',
				'gradientOverlayColor2'  => 'backgroundColor2' ? 'backgroundColor2' : 'gradientOverlayColor2',
				'gradientOverlayLocation1' => 'colorLocation1' ? 'colorLocation1' : 'gradientOverlayLocation1',
				'gradientOverlayLocation2' => 'colorLocation2' ? 'colorLocation2' : 'gradientOverlayLocation2',
			);

			// Populate new background color values using existing ones for backward compatibility.
			foreach ( $new_background_color_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// To populate backgroundType based on existing attribute values.
			$background_type_conditions = array(
				'video' => ( isset( $attr['backgroundVideo'] ) && '' !== $attr['backgroundVideo'] ),
				'image' => ( isset( $attr['backgroundImage'] ) && '' !== $attr['backgroundImage'] ),
				'gradient' => (
					isset( $attr['bgGradient'] ) && true === $attr['bgGradient']
					&& isset( $attr['testimonialBackgroundColor'] ) && '' !== $attr['testimonialBackgroundColor']
					&& isset( $attr['backgroundColor2'] ) && '' !== $attr['backgroundColor2']
				),
				'color' => (
					( ! isset( $attr['bgGradient']) || false === $attr['bgGradient'] || '' === $attr['bgGradient'] )
					&& isset( $attr['testimonialBackgroundColor'] ) && '' !== $attr['testimonialBackgroundColor']
				),
			);

			// Default backgroundType value
			$defaults['backgroundType'] = isset( $attr['backgroundType'] ) ? $attr['backgroundType'] : $defaults['backgroundType'];

			// Evaluate the conditions in order
			foreach ( $background_type_conditions as $type => $condition ) {
				if ( $condition ) {
					$defaults['backgroundType'] = $type;
					break;
				}
			}

			// To set the Overlay Background Type
			$overlay_type = isset( $attr['overlayType'] ) ? $attr['overlayType'] : $defaults['overlayType'];

			if (
				isset( $attr['backgroundImage'] ) && '' !== $attr['backgroundImage']
				&& isset( $attr['bgGradient'] ) && true === $attr['bgGradient']
				&& isset( $attr['testimonialBackgroundColor'] ) && '' !== $attr['testimonialBackgroundColor']
				&& isset( $attr['backgroundColor2'] ) && '' !== $attr['backgroundColor2']
			) {
				$overlay_type = 'gradient';
			} elseif (
				isset( $attr['backgroundImage'] ) && '' !== $attr['backgroundImage']
				&& isset( $attr['bgGradient'] ) && false === $attr['bgGradient']
				&& isset( $attr['testimonialBackgroundColor'] ) && '' !== $attr['testimonialBackgroundColor']
			) {
				$overlay_type = 'color';
			}

			$attr['overlayType'] = $overlay_type;

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css      = $attr['boxShadowPosition'];
			$hoverbox_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hoverbox_shadow_position_css = '';
			}

			$imgopacity = $attr['opacity'] / 100;

			$background_image_effect  = '';
			$updated_background_image = 'url(' . $attr['backgroundImage'] . ')';

			$color_type = '';
			if ( 'color' === $attr['overlayType'] ) {
				$color_type = self::hex_to_rgba(
					$attr['backgroundImageColor'],
					$imgopacity
				);

				if ( $attr['backgroundImage'] ) {
					$updated_background_image = 'linear-gradient(' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					',' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					'),url(' .
					$attr['backgroundImage'] .
					')';
				}
				$background_image_effect = '';
			} else {
				if ( 'linear' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'linear-gradient(' .
					$attr['gradientOverlayAngle'] .
					'deg,' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
				if ( 'radial' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'radial-gradient(' .
					'at ' . $attr['gradientOverlayPosition'] . ', ' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'], $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'], $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
			}
			// Ensure the background image logic is correctly applied.
			$bgimage = ! empty( $updated_background_image ) ? $updated_background_image : $background_image_effect;

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors        = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'position'       => 'relative',
					'z-index'        => $attr['z_index'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-testimonial:last-child' => array(
					'margin-bottom' => '0 !important',
				),
				' .responsive-block-editor-addons-testimonial-text' => array(
					'text-align'     => $attr['testimonialAlignment'],
					'font-family'    => $attr['contentFontFamily'],
					'font-size'      => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'line-height'    => $attr['contentLineHeight'],
					'font-weight'    => $attr['contentFontWeight'],
					'text-transform' => $attr['contentTextTransform'],
					'margin-bottom'  => self::get_css_value( $attr['contentBottomSpacing'], 'px' ),
					'color'          => $attr['contentTypographyColor'],
					'font-style'     => $attr['contentFontStyle'],
				),
				' .responsive-block-editor-addons-testimonial-info' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacing'], 'px' ),
					'text-align'    => $attr['newTestimonialCiteAlign'],
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap' => array(
					'padding-right' => self::get_css_value( $attr['imageSpacing'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap .responsive-block-editor-addons-testimonial-image-wrap' => array(
					'height' => self::get_css_value( $attr['imageWidth'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidth'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-avatar' => array(
					'height' => self::get_css_value( $attr['imageWidth'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidth'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-name' => array(
					'color'          => $attr['nameTypographyColor'],
					'font-family'    => $attr['nameFontFamily'],
					'font-size'      => self::get_css_value( $attr['nameFontSize'], 'px' ),
					'line-height'    => $attr['nameLineHeight'],
					'font-weight'    => $attr['nameFontWeight'],
					'text-transform' => $attr['nameTextTransform'],
					'margin-bottom'  => self::get_css_value( $attr['nameBottomSpacing'], 'px' ),
					'font-style'     => $attr['nameFontStyle'],
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-title' => array(
					'color'          => $attr['titleTypographyColor'],
					'font-family'    => $attr['titleFontFamily'],
					'font-size'      => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'line-height'    => $attr['titleLineHeight'],
					'font-weight'    => $attr['titleFontWeight'],
					'text-transform' => $attr['titleTextTransform'],
					'font-style'     => $attr['titleFontStyle'],
				),
				' .testimonial-box.responsive-block-editor-addons-block-testimonial' => array(
					'box-shadow'     =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
					'padding-top'    => self::get_css_value( $attr['contentTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['contentRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['contentBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['contentLeftPadding'], 'px' ),
				),
				' .testimonial-box.responsive-block-editor-addons-block-testimonial:hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
						self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
						' ' .
						$attr['hoverboxShadowColor'] .
						' ' .
						$hoverbox_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-block-testimonial' => array(
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity )
						: '',
					'background-image'           =>
						'gradient' === $attr['overlayType'] && 'image' === $attr['backgroundType']
						? $background_image_effect
						: (
							'gradient' === $attr['backgroundType']
							? self::generate_background_image_effect(
								self::hex_to_rgb( $attr['backgroundColor1'] ? $attr['backgroundColor1'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								self::hex_to_rgb( $attr['backgroundColor2'] ? $attr['backgroundColor2'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								$attr['gradientDirection'],
								$attr['colorLocation1'],
								$attr['colorLocation2']
							)
							: ( 'image' === $attr['backgroundType'] ? $updated_background_image : '' )
						),
					'background-size'            => $attr['backgroundSize'],
					'background-attachment'      => $attr['backgroundAttachment'],
					'background-repeat'          => $attr['backgroundRepeat'],
					'background-position'        => $background_position_focal,
					'color'                      => $attr['testimonialTextColor'],
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'],
					'border-width'               => 999 !== $attr['borderWidth'] && 1 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-radius'              => 999 !== $attr['borderRadius'] && 2 === $attr['blockBorderRadius'] ? self::get_css_value( $attr['borderRadius'], 'px' ) : self::get_css_value( $attr['blockBorderRadius'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-color'               => 'empty' === $attr['borderColor'] && '' !== $attr['blockBorderColor'] ? $attr['blockBorderColor'] : $attr['borderColor'],
				),
			);
			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .testimonial-box.responsive-block-editor-addons-block-testimonial' => array(
					'padding-top'    => self::get_css_value( $attr['contentTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['contentRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['contentBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['contentLeftPaddingMobile'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-testimonial:last-child' => array(
					'margin-bottom' => '0 !important',
				),
				' .responsive-block-editor-addons-testimonial-text' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-name' => array(
					'font-size'     => self::get_css_value( $attr['nameFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['nameBottomSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-info' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingMobile'], 'px' ),
					'text-align'    => $attr['testimonialCiteAlignMobile'],
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap' => array(
					'padding-right' => self::get_css_value( $attr['imageSpacingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap .responsive-block-editor-addons-testimonial-image-wrap' => array(
					'height' => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-avatar' => array(
					'height' => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-testimonial' => array(
					'background-size'            => $attr['backgroundSizeMobile'],
					'background-position'        => $background_position_focal_mobile,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .testimonial-box.responsive-block-editor-addons-block-testimonial' => array(
					'padding-top'    => self::get_css_value( $attr['contentTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['contentRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['contentBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['contentLeftPaddingTablet'], 'px' ),
				),
				' .wp-block-responsive-block-editor-addons-testimonial:last-child' => array(
					'margin-bottom' => self::get_css_value( 0, 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-testimonial-text' => array(
					'font-size'     => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['contentBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-name' => array(
					'font-size'     => self::get_css_value( $attr['nameFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['nameBottomSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-details .responsive-block-editor-addons-testimonial-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-info' => array(
					'margin-bottom' => self::get_css_value( $attr['titleBottomSpacingTablet'], 'px' ),
					'text-align'    => $attr['testimonialCiteAlignTablet'],
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap' => array(
					'padding-right' => self::get_css_value( $attr['imageSpacingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-info .responsive-block-editor-addons-testimonial-inner-block .responsive-block-editor-addons-testimonial-avatar-wrap .responsive-block-editor-addons-testimonial-image-wrap' => array(
					'height' => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial-avatar' => array(
					'height' => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'width'  => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-testimonial' => array(
					'background-size'            => $attr['backgroundSizeTablet'],
					'background-position'        => $background_position_focal_tablet,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-testimonial.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for testimonial block
		 *
		 * @return array
		 */
		public static function get_responsive_block_testimonial_default_attributes() {
			return array(
				'block_id'                   => '',
				'testimonialBlock'           => '',
				'counterId'                  => '',
				'count'                      => '',
				'gutter'                     => 'medium',
				'testimonialAlignment'       => '',
				'testimonialBackgroundColor' => '#f2f2f2',
				'testimonialTextColor'       => '',
				'testimonialNameColor'       => '',
				'testimonialTitleColor'      => '',
				'titleFontSize'              => '',
				'titleLineHeight'            => '',
				'titleFontWeight'            => '',
				'titleTextTransform'         => '',
				'nameFontSize'               => '',
				'nameLineHeight'             => '',
				'imageWidth'                 => '',
				'imageWidthTablet'           => '',
				'imageWidthMobile'           => '',
				'nameFontFamily'             => '',
				'titleFontFamily'            => '',
				'contentFontFamily'          => '',
				'nameFontWeight'             => '',
				'nameTextTransform'          => '',
				'contentFontSize'            => '',
				'contentLineHeight'          => 1.6,
				'contentFontWeight'          => '',
				'contentTextTransform'       => '',
				'testimonialCiteAlign'       => 'left-align',
				'newTestimonialCiteAlign'    => 'left',
				'backgroundColor'            => '#f2f2f2',
				'blockBorderStyle'           => 'none',
				'blockBorderWidth'           => 1,
				'blockBorderColor'           => '',
				'blockBorderRadius'          => 2,
				'padding'                    => 20,
				'paddingTablet'              => 20,
				'paddingMobile'              => 20,
				'contentSpacing'             => 8,
				'titleSpacing'               => '',
				'nameSpacing'                => -5,
				'imageSpacing'               => '',
				'contentSpacingMobile'       => 8,
				'titleSpacingMobile'         => '',
				'nameSpacingMobile'          => -5,
				'imageSpacingMobile'         => '',
				'contentSpacingTablet'       => 8,
				'titleSpacingTablet'         => '',
				'nameSpacingTablet'          => -5,
				'imageSpacingTablet'         => '',
				'alignment'                  => 'center',
				'imageShape'                 => '',
				'imageSize'                  => 'full',
				'boxShadowColor'             => '#fff',
				'boxShadowHOffset'           => 0,
				'boxShadowVOffset'           => 0,
				'boxShadowBlur'              => 0,
				'boxShadowSpread'            => 0,
				'boxShadowPosition'          => 'outset',
				'hoverboxShadowColor'        => '',
				'hoverboxShadowHOffset'      => 0,
				'hoverboxShadowVOffset'      => 0,
				'hoverboxShadowBlur'         => 6,
				'hoverboxShadowSpread'       => 1,
				'hoverboxShadowPosition'     => 'outset',
				'opacity'                    => 70,
				'gradientDirection'          => 180,
				'bgGradient'                 => false,
				'backgroundImage'            => '',
				'colorLocation1'             => 0,
				'colorLocation2'             => 100,
				'backgroundPosition'         => 'center center',
				'backgroundSize'             => 'cover',
				'backgroundRepeat'           => 'no-repeat',
				'imageHoverEffect'           => '',
				'bggradient'                 => '',
				'backgroundColor2'           => '',
				'contentFontSizeMobile'      => '',
				'contentFontSizeTablet'      => '',
				'nameFontSizeMobile'         => '',
				'nameFontSizeTablet'         => '',
				'titleFontSizeMobile'        => '',
				'titleFontSizeTablet'        => '',
				'borderStyle'                => 'empty', // For compatibility with v1.3.2.
				'borderWidth'                => 999, // For compatibility with v1.3.2.
				'borderRadius'               => 999, // For compatibility with v1.3.2.
				'borderColor'                => 'empty', // For compatibility with v1.3.2.
				'secondaryBackgroundColor'   => 'empty', // For compatibility with v1.3.2.
				'hideWidget'                 => false,
				'hideWidgetMobile'           => false,
				'hideWidgetTablet'           => false,
				'z_index'                    => 1,
				'z_indexTablet'              => 1,
				'z_indexMobile'              => 1,
				'blockTopPadding'            => '',
				'blockTopPaddingMobile'      => '',
				'blockTopPaddingTablet'      => '',
				'blockBottomPadding'         => '',
				'blockBottomPaddingMobile'   => '',
				'blockBottomPaddingTablet'   => '',
				'blockLeftPadding'           => '',
				'blockLeftPaddingMobile'     => '',
				'blockLeftPaddingTablet'     => '',
				'blockRightPadding'          => '',
				'blockRightPaddingMobile'    => '',
				'blockRightPaddingTablet'    => '',
				'blockTopMargin'             => '',
				'blockTopMarginMobile'       => '',
				'blockTopMarginTablet'       => '',
				'blockBottomMargin'          => '',
				'blockBottomMarginMobile'    => '',
				'blockBottomMarginTablet'    => '',
				'blockLeftMargin'            => '',
				'blockLeftMarginMobile'      => '',
				'blockLeftMarginTablet'      => '',
				'blockRightMargin'           => '',
				'blockRightMarginMobile'     => '',
				'blockRightMarginTablet'     => '',
				'blockTopRadiusMobile'       => 0,
				'blockRightRadiusMobile'     => 0,
				'blockBottomRadiusMobile'    => 0,
				'blockLeftRadiusMobile'      => 0,
				'blockTopRadiusTablet'       => 0,
				'blockRightRadiusTablet'     => 0,
				'blockBottomRadiusTablet'    => 0,
				'blockLeftRadiusTablet'      => 0,
				'blockTopRadius'             => 0,
				'blockRightRadius'           => 0,
				'blockBottomRadius'          => 0,
				'blockLeftRadius'            => 0,
				'backgroundPositionTablet'   => 'center center',
				'backgroundPositionMobile'   => 'center center',
				'backgroundPositionFocal'    => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundSizeTablet'       => 'cover',
				'backgroundSizeMobile'       => 'cover',
				'backgroundAttachment'       => 'scroll',
				'backgroundImageColor'       => '#fff',
				'overlayType'                => 'color',
				'gradientOverlayColor1'      => '',
				'gradientOverlayColor2'      => '',
				'gradientOverlayType'        => 'linear',
				'gradientOverlayLocation1'   => 0,
				'gradientOverlayLocation2'   => 100,
				'gradientOverlayAngle'       => 180,
				'gradientOverlayPosition'    => 'center center',
				'backgroundVideo'            => '',
				'backgroundType'             => 'none',
				'contentTypographyColor'     => '',
				'titleTypographyColor'       => '',
				'titleBottomSpacing'         => '',
				'titleBottomSpacingTablet'   => '',
				'titleBottomSpacingMobile'   => '',
				'contentBottomSpacing'       => 8,
				'contentBottomSpacingTablet' => 8,
				'contentBottomSpacingMobile' => 8,
				'contentTopPadding'          => 20,
				'contentTopPaddingMobile'    => 20,
				'contentTopPaddingTablet'    => 20,
				'contentBottomPadding'       => 20,
				'contentBottomPaddingMobile' => 20,
				'contentBottomPaddingTablet' => 20,
				'contentLeftPadding'         => 20,
				'contentLeftPaddingMobile'   => 20,
				'contentLeftPaddingTablet'   => 20,
				'contentRightPadding'        => 20,
				'contentRightPaddingMobile'  => 20,
				'contentRightPaddingTablet'  => 20,
				'nameTypographyColor'        => '',
				'nameBottomSpacing'          => -5,
				'nameBottomSpacingMobile'    => -5,
				'nameBottomSpacingTablet'    => -5,
				'testimonialCiteAlignTablet' => 'left',
				'testimonialCiteAlignMobile' => 'left',
				'backgroundColor1'           => '',
				'contentFontStyle'           => '',
				'nameFontStyle'              => '',
				'titleFontStyle'             => '',
			);
		}

		/**
		 * Get Testimonial Slider Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_testimonial_slider_css( $attr, $id ) {
			$defaults = self::get_responsive_block_testimonial_slider_block_default_attributes();

			$new_border_radius_keys = array(
				'bubbleTopRadius'          => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleRightRadius'        => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleBottomRadius'       => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleLeftRadius'         => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleTopRadiusTablet'    => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleRightRadiusTablet'  => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleBottomRadiusTablet' => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleLeftRadiusTablet'   => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleTopRadiusMobile'    => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleRightRadiusMobile'  => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleBottomRadiusMobile' => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,
				'bubbleLeftRadiusMobile'   => 'bubbleBorderRadius' ? 'bubbleBorderRadius' : 0,

				'blockTopRadius'           => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'     => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'     => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,

				'arrowTopRadius'           => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadius'         => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadius'        => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadius'          => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowTopRadiusTablet'     => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadiusTablet'   => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadiusTablet'  => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadiusTablet'    => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowTopRadiusMobile'     => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowRightRadiusMobile'   => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowBottomRadiusMobile'  => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
				'arrowLeftRadiusMobile'    => 'arrowBorderRadius' ? 'arrowBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'descTypographyColor'     => 'descColor' ? 'descColor' : '',
				'nameTypographyColor'     => 'authorColor' ? 'authorColor' : '',
				'companyTypographyColor'  => 'companyColor' ? 'companyColor' : '',
				'descBottomSpacing'       => 'descSpace' ? 'descSpace' : '',
				'descBottomSpacingMobile' => 'descSpaceMobile' ? 'descSpaceMobile' : '',
				'descBottomSpacingTablet' => 'descSpaceTablet' ? 'descSpaceTablet' : '',
				'nameBottomSpacing'       => 'nameSpace' ? 'nameSpace' : '',
				'nameBottomSpacingMobile' => 'nameSpaceMobile' ? 'nameSpaceMobile' : '',
				'nameBottomSpacingTablet' => 'nameSpaceTablet' ? 'nameSpaceTablet' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$imgopacity = $attr['opacity'] / 100;

			$background_image_effect  = '';
			$updated_background_image = '';

			$color_type = '';
			if ( 'color' === $attr['overlayType'] || '' === $attr['overlayType'] || 'none' === $attr['overlayType'] ) {
				$color_type = self::hex_to_rgba(
					$attr['backgroundImageColor'],
					$imgopacity
				);

				if ( $attr['backgroundImage'] ) {
					$updated_background_image = 'linear-gradient(' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					',' .
					self::hex_to_rgba( $attr['backgroundImageColor'] ? $attr['backgroundImageColor'] : '#fff', $imgopacity ) .
					'),url(' .
					$attr['backgroundImage'] .
					')';
				}
				$background_image_effect = '';
			} else {
				if ( 'linear' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'linear-gradient(' .
					$attr['gradientOverlayAngle'] .
					'deg,' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'] ?? '#fff', $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';

				}
				if ( 'radial' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'radial-gradient(' .
					'at ' . $attr['gradientOverlayPosition'] . ', ' .
					self::hex_to_rgba( $attr['gradientOverlayColor1'], $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgba( $attr['gradientOverlayColor2'], $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$position    = str_replace( '-', ' ', $attr['backgroundImagePosition'] );
			$backopacity = $attr['backgroundOpacity'] ? ( 100 - $attr['backgroundOpacity'] ) / 100 : 0.5;

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                   => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_index'],
					'position'       => 'relative',
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .slick-arrow svg'   => array(
					'fill'   => $attr['arrowColor'],
					'width'  => self::get_css_value( $attr['arrowSize'], 'px' ),
					'height' => self::get_css_value( $attr['arrowSize'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__content' => array(
					'border-width'               => 999 !== $attr['borderWidth'] && 1 === $attr['blockBorderWidth'] ? self::get_css_value( $attr['borderWidth'], 'px' ) : self::get_css_value( $attr['blockBorderWidth'], 'px' ), // For compatibility with v1.3.2.
					'border-color'               => 'empty' !== $attr['borderColor'] && '' === $attr['blockBorderColor'] ? $attr['borderColor'] : $attr['blockBorderColor'],  // For compatibility with v1.3.2.
					'border-style'               => 'empty' !== $attr['borderStyle'] && 'none' === $attr['blockBorderStyle'] ? $attr['borderStyle'] : $attr['blockBorderStyle'],  // For compatibility with v1.3.2.
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'padding'                    => self::get_css_value( $attr['contentPadding'], 'px' ),
					'text-align'                 => $attr['headingAlign'],
				),
				' button.slick-arrow' => array(
					'border-width'               => self::get_css_value( $attr['arrowBorderWidth'], 'px' ),
					'border-color'               => $attr['arrowBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadius'], 'px' ),
					'border-style'               => $attr['arrowBorderStyle'],
				),
				' ul.slick-dots li button:before, ul.slick-dots li.slick-active button:before' => array(
					'color' => $attr['arrowColor'],
				),
				' .responsive-block-editor-addons-tm__image img' => array(
					'width'     => self::get_css_value( $attr['imageWidth'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidth'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap.responsive-block-editor-addons-tm__bg-type-image .responsive-block-editor-addons-tm__overlay' => array(
					'background-color'      =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity )
						: '',
					'background-image'      =>
						'gradient' === $attr['overlayType'] && 'image' === $attr['backgroundType']
						? $background_image_effect
						: (
							'gradient' === $attr['backgroundType']
							? self::generate_background_image_effect(
								self::hex_to_rgb( $attr['backgroundColor1'] ? $attr['backgroundColor1'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								self::hex_to_rgb( $attr['backgroundColor2'] ? $attr['backgroundColor2'] : '#fff', $imgopacity ? $imgopacity : 0 ),
								$attr['gradientDirection'],
								$attr['colorLocation1'],
								$attr['colorLocation2']
							)
							: ( 'image' === $attr['backgroundType'] ? $updated_background_image : '' )
						),
					'background-size'       => $attr['backgroundSize'],
					'background-repeat'     => $attr['backgroundRepeat'],
					'background-position'   => $background_position_focal,
					'background-attachment' => $attr['backgroundAttachment'],
					'opacity'               => 'image' === $attr['backgroundType'] ? $attr['imgopacity'] : '',
				),
				' .responsive-block-editor-addons-testimonial__wrap' => array(
					'padding-left'  => self::get_css_value( $attr['columnGap'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGap'] / 2, 'px' ),
					'margin-bottom' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__image-content' => array(
					'padding-left'   => self::get_css_value( $attr['imgHrPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['imgHrPadding'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['imgVrPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['imgVrPadding'], 'px' ),
				),
				' .responsive-block-editor-addons-tm__content.skin-type-bubble .responsive-block-editor-addons-tm__desc' => array(
					'padding' => self::get_css_value( $attr['bubblePadding'], 'px' ),
					'color'   => $attr['descTypographyColor'],
				),
				' .responsive-block-editor-addons-tm__content.skin-type-bubble .responsive-block-editor-addons-testinomial-text-wrap:before' => array(
					'border-top' => '10px solid ' . $attr['bubbleColor'],
				),
				' .responsive-block-editor-addons-tm__content.skin-type-bubble .responsive-block-editor-addons-testinomial-text-wrap' => array(
					'background-color'           => $attr['bubbleColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['bubbleTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['bubbleRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['bubbleBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['bubbleLeftRadius'], 'px' ),
				),
				' .responsive-block-editor-addons-tm__desc' => array(
					'font-size' => self::get_css_value( $attr['descFontSize'], $attr['descFontSizeType'] ),
					'color'     => $attr['descTypographyColor'],
					'margin-bottom' => self::get_css_value( $attr['descBottomSpacing'], 'px' ) . ' !important',
					'text-transform' => $attr['descTextTransform'],
					'font-style' => $attr['descFontStyle'],
				),
				' .responsive-block-editor-addons-tm__author-name' => array(
					'font-size' => self::get_css_value( $attr['nameFontSize'], $attr['nameFontSizeType'] ),
					'margin-bottom' => self::get_css_value( $attr['nameBottomSpacing'], 'px' ) . ' !important',
					'text-transform' => $attr['nameTextTransform'],
					'font-style' => $attr['nameFontStyle'],
				),
				' .responsive-block-editor-addons-tm__company' => array(
					'font-size' => self::get_css_value( $attr['companyFontSize'], $attr['companyFontSizeType'] ),
					'text-transform' => $attr['companyTextTransform'],
					'font-style' => $attr['companyFontStyle'],
				),
			);

			$mobile_selectors = array(
				' '                   => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on? 'none' : 'block',
					'z-index'        => $attr['z_indexMobile'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__content' => array(
					'text-align'                 => $attr['headingAlignMobile'],
					'padding'                    => self::get_css_value( $attr['contentPaddingMobile'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap' => array(
					'padding-left'  => self::get_css_value( $attr['columnGapMobile'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGapMobile'] / 2, 'px' ),
					'margin-bottom' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__image-content' => array(
					'padding-left'   => self::get_css_value( $attr['imgHrPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['imgHrPaddingMobile'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['imgVrPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['imgVrPaddingMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__image img' => array(
					'width'     => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-tm__author-name' => array(
					'margin-bottom' => self::get_css_value( $attr['nameSpaceMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-tm__desc' => array(
					'margin-bottom' => self::get_css_value( $attr['descSpaceMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-tm__desc' => array(
					'font-size' => self::get_css_value( $attr['descFontSizeMobile'], $attr['descFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__author-name' => array(
					'font-size' => self::get_css_value( $attr['nameFontSizeMobile'], $attr['nameFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__company' => array(
					'font-size' => self::get_css_value( $attr['companyFontSizeMobile'], $attr['companyFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__content.skin-type-bubble .responsive-block-editor-addons-testinomial-text-wrap' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['bubbleTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['bubbleRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['bubbleBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['bubbleLeftRadiusMobile'], 'px' ),
				),
				' button.slick-arrow' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap.responsive-block-editor-addons-tm__bg-type-image .responsive-block-editor-addons-tm__overlay' => array(
					'background-size'       => $attr['backgroundSizeMobile'],
					'background-position'   => $background_position_focal_mobile,
				),
			);

			$tablet_selectors = array(
				' '                   => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index'        => $attr['z_indexTablet'],
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__content' => array(
					'text-align'                 => $attr['headingAlignTablet'],
					'padding'                    => self::get_css_value( $attr['contentPaddingTablet'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap' => array(
					'padding-left'  => self::get_css_value( $attr['columnGapTablet'] / 2, 'px' ),
					'padding-right' => self::get_css_value( $attr['columnGapTablet'] / 2, 'px' ),
					'margin-bottom' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__image-content' => array(
					'padding-left'   => self::get_css_value( $attr['imgHrPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['imgHrPaddingTablet'], 'px' ),
					'padding-top'    => self::get_css_value( $attr['imgVrPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['imgVrPaddingTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap .responsive-block-editor-addons-tm__image img' => array(
					'width'     => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
					'max-width' => self::get_css_value( $attr['imageWidthTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-tm__author-name' => array(
					'margin-bottom' => self::get_css_value( $attr['nameSpaceTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-tm__desc' => array(
					'margin-bottom' => self::get_css_value( $attr['descSpaceTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-tm__desc' => array(
					'font-size' => self::get_css_value( $attr['descFontSizeTablet'], $attr['descFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__author-name' => array(
					'font-size' => self::get_css_value( $attr['nameFontSizeTablet'], $attr['nameFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__company' => array(
					'font-size' => self::get_css_value( $attr['companyFontSizeTablet'], $attr['companyFontSizeType'] ) . '!important',
				),
				' .responsive-block-editor-addons-tm__content.skin-type-bubble .responsive-block-editor-addons-testinomial-text-wrap' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['bubbleTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['bubbleRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['bubbleBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['bubbleLeftRadiusTablet'], 'px' ),
				),
				' button.slick-arrow' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['arrowTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['arrowRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['arrowBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['arrowLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-testimonial__wrap.responsive-block-editor-addons-tm__bg-type-image .responsive-block-editor-addons-tm__overlay' => array(
					'background-size'       => $attr['backgroundSizeTablet'],
					'background-position'   => $background_position_focal_tablet,
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-testomonial__outer-wrap.responsive-block-editor-addons-block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Section Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_section_css( $attr, $id ) {
			$defaults = self::get_responsive_block_section_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$imgopacity = $attr['opacity'] / 100;

			$background_image_effect  = '';
			$updated_background_image = '';

			$color_type = '';
			if ( 'color' === $attr['overlayType'] ) {
				$color_type = self::hex_to_rgb(
					$attr['backgroundImageColor'],
					$imgopacity
				);

				if ( $attr['backgroundImage'] ) {
					$updated_background_image = 'linear-gradient(' .
					self::hex_to_rgb( $attr['backgroundImageColor'], $imgopacity ) .
					',' .
					self::hex_to_rgb( $attr['backgroundImageColor'], $imgopacity ) .
					'),url(' .
					$attr['backgroundImage'] .
					')';
				}
				$background_image_effect = '';
			} else {
				if ( 'linear' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'linear-gradient(' .
					$attr['gradientOverlayAngle'] .
					'deg,' .
					self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgb( $attr['gradientOverlayColor2'], $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
				if ( 'radial' === $attr['gradientOverlayType'] ) {
					$background_image_effect = 'radial-gradient(' .
					'at ' . $attr['gradientOverlayPosition'] . ', ' .
					self::hex_to_rgb( $attr['gradientOverlayColor1'], $imgopacity ) .
					$attr['gradientOverlayLocation1'] .
					'% ,' .
					self::hex_to_rgb( $attr['gradientOverlayColor2'], $imgopacity ) .
					$attr['gradientOverlayLocation2'] .
					'% ),url(' .
					$attr['backgroundImage'] .
					')';
				}
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$selectors = array(
				' '                           => array(
					'display' => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
				),
				' > .responsive-block-editor-addons-block-section.responsive-section-wrap' => array(
					'margin-top'       => 999 !== $attr['topMargin'] && 0 === $attr['blockTopMargin'] ? self::get_css_value( $attr['topMargin'], 'px' ) : self::get_css_value( $attr['blockTopMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'    => 999 !== $attr['bottomMargin'] && 0 === $attr['blockBottomMargin'] ? self::get_css_value( $attr['bottomMargin'], 'px' ) : self::get_css_value( $attr['blockBottomMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'      => 999 !== $attr['leftMargin'] && 0 === $attr['blockLeftMargin'] ? self::get_css_value( $attr['leftMargin'], 'px' ) : self::get_css_value( $attr['blockLeftMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'     => 999 !== $attr['rightMargin'] && 0 === $attr['blockRightMargin'] ? self::get_css_value( $attr['rightMargin'], 'px' ) : self::get_css_value( $attr['blockRightMargin'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'      => 999 !== $attr['topPadding'] && 10 === $attr['blockTopPadding'] ? self::get_css_value( $attr['topPadding'], 'px' ) : self::get_css_value( $attr['blockTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'   => 999 !== $attr['bottomPadding'] && 10 === $attr['blockBottomPadding'] ? self::get_css_value( $attr['bottomPadding'], 'px' ) : self::get_css_value( $attr['blockBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'     => 999 !== $attr['leftPadding'] && 10 === $attr['blockLeftPadding'] ? self::get_css_value( $attr['leftPadding'], 'px' ) : self::get_css_value( $attr['blockLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'    => 999 !== $attr['rightPadding'] && 10 === $attr['blockRightPadding'] ? self::get_css_value( $attr['rightPadding'], 'px' ) : self::get_css_value( $attr['blockRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'background-color' => $color_type,
					'background-image' => $background_image_effect,
				),
				' > .responsive-section-wrap > .responsive-section-inner-wrap' => array(
					'max-width' => 'full' === $attr['align'] ? self::get_css_value( $attr['innerWidth'], 'px' ) : '',
					'z-index'   => $attr['z_index'],
				),
				' .background-type-video'     => array(
					'background-color' => self::hex_to_rgb(
						$attr['backgroundColor'],
						$imgopacity
					),
				),
				' > .responsive-section-wrap' => array(
					'background-image'           => $updated_background_image,
					'background-position'        => $background_position_focal,
					'background-attachment'      => $attr['backgroundAttachment'],
					'background-repeat'          => $attr['backgroundRepeat'],
					'background-size'            => $attr['backgroundSize'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'z-index'                    => $attr['z_index'],
					'max-width'                  => 'full' !== $attr['align'] ? self::get_css_value( $attr['width'], 'px' ) : '',
					'margin-left'                => 'full' !== $attr['align'] ? 'auto' : '',
					'margin-right'               => 'full' !== $attr['align'] ? 'auto' : '',
				),
				' > .responsive-section-wrap.responsive-block-editor-addons-block-section' => array(
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'background-color'           =>
						'color' === $attr['backgroundType']
						? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $imgopacity )
						: '',
					'background-image'           =>
						'gradient' === $attr['backgroundType']
						? self::generate_background_image_effect(
							self::hex_to_rgb( $attr['backgroundColor1'], $imgopacity ),
							self::hex_to_rgb( $attr['backgroundColor2'], $imgopacity ),
							$attr['gradientDirection'],
							$attr['colorLocation1'],
							$attr['colorLocation2']
						)
						: '',
					'box-shadow'                 =>
						self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
						' ' .
						self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
						' ' .
						$attr['boxShadowColor'] .
						' ' .
						$box_shadow_position_css,
				),
				' > .responsive-section-wrap.responsive-block-editor-addons-block-section:hover' => array(
					'box-shadow' => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) )
						? self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) . ' ' .
						self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) . ' ' .
						self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) . ' ' .
						self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) . ' ' .
						$attr['hoverboxShadowColor'] . ' ' .
						$hover_box_shadow_position_css
						: '',
				),
			);

			$mobile_selectors = array(
				' '                           => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
				),
				' > .responsive-block-editor-addons-block-section.responsive-section-wrap' => array(
					'margin-top'     => 999 !== $attr['topMarginMobile'] && '' === $attr['blockTopMarginMobile'] ? self::get_css_value( $attr['topMarginMobile'], 'px' ) : self::get_css_value( $attr['blockTopMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'  => 999 !== $attr['bottomMarginMobile'] && '' === $attr['blockBottomMarginMobile'] ? self::get_css_value( $attr['bottomMarginMobile'], 'px' ) : self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'    => 999 !== $attr['leftMarginMobile'] && '' === $attr['blockLeftMarginMobile'] ? self::get_css_value( $attr['leftMarginMobile'], 'px' ) : self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'   => 999 !== $attr['rightMarginMobile'] && '' === $attr['blockRightMarginMobile'] ? self::get_css_value( $attr['rightMarginMobile'], 'px' ) : self::get_css_value( $attr['blockRightMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'    => 999 !== $attr['topPaddingMobile'] && 10 === $attr['blockTopPaddingMobile'] ? self::get_css_value( $attr['topPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['bottomPaddingMobile'] && 10 === $attr['blockBottomPaddingMobile'] ? self::get_css_value( $attr['bottomPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['leftPaddingMobile'] && 10 === $attr['blockLeftPaddingMobile'] ? self::get_css_value( $attr['leftPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['rightPaddingMobile'] && 10 === $attr['blockRightPaddingMobile'] ? self::get_css_value( $attr['rightPaddingMobile'], 'px' ) : self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
				),
				' > .responsive-section-wrap > .responsive-section-inner-wrap' => array(
					'max-width' =>
						'full' === $attr['align'] ? self::get_css_value( $attr['innerWidthMobile'], 'px' ) : '',
					'z-index'   => $attr['z_indexMobile'],
				),
				' > .responsive-section-wrap' => array(
					'background-position'        => $background_position_focal_mobile,
					'background-size'            => '' === $attr['backgroundSizeMobile'] ? $attr['backgroundSize'] : $attr['backgroundSizeMobile'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' > .responsive-section-wrap.responsive-block-editor-addons-block-section' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                           => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
				),
				' > .responsive-block-editor-addons-block-section.responsive-section-wrap' => array(
					'margin-top'     => 999 !== $attr['topMarginTablet'] && '' === $attr['blockTopMarginTablet'] ? self::get_css_value( $attr['topMarginTablet'], 'px' ) : self::get_css_value( $attr['blockTopMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'  => 999 !== $attr['bottomMarginTablet'] && '' === $attr['blockBottomMarginTablet'] ? self::get_css_value( $attr['bottomMarginTablet'], 'px' ) : self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'    => 999 !== $attr['leftMarginTablet'] && '' === $attr['blockLeftMarginTablet'] ? self::get_css_value( $attr['leftMarginTablet'], 'px' ) : self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'   => 999 !== $attr['rightMarginTablet'] && '' === $attr['blockRightMarginTablet'] ? self::get_css_value( $attr['rightMarginTablet'], 'px' ) : self::get_css_value( $attr['blockRightMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'    => 999 !== $attr['topPaddingTablet'] && 10 === $attr['blockTopPaddingTablet'] ? self::get_css_value( $attr['topPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['bottomPaddingTablet'] && 10 === $attr['blockBottomPaddingTablet'] ? self::get_css_value( $attr['bottomPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['leftPaddingTablet'] && 10 === $attr['blockLeftPaddingTablet'] ? self::get_css_value( $attr['leftPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['rightPaddingTablet'] && 10 === $attr['blockRightPaddingTablet'] ? self::get_css_value( $attr['rightPaddingTablet'], 'px' ) : self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
				),
				' > .responsive-section-wrap > .responsive-section-inner-wrap' => array(
					'max-width' =>
						'full' === $attr['align'] ? self::get_css_value( $attr['innerWidthTablet'], 'px' ) : '',
					'z-index'   => $attr['z_indexTablet'],
				),
				' > .responsive-section-wrap' => array(
					'background-position'        => $background_position_focal_tablet,
					'background-size'            => '' === $attr['backgroundSizeTablet'] ? $attr['backgroundSize'] : $attr['backgroundSizeTablet'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' > .responsive-section-wrap.responsive-block-editor-addons-block-section' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id              = '.responsive-block-editor-addons-block-section-outer-wrap.block-' . $id;
			$css             = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			$css['desktop'] .= '
            .responsive-block-editor-addons-section__video-wrap {
				border-top-left-radius:' . $attr['blockTopRadius'] . 'px );
				border-top-right-radius:' . $attr['blockRightRadius'] . 'px );
				border-bottom-right-radius:' . $attr['blockBottomRadius'] . 'px );
				border-bottom-left-radius:' . $attr['blockLeftRadius'] . 'px );
              }
            .page.page-template-gutenberg-fullwidth .alignfull' . $id . ' > .responsive-section-wrap > .responsive-section-inner-wrap{
                max-width:' . ( 'full' === $attr['align'] ? self::get_css_value( $attr['innerWidth'], 'px' ) : ' ' ) . ' ;}

                .page.page-template-gutenberg-fullwidth .alignfull ' . $id . '{
                max-width:' . ( 'full' !== $attr['align'] ? self::get_css_value( $attr['width'], 'px' ) . ' !important' : ' ' ) . ' ;
                margin-left:' . ( 'full' !== $attr['align'] ? 'auto' : ' ' ) . ' ;
                margin-right:' . ( 'full' !== $attr['align'] ? 'auto' : ' ' ) . ' ;
                }
            ';
			$css['tablet']  .= '
            .page.page-template-gutenberg-fullwidth .alignfull' . $id . ' > .responsive-section-wrap > .responsive-section-inner-wrap{
                max-width:' . ( 'full' === $attr['align'] ? self::get_css_value( $attr['innerWidthTablet'], 'px' ) : ' ' ) . ' ;}
            .responsive-block-editor-addons-section__video-wrap {
				border-top-left-radius:' . $attr['blockTopRadiusTablet'] . 'px );
				border-top-right-radius:' . $attr['blockRightRadiusTablet'] . 'px );
				border-bottom-right-radius:' . $attr['blockBottomRadiusTablet'] . 'px );
				border-bottom-left-radius:' . $attr['blockLeftRadiusTablet'] . 'px );
            }';
			$css['mobile']  .= '
            .page.page-template-gutenberg-fullwidth .alignfull' . $id . ' > .responsive-section-wrap > .responsive-section-inner-wrap{
                max-width:' . ( 'full' === $attr['align'] ? self::get_css_value( $attr['innerWidthMobile'], 'px' ) : ' ' ) . ' ;}
            .responsive-block-editor-addons-section__video-wrap {
				border-top-left-radius:' . $attr['blockTopRadiusMobile'] . 'px );
				border-top-right-radius:' . $attr['blockRightRadiusMobile'] . 'px );
				border-bottom-right-radius:' . $attr['blockBottomRadiusMobile'] . 'px );
				border-bottom-left-radius:' . $attr['blockLeftRadiusMobile'] . 'px );
            }';

			return $css;
		}

		/**
		 * Get Defaults for testimonial slider block
		 *
		 * @return array
		 */
		public static function get_responsive_block_testimonial_slider_block_default_attributes() {
			return array(
				'test_item_count'          => 3,
				'classMigrate'             => false,
				'test_block'               => array(),
				'skin'                     => 'default',
				'bubblePadding'            => 20,
				'bubbleBorderRadius'       => 0,
				'bubbleTopRadiusMobile'    => 0,
				'bubbleRightRadiusMobile'  => 0,
				'bubbleBottomRadiusMobile' => 0,
				'bubbleLeftRadiusMobile'   => 0,
				'bubbleTopRadiusTablet'    => 0,
				'bubbleRightRadiusTablet'  => 0,
				'bubbleBottomRadiusTablet' => 0,
				'bubbleLeftRadiusTablet'   => 0,
				'bubbleTopRadius'          => 0,
				'bubbleRightRadius'        => 0,
				'bubbleBottomRadius'       => 0,
				'bubbleLeftRadius'         => 0,
				'bubbleColor'              => 'center',
				'headingAlign'             => 'center',
				'headingAlignMobile'       => 'center',
				'headingAlignTablet'       => 'center',
				'descColor'                => '#333',
				'companyColor'             => '#888888',
				'authorColor'              => '#333',
				'iconimgStyle'             => 'circle',
				'imagePosition'            => 'bottom',
				'imageAlignment'           => 'top',
				'nameFontSizeType'         => 'px',
				'nameFontSize'             => '',
				'nameFontSizeTablet'       => '',
				'nameFontSizeMobile'       => '',
				'nameFontFamily'           => '',
				'nameFontWeight'           => '',
				'nameFontSubset'           => '',
				'nameLineHeightType'       => 'em',
				'nameLineHeight'           => '',
				'nameLineHeightTablet'     => '',
				'nameLineHeightMobile'     => '',
				'nameLoadGoogleFonts'      => false,
				'companyFontSizeType'      => 'px',
				'companyFontSize'          => '',
				'companyFontSizeTablet'    => '',
				'companyFontSizeMobile'    => '',
				'companyFontFamily'        => '',
				'companyFontWeight'        => '',
				'companyFontSubset'        => '',
				'companyLineHeightType'    => 'em',
				'companyLineHeight'        => '',
				'companyLineHeightTablet'  => '',
				'companyLineHeightMobile'  => '',
				'companyLoadGoogleFonts'   => false,
				'descFontSizeType'         => 'px',
				'descFontSize'             => '',
				'descFontSizeTablet'       => '',
				'descFontSizeMobile'       => '',
				'descFontFamily'           => '',
				'descFontWeight'           => '',
				'descFontSubset'           => '',
				'descLineHeightType'       => 'em',
				'descLineHeight'           => '',
				'descLineHeightTablet'     => '',
				'descLineHeightMobile'     => '',
				'descLoadGoogleFonts'      => false,
				'nameSpace'                => 5,
				'descSpace'                => 15,
				'nameSpaceMobile'          => 5,
				'descSpaceMobile'          => 15,
				'nameSpaceTablet'          => 5,
				'descSpaceTablet'          => 15,
				'block_id'                 => 'not_set',
				'authorSpace'              => 5,
				'imgVrPadding'             => 10,
				'imgHrPadding'             => 10,
				'imgVrPaddingMobile'       => 10,
				'imgHrPaddingMobile'       => 10,
				'imgVrPaddingTablet'       => 10,
				'imgHrPaddingTablet'       => 10,
				'imgTopPadding'            => 10,
				'imgBottomPadding'         => 10,
				'iconImage'                => array(
					'url' => '',
					'alt' => 'InfoBox placeholder img',
				),
				'imageSize'                => 'thumbnail',
				'imageWidth'               => 60,
				'imageWidthTablet'         => 60,
				'imageWidthMobile'         => 60,
				'columns'                  => 1,
				'tcolumns'                 => 1,
				'mcolumns'                 => 1,
				'pauseOnHover'             => true,
				'infiniteLoop'             => true,
				'transitionSpeed'          => 500,
				'autoplay'                 => true,
				'autoplaySpeed'            => 2000,
				'arrowDots'                => 'arrows_dots',
				'arrowSize'                => 20,
				'arrowBorderWidth'         => 1,
				'arrowBorderRadius'        => 0,
				'arrowTopRadiusMobile'     => 0,
				'arrowRightRadiusMobile'   => 0,
				'arrowBottomRadiusMobile'  => 0,
				'arrowLeftRadiusMobile'    => 0,
				'arrowTopRadiusTablet'     => 0,
				'arrowRightRadiusTablet'   => 0,
				'arrowBottomRadiusTablet'  => 0,
				'arrowLeftRadiusTablet'    => 0,
				'arrowTopRadius'           => 0,
				'arrowRightRadius'         => 0,
				'arrowBottomRadius'        => 0,
				'arrowLeftRadius'          => 0,
				'arrowBorderColor'         => '',
				'arrowBorderStyle'         => '',
				'rowGap'                   => 10,
				'rowGapMobile'             => 10,
				'rowGapTablet'             => 10,
				'columnGap'                => 10,
				'columnGapMobile'          => 10,
				'columnGapTablet'          => 10,
				'contentPadding'           => 5,
				'contentPaddingMobile'     => 5,
				'contentPaddingTablet'     => 5,
				'backgroundType'           => '',
				'backgroundImage'          => '',
				'backgroundImagePosition'  => 'center center',
				'backgroundImageSize'      => 'cover',
				'backgroundImageRepeat'    => 'no-repeat',
				'backgroundAttachment'     => 'scroll',
				'overlayType'              => '',
				'backgroundColor'          => '',
				'backgroundImageColor'     => '',
				'blockBorderStyle'         => 'none',
				'blockBorderWidth'         => '1',
				'blockBorderRadius'        => '',
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
				'blockBorderColor'         => '',
				'backgroundOpacity'        => 50,
				'arrowColor'               => '#333',
				'stack'                    => 'tablet',
				'blockPadding'             => 45,
				'blockPaddingMobile'       => 45,
				'blockPaddingTablet'       => 45,
				'gradientOverlayType'      => 'linear',
				'gradientOverlayColor1'    => '',
				'gradientOverlayColor2'    => '',
				'gradientOverlayAngle'     => '0',
				'gradientOverlayLocation1' => '0',
				'gradientOverlayLocation2' => '100',
				'backgroundRepeat'         => 'no-repeat', // For compatibility with v1.3.2.
				'backgroundSize'           => 'cover', // For compatibility with v1.3.2.
				'borderStyle'              => 'empty', // For compatibility with v1.3.2.
				'borderColor'              => 'empty', // For compatibility with v1.3.2.
				'borderWidth'              => 999, // For compatibility with v1.3.2.
				'borderRadius'             => 999, // For compatibility with v1.3.2.
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => 45,
				'blockTopPaddingMobile'    => 45,
				'blockTopPaddingTablet'    => 45,
				'blockBottomPadding'       => 45,
				'blockBottomPaddingMobile' => 45,
				'blockBottomPaddingTablet' => 45,
				'blockLeftPadding'         => 45,
				'blockLeftPaddingMobile'   => 45,
				'blockLeftPaddingTablet'   => 45,
				'blockRightPadding'        => 45,
				'blockRightPaddingMobile'  => 45,
				'blockRightPaddingTablet'  => 45,
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'descTypographyColor'      => '#333',
				'nameTypographyColor'      => '#333',
				'companyTypographyColor'   => '#888888',
				'descBottomSpacing'        => 15,
				'descBottomSpacingMobile'  => 15,
				'descBottomSpacingTablet'  => 15,
				'nameBottomSpacing'        => 5,
				'nameBottomSpacingMobile'  => 5,
				'nameBottomSpacingTablet'  => 5,

				'gradientOverlayPosition'  => 'center center',
				'backgroundColor1'         => '',

				'backgroundPositionTablet' => 'center center',
				'backgroundPositionMobile' => 'center center',
				'backgroundPositionFocal'  => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundSizeTablet'     => 'cover',
				'backgroundSizeMobile'     => 'cover',
				'backgroundPosition'       => 'center center',
				'opacity'                  => 20,
				'descTextTransform'        => '',
      			'descFontStyle'            => '',
      			'nameTextTransform'        => '',
      			'nameFontStyle'            => '',
      			'companyTextTransform'     => '',
      			'companyFontStyle'         => '',
			);
		}

		/**
		 * Get Video Popup Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_video_popup_css( $attr, $id ) {
			$defaults = self::get_responsive_block_video_popup_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];
			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$imgopacity  = $attr['opacity'] / 100;
			$playopacity = $attr['butopacity'] / 100;

			$bg_image_with_opacity = '';
			if ( $attr['backgroundImage'] ) {
				$bg_image_with_opacity = 'linear-gradient( to bottom, ' .
					self::hex_to_rgb( $attr['vidBackgroundColor'], $imgopacity ) .
					', ' .
					self::hex_to_rgb( $attr['vidBackgroundColor'], $imgopacity ) .
					'), ' .
					'url(' .
					$attr['backgroundImage'] .
					')';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),

				' .responsive-block-editor-addons-video-popup__wrapper' => array(
					'background-image'           => 'empty' !== $attr['imgURL'] && '' === $attr['backgroundImage'] ? 'url(' . $attr['imgURL'] . ')' : $bg_image_with_opacity, // For compatibility with v1.3.2.
					'background-color'           => self::hex_to_rgb( $attr['vidBackgroundColor'] || '#000000', $imgopacity ),
					'max-width'                  => self::get_css_value( $attr['vidwidth'], 'px' ),
					'height'                     => self::get_css_value( $attr['vidheight'], 'px' ),
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'position'                   => 'relative',
					'z-index'                    => $attr['z_index'],
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
				),
				' .responsive-block-editor-addons-video-popup__wrapper:hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? 
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),

				' .responsive-block-editor-addons-video-popup__play-button svg' => array(
					'width'   => self::get_css_value( $attr['playButtonSize'], 'px' ),
					'height'  => self::get_css_value( $attr['playButtonSize'], 'px' ),
					'fill'    => $attr['playButtonColor'],
					'opacity' => $playopacity,
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-video-popup__wrapper' => array(
					'max-width'                  => self::get_css_value( $attr['vidwidthMobile'], 'px' ),
					'height'                     => self::get_css_value( $attr['vidheightMobile'], 'px' ),
					'z-index'                    => $attr['z_indexMobile'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'        => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-video-popup__wrapper' => array(
					'max-width'                  => self::get_css_value( $attr['vidwidthTablet'], 'px' ),
					'height'                     => self::get_css_value( $attr['vidheightTablet'], 'px' ),
					'z-index'                    => $attr['z_indexTablet'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-video-popup.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for video popup block
		 *
		 * @return array
		 */
		public static function get_responsive_block_video_popup_default_attributes() {
			return array(
				'block_id'                 => '',
				'align'                    => '',
				'videoLink'                => '',
				'videoID'                  => '',
				'borderRadius'             => '',
				'shadow'                   => '',
				'playButtonType'           => 'normal',
				'playButtonColor'          => '',
				'playButtonSize'           => 30,
				'vidwidth'                 => '',
				'vidwidthTablet'           => '',
				'vidwidthMobile'           => '',
				'vidheight'                => '',
				'vidheightTablet'          => '',
				'vidheightMobile'          => '',
				'opacity'                  => 50,
				'imgURL'                   => 'empty', // For compatibility with v1.3.2.
				'imgID'                    => '',
				'imgAlt'                   => '',
				'counterId'                => 1,
				'butopacity'               => 100,
				'blockBorderStyle'         => 'none',
				'blockBorderWidth'         => 1,
				'blockBorderRadius'        => '',
				'blockBorderColor'         => '',
				'boxShadowColor'           => '',
				'boxShadowHOffset'         => 0,
				'boxShadowVOffset'         => 0,
				'boxShadowBlur'            => 0,
				'boxShadowSpread'          => 0,
				'boxShadowPosition'        => 'outset',
				'hoverboxShadowColor'      => '',
				'hoverboxShadowHOffset'    => 0,
				'hoverboxShadowVOffset'    => 0,
				'hoverboxShadowBlur'       => 0,
				'hoverboxShadowSpread'     => 0,
				'hoverboxShadowPosition'   => 'outset',
				'previewBackgroundColor'   => '#000000',
				'hoverEffect'              => '',
				'backgroundImage'          => '',
				'vidBackgroundColor'       => '#000000',
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => '',
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => '',
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
			);
		}

		/**
		 * Get Defaults for advanced column block
		 *
		 * @return array
		 */
		public static function get_responsive_block_advanced_columns_default_attributes() {
			return array(
				'columnGap'                => 'default',
				'widthType'                => 'px',
				'contentWidth'             => 'theme',
				'stack'                    => 'mobile',
				'columns'                  => 2,
				'width'                    => 900,
				'boxTopPadding'            => 10,
				'boxBottomPadding'         => 10,
				'boxLeftPadding'           => 10,
				'boxRightPadding'          => 10,
				'boxTopPaddingTablet'      => '',
				'boxBottomPaddingTablet'   => '',
				'boxLeftPaddingTablet'     => '',
				'boxRightPaddingTablet'    => '',
				'boxTopPaddingMobile'      => '',
				'boxBottomPaddingMobile'   => '',
				'boxLeftPaddingMobile'     => '',
				'boxRightPaddingMobile'    => '',
				'topMargin'                => '',
				'bottomMargin'             => '',
				'topMarginTablet'          => '',
				'bottomMarginTablet'       => '',
				'topMarginMobile'          => '',
				'bottomMarginMobile'       => '',
				'blockBorderStyle'         => 'none',
				'blockBorderWidth'         => 1,
				'blockBorderRadius'        => '',
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
				'blockBorderColor'         => '',
				'boxShadowColor'           => '',
				'boxShadowHOffset'         => 0,
				'boxShadowVOffset'         => 0,
				'boxShadowBlur'            => 0,
				'boxShadowSpread'          => 0,
				'boxShadowPosition'        => 'outset',
				'hoverboxShadowColor'      => '',
				'hoverboxShadowHOffset'    => 0,
				'hoverboxShadowVOffset'    => 0,
				'hoverboxShadowBlur'       => 0,
				'hoverboxShadowSpread'     => 0,
				'hoverboxShadowPosition'   => 'outset',
				'opacity'                  => 20,
				'colorLocation1'           => 0,
				'colorLocation2'           => 100,
				'gradientDirection'        => 90,
				'backgroundType'           => '',
				'backgroundColor'          => '',
				'backgroundColor1'         => '',
				'backgroundColor2'         => '#fff',
				'backgroundImage'          => '',
				'backgroundImagePosition'  => 'center center',
				'backgroundImageSize'      => 'cover',
				'backgroundImageRepeat'    => 'no-repeat',
				'backgroundAttachment'     => 'scroll',
				'backgroundImageColor'     => '',
				'overlayType'              => 'color',
				'gradientOverlayColor1'    => '',
				'gradientOverlayColor2'    => '',
				'gradientOverlayType'      => 'linear',
				'gradientOverlayLocation1' => 0,
				'gradientOverlayLocation2' => 100,
				'gradientOverlayAngle'     => 0,
				'gradientOverlayPosition'  => 'center center',
				'blockAlign'               => 'left',
				'verticalAlign'            => 'flex-start',
				'blockId'                  => '',
				'height'                   => 'normal',
				'customHeight'             => 50,
				'z_index'                  => 1,
				'hideWidgetTablet'         => false,
				'hideWidgetMobile'         => false,
				'hideWidget'               => false,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'backgroundPosition'       => 'center center', // For compatibility with v1.3.2.
				'backgroundRepeat'         => 'no-repeat', // For compatibility with v1.3.2.
				'backgroundSize'           => 'cover', // For compatibility with v1.3.2.
				'topPadding'               => 999, // For compatibility with v1.3.2.
				'bottomPadding'            => 999, // For compatibility with v1.3.2.
				'leftPadding'              => 999, // For compatibility with v1.3.2.
				'rightPadding'             => 999, // For compatibility with v1.3.2.
				'topPaddingMobile'         => 999, // For compatibility with v1.3.2.
				'bottomPaddingMobile'      => 999, // For compatibility with v1.3.2.
				'leftPaddingMobile'        => 999, // For compatibility with v1.3.2.
				'rightPaddingMobile'       => 999, // For compatibility with v1.3.2.
				'topPaddingTablet'         => 999, // For compatibility with v1.3.2.
				'bottomPaddingTablet'      => 999, // For compatibility with v1.3.2.
				'leftPaddingTablet'        => 999, // For compatibility with v1.3.2.
				'rightPaddingTablet'       => 999, // For compatibility with v1.3.2.
				'boxTopMargin'             => '',
				'boxBottomMargin'          => '',
				'boxLeftMargin'            => '',
				'boxRightMargin'           => '',
				'boxTopMarginTablet'       => '',
				'boxBottomMarginTablet'    => '',
				'boxLeftMarginTablet'      => '',
				'boxRightMarginTablet'     => '',
				'boxTopMarginMobile'       => '',
				'boxBottomMarginMobile'    => '',
				'boxLeftMarginMobile'      => '',
				'boxRightMarginMobile'     => '',
				'backgroundPositionMobile' => 'center center',
				'backgroundPositionTablet' => 'center center',
				'backgroundPositionFocal'  => '50% 50%',
				'backgroundPositionFocalMobile' => '50% 50%',
				'backgroundPositionFocalTablet' => '50% 50%',
				'backgroundSizeMobile'     => 'cover',
				'backgroundSizeTablet'     => 'cover',
			);
		}

		/**
		 * Get Defaults for count up block
		 *
		 * @return array
		 */
		public static function get_responsive_block_count_up_default_attributes() {
			return array(
				'block_id'                      => '',
				'countUp'                       => '',
				'count'                         => '',
				'gutter'                        => 'medium',
				'contentAlign'                  => 'center',
				'textColor'                     => '',
				'itemBackgroundColor'           => '',
				'contentFontFamily'             => '',
				'headingFontFamily'             => '',
				'dateFontFamily'                => '',
				'dateLineHeight'                => 1,
				'dateFontWeight'                => '400',
				'dateFontSize'                  => 40,
				'dateFontSizeMobile'            => '',
				'dateFontSizeTablet'            => '',
				'headingLineHeight'             => 1.8,
				'headingFontSize'               => 16,
				'headingFontWeight'             => '900',
				'titleFontWeight'               => 'empty', // For compatibility with v1.3.2.
				'headingFontSizeTablet'         => '',
				'headingFontSizeMobile'         => '',
				'blockBorderRadius'             => '',
				'blockBorderColor'              => '',
				'numColor'                      => '',
				'titleColor'                    => '',
				'titleSpacing'                  => '',
				'numberSpacing'                 => '',
				'descriptionSpacing'            => '',
				'contentLineHeight'             => 1.75,
				'contentFontWeight'             => '400',
				'contentFontSize'               => 16,
				'contentFontSizeMobile'         => '',
				'contentFontSizeTablet'         => '',
				'icon'                          => 'welcome-add-page',
				'resshowIcon'                   => false,
				'resshowTitle'                  => true,
				'resshowDesc'                   => true,
				'blockBorderStyle'              => 'none',
				'blockBorderWidth'              => 1,
				'opacity'                       => 10,
				'icon_color'                    => '#3a3a3a',
				'iconsize'                      => 16,
				'resshowNum'                    => true,
				'titleSpace'                    => 20,
				'titleSpaceTablet'              => '',
				'titleSpaceMobile'              => '',
				'contentSpace'                  => 30,
				'contentSpaceTablet'            => '',
				'contentSpaceMobile'            => '',
				'numSpace'                      => 20,
				'numSpaceMobile'                => '',
				'numSpaceTablet'                => '',
				'iconStyle'                     => 'none',
				'shapeBorderRadius'             => 100,
				'shapeBorderTopRadius'          => 0,
				'shapeBorderRightRadius'        => 0,
				'shapeBorderBottomRadius'       => 0,
				'shapeBorderLeftRadius'         => 0,
				'shapeBorderTopRadiusTablet'    => 0,
				'shapeBorderRightRadiusTablet'  => 0,
				'shapeBorderBottomRadiusTablet' => 0,
				'shapeBorderLeftRadiusTablet'   => 0,
				'shapeBorderTopRadiusMobile'    => 0,
				'shapeBorderRightRadiusMobile'  => 0,
				'shapeBorderBottomRadiusMobile' => 0,
				'shapeBorderLeftRadiusMobile'   => 0,
				'blockTopRadiusMobile'          => 0,
				'blockRightRadiusMobile'        => 0,
				'blockBottomRadiusMobile'       => 0,
				'blockLeftRadiusMobile'         => 0,
				'blockTopRadiusTablet'          => 0,
				'blockRightRadiusTablet'        => 0,
				'blockBottomRadiusTablet'       => 0,
				'blockLeftRadiusTablet'         => 0,
				'blockTopRadius'                => 0,
				'blockRightRadius'              => 0,
				'blockBottomRadius'             => 0,
				'blockLeftRadius'               => 0,
				'shapePadding'                  => 20,
				'shapeBorder'                   => 2,
				'iconShapeColor'                => '#add5ef',
				'contentSpacing'                => 0,
				'contentSpacingMobile'          => '',
				'contentSpacingTablet'          => '',
				'iconSpacing'                   => 16,
				'iconSpacingTablet'             => '',
				'iconSpacingMobile'             => '',
				'hideWidgetMobile'              => false,
				'hideWidgetTablet'              => false,
				'hideWidget'                    => false,
				'z_index'                       => 1,
				'z_indexMobile'                 => 1,
				'z_indexTablet'                 => 1,
				'blockTopPadding'               => '',
				'blockTopPaddingMobile'         => '',
				'blockTopPaddingTablet'         => '',
				'blockBottomPadding'            => '',
				'blockBottomPaddingMobile'      => '',
				'blockBottomPaddingTablet'      => '',
				'blockLeftPadding'              => '',
				'blockLeftPaddingMobile'        => '',
				'blockLeftPaddingTablet'        => '',
				'blockRightPadding'             => '',
				'blockRightPaddingMobile'       => '',
				'blockRightPaddingTablet'       => '',
				'blockTopMargin'                => '',
				'blockTopMarginMobile'          => '',
				'blockTopMarginTablet'          => '',
				'blockBottomMargin'             => '',
				'blockBottomMarginMobile'       => '',
				'blockBottomMarginTablet'       => '',
				'blockLeftMargin'               => '',
				'blockLeftMarginMobile'         => '',
				'blockLeftMarginTablet'         => '',
				'blockRightMargin'              => '',
				'blockRightMarginMobile'        => '',
				'blockRightMarginTablet'        => '',
				'contentTypographyColor'        => '',
				'headingTypographyColor'        => '',
				'dateTypographyColor'           => '',
				'contentAlignTablet'            => 'center',
				'contentAlignMobile'            => 'center',
				'headingTextTransform'          => '',
				'headingFontStyle'              => '',
				'dateTextTransform'             => '',
				'dateFontStyle'                 => '',
				'contentTextTransform'          => '',
				'contentFontStyle'              => '',
			);
		}

		/**
		 * Get Defaults for blockquote block
		 *
		 * @return array
		 */
		public static function get_responsive_block_blockquote_default_attributes() {
			return array(
				'block_id'                 => '',
				'quoteContent'             => '',
				'quoteBackgroundColor'     => '',
				'quoteTextColor'           => '',
				'quoteFontFamily'          => '',
				'quoteFontSize'            => 18,
				'quoteFontWeight'          => '400',
				'quoteLineHeight'          => 1,
				'quoteSize'                => 70,
				'quoteColor'               => '',
				'blockBorderStyle'         => 'none',
				'blockBorderWidth'         => 1,
				'blockBorderRadius'        => 0,
				'blockTopRadiusMobile'     => 0,
				'blockRightRadiusMobile'   => 0,
				'blockBottomRadiusMobile'  => 0,
				'blockLeftRadiusMobile'    => 0,
				'blockTopRadiusTablet'     => 0,
				'blockRightRadiusTablet'   => 0,
				'blockBottomRadiusTablet'  => 0,
				'blockLeftRadiusTablet'    => 0,
				'blockTopRadius'           => 0,
				'blockRightRadius'         => 0,
				'blockBottomRadius'        => 0,
				'blockLeftRadius'          => 0,
				'blockBorderColor'         => '',
				'blockLeftPadding'         => 60,
				'blockRightPadding'        => 60,
				'blockTopPadding'          => 70,
				'blockBottomPadding'       => 70,
				'blockLeftPaddingMobile'   => 60,
				'blockRightPaddingMobile'  => 60,
				'blockTopPaddingMobile'    => 70,
				'blockBottomPaddingMobile' => 70,
				'blockLeftPaddingTablet'   => 60,
				'blockRightPaddingTablet'  => 60,
				'blockTopPaddingTablet'    => 70,
				'blockBottomPaddingTablet' => 70,
				'blockLeftMargin'          => '',
				'blockRightMargin'         => '',
				'blockTopMargin'           => '',
				'blockBottomMargin'        => '',
				'blockLeftMarginMobile'    => '',
				'blockRightMarginMobile'   => '',
				'blockTopMarginMobile'     => '',
				'blockBottomMarginMobile'  => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMarginTablet'   => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMarginTablet'  => '',
				'quoteHposition'           => 30,
				'quoteVposition'           => 20,
				'quoteAlign'               => 'left',
				'quoteOpacity'             => 100,
				'showQuote'                => true,
				'opacity'                  => 100,
				'colorLocation1'           => 0,
				'colorLocation2'           => 100,
				'gradientDirection'        => 90,
				'backgroundImage'          => '',
				'backgroundVideo'          => '',
				'backgroundColor'          => '',
				'backgroundColor1'         => '',
				'backgroundColor2'         => '',
				'backgroundType'           => 'none',
				'icon'                     => 'round-fat',
				'boxShadowColor'           => '#fff',
				'boxShadowHOffset'         => 0,
				'boxShadowVOffset'         => 0,
				'boxShadowBlur'            => 20,
				'boxShadowSpread'          => 20,
				'boxShadowPosition'        => 'outset',
				'hoverboxShadowColor'      => '',
				'hoverboxShadowHOffset'    => 0,
				'hoverboxShadowVOffset'    => 0,
				'hoverboxShadowBlur'       => 0,
				'hoverboxShadowSpread'     => 0,
				'hoverboxShadowPosition'   => 'outset',
				'textTopPadding'           => 60,
				'textTopPaddingMobile'     => 30,
				'textTopPaddingTablet'     => 30,
				'textBottomPadding'        => 0,
				'textBottomPaddingMobile'  => 0,
				'textBottomPaddingTablet'  => 0,
				'textLeftPadding'          => 70,
				'textLeftPaddingMobile'    => 35,
				'textLeftPaddingTablet'    => 35,
				'textRightPadding'         => 70,
				'textRightPaddingMobile'   => 35,
				'textRightPaddingTablet'   => 35,
				'quoteFontSizeMobile'      => '',
				'quoteFontSizeTablet'      => '',
				'z_index'                  => 1,
				'z_indexTablet'            => 1,
				'z_indexMobile'            => 1,
				'borderColor'              => 'empty', // For compatibility with v1.3.2.
				'borderStyle'              => 'empty', // For compatibility with v1.3.2.
				'borderWidth'              => 999, // For compatibility with v1.3.2.
				'topPadding'               => 999, // For compatibility with v1.3.2.
				'bottomPadding'            => 999, // For compatibility with v1.3.2.
				'leftPadding'              => 999, // For compatibility with v1.3.2.
				'rightPadding'             => 999, // For compatibility with v1.3.2.
				'hideWidgetTablet'         => false,
				'hideWidgetMobile'         => false,
				'hideWidget'               => false,
				'quoteTypographyColor'     => '',
				'quoteAlignMobile'         => 'left',
				'quoteAlignTablet'         => 'left',
				'quoteTextTransform'       => '',
        		'quoteFontStyle'           => '',
				// Twitter button attributes
				'twEnabled'                => true,
				'twView'                   => 'both',
				'twStyle'                  => 'classic',
				'twUrlMode'                => 'current',
				'twCustomUrl'              => '',
				'twLabel'                  => 'Post',
				'twColor'                  => '#ffffff',
				'twBg'                     => '#000000',
				'twHColor'                 => '#ffffff',
				'twHBg'                    => '#000000',
				'twTopPadding'             => 10,
				'twRightPadding'           => 16,
				'twBottomPadding'          => 10,
				'twLeftPadding'            => 16,
				'twTopPaddingTablet'       => '',
				'twRightPaddingTablet'     => '',
				'twBottomPaddingTablet'    => '',
				'twLeftPaddingTablet'      => '',
				'twTopPaddingMobile'       => '',
				'twRightPaddingMobile'     => '',
				'twBottomPaddingMobile'    => '',
				'twLeftPaddingMobile'      => '',
				'twIsPaddingControlConnected' => false,
				'twFontFamily'             => '',
				'twFontSize'               => '',
				'twFontSizeTablet'         => '',
				'twFontSizeMobile'         => '',
				'twFontWeight'             => '',
				'twLineHeight'             => '',
				'twTextTransform'          => '',
				'twTextDecoration'         => '',
				'twIconTextSpacing'        => 8,
				'twTypographyColor'        => '',
				'twFontStyle'              => '',
			);
		}

		/**
		 * Get Defaults for divider block
		 *
		 * @return array
		 */
		public static function get_responsive_block_divider_default_attributes() {
			return array(
				'block_id'                 => '',
				'spacerHeight'             => 30,
				'spacerHeightMobile'       => '',
				'spacerHeightTablet'       => '',
				'spacerDivider'            => false,
				'spacerDividerStyle'       => 'solid',
				'spacerDividerColor'       => '#000',
				'spacerDividerHeight'      => 7,
				'spacerDividerWidth'       => 60,
				'spacerDividerAlignment'   => 'center',
				'hideWidgetTablet'         => false,
				'hideWidgetMobile'         => false,
				'hideWidget'               => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'blockTopPadding'          => '',
				'blockTopPaddingMobile'    => '',
				'blockTopPaddingTablet'    => '',
				'blockBottomPadding'       => '',
				'blockBottomPaddingMobile' => '',
				'blockBottomPaddingTablet' => '',
				'blockLeftPadding'         => '',
				'blockLeftPaddingMobile'   => '',
				'blockLeftPaddingTablet'   => '',
				'blockRightPadding'        => '',
				'blockRightPaddingMobile'  => '',
				'blockRightPaddingTablet'  => '',
				'blockTopMargin'           => 30,
				'blockTopMarginMobile'     => '',
				'blockTopMarginTablet'     => '',
				'blockBottomMargin'        => 30,
				'blockBottomMarginMobile'  => '',
				'blockBottomMarginTablet'  => '',
				'blockLeftMargin'          => '',
				'blockLeftMarginMobile'    => '',
				'blockLeftMarginTablet'    => '',
				'blockRightMargin'         => '',
				'blockRightMarginMobile'   => '',
				'blockRightMarginTablet'   => '',
			);
		}

		/**
		 * Get Count Down Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_count_down_css( $attr, $id ) {
			$defaults = self::get_responsive_block_count_down_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'borderRadiusTopLeft' ? 'borderRadiusTopLeft' : 0,
				'blockRightRadius'        => 'borderRadiusTopRight' ? 'borderRadiusTopRight' : 0,
				'blockBottomRadius'       => 'borderRadiusBottomRight' ? 'borderRadiusBottomRight' : 0,
				'blockLeftRadius'         => 'borderRadiusBottomLeft' ? 'borderRadiusBottomLeft' : 0,
				'blockTopRadiusTablet'    => 'borderRadiusTopLeft' ? 'borderRadiusTopLeft' : 0,
				'blockRightRadiusTablet'  => 'borderRadiusTopRight' ? 'borderRadiusTopRight' : 0,
				'blockBottomRadiusTablet' => 'borderRadiusBottomRight' ? 'borderRadiusBottomRight' : 0,
				'blockLeftRadiusTablet'   => 'borderRadiusBottomLeft' ? 'borderRadiusBottomLeft' : 0,
				'blockTopRadiusMobile'    => 'borderRadiusTopLeft' ? 'borderRadiusTopLeft' : 0,
				'blockRightRadiusMobile'  => 'borderRadiusTopRight' ? 'borderRadiusTopRight' : 0,
				'blockBottomRadiusMobile' => 'borderRadiusBottomRight' ? 'borderRadiusBottomRight' : 0,
				'blockLeftRadiusMobile'   => 'borderRadiusBottomLeft' ? 'borderRadiusBottomLeft' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'labelTypographyColor' => 'labelColor' ? 'labelColor' : '#fff',
				'digitTypographyColor' => 'digitColor' ? 'digitColor' : '#fff',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];
			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$display_days    = $attr['showDaysBox'] ? 'block' : 'none';
			$display_hours   = $attr['showHoursBox'] ? 'block' : 'none';
			$display_minutes = $attr['showMinutesBox'] ? 'block' : 'none';
			$display_seconds = $attr['showSecondsBox'] ? 'block' : 'none';

			$flex_column = $attr['stackOnMobile'] ? 'column' : 'row';
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
				),
				' .responsive-block-editor-addons-countdown-box-stylings' => array(
					'height'                     => self::get_css_value( $attr['boxHeight'], 'px' ),
					'width'                      => self::get_css_value( $attr['boxWidth'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['boxMargin'], 'px' ),
					'padding-top'                => 999 !== $attr['boxPaddingTop'] && 0 === $attr['boxTopPadding'] ? self::get_css_value( $attr['boxPaddingTop'], 'px' ) : self::get_css_value( $attr['boxTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['boxPaddingBottom'] && 10 === $attr['boxBottomPadding'] ? self::get_css_value( $attr['boxPaddingBottom'], 'px' ) : self::get_css_value( $attr['boxBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['boxPaddingLeft'] && 0 === $attr['boxLeftPadding'] ? self::get_css_value( $attr['boxPaddingLeft'], 'px' ) : self::get_css_value( $attr['boxLeftPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['boxPaddingRight'] && 0 === $attr['boxRightPadding'] ? self::get_css_value( $attr['boxPaddingRight'], 'px' ) : self::get_css_value( $attr['boxRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'border'                     => $attr['boxBorderSize'] . 'px ' . $attr['boxBorderStyle'] . ' ' . $attr['boxBorderColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'background-color'           => 'empty' !== $attr['boxBackgroundColor'] && '#6EC1E4' === $attr['backgroundColor'] ? $attr['boxBackgroundColor'] : $attr['backgroundColor'], // For compatibility with v1.3.2.
					'box-shadow'                 => $attr['boxShadowHOffset'] . 'px ' . $attr['boxShadowVOffset'] . 'px ' . $attr['boxShadowBlur'] . 'px ' . $attr['boxShadowSpread'] . 'px ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
				),
				' .responsive-block-editor-addons-countdown-box-stylings:hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? $attr['hoverboxShadowHOffset'] . 'px ' . $attr['hoverboxShadowVOffset'] . 'px ' . $attr['hoverboxShadowBlur'] . 'px ' . $attr['hoverboxShadowSpread'] . 'px ' . $attr['hoverboxShadowColor'] . ' ' . $hover_box_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-countdown-box-stylings:first-of-type' => array(
					'margin-left' => '0px !important',
				),
				' .responsive-block-editor-addons-countdown-digits' => array(
					'font-family'     => $attr['digitFontFamily'],
					'font-size'       => self::get_css_value( $attr['digitFontSize'], 'px' ),
					'font-weight'     => $attr['digitFontWeight'],
					'letter-spacing'  => self::get_css_value( $attr['digitLetterSpacing'], 'px' ),
					'line-height'     => $attr['digitLineHeight'],
					'color'           => $attr['digitTypographyColor'],
					'display'         => $attr['displayInline'] ? 'flex' : 'block',
					'flex'            => $attr['displayInline'] ? 1 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-end' : null,
					"text-transform"  => $attr['digitTextTransform'],
      				"font-style"      => $attr['digitFontStyle'],
				),
				' .responsive-block-editor-addons-countdown-label' => array(
					'font-family'     => $attr['labelFontFamily'],
					'font-size'       => self::get_css_value( $attr['labelFontSize'], 'px' ),
					'font-weight'     => $attr['labelFontWeight'],
					'line-height'     => $attr['labelLineHeight'],
					'padding-left'    => $attr['displayInline'] ? self::get_css_value( $attr['labelLeftPadding'], 'px' ) : '0px',
					'letter-spacing'  => self::get_css_value( $attr['labelLetterSpacing'], 'px' ),
					'color'           => $attr['labelTypographyColor'],
					'display'         => $attr['showDigitLabels'] ? ( $attr['displayInline'] ? 'flex' : 'block' ) : 'none',
					'flex'            => $attr['displayInline'] ? 1 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-start' : null,
					"text-transform"  => $attr['labelTextTransform'],
					"font-style"      => $attr['labelFontStyle'],
				),
				' .responsive-block-editor-addons-countdown-box-margins' => array(
					'margin-top'      => self::get_css_value( $attr['boxItemMarginTop'], 'px' ),
					'margin-right'    => self::get_css_value( $attr['boxItemMarginRight'], 'px' ),
					'margin-bottom'   => self::get_css_value( $attr['boxItemMarginBottom'], 'px' ),
					'margin-left'     => self::get_css_value( $attr['boxItemMarginLeft'], 'px' ),
					'text-align'      => $attr['boxItemTextAlign'],
					'display'         => $attr['displayInline'] ? 'flex' : null,
					'justify-content' => $attr['displayInline'] ? 'center' : null,
					'align-items'     => $attr['displayInline'] ? 'center' : null,
				),
				'.responsive-block-editor-addons-countdown-wrapper' => array(
					'margin-top'     => 999 !== $attr['containerMarginTop'] && 0 === $attr['containerTopMargin'] ? self::get_css_value( $attr['containerMarginTop'], 'px' ) : self::get_css_value( $attr['containerTopMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'   => 999 !== $attr['containerMarginRight'] && 0 === $attr['containerRightMargin'] ? self::get_css_value( $attr['containerMarginRight'], 'px' ) : self::get_css_value( $attr['containerRightMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'  => 999 !== $attr['containerMarginBottom'] && 0 === $attr['containerBottomMargin'] ? self::get_css_value( $attr['containerMarginBottom'], 'px' ) : self::get_css_value( $attr['containerBottomMargin'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'    => 999 !== $attr['containerMarginLeft'] && 0 === $attr['containerLeftMargin'] ? self::get_css_value( $attr['containerMarginLeft'], 'px' ) : self::get_css_value( $attr['containerLeftMargin'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'    => 999 !== $attr['containerPaddingTop'] && 0 === $attr['containerTopPadding'] ? self::get_css_value( $attr['containerPaddingTop'], 'px' ) : self::get_css_value( $attr['containerTopPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['containerPaddingRight'] && 0 === $attr['containerRightPadding'] ? self::get_css_value( $attr['containerPaddingRight'], 'px' ) : self::get_css_value( $attr['containerRightPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['containerPaddingBottom'] && 0 === $attr['containerBottomPadding'] ? self::get_css_value( $attr['containerPaddingBottom'], 'px' ) : self::get_css_value( $attr['containerBottomPadding'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['containerPaddingLeft'] && 0 === $attr['containerLeftPadding'] ? self::get_css_value( $attr['containerPaddingLeft'], 'px' ) : self::get_css_value( $attr['containerLeftPadding'], 'px' ), // For compatibility with v1.3.2.
				),
				' .responsive-block-editor-addons-countdown-container .responsive-block-editor-addons-countdown-items' => array(
					'justify-content' => $attr['justifyItems'],
					'margin'          => 0,
				),
				' .responsive-block-editor-addons-countdown-get-date' => array(
					'display' => 'none',
				),
				' .responsive-block-editor-addons-countdown-item.responsive-block-editor-addons-countdown-item-days' => array(
					'display' => $display_days,
				),
				' .responsive-block-editor-addons-countdown-item.responsive-block-editor-addons-countdown-item-hours' => array(
					'display' => $display_hours,
				),
				' .responsive-block-editor-addons-countdown-item.responsive-block-editor-addons-countdown-item-minutes' => array(
					'display' => $display_minutes,
				),
				' .responsive-block-editor-addons-countdown-item.responsive-block-editor-addons-countdown-item-seconds' => array(
					'display' => $display_seconds,
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
				),
				' .responsive-block-editor-addons-countdown-box-stylings' => array(
					'height'                     => self::get_css_value( $attr['boxHeightMobile'], 'px' ),
					'width'                      => true === $attr['stackOnMobile'] ? '100%' : self::get_css_value( $attr['boxWidthMobile'], 'px' ),
					'margin-left'                => true === $attr['stackOnMobile'] ? '0px' : self::get_css_value( $attr['boxMarginMobile'], 'px' ),
					'margin-bottom'              => true === $attr['stackOnMobile'] ? self::get_css_value( $attr['boxMarginMobile'], 'px' ) : '0px',
					'padding-top'                => 999 !== $attr['boxPaddingTopMobile'] && '' === $attr['boxTopPaddingMobile'] ? self::get_css_value( $attr['boxPaddingTopMobile'], 'px' ) : self::get_css_value( $attr['boxTopPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['boxPaddingBottomMobile'] && '' === $attr['boxBottomPaddingMobile'] ? self::get_css_value( $attr['boxPaddingBottomMobile'], 'px' ) : self::get_css_value( $attr['boxBottomPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['boxPaddingLeftMobile'] && '' === $attr['boxLeftPaddingMobile'] ? self::get_css_value( $attr['boxPaddingLeftMobile'], 'px' ) : self::get_css_value( $attr['boxLeftPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['boxPaddingRightMobile'] && '' === $attr['boxRightPaddingMobile'] ? self::get_css_value( $attr['boxPaddingRightMobile'], 'px' ) : self::get_css_value( $attr['boxRightPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'border'                     => $attr['boxBorderSize'] . 'px ' . $attr['boxBorderStyle'] . ' ' . $attr['boxBorderColor'],
					'border-radius'              => $attr['borderRadiusTopLeft'] . 'px ' . $attr['borderRadiusTopRight'] . 'px ' . $attr['borderRadiusBottomRight'] . 'px ' . $attr['borderRadiusBottomLeft'] . 'px',
					'background-color'           => 'empty' !== $attr['boxBackgroundColor'] && '#6EC1E4' === $attr['backgroundColor'] ? $attr['boxBackgroundColor'] : $attr['backgroundColor'], // For compatibility with v1.3.2.
					'box-shadow'                 => $attr['boxShadowHOffset'] . 'px ' . $attr['boxShadowVOffset'] . 'px ' . $attr['boxShadowBlur'] . 'px ' . $attr['boxShadowSpread'] . 'px ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-countdown-box-stylings:first-of-type' => array(
					'margin-left' => true === $attr['stackOnMobile'] ? '' : '0px !important',
				),
				' .responsive-block-editor-addons-countdown-box-stylings:last-of-type' => array(
					'margin-bottom' => true === $attr['stackOnMobile'] ? '0px !important' : '',
				),
				' .responsive-block-editor-addons-countdown-digits' => array(
					'font-family'     => $attr['digitFontFamily'],
					'font-size'       => self::get_css_value( $attr['digitFontSizeMobile'], 'px' ),
					'font-weight'     => $attr['digitFontWeight'],
					'letter-spacing'  => self::get_css_value( $attr['digitLetterSpacing'], 'px' ),
					'line-height'     => $attr['digitLineHeight'],
					'color'           => $attr['digitTypographyColor'],
					'display'         => $attr['displayInline'] ? 'flex' : 'block',
					'flex'            => $attr['displayInline'] ? 1 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-end' : null,
				),
				' .responsive-block-editor-addons-countdown-label' => array(
					'font-family'     => $attr['labelFontFamily'],
					'font-size'       => self::get_css_value( $attr['labelFontSizeMobile'], 'px' ),
					'font-weight'     => $attr['labelFontWeight'],
					'line-height'     => $attr['labelLineHeight'],
					'padding-left'    => $attr['displayInline'] ? self::get_css_value( $attr['labelLeftPadding'], 'px' ) : '0px',
					'letter-spacing'  => self::get_css_value( $attr['labelLetterSpacing'], 'px' ),
					'color'           => $attr['labelTypographyColor'],
					'flex'            => $attr['displayInline'] ? 1.5 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-start' : null,
				),
				' .responsive-block-editor-addons-countdown-box-margins' => array(
					'margin-top'    => self::get_css_value( $attr['boxItemMarginTopMobile'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['boxItemMarginRightMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['boxItemMarginBottomMobile'], 'px' ),
					'margin-left'   => self::get_css_value( $attr['boxItemMarginLeftMobile'], 'px' ),
				),
				'.responsive-block-editor-addons-countdown-wrapper' => array(
					'margin-top'     => 999 !== $attr['containerMarginTopMobile'] && '' === $attr['containerTopMarginMobile'] ? self::get_css_value( $attr['containerMarginTopMobile'], 'px' ) : self::get_css_value( $attr['containerTopMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'   => 999 !== $attr['containerMarginRightMobile'] && '' === $attr['containerRightMarginMobile'] ? self::get_css_value( $attr['containerMarginRightMobile'], 'px' ) : self::get_css_value( $attr['containerRightMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'  => 999 !== $attr['containerMarginBottomMobile'] && '' === $attr['containerBottomMarginMobile'] ? self::get_css_value( $attr['containerMarginBottomMobile'], 'px' ) : self::get_css_value( $attr['containerBottomMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'    => 999 !== $attr['containerMarginLeftMobile'] && '' === $attr['containerLeftMarginMobile'] ? self::get_css_value( $attr['containerMarginLeftMobile'], 'px' ) : self::get_css_value( $attr['containerLeftMarginMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'    => 999 !== $attr['containerPaddingTopMobile'] && '' === $attr['containerTopPaddingMobile'] ? self::get_css_value( $attr['containerPaddingTopMobile'], 'px' ) : self::get_css_value( $attr['containerTopPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['containerPaddingRightMobile'] && '' === $attr['containerRightPaddingMobile'] ? self::get_css_value( $attr['containerPaddingRightMobile'], 'px' ) : self::get_css_value( $attr['containerRightPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['containerPaddingBottomMobile'] && '' === $attr['containerBottomPaddingMobile'] ? self::get_css_value( $attr['containerPaddingBottomMobile'], 'px' ) : self::get_css_value( $attr['containerBottomPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['containerPaddingLeftMobile'] && '' === $attr['containerLeftPaddingMobile'] ? self::get_css_value( $attr['containerPaddingLeftMobile'], 'px' ) : self::get_css_value( $attr['containerLeftPaddingMobile'], 'px' ), // For compatibility with v1.3.2.
				),
				' .responsive-block-editor-addons-countdown-container .responsive-block-editor-addons-countdown-items' => array(
					'flex-direction' => $flex_column,
					'align-items'    => 'center',
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
				),
				' .responsive-block-editor-addons-countdown-box-stylings' => array(
					'height'                     => self::get_css_value( $attr['boxHeightTablet'], 'px' ),
					'width'                      => self::get_css_value( $attr['boxWidthTablet'], 'px' ),
					'margin-left'                => self::get_css_value( $attr['boxMarginTablet'], 'px' ),
					'padding-top'                => 999 !== $attr['boxPaddingTopTablet'] && '' === $attr['boxTopPaddingTablet'] ? self::get_css_value( $attr['boxPaddingTopTablet'], 'px' ) : self::get_css_value( $attr['boxTopPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom'             => 999 !== $attr['boxPaddingBottomTablet'] && '' === $attr['boxBottomPaddingTablet'] ? self::get_css_value( $attr['boxPaddingBottomTablet'], 'px' ) : self::get_css_value( $attr['boxBottomPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'               => 999 !== $attr['boxPaddingLeftTablet'] && '' === $attr['boxLeftPaddingTablet'] ? self::get_css_value( $attr['boxPaddingLeftTablet'], 'px' ) : self::get_css_value( $attr['boxLeftPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'              => 999 !== $attr['boxPaddingRightTablet'] && '' === $attr['boxRightPaddingTablet'] ? self::get_css_value( $attr['boxPaddingRightTablet'], 'px' ) : self::get_css_value( $attr['boxRightPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'border'                     => $attr['boxBorderSize'] . 'px ' . $attr['boxBorderStyle'] . ' ' . $attr['boxBorderColor'],
					'border-radius'              => $attr['borderRadiusTopLeft'] . 'px ' . $attr['borderRadiusTopRight'] . 'px ' . $attr['borderRadiusBottomRight'] . 'px ' . $attr['borderRadiusBottomLeft'] . 'px',
					'background-color'           => 'empty' !== $attr['boxBackgroundColor'] && '#6EC1E4' === $attr['backgroundColor'] ? $attr['boxBackgroundColor'] : $attr['backgroundColor'], // For compatibility with v1.3.2.
					'box-shadow'                 => $attr['boxShadowHOffset'] . 'px ' . $attr['boxShadowVOffset'] . 'px ' . $attr['boxShadowBlur'] . 'px ' . $attr['boxShadowSpread'] . 'px ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),

				' .responsive-block-editor-addons-countdown-digits' => array(
					'font-family'     => $attr['digitFontFamily'],
					'font-size'       => self::get_css_value( $attr['digitFontSizeTablet'], 'px' ),
					'font-weight'     => $attr['digitFontWeight'],
					'letter-spacing'  => self::get_css_value( $attr['digitLetterSpacing'], 'px' ),
					'line-height'     => $attr['digitLineHeight'],
					'color'           => $attr['digitTypographyColor'],
					'display'         => $attr['displayInline'] ? 'flex' : 'block',
					'flex'            => $attr['displayInline'] ? 1 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-end' : null,
				),

				' .responsive-block-editor-addons-countdown-label' => array(
					'font-family'     => $attr['labelFontFamily'],
					'font-size'       => self::get_css_value( $attr['labelFontSizeTablet'], 'px' ),
					'font-weight'     => $attr['labelFontWeight'],
					'line-height'     => $attr['labelLineHeight'],
					'padding-left'    => $attr['displayInline'] ? self::get_css_value( $attr['labelLeftPadding'], 'px' ) : '0px',
					'letter-spacing'  => self::get_css_value( $attr['labelLetterSpacing'], 'px' ),
					'color'           => $attr['labelTypographyColor'],
					'flex'            => $attr['displayInline'] ? 1 : null,
					'justify-content' => $attr['displayInline'] ? 'flex-start' : null,
				),
				' .responsive-block-editor-addons-countdown-box-margins' => array(
					'margin-top'    => self::get_css_value( $attr['boxItemMarginTopTablet'], 'px' ),
					'margin-right'  => self::get_css_value( $attr['boxItemMarginRightTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['boxItemMarginBottomTablet'], 'px' ),
					'margin-left'   => self::get_css_value( $attr['boxItemMarginLeftTablet'], 'px' ),
				),
				'.responsive-block-editor-addons-countdown-wrapper' => array(
					'margin-top'     => 999 !== $attr['containerMarginTopTablet'] && '' === $attr['containerTopMarginTablet'] ? self::get_css_value( $attr['containerMarginTopTablet'], 'px' ) : self::get_css_value( $attr['containerTopMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-right'   => 999 !== $attr['containerMarginRightTablet'] && '' === $attr['containerRightMarginTablet'] ? self::get_css_value( $attr['containerMarginRightTablet'], 'px' ) : self::get_css_value( $attr['containerRightMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-bottom'  => 999 !== $attr['containerMarginBottomTablet'] && '' === $attr['containerBottomMarginTablet'] ? self::get_css_value( $attr['containerMarginBottomTablet'], 'px' ) : self::get_css_value( $attr['containerBottomMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'margin-left'    => 999 !== $attr['containerMarginLeftTablet'] && '' === $attr['containerLeftMarginTablet'] ? self::get_css_value( $attr['containerMarginLeftTablet'], 'px' ) : self::get_css_value( $attr['containerLeftMarginTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-top'    => 999 !== $attr['containerPaddingTopTablet'] && '' === $attr['containerTopPaddingTablet'] ? self::get_css_value( $attr['containerPaddingTopTablet'], 'px' ) : self::get_css_value( $attr['containerTopPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-right'  => 999 !== $attr['containerPaddingRightTablet'] && '' === $attr['containerRightPaddingTablet'] ? self::get_css_value( $attr['containerPaddingRightTablet'], 'px' ) : self::get_css_value( $attr['containerRightPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-bottom' => 999 !== $attr['containerPaddingBottomTablet'] && '' === $attr['containerBottomPaddingTablet'] ? self::get_css_value( $attr['containerPaddingBottomTablet'], 'px' ) : self::get_css_value( $attr['containerBottomPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
					'padding-left'   => 999 !== $attr['containerPaddingLeftTablet'] && '' === $attr['containerLeftPaddingTablet'] ? self::get_css_value( $attr['containerPaddingLeftTablet'], 'px' ) : self::get_css_value( $attr['containerLeftPaddingTablet'], 'px' ), // For compatibility with v1.3.2.
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-count-down.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for count down block
		 *
		 * @return array
		 */
		public static function get_responsive_block_count_down_default_attributes() {
			return array(
				'block_id'                     => '',
				'date'                         => '',
				'days'                         => '0',
				'hours'                        => '0',
				'minutes'                      => '0',
				'seconds'                      => '0',
				'digitDaysLabel'               => 'Days',
				'digitHoursLabel'              => 'Hours',
				'digitMinutesLabel'            => 'Minutes',
				'digitSecondsLabel'            => 'Seconds',
				'showDigitLabels'              => true,
				'showDaysBox'                  => true,
				'showHoursBox'                 => true,
				'showMinutesBox'               => true,
				'showSecondsBox'               => true,
				'digitFontFamily'              => '',
				'digitFontSize'                => 48,
				'digitFontSizeMobile'          => '',
				'digitFontSizeTablet'          => '',
				'digitFontWeight'              => '500',
				'digitLetterSpacing'           => 0,
				'digitLineHeight'              => 2,
				'digitColor'                   => '#fff',
				'labelFontFamily'              => '',
				'labelFontSize'                => 14,
				'labelFontSizeMobile'          => '',
				'labelFontSizeTablet'          => '',
				'labelColor'                   => '#fff',
				'labelLineHeight'              => 2,
				'labelFontWeight'              => '500',
				'labelLeftPadding'             => 0,
				'labelLetterSpacing'           => 0,
				'boxItemMarginTop'             => 0,
				'boxItemMarginRight'           => 0,
				'boxItemMarginBottom'          => 0,
				'boxItemMarginLeft'            => 0,
				'boxItemMarginTopTablet'       => 0,
				'boxItemMarginRightTablet'     => 0,
				'boxItemMarginBottomTablet'    => 0,
				'boxItemMarginLeftTablet'      => 0,
				'boxItemMarginTopMobile'       => 0,
				'boxItemMarginRightMobile'     => 0,
				'boxItemMarginBottomMobile'    => 0,
				'boxItemMarginLeftMobile'      => 0,
				'boxItemTextAlign'             => 'center',
				'boxHeight'                    => '',
				'boxWidth'                     => 140,
				'boxMargin'                    => 10,
				'boxHeightMobile'              => '',
				'boxWidthMobile'               => 80,
				'boxMarginMobile'              => '',
				'boxHeightTablet'              => '',
				'boxWidthTablet'               => 140,
				'boxMarginTablet'              => '',
				'boxTopPadding'                => 0,
				'boxRightPadding'              => 0,
				'boxBottomPadding'             => 10,
				'boxLeftPadding'               => 0,
				'boxTopPaddingMobile'          => '',
				'boxRightPaddingMobile'        => '',
				'boxBottomPaddingMobile'       => '',
				'boxLeftPaddingMobile'         => '',
				'boxTopPaddingTablet'          => '',
				'boxRightPaddingTablet'        => '',
				'boxBottomPaddingTablet'       => '',
				'boxLeftPaddingTablet'         => '',
				'showBoxBorder'                => true,
				'boxBorderColor'               => '000',
				'boxBorderSize'                => 0,
				'boxBorderStyle'               => 'solid',
				'borderRadiusTopLeft'          => 0,
				'borderRadiusTopRight'         => 0,
				'borderRadiusBottomRight'      => 0,
				'borderRadiusBottomLeft'       => 0,
				'blockTopRadiusMobile'         => 0,
				'blockRightRadiusMobile'       => 0,
				'blockBottomRadiusMobile'      => 0,
				'blockLeftRadiusMobile'        => 0,
				'blockTopRadiusTablet'         => 0,
				'blockRightRadiusTablet'       => 0,
				'blockBottomRadiusTablet'      => 0,
				'blockLeftRadiusTablet'        => 0,
				'blockTopRadius'               => 0,
				'blockRightRadius'             => 0,
				'blockBottomRadius'            => 0,
				'blockLeftRadius'              => 0,
				'showBoxShadow'                => true,
				'boxShadowHOffset'             => 0,
				'boxShadowVOffset'             => 0,
				'boxShadowBlur'                => 0,
				'boxShadowPosition'            => 'outset',
				'boxShadowSpread'              => 0,
				'boxShadowColor'               => '',
				'hoverboxShadowHOffset'        => 0,
				'hoverboxShadowVOffset'        => 0,
				'hoverboxShadowBlur'           => 0,
				'hoverboxShadowPosition'       => 'outset',
				'hoverboxShadowSpread'         => 0,
				'hoverboxShadowColor'          => '',
				'backgroundColor'              => '#6EC1E4',
				'containerTopMargin'           => '',
				'containerRightMargin'         => '',
				'containerBottomMargin'        => '',
				'containerLeftMargin'          => '',
				'containerTopPadding'          => '',
				'containerRightPadding'        => '',
				'containerBottomPadding'       => '',
				'containerLeftPadding'         => '',
				'containerTopMarginTablet'     => '',
				'containerRightMarginTablet'   => '',
				'containerBottomMarginTablet'  => '',
				'containerLeftMarginTablet'    => '',
				'containerTopPaddingTablet'    => '',
				'containerRightPaddingTablet'  => '',
				'containerBottomPaddingTablet' => '',
				'containerLeftPaddingTablet'   => '',
				'containerTopMarginMobile'     => '',
				'containerRightMarginMobile'   => '',
				'containerBottomMarginMobile'  => '',
				'containerLeftMarginMobile'    => '',
				'containerTopPaddingMobile'    => '',
				'containerRightPaddingMobile'  => '',
				'containerBottomPaddingMobile' => '',
				'containerLeftPaddingMobile'   => '',
				'z_index'                      => 1,
				'z_indexMobile'                => 1,
				'z_indexTablet'                => 1,
				'justifyItems'                 => 'center',
				'displayInline'                => false,
				'stackOnMobile'                => false,
				'boxPaddingTop'                => 999, // For compatibility with v1.3.2.
				'boxPaddingBottom'             => 999, // For compatibility with v1.3.2.
				'boxPaddingLeft'               => 999, // For compatibility with v1.3.2.
				'boxPaddingRight'              => 999, // For compatibility with v1.3.2.
				'boxPaddingTopMobile'          => 999, // For compatibility with v1.3.2.
				'boxPaddingBottomMobile'       => 999, // For compatibility with v1.3.2.
				'boxPaddingLeftMobile'         => 999, // For compatibility with v1.3.2.
				'boxPaddingRightMobile'        => 999, // For compatibility with v1.3.2.
				'boxPaddingTopTablet'          => 999, // For compatibility with v1.3.2.
				'boxPaddingBottomTablet'       => 999, // For compatibility with v1.3.2.
				'boxPaddingLeftTablet'         => 999, // For compatibility with v1.3.2.
				'boxPaddingRightTablet'        => 999, // For compatibility with v1.3.2.
				'containerMarginTop'           => 999, // For compatibility with v1.3.2.
				'containerMarginTopMobile'     => 999, // For compatibility with v1.3.2.
				'containerMarginTopTablet'     => 999, // For compatibility with v1.3.2.
				'containerMarginBottom'        => 999, // For compatibility with v1.3.2.
				'containerMarginBottomMobile'  => 999, // For compatibility with v1.3.2.
				'containerMarginBottomTablet'  => 999, // For compatibility with v1.3.2.
				'containerMarginLeft'          => 999, // For compatibility with v1.3.2.
				'containerMarginLeftMobile'    => 999, // For compatibility with v1.3.2.
				'containerMarginLeftTablet'    => 999, // For compatibility with v1.3.2.
				'containerMarginRight'         => 999, // For compatibility with v1.3.2.
				'containerMarginRightMobile'   => 999, // For compatibility with v1.3.2.
				'containerMarginRightTablet'   => 999, // For compatibility with v1.3.2.
				'containerPaddingTop'          => 999, // For compatibility with v1.3.2.
				'containerPaddingTopMobile'    => 999, // For compatibility with v1.3.2.
				'containerPaddingTopTablet'    => 999, // For compatibility with v1.3.2.
				'containerPaddingBottom'       => 999, // For compatibility with v1.3.2.
				'containerPaddingBottomMobile' => 999, // For compatibility with v1.3.2.
				'containerPaddingBottomTablet' => 999, // For compatibility with v1.3.2.
				'containerPaddingLeft'         => 999, // For compatibility with v1.3.2.
				'containerPaddingLeftMobile'   => 999, // For compatibility with v1.3.2.
				'containerPaddingLeftTablet'   => 999, // For compatibility with v1.3.2.
				'containerPaddingRight'        => 999, // For compatibility with v1.3.2.
				'containerPaddingRightMobile'  => 999, // For compatibility with v1.3.2.
				'containerPaddingRightTablet'  => 999, // For compatibility with v1.3.2.
				'boxBackgroundColor'           => 'empty', // For compatibility with v1.3.2.
				'hideWidgetMobile'             => false,
				'hideWidgetTablet'             => false,
				'hideWidget'                   => false,
				'labelTypographyColor'         => '#fff',
				'digitTypographyColor'         => '#fff',
				'digitTextTransform'           => '',
				'digitFontStyle'               => '',
				'labelTextTransform'           => '',
				'labelFontStyle'               => '',
			);
		}

		/**
		 * Get Table Of Contents Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_table_of_contents_css( $attr, $id ) {
			$defaults = self::get_responsive_block_table_of_contents_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );
			?>
			<script>
				( function( $ ) {

					RBEATableOfContents = {

						init: function() {
							$( document ).on( "click",'.responsive-block-editor-addons-toc__title-wrap', RBEATableOfContents._toggleCollapse )
						},

						_toggleCollapse: function( e ) {
							if ( $( this ).find( '.responsive-block-editor-addons-toc__collapsible-wrap' ).length > 0 ) {
								let $root = $(this).closest(
  '.responsive-block-editor-addons-block-table-of-contents'
);
								if ( $root.hasClass( 'responsive-block-editor-addons-toc__collapse' ) ) {
									$root.removeClass( 'responsive-block-editor-addons-toc__collapse' );
								} else {
									$root.addClass( 'responsive-block-editor-addons-toc__collapse' );
								}
							}
						},

						_run: function( attr, id ) {
							var $this_scope = $( id );
							if ( $this_scope.find( '.responsive-block-editor-addons-toc__collapsible-wrap' ).length > 0 ) {
								$this_scope.find( '.responsive-block-editor-addons-toc__title-wrap' ).addClass( 'responsive-block-editor-addons-toc__is-collapsible' );
							}
						},
					}

					$( document ).ready(function() {
						RBEATableOfContents.init()
						RBEATableOfContents._run( <?php echo wp_json_encode( $attr ); ?>, '<?php echo esc_attr( $id ); ?>' );
					})
				})( jQuery )
			</script>
			<?php

			// Frontend Backward Compatibility For Border Radius
			$new_border_radius_keys = array(
				'headingBorderTopRadius'          => 'headingBorderTopLeftRadius' ? 'headingBorderTopLeftRadius' : 0,
				'headingBorderRightRadius'        => 'headingBorderTopRightRadius' ? 'headingBorderTopRightRadius' : 0,
				'headingBorderLeftRadius'         => 'headingBorderBottomLeftRadius' ? 'headingBorderBottomLeftRadius' : 0,
				'headingBorderBottomRadius'       => 'headingBorderBottomRightRadius' ? 'headingBorderBottomRightRadius' : 0,
				'headingBorderTopRadiusTablet'    => 'headingBorderTopLeftRadiusTablet' ? 'headingBorderTopLeftRadiusTablet' : 0,
				'headingBorderRightRadiusTablet'  => 'headingBorderTopRightRadiusTablet' ? 'headingBorderTopRightRadiusTablet' : 0,
				'headingBorderLeftRadiusTablet'   => 'headingBorderBottomLeftRadiusTablet' ? 'headingBorderBottomLeftRadiusTablet' : 0,
				'headingBorderBottomRadiusTablet' => 'headingBorderBottomRightRadiusTablet' ? 'headingBorderBottomRightRadiusTablet' : 0,
				'headingBorderTopRadiusMobile'    => 'headingBorderTopLeftRadiusMobile' ? 'headingBorderTopLeftRadiusMobile' : 0,
				'headingBorderRightRadiusMobile'  => 'headingBorderTopRightRadiusMobile' ? 'headingBorderTopRightRadiusMobile' : 0,
				'headingBorderLeftRadiusMobile'   => 'headingBorderBottomLeftRadiusMobile' ? 'headingBorderBottomLeftRadiusMobile' : 0,
				'headingBorderBottomRadiusMobile' => 'headingBorderBottomRightRadiusMobile' ? 'headingBorderBottomRightRadiusMobile' : 0,
				'bodyBorderTopRadius'             => 'bodyBorderTopLeftRadius' ? 'bodyBorderTopLeftRadius' : 0,
				'bodyBorderRightRadius'           => 'bodyBorderTopRightRadius' ? 'bodyBorderTopRightRadius' : 0,
				'bodyBorderLeftRadius'            => 'bodyBorderBottomLeftRadius' ? 'bodyBorderBottomLeftRadius' : 0,
				'bodyBorderBottomRadius'          => 'bodyBorderBottomRightRadius' ? 'bodyBorderBottomRightRadius' : 0,
				'bodyBorderTopRadiusTablet'       => 'bodyBorderTopLeftRadiusTablet' ? 'bodyBorderTopLeftRadiusTablet' : 0,
				'bodyBorderRightRadiusTablet'     => 'bodyBorderTopRightRadiusTablet' ? 'bodyBorderTopRightRadiusTablet' : 0,
				'bodyBorderLeftRadiusTablet'      => 'bodyBorderBottomLeftRadiusTablet' ? 'bodyBorderBottomLeftRadiusTablet' : 0,
				'bodyBorderBottomRadiusTablet'    => 'bodyBorderBottomRightRadiusTablet' ? 'bodyBorderBottomRightRadiusTablet' : 0,
				'bodyBorderTopRadiusMobile'       => 'bodyBorderTopLeftRadiusMobile' ? 'bodyBorderTopLeftRadiusMobile' : 0,
				'bodyBorderRightRadiusMobile'     => 'bodyBorderTopRightRadiusMobile' ? 'bodyBorderTopRightRadiusMobile' : 0,
				'bodyBorderLeftRadiusMobile'      => 'bodyBorderBottomLeftRadiusMobile' ? 'bodyBorderBottomLeftRadiusMobile' : 0,
				'bodyBorderBottomRadiusMobile'    => 'bodyBorderBottomRightRadiusMobile' ? 'bodyBorderBottomRightRadiusMobile' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$justify_content = 'flex-start';
			if ( 'center' === $attr['align'] ) {
				$justify_content = 'center';
			} elseif ( 'right' === $attr['align'] ) {
				$justify_content = 'flex-end';
			}

			$updated_background_image = '';
			if ( $attr['backgroundImage'] ) {
				$updated_background_image = 'linear-gradient(' .
				self::hex_to_rgb( '#fff', 0 ) .
				',' .
				self::hex_to_rgb( '#fff', 0 ) .
				'),url(' .
				$attr['backgroundImage'] .
				')';
			}
			if ( 'image' !== $attr['backgroundType'] ) {
				$updated_background_image = '';
			}

			$background_position_focal        = self::get_background_position( $attr['backgroundPosition'] );
			$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionTablet'] );
			$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionMobile'] );

			if ( isset( $attr['hasImagePositionMigrated'] ) && $attr['hasImagePositionMigrated'] ) {
				$background_position_focal        = self::get_background_position( $attr['backgroundPositionFocal'] );
				$background_position_focal_tablet = self::get_background_position( $attr['backgroundPositionFocalTablet'] );
				$background_position_focal_mobile = self::get_background_position( $attr['backgroundPositionFocalMobile'] );
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'             => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'background-image'    => $updated_background_image,
					'z-index'             => $attr['z_index'],
					'background-position' => $background_position_focal,
					'background-repeat'   => $attr['backgroundRepeat'],
					'background-size'     => $attr['backgroundSize'],
					'background-color'    => 'color' === $attr['backgroundType'] ? self::hex_to_rgb(
						$attr['backgroundColor'],
						1
					) : null,
				),
				' .responsive-block-editor-addons-toc__title-wrap' => array(
					'justify-content'            => $justify_content,
					'font-family'                => $attr['headingFontFamily'],
					'font-weight'                => $attr['headingFontWeight'],
					'font-size'                  => self::get_css_value( $attr['headingFontSize'], 'px' ),
					'line-height'                => $attr['headingLineHeight'],
					'color'                      => $attr['headingColor'],
					'background-color'           => $attr['headingBgColor'],
					'padding-top'                => self::get_css_value( $attr['headingTopPadding'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['headingBottomPadding'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['headingLeftPadding'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['headingRightPadding'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['headingTopMargin'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['headingBottomMargin'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['headingLeftMargin'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['headingRightMargin'], 'px' ) . '!important',
					'border-style'               => $attr['headingBorderStyle'],
					'border-color'               => $attr['headingBorderColor'],
					'border-radius'              => self::get_css_value( $attr['headingBorderRadius'], 'px' ),
					// Border Radius.
					'border-top-left-radius'     => self::get_css_value( $attr['headingBorderTopRadius'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['headingBorderRightRadius'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['headingBorderBottomRadius'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['headingBorderLeftRadius'], 'px' ) . '!important',
					// Border Width.
					'border-top-width'           => self::get_css_value( $attr['headingBorderTopWidth'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['headingBorderLeftWidth'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['headingBorderRightWidth'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['headingBorderBottomWidth'], 'px' ),
					"text-transform"             => $attr['headingTextTransform'],
					"font-style"                 => $attr['headingFontStyle'],
				),
				' .responsive-block-editor-addons-toc__title-wrap:hover' => array(
					'color'            => $attr['headingColorHover'],
					'background-color' => $attr['headingBgColorHover'],
				),
				' .responsive-block-editor-addons-toc__list-wrap' => array(
					'font-family'                => $attr['contentFontFamily'],
					'font-weight'                => $attr['contentFontWeight'],
					'font-size'                  => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'line-height'                => $attr['contentLineHeight'],
					'background-color'           => $attr['bodyBgColor'],
					'padding-top'                => self::get_css_value( $attr['contentTopPadding'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['contentBottomPadding'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['contentLeftPadding'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['contentRightPadding'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['contentTopMargin'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['contentBottomMargin'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['contentLeftMargin'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['contentRightMargin'], 'px' ) . '!important',
					'border-style'               => $attr['bodyBorderStyle'],
					'border-color'               => $attr['bodyBorderColor'],
					'border-radius'              => self::get_css_value( $attr['bodyBorderRadius'], 'px' ),
					// Border Radius.
					'border-top-left-radius'     => self::get_css_value( $attr['bodyBorderTopRadius'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['bodyBorderRightRadius'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['bodyBorderBottomRadius'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['bodyBorderLeftRadius'], 'px' ) . '!important',
					// Border Width.
					'border-top-width'           => self::get_css_value( $attr['bodyBorderTopWidth'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['bodyBorderLeftWidth'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['bodyBorderRightWidth'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['bodyBorderBottomWidth'], 'px' ),
					"text-transform"             => $attr['contentTextTransform'],
					"font-style"                 => $attr['contentFontStyle'],
				),
				' .responsive-block-editor-addons_table-of-contents-placeholder' => array(
					'font-family'         => $attr['contentFontFamily'],
					'font-weight'         => $attr['contentFontWeight'],
					'font-size'           => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'line-height'         => $attr['contentLineHeight'],
					'background-color'    => $attr['bodyBgColor'],
					'padding-top'         => self::get_css_value( $attr['contentTopPadding'], 'px' ) . '!important',
					'padding-bottom'      => self::get_css_value( $attr['contentBottomPadding'], 'px' ) . '!important',
					'padding-left'        => self::get_css_value( $attr['contentLeftPadding'], 'px' ) . '!important',
					'padding-right'       => self::get_css_value( $attr['contentRightPadding'], 'px' ) . '!important',
					'margin-top'          => self::get_css_value( $attr['contentTopMargin'], 'px' ) . '!important',
					'margin-bottom'       => self::get_css_value( $attr['contentBottomMargin'], 'px' ) . '!important',
					'margin-left'         => self::get_css_value( $attr['contentLeftMargin'], 'px' ) . '!important',
					'margin-right'        => self::get_css_value( $attr['contentRightMargin'], 'px' ) . '!important',
					'border-style'        => $attr['bodyBorderStyle'],
					'border-color'        => $attr['bodyBorderColor'],
					'border-radius'       => self::get_css_value( $attr['bodyBorderRadius'], 'px' ) . ' !important',
					'border-top-width'    => self::get_css_value( 0, 'px' ),
					'border-left-width'   => self::get_css_value( $attr['bodyBorderWidth'], 'px' ),
					'border-right-width'  => self::get_css_value( $attr['bodyBorderWidth'], 'px' ),
					'border-bottom-width' => self::get_css_value( $attr['bodyBorderWidth'], 'px' ),
					'color'               => $attr['bodyColor'],
					"text-transform"      => $attr['contentTextTransform'],
					"font-style"          => $attr['contentFontStyle'],
				),
				' .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li a' => array(
					'color' => $attr['bodyColor'],
				),
				' .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li' => array(
					'color' => $attr['bodyColor'],
					'width' => 'fit-content',
				),
				' .responsive-block-editor-addons-toc__list-wrap:hover' => array(
					'background-color' => $attr['bodyBgColorHover'],
				),
				' .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li:hover, .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li:hover a, .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li a:hover' => array(
					'color' => $attr['bodyColorHover'],
				),
				' .responsive-block-editor-addons-toc__list-wrap .responsive-block-editor-addons-toc__list li a:hover' => array(
					'color' => $attr['bodyColorHover'],
				),
				' .responsive-block-editor-addons-toc__wrap' => array(
					'width'          => self::get_css_value( $attr['blockWidth'], '%' ),
					'border-style'   => $attr['blockBorderStyle'],
					'border-color'   => $attr['blockBorderColor'],
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ) . '!important',
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ) . '!important',
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ) . '!important',
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ) . '!important',
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ) . '!important',
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ) . '!important',
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ) . '!important',
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ) . '!important',

				),
				' .responsive-block-editor-addons-toc__collapsible-wrap .responsive-block-editor-addons-toc__collapsible-icon' => array(
					'color' => $attr['icon_color'],
				),
				' .responsive-block-editor-addons-toc__collapsible-wrap .responsive-block-editor-addons-toc__collapsible-icon svg' => array(
					'fill' => $attr['icon_color'],
				),
				' .responsive-block-editor-addons-toc__collapsible-icon' => array(
					'width'  => self::get_css_value( $attr['size'], 'px' ),
					'height' => self::get_css_value( $attr['size'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__collapsible-icon svg' => array(
					'width'  => self::get_css_value( $attr['size'], 'px' ),
					'height' => self::get_css_value( $attr['size'], 'px' ),

				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'             => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'flex',
					'z-index'             => $attr['z_indexMobile'],
					'background-position' => $background_position_focal_mobile,
					'background-size'     => $attr['backgroundSizeMobile'],
				),
				' .responsive-block-editor-addons-toc__title-wrap' => array(
					'font-size'                  => self::get_css_value( $attr['headingFontSizeMobile'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['headingTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['headingBottomPaddingMobile'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['headingLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['headingRightPaddingMobile'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['headingTopMarginMobile'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['headingBottomMarginMobile'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['headingLeftMarginMobile'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['headingRightMarginMobile'], 'px' ) . '!important',
					// Border Radius.
					'border-top-left-radius'     => self::get_css_value( $attr['headingBorderTopRadiusMobile'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['headingBorderRightRadiusMobile'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['headingBorderBottomRadiusMobile'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['headingBorderLeftRadiusMobile'], 'px' ) . '!important',
					// Border Width.
					'border-top-width'           => self::get_css_value( $attr['headingBorderTopWidthMobile'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['headingBorderLeftWidthMobile'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['headingBorderRightWidthMobile'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['headingBorderBottomWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__list-wrap' => array(
					'font-size'                  => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['contentTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['contentBottomPaddingMobile'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['contentLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['contentRightPaddingMobile'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['contentTopMarginMobile'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['contentBottomMarginMobile'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['contentLeftMarginMobile'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['contentRightMarginMobile'], 'px' ) . '!important',
					// Border Radius.
					'border-top-left-radius'     => self::get_css_value( $attr['bodyBorderTopRadiusMobile'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['bodyBorderRightRadiusMobile'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['bodyBorderBottomRadiusMobile'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['bodyBorderLeftRadiusMobile'], 'px' ) . '!important',
					// Border Width.
					'border-top-width'           => self::get_css_value( $attr['bodyBorderTopWidthMobile'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['bodyBorderLeftWidthMobile'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['bodyBorderRightWidthMobile'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['bodyBorderBottomWidthMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__collapsible-icon' => array(
					'width'  => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
					'height' => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__collapsible-icon svg' => array(
					'width'  => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
					'height' => $attr['sizeMobile'] ? self::get_css_value( $attr['sizeMobile'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__wrap' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . '!important',
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . '!important',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . '!important',
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . '!important',
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . '!important',
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . '!important',
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'             => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'flex',
					'z-index'             => $attr['z_indexTablet'],
					'background-position' => $background_position_focal_tablet,
					'background-size'     => $attr['backgroundSizeTablet'],
				),
				' .responsive-block-editor-addons-toc__title-wrap' => array(
					'font-size'                  => self::get_css_value( $attr['headingFontSizeTablet'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['headingTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['headingBottomPaddingTablet'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['headingLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['headingRightPaddingTablet'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['headingTopMarginTablet'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['headingBottomMarginTablet'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['headingLeftMarginTablet'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['headingRightMarginTablet'], 'px' ) . '!important',
					// Border Radius.
					'border-top-left-radius'     => self::get_css_value( $attr['headingBorderTopRadiusTablet'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['headingBorderRightRadiusTablet'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['headingBorderBottomRadiusTablet'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['headingBorderLeftRadiusTablet'], 'px' ) . '!important',
					// Border Width.
					'border-top-width'           => self::get_css_value( $attr['headingBorderTopWidthTablet'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['headingBorderLeftWidthTablet'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['headingBorderRightWidthTablet'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['headingBorderBottomWidthTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__list-wrap' => array(
					'font-size'                  => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'padding-top'                => self::get_css_value( $attr['contentTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['contentBottomPaddingTablet'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['contentLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['contentRightPaddingTablet'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['contentTopMarginTablet'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['contentBottomMarginTablet'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['contentLeftMarginTablet'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['contentRightMarginTablet'], 'px' ) . '!important',

					// Border Radius
					'border-top-left-radius'     => self::get_css_value( $attr['bodyBorderTopRadiusTablet'], 'px' ) . '!important',
					'border-top-right-radius'    => self::get_css_value( $attr['bodyBorderRightRadiusTablet'], 'px' ) . '!important',
					'border-bottom-right-radius' => self::get_css_value( $attr['bodyBorderBottomRadiusTablet'], 'px' ) . '!important',
					'border-bottom-left-radius'  => self::get_css_value( $attr['bodyBorderLeftRadiusTablet'], 'px' ) . '!important',
					// Border Width
					'border-top-width'           => self::get_css_value( $attr['bodyBorderTopWidthTablet'], 'px' ),
					'border-left-width'          => self::get_css_value( $attr['bodyBorderLeftWidthTablet'], 'px' ),
					'border-right-width'         => self::get_css_value( $attr['bodyBorderRightWidthTablet'], 'px' ),
					'border-bottom-width'        => self::get_css_value( $attr['bodyBorderBottomWidthTablet'], 'px' ),

				),
				' .responsive-block-editor-addons-toc__collapsible-icon' => array(
					'width'  => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
					'height' => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
				),
				' .responsive-block-editor-addons-toc__collapsible-icon svg' => array(
					'width'  => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),
					'height' => $attr['sizeTablet'] ? self::get_css_value( $attr['sizeTablet'], 'px' ) : self::get_css_value( $attr['size'], 'px' ),

				),
				' .responsive-block-editor-addons-toc__wrap' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . '!important',
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . '!important',
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . '!important',
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . '!important',
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . '!important',
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . '!important',
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-table-of-contents.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );

			return $css;
		}

		/**
		 * Get Defaults for Table Of Contents block
		 *
		 * @return array
		 */
		public static function get_responsive_block_table_of_contents_default_attributes() {

			return array(
				'block_id'                             => '',
				'classMigrate'                         => false,
				'isCollapsible'                        => false,
				'icon'                                 => 'fa-angle-down',
				'heading'                              => 'Table Of Contents',
				'headingTitle'                         => 'Table Of Contents',
				'borderStyle'                          => 'solid',
				'borderWidth'                          => 1,
				'borderRadius'                         => 0,
				'borderColor'                          => '#333',
				'blockTopPadding'                      => '',
				'blockTopPaddingMobile'                => '',
				'blockTopPaddingTablet'                => '',
				'blockBottomPadding'                   => '',
				'blockBottomPaddingTablet'             => '',
				'blockBottomPaddingMobile'             => '',
				'blockRightPadding'                    => '',
				'blockRightPaddingMobile'              => '',
				'blockRightPaddingTablet'              => '',
				'blockLeftPadding'                     => '',
				'blockLeftPaddingTablet'               => '',
				'blockLeftPaddingMobile'               => '',
				'blockTopMargin'                       => '',
				'blockTopMarginMobile'                 => '',
				'blockTopMarginTablet'                 => '',
				'blockBottomMargin'                    => '',
				'blockBottomMarginTablet'              => '',
				'blockBottomMarginMobile'              => '',
				'blockRightMargin'                     => '',
				'blockRightMarginMobile'               => '',
				'blockRightMarginTablet'               => '',
				'blockLeftMargin'                      => '',
				'blockLeftMarginTablet'                => '',
				'blockLeftMarginMobile'                => '',
				'z_index'                              => 1,
				'z_indexMobile'                        => 1,
				'z_indexTablet'                        => 1,
				'headingFontFamily'                    => '',
				'headingFontWeight'                    => '500',
				'headingFontSize'                      => 16,
				'headingFontSizeTablet'                => 16,
				'headingFontSizeMobile'                => 14,
				'headingLineHeight'                    => 1,
				'contentFontFamily'                    => '',
				'contentFontWeight'                    => '500',
				'contentFontSize'                      => 16,
				'contentFontSizeTablet'                => 16,
				'contentFontSizeMobile'                => 14,
				'contentLineHeight'                    => 1.8,
				'align'                                => 'left',
				'headingColor'                         => '#fff',
				'headingBgColor'                       => '#0984ff',
				'headingColorHover'                    => '',
				'headingBgColorHover'                  => '',
				'bodyColor'                            => '',
				'bodyBgColor'                          => '#fff',
				'bodyColorHover'                       => '',
				'bodyBgColorHover'                     => '',
				'headingTopPadding'                    => 15,
				'headingTopPaddingMobile'              => 15,
				'headingTopPaddingTablet'              => 15,
				'headingBottomPadding'                 => 15,
				'headingBottomPaddingTablet'           => 15,
				'headingBottomPaddingMobile'           => 15,
				'headingRightPadding'                  => 20,
				'headingRightPaddingMobile'            => 20,
				'headingRightPaddingTablet'            => 20,
				'headingLeftPadding'                   => 20,
				'headingLeftPaddingTablet'             => 20,
				'headingLeftPaddingMobile'             => 20,
				'headingTopMargin'                     => 0,
				'headingTopMarginMobile'               => 0,
				'headingTopMarginTablet'               => 0,
				'headingBottomMargin'                  => 0,
				'headingBottomMarginTablet'            => 0,
				'headingBottomMarginMobile'            => 0,
				'headingRightMargin'                   => 0,
				'headingRightMarginMobile'             => 0,
				'headingRightMarginTablet'             => 0,
				'headingLeftMargin'                    => 0,
				'headingLeftMarginTablet'              => 0,
				'headingLeftMarginMobile'              => 0,
				'contentTopPadding'                    => 15,
				'contentTopPaddingMobile'              => 15,
				'contentTopPaddingTablet'              => 15,
				'contentBottomPadding'                 => 15,
				'contentBottomPaddingTablet'           => 15,
				'contentBottomPaddingMobile'           => 15,
				'contentRightPadding'                  => 20,
				'contentRightPaddingMobile'            => 20,
				'contentRightPaddingTablet'            => 20,
				'contentLeftPadding'                   => 20,
				'contentLeftPaddingTablet'             => 20,
				'contentLeftPaddingMobile'             => 20,
				'contentTopMargin'                     => 0,
				'contentTopMarginMobile'               => 0,
				'contentTopMarginTablet'               => 0,
				'contentBottomMargin'                  => 0,
				'contentBottomMarginTablet'            => 0,
				'contentBottomMarginMobile'            => 0,
				'contentRightMargin'                   => 0,
				'contentRightMarginMobile'             => 0,
				'contentRightMarginTablet'             => 0,
				'contentLeftMargin'                    => 0,
				'contentLeftMarginTablet'              => 0,
				'contentLeftMarginMobile'              => 0,
				'blockWidth'                           => 100,
				'blockBorderStyle'                     => 'solid',
				'headingBorderTopWidth'                => 1,
				'headingBorderBottomWidth'             => 1,
				'headingBorderLeftWidth'               => 1,
				'headingBorderRightWidth'              => 1,
				'headingBorderTopWidthTablet'          => 1,
				'headingBorderBottomWidthTablet'       => 1,
				'headingBorderLeftWidthTablet'         => 1,
				'headingBorderRightWidthTablet'        => 1,
				'headingBorderTopWidthMobile'          => 1,
				'headingBorderBottomWidthMobile'       => 1,
				'headingBorderLeftWidthMobile'         => 1,
				'headingBorderRightWidthMobile'        => 1,
				// Border Radius
				'headingBorderTopLeftRadius'           => '',
				'headingBorderTopRightRadius'          => '',
				'headingBorderBottomLeftRadius'        => '',
				'headingBorderBottomRightRadius'       => '',
				'headingBorderTopLeftRadiusMobile'     => '',
				'headingBorderTopRightRadiusMobile'    => '',
				'headingBorderBottomLeftRadiusMobile'  => '',
				'headingBorderBottomRightRadiusMobile' => '',
				'headingBorderTopLeftRadiusTablet'     => '',
				'headingBorderTopRightRadiusTablet'    => '',
				'headingBorderBottomLeftRadiusTablet'  => '',
				'headingBorderBottomRightRadiusTablet' => '',
				'blockBorderColor'                     => '#0984ff',
				'headingBorderStyle'                   => '',
				'headingBorderWidth'                   => 1,
				'headingBorderRadius'                  => '',
				'headingBorderColor'                   => '',
				'bodyBorderStyle'                      => '',
				'bodyBorderWidth'                      => 1,
				'bodyBorderTopWidth'                   => 1,
				'bodyBorderLeftWidth'                  => 1,
				'bodyBorderRightWidth'                 => 1,
				'bodyBorderBottomWidth'                => 1,
				'bodyBorderTopWidthTablet'             => 1,
				'bodyBorderLeftWidthTablet'            => 1,
				'bodyBorderRightWidthTablet'           => 1,
				'bodyBorderBottomWidthTablet'          => 1,
				'bodyBorderTopWidthMobile'             => 1,
				'bodyBorderLeftWidthMobile'            => 1,
				'bodyBorderRightWidthMobile'           => 1,
				'bodyBorderBottomWidthMobile'          => 1,

				'headingBorderTopRadiusMobile'         => 0,
				'headingBorderRightRadiusMobile'       => 0,
				'headingBorderBottomRadiusMobile'      => 0,
				'headingBorderLeftRadiusMobile'        => 0,
				'headingBorderTopRadiusTablet'         => 0,
				'headingBorderRightRadiusTablet'       => 0,
				'headingBorderBottomRadiusTablet'      => 0,
				'headingBorderLeftRadiusTablet'        => 0,
				'headingBorderTopRadius'               => 0,
				'headingBorderRightRadius'             => 0,
				'headingBorderBottomRadius'            => 0,
				'headingBorderLeftRadius'              => 0,
				'bodyBorderTopRadiusMobile'            => 0,
				'bodyBorderRightRadiusMobile'          => 0,
				'bodyBorderBottomRadiusMobile'         => 0,
				'bodyBorderLeftRadiusMobile'           => 0,
				'bodyBorderTopRadiusTablet'            => 0,
				'bodyBorderRightRadiusTablet'          => 0,
				'bodyBorderBottomRadiusTablet'         => 0,
				'bodyBorderLeftRadiusTablet'           => 0,
				'bodyBorderTopRadius'                  => 0,
				'bodyBorderRightRadius'                => 0,
				'bodyBorderBottomRadius'               => 0,
				'bodyBorderLeftRadius'                 => 0,
				'blockBorderWidth'                     => 1,
				'blockBorderRadius'                    => '',

				'bodyBorderRadius'                     => 0,
				'bodyBorderColor'                      => '',
				'tableType'                            => 'unordered',
				'orderListType'                        => 'none',
				'headerLayout'                         => 'fill',
				'backgroundImage'                      => '',
				'backgroundPosition'                   => 'center-center',
				'backgroundSize'                       => 'cover',
				'backgroundRepeat'                     => 'no-repeat',
				'backgroundColor'                      => '',
				'backgroundVideo'                      => '',
				'backgroundType'                       => 'none',
				'size'                                 => 20,
				'sizeMobile'                           => '',
				'sizeTablet'                           => '',
				'icon_color'                           => '#3a3a3a',
				'hideWidgetMobile'                     => false,
				'hideWidgetTablet'                     => false,
				'hideWidget'                           => false,

				// Body radius
				'bodyBorderTopLeftRadiusMobile'        => '',
				'bodyBorderTopRightRadiusMobile'       => '',
				'bodyBorderBottomLeftRadiusMobile'     => '',
				'bodyBorderBottomRightRadiusMobile'    => '',
				'bodyBorderTopLeftRadiusTablet'        => '',
				'bodyBorderTopRightRadiusTablet'       => '',
				'bodyBorderBottomLeftRadiusTablet'     => '',
				'bodyBorderBottomRightRadiusTablet'    => '',
				'bodyBorderTopLeftRadius'              => '',
				'bodyBorderTopRightRadius'             => '',
				'bodyBorderBottomLeftRadius'           => '',
				'bodyBorderBottomRightRadius'          => '',
				// Image Position & Size
				'imagePositionTab'                     => 'desktop',
				'backgroundSizeTablet'                 => 'cover',
				'backgroundSizeMobile'                 => 'cover',
				'backgroundPositionMobile'             => 'center center',
				'backgroundPositionTablet'             => 'center center',
				'backgroundPositionFocal'              => '50% 50%',
				'backgroundPositionFocalMobile'        => '50% 50%',
				'backgroundPositionFocalTablet'        => '50% 50%',
				'imageSizeTab'                         => 'desktop',
				'headingTextTransform'                 => '',
				'headingFontStyle'                     => '',
				'contentTextTransform'                 => '',
				'contentFontStyle'                     => '',
			);
		}

		/**
		 * Get How-To Schema Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_how_to_css( $attr, $id ) {
			$defaults = self::get_responsive_block_how_to_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			// Frontend Backward Compatibility For Border Radius
			$new_border_radius_keys = array(
				'blockTopRadius'          => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadius'        => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadius'       => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadius'         => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusTablet'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusTablet'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusTablet' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusTablet'   => 'borderRadius' ? 'borderRadius' : 0,
				'blockTopRadiusMobile'    => 'borderRadius' ? 'borderRadius' : 0,
				'blockRightRadiusMobile'  => 'borderRadius' ? 'borderRadius' : 0,
				'blockBottomRadiusMobile' => 'borderRadius' ? 'borderRadius' : 0,
				'blockLeftRadiusMobile'   => 'borderRadius' ? 'borderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$mobile_selectors = array();
			$tablet_selectors = array();

			$border     = 'none' !== $attr['borderStyle'] ? self::get_css_value( $attr['borderWidth'], 'px' ) . ' ' . $attr['borderStyle'] . ' ' . $attr['borderColor'] : '';
			$border_rad = 'none' !== $attr['borderStyle'] ? self::get_css_value( $attr['borderRadius'], 'px' ) : '';
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				'' => array(
					'display'    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'text-align' => $attr['overallAlignment'],
					'padding'    => self::get_css_value( 10, 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-main-heading' => array(
					'color'          => $attr['mainHeadingColor'],
					'font-family'    => $attr['mainHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['mainHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['mainHeadingFontWeight'],
					'margin-bottom'  => self::get_css_value( $attr['rowGap'], 'px' ),
					'letter-spacing' => self::get_css_value( $attr['mainHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['mainHeadingLineHeight'],
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-time' => array(
					'color'          => $attr['secondaryHeadingColor'],
					'display'        => 'inline',
					'letter-spacing' => self::get_css_value( $attr['subHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['subHeadingLineHeight'],
					'font-family'    => $attr['subHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['subHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['subHeadingFontWeight'],
					'margin-right'   => self::get_css_value( $attr['timeMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-time-value' => array(
					'color'          => $attr['descriptionColor'],
					'letter-spacing' => self::get_css_value( $attr['descriptionLetterSpacing'], 'px' ),
					'line-height'    => $attr['descriptionLineHeight'],
					'font-family'    => $attr['descriptionFontFamily'],
					'font-size'      => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'    => $attr['descriptionFontWeight'],
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-cost' => array(
					'color'          => $attr['secondaryHeadingColor'],
					'display'        => 'inline',
					'letter-spacing' => self::get_css_value( $attr['subHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['subHeadingLineHeight'],
					'font-family'    => $attr['subHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['subHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['subHeadingFontWeight'],
					'margin-right'   => self::get_css_value( $attr['costMargin'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-value' => array(
					'color'          => $attr['descriptionColor'],
					'display'        => 'inline',
					'letter-spacing' => self::get_css_value( $attr['descriptionLetterSpacing'], 'px' ),
					'line-height'    => $attr['descriptionLineHeight'],
					'font-family'    => $attr['descriptionFontFamily'],
					'font-size'      => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'    => $attr['descriptionFontWeight'],
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-tools' => array(
					'color'          => $attr['secondaryHeadingColor'],
					'letter-spacing' => self::get_css_value( $attr['subHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['subHeadingLineHeight'],
					'font-family'    => $attr['subHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['subHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['subHeadingFontWeight'],
				),
				' .responsive-block-editor-addons-block-how-to-tools-list-item' => array(
					'color'          => $attr['descriptionColor'],
					'letter-spacing' => self::get_css_value( $attr['descriptionLetterSpacing'], 'px' ),
					'font-family'    => $attr['descriptionFontFamily'],
					'font-size'      => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'    => $attr['descriptionFontWeight'],
					'list-style'     => $attr['toolsListStyle'],
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-materials' => array(
					'color'          => $attr['secondaryHeadingColor'],
					'letter-spacing' => self::get_css_value( $attr['subHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['subHeadingLineHeight'],
					'font-family'    => $attr['subHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['subHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['subHeadingFontWeight'],
				),
				' .responsive-block-editor-addons-block-how-to-materials-list-item' => array(
					'color'          => $attr['descriptionColor'],
					'letter-spacing' => self::get_css_value( $attr['descriptionLetterSpacing'], 'px' ),
					'font-family'    => $attr['descriptionFontFamily'],
					'font-size'      => self::get_css_value( $attr['descriptionFontSize'], 'px' ),
					'font-weight'    => $attr['descriptionFontWeight'],
					'list-style'     => $attr['materialsListStyle'],
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-steps' => array(
					'color'          => $attr['secondaryHeadingColor'],
					'display'        => 'inline',
					'letter-spacing' => self::get_css_value( $attr['subHeadingLetterSpacing'], 'px' ),
					'line-height'    => $attr['subHeadingLineHeight'],
					'font-family'    => $attr['subHeadingFontFamily'],
					'font-size'      => self::get_css_value( $attr['subHeadingFontSize'], 'px' ),
					'font-weight'    => $attr['subHeadingFontWeight'],
				),
				' .responsive-block-editor-addons-block-how-to-time-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-tools-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-materials-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGap'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-main-image' => array(
					'border'                     => $border,
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps .wp-block-responsive-block-editor-addons-info-block' => array(
					'margin-top' => self::get_css_value( $attr['stepsMargin'], 'px' ),
				),
			);

			$mobile_selectors = array(
				'' => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
				),
				' .responsive-block-editor-addons-block-how-to-main-heading' => array(
					'line-height'   => $attr['mainHeadingLineHeight'],
					'font-size'     => self::get_css_value( $attr['mainHeadingFontSizeMobile'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-time' => array(
					'line-height'  => $attr['subHeadingLineHeight'],
					'font-weight'  => self::get_css_value( $attr['subHeadingFontSizeMobile'], 'px' ),
					'margin-right' => self::get_css_value( $attr['timeMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-cost' => array(
					'line-height'  => $attr['subHeadingLineHeight'],
					'font-weight'  => self::get_css_value( $attr['subHeadingFontSizeMobile'], 'px' ),
					'margin-right' => self::get_css_value( $attr['costMarginMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-tools' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-materials' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-steps' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-time-value' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-value' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-tools-list-item' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-materials-list-item' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-time-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-tools-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-materials-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-main-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps .wp-block-responsive-block-editor-addons-info-block' => array(
					'margin-top' => self::get_css_value( $attr['stepsMarginMobile'], 'px' ),
				),

			);

			$tablet_selectors = array(
				'' => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
				),
				' .responsive-block-editor-addons-block-how-to-main-heading' => array(
					'line-height'   => $attr['mainHeadingLineHeight'],
					'font-size'     => self::get_css_value( $attr['mainHeadingFontSizeTablet'], 'px' ),
					'margin-bottom' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-time' => array(
					'line-height'  => $attr['subHeadingLineHeight'],
					'font-weight'  => self::get_css_value( $attr['subHeadingFontSizeTablet'], 'px' ),
					'margin-right' => self::get_css_value( $attr['timeMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-cost' => array(
					'line-height'  => $attr['subHeadingLineHeight'],
					'font-weight'  => self::get_css_value( $attr['subHeadingFontSizeTablet'], 'px' ),
					'margin-right' => self::get_css_value( $attr['costMarginTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-tools' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-materials' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-sub-heading-steps' => array(
					'line-height' => $attr['subHeadingLineHeight'],
					'font-weight' => self::get_css_value( $attr['subHeadingFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-time-value' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-value' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-tools-list-item' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-materials-list-item' => array(
					'line-height' => $attr['descriptionLineHeight'],
					'font-size'   => self::get_css_value( $attr['descriptionFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-time-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-cost-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-tools-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-materials-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps-area' => array(
					'margin-top' => self::get_css_value( $attr['rowGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-main-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-how-to-steps .wp-block-responsive-block-editor-addons-info-block' => array(
					'margin-top' => self::get_css_value( $attr['stepsMarginTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-how-to.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for how to block
		 *
		 * @return array
		 */
		public static function get_responsive_block_how_to_default_attributes() {
			return array(
				'block_id'                    => '',
				'overallAlignment'            => 'left',
				'mainHeadingColor'            => '',
				'secondaryHeadingColor'       => '',
				'descriptionColor'            => '',
				'mainHeadingFontFamily'       => '',
				'mainHeadingFontSize'         => 12,
				'mainHeadingFontSizeMobile'   => 12,
				'mainHeadingFontSizeTablet'   => 14,
				'mainHeadingFontWeight'       => '',
				'mainHeadingLineHeight'       => 0,
				'mainHeadingLineHeightMobile' => 0,
				'mainHeadingLineHeightTablet' => 0,
				'mainHeadingLetterSpacing'    => 0,
				'subHeadingFontFamily'        => '',
				'subHeadingFontSize'          => 12,
				'subHeadingFontSizeMobile'    => 12,
				'subHeadingFontSizeTablet'    => 14,
				'subHeadingFontWeight'        => '',
				'subHeadingLineHeight'        => 0,
				'subHeadingLineHeightMobile'  => 0,
				'subHeadingLineHeightTablet'  => 0,
				'subHeadingLetterSpacing'     => 0,
				'descriptionFontFamily'       => '',
				'descriptionFontSize'         => 12,
				'descriptionFontSizeMobile'   => 12,
				'descriptionFontSizeTablet'   => 14,
				'descriptionFontWeight'       => '',
				'descriptionLineHeight'       => 0,
				'descriptionLineHeightMobile' => 0,
				'descriptionLineHeightTablet' => 0,
				'descriptionLetterSpacing'    => 0,
				'timeMargin'                  => 10,
				'costMargin'                  => 10,
				'rowGap'                      => 10,
				'timeMarginMobile'            => 10,
				'costMarginMobile'            => 10,
				'rowGapMobile'                => 10,
				'timeMarginTablet'            => 10,
				'costMarginTablet'            => 10,
				'rowGapTablet'                => 10,
				'toolsListStyle'              => 'none',
				'materialsListStyle'          => 'none',
				'borderStyle'                 => 'none',
				'borderRadius'                => 0,
				'blockTopRadiusMobile'        => 0,
				'blockRightRadiusMobile'      => 0,
				'blockBottomRadiusMobile'     => 0,
				'blockLeftRadiusMobile'       => 0,
				'blockTopRadiusTablet'        => 0,
				'blockRightRadiusTablet'      => 0,
				'blockBottomRadiusTablet'     => 0,
				'blockLeftRadiusTablet'       => 0,
				'blockTopRadius'              => 0,
				'blockRightRadius'            => 0,
				'blockBottomRadius'           => 0,
				'blockLeftRadius'             => 0,
				'borderWidth'                 => 1,
				'borderColor'                 => '',
				'stepsMargin'                 => 10,
				'stepsMarginMobile'           => 10,
				'stepsMarginTablet'           => 10,
				'hideWidgetTablet'            => false,
				'hideWidgetMobile'            => false,
				'hideWidget'                  => false,
			);
		}

		/**
		 * Get Inline Notice Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_inline_notice_css( $attr, $id ) {
			$defaults = self::get_responsive_block_inline_notice_default_attributes();

			// Frontend Backward Compatibility For TypographySettings For Image Boxes
			$new_typography_settings_keys = array(
				'contentTypographyColor' => 'contentColor' ? 'contentColor' : '',
				'titleTypographyColor'   => 'titleColor' ? 'titleColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr          = array_merge( $defaults, (array) $attr );
			$base_selector = '.responsive-block-editor-addons-block-inline-notice.block-';
			$selector      = $base_selector . $id;
			$js_attr       = array(
				'cookies_id'         => $attr['cookies_id'],
				'cookies'            => $attr['cookies'],
				'close_cookies_days' => $attr['close_cookies_days'],
				'noticeDismiss'      => $attr['noticeDismiss'],
			);
			?>

			<script>
				( function( $ ) {

					RBEAInlineNotice = {

						_run: function( attr, id ) {

							if ( $( id ).length === 0 ) {
								return;
							}

							var unique_id = attr['cookies_id'];
							var is_cookie = attr['cookies'];
							var cookies_days = attr['close_cookies_days'];
							var current_cookie = Cookies.get( 'rbea-notice-' + unique_id );

							if( 'undefined' === typeof current_cookie && true === is_cookie ){
								$( id ).show()
							}

							if ( attr['noticeDismiss'] !== '' ) {
								$( id + " .rbea-notice-dismiss" ).on( 'click',function() {
									if ( true === is_cookie && 'undefined' !== typeof current_cookie) {
										current_cookies = Cookies.set( 'rbea-notice-' + unique_id, true, { expires: cookies_days } );
									$( id ).addClass("rbea-notice__active").css('display' ,'none')
									}

									if( 'undefined' === typeof current_cookie && true === is_cookie ){
										current_cookies = Cookies.set( 'rbea-notice-' + unique_id, true, { expires: cookies_days } );
										$( id ).addClass("rbea-notice__active").css('display' ,'none')
									}

									if( false === is_cookie ){
										$( id ).addClass("rbea-notice__active").css('display' ,'none')
									}
								});
							}
						}
					}
					$( document ).ready(function() {
						RBEAInlineNotice._run( <?php echo wp_json_encode( $js_attr ); ?>, '<?php echo esc_attr( $selector ); ?>' );
					})
				})( jQuery )
			</script>

			<?php

			$mobile_selectors = array();
			$tablet_selectors = array();

			$notice = $attr['noticeType'];
			switch ( $notice ) {
				case 'warning':
					$notice_type_color = '#ffd54f';
					break;
				case 'info':
					$notice_type_color = '#2091e1';
					break;
				case 'error':
					$notice_type_color = '#d9534f';
					break;
				case 'notification':
					$notice_type_color = '#40ba7b';
					break;
				default:
					$notice_type_color = $attr['noticeBoxColor'];
			}

			$notice_area_border = 'simple' === $attr['layout'] ? '1px solid ' . $notice_type_color : 'none';
			$modern_border      = '1px solid ' . $notice_type_color;
			$border_values      = 'modern' === $attr['layout'] ? $modern_border : 'none';
			$border_left        = 'simple' === $attr['layout'] ? '5px solid ' . $notice_type_color : $modern_border;
			$notice_bg_color    = 'modern' === $attr['layout'] ? $notice_type_color : '';
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'text-align' => $attr['noticeAlignment'],
					'padding'    => '' . self::get_css_value( $attr['blockTopPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPadding'], 'px' ) . ' !important',
					'margin'     => '' . self::get_css_value( $attr['blockTopMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ' !important',
					'position'   => 'relative',
					'z-index'    => $attr['z_index'],
				),
				' .responsive-block-editor-addons-block-inline-notice-title-area' => array(
					'background-color' => $notice_type_color,
					'border-left'      => $notice_area_border,
					'display'          => 'flex',
					'align-items'      => 'center',
					'justify-content'  => 'space-between',
				),
				' .responsive-block-editor-addons-block-inline-notice-title' => array(
					'color'          => $attr['titleTypographyColor'],
					'font-family'    => $attr['titleFontFamily'],
					'font-size'      => self::get_css_value( $attr['titleFontSize'], 'px' ),
					'font-weight'    => $attr['titleFontWeight'],
					'line-height'    => $attr['titleLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['titleLetterSpacing'], 'px' ),
					'margin'         => 0,
					'padding'        => '' . self::get_css_value( $attr['titlePaddingVertical'], 'px' ) . ' ' . self::get_css_value( $attr['titlePaddingHorizontal'], 'px' ),
					"text-transform" => $attr['titleTextTransform'],
     			 	"font-style"     => $attr['titleFontStyle'],
				),
				' .responsive-block-editor-addons-block-inline-notice-svg > svg' => array(
					'height'       => '17px',
					'width'        => '17px',
					'margin-right' => '10px',
				),
				' .responsive-block-editor-addons-block-inline-notice-content-area' => array(
					'background-color' => $attr['contentBgColor'],
					'border-bottom'    => $border_values,
					'border-left'      => $border_left,
					'border-right'     => $border_values,
				),
				' .responsive-block-editor-addons-block-inline-notice-content' => array(
					'color'          => $attr['contentTypographyColor'],
					'font-family'    => $attr['contentFontFamily'],
					'font-size'      => self::get_css_value( $attr['contentFontSize'], 'px' ),
					'font-weight'    => $attr['contentFontWeight'],
					'line-height'    => $attr['contentLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['contentLetterSpacing'], 'px' ),
					'padding'        => '' . self::get_css_value( $attr['contentPaddingVertical'], 'px' ) . ' ' . self::get_css_value( $attr['contentPaddingHorizontal'], 'px' ),
					"text-transform" => $attr['contentTextTransform'],
      				"font-style"     => $attr['contentFontStyle'],
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
					'padding' => '' . self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . ' !important',
					'margin'  => '' . self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-block-inline-notice-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeMobile'], 'px' ),
					'padding'   => '' . self::get_css_value( $attr['titlePaddingVerticalMobile'], 'px' ) . ' ' . self::get_css_value( $attr['titlePaddingHorizontalMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-block-inline-notice-content' => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeMobile'], 'px' ),
					'padding'   => '' . self::get_css_value( $attr['contentPaddingVerticalMobile'], 'px' ) . ' ' . self::get_css_value( $attr['contentPaddingHorizontalMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
					'padding' => '' . self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . ' !important',
					'margin'  => '' . self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-block-inline-notice-title' => array(
					'font-size' => self::get_css_value( $attr['titleFontSizeTablet'], 'px' ),
					'padding'   => '' . self::get_css_value( $attr['titlePaddingVerticalTablet'], 'px' ) . ' ' . self::get_css_value( $attr['titlePaddingHorizontalTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-block-inline-notice-content' => array(
					'font-size' => self::get_css_value( $attr['contentFontSizeTablet'], 'px' ),
					'padding'   => '' . self::get_css_value( $attr['contentPaddingVerticalTablet'], 'px' ) . ' ' . self::get_css_value( $attr['contentPaddingHorizontalTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-inline-notice.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for inline notice block
		 *
		 * @return array
		 */
		public static function get_responsive_block_inline_notice_default_attributes() {
			return array(
				'block_id'                       => '',
				'blockTopPadding'                => 20,
				'blockBottomPadding'             => 20,
				'blockLeftPadding'               => 20,
				'blockRightPadding'              => 20,
				'blockTopPaddingMobile'          => 20,
				'blockBottomPaddingMobile'       => 20,
				'blockLeftPaddingMobile'         => 20,
				'blockRightPaddingMobile'        => 20,
				'blockTopPaddingTablet'          => 20,
				'blockBottomPaddingTablet'       => 20,
				'blockLeftPaddingTablet'         => 20,
				'blockRightPaddingTablet'        => 20,
				'blockTopMargin'                 => 0,
				'blockBottomMargin'              => 0,
				'blockLeftMargin'                => 0,
				'blockRightMargin'               => 0,
				'blockTopMarginMobile'           => 0,
				'blockBottomMarginMobile'        => 0,
				'blockLeftMarginMobile'          => 0,
				'blockRightMarginMobile'         => 0,
				'blockTopMarginTablet'           => 0,
				'blockBottomMarginTablet'        => 0,
				'blockLeftMarginTablet'          => 0,
				'blockRightMarginTablet'         => 0,
				'blockZIndex'                    => 0,
				'cookies'                        => false,
				'cookies_id'                     => '',
				'close_cookies_days'             => 1,
				'contentBgColor'                 => '',
				'contentColor'                   => '',
				'contentFontFamily'              => '',
				'contentFontSize'                => 16,
				'contentFontSizeMobile'          => 16,
				'contentFontSizeTablet'          => 16,
				'contentFontWeight'              => '600',
				'contentLineHeight'              => 1,
				'contentLetterSpacing'           => 0,
				'contentPaddingVertical'         => 20,
				'contentPaddingHorizontal'       => 20,
				'contentPaddingVerticalMobile'   => 2,
				'contentPaddingHorizontalMobile' => 2,
				'contentPaddingVerticalTablet'   => 5,
				'contentPaddingHorizontalTablet' => 5,
				'headingTag'                     => 'h4',
				'layout'                         => 'modern',
				'noticeAlignment'                => 'left',
				'noticeBoxColor'                 => '#FFD54F',
				'noticeContent'                  => '',
				'noticeDismiss'                  => '',
				'noticeType'                     => 'default',
				'noticeTitle'                    => '',
				'titleColor'                     => '',
				'titleFontFamily'                => '',
				'titleFontSize'                  => 20,
				'titleFontSizeMobile'            => 20,
				'titleFontSizeTablet'            => 20,
				'titleFontWeight'                => '600',
				'titleLineHeight'                => 1,
				'titleLetterSpacing'             => 0,
				'titlePaddingVertical'           => 15,
				'titlePaddingHorizontal'         => 15,
				'titlePaddingVerticalMobile'     => 2,
				'titlePaddingHorizontalMobile'   => 2,
				'titlePaddingVerticalTablet'     => 5,
				'titlePaddingHorizontalTablet'   => 5,
				'hideWidgetMobile'               => false,
				'hideWidgetTablet'               => false,
				'hideWidget'                     => false,
				'z_index'                        => 1,
				'z_indexMobile'                  => 1,
				'z_indexTablet'                  => 1,
				'contentTypographyColor'         => '',
				'titleTypographyColor'           => '',
				'titleTextTransform'             => '',
				'titleFontStyle'                 => '',
				'contentTextTransform'           => '',
				'contentFontStyle'               => '',
			);
		}

		/**
		 * Get Call/Mail Button CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_call_mail_button_css( $attr, $id ) {
			$defaults = self::get_responsive_block_call_mail_button_default_attributes();
			$attr     = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$button_width_css = 'fit-content';

			$button_width_css        = 'fixed' === $attr['buttonWidthType'] ? 'fit-content' : ( 'flexible' === $attr['buttonWidthType'] ? self::get_css_value( $attr['buttonWidth'], 'px' ) : self::get_css_value( 100, '%' ) );
			$button_width_css_mobile = 'fixed' === $attr['buttonWidthType'] ? 'fit-content' : ( 'flexible' === $attr['buttonWidthType'] ? self::get_css_value( $attr['buttonWidthMobile'], 'px' ) : self::get_css_value( 100, '%' ) );
			$button_width_css_tablet = 'fixed' === $attr['buttonWidthType'] ? 'fit-content' : ( 'flexible' === $attr['buttonWidthType'] ? self::get_css_value( $attr['buttonWidthTablet'], 'px' ) : self::get_css_value( 100, '%' ) );

			$button_border           = '1px solid ' . $attr['buttonColor'];
			$button_border_hover     = '1px solid ' . $attr['buttonColorHover'];
			$button_border_radius    = 'rounded' === $attr['buttonStyleToggle'] ? self::get_css_value( $attr['buttonRadius'], 'px' ) : 0;
			$text_color              = 'transparent' === $attr['buttonStyleToggle'] ? $attr['buttonColor'] : $attr['buttonTextColor'];
			$button_background       = 'transparent' === $attr['buttonStyleToggle'] ? '' : $attr['buttonColor'];
			$text_color_hover        = 'transparent' === $attr['buttonStyleToggle'] ? $attr['buttonColorHover'] : $attr['buttonTextColorHover'];
			$button_background_hover = 'transparent' === $attr['buttonStyleToggle'] ? '' : $attr['buttonColorHover'];

			$justify_content_direction = 'flex-start';
			if ( 'left' === $attr['buttonAlign'] ) {
				$justify_content_direction = 'flex-start';
			} elseif ( 'center' === $attr['buttonAlign'] ) {
				$justify_content_direction = 'center';
			} elseif ( 'right' === $attr['buttonAlign'] ) {
				$justify_content_direction = 'flex-end';
			}

			$background_keys = array(
				'buttonStyleToggle' => 'buttonRounded' ? 'rounded' : 'buttonTransparent' ? 'transparent' : '',
			);

			// To populate new control values with existing background control values for backward compatibility.
			foreach ( $background_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$global_inherit_from_theme = get_option( 'rbea_global_inherit_from_theme');
			$rbea_global_inherit_from_theme_last_changed = get_option( 'rbea_global_inherit_from_theme_last_changed');
			$inheritFromThemeLocalTimestamp = isset($attr['inheritFromThemeLocalTimestamp']) ? $attr['inheritFromThemeLocalTimestamp'] : '';
			$flag = ($rbea_global_inherit_from_theme_last_changed && (!$inheritFromThemeLocalTimestamp || strtotime($rbea_global_inherit_from_theme_last_changed) > strtotime($inheritFromThemeLocalTimestamp))) || $attr['inheritFromTheme'];
			$flag = $flag && ($attr['inheritFromThemesaved'] || $global_inherit_from_theme);

			$selectors = array(
				' ' => array(
					'display'         => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'position'        => 'relative',
					'z-index'         => $attr['z_index'],
					'margin'          => self::get_css_value( $attr['blockTopMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMargin'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMargin'], 'px' ) . ' !important',
					'padding'         => self::get_css_value( $attr['blockTopPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPadding'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPadding'], 'px' ) . ' !important',
					'justify-content' => $justify_content_direction,
				),
				' .responsive-block-editor-addons-call-mail-button-button-container' => array(
					'width'            => $button_width_css,
					'border'           => $flag ? '' : $button_border,
					'background-color' => $flag ? '' : $button_background,
					'border-radius'    => $flag ? '' : $button_border_radius,
				),
				' .responsive-block-editor-addons-call-mail-button-text' => array(
					'color'       => $flag ? '' : $text_color,
					'font-family' => $flag ? 'Default' : $attr['textFontFamily'],
					'font-size'   => $flag ? '' : self::get_css_value( $attr['textFontSize'], 'px' ) . ' !important',
					'font-weight' => $flag ? '' : $attr['textFontWeight'],
					'line-height' => $flag ? '' : $attr['textLineHeight'],
					'text-transform' => $flag ? '' : $attr['textTextTransform'],
					'font-style' => $flag ? '' : $attr['textFontStyle'],
				),
				' .responsive-block-editor-addons-call-mail-button-icon' => array(
					'fill' => $text_color,
				),
				' .responsive-block-editor-addons-call-mail-button-icon svg' => array(
					'height' => self::get_css_value( $attr['iconSize'], 'px' ) . ' !important',
					'width'  => self::get_css_value( $attr['iconSize'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-call-mail-button-button-container:hover' => array(
					'border'           => $flag ? '' : $button_border_hover,
					'background-color' => $flag ? '' : $button_background_hover,
				),
				' .responsive-block-editor-addons-call-mail-button-button-container:hover .responsive-block-editor-addons-call-mail-button-text' => array(
					'color' => $flag ? '' : $text_color_hover,
				),
				' .responsive-block-editor-addons-call-mail-button-button-container:hover .responsive-block-editor-addons-call-mail-button-icon' => array(
					'fill' => $text_color_hover,
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-left' => array(
					'margin-right' => self::get_css_value( $attr['iconTextGap'], 'px' ),
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-right' => array(
					'margin-left' => self::get_css_value( $attr['iconTextGap'], 'px' ),
				),
			);

			$mobile_selectors = array(
				' .responsive-block-editor-addons-call-mail-button-button-container' => array(
					'width' => $button_width_css_mobile,
				),
				' .responsive-block-editor-addons-call-mail-button-text' => array(
					'font-size' => $flag ? '' : self::get_css_value( $attr['textFontSizeMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-call-mail-button-icon svg' => array(
					'height' => self::get_css_value( $attr['iconSizeMobile'], 'px' ) . ' !important',
					'width'  => self::get_css_value( $attr['iconSizeMobile'], 'px' ) . ' !important',
				),
				' ' => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'flex',
					'z-index' => $attr['z_indexMobile'],
					'margin'  => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . ' !important',
					'padding' => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-left' => array(
					'margin-right' => self::get_css_value( $attr['iconTextGapMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-right' => array(
					'margin-left' => self::get_css_value( $attr['iconTextGapMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' .responsive-block-editor-addons-call-mail-button-button-container' => array(
					'width' => $button_width_css_tablet,
				),
				' .responsive-block-editor-addons-call-mail-button-text' => array(
					'font-size' => $flag ? '' : self::get_css_value( $attr['textFontSizeTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-call-mail-button-icon svg' => array(
					'height' => self::get_css_value( $attr['iconSizeTablet'], 'px' ) . ' !important',
					'width'  => self::get_css_value( $attr['iconSizeTablet'], 'px' ) . ' !important',
				),
				' ' => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'flex',
					'z-index' => $attr['z_indexTablet'],
					'margin'  => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . ' !important',
					'padding' => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . ' ' . self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . ' !important',
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-left' => array(
					'margin-right' => self::get_css_value( $attr['iconTextGapTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-call-mail-button-icon-iconPosition-right' => array(
					'margin-left' => self::get_css_value( $attr['iconTextGapTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-call-mail-button.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for Call/Mail Button block
		 *
		 * @return array
		 */
		public static function get_responsive_block_call_mail_button_default_attributes() {
			return array(
				'block_id'                 => '',
				'buttonWidthType'          => 'fixed',
				'buttonWidth'              => 200,
				'buttonWidthMobile'        => 200,
				'buttonWidthTablet'        => 200,
				'iconSize'                 => '',
				'iconSizeMobile'           => '',
				'iconSizeTablet'           => '',
				'buttonColor'              => '#4aac38',
				'buttonTextColor'          => '#ffffff',
				'buttonColorHover'         => '',
				'buttonTextColorHover'     => '#ffffff',
				'buttonRounded'            => false,
				'buttonTransparent'        => false,
				'buttonRadius'             => 0,
				'textFontFamily'           => '',
				'textFontSize'             => '',
				'textFontSizeMobile'       => '',
				'textFontSizeTablet'       => '',
				'textFontWeight'           => '100',
				'textLineHeight'           => 1,
				'blockTopMargin'           => 10,
				'blockBottomMargin'        => 10,
				'blockLeftMargin'          => 10,
				'blockRightMargin'         => 10,
				'blockTopMarginMobile'     => 10,
				'blockBottomMarginMobile'  => 10,
				'blockLeftMarginMobile'    => 10,
				'blockRightMarginMobile'   => 10,
				'blockTopMarginTablet'     => 10,
				'blockBottomMarginTablet'  => 10,
				'blockLeftMarginTablet'    => 10,
				'blockRightMarginTablet'   => 10,
				'blockTopPadding'          => 10,
				'blockBottomPadding'       => 10,
				'blockLeftPadding'         => 10,
				'blockRightPadding'        => 10,
				'blockTopPaddingMobile'    => 10,
				'blockBottomPaddingMobile' => 10,
				'blockLeftPaddingMobile'   => 10,
				'blockRightPaddingMobile'  => 10,
				'blockTopPaddingTablet'    => 10,
				'blockBottomPaddingTablet' => 10,
				'blockLeftPaddingTablet'   => 10,
				'blockRightPaddingTablet'  => 10,
				'iconTextGap'              => 5,
				'iconTextGapMobile'        => 3,
				'iconTextGapTablet'        => 5,
				'buttonAlign'              => 'left',
				'hideWidget'               => false,
				'hideWidgetMobile'         => false,
				'hideWidgetTablet'         => false,
				'z_index'                  => 1,
				'z_indexMobile'            => 1,
				'z_indexTablet'            => 1,
				'buttonStyleToggle'        => '',
				'textTextTransform'        => '',
     			'textFontStyle'            => '',
				'inheritFromThemesaved'	   => false,	
				'inheritFromTheme'		   => false,
			);
		}

		/**
		 * Get Progress Bar block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_progress_bar_css( $attr, $id ) {
			$defaults = self::get_responsive_block_progress_bar_default_attributes();

			// Frontend backward compatibility
			$new_border_radius_keys = array(
				'horizontalProgressBarTopRadius'          => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarRightRadius'        => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarBottomRadius'       => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarLeftRadius'         => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarTopRadiusTablet'    => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarRightRadiusTablet'  => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarBottomRadiusTablet' => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarLeftRadiusTablet'   => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarTopRadiusMobile'    => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarRightRadiusMobile'  => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarBottomRadiusMobile' => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
				'horizontalProgressBarLeftRadiusMobile'   => 'horizontalProgressBarBorderRadius' ? 'horizontalProgressBarBorderRadius' : 5,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_border_radius_keys = array(
				'topTitleValueTypographyColor'             => 'horizontalProgressBarTopTitleValueColor' ? 'horizontalProgressBarTopTitleValueColor' : '',
				'innerTitleValueTypographyColor'           => 'horizontalProgressBarInnerTitleValueColor' ? 'horizontalProgressBarInnerTitleValueColor' : '',
				'bottomTitleValueTypographyColor'          => 'horizontalProgressBarBottomTitleValueColor' ? 'horizontalProgressBarBottomTitleValueColor' : '',
				'circularTopTitleValueTypographyColor'     => 'circularProgressBarTopTitleValueColor' ? 'circularProgressBarTopTitleValueColor' : '',
				'circularInnerValueTypographyColor'        => 'circularProgressBarInnerValueColor' ? 'circularProgressBarInnerValueColor' : '',
				'circularBottomTitleValueTypographyColor'  => 'circularProgressBarBottomTitleValueColor' ? 'circularProgressBarBottomTitleValueColor' : '',
				'semiCircularTopTitleValueTypographyColor' => 'semiCircularProgressBarTopTitleValueColor' ? 'semiCircularProgressBarTopTitleValueColor' : '',
				'semiCircularInnerValueTypographyColor'    => 'semiCircularProgressBarInnerValueColor' ? 'semiCircularProgressBarInnerValueColor' : '',
				'semiCircularBottomTitleValueTypographyColor' => 'semiCircularProgressBarBottomTitleValueColor' ? 'semiCircularProgressBarBottomTitleValueColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$circle_radius_val      = 0;
			$stroke_dash_array_val  = 0;
			$stroke_dash_offset_val = 0;

			if ( $attr['circularProgressBarSize'] ) {
				$circle_radius_val      = ( $attr['circularProgressBarSize'] / 2 ) - 10;
				$stroke_dash_array_val  = ( $circle_radius_val * 6.27 ) + 3;
				$stroke_dash_offset_val = ( $circle_radius_val * 6.27 ) + 3;
			}

			$horizontal_track_color = '';
			if ( $attr['gradientTrack'] ) {
				$horizontal_track_color =
					'linear-gradient( to bottom, ' .
					$attr['horizontalProgressBarPrimaryTrackColor'] .
					', ' .
					$attr['horizontalProgressBarSecondaryTrackColor'] .
					')';
			} else {
				$horizontal_track_color =
					'linear-gradient( to bottom, ' .
					$attr['horizontalProgressBarPrimaryTrackColor'] .
					', ' .
					$attr['horizontalProgressBarPrimaryTrackColor'] .
					')';
			}

			$track_stripe_color = 'linear-gradient(45deg, ' .
				$attr['horizontalProgressBarStripeColor'] . ' 25%,' .
				' rgba(0, 0, 0, 0) 25%,' .
				' rgba(0, 0, 0, 0) 50%,' .
				$attr['horizontalProgressBarStripeColor'] . ' 50%,' .
				$attr['horizontalProgressBarStripeColor'] . ' 75%,' .
				' rgba(0, 0, 0, 0) 75%,' .
				' rgba(0, 0, 0, 0) 25%)';

			$stripe_animation_duration_val = 0;
			if ( $attr['stripedHorizontalProgressBarAnimationTime'] ) {
				$stripe_animation_duration_val = $attr['stripedHorizontalProgressBarAnimationTime'] * 0.1;
			}

			$semi_circular_background_track_colors = '';
			if ( $attr['semiCircularProgressBarBackgroundColor'] && $attr['semiCircularProgressBarTrackColor'] ) {
				$semi_circular_background_track_colors =
					$attr['semiCircularProgressBarBackgroundColor'] .
					$attr['semiCircularProgressBarBackgroundColor'] .
					$attr['semiCircularProgressBarTrackColor'] .
					$attr['semiCircularProgressBarTrackColor'];
			}

			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' '                                    => array(
					'display'  => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position' => 'relative',
					'z-index'  => $attr['z_index'],
				),
				' .responsive-horizontal-progress-bar-container, .responsive-circular-progress-bar-container' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPadding'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPadding'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPadding'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPadding'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMargin'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMargin'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMargin'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMargin'], 'px' ),
				),
				' .responsive-horizontal-progress-bar' => array(
					'height'                     => self::get_css_value( $attr['horizontalProgressBarSize'], 'px' ),
					'background-color'           => $attr['horizontalProgressBarBackgroundColor'],
					'border-top-left-radius'     => self::get_css_value( $attr['horizontalProgressBarTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['horizontalProgressBarRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['horizontalProgressBarBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['horizontalProgressBarLeftRadius'], 'px' ),
					'border-style'               => $attr['horizontalProgressBarBorderStyle'],
					'border-width'               => self::get_css_value( $attr['horizontalProgressBarBorderWidth'], 'px' ),
					'border-color'               => $attr['horizontalProgressBarBorderColor'],
				),
				' .responsive-horizontal-progress-bar-progress' => array(
					'width'            => $attr['progressBarValue'] . '%',
					'background-image' => $horizontal_track_color,
				),
				' .responsive-striped-horizontal-progress-bar-progress' => array(
					'width'            => $attr['progressBarValue'] . '%',
					'background-image' => $horizontal_track_color,
				),
				' .responsive-semi-circular-progress'  => array(
					'width'  => self::get_css_value( $attr['semiCircularProgressBarSize'], 'px' ),
					'height' => self::get_css_value( ( $attr['semiCircularProgressBarSize'] / 2 ), 'px' ),
				),
				' .responsive-semi-circular-progress::after' => array(
					'width'        => self::get_css_value( $attr['semiCircularProgressBarSize'], 'px' ),
					'height'       => self::get_css_value( $attr['semiCircularProgressBarSize'], 'px' ),
					'transform'    => 'rotate(calc(1deg * (-45 + ' . $attr['progressBarValue'] . ' * 1.8)))',
					'border-width' => self::get_css_value( $attr['semiCircularProgressBarWidth'], 'px' ),
					'border-color' => $semi_circular_background_track_colors,
				),
				' .responsive-circular-progress-bar-circle' => array(
					'width'  => self::get_css_value( $attr['circularProgressBarSize'], 'px' ),
					'height' => self::get_css_value( $attr['circularProgressBarSize'], 'px' ),
				),
				' .responsive-circular-progress-bar-circle circle:nth-child(2)' => array(
					'stroke-dasharray'  => $stroke_dash_array_val,
					'stroke-dashoffset' => $stroke_dash_offset_val,
					'stroke'            => $attr['circularProgressBarTrackColor'],
				),
				' .responsive-circular-progress-bar-container:nth-child(1) .responsive-circular-progress-bar-circle circle:nth-child(2)' => array(
					'stroke-dashoffset' => 'calc(' . $stroke_dash_offset_val . ' - (' . $stroke_dash_offset_val . ' * ' . $attr['progressBarValue'] . ') / 100)',
				),
				' .responsive-circular-progress-bar-circle circle' => array(
					'stroke-width'   => self::get_css_value( $attr['circularProgressBarWidth'], 'px' ),
					'stroke'         => $attr['circularProgressBarBackgroundColor'],
					'stroke-linecap' => $attr['circularProgressBarTrackStyle'],
				),
				' .responsive-striped-horizontal-progress-bar-inner-span::after' => array(
					'background-image' => $track_stripe_color,
				),
				' .responsive-horizontal-progress-bar-top-title' => array(
					'color'          => $attr['topTitleValueTypographyColor'],
					'font-family'    => $attr['topTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['topTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['topTitleValueFontWeight'],
					'line-height'    => $attr['topTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['topTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['topTitleValueTextTransform'],
					'font-style'     => $attr['topTitleValueFontStyle'],
				),
				' .responsive-horizontal-progress-bar-top-value' => array(
					'color'          => $attr['topTitleValueTypographyColor'],
					'font-family'    => $attr['topTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['topTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['topTitleValueFontWeight'],
					'line-height'    => $attr['topTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['topTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['topTitleValueTextTransform'],
					'font-style'     => $attr['topTitleValueFontStyle'],
				),
				' .responsive-horizontal-progress-bar-inner-title' => array(
					'color'          => $attr['innerTitleValueTypographyColor'],
					'font-family'    => $attr['innerTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['innerTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['innerTitleValueFontWeight'],
					'line-height'    => $attr['innerTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['innerTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['innerTitleValueTextTransform'],
					'font-style'     => $attr['innerTitleValueFontStyle'],
				),
				' .responsive-horizontal-progress-bar-inner-value' => array(
					'color'          => $attr['innerTitleValueTypographyColor'],
					'font-family'    => $attr['innerTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['innerTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['innerTitleValueFontWeight'],
					'line-height'    => $attr['innerTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['innerTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['innerTitleValueTextTransform'],
					'font-style'     => $attr['innerTitleValueFontStyle'],
				),
				' .responsive-horizontal-progress-bar-bottom-title' => array(
					'color'          => $attr['bottomTitleValueTypographyColor'],
					'font-family'    => $attr['bottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['bottomTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['bottomTitleValueFontWeight'],
					'line-height'    => $attr['bottomTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['bottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['bottomTitleValueTextTransform'],
					'font-style'     => $attr['bottomTitleValueFontStyle'],
				),
				' .responsive-horizontal-progress-bar-bottom-value' => array(
					'color'          => $attr['bottomTitleValueTypographyColor'],
					'font-family'    => $attr['bottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['bottomTitleValueFontSize'], 'px' ),
					'font-weight'    => $attr['bottomTitleValueFontWeight'],
					'line-height'    => $attr['bottomTitleValueLineHeight'],
					'letter-spacing' => self::get_css_value( $attr['bottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['bottomTitleValueTextTransform'],
					'font-style'     => $attr['bottomTitleValueFontStyle'],
				),
				' .responsive-circular-progress-bar-top-title' => array(
					'color'          => $attr['circularTopTitleValueTypographyColor'],
					'font-family'    => $attr['circularTopTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['circularTopTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['circularTopTitleValueLineHeight'],
					'font-weight'    => $attr['circularTopTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['circularTopTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['circularTopTitleValueTextTransform'],
					"font-style"     => $attr['circularTopTitleValueFontStyle'],
				),
				' .responsive-circular-progress-bar-top-value' => array(
					'color'          => $attr['circularTopTitleValueTypographyColor'],
					'font-family'    => $attr['circularTopTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['circularTopTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['circularTopTitleValueLineHeight'],
					'font-weight'    => $attr['circularTopTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['circularTopTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['circularTopTitleValueTextTransform'],
					"font-style"     => $attr['circularTopTitleValueFontStyle'],
				),
				' .responsive-circular-progress-bar-progress' => array(
					'color'           => $attr['circularInnerValueTypographyColor'],
					'font-family'     => $attr['circularInnerValueFontFamily'],
					'font-size'       => self::get_css_value( $attr['circularInnerValueFontSize'], 'px' ),
					'line-height'     => $attr['circularInnerValueLineHeight'],
					'font-weight'     => $attr['circularInnerValueFontWeight'],
					'letter-spacing'  => self::get_css_value( $attr['circularInnerValueLetterSpacing'], 'px' ),
					'display'         => 'flex',
					'justify-content' => 'center',
					'align-items'     => 'center',
					'width'           => self::get_css_value( $attr['circularProgressBarSize'] - 40, 'px' ),
					'height'          => self::get_css_value( $attr['circularProgressBarSize'] - 40, 'px' ),
					'border-radius'   => '100%',
					'overflow'        => 'hidden',
					"font-style"      => $attr['circularInnerValueFontStyle'],
				),
				' .responsive-circular-progress-bar-bottom-title' => array(
					'color'          => $attr['circularBottomTitleValueTypographyColor'],
					'font-family'    => $attr['circularBottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['circularBottomTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['circularBottomTitleValueLineHeight'],
					'font-weight'    => $attr['circularBottomTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['circularBottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['circularBottomTitleValueTextTransform'],
					"font-style"     => $attr['circularBottomTitleValueFontStyle'],
				),
				' .responsive-circular-progress-bar-bottom-value' => array(
					'color'          => $attr['circularBottomTitleValueTypographyColor'],
					'font-family'    => $attr['circularBottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['circularBottomTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['circularBottomTitleValueLineHeight'],
					'font-weight'    => $attr['circularBottomTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['circularBottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['circularBottomTitleValueTextTransform'],
					"font-style"     => $attr['circularBottomTitleValueFontStyle'],
				),
				' .responsive-semi-circular-progress-bar-top-title' => array(
					'color'          => $attr['semiCircularTopTitleValueTypographyColor'],
					'font-family'    => $attr['semiCircularTopTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['semiCircularTopTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['semiCircularTopTitleValueLineHeight'],
					'font-weight'    => $attr['semiCircularTopTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['semiCircularTopTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['semiCircularTopTitleValueTextTransform'],
					"font-style"     => $attr['semiCircularTopTitleValueFontStyle'],
				),
				' .responsive-semi-circular-progress-bar-top-value' => array(
					'color'          => $attr['semiCircularTopTitleValueTypographyColor'],
					'font-family'    => $attr['semiCircularTopTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['semiCircularTopTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['semiCircularTopTitleValueLineHeight'],
					'font-weight'    => $attr['semiCircularTopTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['semiCircularTopTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['semiCircularTopTitleValueTextTransform'],
					"font-style"     => $attr['semiCircularTopTitleValueFontStyle'],
				),
				' .responsive-semi-circular-progress-bar-value' => array(
					'color'          => $attr['semiCircularInnerValueTypographyColor'],
					'font-family'    => $attr['semiCircularInnerValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['semiCircularInnerValueFontSize'], 'px' ),
					'line-height'    => $attr['semiCircularInnerValueLineHeight'],
					'font-weight'    => $attr['semiCircularInnerValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['semiCircularInnerValueLetterSpacing'], 'px' ),
					"font-style"     => $attr['semiCircularInnerValueFontStyle'],
				),
				' .responsive-semi-circular-progress-bar-bottom-title' => array(
					'color'          => $attr['semiCircularBottomTitleValueTypographyColor'],
					'font-family'    => $attr['semiCircularBottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['semiCircularBottomTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['semiCircularBottomTitleValueLineHeight'],
					'font-weight'    => $attr['semiCircularBottomTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['semiCircularBottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['semiCircularBottomTitleValueTextTransform'],
					"font-style"     => $attr['semiCircularBottomTitleValueFontStyle'],
				),
				' .responsive-semi-circular-progress-bar-bottom-value' => array(
					'color'          => $attr['semiCircularBottomTitleValueTypographyColor'],
					'font-family'    => $attr['semiCircularBottomTitleValueFontFamily'],
					'font-size'      => self::get_css_value( $attr['semiCircularBottomTitleValueFontSize'], 'px' ),
					'line-height'    => $attr['semiCircularBottomTitleValueLineHeight'],
					'font-weight'    => $attr['semiCircularBottomTitleValueFontWeight'],
					'letter-spacing' => self::get_css_value( $attr['semiCircularBottomTitleValueLetterSpacing'], 'px' ),
					'text-transform' => $attr['semiCircularBottomTitleValueTextTransform'],
					"font-style"     => $attr['semiCircularBottomTitleValueFontStyle'],
				),
				' .stripe-movement-effect::after'      => array(
					'animation-duration' => $stripe_animation_duration_val . 's',
				),
			);

			$mobile_selectors = array(
				' '                                    => array(
					'display' => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexMobile'],
				),
				' .responsive-horizontal-progress-bar-container, .responsive-circular-progress-bar-container' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['topTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['topTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-inner-title' => array(
					'font-size' => self::get_css_value( $attr['innerTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-inner-value' => array(
					'font-size' => self::get_css_value( $attr['innerTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['bottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['bottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-circular-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['circularTopTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-circular-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['circularTopTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-circular-progress-bar-progress' => array(
					'font-size' => self::get_css_value( $attr['circularInnerValueFontSizeMobile'], 'px' ),
				),
				' .responsive-circular-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['circularBottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-circular-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['circularBottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['semiCircularTopTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularTopTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularInnerValueFontSizeMobile'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['semiCircularBottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularBottomTitleValueFontSizeMobile'], 'px' ),
				),
				' .responsive-horizontal-progress-bar' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['horizontalProgressBarTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['horizontalProgressBarRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['horizontalProgressBarBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['horizontalProgressBarLeftRadiusMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' '                                    => array(
					'display' => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'z-index' => $attr['z_indexTablet'],
				),
				' .responsive-horizontal-progress-bar-container,.responsive-circular-progress-bar-container' => array(
					'padding-top'    => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ),
					'margin-top'     => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ),
					'margin-right'   => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ),
					'margin-bottom'  => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ),
					'margin-left'    => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['topTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['topTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-inner-title' => array(
					'font-size' => self::get_css_value( $attr['innerTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-inner-value' => array(
					'font-size' => self::get_css_value( $attr['innerTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['bottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['bottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-circular-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['circularTopTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-circular-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['circularTopTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-circular-progress-bar-progress' => array(
					'font-size' => self::get_css_value( $attr['circularInnerValueFontSizeTablet'], 'px' ),
				),
				' .responsive-circular-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['circularBottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-circular-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['circularBottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-top-title' => array(
					'font-size' => self::get_css_value( $attr['semiCircularTopTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-top-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularTopTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularInnerValueFontSizeTablet'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-bottom-title' => array(
					'font-size' => self::get_css_value( $attr['semiCircularBottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-semi-circular-progress-bar-bottom-value' => array(
					'font-size' => self::get_css_value( $attr['semiCircularBottomTitleValueFontSizeTablet'], 'px' ),
				),
				' .responsive-horizontal-progress-bar' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['horizontalProgressBarTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['horizontalProgressBarRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['horizontalProgressBarBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['horizontalProgressBarLeftRadiusTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-progress-bar.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for Progress Bar block
		 *
		 * @return array
		 */
		public static function get_responsive_block_progress_bar_default_attributes() {
			return array(
				'block_id'                                 => '',
				'progressBarStyle'                         => 'horizontal',
				'progressBarColorType'                     => 'default',
				'horizontalProgressBarStyle'               => 'plain',
				'circularProgressBarStyle'                 => 'circle',
				'progressBarTopTitle'                      => '',
				'progressBarTopTitleEnable'                => true,
				'progressBarTopValueEnable'                => true,
				'progressBarValue'                         => 50,
				'progressBarInnerTitle'                    => '',
				'progressBarInnerTitleEnable'              => false,
				'progressBarInnerValueEnable'              => true,
				'progressBarBottomTitle'                   => '',
				'progressBarBottomTitleEnable'             => false,
				'progressBarBottomValueEnable'             => false,
				'circularProgressBarTopTitle'              => '',
				'circularProgressBarBottomTitle'           => '',
				'circularProgressBarValueEnable'           => true,
				'circularProgressBarTopTitleEnable'        => true,
				'circularProgressBarTopValueEnable'        => false,
				'circularProgressBarBottomTitleEnable'     => true,
				'circularProgressBarBottomValueEnable'     => false,
				'semiCircularProgressBarValueEnable'       => true,
				'semiCircularProgressBarTopTitle'          => '',
				'semiCircularProgressBarBottomTitle'       => '',
				'semiCircularProgressBarTopTitleEnable'    => true,
				'semiCircularProgressBarTopValueEnable'    => false,
				'semiCircularProgressBarBottomTitleEnable' => true,
				'semiCircularProgressBarBottomValueEnable' => false,
				'horizontalProgressBarSize'                => 25,
				'semiCircularProgressBarSize'              => 200,
				'circularProgressBarSize'                  => 150,
				'circularProgressBarWidth'                 => 10,
				'semiCircularProgressBarWidth'             => 10,
				'horizontalProgressBarBackgroundColor'     => '#d9d9d9',
				'horizontalProgressBarPrimaryTrackColor'   => '#80bfff',
				'gradientTrack'                            => true,
				'horizontalProgressBarSecondaryTrackColor' => '#1a8cff',
				'horizontalProgressBarStripeColor'         => '#fff',
				'horizontalProgressBarTopTitleValueColor'  => '#333333',
				'horizontalProgressBarInnerTitleValueColor' => '#333333',
				'horizontalProgressBarBottomTitleValueColor' => '#333333',
				'horizontalProgressBarBorderRadius'        => 5,
				'horizontalProgressBarBorderStyle'         => 'solid',
				'horizontalProgressBarBorderWidth'         => 0,
				'horizontalProgressBarBorderColor'         => '#333333',
				'topTitleValueFontFamily'                  => '',
				'topTitleValueFontSize'                    => '',
				'topTitleValueFontSizeMobile'              => '',
				'topTitleValueFontSizeTablet'              => '',
				'topTitleValueFontWeight'                  => '400',
				'topTitleValueLineHeight'                  => 1,
				'topTitleValueLetterSpacing'               => 1,
				'topTitleValueTextTransform'               => '',
				'innerTitleValueFontFamily'                => '',
				'innerTitleValueFontSize'                  => '',
				'innerTitleValueFontSizeMobile'            => '',
				'innerTitleValueFontSizeTablet'            => '',
				'innerTitleValueFontWeight'                => '400',
				'innerTitleValueLineHeight'                => 1,
				'innerTitleValueLetterSpacing'             => 1,
				'innerTitleValueTextTransform'             => '',
				'bottomTitleValueFontFamily'               => '',
				'bottomTitleValueFontSize'                 => '',
				'bottomTitleValueFontSizeMobile'           => '',
				'bottomTitleValueFontSizeTablet'           => '',
				'bottomTitleValueFontWeight'               => '400',
				'bottomTitleValueLineHeight'               => 1,
				'bottomTitleValueLetterSpacing'            => 1,
				'bottomTitleValueTextTransform'            => '',
				'stripedHorizontalProgressBarAnimationTime' => 20,
				'circularProgressBarBackgroundColor'       => '#d9d9d9',
				'circularProgressBarTrackColor'            => '#6665ae',
				'circularProgressBarTopTitleValueColor'    => '#333333',
				'circularProgressBarInnerValueColor'       => '#333333',
				'circularProgressBarBottomTitleValueColor' => '#333333',
				'semiCircularProgressBarTopTitleValueColor' => '#333333',
				'semiCircularProgressBarInnerValueColor'   => '#333333',
				'semiCircularProgressBarBottomTitleValueColor' => '#333333',
				'circularProgressBarTrackStyle'            => 'square',
				'circularTopTitleValueFontFamily'          => '',
				'circularTopTitleValueFontSize'            => '',
				'circularTopTitleValueFontSizeMobile'      => '',
				'circularTopTitleValueFontSizeTablet'      => '',
				'circularTopTitleValueFontWeight'          => '400',
				'circularTopTitleValueLineHeight'          => 1,
				'circularTopTitleValueLetterSpacing'       => 1,
				'circularTopTitleValueTextTransform'       => '',
				'circularBottomTitleValueFontFamily'       => '',
				'circularBottomTitleValueFontSize'         => '',
				'circularBottomTitleValueFontSizeMobile'   => '',
				'circularBottomTitleValueFontSizeTablet'   => '',
				'circularBottomTitleValueFontWeight'       => '400',
				'circularBottomTitleValueLineHeight'       => 1,
				'circularBottomTitleValueLetterSpacing'    => 1,
				'circularBottomTitleValueTextTransform'    => '',
				'circularInnerValueFontFamily'             => '',
				'circularInnerValueFontSize'               => '',
				'circularInnerValueFontSizeMobile'         => '',
				'circularInnerValueFontSizeTablet'         => '',
				'circularInnerValueFontWeight'             => '400',
				'circularInnerValueLineHeight'             => 1,
				'circularInnerValueLetterSpacing'          => 1,
				'semiCircularTopTitleValueFontFamily'      => '',
				'semiCircularTopTitleValueFontSize'        => '',
				'semiCircularTopTitleValueFontSizeMobile'  => '',
				'semiCircularTopTitleValueFontSizeTablet'  => '',
				'semiCircularTopTitleValueFontWeight'      => '400',
				'semiCircularTopTitleValueLineHeight'      => 1,
				'semiCircularTopTitleValueLetterSpacing'   => 0,
				'semiCircularTopTitleValueTextTransform'   => '',
				'semiCircularBottomTitleValueFontFamily'   => '',
				'semiCircularBottomTitleValueFontSize'     => '',
				'semiCircularBottomTitleValueFontSizeMobile' => '',
				'semiCircularBottomTitleValueFontSizeTablet' => '',
				'semiCircularBottomTitleValueFontWeight'   => '400',
				'semiCircularBottomTitleValueLineHeight'   => 1,
				'semiCircularBottomTitleValueLetterSpacing' => 1,
				'semiCircularBottomTitleValueTextTransform' => '',
				'semiCircularInnerValueFontFamily'         => '',
				'semiCircularInnerValueFontSize'           => '',
				'semiCircularInnerValueFontSizeMobile'     => '',
				'semiCircularInnerValueFontSizeTablet'     => '',
				'semiCircularInnerValueFontWeight'         => '400',
				'semiCircularInnerValueLineHeight'         => 1,
				'semiCircularInnerValueLetterSpacing'      => 1,
				'semiCircularProgressBarBackgroundColor'   => '#d9d9d9',
				'semiCircularProgressBarTrackColor'        => '#1a8cff',
				'hideWidget'                               => false,
				'hideWidgetMobile'                         => false,
				'hideWidgetTablet'                         => false,
				'z_index'                                  => 1,
				'z_indexMobile'                            => 1,
				'z_indexTablet'                            => 1,
				'blockTopPadding'                          => '',
				'blockTopPaddingMobile'                    => '',
				'blockTopPaddingTablet'                    => '',
				'blockBottomPadding'                       => '',
				'blockBottomPaddingMobile'                 => '',
				'blockBottomPaddingTablet'                 => '',
				'blockLeftPadding'                         => '',
				'blockLeftPaddingMobile'                   => '',
				'blockLeftPaddingTablet'                   => '',
				'blockRightPadding'                        => '',
				'blockRightPaddingMobile'                  => '',
				'blockRightPaddingTablet'                  => '',
				'blockTopMargin'                           => '',
				'blockTopMarginMobile'                     => '',
				'blockTopMarginTablet'                     => '',
				'blockBottomMargin'                        => '',
				'blockBottomMarginMobile'                  => '',
				'blockBottomMarginTablet'                  => '',
				'blockLeftMargin'                          => '',
				'blockLeftMarginMobile'                    => '',
				'blockLeftMarginTablet'                    => '',
				'blockRightMargin'                         => '',
				'blockRightMarginMobile'                   => '',
				'blockRightMarginTablet'                   => '',
				'horizontalProgressBarTopRadiusMobile'     => 0,
				'horizontalProgressBarRightRadiusMobile'   => 0,
				'horizontalProgressBarBottomRadiusMobile'  => 0,
				'horizontalProgressBarLeftRadiusMobile'    => 0,
				'horizontalProgressBarTopRadiusTablet'     => 0,
				'horizontalProgressBarRightRadiusTablet'   => 0,
				'horizontalProgressBarBottomRadiusTablet'  => 0,
				'horizontalProgressBarLeftRadiusTablet'    => 0,
				'horizontalProgressBarTopRadius'           => 0,
				'horizontalProgressBarRightRadius'         => 0,
				'horizontalProgressBarBottomRadius'        => 0,
				'horizontalProgressBarLeftRadius'          => 0,
				'topTitleValueTypographyColor'             => '#333333',
				'innerTitleValueTypographyColor'           => '#333333',
				'bottomTitleValueTypographyColor'          => '#333333',
				'circularTopTitleValueTypographyColor'     => '#333333',
				'circularInnerValueTypographyColor'        => '#333333',
				'circularBottomTitleValueTypographyColor'  => '#333333',
				'semiCircularTopTitleValueTypographyColor' => '#333333',
				'semiCircularInnerValueTypographyColor'    => '#333333',
				'semiCircularBottomTitleValueTypographyColor' => '#333333',
				'topTitleValueFontStyle'                   => '',
				'innerTitleValueFontStyle'                 => '',
				'bottomTitleValueFontStyle'                => '',
				'circularTopTitleValueFontStyle'           => '',
				'circularInnerValueFontStyle'              => '',
				'circularBottomTitleValueFontStyle'        => '',
				'semiCircularTopTitleValueFontStyle'       => '',
				'semiCircularInnerValueFontStyle'          => '',
				'semiCircularBottomTitleValueFontStyle'    => '',
			);
		}

		/**
		 * Get Social Icons Block CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_social_icons_css( $attr, $id ) {
			$defaults = self::get_responsive_block_social_icons_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			// Change the vaule of iconContainerSize to 5px for backward compatibility.
			if(isset($attr['iconContainerSize']) && ($attr['iconContainerSize'] === 120 || $attr['iconContainerSize'] === 103)) {
				$attr['iconContainerSize'] = 5;
			}

			$new_border_radius_keys = array(
				'iconContainerTopPadding'          => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerBottomPadding'       => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerLeftPadding'         => 'iconContainerSize' ? 'iconContainerSize' : 5,
				'iconContainerRightPadding'        => 'iconContainerSize' ? 'iconContainerSize' : 5,
				'iconContainerTopPaddingTablet'    => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerBottomPaddingTablet' => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerRightPaddingTablet'  => 'iconContainerSize' ? 'iconContainerSize' : 5,
				'iconContainerLeftPaddingTablet'   => 'iconContainerSize' ? 'iconContainerSize' : 5,
				'iconContainerTopPaddingMobile'    => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerBottomPaddingMobile' => 'iconContainerHeight' ? 'iconContainerHeight' : 5,
				'iconContainerLeftPaddingMobile'   => 'iconContainerSize' ? 'iconContainerSize' : 5,
				'iconContainerRightPaddingMobile'  => 'iconContainerSize' ? 'iconContainerSize' : 5,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'labelTypographyColor' => 'labelColor' ? 'labelColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr = array_merge( $defaults, (array) $attr );

			$mobile_selectors = array();
			$tablet_selectors = array();

			$icon_shape_radius = '';
			if ( 'square' === $attr['iconShape'] ) {
				$icon_shape_radius = '0%';
			} elseif ( 'rounded' === $attr['iconShape'] ) {
				$icon_shape_radius = '10%';
			} elseif ( 'circle' === $attr['iconShape'] ) {
				$icon_shape_radius = '100%';
			}

			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];

			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}

			$newopacity = $attr['opacity'] / 100;
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;

			$selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'block',
					'position'                   => 'relative',
					'margin-top'                 => self::get_css_value( $attr['blockTopMargin'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMargin'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['blockLeftMargin'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['blockRightMargin'], 'px' ) . '!important',
					'padding-top'                => self::get_css_value( $attr['blockTopPadding'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPadding'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['blockLeftPadding'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['blockRightPadding'], 'px' ) . '!important',
					'z-index'                    => $attr['z_index'],
					'background-color'           => self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $newopacity ),
					'border-color'               => $attr['blockBorderColor'],
					'border-style'               => $attr['blockBorderStyle'],
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'box-shadow'                 =>
					self::get_css_value( $attr['boxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['boxShadowSpread'], 'px' ) .
					' ' .
					$attr['boxShadowColor'] .
					' ' .
					$box_shadow_position_css,
					'min-width'                  => 'fit-content',
					'max-width'                  => '100%',
				),
				':hover' => array(
					'box-shadow'                 => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ?
					self::get_css_value( $attr['hoverboxShadowHOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowVOffset'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowBlur'], 'px' ) .
					' ' .
					self::get_css_value( $attr['hoverboxShadowSpread'], 'px' ) .
					' ' .
					$attr['hoverboxShadowColor'] .
					' ' .
					$hover_box_shadow_position_css : '',
				),
				' .responsive-block-editor-addons-social-icon' => array(
					'border-radius'    => $icon_shape_radius,
					'fill'             => 'custom' === $attr['iconColorType'] ? $attr['iconPrimaryColor'] : '',
					'background-color' => 'custom' === $attr['iconColorType'] && 'flat' === $attr['skin'] ? $attr['iconSecondaryColor'] : '',
					'border'           => 'custom' === $attr['iconColorType'] && ( 'framed' === $attr['skin'] || 'boxed' === $attr['skin'] ) ? '1px solid ' . $attr['iconSecondaryColor'] : '',
					'display'          => 'flex',
					'justify-content'  => 'center',
					'padding-top'      => self::get_css_value( $attr['iconContainerTopPadding'], 'px' ),
					'padding-bottom'   => self::get_css_value( $attr['iconContainerBottomPadding'], 'px' ),
					'padding-left'     => self::get_css_value( $attr['iconContainerLeftPadding'], 'px' ),
					'padding-right'    => self::get_css_value( $attr['iconContainerRightPadding'], 'px' ),
					'width'            => 'fit-content',
				),
				' .responsive-block-editor-addons-social-icon > a:first-child' => array(
					'padding'          => 'boxed' === $attr['skin'] || 'minimal' === $attr['skin'] ? '0 10px 0 10px' : '',
					'background-color' => ( 'boxed' === $attr['skin'] || 'minimal' === $attr['skin'] ) ? $attr['iconSecondaryColor'] : '',
				),
				' .responsive-block-editor-addons-social-icon > a:last-child' => array(
					'padding' => ( 'boxed' === $attr['skin'] || 'minimal' === $attr['skin'] ) ? '0 10px 0 0' : '',
				),
				' .responsive-block-editor-addons-social-icon-svg svg' => array(
					'height' => self::get_css_value( $attr['iconSize'], 'px' ),
					'width'  => self::get_css_value( $attr['iconSize'], 'px' ),
					'fill'   => 'custom' === $attr['iconColorType'] ? $attr['iconPrimaryColor'] : '',
				),
				' .responsive-block-editor-addons-social-icons-container' => array(
					'display'               => 'inline-grid',
					'grid-template-columns' =>
					'auto' !== $attr['iconColumns'] ? 'repeat(' . $attr['iconColumns'] . ' , auto)' : '',
					'grid-auto-flow'        =>
					'auto' !== $attr['iconColumns'] ? '' : 'column',
					'grid-column-gap'       => self::get_css_value( $attr['iconColumnsGap'], 'px' ),
					'grid-row-gap'          => self::get_css_value( $attr['iconRowsGap'], 'px' ),
				),
				' .responsive-block-editor-addons-social-icon-label' => array(
					'font-size'   => self::get_css_value( $attr['labelFontSize'], 'px' ),
					'font-family' => $attr['labelFontFamily'],
					'text-transform'=> $attr['labelTextTransform'],
      				'font-style'  => $attr['labelFontStyle'],
					'font-weight' => $attr['labelFontWeight'],
					'line-height' => $attr['labelLineHeight'],
					'margin-left' => self::get_css_value( $attr['iconLabelGap'], 'px' ),
					'color'       => $attr['labelTypographyColor'],
				),
				' .responsive-block-editor-addons-icon-facebook, .responsive-block-editor-addons-icon-facebook-f, .responsive-block-editor-addons-icon-facebook-square, .responsive-block-editor-addons-icon-facebook-messenger' => array(
					'fill' => '#3b5998',
				),
				' .responsive-block-editor-addons-icon-twitter, .responsive-block-editor-addons-icon-twitter-square' => array(
					'fill' => '#00aced',
				),
				' .responsive-block-editor-addons-icon-linkedin, .responsive-block-editor-addons-icon-linkedin-in' => array(
					'fill' => '#007bb6',
				),
				' .responsive-block-editor-addons-icon-youtube, .responsive-block-editor-addons-icon-youtube-square' => array(
					'fill' => '#bb0000',
				),
				' .responsive-block-editor-addons-icon-pinterest, .responsive-block-editor-addons-icon-pinterest-p, .responsive-block-editor-addons-icon-pinterest-square' => array(
					'fill' => '#bb0000',
				),
				' .responsive-block-editor-addons-icon-instagram' => array(
					'fill' => '#e95950',
				),
				' .responsive-block-editor-addons-icon-snapchat, .responsive-block-editor-addons-icon-snapchat-ghost,  .responsive-block-editor-addons-icon-snapchat-square' => array(
					'fill' => '#fffc00',
				),
				' .responsive-block-editor-addons-icon-tumblr, .responsive-block-editor-addons-icon-tumblr-square' => array(
					'fill' => '#32506d',
				),
				' .responsive-block-editor-addons-icon-vimeo, .responsive-block-editor-addons-icon-vimeo-v, .responsive-block-editor-addons-icon-vimeo-square' => array(
					'fill' => '#aad450',
				),
				' .responsive-block-editor-addons-icon-quora' => array(
					'fill' => '#a82400',
				),
				' .responsive-block-editor-addons-icon-google-plus, .responsive-block-editor-addons-icon-google-plus-g, .responsive-block-editor-addons-icon-google-plus-square' => array(
					'fill' => '#dd4b39',
				),
				' .responsive-block-editor-addons-icon-reddit, .responsive-block-editor-addons-icon-reddit-alien, .responsive-block-editor-addons-icon-reddit-square' => array(
					'fill' => '#FF5700',
				),
				' .responsive-block-editor-addons-icon-skype' => array(
					'fill' => '#00aff0',
				),
				' .responsive-block-editor-addons-icon-telegram, .responsive-block-editor-addons-icon-telegram-plane' => array(
					'fill' => '#0088cc',
				),
				' .responsive-block-editor-addons-icon-whatsapp, .responsive-block-editor-addons-icon-whatsapp-square' => array(
					'fill' => '#34B7F1',
				),
				' .responsive-block-editor-addons-icon-envelope' => array(
					'fill' => '#BB001B',
				),
			);

			$mobile_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'block',
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginMobile'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginMobile'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginMobile'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['blockRightMarginMobile'], 'px' ) . '!important',
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingMobile'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingMobile'], 'px' ) . '!important',
					'z-index'                    => $attr['z_indexMobile'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-social-icon-label' => array(
					'font-size' => self::get_css_value( $attr['labelFontSizeMobile'], 'px' ),
				),
				' .responsive-block-editor-addons-social-icons-container' => array(
					'grid-template-columns' =>
					'auto' !== $attr['iconColumnsMobile'] ? 'repeat(' . $attr['iconColumnsMobile'] . ' , auto)' : '',
					'grid-auto-flow'        =>
					'auto' !== $attr['iconColumnsMobile'] ? 'unset' : 'column',
				),
				' .responsive-block-editor-addons-social-icon' => array(
					'padding-top'    => self::get_css_value( $attr['iconContainerTopPaddingMobile'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['iconContainerBottomPaddingMobile'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['iconContainerLeftPaddingMobile'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['iconContainerRightPaddingMobile'], 'px' ),
				),
			);

			$tablet_selectors = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'block',
					'margin-top'                 => self::get_css_value( $attr['blockTopMarginTablet'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['blockBottomMarginTablet'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['blockLeftMarginTablet'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['blockRightMarginTablet'], 'px' ) . '!important',
					'padding-top'                => self::get_css_value( $attr['blockTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['blockBottomPaddingTablet'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['blockLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['blockRightPaddingTablet'], 'px' ) . '!important',
					'z-index'                    => $attr['z_indexTablet'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-social-icon-label' => array(
					'font-size' => self::get_css_value( $attr['labelFontSizeTablet'], 'px' ),
				),
				' .responsive-block-editor-addons-social-icons-container' => array(
					'grid-template-columns' =>
					'auto' !== $attr['iconColumnsTablet'] ? 'repeat(' . $attr['iconColumnsTablet'] . ' , auto)' : '',
					'grid-auto-flow'        =>
					'auto' !== $attr['iconColumnsTablet'] ? 'unset' : 'column',
				),
				' .responsive-block-editor-addons-social-icon' => array(
					'padding-top'    => self::get_css_value( $attr['iconContainerTopPaddingTablet'], 'px' ),
					'padding-bottom' => self::get_css_value( $attr['iconContainerBottomPaddingTablet'], 'px' ),
					'padding-left'   => self::get_css_value( $attr['iconContainerLeftPaddingTablet'], 'px' ),
					'padding-right'  => self::get_css_value( $attr['iconContainerRightPaddingTablet'], 'px' ),
				),
			);

			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);

			$id  = '.responsive-block-editor-addons-block-social-icons.block-' . $id;
			$css = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for social icons block
		 *
		 * @return array
		 */
		public static function get_responsive_block_social_icons_default_attributes() {
			return array(
				'block_id'                         => '',
				'socialMediaIcons'                 => '',
				'iconShape'                        => 'square',
				'iconColorType'                    => 'official',
				'iconPrimaryColor'                 => '#0112ff',
				'iconSecondaryColor'               => '#e4f3ff',
				'showIconLabel'                    => true,
				'iconSize'                         => 30,
				'iconColumns'                      => 'auto',
				'iconColumnsGap'                   => 15,
				'iconRowsGap'                      => 10,
				'iconsAlign'                       => 'left',
				'iconContainerHeight'              => 5,
				'iconContainerSize'                => 5,
				'socialZindex'                     => 0,
				'blockTopPadding'                  => '',
				'blockBottomPadding'               => '',
				'blockLeftPadding'                 => '',
				'blockRightPadding'                => '',
				'blockTopPaddingTablet'            => '',
				'blockBottomPaddingTablet'         => '',
				'blockLeftPaddingTablet'           => '',
				'blockRightPaddingTablet'          => '',
				'blockTopPaddingMobile'            => '',
				'blockBottomPaddingMobile'         => '',
				'blockLeftPaddingMobile'           => '',
				'blockRightPaddingMobile'          => '',
				'blockTopMargin'                   => '',
				'blockBottomMargin'                => '',
				'blockLeftMargin'                  => '',
				'blockRightMargin'                 => '',
				'blockTopMarginMobile'             => '',
				'blockBottomMarginMobile'          => '',
				'blockLeftMarginMobile'            => '',
				'blockRightMarginMobile'           => '',
				'blockTopMarginTablet'             => '',
				'blockBottomMarginTablet'          => '',
				'blockLeftMarginTablet'            => '',
				'blockRightMarginTablet'           => '',
				'labelFontFamily'                  => 'Default',
				'labelFontSize'                    => 16,
				'labelFontSizeMobile'              => 16,
				'labelFontSizeTablet'              => 16,
				'labelFontWeight'                  => '500',
				'labelLineHeight'                  => 1,
				'iconLabelGap'                     => 5,
				'labelColor'                       => '#333',
				'viewOption'                       => 'icontext',
				'skin'                             => 'default',
				'blockBorderStyle'                 => 'none',
				'blockBorderWidth'                 => 2,
				'blockBorderRadius'                => '',
				'blockBorderColor'                 => '',
				'boxShadowColor'                   => '',
				'boxShadowHOffset'                 => 0,
				'boxShadowVOffset'                 => 0,
				'boxShadowBlur'                    => 0,
				'boxShadowSpread'                  => 0,
				'boxShadowPosition'                => 'outset',
				'hoverboxShadowColor'              => '',
				'hoverboxShadowHOffset'            => 0,
				'hoverboxShadowVOffset'            => 0,
				'hoverboxShadowBlur'               => 0,
				'hoverboxShadowSpread'             => 0,
				'hoverboxShadowPosition'           => 'outset',
				'backgroundColor'                  => '#fff',
				'opacity'                          => 100,
				'iconColumnsMobile'                => '2',
				'iconColumnsTablet'                => 'auto',
				'hideWidget'                       => false,
				'hideWidgetMobile'                 => false,
				'hideWidgetTablet'                 => false,
				'z_index'                          => 1,
				'z_indexMobile'                    => 1,
				'z_indexTablet'                    => 1,
				'blockTopRadiusMobile'             => 0,
				'blockRightRadiusMobile'           => 0,
				'blockBottomRadiusMobile'          => 0,
				'blockLeftRadiusMobile'            => 0,
				'blockTopRadiusTablet'             => 0,
				'blockRightRadiusTablet'           => 0,
				'blockBottomRadiusTablet'          => 0,
				'blockLeftRadiusTablet'            => 0,
				'blockTopRadius'                   => 0,
				'blockRightRadius'                 => 0,
				'blockBottomRadius'                => 0,
				'blockLeftRadius'                  => 0,
				'labelTypographyColor'             => '#333',
				'iconContainerTopPadding'          => 5,
				'iconContainerBottomPadding'       => 5,
				'iconContainerLeftPadding'         => 5,
				'iconContainerRightPadding'        => 5,
				'iconContainerTopPaddingTablet'    => 5,
				'iconContainerBottomPaddingTablet' => 5,
				'iconContainerRightPaddingTablet'  => 5,
				'iconContainerLeftPaddingTablet'   => 5,
				'iconContainerTopPaddingMobile'    => 5,
				'iconContainerBottomPaddingMobile' => 5,
				'iconContainerLeftPaddingMobile'   => 5,
				'iconContainerRightPaddingMobile'  => 5,
				'labelTextTransform'               => '',
    			'labelFontStyle'                   => '',
			);
		}

		/**
		 * Get Tabs CSS
		 *
		 * @param array  $attr The block attributes.
		 * @param string $id The selector ID.
		 * @return array Styles.
		 */
		public static function get_responsive_block_tabs_css( $attr, $id ) {
			$defaults = self::get_responsive_block_tabs_default_attributes();

			$new_border_radius_keys = array(
				'blockTopRadius'          => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadius'        => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadius'       => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadius'         => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusTablet'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusTablet'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusTablet' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusTablet'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockTopRadiusMobile'    => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockRightRadiusMobile'  => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockBottomRadiusMobile' => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
				'blockLeftRadiusMobile'   => 'blockBorderRadius' ? 'blockBorderRadius' : 0,
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_border_radius_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$new_typography_settings_keys = array(
				'tabTitleTypographyColor'       => 'tabTitleColor' ? 'tabTitleColor' : '',
				'tabTitleActiveTypographyColor' => 'tabTitleActiveColor' ? 'tabTitleActiveColor' : '',
				'tabContentTypographyColor'     => 'tabContentColor' ? 'tabContentColor' : '',
			);

			// To populate new control values with existing control values for backward compatibility.
			foreach ( $new_typography_settings_keys as $attr_key => $default_key ) {
				if ( array_key_exists( $attr_key, $defaults ) ) {
					$defaults[ $attr_key ] = isset( $attr[ $default_key ] ) ? $attr[ $default_key ] : $defaults[ $attr_key ];
				}
			}

			$attr             = array_merge( $defaults, (array) $attr );
			$mobile_selectors = array();
			$tablet_selectors = array();
			$img_opacity      = 0 === $attr['opacity'] / 100 ? '0.0' : $attr['opacity'] / 100;
			if ( 'hstyle3' === $attr['tabsStyleD'] ) {
				$active_tab_border_bottom = '0px';
				$active_tab_border_right  = self::get_css_value( $attr['tabBorderWidth'], 'px' );
				$active_tab_border_left   = self::get_css_value( $attr['tabBorderWidth'], 'px' );
			} elseif ( 'vstyle8' === $attr['tabsStyleD'] && 'left' === $attr['alignTabsVertical'] ) {
				$active_tab_border_bottom = self::get_css_value( $attr['tabBorderWidth'], 'px' );
				$active_tab_border_left   = self::get_css_value( $attr['tabBorderWidth'], 'px' );
				$active_tab_border_right  = '0px';
			} elseif ( 'vstyle8' === $attr['tabsStyleD'] && 'right' === $attr['alignTabsVertical'] ) {
				$active_tab_border_bottom = self::get_css_value( $attr['tabBorderWidth'], 'px' );
				$active_tab_border_right  = self::get_css_value( $attr['tabBorderWidth'], 'px' );
				$active_tab_border_left   = '0px';
			}
			$box_shadow_position_css       = $attr['boxShadowPosition'];
			$hover_box_shadow_position_css = $attr['hoverboxShadowPosition'];
			if ( 'outset' === $attr['boxShadowPosition'] ) {
				$box_shadow_position_css = '';
			}
			if ( 'outset' === $attr['hoverboxShadowPosition'] ) {
				$hover_box_shadow_position_css = '';
			}
			$is_on = array_column( (array) get_option( 'rbea_blocks' ), 'status', 'key' )['responsive-conditions'] ?? 1;
			$selectors          = array(
				' '      => array(
					'display'                    => true === $attr['hideWidget'] && $is_on ? 'none' : 'flex',
					'position'                   => 'relative',
					'padding-top'                => self::get_css_value( $attr['tabsTopPadding'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['tabsBottomPadding'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['tabsLeftPadding'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['tabsRightPadding'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['tabsTopMargin'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['tabsBottomMargin'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['tabsLeftMargin'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['tabsRightMargin'], 'px' ) . '!important',
					'z-index'                    => $attr['z_index'],
					'background-color'           => 'color' === $attr['backgroundType'] ? self::hex_to_rgb( $attr['backgroundColor'] ? $attr['backgroundColor'] : '#fff', $img_opacity ) : '',
					'background-image'           => 'gradient' === $attr['backgroundType'] ? self::generate_background_image_effect(
						self::hex_to_rgb( $attr['backgroundColor1'], $img_opacity ),
						self::hex_to_rgb( $attr['backgroundColor2'], $img_opacity ),
						$attr['gradientDirection'],
						$attr['colorLocation1'],
						$attr['colorLocation2']
					) : '',
					'border-style'               => $attr['blockBorderStyle'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadius'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadius'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadius'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadius'], 'px' ),
					'border-width'               => self::get_css_value( $attr['blockBorderWidth'], 'px' ),
					'border-color'               => $attr['blockBorderColor'],
					'animation-name'             => $attr['animationName'] . '' . $attr['animationDirection'],
					'animation-timing-function'  => $attr['animationCurve'],
					'animation-duration'         => $attr['animationDuration'] . 'ms',
					'animation-delay'            => $attr['animationDelay'] . 'ms',
					'animation-iteration-count'  => 'once' === $attr['animationRepeat'] ? 1 : 'infinite',
					'box-shadow'                 => $attr['boxShadowHOffset'] . 'px ' . $attr['boxShadowVOffset'] . 'px ' . $attr['boxShadowBlur'] . 'px ' . $attr['boxShadowSpread'] . 'px ' . $attr['boxShadowColor'] . ' ' . $box_shadow_position_css,
				),
				':hover' => array(
					'background-color' => 'color' === $attr['backgroundType'] ? self::hex_to_rgb( $attr['backgroundHoverColor'] ? $attr['backgroundHoverColor'] : '#fff', $img_opacity ) : '',
					'background-image' => 'gradient' === $attr['backgroundType'] ? self::generate_background_image_effect(
						self::hex_to_rgb( $attr['hoverbackgroundColor1'], $img_opacity ),
						self::hex_to_rgb( $attr['hoverbackgroundColor2'], $img_opacity ),
						$attr['hovergradientDirection'],
						$attr['hovercolorLocation1'],
						$attr['hovercolorLocation2']
					) : '',
					'box-shadow'       => ( isset( $attr['hoverboxShadowColor'] ) && ! empty( $attr['hoverboxShadowColor'] ) ) ? $attr['hoverboxShadowHOffset'] . 'px ' . $attr['hoverboxShadowVOffset'] . 'px ' . $attr['hoverboxShadowBlur'] . 'px ' . $attr['hoverboxShadowSpread'] . 'px ' . $attr['hoverboxShadowColor'] . ' ' . $hover_box_shadow_position_css : '',
				),
				' > .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab.responsive-block-editor-addons-tabs__active' => array(
					'background' => $attr['tabBackgroundColor'],
				),
				' > .responsive-block-editor-addons-tabs__body-wrap ' => array(
					'background' => $attr['tabBackgroundColor'],
				),
				'.responsive-block-editor-addons-tabs__wrap > .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab' => array(
					'border-style'        => $attr['tabBorderWidth'] > 0 ? 'solid' : 'none',
					'border-top-width'    => self::get_css_value( $attr['tabBorderWidth'], 'px' ),
					'border-left-width'   => $active_tab_border_left,
					'border-bottom-width' => $active_tab_border_bottom,
					'border-right-width'  => $active_tab_border_right,
					'border-color'        => 'transparent',
					'text-align'          => 'vstyle8' === $attr['tabsStyleD'] ? 'center' : 'left',
				),
				'.responsive-block-editor-addons-tabs__wrap > .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab.responsive-block-editor-addons-tabs__active' => array(
					'border-style'        => $attr['tabBorderWidth'] > 0 ? 'solid' : 'none',
					'border-top-width'    => self::get_css_value( $attr['tabBorderWidth'], 'px' ),
					'border-left-width'   => $active_tab_border_left,
					'border-bottom-width' => $active_tab_border_bottom,
					'border-right-width'  => $active_tab_border_right,
					'border-color'        => $attr['tabBorderColor'],
					'z-index'             => '10',
					'margin-bottom'       => 'hstyle3' === $attr['tabsStyleD'] ? '-2px' : '',
					'margin-right'        => 'vstyle8' === $attr['tabsStyleD'] ? '-2px' : '',
				),
				'.responsive-block-editor-addons-tabs__wrap > .responsive-block-editor-addons-tabs__body-wrap' => array(
					'border-width' => self::get_css_value( $attr['tabBorderWidth'], 'px' ),
					'border-color' => $attr['tabBorderColor'],
				),
				'  .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab span' => array(
					'color'       => $attr['tabTitleTypographyColor'],
					'font-family' => $attr['tabTitleFontFamily'],
					'text-transform' => $attr['tabTitleTextTransform'],
					'font-style'  => $attr['tabTitleFontStyle'],
					'font-weight' => $attr['tabTitleFontWeight'],
					'font-size'   => self::get_css_value( $attr['tabTitleFontSize'], 'px' ),
					'line-height' => self::get_css_value( $attr['tabTitleLineHeight'], 'px' ),
				),
				'  .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab.responsive-block-editor-addons-tabs__active span' => array(
					'color' => $attr['tabTitleActiveTypographyColor'],
				),
				' > .responsive-block-editor-addons-tabs__body-wrap .wp-block-responsive-block-editor-addons-tabs-child p' => array(
					'color'       => $attr['tabContentTypographyColor'],
					'font-family' => $attr['tabContentFontFamily'],
					'text-transform' => $attr['tabContentTextTransform'],
					'font-style'  => $attr['tabContentFontStyle'],
					'font-weight' => $attr['tabContentFontWeight'],
					'font-size'   => self::get_css_value( $attr['tabContentFontSize'], 'px' ),
					'line-height' => self::get_css_value( $attr['tabContentLineHeight'], 'px' ),
				),
				'.responsive-block-editor-addons-vstyle8-right' => array(
					'flex-direction' => 'row-reverse',
				),
			);
			$mobile_selectors   = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetMobile'] && $is_on ? 'none' : 'flex',
					'padding-top'                => self::get_css_value( $attr['tabsTopPaddingMobile'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['tabsBottomPaddingMobile'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['tabsLeftPaddingMobile'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['tabsRightPaddingMobile'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['tabsTopMarginMobile'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['tabsBottomMarginMobile'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['tabsLeftMarginMobile'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['tabsRightMarginMobile'], 'px' ) . '!important',
					'z-index'                    => $attr['z_indexMobile'],
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				':hover .responsive-block-editor-addons-add-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusMobile'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusMobile'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusMobile'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusMobile'], 'px' ),
				),
				' > .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab span' => array(
					'font-size' => self::get_css_value( $attr['tabTitleFontSizeMobile'], 'px' ),
				),
				' > .responsive-block-editor-addons-tabs__body-wrap .wp-block-responsive-block-editor-addons-tabs-child p' => array(
					'font-size' => self::get_css_value( $attr['tabContentFontSizeMobile'], 'px' ),
				),
			);
			$tablet_selectors   = array(
				' ' => array(
					'display'                    => true === $attr['hideWidgetTablet'] && $is_on ? 'none' : 'flex',
					'z-index'                    => $attr['z_indexTablet'],
					'padding-top'                => self::get_css_value( $attr['tabsTopPaddingTablet'], 'px' ) . '!important',
					'padding-bottom'             => self::get_css_value( $attr['tabsBottomPaddingTablet'], 'px' ) . '!important',
					'padding-left'               => self::get_css_value( $attr['tabsLeftPaddingTablet'], 'px' ) . '!important',
					'padding-right'              => self::get_css_value( $attr['tabsRightPaddingTablet'], 'px' ) . '!important',
					'margin-top'                 => self::get_css_value( $attr['tabsTopMarginTablet'], 'px' ) . '!important',
					'margin-bottom'              => self::get_css_value( $attr['tabsBottomMarginTablet'], 'px' ) . '!important',
					'margin-left'                => self::get_css_value( $attr['tabsLeftMarginTablet'], 'px' ) . '!important',
					'margin-right'               => self::get_css_value( $attr['tabsRightMarginTablet'], 'px' ) . '!important',
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				':hover .responsive-block-editor-addons-add-image' => array(
					'border-top-left-radius'     => self::get_css_value( $attr['blockTopRadiusTablet'], 'px' ),
					'border-top-right-radius'    => self::get_css_value( $attr['blockRightRadiusTablet'], 'px' ),
					'border-bottom-right-radius' => self::get_css_value( $attr['blockBottomRadiusTablet'], 'px' ),
					'border-bottom-left-radius'  => self::get_css_value( $attr['blockLeftRadiusTablet'], 'px' ),
				),
				' > .responsive-block-editor-addons-tabs__panel .responsive-block-editor-addons-tab span' => array(
					'font-size' => self::get_css_value( $attr['tabTitleFontSizeTablet'], 'px' ),
				),
				' > .responsive-block-editor-addons-tabs__body-wrap .wp-block-responsive-block-editor-addons-tabs-child p' => array(
					'font-size' => self::get_css_value( $attr['tabContentFontSizeTablet'], 'px' ),
				),
			);
			$combined_selectors = array(
				'desktop' => $selectors,
				'tablet'  => $tablet_selectors,
				'mobile'  => $mobile_selectors,
			);
			$id                 = '.responsive-block-editor-addons-block-tabs.block-' . $id;
			$css                = Responsive_Block_Editor_Addons_Frontend_Styles_Helper::responsive_block_editor_addons_generate_all_css( $combined_selectors, $id );
			return $css;
		}

		/**
		 * Get Defaults for tabs block
		 *
		 * @return array
		 */
		public static function get_responsive_block_tabs_default_attributes() {
			return array(
				'block_id'                      => '',
				'tabHeaderOptions'              => '',
				'activeTab'                     => 0,
				'tabActiveFrontend'             => 0,
				'alignTabs'                     => 'left',
				'tabsStyleD'                    => 'hstyle3',
				'tabsStyleT'                    => 'hstyle3',
				'tabsStyleM'                    => 'hstyle3',
				'tabBorderWidth'                => 1,
				'tabBorderColor'                => '#e0e0e0',
				'tabBackgroundColor'            => '',
				'tabTitleColor'                 => '#007cba',
				'tabTitleActiveColor'           => '#000',
				'tabTitleFontFamily'            => '',
				'tabTitleFontSize'              => '',
				'tabTitleFontSizeMobile'        => '',
				'tabTitleFontSizeTablet'        => '',
				'tabTitleFontWeight'            => '',
				'tabTitleLineHeight'            => '',
				'tabContentColor'               => '000',
				'tabContentFontFamily'          => '',
				'tabContentFontSize'            => '',
				'tabContentFontSizeMobile'      => '',
				'tabContentFontSizeTablet'      => '',
				'tabContentFontWeight'          => '',
				'tabContentLineHeight'          => '',
				'alignTabs'                     => '',
				'z_index'                       => 1,
				'z_indexMobile'                 => 1,
				'z_indexTablet'                 => 1,
				'tabsTopPadding'                => '',
				'tabsBottomPadding'             => '',
				'tabsLeftPadding'               => '',
				'tabsRightPadding'              => '',
				'tabsTopPaddingTablet'          => '',
				'tabsBottomPaddingTablet'       => '',
				'tabsLeftPaddingTablet'         => '',
				'tabsRightPaddingTablet'        => '',
				'tabsTopPaddingMobile'          => '',
				'tabsBottomPaddingMobile'       => '',
				'tabsLeftPaddingMobile'         => '',
				'tabsRightPaddingMobile'        => '',
				'tabsTopMargin'                 => '',
				'tabsBottomMargin'              => '',
				'tabsLeftMargin'                => '',
				'tabsRightMargin'               => '',
				'tabsTopMarginTablet'           => '',
				'tabsBottomMarginTablet'        => '',
				'tabsLeftMarginTablet'          => '',
				'tabsRightMarginTablet'         => '',
				'tabsTopMarginMobile'           => '',
				'tabsBottomMarginMobile'        => '',
				'tabsLeftMarginMobile'          => '',
				'tabsRightMarginMobile'         => '',
				'backgroundType'                => '',
				'backgroundColor'               => '',
				'backgroundColor1'              => '',
				'backgroundColor2'              => '',
				'colorLocation1'                => 0,
				'colorLocation2'                => 100,
				'gradientDirection'             => 90,
				'hoverbackgroundColor1'         => '',
				'hoverbackgroundColor2'         => '',
				'hovercolorLocation1'           => 0,
				'hovercolorLocation2'           => 100,
				'hovergradientDirection'        => 90,
				'backgroundHoverColor'          => '',
				'opacity'                       => 20,
				'animationName'                 => 'none',
				'animationDirection'            => 'Left',
				'animationRepeat'     