<?php
/**
 * All helper function for customizer
 *
 * @package Responsive Addons pro
 */

if ( ! function_exists( 'responsive_footer_elements_positioning' ) ) {
	/**
	 * Returns footer elements positioning
	 *
	 * @since 0.2
	 */
	function responsive_footer_elements_positioning() {

		// Default sections.
		$sections = array( 'social_icons', 'footer_menu', 'copy_right_text' );

		// Get sections from Customizer.
		$sections = get_theme_mod( 'responsive_footer_elements_positioning', $sections );

		// Turn into array if string.
		if ( $sections && ! is_array( $sections ) ) {
			$sections = explode( ',', $sections );
		}

		// Apply filters for easy modification.
		$sections = apply_filters( 'responsive_footer_elements_positioning', $sections );

		// Return sections.
		return $sections;
	}
}
if ( ! function_exists( 'responsive_blog_pagination' ) ) {
	/**
	 * Returns blog pagination option
	 *
	 * @since 0.2
	 */
	function responsive_blog_pagination() {

		$blog_pagination = get_theme_mod( 'blog_pagination' );

		return $blog_pagination;
	}
}

if ( ! function_exists( 'responsive_date_box_toggle_value' ) ) {
	/**
	 * Returns date box option
	 */
	function responsive_date_box_toggle_value() {
		$date_box_toggle_value = get_theme_mod( 'responsive_date_box_toggle' );
		return $date_box_toggle_value;
	}
}

if ( ! function_exists( 'required_font_color_value' ) ) {
	/**
	 * Returns needed font color value for date box
	 *
	 * @param [type] $color [description] Needed font color value of the date box.
	 */
	function required_font_color_value( $color ) {
		list($r, $g, $b) = sscanf( $color, '#%02x%02x%02x' );
		$red             = $r * 299;
		$green           = $g * 587;
		$blue            = $b * 114;
		$sum             = round( ( $red + $green + $blue ) / 1000 );
		if ( $sum > 125 ) {
			$font_color_needed = 'black';
		} else {
			$font_color_needed = 'white';
		}
		return $font_color_needed;
	}
}

if ( ! function_exists( 'responsive_addons_menu_search_icon' ) ) {
	/**
	 * Check if the menu's last item is set to display a search icon.
	 *
	 * @return bool True if search is the last menu item, false otherwise.
	 */
	function responsive_addons_menu_search_icon() {
		$menu_last_item = get_theme_mod( 'responsive_menu_last_item', 'none' );
		return 'search' === $menu_last_item;
	}
}

/**
 * Check if off canvas is active
 *
 * @return mixed
 */
function enable_native_cart_popup_check() {
	$val = get_theme_mod( 'responsive_enable_native_cart_popup', false );
	return ( $val === true || $val === '1' || $val === 1 );
}

if ( ! function_exists( 'responsive_addons_checkbox_control' ) ) {
	/**
	 * Register a custom checkbox control in the WordPress Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer manager instance.
	 * @param string               $element      The setting key name.
	 * @param string               $label        The label displayed for the control.
	 * @param string               $section      The section to which this control belongs.
	 * @param int                  $priority     The priority/order of the control.
	 * @param mixed                $default      The default value for the setting.
	 * @param callable|null        $active_call  Callback function to determine active state.
	 * @param string               $transport    Transport method ('refresh' or 'postMessage').
	 * @param string               $desc         Optional description shown under the control.
	 *
	 * @return void
	 */
	function responsive_addons_checkbox_control( $wp_customize, $element, $label, $section, $priority, $default, $active_call = null, $transport = 'refresh', $desc = '' ) {
		$wp_customize->add_setting(
			'responsive_' . $element,
			array(
				'default'           => $default,
				'sanitize_callback' => 'responsive_checkbox_validate',
				'transport'         => $transport,
			)
		);
		$wp_customize->add_control(
			new Responsive_Customizer_Responsive_Checkbox_Control(
				$wp_customize,
				'responsive_' . $element,
				array(
					'label'           => $label,
					'section'         => $section,
					'settings'        => 'responsive_' . $element,
					'priority'        => $priority,
					'active_callback' => $active_call,
					'description'     => $desc,
				)
			)
		);
	}
}

if ( ! function_exists( 'responsive_addons_radio_button_control' ) ) {
	/**
	 * Register a radio button control in the WordPress Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer manager instance.
	 * @param string               $element      The setting key name.
	 * @param string               $label        The label displayed for the control.
	 * @param string               $section      The section to which this control belongs.
	 * @param int                  $priority     The priority/order of the control.
	 * @param mixed                $default_val  The default value for the setting.
	 * @param array                $choices      Array of key => label choices.
	 * @param string               $transport    Transport method ('refresh' or 'postMessage').
	 *
	 * @return void
	 */
	function responsive_addons_radio_button_control( $wp_customize, $element, $label, $section, $priority, $default_val, $choices = '', $transport = 'refresh' ) {
		$wp_customize->add_setting(
			'responsive_' . $element,
			array(
				'default'   => $default_val,
				'transport' => $transport,
			)
		);
		$wp_customize->add_control(
			'responsive_' . $element,
			array(
				'label'    => $label,
				'section'  => $section,
				'settings' => 'responsive_' . $element,
				'type'     => 'radio',
				'priority' => $priority,
				'choices'  => $choices,
			)
		);
	}
}

if ( ! function_exists( 'responsive_addons_separator_control' ) ) {

	/**
	 * [responsive_addons_separator_control description].
	 *
	 * @param  [type] $wp_customize [description].
	 * @param  [type] $element      [description].
	 * @param  [type] $label        [description].
	 * @param  [type] $section      [description].
	 * @param  [type] $priority     [description].
	 * @param  [type] $active_call     [description].
	 *
	 * @return void               [description].
	 */
	function responsive_addons_separator_control( $wp_customize, $element, $label, $section, $priority, $active_call = null ) {

		/**
		*  Heading.
		*/
		$wp_customize->add_setting(
			'responsive_' . $element,
			array(
				'sanitize_callback' => 'wp_kses',
			)
		);

		$wp_customize->add_control(
			new Responsive_Customizer_Heading_Control(
				$wp_customize,
				'responsive_' . $element,
				array(
					'label'           => $label,
					'section'         => $section,
					'priority'        => $priority,
					'active_callback' => $active_call,
				)
			)
		);
	}
}

if ( ! function_exists( 'responsive_addons_padding_control' ) ) {
	/**
	 * Responsive_addons_padding_control.
	 *
	 * @param  object  $wp_customize  [description].
	 * @param  integer $element  [description].
	 * @param  string  $section  [description].
	 * @param  integer $priority [description].
	 * @param  integer $default_values_y [description].
	 * @param  integer $default_values_x [description].
	 * @param  bool    $active_call [description].
	 * @param  string  $label [description].
	 * @param  integer $max [100 by default].
	 * @return void
	 */
	function responsive_addons_padding_control( $wp_customize, $element, $section, $priority, $default_values_y = '', $default_values_x = '', $active_call = null, $label = 'Padding (px)', $max = 100 ) {
		/**
		 *  Padding control.
		 */
		$wp_customize->add_setting(
			'responsive_' . $element . '_top_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_left_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);

		$wp_customize->add_setting(
			'responsive_' . $element . '_bottom_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_right_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_tablet_top_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_tablet_right_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_tablet_bottom_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_tablet_left_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);

		$wp_customize->add_setting(
			'responsive_' . $element . '_mobile_top_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_mobile_right_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_mobile_bottom_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_y,
			)
		);
		$wp_customize->add_setting(
			'responsive_' . $element . '_mobile_left_padding',
			array(
				'transport'         => 'postMessage',
				'sanitize_callback' => 'responsive_sanitize_number',
				'default'           => $default_values_x,
			)
		);
		$wp_customize->add_control(
			new Responsive_Customizer_Dimensions_Control(
				$wp_customize,
				'responsive_' . $element . '_padding',
				array(
					'label'           => $label,
					'section'         => $section,
					'settings'        => array(
						'desktop_top'    => 'responsive_' . $element . '_top_padding',
						'desktop_right'  => 'responsive_' . $element . '_right_padding',
						'desktop_bottom' => 'responsive_' . $element . '_bottom_padding',
						'desktop_left'   => 'responsive_' . $element . '_left_padding',
						'tablet_top'     => 'responsive_' . $element . '_tablet_top_padding',
						'tablet_right'   => 'responsive_' . $element . '_tablet_right_padding',
						'tablet_bottom'  => 'responsive_' . $element . '_tablet_bottom_padding',
						'tablet_left'    => 'responsive_' . $element . '_tablet_left_padding',
						'mobile_top'     => 'responsive_' . $element . '_mobile_top_padding',
						'mobile_right'   => 'responsive_' . $element . '_mobile_right_padding',
						'mobile_bottom'  => 'responsive_' . $element . '_mobile_bottom_padding',
						'mobile_left'    => 'responsive_' . $element . '_mobile_left_padding',
					),
					'priority'        => $priority,
					'active_callback' => $active_call,
					'input_attrs'     => array(
						'min'  => '',
						'max'  => $max,
						'step' => 1,
					),
				)
			)
		);
	}
}

if ( ! function_exists( 'responsive_addons_rst_text_control' ) ) {
	/**
	 * Adds a text-based control to the WordPress Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize      The Customizer manager instance.
	 * @param string               $element           The setting key suffix (appended to 'responsive_').
	 * @param string               $label             The label text for the control.
	 * @param string               $section           The Customizer section where this control will appear.
	 * @param int                  $priority          The priority/order of this control in the section.
	 * @param mixed                $default_val       The default value for the setting.
	 * @param callable|null        $active_call       Optional callback to determine if control is active.
	 * @param callable|string      $sanitize_function Optional sanitization callback (default: 'sanitize_text_field').
	 * @param string               $type              The input type (default: 'text').
	 * @param string               $transport         Transport method for preview updates ('refresh' or 'postMessage').
	 *
	 * @return void
	 */
	function responsive_addons_rst_text_control( $wp_customize, $element, $label, $section, $priority, $default_val, $active_call = null, $sanitize_function = 'sanitize_text_field', $type = 'text', $transport = 'refresh' ) {

		$wp_customize->add_setting(
			'responsive_' . $element,
			array(
				'default'           => $default_val,
				'sanitize_callback' => $sanitize_function,
				'transport'         => $transport,
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'responsive_' . $element,
				array(
					'active_callback' => $active_call,
					'label'           => $label,
					'priority'        => $priority,
					'section'         => $section,
					'settings'        => 'responsive_' . $element,
					'type'            => $type,
				)
			)
		);
	}
}


if ( ! function_exists( 'responsive_border_css' ) ) {
	/**
	 * Return border values for customizer
	 *
	 * @param  integer $top    Top width.
	 * @param  integer $right  Right width.
	 * @param  integer $bottom bottom width.
	 * @param  integer $left   Left width.
	 * @return integer
	 */
	function responsive_border_css( $top, $right, $bottom, $left ) {

		// Add px and 0 if no value.
		$s_top    = ( isset( $top ) && '' !== $top ) ? intval( $top ) . 'px ' : '1px ';
		$s_right  = ( isset( $right ) && '' !== $right ) ? intval( $right ) . 'px ' : '1px ';
		$s_bottom = ( isset( $bottom ) && '' !== $bottom ) ? intval( $bottom ) . 'px ' : '1px ';
		$s_left   = ( isset( $left ) && '' !== $left ) ? intval( $left ) . 'px ' : '1px';

		// Return one value if it is the same on every inputs.
		if ( ( intval( $s_top ) === intval( $s_right ) )
			&& ( intval( $s_right ) === intval( $s_bottom ) )
			&& ( intval( $s_bottom ) === intval( $s_left ) ) ) {
			return $s_left;
		}

		// Return.
		return $s_top . $s_right . $s_bottom . $s_left;
	}
}

if ( ! function_exists( 'responsive_spacing_css' ) ) {
	/**
	 * Return padding/margin values for customizer
	 *
	 * @param  integer $top    Top width.
	 * @param  integer $right  Right width.
	 * @param  integer $bottom bottom width.
	 * @param  integer $left   Left width.
	 * @return integer
	 */
	function responsive_spacing_css( $top, $right, $bottom, $left ) {

		// Add px and 0 if no value.
		$s_top    = ( isset( $top ) && '' !== $top ) ? intval( $top ) . 'px ' : '0px ';
		$s_right  = ( isset( $right ) && '' !== $right ) ? intval( $right ) . 'px ' : '0px ';
		$s_bottom = ( isset( $bottom ) && '' !== $bottom ) ? intval( $bottom ) . 'px ' : '0px ';
		$s_left   = ( isset( $left ) && '' !== $left ) ? intval( $left ) . 'px ' : '0px';

		// Return one value if it is the same on every inputs.
		if ( ( intval( $s_top ) === intval( $s_right ) )
			&& ( intval( $s_right ) === intval( $s_bottom ) )
			&& ( intval( $s_bottom ) === intval( $s_left ) ) ) {
			return $s_left;
		}

		// Return.
		return $s_top . $s_right . $s_bottom . $s_left;
	}
}

if ( ! function_exists( 'responsive_popup_elements_positioning' ) ) {

	/**
	 * Returns popup elements positioning
	 */
	function responsive_popup_elements_positioning() {

		// Default elements.
		$sections = array( 'title', 'content', 'buttons', 'bottom_text' );

		// Get elements from Customizer.
		$sections = get_theme_mod( 'responsive_popup_elements_positioning', $sections );

		// Turn into array if string.
		if ( $sections && ! is_array( $sections ) ) {
			$sections = explode( ',', $sections );
		}

		// Apply filters for easy modification.
		$sections = apply_filters( 'responsive_popup_elements_positioning', $sections );

		// Return sections.
		return $sections;
	}
}
// Add shortcode at initialisation.
add_action( 'init', 'responsive_addons_register_woo_cart_shortcodes' );

if ( ! function_exists( 'responsive_addons_register_woo_cart_shortcodes' ) ) {
	/**
	 * Register woo cart shortcodes
	 */
	function responsive_addons_register_woo_cart_shortcodes() {
		// Register Shortcode returns cart item count.
		add_shortcode( 'responsive_woo_cart_items', 'responsive_addons_woo_cart_items_count_function' );
		// Register Shortcode returns total.
		add_shortcode( 'responsive_woo_total_cart', 'responsive_addons_woo_cart_total_function' );
		// Register Shortcode returns total.
		add_shortcode( 'responsive_woo_free_shipping_left', 'woo_free_shipping_shortcode' );
	}
}

if ( ! function_exists( 'responsive_addons_woo_cart_items_count_function' ) ) {
	/**
	 * Shortcode returns cart item count
	 */
	function responsive_addons_woo_cart_items_count_function() {
		if ( ! class_exists( 'WooCommerce' )
				|| is_admin() ) {
			return;
		}
		// return if in elementor, avoid errors.
		if ( class_exists( 'Elementor\Plugin' )
				&& \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			return esc_html__( 'This shortcode only works in front end', 'responsive_addons_pro' );
		}
		$output  = '<span class="responsive-woo-cart-count">';
		$output .= WC()->cart->get_cart_contents_count();
		$output .= '</span>';

		return $output;
	}
}

if ( ! function_exists( 'responsive_addons_woo_cart_total_function' ) ) {
	/**
	 * Shortcode returns cart total
	 */
	function responsive_addons_woo_cart_total_function() {
		if ( ! class_exists( 'WooCommerce' )
				|| is_admin() ) {
			return;
		}
		// return if in elementor, avoid errors.
		if ( class_exists( 'Elementor\Plugin' )
				&& \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			return esc_html__( 'This shortcode only works in front end', 'responsive_addons_pro' );
		}

		$output  = '<span class="responsive-woo-total">';
		$output .= WC()->cart->get_total();
		$output .= '</span>';

		return $output;
	}
}

/**
 * Free shipping left
 */
if ( ! function_exists( 'woo_free_shipping_left' ) ) {
	/**
	 * Returns a message indicating how much is left to spend for free shipping,
	 * or a message indicating free shipping has been reached.
	 *
	 * @param string $content         The message to show when free shipping is not reached. Can contain '%left_to_free%' placeholder.
	 * @param string $content_reached The message to show when free shipping threshold is reached.
	 * @param float  $multiply_by     Multiplier for prices (default 1).
	 *
	 * @return string|void The message with prices replaced, or void if WooCommerce is not active or conditions fail.
	 */
	function woo_free_shipping_left( $content, $content_reached, $multiply_by = 1 ) {

		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		if ( class_exists( 'Elementor\Plugin' )
			&& \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			return;
		}

		if ( empty( $content ) ) {
			$content = esc_html__( 'Buy for %left_to_free% more and get free shipping', 'responsive_addons_pro' );
		}

		if ( empty( $content_reached ) ) {
			$content_reached = esc_html__( 'You have Free delivery!', 'responsive_addons_pro' );
		}

		$min_free_shipping_amount = 0;

		$free_shipping = new WC_Shipping_Legacy_Free_Shipping();
		if ( 'yes' === $free_shipping->enabled ) {
			// Fix: strict in_array with true for strict checking.
			if ( in_array( $free_shipping->requires, array( 'min_amount', 'either', 'both' ), true ) ) {
				$min_free_shipping_amount = $free_shipping->min_amount;
			}
		}
		if ( 0 === $min_free_shipping_amount ) {
			if ( function_exists( 'WC' ) ) {
				$wc_shipping = WC()->shipping;
				$wc_cart     = WC()->cart;
				if ( $wc_shipping && $wc_cart ) {
					if ( $wc_shipping->enabled ) {
						$packages = $wc_cart->get_shipping_packages();
						if ( $packages ) {
							$methods = $wc_shipping->load_shipping_methods( $packages[0] );
							foreach ( $methods as $method ) {
								if ( 'yes' === $method->enabled && 0 !== $method->instance_id ) {
									if ( 'WC_Shipping_Free_Shipping' === get_class( $method ) ) {
										if ( in_array( $method->requires, array( 'min_amount', 'either', 'both' ), true ) ) {
											$min_free_shipping_amount = $method->min_amount;
											break;
										}
									}
								}
							}
						}
					}
				}
			}
		}

		if ( 0 !== $min_free_shipping_amount ) {
			if ( isset( WC()->cart->cart_contents_total ) ) {
				$total = ( WC()->cart->prices_include_tax ) ? ( WC()->cart->cart_contents_total + WC()->cart->get_cart_contents_tax() ) : WC()->cart->cart_contents_total;
				if ( $total >= $min_free_shipping_amount ) {
					return do_shortcode( $content_reached );
				} else {
					$content = str_replace( '%left_to_free%', '<span class="responsive-woo-left-to-free">' . wc_price( ( $min_free_shipping_amount - $total ) * $multiply_by ) . '</span>', $content );
					$content = str_replace( '%free_shipping_min_amount%', '<span class="responsive-woo-left-to-free">' . wc_price( $min_free_shipping_amount * $multiply_by ) . '</span>', $content );
					return $content;
				}
			}
		}
	}
}


if ( ! function_exists( 'woo_free_shipping_shortcode' ) ) {
	/**
	 * Shortcode to display free shipping progress message.
	 *
	 * @param array  $atts    Shortcode attributes.
	 * @param string $content Content inside shortcode (not used).
	 *
	 * @return string|void HTML content for free shipping progress.
	 */
	function woo_free_shipping_shortcode( $atts, $content ) {

		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		wp_enqueue_script( 'responsive-woo-popup' );

		$content_data    = '';
		$content_reached = '';

		if ( ! empty( $atts ) ) {
			if ( isset( $atts['content'] ) ) {
				$content_data = $atts['content'];
			}
			if ( isset( $atts['content_reached'] ) ) {
				$content_reached = $atts['content_reached'];
			}
		}

		$x = str_replace( '%', '+', $content_data );

		$atts = shortcode_atts(
			array(
				'content'         => esc_html__( 'Buy for %left_to_free% more and get free shipping', 'responsive_addons_pro' ),
				'content_reached' => esc_html__( 'You have Free delivery!', 'responsive_addons_pro' ),
				'multiply_by'     => 1,
			),
			$atts
		);

		$content         = $atts['content'];
		$content_reached = $atts['content_reached'];
		$multiply_by     = $atts['multiply_by'];

		return woo_free_shipping_left( "<span class='responsive-woo-free-shipping' data-content='$x' data-reach='$content_reached'>" . $content . '</span>', '<span class="responsive-woo-free-shipping">' . $content_reached . '</span>', $multiply_by );
	}
}



if ( ! function_exists( 'update_responsive_woo_free_shipping_left_shortcode' ) ) {
	/**
	 * AJAX handler to refresh the free shipping shortcode fragment.
	 *
	 * @return void
	 */
	function update_responsive_woo_free_shipping_left_shortcode() {
		$atts = array();
		// The nonce is not provided by WooCommerce for this context, suppressing warning.
		// phpcs:disable WordPress.Security.NonceVerification.Missing

		if ( ( isset( $_POST['content'] ) && '' !== sanitize_text_field( wp_unslash( $_POST['content'] ) ) )
			|| ( isset( $_POST['content_rech_data'] ) && '' !== sanitize_text_field( wp_unslash( $_POST['content_rech_data'] ) ) ) ) {

			$atts['content_reached'] = sanitize_text_field( wp_unslash( $_POST['content_rech_data'] ) );
			$content                 = str_replace( '+', '%', sanitize_text_field( wp_unslash( $_POST['content_rech_data'] ) ) );
			$atts['content']         = $content;
			$return_shortcode_value  = woo_free_shipping_shortcode( $atts, '' );
			wp_send_json( $return_shortcode_value );

		} else {

			$return_shortcode_value = woo_free_shipping_shortcode( $atts, '' );
			wp_send_json( $return_shortcode_value );

		}
		// phpcs:enable
	}
}


add_action( 'wp_ajax_update_responsive_woo_free_shipping_left_shortcode', 'update_responsive_woo_free_shipping_left_shortcode' );
add_action( 'wp_ajax_nopriv_update_responsive_woo_free_shipping_left_shortcode', 'update_responsive_woo_free_shipping_left_shortcode' );

if ( ! function_exists( 'responsive_addons_distraction_free_woocommerce' ) ) {
	/**
	 * [responsive_addons_distraction_free_woocommerce description]
	 *
	 * @return [type] [description]
	 */
	function responsive_addons_distraction_free_woocommerce() {
		return ( 1 === get_theme_mod( 'responsive_distraction_free_woocommerce', 0 ) ) ? true : false;
	}
}

/**
 * Return current content layout.
 */
if ( ! function_exists( 'responsive_addons_get_content_layout' ) ) {

	/**
	 * Return current content layout.
	 *
	 * @since 3.3.0
	 * @return mixed content layout.
	 */
	function responsive_addons_get_content_layout() {
		$layout = null;
		return apply_filters( 'responsive_addons_get_content_layout', $layout );
	}
}

if ( ! function_exists( 'responsive_addons_return_content_layout_site_builder' ) ) {

	/**
	 * String for content layout - site-builder
	 *
	 * @since  3.3.0
	 * @return String site-builder string used for filter `astra_get_content_layout`
	 */
	function responsive_addons_return_content_layout_site_builder() {
		return 'site-builder';
	}
}

add_filter( 'responsive_site_builder_sticky_header_css', 'responsive_addons_site_builder_sticky_header_css', 10, 1 );

function responsive_addons_site_builder_sticky_header_css( $css ) {

	$device_type = apply_filters( 'responsive_site_builder_header_sticky_device', null );
	if ( ! $device_type ) {
		return $css;
	}

	if ( 'both' === $device_type ) {
		$css .= "
			.responsive-sb-sticky-header-both .sticky-header {
				position: fixed;
				top: 0;
				left: 0;
				z-index: 9999;
				width: 100%;
			}
			@media (max-width: 920px) {
				.responsive-sb-sticky-header-both.admin-bar .sticky-header {
					top: 46px;
				}
			}
			@media (min-width: 921px) {
				.responsive-sb-sticky-header-both.admin-bar .sticky-header {
					top: 32px;
				}
			}
		";
	} elseif ( 'desktop' === $device_type ) {
		$css .= "
			@media (min-width: 921px) {
				.responsive-sb-sticky-header-desktop .sticky-header {
					position: fixed;
					top: 0;
					left: 0;
					z-index: 9999;
					width: 100%;
				}
				.responsive-sb-sticky-header-desktop.admin-bar .sticky-header {
					top: 32px;
				}
			}";
	} elseif ( 'mobile' === $device_type ) {
		$css .= "
			@media (max-width: 920px) {
				.responsive-sb-sticky-header-mobile .sticky-header {
					position: fixed;
					top: 0;
					left: 0;
					z-index: 9999;
					width: 100%;
				}
				.responsive-sb-sticky-header-mobile.admin-bar .sticky-header {
					top: 46px;
				}
			}";
	}
	return $css;
}

add_filter( 'responsive_site_builder_sticky_footer_css', 'responsive_addons_site_builder_sticky_footer_css', 10, 1 );

function responsive_addons_site_builder_sticky_footer_css( $css ) {

	$device_type = apply_filters( 'responsive_site_builder_footer_sticky_device', null );
	if ( ! $device_type ) {
		return $css;
	}

	if ( 'both' === $device_type ) {
		$css .= "
			.responsive-sb-sticky-footer-both .responsive-site-builder-footer {
				position: fixed;
				bottom: 0;
				left: 0;
				z-index: 9999;
				width: 100%;
			}
		";
	} elseif ( 'desktop' === $device_type ) {
		$css .= "
			@media (min-width: 921px) {
				.responsive-sb-sticky-footer-desktop .responsive-site-builder-footer {
					position: fixed;
					bottom: 0;
					left: 0;
					z-index: 9999;
					width: 100%;
				}
			}";
	} elseif ( 'mobile' === $device_type ) {
		$css .= "
			@media (max-width: 920px) {
				.responsive-sb-sticky-footer-mobile .responsive-site-builder-footer {
					position: fixed;
					bottom: 0;
					left: 0;
					z-index: 9999;
					width: 100%;
				}
			}";
	}

	return $css;
}
