<?php

    if ( ! defined( 'ABSPATH' ) ) {
        exit; // Exit if accessed directly.
    }

class loginpress_amp {

    /* Default values.
     * PHP 8.0 compatible
     * */
    public $background        = '#ffffff';
    public $hoverbackground   = '#eeeeee';
    public $border_color      = '#dddddd';
    public $font_color        = '#333333';
    public $font_family       = 'Arial';
    public $font_size         = '12';
    public $text_block_height = '75';

    /**
     * Constructor for the loginpress_amp class.
     *
     */
    public function __construct() {
        $this->loginpress_amp_styling();
    }

    /**
     * Outputs the styling for the Related Posts Thumnails block in AMP.
     *
     * @since 4.2.0
     */
    public function loginpress_amp_styling() {
        ?>
        <style type="text/css">
            .related-posts-nav {
                border: 0pt none;
                margin: 0pt;
                padding: 0pt;
            }
        
            .related-posts-nav:after {
                content: '';
                display: block;
                clear: both;
            }
        
            .related-posts-nav>li {
                list-style: none;
                padding: 0;
                margin: 0;
                float: left;
            }
        
            .related-posts-nav>li:after {
                content: '';
                display: block;
                clear: both;
            }
        
            .related-posts-nav>li:before {
                display: none;
            }
        
            .related-posts-nav>li>a {
                border-bottom: medium none;
                margin: 0pt;
                padding: 6px;
                display: block;
                float: left;
                text-decoration: none;
                text-align: center;
                cursor: pointer;
                border-right: #ddd;
                background-color: #fff;
            }
        
            .related-posts-nav>li>a:hover {
                background-color: #eeeeef;
            }
        
            @media screen and (min-width: 290px) and (max-width: 520px) {
                .relpost-block-container {
                    display: flex;
                    flex-wrap: wrap;
                    justify-content: center;
                }
            }
        
            .related-posts-nav>li>a>.related-post-list-item-inner-container {
                border: 0pt none;
                margin: 0pt;
                padding: 0pt;
                width: 150px;
                height: 225px;
            }
        
            .related-posts-nav>li>a>.related-post-list-item-inner-container>.related-post-list-item-img-container {
                border: 0pt none;
                margin: 0pt;
                padding: 0pt;
                width: 150px;
                height: 150px;
                background-size: cover;
                background-repeat: no-repeat;
                background-attachment: scroll;
                background-position: 0 0;
            }
        
            .related-posts-nav>li>a>.related-post-list-item-inner-container>.related-post-list-item-text-container {
                border: 0pt none;
                margin: 3px 0pt 0pt;
                padding: 0pt;
                font-style: normal;
                font-variant: normal;
                font-weight: normal;
                font-size: 12px;
                line-height: normal;
                font-stretch: normal;
                color: #333333;
            }
        
            .related-post-list-item-link {
                box-shadow: none !important;
            }
        
        
            /* Burhan */
        
            #related_posts_thumbnails {
                list-style-type: none;
                list-style-position: inside;
                padding: 0;
                margin: 0
            }
        
            #related_posts_thumbnails li {
                float: left;
                padding: 0;
                margin: 0;
                padding: 5px;
                display: block;
                max-width: 100%;
            }
        
            .relpost_content {
                display: block;
                overflow: hidden;
                font-style: normal;
                font-variant: normal;
                font-weight: normal;
                line-height: normal;
                font-stretch: normal;
                -x-system-font: none;
                text-decoration: none;
                max-width: 100%;
            }
        
            .relpost-post-image {
                padding: 0;
                margin: 0;
                border: 0 none;
                max-width: 100%;
            }
        
            .relpost-block-container {
                border: 0 none;
                margin: 0;
                padding: 0;
            }
        
            .relpost-block-single {
                border-bottom: medium none;
                margin: 0;
                padding: 6px;
                display: block;
                float: left;
                text-decoration: none;
                text-align: center;
                cursor: pointer;
                margin-right: -1px;
                margin-bottom: 5px;
                overflow: hidden;
                border: 0;
            }
        
            .rpth_list_date{
                display: block;
                padding-top: 5px
                
            }
        
            .relpost-block-single-image {
                border: 0 none;
                margin: 0;
                padding: 0;
                -moz-background-clip: border;
                -moz-background-origin: padding;
                -moz-background-inline-policy: continuous;
                background-size: cover !important;
                max-width: 100%;
            }
        
            .relpost-block-single-text {
                border: 0 none;
                margin: 3px 0 0;
                padding: 0;
                font-style: normal;
                font-variant: normal;
                font-weight: normal;
                line-height: normal;
                font-stretch: normal;
                -x-system-font: none;
            }
            .relpoststh_front_cat {
                padding-top: 5px;
            }
            html[dir="rtl"] .relpost-block-single {
                float: right;
            }
        
            html[dir="rtl"] #related_posts_thumbnails li {
                float: right;
            }
        
            .relpost-align-left {
                float: left;
            }
        
            .relpost-align-right {
                float: right;
            }
        
            .relpost-align-center {
                float: none;
                text-align: center;
            }
        
            .relpost-align-center .relpost-block-single {
                display: inline-block;
                float: none;
            }
        
            .relpost-thumb-wrapper:after {
                content: "";
                display: block;
                clear: both;
            }
        
            .rpth_post_date {
                display: block;
                padding-top: 10px;
                font-size: 11px;
            }
            .relpost-block-container{
                display: flex;
                flex-wrap: wrap;
            }
            .relpost-block-container .relpost_card_title{
                font-size: inherit;
                line-height: inherit;
                font-weight: 700;
            }
            .relpost-block-container>div{
                max-width: min-content;
            }
            .relpost_content h2.relpost_card_title {
                font-size: inherit;
            }
        
            .relpost-block-container>div{
                border-right: 1px solid <?php echo get_option( 'relpoststh_bordercolor', $this->border_color );  ?>;
                background-color: <?php echo get_option( 'relpoststh_background', $this->background ); ?>
            }
            .relpost-block-container>div:hover{
                background-color: <?php echo get_option( 'relpoststh_hoverbackground', $this->hoverbackground ); ?>;
            }
            .relpost_content{
                font-size:	<?php echo get_option( 'relpoststh_fontsize', $this->font_size ) . 'px'; ?>;
                color: 		<?php echo get_option( 'relpoststh_fontcolor', $this->font_color ); ?>;
            }
            .relpost-block-single{
                background-color: <?php echo get_option( 'relpoststh_background', $this->background ); ?>;
                border-right: 1px solid  <?php echo get_option( 'relpoststh_bordercolor', $this->border_color ); ?>;
                border-left: 1px solid  <?php echo get_option( 'relpoststh_bordercolor', $this->border_color ); ?>;
                margin-right: -1px;
            }
            .relpost-block-single:hover{
                background-color: <?php echo get_option( 'relpoststh_hoverbackground', $this->hoverbackground ); ?>;
            }
            #related_posts_thumbnails li {
                border-right: 1px solid <?php echo get_option( 'relpoststh_bordercolor', $this->border_color );  ?>;
                background-color: <?php echo get_option( 'relpoststh_background', $this->background ); ?>
            }
        
            #related_posts_thumbnails li:hover {
                background-color: <?php echo get_option( 'relpoststh_hoverbackground', $this->hoverbackground ); ?>;
            }
        
            .relpost_content {
                font-size: <?php echo get_option( 'relpoststh_fontsize', $this->font_size ) . 'px'; ?>;
                color: <?php echo get_option( 'relpoststh_fontcolor', $this->font_color ); ?>;
            }
        
            .relpost-block-single {
                background-color: <?php echo get_option( 'relpoststh_background', $this->background ); ?>;
                border-right: 1px solid <?php echo get_option( 'relpoststh_bordercolor', $this->border_color ); ?>;
                border-left: 1px solid <?php echo get_option( 'relpoststh_bordercolor', $this->border_color ); ?>;
                margin-right: -1px;
            }
        
            .relpost-block-single:hover {
                background-color: <?php echo get_option( 'relpoststh_hoverbackground', $this->hoverbackground ); ?>;
            }
            #related_posts_thumbnails .related_posts_thumbnails img{
                object-fit: cover;
            }
        </style>
        <?php
    }
}
// call class
$loginpress_amp = new loginpress_amp();

