<?php
/*
	Plugin Name: Related Posts for WordPress
	Plugin URI: http://www.relatedpostsforwp.com/
	Description: Related Posts for WordPress, the best way to display related posts in WordPress.
	Version: 2.3.0
	Author: Never5
	Author URI: http://www.never5.com/
	Requires at least: 5.0
	Requires PHP: 7.2
	License: GPL v3
	License URI: http://www.gnu.org/licenses/gpl-3.0.html
	Text Domain: related-posts-for-wp

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

function rp4wp_load_plugin() {

	// Deactivate own plugin if Premium is loaded
	if ( defined( 'RP4WP_PLUGIN_FILE' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		deactivate_plugins( plugin_basename( __FILE__ ) );

		return false;
	}

	// Define
	define( 'RP4WP_PLUGIN_FILE', __FILE__ );

	require dirname( __FILE__ ) . '/vendor/autoload.php';
	require dirname( __FILE__ ) . '/includes/functions.php';

	// Instantiate main plugin object
	RP4WP();
}

// Create object - Plugin init
add_action( 'plugins_loaded', 'rp4wp_load_plugin', 20 );

//
if ( is_admin() && ! is_multisite() && ( false === defined( 'DOING_AJAX' ) || false === DOING_AJAX ) ) {

	// Load installer functions
	require_once plugin_dir_path( __FILE__ ) . 'includes/installer-functions.php';

	// Activation hook
	register_activation_hook( __FILE__, 'rp4wp_activate_plugin' );
}
