<?php
/** no direct access **/
defined('_WPLEXEC') or die('Restricted access');

/** import js codes **/
$this->_wpl_import('widgets.carousel.scripts.js', true, true);

$image_height = $this->instance['data']['image_height'] ?? 220;
$images_per_page = intval($this->instance['data']['images_per_page'] ?? 3);
$image_width = floatval($this->instance['data']['image_width'] ?? (1170 - ($images_per_page * 20)) / $images_per_page);
$auto_play = $this->instance['data']['auto_play'] ?? false;
$slide_interval = intval($this->instance['data']['slide_interval'] ?? 3000);
$show_tags = $this->instance['data']['show_tags'] ?? false;
$wpl_rtl = is_rtl() ? 'true' : 'false';
$this->lazyload = $this->instance['data']['lazy_load'] ?? false;
$lazy_load = $this->lazyload ? 'owl-lazy' : '';
$src = $this->lazyload ? 'data-src' : 'src';

/** add Layout js **/
$js[] = (object) array('param1'=>'owl.slider', 'param2'=>'packages/owl_slider/owl.carousel.min.js');
foreach($js as $javascript) wpl_extensions::import_javascript($javascript);

$wpl_properties_count = count($wpl_properties);
$tags = wpl_flex::get_tag_fields(($this->instance['data']['kind'] ?? 0));
?>

<div id="wpl-multi-images-<?php wpl_esc::e($this->widget_id); ?>" class="wpl-plugin-owl wpl-carousel-multi-images container <?php if($wpl_properties_count == 1) wpl_esc::e("wpl-carousl-multi-single");  wpl_esc::attr($this->css_class); ?> ">
    <?php
	foreach($wpl_properties as $key=>$gallery)
	{
		if(!isset($gallery["items"]["gallery"][0])) continue;

		$params = array();
		$params['image_name'] 		= $gallery["items"]["gallery"][0]->item_name;
		$params['image_parentid'] 	= $gallery["items"]["gallery"][0]->parent_id;
		$params['image_parentkind'] = $gallery["items"]["gallery"][0]->parent_kind;
		$params['image_source'] 	= wpl_global::get_upload_base_path(wpl_property::get_blog_id($params['image_parentid'])).$params['image_parentid'].DS.$params['image_name'];

		$image_title = wpl_property::update_property_title($gallery['raw']);

		if( trim($gallery['items']['gallery'][0]->item_extra2 ?? '') != '') $image_alt = $gallery['items']['gallery'][0]->item_extra2;
		elseif( trim($gallery['raw']['meta_keywords'] ?? '') ) $image_alt = $gallery['raw']['meta_keywords'];
		else $image_alt = $image_title;

		$image_description	= $gallery["items"]["gallery"][0]->item_extra2;

		if($gallery["items"]["gallery"][0]->item_cat != 'external') $image_url = wpl_images::create_gallery_image($image_width, $image_height, $params, 1);
		else $image_url = $gallery["items"]["gallery"][0]->item_extra3;
		$location_visibility = wpl_property::location_visibility($gallery['items']['gallery'][0]->parent_id, $gallery['items']['gallery'][0]->parent_kind, wpl_users::get_user_membership());
	?>
	<div class="wpl-carousel-item" <?php wpl_esc::item_type($this->microdata, 'SingleFamilyResidence'); ?>>
		<img class="<?php wpl_esc::e($lazy_load); ?>"
			<?php wpl_esc::item_prop($this->microdata, 'image'); ?>
			<?php wpl_esc::attr($src); ?>="<?php wpl_esc::url($image_url); ?>"
			alt="<?php wpl_esc::attr($image_alt); ?>"
			title="<?php wpl_esc::attr($image_title); ?>"
			height="<?php wpl_esc::attr($image_height); ?>"
			style="height: <?php wpl_esc::attr($image_height); ?>px;"
		/>
		<div class="title">
			<h3 <?php wpl_esc::item_prop($this->microdata, 'name'); ?>><?php wpl_esc::html($image_title); ?></h3>
			<h4 <?php wpl_esc::item_prop($this->microdata, 'address'); ?> style="display:none">
				<?php wpl_esc::html($location_visibility === true ? $gallery['location_text'] : $location_visibility); ?>
			</h4>
			<a <?php wpl_esc::item_prop($this->microdata, 'url'); ?> class="more_info" href="<?php wpl_esc::url($gallery["property_link"]); ?>">
				<?php wpl_esc::html_t('More'); ?>
			</a>
		</div>
		<?php if($show_tags): ?>
			<div class="wpl-listing-tags-wp">
				<div class="wpl-listing-tags-cnt">
					<?php wpl_esc::e($this->tags($tags, $gallery['raw'])); ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
	<?php
	}
	?>
</div>

<?php if($wpl_properties_count > 1): ?>
<script type="text/javascript">
wplj(function()
{
    wplj("#wpl-multi-images-<?php wpl_esc::e($this->widget_id); ?>").owlCarousel(
    {
        items: <?php wpl_esc::e($images_per_page); ?>,
        loop: true,
        nav: true,
        autoplay: <?php wpl_esc::e($auto_play ? 'true' : 'false'); ?>,
        autoplayTimeout: <?php wpl_esc::e($slide_interval); ?>,
        autoplayHoverPause: true,
        navText: false,
        dots: false,
        responsiveClass: true,
        lazyLoad: true,
        rtl: <?php wpl_esc::e($wpl_rtl); ?>,
        responsive: {
            0: {
                items: 1,
                nav: false,
                dots: true
            },
            768: {
                items: 2
            },
            1024:{
                items: <?php wpl_esc::e($images_per_page); ?>
            }
        }
    });
});
</script>
<?php endif;