import App from "./Components/App";
import Settings from "./Components/Settings";
import Statistics from "./Components/Statistics";
import ChartWidget from "./Components/Statistics/ChartWidget";
import {showProModal} from "./includes/functions";

;(function ($) {

    const app = {
        init: () => {
            app.initApp();

            app.initSettings();
            app.initStatistics();

        },

        ready: () => {
            // Handle offer notice dismiss
            $(document).on('click', '.radio-player-offer-notice .offer-btn-main, .radio-player-offer-notice .notice-dismiss', app.handleNoticeDismiss);
            $('.pricing-switcher').on('click', app.handleSwitcher);

            $('.rp-play').on('click', app.handlePopupPlay);

            // Handle Getting Started
            app.handleGettingStarted();

            // Handle PRO feature clicks
            $(document).on('click', '.radio-player-pro-icon', () => {
                showProModal(wp.i18n.__('Upgrade to PRO to access this feature', 'radio-player'));
            });

            // on click .menu-top#toplevel_page_radio-player a:has(.radio-player-icon.icon-pro) open link in new tab
            $(document).on('click', '.menu-top#toplevel_page_radio-player a:has(.radio-player-icon.icon-pro)', function (e) {
                e.preventDefault();
                const proUrl = $(this).attr('href');
                window.open(proUrl, '_blank');
            });

        },

        handleGettingStarted: () => {
            // Switch Tabs
            $('.radio-player-getting-started .menu-item').on('click', function () {

                const target = $(this).data('target');
                localStorage.setItem('rp_getting_started_tab', target);

                $('.menu-item').removeClass('active');
                $('.getting-started-content').removeClass('active');

                $(this).addClass('active');
                $('#' + target).addClass('active');
            });

            // Load saved tab
            const savedTab = localStorage.getItem('rp_getting_started_tab');
            if (savedTab) {
                $('.radio-player-getting-started .menu-item[data-target="' + savedTab + '"]').trigger('click');
            }
        },

        handleSwitcher: function (e) {
            $('.price-text').removeClass('annual lifetime')
                .addClass($(this).hasClass('active') ? 'annual' : 'lifetime');
            $(this).toggleClass('active');
        },

        handlePopupPlay: function (e) {
            e.preventDefault();

            const videoId = $(this).attr('data-video-id');
            const title = $(this).attr('data-title');
            const autoplaySrc = `https://www.youtube.com/embed/${videoId}?rel=0&autoplay=1`;

            Swal.fire({
                title,
                text: '',
                icon: '',
                html: `
            <iframe
                src="${autoplaySrc}"
                frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen
                width="720" height="415"
            ></iframe>
        `,
                showDenyButton: false,
                showConfirmButton: false,
                reverseButtons: true,
                allowEscapeKey: true,
                showCloseButton: true,
                customClass: {container: 'radio-player-swal radio-player-popup-play'}
            });
        },


        handleNoticeDismiss: function (e) {
            $(this).closest('.radio-player-admin-notice').slideUp();

            wp.ajax.post('rp_dismiss_offer_notice', {
                nonce: radioPlayer.nonce,
            });
        },

        initApp: () => {
            const appElement = document.getElementById('radio-player-app');

            if (appElement) {
                const isAddNew = !!appElement.dataset.addNew;
                ReactDOM.render(<App isAddNew={isAddNew}/>, appElement);
            }

        },

        initSettings: () => {
            const settingsElement = document.getElementById("radio-player-settings");

            if (settingsElement) {
                ReactDOM.render(<Settings/>, settingsElement);
            }
        },

        initStatistics: () => {
            const statisticsElement = document.getElementById('radio-player-statistics');

            if (statisticsElement) {
                ReactDOM.render(<Statistics/>, statisticsElement);
            }

            const chartWidgetElement = document.getElementById('radio-player-chart-widget');
            if (chartWidgetElement) {
                ReactDOM.render(<ChartWidget/>, chartWidgetElement);
            }
        },

    }

    app.init();
    $(document).ready(app.ready);


})(jQuery);

