import Header from "./Statistics/Header";
import Summary from "./Statistics/Summary";
import PlayChart from "./Statistics/PlayChart";
import TopPlayers from "./Statistics/TopPlayers";
import TimesChart from "./Statistics/TimesChart";
import TopStations from "./Statistics/TopStations";

import {formatDate} from "../includes/functions";
import Logs from "./Statistics/Logs";
import TopUsers from "./Statistics/TopUsers";
import TopBrowsers from "./Statistics/TopBrowsers";

const {useState, useEffect} = React;

export default function Statistics() {
    const isPro = radioPlayer.isPro;

    const [loading, setLoading] = useState(false);

    const lastMonthDate = new Date();
    lastMonthDate.setMonth(lastMonthDate.getMonth() - 1);

    const [data, setData] = useState({
        logs: [],
        players: [],
        total_plays: 0,
        total_users: 0,
        total_duration: 0,
    });

    const [startDate, setStartDate] = useState(formatDate(lastMonthDate));
    const [endDate, setEndDate] = useState(formatDate(new Date()));

    const [dateRange, setDateRange] = useState([
        {
            startDate: lastMonthDate,
            endDate: new Date(),
            key: "selection",
        },
    ]);

    const handleDateChange = (ranges) => {
        setDateRange([ranges.selection]);

        setStartDate(formatDate(ranges.selection.startDate));
        setEndDate(formatDate(ranges.selection.endDate));
    }

    useEffect(() => {

        if (!isPro) return;

        setLoading(true);

        wp.ajax
            .post('radio_player_get_statistics', {
                start_date: startDate,
                end_date: endDate,
                nonce: radioPlayer.nonce,
            })
            .done((data) => {
                if (data) {
                    setData(data);
                }
            })
            .fail(error => console.log(error))
            .always(() => {
                setLoading(false);
            });

    }, [startDate, endDate]);

    return (
        <div className="radio-player-statistics">

            <Header
                startDate={startDate}
                endDate={endDate}
                setStartDate={setStartDate}
                setEndDate={setEndDate}
                setData={setData}
                handleDateChange={handleDateChange}
                dateRange={dateRange}
            />

            {loading && <div className="radio-player-spinner spinner-large"></div>}


            {/*{!!data && (*/}
            <>
                <Summary data={data}/>

                <PlayChart data={data}/>
                <TimesChart data={data}/>

                <TopUsers data={data} startDate={startDate} endDate={endDate}/>
                <TopBrowsers data={data} startDate={startDate} endDate={endDate}/>

                <TopPlayers data={data}/>
                <TopStations data={data}/>

                <Logs
                    data={data}
                    startDate={startDate}
                    endDate={endDate}
                />
            </>
            {/*)}*/}
        </div>
    )
}