import {Tooltip} from "react-tooltip";
import Select from "react-select";
import Uploader from "../App/Form/Uploader";
import {showProModal} from "../../includes/functions";

const {
    FormToggle,
    SelectControl,

    __experimentalRadio: Radio,
    __experimentalRadioGroup: RadioGroup,
} = wp.components;


const {plugin_url, isPro, players, exclude_list = {}} = radioPlayer;

export default function StickySettings({data, setData}) {

    const excludeList = [];

    const playerList = [{label: wp.i18n.__(`None`, "radio-player"), value: 0}];

    if (isPro) {
        Object.keys(exclude_list).forEach(key => {
            const options = exclude_list[key].options;
            excludeList.push({
                label: exclude_list[key].label,
                options: Object.keys(options).map(key => {
                    return {
                        label: options[key],
                        value: key,
                    };
                })
            });
        });

        players.map(item => {
            playerList.push({value: item.id, label: item.title});
        });
    }

    const allOptions = excludeList.reduce((acc, cur) => {
        return acc.concat(cur.options);
    }, []);

    const {
        excludePages = [],
        excludeAll = false,
        excludeExceptPages = [],
        stickyPlayer,
        alwaysSticky,
        stickyStyle = 'fullwidth',
        floatingPosition = 'bottom-right',
        stickyPosition = 'bottom',
        displayOnMobile = true,
        minimizePlayerImage = plugin_url + '/assets/images/minimize.png',
        draggableFloating = true,
        stickyTriggers = isPro ? [] : [''],
    } = data;


    const excludeExceptPagesValue = !!allOptions.length &&
        excludeExceptPages.map(item => {
            const foundOption = allOptions.find(option => option.value === item);
            return {
                value: item,
                label: foundOption?.label || '',
            };
        });
    const excludePagesValue = !!allOptions.length &&
        Array.isArray(excludePages) && excludePages.map(item => {
            const foundOption = allOptions.find(option => option.value === item);
            return {
                value: item,
                label: foundOption?.label || '',
            };
        });

    const updateTrigger = (index, key, value) => {
        setData({
            ...data,
            stickyTriggers: [...stickyTriggers.slice(0, index), {
                ...stickyTriggers[index],
                [key]: value
            }, ...stickyTriggers.slice(index + 1)]
        });
    }

    const removeTrigger = (index) => {
        const newTriggers = [...stickyTriggers.slice(0, index), ...stickyTriggers.slice(index + 1)];

        setData({...data, stickyTriggers: newTriggers});
    }

    return (
        <div className="tab-content">

            <div className="settings-header">

                <img src={`${plugin_url}/assets/images/settings/sticky.svg`}/>

                <span>{wp.i18n.__('Sticky Player Settings', 'radio-player')}</span>
            </div>

            {/* Always Sticky */}
            <div className="setting-field">

                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Always Play in Sticky', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className={`setting-field-content `}>

                    <div className={`${!isPro ? 'pro-disabled' : ''} input-group`}>
                        <FormToggle
                            checked={isPro && alwaysSticky}
                            onChange={() => {

                                if (!isPro) {
                                    showProModal(wp.i18n.__('Upgrade to PRO to use the sticky player feature.', 'radio-player'));
                                    return;
                                }

                                setData(data => ({...data, alwaysSticky: !alwaysSticky}))
                            }}
                        />
                    </div>

                    <p className="description">{wp.i18n.__('Enable this option to play all streams using the sticky player automatically.', 'radio-player')}</p>
                </div>
            </div>

            {/* Sticky Player */}
            <div className="setting-field">
                {alwaysSticky ?
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Default Sticky Player', 'radio-player')}
                        {!isPro && <span className="radio-player-pro-icon"><i className={`radio-player-icon icon-pro`}/></span>}
                    </h4>
                    :
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Sticky Player', 'radio-player')}
                        {!isPro && <span className="radio-player-pro-icon"><i className={`radio-player-icon icon-pro`}/></span>}
                    </h4>
                }

                <div className="setting-field-content">
                    <div
                        className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}
                        onClick={() => {
                            if (!isPro) {
                                showProModal(wp.i18n.__('Upgrade to PRO to use Sticky Player.', 'radio-player'));
                            }
                        }}
                    >
                        <SelectControl
                            isDisabled={!isPro}
                            value={stickyPlayer}
                            options={playerList}
                            onChange={value => {

                                if (!isPro) {
                                    showProModal(wp.i18n.__('Upgrade to PRO to customize the sticky player.', 'radio-player'));
                                    return;
                                }

                                setData({...data, stickyPlayer: value})
                            }}
                            __next40pxDefaultSize={true}
                            __nextHasNoMarginBottom={true}

                        />

                    </div>

                    {alwaysSticky ?
                        <p className={`description`}>{wp.i18n.__('Select the default sticky player to use.', 'radio-player')}</p>
                        :
                        <p className="description">{wp.i18n.__('Select the player to display as the sticky player.', 'radio-player')}</p>
                    }

                </div>
            </div>

            {/* Sticky Player Style */}
            <div className="setting-field">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Sticky Player Style', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className="setting-field-content">
                    <div
                        className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}>
                        <RadioGroup
                            label={wp.i18n.__('Sticky Player Style', 'radio-player')}
                            checked={stickyStyle}
                            onChange={(value) => {
                                if (!isPro) {
                                    showProModal(wp.i18n.__('Upgrade to PRO to customize the sticky player style.', 'radio-player'));
                                    return;
                                }
                                setData({...data, stickyStyle: value});
                            }}
                            className="radio-player-radio-group"
                        >
                            <Radio value="fullwidth">{wp.i18n.__('Fullwidth', 'radio-player')}</Radio>
                            <Radio value="mini-fullwidth">{wp.i18n.__('Mini Fullwidth', 'radio-player')}</Radio>
                            <Radio value="floating">{wp.i18n.__('Floating', 'radio-player')}</Radio>
                        </RadioGroup>
                    </div>

                    {!isPro &&
                        <Tooltip className={'radio-player-tooltip'} id={`sticky-style`} place="right" variant="warning"
                                 effect="solid"/>}

                    <p className="description">{wp.i18n.__('Select the sticky player style.', 'radio-player')}</p>
                </div>
            </div>

            {/* Sticky Player Position */}
            {(isPro && stickyStyle !== 'floating') &&
                <div className="setting-field">
                    <label>{wp.i18n.__('Sticky Player Position', 'radio-player')}</label>

                    <div className="setting-field-content">
                        <RadioGroup
                            label={wp.i18n.__('Sticky Player Position', 'radio-player')}
                            checked={stickyPosition}
                            onChange={(value) => setData({...data, stickyPosition: value})}
                            className="radio-player-radio-group"
                        >
                            <Radio value="top">{wp.i18n.__('Top', 'radio-player')}</Radio>
                            <Radio value="bottom">{wp.i18n.__('Bottom', 'radio-player')}</Radio>
                        </RadioGroup>

                        <p className="description">{wp.i18n.__('Set the fullwidth sticky player position.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Floating Position */}
            {(isPro && stickyStyle === 'floating') &&
                <div className="setting-field">
                    <label>{wp.i18n.__('Floating Position', 'radio-player')}</label>

                    <div className="setting-field-content">
                        <RadioGroup
                            label={wp.i18n.__('Floating Position', 'radio-player')}
                            checked={floatingPosition}
                            onChange={(value) => setData({...data, floatingPosition: value})}
                            className="radio-player-radio-group"
                        >
                            <Radio value="top-left">{wp.i18n.__('Top Left', 'radio-player')}</Radio>
                            <Radio value="top-right">{wp.i18n.__('Top Right', 'radio-player')}</Radio>
                            <Radio value="bottom-left">{wp.i18n.__('Bottom Left', 'radio-player')}</Radio>
                            <Radio value="bottom-right">{wp.i18n.__('Bottom Right', 'radio-player')}</Radio>
                        </RadioGroup>

                        <p className="description">{wp.i18n.__('Set the floating sticky player position.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Draggable Floating Player */}
            {(isPro && stickyStyle === 'floating') &&
                <div className="setting-field">
                    <label>{wp.i18n.__('Draggable Floating Player', 'radio-player')}</label>

                    <div className="setting-field-content">
                        <div
                            className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}>
                            <FormToggle
                                checked={draggableFloating}
                                onChange={() => {

                                    if (!isPro) {
                                        showProModal(wp.i18n.__('Upgrade to PRO to make the floating player draggable.', 'radio-player'));
                                        return;
                                    }

                                    setData({...data, draggableFloating: !draggableFloating})
                                }
                                }
                            />
                        </div>

                        <p className="description">{wp.i18n.__('Make the floating sticky player draggable to let your users move it around the screen.', 'radio-player')}</p>

                    </div>
                </div>
            }

            {/* Display on Mobile */}
            <div className="setting-field">
                <label>
                    {wp.i18n.__('Display On Mobile', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </label>

                <div className="setting-field-content">
                    <div
                        className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}>
                        <FormToggle
                            checked={displayOnMobile}
                            onChange={() => {

                                if (!isPro) {
                                    showProModal(wp.i18n.__('Upgrade to PRO to use the sticky player.', 'radio-player'));
                                    return;
                                }

                                setData({...data, displayOnMobile: !displayOnMobile})
                            }}
                        />
                    </div>


                    <p className="description">{wp.i18n.__('Display the sticky player on mobile devices.', 'radio-player')}</p>
                </div>
            </div>

            {/* Exclude */}
            <div className="setting-field exclude-field">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Exclude Pages', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className={`setting-field-content`}>
                    <div
                        className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}
                        onClick={() => {
                            if (!isPro) {
                                showProModal(wp.i18n.__('Upgrade to PRO to use Sticky Player.', 'radio-player'));
                            }
                        }}
                    >
                        <div className="exclude-field-input">

                            <Select
                                isMulti
                                isDisabled={!!excludeAll}
                                value={excludePagesValue}
                                options={excludeList}
                                onChange={selected => setData(data => ({
                                    ...data,
                                    excludePages: selected.map(item => item.value)
                                }))}
                                className="radio-player-select"
                                classNamePrefix="radio-player-select"
                            />

                            <span
                                className="description">{wp.i18n.__('Select the posts/pages, where the sticky player will be hidden.', 'radio-player')}</span>
                        </div>

                        <div className="exclude-field-all">

                            <div>
                                <span
                                    className="exclude-field-all-label">{wp.i18n.__("Exclude All : ", "radio-player")} </span>

                                <FormToggle
                                    checked={excludeAll}
                                    onChange={() => {

                                        if (!isPro) {
                                            showProModal(wp.i18n.__('Upgrade to PRO to use Sticky Player', 'radio-player'));
                                            return;
                                        }

                                        setData(data => ({...data, excludeAll: !excludeAll}))
                                    }}
                                />

                            </div>

                            <div>
                                <span
                                    className="exclude-field-all-label">{wp.i18n.__("Except : ", "radio-player")}</span>
                                <Select
                                    isMulti
                                    isDisabled={!excludeAll}
                                    value={excludeExceptPagesValue}
                                    options={excludeList}
                                    onChange={selected => setData(data => ({
                                        ...data,
                                        excludeExceptPages: selected.map(item => item.value)
                                    }))}
                                    className="radio-player-select"
                                    classNamePrefix="radio-player-select"
                                />
                            </div>

                            <span
                                className="description">{wp.i18n.__('When Excluded All, the sticky player will only show on the exceptions posts/pages.', 'radio-player')}</span>

                        </div>
                    </div>

                    {!isPro &&
                        <Tooltip id={`exclude-pages`} className={'radio-player-tooltip'} place="left"
                                 variant="warning" effect="solid"/>}

                </div>
            </div>

            {/* Minimize Player Image */}
            <div className="setting-field field-minimize-player-image">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Minimized Player Image', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className="setting-field-content">

                    <div
                        className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}
                        onClick={() => {
                            if (!isPro) {
                                showProModal(wp.i18n.__('Upgrade to PRO to use the sticky player.', 'radio-player'));
                            }
                        }}
                    >
                        <Uploader
                            media={minimizePlayerImage}
                            onChange={minimizePlayerImage => setData({...data, minimizePlayerImage})}
                        />
                    </div>

                    {!isPro && <Tooltip place="left" effect="solid" variant="warning"/>}

                    <p className="description">{wp.i18n.__('Show the image when the sticky player is in minimized state.', 'radio-player')}</p>
                </div>
            </div>

            {/* Sticky Triggers */}
            <div className="setting-field field-popup-triggers">
                <div className="setting-field-content">
                    <div className="popup-triggers">

                        <h3>
                            {wp.i18n.__('Custom Sticky Triggers', 'radio-player')}
                            {!isPro &&
                                <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                            }
                        </h3>

                        <p>{wp.i18n.__('Allow any element on your website to open and play any player in the sticky player mode when clicked.', 'radio-player')}</p>

                        {stickyTriggers.map((triger, index) => {
                            const {selector, player} = triger;

                            return (
                                <div
                                    className={!isPro ? 'pro-disabled trigger-group' : ''}
                                    onClick={() => {
                                        if (!isPro) {
                                            showProModal();
                                        }
                                    }}
                                    key={index}
                                >
                                    <div className="group-item">

                                        {index === 0 &&
                                            <div className={`group-item-header`}>
                                                <span
                                                    className={`header-title`}>{wp.i18n.__('Element Selector', 'radio-player')}</span>
                                            </div>
                                        }

                                        <div className="input-group">
                                            <input type="text" placeholder="Enter CSS Selector (e.g. .my-class, #my-id)"
                                                   value={selector}
                                                   onChange={e => updateTrigger(index, 'selector', e.target.value)}/>
                                        </div>
                                    </div>

                                    {/* Player */}
                                    <div className="group-item">

                                        {index === 0 &&
                                            <div className={`group-item-header`}>
                                                <span
                                                    className={`header-title`}>{wp.i18n.__('Select Player', 'radio-player')}</span>
                                            </div>
                                        }

                                        <div className="input-group">

                                            <SelectControl
                                                isDisabled={!isPro}
                                                value={player}
                                                options={playerList}
                                                onChange={value => {

                                                    if (!isPro) {
                                                        showProModal(wp.i18n.__('Upgrade to PRO to use the Popup Player.', 'radio-player'));
                                                        return;
                                                    }

                                                    updateTrigger(index, 'player', value);
                                                }}
                                                __next40pxDefaultSize={true}
                                                __nextHasNoMarginBottom={true}

                                            />

                                        </div>

                                    </div>


                                    <button type={`button`} className="radio-player-btn btn-danger"
                                            onClick={() => removeTrigger(index)}>
                                        <i className="dashicons dashicons-trash"></i>
                                    </button>

                                </div>
                            )
                        })}


                        <button
                            type={`button`}
                            className={`radio-player-btn add-group ${!isPro ? 'pro-disabled' : ''}`}
                            onClick={() => {
                                if (!isPro) {
                                    showProModal();
                                    return;
                                }

                                setData({
                                    ...data,
                                    stickyTriggers: [...stickyTriggers,
                                        {
                                            selector: '',
                                            player: playerList[0].value,
                                        }
                                    ]
                                })
                            }}>
                            <i className={`dashicons dashicons-plus-alt2`}></i>
                            <span>{wp.i18n.__('Add New Trigger', 'radio-player')}</span>
                        </button>

                    </div>
                </div>
            </div>

        </div>
    )
}