import {Tooltip} from "react-tooltip";
import {showProModal} from "../../includes/functions";

const {FormToggle, SelectControl} = wp.components;

export default function StatisticsSettings({data, setData}) {

    const {isPro, admin_email} = radioPlayer;

    const {
        enableStats,
        enableDashboardWidget,
        emailReport,
        emailReportInterval = 'weekly',
        reportingEmail = admin_email,
    } = data;

    return (
        <div className="tab-content">



            <div className="settings-header">
                <img src={`${radioPlayer.plugin_url}/assets/images/settings/statistics.svg`}/>
                <span>{wp.i18n.__('Statistics Settings', 'radio-player')}</span>
            </div>

            {/* Enable statistics */}
            <div className="setting-field">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Enable Statistics', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className="setting-field-content">
                    <div className={`input-group ${!isPro ? 'disabled pro-disabled' : ''}`}>

                        <FormToggle
                            checked={isPro && enableStats}
                            onChange={() => {

                                if (!isPro) {
                                    showProModal('Upgrade to PRO to enable statistics.');
                                    return;
                                }

                                setData(data => ({...data, enableStats: !enableStats,}))
                            }}
                        />
                    </div>

                    <p className="description">{wp.i18n.__('Enable/disable the radio players playing statistics.', 'radio-player')}</p>
                </div>
            </div>

            {/* Dashboard Widget */}
            {enableStats &&
                <div className="setting-field">
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Enable Dashboard Widget', 'radio-player')}
                        {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                    </h4>

                    <div className="setting-field-content">
                        <div className={`input-group ${!isPro ? 'disabled pro-disabled' : ''}`}>

                            <FormToggle
                                checked={isPro && !!enableDashboardWidget}
                                onChange={() => {
                                    if (!isPro) {
                                        showProModal('Upgrade to PRO to enable dashboard widget.');
                                        return;
                                    }

                                    setData(data => ({...data, enableDashboardWidget: !enableDashboardWidget}))
                                }}
                            />
                        </div>

                        <p className="description">{wp.i18n.__('Enable/disable the Dashboard statistics widget.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Email report */}
            {(enableStats || !isPro) &&
                <div className="setting-field">
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Enable Email Report', 'radio-player')}
                        {!isPro &&
                            <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                        }
                    </h4>

                    <div className="setting-field-content">
                        <div className={`input-group ${!isPro ? 'disabled pro-disabled' : ''}`}>

                            <FormToggle
                                checked={isPro && !!emailReport}
                                onChange={() => {

                                    if (!isPro) {
                                        showProModal('Upgrade to PRO to enable usage statistics.');
                                        return;
                                    }

                                    setData(data => ({...data, emailReport: !emailReport}))
                                }}
                            />
                        </div>

                        <p className="description">{wp.i18n.__('Enable/disable the statistics email reporting.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Reporting Email */}
            {((enableStats && emailReport) || !isPro) &&
                <div className="setting-field">
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Reporting Email', 'radio-player')}
                        {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                    </h4>

                    <div className="setting-field-content">
                        <div className={`input-group ${!isPro ? 'disabled pro-disabled' : ''}`}>
                            <input
                                disabled={!isPro}
                                value={reportingEmail}
                                type={'email'}
                                onChange={e => {

                                    if (!isPro) {
                                        showProModal('Upgrade to PRO to enable statistics.');
                                        return;
                                    }

                                    setData({...data, reportingEmail: e.target.value});
                                }}
                            />

                        </div>

                        <p className="description">{wp.i18n.__('Enter the email to receive the player statistics report.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Email report interval */}
            {((enableStats && emailReport) || !isPro) &&
                <div className="setting-field">
                    <h4 className={`setting-field-label`}>
                        {wp.i18n.__('Email Report Interval', 'radio-player')}
                        {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                    </h4>

                    <div className="setting-field-content">
                        <div className={`input-group ${!isPro ? 'disabled pro-disabled' : ''}`}>

                            <SelectControl
                                disabled={!isPro}
                                value={emailReportInterval}
                                options={[
                                    {label: 'Daily', value: 'daily'},
                                    {label: 'Weekly', value: 'weekly'},
                                    {label: 'Monthly', value: 'monthly'},
                                ]}
                                onChange={emailReportInterval => {

                                    if (!isPro) {
                                        showProModal('Upgrade to PRO to enable statistics.');
                                        return;
                                    }

                                    setData(data => ({...data, emailReportInterval}));
                                }}
                                __next40pxDefaultSize={true}
                                __nextHasNoMarginBottom={true}

                            />
                        </div>

                        <p className="description">{wp.i18n.__('Select the email reporting interval.', 'radio-player')}</p>
                    </div>
                </div>
            }


        </div>
    )
}