export default function ProAddonModal({addon}) {

    const addons = {
        proxy: {
            title: wp.i18n.__('Radio Player Proxy Add-on', 'radio-player'),
            description: wp.i18n.__(`Radio Player Proxy Add-on - Addon facilitates the playback of HTTP (non-SSL) radio streams on HTTPS-enabled websites. Additionally, if your website server struggles to retrieve stream data including current track title, artist and artwork, the plugin can fix display of the metadata.`, 'radio-player'),
            image: `${radioPlayer.plugin_url}/assets/images/radio-player-proxy-card.png`,
            link: 'https://softlabbd.com/radio-player-proxy/',
        },
        adsPlayer: {
            title: wp.i18n.__('Radio Player Ads - Addon', 'radio-player'),
            description: wp.i18n.__(`Enhance your online radio station with the Radio Player Ads addon, designed for seamless integration of custom audio ads, stingers, and mic-drops. Gain full control over ad placement, scheduling, and rotation to maximize listener engagement and boost revenue.`, 'radio-player'),
            image: `${radioPlayer.plugin_url}/assets/images/radio-player-ads-card.png`,
            link: 'https://softlabbd.com/radio-player-ads/',
        },
    }

    const {title, description, image, link} = addons[addon];

    return (
        <div className="pro-addon-modal">
            <div className="modal-inner">
                <h2>{title}</h2>
                <img src={image} alt={title} />
                <p>{description}</p>

                <a href={link} className="button" target={'_blank'}>
                    <i className="dashicons dashicons-download"></i>
                    {wp.i18n.__('Learn More', 'radio-player')}
                </a>

            </div>
        </div>
    )
}