import {Tooltip} from "react-tooltip";
import {showProModal} from "../../includes/functions";

const {
    RangeControl,
    FormToggle,
    ButtonGroup,
    Button,
} = wp.components;

const isPro = !!radioPlayer.isPro;

export default function PlaylistSettings({data, setData}) {

    const {
        openPlaylist = true,
        playlist_height = 'custom',
        playlist_height_custom = 300,
    } = data;

    return (
        <div className="tab-content">

            <div className="settings-header">
                <img src={`${radioPlayer.plugin_url}/assets/images/settings/playlist.svg`}/>

                <span>{wp.i18n.__('General Settings', 'radio-player')}</span>
            </div>


            {/* Open Playlist By Default */}
            <div className="setting-field">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Opened Playlist', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className={`setting-field-content `}>

                    <div className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}>
                        <FormToggle
                            checked={isPro && openPlaylist}
                            onChange={() => {

                                if (!isPro) {
                                    showProModal('Upgrade to PRO to use the station playlist.');
                                    return;
                                }

                                setData(data => ({...data, openPlaylist: !openPlaylist}))
                            }}
                        />
                    </div>

                    {!isPro &&
                        <Tooltip id="opened-playlist" className={'radio-player-tooltip'} place="right" variant="warning"
                                 effect="solid"/>}

                    <p className="description">{wp.i18n.__('Enable to keep open the station playlist by default.', 'radio-player')}</p>

                </div>
            </div>

            {/* Playlist Height */}
            <div className="setting-field">
                <h4 className={`setting-field-label`}>
                    {wp.i18n.__('Playlist Height', 'radio-player')}
                    {!isPro &&
                        <span className="radio-player-pro-icon">
                            <i className={`radio-player-icon icon-pro`}/>
                        </span>
                    }
                </h4>

                <div className={`setting-field-content `}>

                    <div className={`${!isPro ? 'disabled pro-disabled' : ''} input-group`}>

                        <ButtonGroup>
                            <Button
                                isPrimary={playlist_height === 'full'}
                                onClick={() =>
                                    setData((data) => ({...data, playlist_height: 'full'}))
                                }
                            >
                                <span>{wp.i18n.__('Full', 'radio-player')}</span>
                            </Button>
                            <Button
                                isPrimary={playlist_height === 'custom'}
                                onClick={() =>
                                    setData((data) => ({...data, playlist_height: 'custom'}))
                                }
                            >
                                <span>{wp.i18n.__('Custom', 'radio-player')}</span>
                            </Button>
                        </ButtonGroup>

                    </div>

                    <p className="description">{wp.i18n.__('Select the height of the station playlist.', 'radio-player')}</p>

                </div>
            </div>

            {/* Playlist Custom Height */}
            {'custom' === playlist_height &&
                <>
                    <div className="setting-field">
                        <h4 className={`setting-field-label`}>
                            {wp.i18n.__('Playlist Custom Height', 'radio-player')}

                            {!isPro &&
                                <span className="radio-player-pro-icon"><i className={`radio-player-icon icon-pro`}/></span>
                            }
                        </h4>

                        <div className={`setting-field-content `}>

                            <RangeControl
                                value={playlist_height_custom}
                                onChange={playlist_height_custom => setData(data => ({
                                    ...data,
                                    playlist_height_custom
                                }))}
                                min={0}
                                max={1000}
                                step={5}
                                allowReset={true}
                                resetFallbackValue={80}
                            />

                            <p className="description">{wp.i18n.__('Set the custom height of the playlist in px.', 'radio-player')}</p>
                        </div>
                    </div>
                </>
            }

        </div>
    )
}