const {Spinner} = wp.components;

export default function Header({updateSettings, isUpdating}) {
    return (
        <div className="radio-player-settings-header">
            <div className="header-title">
                <svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="22" cy="22" r="22" fill="#00BB45"/>
                    <g clipPath="url(#clip0_2140_8682)">
                        <path
                            d="M17.469 31.5165C18.5654 30.42 19.6057 29.3705 20.6646 28.3396C20.749 28.2553 20.9458 28.2553 21.0863 28.2646C23.6634 28.4708 25.8282 27.6836 27.2714 25.472C28.649 23.3634 28.724 21.1049 27.4963 18.912C26.2593 16.691 24.2726 15.604 21.7236 15.7164C17.9469 15.8757 15.2761 19.1276 15.7447 22.8855C15.7634 23.0261 15.7728 23.2322 15.6884 23.3166C14.6295 24.3755 13.5611 25.4157 12.446 26.5122C12.2304 25.9031 12.0336 25.2939 11.7993 24.7129C11.7337 24.5442 11.5557 24.3474 11.3964 24.3099C9.80323 23.9538 10.0094 23.832 10 22.4544C10 21.8921 10.0094 21.3298 10 20.7676C9.99066 20.2896 10.2062 19.9335 10.6654 19.896C11.5182 19.8398 11.8649 19.39 12.0617 18.6028C12.221 17.9655 12.5678 17.3751 12.877 16.7754C12.9989 16.5317 13.0363 16.3443 12.8864 16.0913C12.221 15.0136 12.0524 15.0136 13.1675 13.9452C13.5986 13.5329 14.011 13.1112 14.4233 12.6895C14.7607 12.3427 15.1543 12.2303 15.5479 12.5489C16.1289 13.0268 16.6443 13.0081 17.2909 12.6145C17.8907 12.249 18.6029 12.0616 19.287 11.8367C19.5401 11.7523 19.6806 11.6493 19.7275 11.3869C20.0367 9.79373 20.2054 10.0186 21.5268 10.0093C22.1078 10.0093 22.6795 10.0186 23.2605 10.0093C23.7478 9.9999 24.0852 10.2342 24.1226 10.684C24.1882 11.4993 24.5912 11.8648 25.3784 12.0522C26.0438 12.2115 26.6529 12.6239 27.2995 12.8863C27.4682 12.9519 27.7306 12.9612 27.8805 12.8769C29.052 12.1928 29.0051 12.071 30.1109 13.2049C30.5045 13.6079 30.9075 14.0015 31.3011 14.3951C31.7228 14.8261 31.7978 15.0885 31.451 15.5477C31.0106 16.1288 30.9918 16.6161 31.3854 17.2533C31.7603 17.8718 31.9196 18.6122 32.2007 19.2775C32.2757 19.4462 32.4444 19.6524 32.6037 19.6899C34.1968 20.0553 34 20.1303 34.0094 21.5829C34.0094 22.1452 34 22.7074 34.0094 23.2697C34.0188 23.7289 33.8032 24.0663 33.3628 24.1038C32.4912 24.16 32.1445 24.6379 31.9383 25.4345C31.779 26.0717 31.4229 26.6621 31.123 27.2619C31.0012 27.4962 30.9825 27.6649 31.123 27.8992C31.8165 29.0237 31.9477 28.9956 30.8325 30.0827C30.4202 30.4856 30.0172 30.9074 29.6049 31.3103C29.1832 31.7227 28.9114 31.7976 28.4522 31.4415C27.8618 30.9823 27.3745 31.0104 26.7466 31.3947C26.1375 31.7508 25.4346 31.9476 24.7505 32.1725C24.5069 32.2568 24.3569 32.3412 24.3007 32.6129C23.9821 34.2061 23.8509 33.9999 22.4639 34.0093C21.9016 34.0093 21.3394 33.9999 20.7771 34.0093C20.2991 34.0186 19.943 33.8031 19.9055 33.3439C19.8399 32.5005 19.4089 32.1069 18.6029 31.9663C18.2281 31.882 17.8813 31.6758 17.469 31.5165Z"
                            fill="white"/>
                        <path
                            d="M22.0422 17.0659C22.3983 17.1128 22.7638 17.1128 23.1011 17.2346C23.3542 17.3189 23.6728 17.5251 23.7384 17.7407C23.804 17.9562 23.654 18.3123 23.476 18.5091C23.0543 19.0058 22.5576 19.4462 22.0984 19.9148C21.4612 20.5708 21.4237 21.4236 22.0047 21.9952C22.5763 22.5763 23.4291 22.5388 24.0851 21.9015C24.5537 21.4423 24.9941 20.955 25.4908 20.5239C25.6876 20.3553 26.0437 20.1959 26.2593 20.2615C26.4748 20.3271 26.7091 20.6458 26.7653 20.8894C27.6087 24.5255 24.4225 27.6462 20.777 26.7559C20.4116 26.6622 20.2148 26.7559 19.9711 26.9995C17.9 29.08 15.829 31.1604 13.7485 33.2315C12.7833 34.1874 11.5463 34.253 10.656 33.4189C9.84069 32.6505 9.76572 31.4041 10.4967 30.5419C10.6185 30.4013 10.7497 30.2701 10.8809 30.1296C12.9332 28.0772 14.9856 26.0249 17.0472 23.9726C17.2722 23.7477 17.3284 23.5603 17.244 23.2416C16.4194 20.1022 18.7809 17.0753 22.0422 17.0659Z"
                            fill="white"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_2140_8682">
                            <rect width="24" height="24" fill="white" transform="translate(10 10)"/>
                        </clipPath>
                    </defs>
                </svg>
                <span>{wp.i18n.__('Radio Player Settings', 'radio-player')}</span>
            </div>

            <button type={"button"} className={'radio-player-btn save-settings'} onClick={updateSettings}>
                {isUpdating ? <Spinner/> : <i className="dashicons dashicons-saved"></i>}
                <span>{wp.i18n.__('Save Changes', 'radio-player')}</span>
            </button>

        </div>
    )
}