const {
    RangeControl,
    FormToggle,
    SelectControl,
    __experimentalRadio: Radio,
    __experimentalRadioGroup: RadioGroup,

} = wp.components;

export default function PlayerSettings({data, setData}) {

    const {
        resumeLocalPlayback = true,
        volume = 80,
        metadataRefreshFrequency = 60,
        metaDataTextSpeed = 10,
    } = data;

    return (
        <div className="tab-content">

            <div className="settings-header">

                <img src={`${radioPlayer.plugin_url}/assets/images/settings/general.svg`}/>

                <span>{wp.i18n.__('General Settings', 'radio-player')}</span>
            </div>

            {/* Resume Local Playback */}
            <div className="setting-field">
                <h4 className={`setting-field-label`}>{wp.i18n.__('Resume Local Playback', 'radio-player')}</h4>

                <div className={`setting-field-content `}>

                    <div className={`input-group`}>
                        <FormToggle
                            checked={resumeLocalPlayback}
                            onChange={() => {

                                setData(data => ({...data, resumeLocalPlayback: !resumeLocalPlayback}))
                            }}
                        />
                    </div>


                    <p className="description">{wp.i18n.__('Enable to resume playback from the last position when playing local audio files.', 'radio-player')}</p>

                </div>
            </div>

            {/* Metadata Refresh Frequency */}
            <div className="setting-field">
                <label>{wp.i18n.__('Metadata Refresh Frequency', 'radio-player')}</label>
                <div className="input-group">
                    <SelectControl
                        value={metadataRefreshFrequency}
                        onChange={metadataRefreshFrequency => setData(data => ({...data, metadataRefreshFrequency}))}
                        options={[
                            {label: wp.i18n.__('Never', 'radio-player'), value: 'never'},
                            {label: wp.i18n.__('30 seconds', 'radio-player'), value: 30},
                            {label: wp.i18n.__('1 minute', 'radio-player'), value: 60},
                            {label: wp.i18n.__('5 minutes', 'radio-player'), value: 120},
                            {label: wp.i18n.__('10 minutes', 'radio-player'), value: 600},
                        ]}
                        __next40pxDefaultSize={true}
                        __nextHasNoMarginBottom={true}

                    />

                    <p className="description">{wp.i18n.__('Set the frequency to refresh the metadata of the current song title.', 'radio-player')}</p>
                </div>
            </div>

            {/*--- Metadata Scrolling Speed ---*/}
            {'never' !== metadataRefreshFrequency &&
                <div className="setting-field">
                    <h4 className={`setting-field-label`}>{wp.i18n.__('Metadata Scrolling Speed', 'radio-player')}</h4>

                    <div className="input-group">

                        <RadioGroup
                            label={wp.i18n.__('Metadata Scrolling Speed', 'radio-player')}
                            checked={metaDataTextSpeed.toString()}
                            onChange={(value) => setData(data => ({...data, metaDataTextSpeed: value}))}
                            className="radio-player-radio-group"
                        >
                            <Radio value="disabled">{wp.i18n.__('Disabled', 'radio-player')}</Radio>
                            <Radio value="20">{wp.i18n.__('Slow', 'radio-player')}</Radio>
                            <Radio value="10">{wp.i18n.__('Medium', 'radio-player')}</Radio>
                            <Radio value="5">{wp.i18n.__('Fast', 'radio-player')}</Radio>
                        </RadioGroup>

                        <p className="description">{wp.i18n.__('Adjust the scrolling speed of the current song title text.', 'radio-player')}</p>
                    </div>
                </div>
            }

            {/* Default Volume */}
            <div className="setting-field">
                <label>{wp.i18n.__('Default Volume', 'radio-player')}</label>
                <div className="input-group">
                    <RangeControl
                        value={volume}
                        onChange={volume => setData(data => ({...data, volume}))}
                        min={0}
                        max={100}
                        step={5}
                        allowReset={true}
                        resetFallbackValue={80}
                        __next40pxDefaultSize={true}
                        __nextHasNoMarginBottom={true}
                    />
                    <p className="description">{wp.i18n.__('Set the default initial volume level for the radio player.', 'radio-player')}</p>
                </div>
            </div>

        </div>
    )
}